# 📦 Instrukcja Backup i Restore - Alpma OMS

## 🔄 Tworzenie Backupu

### Backup bazy danych
```bash
tsx scripts/backup-database.ts
```

To utworzy plik backup w folderze `backups/` z nazwą `backup-YYYY-MM-DD-HH-MM-SS.sql`

Backup zawiera:
- ✅ Wszystkie tabele ze schematów: commerce, catalog, allegro, shoper
- ✅ Dane użytkowników i sesji
- ✅ Konfiguracje API tokenów i webhooków
- ✅ Historie zmian i synchronizacji
- ✅ Kolejkę synchronizacji Odoo

### Backup plików projektu

#### Opcja 1: Przez interfejs Replit
1. Kliknij na folder główny projektu
2. Wybierz "Download as zip" (dostępne dla użytkowników Explorer/Staff)

#### Opcja 2: Przez Git
```bash
# Sklonuj repozytorium
git clone <url-twojego-repo>
```

#### Opcja 3: Pobierz najważniejsze pliki ręcznie
```bash
# Lista kluczowych plików do ręcznego pobrania:
- /backups/*.sql (backupy bazy danych)
- /server/*.ts (kod backendu)
- /client/src/**/*.tsx (kod frontendu)
- /shared/*.ts (współdzielone typy)
- /attached_assets/* (załączone pliki)
- /.env (zmienne środowiskowe - WAŻNE!)
```

## 🔙 Przywracanie z Backupu

### Restore bazy danych
```bash
tsx scripts/restore-database.ts backup-2025-10-14-19-30-00.sql
```

**⚠️ UWAGA:** Restore nadpisze istniejące dane!

### Restore plików
1. Zatrzymaj aplikację
2. Skopiuj pliki z backupu do odpowiednich folderów
3. Uruchom ponownie aplikację

## 📊 Lista dostępnych backupów

```bash
ls -lh backups/
```

## 🗑️ Usuwanie starych backupów

```bash
# Usuń backupy starsze niż 30 dni
find backups/ -name "backup-*.sql" -mtime +30 -delete
```

## 💾 Rekomendacje

### Częstotliwość backupów:
- 🔵 **Backup bazy danych**: Codziennie (automatyczny)
- 🟢 **Backup plików**: Co tydzień
- 🟠 **Przed dużymi zmianami**: Zawsze!

### Przechowywanie:
- Zachowaj min. 7 ostatnich backupów
- Archiwizuj miesięczne backupy na zewnętrznym dysku
- Testuj restore co miesiąc

## 🔐 Bezpieczeństwo

**NIE COMMITUJ do repozytorium:**
- ❌ Plików `.sql` z backupami (mogą zawierać dane osobowe)
- ❌ Pliku `.env` (zawiera klucze API)
- ❌ Plików z foldera `backups/`

Dodaj do `.gitignore`:
```
backups/
*.sql
.env
```

## 🆘 Automatyczny Backup (Opcjonalny)

Możesz utworzyć automatyczny backup używając:

### Cron job (na serwerze produkcyjnym):
```bash
# Dodaj do crontab
0 2 * * * cd /path/to/project && tsx scripts/backup-database.ts
```

### GitHub Actions (dla Replit):
Możesz stworzyć workflow który robi backup i uploaduje do zewnętrznego storage.

## 📞 Wsparcie

W razie problemów z backup/restore:
1. Sprawdź logi w konsoli
2. Upewnij się że masz dostęp do bazy danych
3. Zweryfikuj poprawność pliku SQL
