from odoo import _, fields, models

from ..models.market_mixin import ALLEGRO


class ResConfigSettings(models.TransientModel):
    _inherit = 'res.config.settings'

    def _x_allegro_default_account_id(self):
        return self.env['trilab.market.account'].search(
            [('market', '=', ALLEGRO), ('company_id', '=', self.env.company.id)], limit=1
        )

    x_allegro_account_id = fields.Many2one(
        'trilab.market.account', default=_x_allegro_default_account_id, ondelete='cascade'
    )

    x_allegro_state = fields.Selection(related='x_allegro_account_id.state')
    x_allegro_name = fields.Char(related='x_allegro_account_id.name', readonly=False)

    x_allegro_company_id = fields.Many2one(
        string='Allegro Company', related='x_allegro_account_id.company_id', readonly=False
    )

    x_allegro_environment = fields.Selection(related='x_allegro_account_id.allegro_environment', readonly=False)
    x_allegro_market = fields.Selection(related='x_allegro_account_id.market', readonly=False)
    x_allegro_marketplace_id = fields.Many2one(related='x_allegro_account_id.marketplace_id', readonly=False)
    x_allegro_active = fields.Boolean(related='x_allegro_account_id.active', readonly=False)
    x_allegro_user_id = fields.Many2one(
        related='x_allegro_account_id.user_id', string='Allegro Salesperson', readonly=False
    )
    x_allegro_team_id = fields.Many2one(
        related='x_allegro_account_id.team_id', string='Allegro Sales Team', readonly=False
    )
    x_allegro_order_confirm = fields.Boolean(related='x_allegro_account_id.order_confirm', readonly=False)
    x_allegro_create_missing_product = fields.Boolean(
        related='x_allegro_account_id.create_missing_product', readonly=False
    )

    x_allegro_sync_price = fields.Boolean(related='x_allegro_account_id.sync_price', readonly=False)
    x_allegro_sync_stock = fields.Boolean(related='x_allegro_account_id.sync_stock', readonly=False)
    x_allegro_qty_field = fields.Selection(related='x_allegro_account_id.qty_field', readonly=False)

    x_allegro_auto_sync_offer = fields.Boolean(related='x_allegro_account_id.auto_sync_offer', readonly=False)
    x_allegro_restock_auto_renew = fields.Boolean(
        related='x_allegro_account_id.allegro_restock_auto_renew', readonly=False
    )

    x_allegro_sync_orders = fields.Boolean(
        related='x_allegro_account_id.sync_orders', string='Allegro Sync Orders', readonly=False
    )
    x_allegro_sync_payment = fields.Boolean(related='x_allegro_account_id.sync_payment', readonly=False)
    x_allegro_sync_state = fields.Boolean(related='x_allegro_account_id.sync_state', readonly=False)
    x_allegro_send_invoice = fields.Boolean(related='x_allegro_account_id.send_invoice', readonly=False)

    x_allegro_is_company = fields.Boolean(related='x_allegro_account_id.allegro_is_company')
    x_allegro_offer_sync_date = fields.Datetime(
        related='x_allegro_account_id.offer_sync_date', string='Allegro Offer Sync Date', readonly=False
    )
    x_allegro_order_sync_date = fields.Datetime(
        related='x_allegro_account_id.order_sync_date', string='Allegro Order Sync Date', readonly=False
    )
    x_allegro_debug_logging = fields.Boolean(related='x_allegro_account_id.debug_logging', readonly=False)
    module_trilab_delivery_allegro = fields.Boolean(string='Allegro Delivery')

    def x_action_allegro_account_create_new(self):
        return {
            'view_mode': 'form',
            'view_id': self.env.ref('trilab_market_base.account_view_form').id,
            'res_model': 'trilab.market.account',
            'type': 'ir.actions.act_window',
            'target': 'new',
            'res_id': False,
            'context': {
                'default_market': ALLEGRO,
                'default_marketplace_id': self.env.ref('trilab_allegro.marketplace_pl').id,
                'x_open_modal': True,
            },
        }

    def x_allegro_action_account_unlink(self):
        self.x_allegro_account_id.unlink()

    def x_allegro_action_pair(self):
        self.ensure_one()
        pair_request_id = self.env['trilab.allegro.pair'].create(
            [
                {
                    'state': 'already_paired' if self.x_allegro_account_id.allegro_access_token else 'init',
                    'account_id': self.x_allegro_account_id.id,
                }
            ]
        )

        if not self.x_allegro_account_id.allegro_access_token:
            pair_request_id.get_pair_data()

        return {
            'view_mode': 'form',
            'name': _('Pair with Allegro user account'),
            'res_model': 'trilab.allegro.pair',
            'type': 'ir.actions.act_window',
            'target': 'new',
            'res_id': pair_request_id.id,
        }

    def x_allegro_action_settings(self):
        self.ensure_one()
        return {
            'name': _('Account Settings'),
            'domain': [('account_id', 'in', self.x_allegro_account_id.ids)],
            'view_mode': 'list',
            'res_model': 'trilab.market.settings',
            'type': 'ir.actions.act_window',
            'context': {'default_account_id': self.x_allegro_account_id.id},
        }

    def x_allegro_action_payment_terms(self):
        self.ensure_one()
        self.x_allegro_account_id.ensure_one()

        return {
            'name': _('Payment Terms'),
            'domain': [('account_id', '=', self.x_allegro_account_id.id)],
            'view_mode': 'list',
            'views': [(self.env.ref('trilab_allegro.payment_terms_view_list').id, 'list')],
            'res_model': 'trilab.market.payment_terms',
            'type': 'ir.actions.act_window',
            'context': {'default_account_id': self.x_allegro_account_id.id},
        }
