import logging

_logger = logging.getLogger(__name__)

MAPPING_ACCOUNT_PARAMS = {
    'user_id': 'allegro_seller_id',
    'team_id': 'allegro_sales_team',
}

MAPPING_FISCAL_PARAMS = {
    'allegro-cz': 'allegro-cz_fp_id',
    'allegro-business-cz': 'allegro-cz_fp_id',
    'allegro-pl': 'allegro-pl_fp_id',
    'allegro-sk': 'allegro-sk_fp_id',
}

REMOVE_KEYS = (
    'allegro_environment',
    'allegro_user_code',
    'allegro_user_access_token',
    'allegro_user_access_token_validity',
    'allegro_user_refresh_token',
    'allegro_last_event_id',
    'allegro_sales_team',
    'allegro_cash_on_delivery_payment_term_id',
    'allegro_wire_transfer_payment_term_id',
    'allegro_online_payment_term_id',
    'allegro_split_payment_payment_term_id',
    'allegro-cz_fp_id',
    'allegro-pl_fp_id',
    'allegro-sk_fp_id',
    'allegro_seller_id',
    'allegro_sale_auto_confirm',
    'allegro_sale_payment',
    'trilab_allegro.debug',
    'trilab_allegro.date_from',
    'allegro_client_id_prod',
    'allegro_client_id_sand',
    'allegro_client_secret_prod',
    'allegro_client_secret_sand',
)


# noinspection SqlWithoutWhere
def migrate(cr, version):
    _logger.info(f'end migration start (from {version})')

    # update default account
    _logger.info('update params for default account')

    cr.execute(
        """
        UPDATE trilab_allegro_account 
        SET last_order_date = COALESCE((
        SELECT MAX(date_order) 
        FROM sale_order 
        WHERE origin LIKE 'allegro%'
        ), CURRENT_TIMESTAMP)    
        """
    )

    # create fiscal positions mapping
    for marketplace_name, fiscal_key in MAPPING_FISCAL_PARAMS.items():
        cr.execute('SELECT value FROM ir_config_parameter WHERE key = %s', (fiscal_key,))

        if fiscal_position_id := cr.fetchone():
            fiscal_position_id = int(fiscal_position_id[0])
            _logger.info(f"found fiscal position with id '{fiscal_position_id}' for key '{fiscal_key}'")

            cr.execute('SELECT id FROM trilab_allegro_marketplace WHERE name = %s', (marketplace_name,))
            if marketplace_id := cr.fetchone():
                _logger.info(
                    f"insert fiscal position with id '{fiscal_position_id}' for '{marketplace_name}' marketplace"
                )

                cr.execute(
                    """
                    INSERT INTO trilab_allegro_account_settings (marketplace_id, fiscal_position_id, account_id)
                    VALUES (%s, %s, %s)
                    """,
                    (marketplace_id[0], fiscal_position_id, 1),
                )

    # remove the keys from ir_config_parameter
    for remove_key in REMOVE_KEYS:
        _logger.info(f"remove key '{remove_key}' if exist")
        cr.execute('DELETE FROM ir_config_parameter WHERE key = %s', (remove_key,))

    # remove old action server and cron
    _logger.info('remove old cron and action server')
    cr.execute("DELETE FROM ir_cron WHERE cron_name = 'allegro: get new orders'")
    cr.execute("DELETE FROM ir_act_server WHERE name ->> 'en_US' = 'allegro: get new orders'")

    _logger.info('end migration finished')
