-- ========================================
-- KROK 1: SCHEMATY I TABELE
-- ========================================

-- Utwórz schematy
CREATE SCHEMA IF NOT EXISTS allegro;
CREATE SCHEMA IF NOT EXISTS shoper;
CREATE SCHEMA IF NOT EXISTS commerce;

-- Tabela allegro.orders
CREATE TABLE IF NOT EXISTS allegro.orders (
    id SERIAL PRIMARY KEY,
    order_id VARCHAR(255) UNIQUE NOT NULL,
    marketplace VARCHAR(50),
    seller_status VARCHAR(50),
    seller_login VARCHAR(255),
    buyer_login VARCHAR(255),
    buyer_name VARCHAR(255),
    buyer_email VARCHAR(255),
    buyer_company VARCHAR(255),
    buyer_phone VARCHAR(50),
    buyer_address VARCHAR(500),
    buyer_zip VARCHAR(20),
    buyer_city VARCHAR(100),
    buyer_country_code VARCHAR(10),
    order_date TIMESTAMP,
    payment_id VARCHAR(255),
    payment_status VARCHAR(50),
    payment_type VARCHAR(50),
    payment_provider VARCHAR(100),
    payment_amount NUMERIC(10, 2),
    payment_currency VARCHAR(10),
    delivery_method VARCHAR(255),
    delivery_amount NUMERIC(10, 2),
    delivery_currency VARCHAR(10),
    total_to_pay_amount NUMERIC(10, 2),
    total_to_pay_currency VARCHAR(10),
    buyer_notes TEXT,
    invoice_required BOOLEAN DEFAULT false,
    smart BOOLEAN DEFAULT false,
    allegro_pay BOOLEAN DEFAULT false,
    tracking_numbers TEXT[] DEFAULT '{}',
    created_at TIMESTAMP DEFAULT NOW(),
    updated_at TIMESTAMP DEFAULT NOW()
);

-- Tabela allegro.order_items
CREATE TABLE IF NOT EXISTS allegro.order_items (
    id SERIAL PRIMARY KEY,
    order_id VARCHAR(255) REFERENCES allegro.orders(order_id) ON DELETE CASCADE,
    offer_id VARCHAR(255),
    offer_name VARCHAR(500),
    quantity INTEGER,
    unit_price NUMERIC(10, 2),
    total_price NUMERIC(10, 2),
    external_id VARCHAR(255),
    created_at TIMESTAMP DEFAULT NOW()
);

-- Tabela allegro.products
CREATE TABLE IF NOT EXISTS allegro.products (
    id SERIAL PRIMARY KEY,
    offer_id VARCHAR(255) UNIQUE NOT NULL,
    name VARCHAR(500),
    category_id VARCHAR(255),
    price NUMERIC(10, 2),
    stock INTEGER,
    ean VARCHAR(50),
    created_at TIMESTAMP DEFAULT NOW(),
    updated_at TIMESTAMP DEFAULT NOW()
);

-- Tabela allegro.sync_logs
CREATE TABLE IF NOT EXISTS allegro.sync_logs (
    id SERIAL PRIMARY KEY,
    sync_type VARCHAR(50),
    status VARCHAR(50),
    message TEXT,
    created_at TIMESTAMP DEFAULT NOW()
);

-- Tabela shoper.orders
CREATE TABLE IF NOT EXISTS shoper.orders (
    id SERIAL PRIMARY KEY,
    shoper_order_id VARCHAR(255) UNIQUE NOT NULL,
    order_date TIMESTAMP,
    buyer_login VARCHAR(255),
    buyer_email VARCHAR(255),
    total_amount NUMERIC(10, 2),
    currency VARCHAR(10),
    payment_status VARCHAR(50),
    fulfillment_status VARCHAR(50),
    raw_data JSONB,
    created_at TIMESTAMP DEFAULT NOW(),
    updated_at TIMESTAMP DEFAULT NOW()
);

-- Tabela commerce.orders (BEZ order_code - zostanie dodane w step2)
CREATE TABLE IF NOT EXISTS commerce.orders (
    id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
    order_number INTEGER,
    source VARCHAR(20) NOT NULL,
    source_order_id VARCHAR(255) NOT NULL,
    order_date TIMESTAMP,
    status VARCHAR(50),
    buyer_login VARCHAR(255),
    buyer_email VARCHAR(255),
    buyer_company VARCHAR(255),
    buyer_first_name VARCHAR(255),
    buyer_last_name VARCHAR(255),
    buyer_phone VARCHAR(50),
    buyer_address VARCHAR(500),
    buyer_zip VARCHAR(20),
    buyer_city VARCHAR(100),
    buyer_country_code VARCHAR(10),
    payment_id VARCHAR(255),
    payment_status VARCHAR(50),
    payment_type VARCHAR(50),
    payment_provider VARCHAR(100),
    payment_amount NUMERIC(10, 2),
    payment_currency VARCHAR(10),
    delivery_method VARCHAR(255),
    delivery_amount NUMERIC(10, 2),
    delivery_currency VARCHAR(10),
    total_to_pay_amount NUMERIC(10, 2),
    total_to_pay_currency VARCHAR(10),
    buyer_notes TEXT,
    invoice_required BOOLEAN DEFAULT false,
    tracking_numbers TEXT[] DEFAULT '{}',
    raw_payload JSONB,
    created_at TIMESTAMP DEFAULT NOW(),
    updated_at TIMESTAMP DEFAULT NOW(),
    UNIQUE(source_order_id, source)
);

-- Dodaj order_code TYLKO jeśli tabela już istnieje i kolumna nie istnieje
DO $$ 
BEGIN
    IF EXISTS (SELECT 1 FROM information_schema.tables WHERE table_schema = 'commerce' AND table_name = 'orders') THEN
        IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_schema = 'commerce' AND table_name = 'orders' AND column_name = 'order_code') THEN
            ALTER TABLE commerce.orders ADD COLUMN order_code VARCHAR(20) GENERATED ALWAYS AS ('ORD-' || LPAD(order_number::TEXT, 6, '0')) STORED;
        END IF;
    END IF;
END $$;

-- Tabela sync_settings
CREATE TABLE IF NOT EXISTS sync_settings (
    id SERIAL PRIMARY KEY,
    platform VARCHAR(50) UNIQUE NOT NULL,
    last_sync_date TIMESTAMP,
    created_at TIMESTAMP DEFAULT NOW(),
    updated_at TIMESTAMP DEFAULT NOW()
);

-- Tabela allegro_connections
CREATE TABLE IF NOT EXISTS allegro_connections (
    id SERIAL PRIMARY KEY,
    access_token TEXT,
    refresh_token TEXT,
    expires_at TIMESTAMP,
    created_at TIMESTAMP DEFAULT NOW(),
    updated_at TIMESTAMP DEFAULT NOW()
);

-- Sekwencja dla numerów zamówień
CREATE SEQUENCE IF NOT EXISTS commerce.order_number_seq START 1000;

-- ✅ KROK 1 ZAKOŃCZONY - Teraz uruchom production-step2-triggers.sql
