# Alpma OMS - Zarządzanie Zamówieniami

## Overview
Alpma OMS (Order Management System) is a professional web application designed to manage orders from Allegro and Shoper platforms. It automatically fetches orders, verifies payment statuses, and synchronizes data. The project aims to provide a unified platform for e-commerce order management, capable of integrating with other business systems like Odoo. Key capabilities include comprehensive order management, real-time synchronization, secure API for external systems, robust user authentication, and detailed statistics.

## User Preferences
- Język: Polski (wszystkie UI teksty)
- Motyw domyślny: Dark mode
- OAuth flow: Przekierowanie na stronę Allegro (jak w module Odoo)
- Częstotliwość synchronizacji: Co kilka minut (konfigurowalne: 1, 3, 5, 10 min)

## System Architecture

### UI/UX Decisions
- **Frontend Framework**: React 18 with Vite.
- **UI Components**: Shadcn UI built on Radix UI, styled with Tailwind CSS.
- **Theming**: Supports Dark/Light mode.
- **Navigation**: Wouter for client-side routing.
- **Data Display**: Dashboard with key metrics and a detailed, sortable orders table with visual badges for payment/fulfillment statuses and progress bars.

### Technical Implementations
- **Backend**: Express.js with TypeScript.
- **Data Fetching & State Management**: TanStack Query v5.
- **Form Handling**: React Hook Form with Zod validation.
- **Date Handling**: `date-fns`.
- **Icons**: Lucide React.
- **Charting**: Recharts for interactive data visualization.
- **Order Numeration**: Native PostgreSQL SERIAL autoincrement for chronological order numbering (e.g., AL-1, SH-2).
- **Server-side Sorting & Pagination**: Implemented for optimal performance.
- **Incremental Synchronization**: Uses `updated_at` timestamps to fetch only modified orders.
- **Dual-Layer Persistence**: Raw platform data stored and then normalized into a unified `commerce.orders` table.
- **Image Handling**: Product image URLs extracted and stored for direct access.
- **Error Handling**: Robust logging and non-blocking synchronization.
- **Statistics Calculation**: All statistics calculated in PostgreSQL.
- **Payment Data Mapping**: Accurate tracking of paid amounts and handling of zero values.
- **Payment & Delivery Methods**: Fetches dictionaries from Shoper API for descriptive names.
- **Customer Returns & Refunds**: Tracks product returns (using Allegro's BETA API) and payment refunds with dedicated database fields and UI indicators.
- **Smart Search**: Supports full order codes (AL-917) and numeric order numbers (917).
- **Order Change History**: Displays change history on order detail page and sends it to Odoo as notes during UPDATE operations.
    - **Duplicate Prevention**: 5-minute lookback window prevents duplicate change entries for the same field
    - **RETURNING Clause Validation**: Verifies actual saved values after UPDATE operations to ensure data accuracy
- **Authentication**: Complete username/password authentication with PostgreSQL, Passport.js (scrypt hashing), session management (express-session, connect-pg-simple), and CSRF protection.
- **Authorization**: Role-based access control (admin/manager/user) with `requirePermission` middleware and frontend permission checks.
- **External Integration**: REST API and Webhook system for Odoo/External Systems integration.
    - **REST API**: Endpoints for orders, products, with Bearer token authentication (SHA256-hashed tokens, audit logging).
    - **Webhooks**: Real-time push notifications for order events (`order.created`, `order.updated`, `order.paid`, `order.shipped`) with retry logic and HMAC-SHA256 signature verification.

### Feature Specifications
- **OAuth Integration**: Secure OAuth 2.0 connection with Allegro.
- **Automated Synchronization**: Configurable cyclic synchronization for Allegro and Shoper.
- **Dashboard & Order Table**: Overview of orders, revenue, with filtering, searching, and sorting.
- **Statistics Chart**: Interactive line chart for daily orders, paid orders, and revenue trends.
- **Configuration Panel**: Centralized settings for OAuth, synchronization, and connections.
- **Historia Zmian (Change History)**: Unified page with 3 tabs consolidating order tracking:
  - **Wykryte zmiany** (Detected Changes): Detailed field-level change tracking
  - **Ostatnie aktualizacje** (Recent Updates): Orders modified in last sync
  - **Logi synchronizacji** (Sync Logs): Technical synchronization history
- **User Management**: Admin-only user management page with CRUD operations for users, roles, and permissions.
- **API Token Management**: Admin-only CRUD for API tokens with audit logs.
- **Webhook Management**: Admin-only CRUD for webhook configurations and delivery logs.

### System Design Choices
- **Unified Schema**: `commerce` schema for consolidated orders, `catalog` for shared product info.
- **Modularity**: Separated `client`, `server`, and `shared` types.
- **Scalability**: Designed for integration with Odoo.

## External Dependencies
- **Database**: PostgreSQL (Replit) with schemas: `commerce`, `catalog`, `allegro`, `shoper`, `api_tokens`, `webhook_configs`, `api_request_logs`, `webhook_logs`, `users`, `sessions`, `password_reset_tokens`.
- **E-commerce Platforms**:
    - **Allegro API**: OAuth authorization, order synchronization, customer returns (BETA API), payments/refunds.
    - **Shoper API**: Order synchronization, product details.
- **Odoo Integration**: Direct integration via Cloudflare Tunnel with dual-mode synchronization.
    - **Connection**: Odoo v18/19 at http://100.99.76.111:8070/odoo (database: amdecor) exposed via Cloudflare Tunnel at https://synchronizacja.alpma.app/odoo
    - **Synchronization**: 
        - Real-time: Orders automatically synced when created/updated via queue system
        - Scheduled: Background sync every 1 minute as backup (configurable)
        - Smart operation detection: Automatically determines CREATE vs UPDATE based on existing Odoo order ID
    - **Queue System**: Retry logic with max 3 attempts, comprehensive error logging
    - **Data Mapping**: 
        - Customers: name, email, phone, address from buyer data
        - Products: Consumable type (consu) with name, quantity, price from order_items
        - Dates: ISO 8601 to Odoo format (YYYY-MM-DD HH:MM:SS) conversion
    - **Technical Details**:
        - Column mapping: snake_case database → camelCase TypeScript
        - Product data: Uses offer_name and unit_price from commerce.order_items
        - Delivery: Maps delivery_amount to deliveryPrice
        - Odoo Order ID tracking: commerce.orders.odoo_order_id stores Odoo sale.order ID for reference
        - Duplicate prevention: findOrCreatePartner() searches by email, findOrCreateProduct() searches by name
        - Partner/Product reuse: System searches existing Odoo records before creating new ones to prevent duplicates