# -*- coding: utf-8 -*-
{
    'name': 'Shoper Integration',
    'version': '18.0.1.2.0',
    'category': 'Sales',
    'summary': 'Advanced Shoper integration with full order tracking, change history and updated_at field support',
    'description': """
        Shoper Integration Module - Advanced Edition
        ============================================
        
        Complete integration with Shoper e-commerce platform featuring:
        
        🚀 Version 1.2.0 - Major Update
        ===============================
        * **NEW**: Full order synchronization with shoper_updated_at field
        * **NEW**: Complete change history tracking
        * **NEW**: Advanced sync wizard with multiple modes
        * **NEW**: Detailed logging system with separate change logs
        * **NEW**: Order status badges and visual indicators
        * **NEW**: Kanban and graph views for order analytics
        * **NEW**: Automatic partner (customer) creation
        * **NEW**: Tracking number support
        * **NEW**: Bulk operations and batch processing
        
        Key Features:
        ------------
        ✅ Order Synchronization
        * Import orders from Shoper with full data
        * Track changes with shoper_updated_at field (date_edit from API)
        * Incremental updates - only sync changed orders
        * Batch processing for performance
        
        ✅ Change Tracking
        * Complete history of all order changes
        * Track status changes, payments, shipping updates
        * Detailed change logs with timestamps
        * Visual indicators for recent changes
        
        ✅ Synchronization Modes
        * New Orders - import only new orders
        * Recent Updates - update changed orders
        * Full Sync - complete synchronization
        * Custom Range - sync specific date range
        
        ✅ Analytics & Reporting
        * Dashboard with order statistics
        * Graph views for sales analysis
        * Pivot tables for detailed reports
        * Kanban board for order management
        
        ✅ Automation
        * Scheduled synchronization (configurable)
        * Automatic partner creation
        * Optional sale.order creation
        * Email notifications for important changes
        
        Configuration:
        -------------
        1. Settings > Sales > Shoper Configuration
        2. Enter API credentials
        3. Configure sync preferences
        4. Enable automatic sync if needed
        
        Usage:
        ------
        1. Shoper > Sync Orders - manual synchronization
        2. Shoper > Orders Sync - view synchronized orders
        3. Shoper > Changes History - track all changes
        4. Use filters and groups for analysis
        
        Technical Details:
        -----------------
        * Models: shoper.order.sync, shoper.order.change
        * Updated_at field mapped from Shoper's date_edit
        * Comprehensive logging to sync_orders_detailed.log
        * Change tracking to order_changes_detailed.log
        
        Version History:
        ---------------
        v1.2.0 - Complete rewrite with advanced features
        v1.1.1 - Fixed order products endpoint
        v1.1.0 - Added payment tracking
        v1.0.0 - Initial release
        
        See CHANGELOG.md for detailed changes
    """,
    'author': 'Alpma sp. z o.o.',
    'website': 'https://www.alpmeb.pl',
    'license': 'LGPL-3',
    'depends': [
        'base',
        'sale_management',
        'stock',
        'account',
        'mail',
    ],
    'data': [
        'security/ir.model.access.csv',
        'views/shoper_config_views.xml',
        'views/sale_order_views.xml',
        'views/shoper_order_sync_views.xml',
        'views/shoper_sync_wizard_views.xml',
        'views/shoper_menu.xml',
        'data/ir_cron.xml',
    ],
    'assets': {
        'web.assets_backend': [
            # Możemy dodać własne style CSS jeśli potrzebne
        ],
    },
    'demo': [],
    'installable': True,
    'application': True,
    'auto_install': False,
    'sequence': 10,
}
