# Upgrade Guide - Version 1.1.0

## 🎯 What's New in 1.1.0

Version 1.1.0 fixes critical issues with incremental synchronization and adds proper order update detection.

### Key Improvements

✅ **Fixed Incremental Sync** - Now properly uses `updated_at` field from Shoper API  
✅ **Change Detection** - Detects actual changes in orders (status, payment, etc.)  
✅ **Payment Tracking** - New `shoper_paid` field for better payment status visibility  
✅ **Enhanced Logging** - Detailed sync summary showing what changed  
✅ **Better Performance** - Commits every 20 orders, skip unchanged orders  

---

## 📋 Pre-Upgrade Checklist

Before upgrading, ensure you have:

- [ ] **Backup of your Odoo database**
- [ ] **Access to Odoo Apps menu** (Admin rights)
- [ ] **Access to server files** (if manual installation)
- [ ] **Noted current statistics** (check Shoper > Configuration)

---

## 🚀 Upgrade Steps

### Option 1: Via Odoo Apps (Recommended)

1. **Backup Database**
   ```bash
   # Create database backup
   pg_dump -h localhost -U odoo -d your_database > backup_before_1.1.0.sql
   ```

2. **Update Module Files**
   ```bash
   cd /path/to/odoo/addons/odoo_shoper_integration
   git pull  # if using git
   # or copy new files manually
   ```

3. **Restart Odoo**
   ```bash
   sudo systemctl restart odoo
   # or
   sudo service odoo restart
   ```

4. **Upgrade Module**
   - Go to **Apps** menu
   - Remove "Apps" filter
   - Search for "Shoper Integration"
   - Click **Upgrade**
   - Wait for upgrade to complete

5. **Verify Upgrade**
   - Go to **Shoper > Configuration**
   - Check that new fields are visible:
     - `Total Orders Updated`
     - `Last Update Count`
   - Go to **Shoper > Orders**
   - Open any order, go to "Shoper Info" tab
   - Verify `Shoper Paid` field is visible

### Option 2: Via Command Line

1. **Backup Database**
   ```bash
   pg_dump -h localhost -U odoo -d your_database > backup_before_1.1.0.sql
   ```

2. **Update Module Files**
   ```bash
   cd /path/to/odoo/addons/
   # If using git:
   cd odoo_shoper_integration && git pull && cd ..
   # Or copy new files
   ```

3. **Upgrade Module**
   ```bash
   odoo-bin -c /etc/odoo/odoo.conf -u odoo_shoper_integration -d your_database --stop-after-init
   ```

4. **Restart Odoo**
   ```bash
   sudo systemctl restart odoo
   ```

---

## ✅ Post-Upgrade Verification

### 1. Check Module Version

Go to **Apps > Shoper Integration** and verify version is **18.0.1.1.0**

### 2. Verify New Fields

**In Configuration (Shoper > Configuration):**
- [ ] `Total Orders Updated` field exists
- [ ] `Last Update Count` field exists
- [ ] `Last Order Update` field shows last sync date

**In Orders (Shoper > Orders):**
- [ ] `Shoper Paid` field visible in tree view
- [ ] `Shoper Paid` field visible in form view (Shoper Info tab)
- [ ] Filters "Paid (Shoper)" and "Unpaid (Shoper)" available

### 3. Test Synchronization

**Run Manual Sync:**
1. Go to **Shoper > Configuration**
2. Click **Synchronize Orders Now**
3. Check notification message - should show sync mode (INCREMENTAL/FULL/etc.)
4. Review logs for sync summary

**Expected Log Output:**
```
================================================================================
STARTING ORDER SYNCHRONIZATION: https://yourshop.pl
================================================================================
Mode: INCREMENTAL
Fetching orders updated since: 2025-10-02 10:00:00
Orders matching filters: 5
Fetched 5 orders from Shoper API
✓ Updated order #12345 (Odoo: SO0123)
○ No changes for order #12346
...
================================================================================
SYNCHRONIZATION SUMMARY
================================================================================
Mode: INCREMENTAL
New orders imported: 2
Existing orders updated: 3
Orders unchanged: 1
Errors: 0
Latest update date: 2025-10-02 12:30:00
================================================================================
```

### 4. Test Change Detection

**To verify change detection works:**

1. In Shoper admin, change status of an order
2. In Odoo, run **Synchronize Orders Now**
3. Check that:
   - Order was detected as changed
   - Status updated in Odoo
   - Change logged in order chatter
   - Statistics updated

### 5. Verify Incremental Sync

**Check that incremental sync is working:**

1. Note the `Last Order Update` date in Configuration
2. Wait a few minutes or modify an order in Shoper
3. Run sync again
4. Verify:
   - Only changed orders were processed
   - `Last Order Update` was updated to latest date
   - Log shows "Mode: INCREMENTAL"

---

## 🔧 Troubleshooting

### Issue: "Module not found" after upgrade

**Solution:**
```bash
# Update apps list
# In Odoo: Apps > Update Apps List
# Or command line:
odoo-bin -c /etc/odoo/odoo.conf -d your_database --update odoo_shoper_integration
```

### Issue: New fields not visible

**Solution:**
1. Clear browser cache (Ctrl+Shift+R)
2. Restart Odoo server
3. Re-upgrade module:
   ```bash
   odoo-bin -c /etc/odoo/odoo.conf -u odoo_shoper_integration -d your_database --stop-after-init
   ```

### Issue: "Programming Error" about missing columns

**Solution:**
The upgrade should automatically add columns. If not:
```sql
-- Run in PostgreSQL:
ALTER TABLE sale_order ADD COLUMN IF NOT EXISTS shoper_paid BOOLEAN;
ALTER TABLE shoper_config ADD COLUMN IF NOT EXISTS total_orders_updated INTEGER DEFAULT 0;
ALTER TABLE shoper_config ADD COLUMN IF NOT EXISTS last_update_count INTEGER DEFAULT 0;

-- Update existing records
UPDATE sale_order SET shoper_paid = false WHERE shoper_paid IS NULL AND is_shoper_order = true;
UPDATE shoper_config SET total_orders_updated = 0 WHERE total_orders_updated IS NULL;
UPDATE shoper_config SET last_update_count = 0 WHERE last_update_count IS NULL;
```

### Issue: Sync showing "FULL_ALL" mode instead of "INCREMENTAL"

**Cause:** `last_order_update` field is empty

**Solution:**
This is normal for first sync after upgrade. The sync will populate `last_order_update` and subsequent syncs will be incremental.

### Issue: No orders detected in sync

**Possible causes:**
1. No orders changed since last sync (normal)
2. Shoper API connectivity issue (check logs)
3. Filter settings too restrictive (check `import_from_date`)

**Check:**
```bash
# View Odoo logs:
tail -f /var/log/odoo/odoo.log | grep -i shoper
```

---

## 📊 Rollback Procedure (If Needed)

If you encounter critical issues:

### 1. Stop Odoo
```bash
sudo systemctl stop odoo
```

### 2. Restore Database Backup
```bash
# Drop current database
dropdb -h localhost -U odoo your_database

# Restore backup
createdb -h localhost -U odoo your_database
psql -h localhost -U odoo -d your_database < backup_before_1.1.0.sql
```

### 3. Restore Old Module Files
```bash
cd /path/to/odoo/addons/odoo_shoper_integration
git checkout v1.0.0  # if using git
# or restore from backup
```

### 4. Restart Odoo
```bash
sudo systemctl start odoo
```

---

## 🔄 Migration Notes

### Data Migration

**No data loss** - all existing data is preserved:
- All orders remain intact
- `last_order_update` date preserved
- Customer and product data unchanged
- Order history maintained

### Behavior Changes

**Before 1.1.0:**
- Incremental sync didn't work properly
- All orders re-checked on each sync
- No change detection
- Less detailed logging

**After 1.1.0:**
- Proper incremental sync
- Only changed orders processed
- Change detection with chatter updates
- Detailed sync mode logging
- Better performance

### API Changes

**No breaking changes for users** - all existing functionality maintained.

**For developers:**
- `update_from_shoper()` now returns boolean
- API client filter format changed (internal)
- New sync modes added (internal)

---

## 📞 Support

If you encounter issues during upgrade:

1. **Check logs** - Most issues are logged
2. **Review this guide** - Common issues covered
3. **Check CHANGELOG.md** - Technical details
4. **Contact support** - Provide logs and error messages

---

## ✨ What's Next?

After successful upgrade:

1. **Monitor first few syncs** - Check logs
2. **Verify statistics** - Should match expectations
3. **Enable automatic sync** - If satisfied with results
4. **Enjoy improved sync** - Less API calls, better detection!

---

**Happy upgrading! 🚀**

Module version: 1.1.0  
Date: 2025-10-02
