# 🔍 Problem: "No orders returned from API"

## Szybka Diagnoza

### 📋 Możliwe Przyczyny:

1. **Filtry blokują zamówienia**
2. **Brak zamówień w Shoper**
3. **Problem z datami w konfiguracji**
4. **Błędny token API**

---

## ✅ Krok po Kroku - Sprawdź To:

### Krok 1: Sprawdź Konfigurację w Odoo

Przejdź do: **Shoper → Configuration**

#### Sprawdź te pola:

| Pole | Co Sprawdzić | Jak Naprawić |
|------|--------------|--------------|
| **Shop URL** | Czy zawiera `https://` | Dodaj https:// |
| **API Access Token** | Czy jest aktualny | Wygeneruj nowy w Shoper |
| **Active** | Czy jest zaznaczone | Zaznacz checkbox |
| **Import From Date** | ⚠️ **TO CZĘSTO BLOKUJE!** | Pozostaw PUSTE lub ustaw starą datę |
| **Last Order Update** | Kiedy było | Jeśli w przyszłości - wyczyść pole |
| **Max Orders Per Sync** | Czy > 0 | Ustaw na 50-100 |

### ⚠️ NAJWAŻNIEJSZE: Import From Date

**Problem:**
```
Import From Date: 2025-10-05 10:00:00
↓
Odoo importuje TYLKO zamówienia NOWSZE niż ta data
↓
Jeśli wszystkie zamówienia są STARSZE - wynik: "No orders"
```

**Rozwiązanie:**
1. Otwórz konfigurację
2. **Usuń datę** z pola "Import From Date"
3. Lub ustaw starą datę (np. 2024-01-01)
4. Zapisz
5. Uruchom sync ponownie

---

### Krok 2: Test Połączenia

W konfiguracji kliknij: **"Test Connection"**

**Oczekiwany wynik:**
```
✅ Successfully connected to https://alpmeb.pl
   Total orders in shop: 234
```

**Jeśli błąd:**
- Sprawdź URL (https://)
- Sprawdź token (wygeneruj nowy)
- Sprawdź internet

---

### Krok 3: Sprawdź Logi Odoo

#### Windows/Docker:
```bash
docker-compose logs odoo-web | grep -i "shoper" | tail -50
```

#### Linux:
```bash
tail -f /var/log/odoo/odoo.log | grep -i "shoper"
```

**Szukaj w logach:**

✅ **Dobre znaki:**
```
Total orders matching filters: 234
Fetched 50 orders from Shoper API
Added order 12345 (updated: ..., 5 products)
```

❌ **Złe znaki:**
```
Total orders matching filters: 0
No orders returned from API
Shoper API error 401: Unauthorized
Shoper API error 404: Not Found
```

---

### Krok 4: Uruchom Diagnostykę API

Użyj skryptu testowego:

```bash
cd C:\AlpSys\data\odoo\addons\odoo_shoper_integration
python test_shoper_api.py
```

**Przed uruchomieniem:**
1. Otwórz `test_shoper_api.py`
2. Uzupełnij:
   ```python
   SHOP_URL = "https://alpmeb.pl"
   ACCESS_TOKEN = "twój_token_tutaj"
   ```
3. Zapisz i uruchom

Skrypt sprawdzi:
- ✅ Połączenie z API
- ✅ Liczbę zamówień w sklepie
- ✅ Ostatnie zamówienia
- ✅ Zamówienia z filtrami dat
- ✅ Produkty zamówień

---

## 🎯 Najczęstsze Rozwiązania

### Rozwiązanie 1: Wyczyść Import From Date

```
Shoper → Configuration
├─ Import From Date: [USUŃ DATĘ]
└─ Zapisz
```

### Rozwiązanie 2: Wyczyść Last Order Update

W PostgreSQL (jeśli wiesz jak):
```sql
UPDATE shoper_config 
SET last_order_update = NULL 
WHERE active = true;
```

Lub przez Odoo (Developer mode):
1. Włącz tryb developer
2. Shoper → Configuration
3. Edytuj rekord
4. Wyczyść pole "Last Order Update"
5. Zapisz

### Rozwiązanie 3: Zmień Tryb Synchronizacji

Zmień strategię sync:
```
Max Orders Per Sync: 100
Import From Date: [puste] lub stara data
```

Odoo automatycznie wybierze tryb:
- **FULL_ALL** - jeśli oba pola puste (importuje wszystko)
- **FULL_FROM_DATE** - jeśli jest Import From Date
- **INCREMENTAL** - jeśli jest Last Order Update

---

## 🔬 Zaawansowana Diagnostyka

### Sprawdź Bazę Danych

```sql
-- Ile zamówień jest już w Odoo?
SELECT COUNT(*) FROM sale_order WHERE is_shoper_order = true;

-- Jakie są daty ostatnich zamówień?
SELECT 
    shoper_order_id,
    shoper_date,
    shoper_updated_at
FROM sale_order 
WHERE is_shoper_order = true
ORDER BY shoper_updated_at DESC
LIMIT 10;

-- Sprawdź konfigurację
SELECT 
    shop_url,
    import_from_date,
    last_order_update,
    max_orders_per_sync,
    total_orders_imported
FROM shoper_config
WHERE active = true;
```

---

## 🆘 Jeśli Nic Nie Pomaga

### Debug Mode - Włącz Szczegółowe Logi

1. Edytuj `models/shoper_config.py`
2. W metodzie `action_sync_orders()` dodaj na początku:
   ```python
   import logging
   logging.getLogger('odoo.addons.odoo_shoper_integration').setLevel(logging.DEBUG)
   ```
3. Zrestartuj Odoo
4. Uruchom sync
5. Sprawdź logi - będą bardzo szczegółowe

### Sprawdź Bezpośrednio API

**Test 1: Całkowita liczba zamówień**
```bash
curl -H "Authorization: Bearer TWÓJ_TOKEN" \
     "https://alpmeb.pl/webapi/rest/orders?limit=1"
```

Odpowiedź powinna zawierać:
```json
{
  "count": 234,
  "pages": 1,
  "page": 1,
  "list": [...]
}
```

**Test 2: Zamówienia z datą**
```bash
curl -H "Authorization: Bearer TWÓJ_TOKEN" \
     "https://alpmeb.pl/webapi/rest/orders?limit=10&date[>=]=2024-01-01"
```

---

## 📊 Checklist Diagnostyczny

Przejdź przez tę listę:

- [ ] **Test Connection** w Odoo działa
- [ ] Widzę liczbę zamówień w Test Connection
- [ ] **Import From Date** jest PUSTE lub stare
- [ ] **Last Order Update** nie jest w przyszłości
- [ ] **Max Orders Per Sync** >= 50
- [ ] **Active** checkbox jest zaznaczony
- [ ] Token API jest świeży (nie wygasł)
- [ ] URL zawiera `https://`
- [ ] W logach NIE MA błędów 401/403/404
- [ ] Skrypt testowy pokazuje zamówienia
- [ ] W Shoper faktycznie SĄ zamówienia

---

## 💡 Przykładowa Dobra Konfiguracja

```
Shop URL: https://alpmeb.pl
API Access Token: a1b2c3d4e5f6... (aktualny)
Active: ✓ (zaznaczone)

Max Orders Per Sync: 100
Import From Date: [PUSTE] ← WAŻNE!
Default Order State: draft

Last Synchronization: 2025-10-05 10:00:00
Last Order Update: [może być puste lub stara data]
```

Po takiej konfiguracji:
- Pierwszy sync: FULL_ALL (importuje wszystkie)
- Kolejne synce: INCREMENTAL (tylko zmienione)

---

## 🎯 Najczęstszy Błąd

**90% przypadków:**
```
Import From Date: [jakaś przyszła lub niedawna data]
↓
Wszystkie zamówienia są starsze
↓
Wynik: "No orders returned from API"
```

**Rozwiązanie:**
```
Import From Date: [USUŃ]
↓
Sync → FULL_ALL mode
↓
Wynik: Wszystkie zamówienia zaimportowane ✓
```

---

## 📞 Co Mi Dać Do Pomocy

Jeśli problem pozostaje, prześlij:

1. **Screenshot konfiguracji** (Shoper → Configuration)
2. **Logi z synchronizacji** (ostatnie 50 linii)
3. **Wynik Test Connection**
4. **Wynik skryptu test_shoper_api.py**

To pozwoli mi dokładnie zdiagnozować problem!

---

**TL;DR: W 90% przypadków problem to Import From Date - po prostu wyczyść to pole!**
