# Testing Guide - Shoper Integration v1.1.0

## 🧪 Testing Checklist

Use this guide to verify that version 1.1.0 works correctly after installation/upgrade.

---

## ✅ Pre-Testing Setup

Before testing, ensure:
- [ ] Module installed/upgraded successfully
- [ ] Shoper API credentials configured
- [ ] Test connection passed
- [ ] At least 5-10 orders exist in Shoper

---

## 🎯 Test Cases

### Test 1: Module Installation

**Objective:** Verify module is properly installed

**Steps:**
1. Go to **Apps**
2. Remove "Apps" filter
3. Search "Shoper Integration"
4. Check module status

**Expected Results:**
- [x] Module shows as "Installed"
- [x] Version shows: 18.0.1.1.0
- [x] No error messages

---

### Test 2: Configuration

**Objective:** Verify configuration UI works

**Steps:**
1. Go to **Shoper > Configuration**
2. Create or edit configuration
3. Check all fields are visible

**Expected Results:**
- [x] All connection fields visible (Shop URL, Token)
- [x] All sync settings visible (Interval, Max Orders, etc.)
- [x] All statistics visible (Last Sync, Total Imported, etc.)
- [x] New fields visible: `total_orders_updated`, `last_update_count`
- [x] Help text present and clear

---

### Test 3: Connection Test

**Objective:** Verify API connection works

**Steps:**
1. Go to **Shoper > Configuration**
2. Enter valid Shop URL and Token
3. Click **Test Connection**

**Expected Results:**
- [x] Green notification: "Connection Successful"
- [x] Shows total orders in shop
- [x] No errors in log

**If Fails:**
- Check Shop URL format (must include https://)
- Verify token is correct
- Check network connectivity
- Review logs: `tail -f /var/log/odoo/odoo.log | grep -i shoper`

---

### Test 4: First Sync (FULL)

**Objective:** Test initial order import

**Steps:**
1. In Configuration, set `Import From Date` to 30 days ago (optional)
2. Click **Synchronize Orders Now**
3. Wait for completion (30-60 seconds)
4. Check notification message

**Expected Results:**
- [x] Notification shows: "Mode: FULL_ALL" or "Mode: FULL_FROM_DATE"
- [x] Shows count of imported orders
- [x] No critical errors
- [x] `last_order_update` field is now populated
- [x] `Total Orders Imported` increased

**Verify in Orders:**
1. Go to **Shoper > Orders**
2. Check orders are present
3. Open one order, go to "Shoper Info" tab

**Expected:**
- [x] Orders visible in list
- [x] `Shoper Order ID` visible
- [x] `Shoper Paid` field visible (boolean)
- [x] All Shoper fields populated
- [x] Raw data present

**Check Logs:**
```bash
tail -100 /var/log/odoo/odoo.log | grep -i "SYNCHRONIZATION SUMMARY" -A 10
```

**Expected Log:**
```
================================================================================
SYNCHRONIZATION SUMMARY
================================================================================
Mode: FULL_ALL (or FULL_FROM_DATE)
New orders imported: X
Existing orders updated: 0
Orders unchanged: 0
Errors: 0
Latest update date: YYYY-MM-DD HH:MM:SS
================================================================================
```

---

### Test 5: Incremental Sync (No Changes)

**Objective:** Test incremental sync when nothing changed

**Steps:**
1. Wait 5 minutes after first sync
2. **DO NOT** change anything in Shoper
3. Click **Synchronize Orders Now** again
4. Check notification

**Expected Results:**
- [x] Notification shows: "Mode: INCREMENTAL"
- [x] Shows: "New orders: 0, Updated: 0, Unchanged: X"
- [x] Fast completion (1-5 seconds)
- [x] `last_order_update` unchanged or slightly updated

**Check Logs:**
```bash
tail -100 /var/log/odoo/odoo.log | grep -i "INCREMENTAL" -A 20
```

**Expected Log:**
```
Mode: INCREMENTAL
Fetching orders updated since: YYYY-MM-DD HH:MM:SS
Orders matching filters: X
...
○ No changes for order #XXX
○ No changes for order #YYY
...
New orders imported: 0
Existing orders updated: 0
Orders unchanged: X
```

---

### Test 6: Order Update Detection

**Objective:** Test change detection

**Steps:**
1. In Shoper admin, find an existing order
2. Change its status (e.g., from "new" to "processing")
3. Wait 1 minute
4. In Odoo, click **Synchronize Orders Now**
5. Check notification and logs

**Expected Results:**
- [x] Notification shows: "Mode: INCREMENTAL"
- [x] Shows: "Updated orders: 1" (or more if multiple changed)
- [x] Fast completion
- [x] `last_order_update` updated

**Verify Order:**
1. Go to **Shoper > Orders**
2. Find the order you changed
3. Check status is updated
4. Open order, check "Shoper Info" tab
5. Check order chatter (Activity/Messages)

**Expected:**
- [x] Order status updated in Odoo
- [x] `Shoper Status Name` changed
- [x] `Shoper Updated At` changed
- [x] Message in chatter: "Shoper order updated: status: X → Y"

**Check Logs:**
```
✓ Updated order #XXXXX (Odoo: SO0XXX): status: new → processing
```

---

### Test 7: Payment Status Change

**Objective:** Test payment status tracking

**Steps:**
1. In Shoper, find an unpaid order
2. Mark it as paid
3. In Odoo, sync orders
4. Check order

**Expected Results:**
- [x] Order shows `shoper_paid = True`
- [x] Change logged in chatter
- [x] Filter "Paid (Shoper)" finds the order

---

### Test 8: New Order Creation

**Objective:** Test importing new orders

**Steps:**
1. In Shoper, create a new test order
2. Wait 1 minute
3. In Odoo, sync orders
4. Check order was imported

**Expected Results:**
- [x] Notification shows: "New orders: 1"
- [x] Order appears in **Shoper > Orders**
- [x] Customer created/matched
- [x] Products created/matched
- [x] All fields populated correctly

---

### Test 9: Filters and Search

**Objective:** Test UI filters work

**Steps:**
1. Go to **Shoper > Orders**
2. Try each filter:
   - "Shoper Orders"
   - "Manual Orders"
   - "Paid (Shoper)"
   - "Unpaid (Shoper)"

**Expected Results:**
- [x] "Shoper Orders" shows only Shoper orders
- [x] "Manual Orders" shows only non-Shoper orders
- [x] "Paid (Shoper)" shows only paid Shoper orders
- [x] "Unpaid (Shoper)" shows only unpaid Shoper orders

---

### Test 10: Automatic Sync (Cron)

**Objective:** Test scheduled synchronization

**Steps:**
1. In Configuration, enable **Automatic Synchronization**
2. Set interval to 1 hour
3. Wait for cron to run (check next scheduled time)
4. Check logs after cron runs

**Expected Results:**
- [x] Cron runs automatically
- [x] Orders synchronized
- [x] No errors in logs

**Check Cron:**
1. Go to **Settings > Technical > Automation > Scheduled Actions**
2. Find "Shoper: Synchronize Orders"
3. Check **Last Run** date
4. Check **Next Run** date

---

### Test 11: Statistics Accuracy

**Objective:** Verify statistics are correct

**Steps:**
1. Note statistics before sync
2. Run sync
3. Check statistics after

**Expected Results:**
- [x] `Last Sync Date` updated to current time
- [x] `Last Import Count` matches notification
- [x] `Last Update Count` matches notification
- [x] `Total Orders Imported` increased by new orders
- [x] `Total Orders Updated` increased by updated orders

---

### Test 12: Error Handling

**Objective:** Test error handling

**Test A: Invalid Token**
1. Enter invalid API token
2. Try to sync

**Expected:**
- [x] Error message: "Synchronization failed"
- [x] Detailed error in logs
- [x] No crash

**Test B: Network Issue**
1. Disconnect from internet (if testing locally)
2. Try to sync

**Expected:**
- [x] Error message about connection
- [x] Graceful failure
- [x] Can retry after reconnecting

**Test C: Malformed Data**
- Automatically handled by try-except blocks
- Check logs for warnings

---

### Test 13: Multi-Company (if applicable)

**Objective:** Test multi-company isolation

**Steps:**
1. Create second company
2. Switch to second company
3. Try to see orders from first company

**Expected Results:**
- [x] Orders isolated by company
- [x] Each company has own configuration
- [x] No cross-company data leakage

---

### Test 14: Performance

**Objective:** Measure sync performance

**Test A: First Sync**
1. Clear all orders
2. Sync 100 orders
3. Measure time

**Expected:**
- Time: 30-90 seconds
- No timeout errors

**Test B: Incremental Sync (no changes)**
1. Sync again immediately
2. Measure time

**Expected:**
- Time: 1-5 seconds (much faster!)
- Log shows: "Orders unchanged: X"

**Test C: Incremental Sync (with changes)**
1. Change 5 orders in Shoper
2. Sync
3. Measure time

**Expected:**
- Time: 5-15 seconds
- Only 5 orders processed

---

## 📊 Test Summary Template

```
TEST RESULTS - Shoper Integration v1.1.0
Date: __________
Tester: __________
Environment: __________

┌─────────────────────────────────────────┬─────────┬──────────┐
│ Test Case                               │ Status  │ Notes    │
├─────────────────────────────────────────┼─────────┼──────────┤
│ 1. Module Installation                  │ ☐ PASS  │          │
│ 2. Configuration                        │ ☐ PASS  │          │
│ 3. Connection Test                      │ ☐ PASS  │          │
│ 4. First Sync (FULL)                    │ ☐ PASS  │          │
│ 5. Incremental Sync (No Changes)        │ ☐ PASS  │          │
│ 6. Order Update Detection               │ ☐ PASS  │          │
│ 7. Payment Status Change                │ ☐ PASS  │          │
│ 8. New Order Creation                   │ ☐ PASS  │          │
│ 9. Filters and Search                   │ ☐ PASS  │          │
│ 10. Automatic Sync (Cron)               │ ☐ PASS  │          │
│ 11. Statistics Accuracy                 │ ☐ PASS  │          │
│ 12. Error Handling                      │ ☐ PASS  │          │
│ 13. Multi-Company                       │ ☐ PASS  │          │
│ 14. Performance                         │ ☐ PASS  │          │
└─────────────────────────────────────────┴─────────┴──────────┘

Overall Result: ☐ PASS  ☐ FAIL

Issues Found:
1. _______________________________________________________________
2. _______________________________________________________________
3. _______________________________________________________________

Performance Metrics:
- First sync time: _______ seconds
- Incremental sync time: _______ seconds
- Orders imported: _______
- Orders updated: _______

Recommendations:
________________________________________________________________
________________________________________________________________
________________________________________________________________
```

---

## 🐛 Common Issues

### Issue: Sync shows FULL_ALL instead of INCREMENTAL

**Cause:** First sync after install/upgrade

**Solution:** This is expected. Run sync once, then subsequent syncs will be INCREMENTAL.

### Issue: Orders not updating

**Cause:** Order not actually changed in Shoper, or `updated_at` not changed

**Solution:**
- Verify order was modified in Shoper
- Check `updated_at` field in Shoper
- Wait 1 minute after changing order

### Issue: Slow sync

**Cause:** Many orders changed, or network issues

**Solution:**
- Check network speed
- Reduce `max_orders_per_sync`
- Check Shoper API limits

---

## ✅ Success Criteria

Module passes testing if:
- [x] All test cases pass
- [x] No critical errors in logs
- [x] Incremental sync works correctly
- [x] Change detection works
- [x] Performance is acceptable
- [x] Statistics are accurate

---

## 📝 Reporting Issues

If you find bugs:

1. **Check logs first**
   ```bash
   tail -500 /var/log/odoo/odoo.log | grep -i shoper > shoper_issue.log
   ```

2. **Document the issue**
   - What you did
   - What you expected
   - What actually happened
   - Error messages
   - Log excerpts

3. **Contact support**
   - Provide logs
   - Describe steps to reproduce
   - Include configuration details

---

**Happy testing! 🧪**
