# Shoper Integration v1.1.1 🔥 CRITICAL HOTFIX

**Urgent Update Required** - Critical bug fix for order products import

---

## 🚨 What's Fixed

### Critical Bug: Orders Importing Without Products

**Problem:**
- Orders were importing to Odoo **without product lines**
- API was using non-existent endpoint: `orders/{id}/products`
- Result: Empty order lines, incomplete data

**Solution:**
- Fixed API endpoint to use correct `order-products` with filter
- Orders now import **with full product information**
- Verified against official Shoper API documentation

---

## 🔧 Quick Fix Guide

### 1. Stop Odoo
```bash
docker-compose stop odoo-web
# or
sudo systemctl stop odoo
```

### 2. Update Module
```bash
cd /path/to/odoo/addons/odoo_shoper_integration
# Copy new files or git pull
```

### 3. Start Odoo
```bash
docker-compose start odoo-web
# or
sudo systemctl start odoo
```

### 4. Upgrade in Odoo
```
Apps → Search "Shoper Integration" → Upgrade
```

### 5. Test
```
Shoper → Configuration → "Synchronize Orders Now"
```

---

## ✅ Verification

After update, orders should import with products:

**Before (v1.1.0):**
```
Order SO0001
├─ Customer: John Doe
├─ Total: $100.00
└─ ❌ Order Lines: EMPTY
```

**After (v1.1.1):**
```
Order SO0001
├─ Customer: John Doe
├─ Total: $100.00
└─ ✅ Order Lines:
    ├─ Product A × 2 = $50.00
    ├─ Product B × 1 = $40.00
    └─ Delivery      = $10.00
```

---

## 📋 Technical Changes

### File Changed
- `models/shoper_api_client.py`

### Method Fixed
- `get_order_products(order_id)`

### Endpoint Corrected

❌ **OLD (Incorrect):**
```python
GET /webapi/rest/orders/12345/products
# Does not exist in Shoper API!
```

✅ **NEW (Correct):**
```python
GET /webapi/rest/order-products?filters={"order_id":12345}
# Official Shoper API endpoint
```

---

## 🔄 Existing Orders

### Will old orders be fixed automatically?
**No** - orders imported with v1.1.0 will remain without products.

### How to fix old orders?
**Option 1:** Delete and re-import
1. Delete orders in Odoo
2. Run synchronization again

**Option 2:** Manual product addition
1. Open order in Odoo
2. Add products manually from order lines

---

## 📖 Documentation

- **Full Changelog**: [CHANGELOG.md](CHANGELOG.md)
- **Detailed Fix Guide**: [HOTFIX_v1.1.1.md](HOTFIX_v1.1.1.md)
- **Main README**: [README.md](README.md)

---

## 🆘 Support

### Still having issues?

1. **Check logs:**
   ```bash
   tail -f /var/log/odoo/odoo.log | grep -i "shoper\|product"
   ```

2. **Test API manually:**
   ```bash
   curl -H "Authorization: Bearer YOUR_TOKEN" \
        "https://alpmeb.pl/webapi/rest/order-products?limit=1"
   ```

3. **Verify version:**
   ```
   Apps → Shoper Integration
   Should show: Version 18.0.1.1.1
   ```

---

## ⚡ Changelog Summary

### [1.1.1] - 2025-10-05
- 🔥 **FIXED**: Order products endpoint (critical)
- ✅ Orders now import WITH products
- 📝 Enhanced logging for debugging

### [1.1.0] - 2025-10-02
- ✅ Fixed incremental sync
- ✅ Added change detection
- ✅ Payment status tracking

### [1.0.0] - 2025-01-15
- 🎉 Initial release

---

## 🎯 Priority: CRITICAL

**This is a critical bug fix that prevents proper order import.**

**Action Required:**
- ⚠️ Update immediately
- ⚠️ Test after update
- ⚠️ Monitor first few syncs

---

**Status:** ✅ Fixed in v1.1.1  
**Impact:** Critical - Orders import properly now  
**Compatibility:** Backward compatible  
**Database Migration:** Not required  

**Update today to ensure proper order synchronization!**
