# Quick Start Guide - Shoper Integration for Odoo 18

Get started with Shoper integration in 5 minutes!

## Prerequisites Checklist

- ✅ Odoo 18 installed and running
- ✅ Shoper shop with active paid plan
- ✅ API access enabled in Shoper
- ✅ Admin access to both Odoo and Shoper

## Step 1: Get Shoper API Token (2 minutes)

1. Login to your **Shoper admin panel**
2. Navigate to **Settings → API** (or **Ustawienia → API**)
3. Click **"Generate new token"** button
4. **Copy** the generated token - it looks like:
   ```
   8178507ff9b80d67a10fd27bec40567a6d417b28b6e5255063b9f9830eb5d2df
   ```
5. Save it somewhere safe (you'll need it in Step 3)

**Important:** Keep this token secure! It provides full API access to your shop.

## Step 2: Install Module (1 minute)

### Option A: Automatic Installation (Recommended)

```bash
cd /path/to/odoo_shoper_integration
chmod +x install.sh
./install.sh
```

Follow the prompts. The script will:
- Find your Odoo installation
- Copy module files
- Install dependencies
- Set permissions
- Restart Odoo

### Option B: Manual Installation

```bash
# Copy module
cp -r odoo_shoper_integration /path/to/odoo/addons/

# Install dependencies
pip3 install requests

# Restart Odoo
sudo systemctl restart odoo
```

## Step 3: Activate Module (1 minute)

1. Open **Odoo**
2. Go to **Apps** menu
3. Click **"Update Apps List"** (top-right)
4. Wait for update to complete
5. Remove **"Apps"** filter
6. Search for **"Shoper"**
7. Click **"Install"** on Shoper Integration

Wait for installation to complete...

## Step 4: Configure API Connection (1 minute)

1. After installation, go to **Shoper → Configuration**
   (or **Sales → Configuration → Shoper API**)

2. Click **"Create"** button

3. Fill in the form:
   ```
   Shop URL: https://yourshop.pl
   API Access Token: [paste token from Step 1]
   Active: ✓ (checked)
   ```

4. Click **"Save"**

5. Click **"Test Connection"** button

   ✅ Success: "Connected successfully" message
   ❌ Error: Check URL format and token

## Step 5: First Synchronization (Under 1 minute)

### Quick Test (Last 7 Days)

1. In the configuration form, set:
   ```
   Import From Date: [7 days ago]
   Max Orders Per Sync: 25
   Default Order State: Quotation
   ```

2. Click **"Synchronize Orders Now"** button

3. Wait for notification: "Synchronization completed"

4. Go to **Shoper → Orders** to see imported orders

### View Your First Orders

1. Click **Shoper → Orders** in menu
2. You should see orders imported from Shoper
3. Open any order to see:
   - Customer information
   - Products and quantities
   - Shoper status
   - Raw data (in Shoper Info tab)

## You're Done! 🎉

Your Shoper integration is now working!

---

## Next Steps

### Enable Automatic Synchronization

1. Go back to **Shoper → Configuration**
2. Open your configuration
3. Check **"Enable Automatic Synchronization"**
4. Set **"Synchronization Interval"**: `1` hour (recommended)
5. Set **"Max Orders Per Sync"**: `50` (recommended)
6. Click **"Save"**

Now orders will sync automatically every hour!

### Import All Historical Orders

1. Open configuration
2. **Remove** the "Import From Date" value (leave empty)
3. Set **"Max Orders Per Sync"**: `100`
4. Click **"Synchronize Orders Now"**
5. Wait (may take a few minutes)
6. Repeat if needed (for very large order history)

### Customize Settings

1. **Default Order State**: Choose initial state for orders
   - `Quotation` - Review before confirming
   - `Sales Order` - Auto-confirmed
   
2. **Sync Interval**: Adjust based on your needs
   - High volume: Every 30-60 minutes
   - Medium volume: Every 1-2 hours
   - Low volume: Every 4-6 hours

---

## Common First-Time Issues

### ❌ "Connection test failed"

**Fix:**
- Check URL includes `https://` 
- Regenerate API token in Shoper
- Verify API is enabled in your Shoper plan

### ❌ "No orders imported"

**Fix:**
- Check if orders exist in date range
- Remove "Import From Date" to import all
- Verify orders aren't already imported

### ❌ Products are duplicated

**Fix:**
- Update product codes in Odoo to match Shoper
- Pre-create products before import
- Module matches by: Code → EAN → Name

### ❌ Customers are duplicated

**Fix:**
- Manually merge duplicates (Odoo feature)
- Ensure email addresses are consistent
- Module matches by: Email → Phone

---

## Quick Reference Card

### Manual Sync
```
Shoper → Configuration → Open config → "Synchronize Orders Now"
```

### View Orders
```
Shoper → Orders
or
Sales → Orders → Filter: "Shoper Orders"
```

### Check Statistics
```
Shoper → Configuration → Open config
See: Last Sync Date, Total Imported, etc.
```

### Find Order by Shoper ID
```
Sales → Orders → Search: "Shoper Order ID" = [number]
```

---

## Verification Checklist

After setup, verify:

- [ ] Configuration is Active
- [ ] Test connection succeeds
- [ ] At least one order imported
- [ ] Customer data looks correct
- [ ] Products are properly matched
- [ ] Delivery costs are included
- [ ] Automatic sync is enabled (if desired)

---

## Getting Help

**Documentation:**
- Full guide: README.md
- Examples: EXAMPLES.md  
- FAQ: FAQ.md
- Technical: ARCHITECTURE.md

**Logs:**
```bash
tail -f /var/log/odoo/odoo.log | grep -i shoper
```

**Support:**
- Check Odoo logs for errors
- Review FAQ for common issues
- Contact your Odoo partner

---

## What's Next?

Once basic sync works:

1. ✅ Review imported data quality
2. ✅ Map products to existing catalog
3. ✅ Merge duplicate customers
4. ✅ Configure automatic sync
5. ✅ Set up order processing workflow
6. ✅ Train team on Shoper orders
7. ✅ Monitor sync regularly

---

## Tips for Success

### Start Small
Import last 7-30 days first, then expand

### Monitor Closely
Check logs and statistics for first week

### Clean Data
Review and fix issues early

### Use Incremental Sync
Let the system handle updates automatically

### Regular Backups
Backup database before major changes

### Test First
Use staging environment for testing

---

## Congratulations! 🎊

You've successfully set up Shoper integration!

Your orders will now flow automatically from Shoper to Odoo.

For more advanced features and customization, check out:
- EXAMPLES.md - Code examples
- ARCHITECTURE.md - Technical details
- FAQ.md - Common questions

**Happy selling!** 🚀
