# Shoper Integration Module - Quick Start Guide

## Installation Steps

### 1. Prerequisites

- Odoo 18 installed and running
- Python 3.10 or higher
- Access to Shoper admin panel
- API access enabled in Shoper

### 2. Install Module

```bash
# Copy module to addons directory
cp -r odoo_shoper_integration /path/to/odoo/addons/

# Install dependencies
pip install -r /path/to/odoo/addons/odoo_shoper_integration/requirements.txt

# Restart Odoo
sudo systemctl restart odoo
```

### 3. Activate in Odoo

1. Go to **Apps** menu
2. Remove "Apps" filter
3. Search for "Shoper Integration"
4. Click **Install**

### 4. Configure API Access

#### In Shoper:

1. Login to Shoper admin panel
2. Go to **Settings** → **API**
3. Click **Generate new token**
4. Copy the generated token
5. Note: Token format is long alphanumeric string (e.g., `8178507ff9b80d67a10fd27bec40567a6d417b28b6e5255063b9f9830eb5d2df`)

#### In Odoo:

1. Go to **Shoper** → **Configuration**
2. Click **Create**
3. Fill in:
   - **Shop URL**: `https://yourshop.pl` (your actual Shoper URL)
   - **API Access Token**: Paste token from Shoper
   - **Active**: ✓ Check
4. Click **Save**
5. Click **Test Connection** to verify

### 5. Configure Synchronization

#### For Manual Sync:

Leave **Enable Automatic Synchronization** unchecked and use "Synchronize Orders Now" button when needed.

#### For Automatic Sync:

1. Check **Enable Automatic Synchronization**
2. Set **Synchronization Interval**: e.g., `1` hour
3. Set **Max Orders Per Sync**: e.g., `100`
4. Optionally set **Import From Date** to limit initial import
5. Choose **Default Order State**: e.g., `Quotation`
6. Click **Save**

### 6. First Synchronization

1. Open your configuration record
2. Click **Synchronize Orders Now**
3. Wait for completion (notification will appear)
4. Go to **Shoper** → **Orders** to see imported orders

## Configuration Options Explained

### Shop URL
Full URL of your Shoper shop, including `https://`

Example: `https://alpmeb.pl`

### API Access Token
Bearer token from Shoper API settings. This is a long string that looks like:
`8178507ff9b80d67a10fd27bec40567a6d417b28b6e5255063b9f9830eb5d2df`

### Enable Automatic Synchronization
When enabled, orders will be synchronized automatically according to the interval.

### Synchronization Interval (hours)
How often the cron job runs to fetch new orders.

Recommended: 1-4 hours depending on order volume.

### Max Orders Per Sync
Maximum number of orders to import in one synchronization run.

Recommended: 50-100 to avoid timeouts.

### Import From Date
Optional. If set, only orders created after this date will be imported.

Useful for:
- Initial setup (skip old orders)
- Testing (import recent orders only)
- Migration scenarios

### Default Order State
The initial state assigned to imported orders in Odoo:
- **Quotation** (draft): Imported orders need confirmation
- **Sales Order** (sale): Imported orders are immediately confirmed
- **Quotation Sent** (sent): Imported orders marked as sent

Recommended: **Quotation** to review before confirming.

## First Run Tips

### Start with Recent Orders

On first sync, set **Import From Date** to recent date (e.g., last 7 days) to test with smaller dataset.

### Check Product Mapping

After first import:
1. Review created products
2. Map Shoper products to existing Odoo products if needed
3. Update product codes/EAN to improve future matching

### Verify Customer Data

Check imported customers:
1. Look for duplicates
2. Merge similar customers if needed
3. Correct any address issues

### Monitor Logs

Check Odoo logs for any warnings or errors:
```bash
tail -f /var/log/odoo/odoo.log | grep -i shoper
```

## Common Issues

### "Connection test failed"
- Verify Shop URL is correct (include `https://`)
- Check API token is valid
- Ensure API access is enabled in Shoper
- Check network connectivity

### "No orders imported"
- Check **Import From Date** isn't filtering all orders
- Verify orders exist in Shoper for the date range
- Check if orders were already imported (check by Shoper Order ID)

### Products not matching
- Products are matched in order: Code → EAN → Name
- If no match, new product is created
- Update product codes in Odoo to match Shoper codes
- Use Product Templates to pre-create products

### Performance issues
- Reduce **Max Orders Per Sync**
- Increase **Synchronization Interval**
- Import in smaller batches
- Use **Import From Date** to limit scope

## Maintenance

### Regular Tasks

1. **Monitor sync status**: Check last sync date and import count
2. **Review logs**: Look for errors or warnings
3. **Update mappings**: Improve product/customer matching
4. **Clean up**: Remove test orders if needed

### Troubleshooting Commands

```python
# In Odoo shell
env = api.Environment(cr, uid, {})

# Get active config
config = env['shoper.config'].search([('active', '=', True)], limit=1)

# Check last sync
print(config.last_sync_date)
print(config.total_orders_imported)

# Manual sync
config.action_sync_orders()

# Check existing orders
orders = env['sale.order'].search([('is_shoper_order', '=', True)])
print(f"Total Shoper orders: {len(orders)}")
```

## API Rate Limits

Shoper API has rate limits:
- Be cautious with frequent syncs
- Use incremental sync (it's automatic)
- Don't set sync interval below 15 minutes
- Monitor API usage in Shoper panel

## Next Steps

After successful installation:

1. ✅ Test with small order batch
2. ✅ Verify product mapping
3. ✅ Check customer data
4. ✅ Configure automatic sync
5. ✅ Train users on Shoper orders view
6. ✅ Set up order processing workflow
7. ✅ Document any custom mappings

## Support

For technical support:
- Check module logs
- Review API documentation
- Contact your Odoo partner
- Check Shoper API status

## Updates

When updating the module:
1. Backup your database
2. Update module files
3. Go to Apps → Update Apps List
4. Search for "Shoper Integration"
5. Click **Upgrade**
6. Test synchronization after upgrade
