# Frequently Asked Questions (FAQ)

## General Questions

### Q: What is this module for?
**A:** This module integrates Odoo 18 with Shoper e-commerce platform, automatically importing orders from Shoper to Odoo for unified order management.

### Q: Do I need a paid Shoper account?
**A:** Yes, API access typically requires a paid Shoper plan. Check with Shoper for specific plan requirements.

### Q: Does this work with Odoo Community or Enterprise?
**A:** Both. The module is compatible with Odoo 18 Community and Enterprise editions.

### Q: Can I use this with multiple Shoper shops?
**A:** Yes, create multiple configurations (one per shop). Each shop will have its own settings.

---

## Installation

### Q: How do I install the module?
**A:** 
1. Copy module to Odoo addons directory
2. Run `pip install -r requirements.txt`
3. Restart Odoo
4. Go to Apps → Update Apps List
5. Search "Shoper Integration" → Install

See INSTALL.md for detailed steps.

### Q: I get "Module not found" error
**A:** 
- Ensure module is in correct addons path
- Check addons_path in odoo.conf
- Update apps list in Odoo
- Restart Odoo service

### Q: Installation script fails
**A:** 
- Run with proper permissions (sudo if needed)
- Check Python version (requires 3.10+)
- Verify Odoo installation path
- Install manually if script fails

---

## Configuration

### Q: Where do I get the API token?
**A:** 
1. Log in to Shoper admin panel
2. Go to Settings → API
3. Click "Generate new token"
4. Copy the token (long alphanumeric string)

### Q: What's the correct Shop URL format?
**A:** Include `https://` and your shop domain:
- ✅ Correct: `https://yourshop.pl`
- ❌ Wrong: `yourshop.pl` or `www.yourshop.pl`

### Q: Test connection fails - what to check?
**A:**
1. Shop URL format (include https://)
2. API token validity (regenerate if needed)
3. API access enabled in Shoper plan
4. Network connectivity from Odoo server
5. Firewall not blocking requests

### Q: Can I import orders from a specific date?
**A:** Yes, set "Import From Date" in configuration. This skips older orders.

### Q: What's the difference between manual and automatic sync?
**A:**
- **Manual**: Click "Synchronize Orders Now" button when needed
- **Automatic**: Runs on schedule (configurable interval)

Both use incremental sync (only new/updated orders).

---

## Synchronization

### Q: How does incremental sync work?
**A:** 
- First sync imports all orders (or from specified date)
- Subsequent syncs only import orders changed since last sync
- Uses Shoper's `updated_at` field automatically
- No duplicates, efficient syncing

### Q: How often should I sync?
**A:** 
- Low volume: Every 4-6 hours
- Medium volume: Every 1-2 hours  
- High volume: Every 30-60 minutes
- **Never** less than 15 minutes (API rate limits)

### Q: Orders aren't importing - why?
**A:** Check:
1. Configuration is Active
2. "Import From Date" isn't blocking orders
3. Orders exist in Shoper for that period
4. API token is valid
5. Check Odoo logs for errors

### Q: Can I import historical orders?
**A:** Yes:
1. Leave "Import From Date" empty, OR
2. Set it to earliest date you want
3. Increase "Max Orders Per Sync" if needed
4. Run manual sync

### Q: I see "No orders imported" message
**A:** 
- All orders might already be imported (check by Shoper ID)
- Date filters might be excluding orders
- Orders might not exist in Shoper
- Check if orders meet import criteria

### Q: Can I re-import an order?
**A:** No, each Shoper order ID can only exist once. To re-import:
1. Delete the order in Odoo
2. Run sync again

---

## Products

### Q: How are products matched?
**A:** Priority order:
1. By product code (SKU) - exact match
2. By EAN barcode - exact match
3. By name - exact match
4. If no match: creates new product

### Q: Products are being duplicated
**A:** 
- Update product codes in Odoo to match Shoper codes
- Or pre-create products before import
- Use product templates for common products

### Q: Can I map Shoper products to existing Odoo products?
**A:** Yes:
1. Update Odoo product's "Internal Reference" to match Shoper code
2. Or update "Barcode" to match Shoper EAN
3. Next sync will match automatically

### Q: What if a product doesn't exist in Odoo?
**A:** Module automatically creates it with:
- Name from Shoper
- Code/SKU from Shoper
- EAN from Shoper
- Price from Shoper

You can edit after import.

---

## Customers

### Q: How are customers matched?
**A:**
1. By email - first priority
2. By phone - second priority
3. If no match: creates new customer

### Q: Customer duplicates are being created
**A:** 
- Check if emails are consistent
- Manually merge duplicates in Odoo
- Update customer data to improve matching

### Q: Can I map to existing customers?
**A:** Yes, ensure email or phone matches in Odoo.

### Q: What customer data is imported?
**A:**
- Name
- Email
- Phone
- Address (street, city, zip, country)
- Company name (if B2B)
- VAT number (if provided)

---

## Orders

### Q: What data is imported from each order?
**A:**
- Order details (date, totals, status)
- Customer information
- Products and quantities
- Prices and discounts
- Delivery method and cost
- Payment method
- Order notes

### Q: Are delivery costs included?
**A:** Yes, added as separate order line with delivery method name.

### Q: What about payment information?
**A:** Payment method name is stored, but payment status must be managed in Odoo.

### Q: Can I edit imported orders?
**A:** Yes, but:
- Changes in Odoo won't sync back to Shoper
- Re-sync will update Shoper status/data

### Q: What's the default order state?
**A:** Configurable in settings. Common options:
- **Quotation** (draft): Review before confirming
- **Sales Order** (sale): Auto-confirmed
- **Quotation Sent**: Marked as sent

### Q: Can I see raw Shoper data?
**A:** Yes, in order's "Shoper Info" tab → "Raw Data" field (JSON format).

---

## Status Synchronization

### Q: Are order statuses synced from Shoper?
**A:** Yes, Shoper status is stored in order:
- `shoper_status_id`: Status ID
- `shoper_status_name`: Status name

### Q: Do Odoo order statuses sync back to Shoper?
**A:** Not in current version. This is planned for future release.

### Q: How do I handle status changes?
**A:** 
- Update order state in Odoo manually
- Or configure workflow based on Shoper status

---

## Performance

### Q: How many orders can I import at once?
**A:** Recommended: 50-100 orders per sync
- More: Risk of timeout
- Less: More sync runs needed

### Q: Import is slow - what can I do?
**A:**
1. Reduce "Max Orders Per Sync"
2. Use incremental sync (automatic)
3. Increase sync interval
4. Check server resources

### Q: Does this affect Odoo performance?
**A:** Minimal impact:
- Runs in background (cron)
- Uses efficient queries
- Proper indexing on key fields

---

## Troubleshooting

### Q: "Connection test failed" error
**A:**
1. Verify Shop URL (include https://)
2. Check API token validity
3. Regenerate token in Shoper if needed
4. Test network connectivity
5. Check firewall settings

### Q: "No active configuration found" error
**A:**
1. Go to Shoper → Configuration
2. Ensure a configuration exists
3. Check "Active" box
4. Save

### Q: API rate limit errors
**A:**
- Reduce sync frequency (increase interval)
- Check Shoper API plan limits
- Contact Shoper support

### Q: Timeout errors during import
**A:**
- Reduce "Max Orders Per Sync" to 25-50
- Check network speed
- Increase Odoo timeout settings

### Q: Where can I find error logs?
**A:** Check Odoo log file:
```bash
tail -f /var/log/odoo/odoo.log | grep -i shoper
```

### Q: Orders imported but data is wrong
**A:**
1. Check "Raw Data" in order
2. Verify mapping logic
3. Report issue if data structure changed

---

## Advanced

### Q: Can I customize the import logic?
**A:** Yes, module is open source (LGPL-3):
- Edit models/sale_order.py for order logic
- Edit models/res_partner.py for customer logic
- Add custom fields as needed

### Q: Can I add custom fields?
**A:** Yes:
1. Extend sale.order or res.partner models
2. Add fields in your custom module
3. Modify import logic to populate them

### Q: Can I use webhooks instead of polling?
**A:** Not yet. Webhook support is planned for future release.

### Q: Does this work with multi-company?
**A:** Yes:
- Create separate configuration per company
- Orders are company-specific
- Proper access rights enforced

### Q: Can I import to specific warehouse?
**A:** Extend the module to:
1. Add warehouse_id to configuration
2. Set warehouse in order creation

### Q: How do I backup before sync?
**A:**
```bash
# Backup database
pg_dump your_database > backup_$(date +%Y%m%d).sql
```

### Q: Can I test without importing to production?
**A:** Yes:
1. Use staging/test Odoo database
2. Configure with test Shoper shop
3. Test thoroughly before production

---

## Support

### Q: Where can I get help?
**A:**
- Check README.md and EXAMPLES.md
- Review ARCHITECTURE.md for technical details
- Check Odoo logs for errors
- Contact your Odoo partner

### Q: How do I report a bug?
**A:**
1. Check logs for error details
2. Try to reproduce in test environment
3. Document steps to reproduce
4. Contact module maintainer with details

### Q: Can I request features?
**A:** Yes! Feature requests welcome. See CHANGELOG.md for planned features.

### Q: Is commercial support available?
**A:** Contact your Odoo partner for commercial support options.

---

## Best Practices

### Q: What's the recommended setup?
**A:**
1. Start with test environment
2. Import last 30 days initially
3. Verify data quality
4. Pre-map common products
5. Merge customer duplicates
6. Enable automatic sync
7. Monitor for first week

### Q: How to prepare for first import?
**A:**
1. Backup database
2. Set "Import From Date" to recent date
3. Start with small "Max Orders Per Sync" (25-50)
4. Review imported data
5. Adjust settings as needed
6. Gradually expand date range

### Q: How to maintain data quality?
**A:**
1. Regular review of imported orders
2. Update product mappings
3. Merge customer duplicates
4. Monitor sync logs
5. Keep Shoper data clean

---

## Migration

### Q: Upgrading from older version?
**A:** See CHANGELOG.md for upgrade notes.

### Q: Moving to new Odoo instance?
**A:**
1. Install module on new instance
2. Configure with same Shoper credentials
3. Don't re-import (orders have same IDs)
4. Or export/import Odoo data

---

## API Limits

### Q: What are Shoper API limits?
**A:** Depends on your Shoper plan. Contact Shoper support for:
- Requests per minute/hour
- Data transfer limits
- API access level

### Q: How to stay within limits?
**A:**
- Use recommended sync intervals (1-4 hours)
- Don't sync more frequently than needed
- Use incremental sync (automatic)
- Monitor sync statistics

---

## Pricing

### Q: Is this module free?
**A:** Yes, open source (LGPL-3 license).

### Q: Are there any costs?
**A:**
- Module: Free
- Odoo: Free (Community) or paid (Enterprise)
- Shoper: Requires paid plan with API access
- Hosting: Your infrastructure costs

---

## Still have questions?

Check:
- README.md - General information
- INSTALL.md - Installation guide
- EXAMPLES.md - Usage examples
- ARCHITECTURE.md - Technical details

Or contact your Odoo partner for support.
