# Instrukcja Aktualizacji Modułu Shoper dla AlpSys

**Data:** 2025-10-05  
**System:** AlpSys (Windows/Docker)  
**Moduł:** odoo_shoper_integration v1.1.1

---

## 🔍 Problem Który Był

Moduł używał **błędnego endpointa API** do pobierania produktów z zamówień:
- Używał: `orders/{id}/products` ❌ (nie istnieje!)
- Powinien: `order-products?filters={"order_id":123}` ✅

**Skutek:**
- Zamówienia importowały się **bez produktów**
- Logi pokazywały błędy 404
- Synchronizacja była niepełna

---

## ✅ Co Zostało Naprawione

### Pliki Zmienione:
1. ✅ `models/shoper_api_client.py` - Poprawiony endpoint API
2. ✅ `__manifest__.py` - Zaktualizowana wersja do 1.1.1
3. ✅ `CHANGELOG.md` - Dodany opis zmian
4. ✅ `HOTFIX_v1.1.1.md` - Szczegółowa dokumentacja poprawki
5. ✅ `README_v1.1.1.md` - Krótki opis wersji

### Główna Zmiana:
```python
# PRZED:
def get_order_products(self, order_id):
    result = self._make_request('GET', f'orders/{order_id}/products')

# PO:
def get_order_products(self, order_id):
    filters_json = json.dumps({"order_id": order_id})
    params = {'filters': filters_json, 'limit': 50}
    result = self._make_request('GET', 'order-products', params=params)
```

---

## 🔧 Jak Zastosować w AlpSys

### Krok 1: Zatrzymaj Odoo

```bash
cd C:\AlpSys
docker-compose stop odoo-web
```

### Krok 2: Pliki Są Już Zaktualizowane

Pliki zostały już zapisane w lokalizacji:
```
C:\AlpSys\data\odoo\addons\odoo_shoper_integration\
```

Zmienione pliki:
- ✅ models/shoper_api_client.py
- ✅ __manifest__.py
- ✅ CHANGELOG.md
- ✅ HOTFIX_v1.1.1.md (nowy)
- ✅ README_v1.1.1.md (nowy)

### Krok 3: Uruchom Odoo

```bash
cd C:\AlpSys
docker-compose up -d odoo-web
```

### Krok 4: Sprawdź Logi Startu

```bash
docker-compose logs -f odoo-web
```

Poczekaj aż zobaczysz:
```
odoo-web | INFO ... odoo.service.server: HTTP service (werkzeug) running on ...
```

### Krok 5: Zaktualizuj Moduł w Odoo

**Opcja A: Przez interfejs web**
1. Zaloguj się do Odoo: http://localhost:8069
2. Przejdź do: **Apps** (Aplikacje)
3. Usuń filtr "Apps" z paska wyszukiwania
4. Wyszukaj: **Shoper Integration**
5. Kliknij: **Upgrade** (Aktualizuj)
6. Poczekaj na zakończenie

**Opcja B: Przez konsolę (zalecane)**
```bash
docker exec -it alpsys-odoo-web-1 odoo \
  -d postgres \
  -u odoo_shoper_integration \
  --stop-after-init
```

### Krok 6: Zrestartuj Odoo Po Aktualizacji

```bash
docker-compose restart odoo-web
```

---

## 🧪 Weryfikacja

### Test 1: Sprawdź Wersję
1. Odoo → **Apps** → **Shoper Integration**
2. Powinna być wersja: **18.0.1.1.1**

### Test 2: Test Połączenia
1. Odoo → **Shoper** → **Configuration**
2. Otwórz swoją konfigurację
3. Kliknij: **Test Connection**
4. Powinno pokazać: "Successfully connected..."

### Test 3: Synchronizacja Testowa
1. W konfiguracji kliknij: **Synchronize Orders Now**
2. Obserwuj notyfikację
3. Powinno pokazać liczbę zaimportowanych zamówień

### Test 4: Sprawdź Produkty w Zamówieniu
1. Odoo → **Shoper** → **Orders**
2. Otwórz dowolne zamówienie
3. Zakładka: **Order Lines**
4. **Powinny być produkty!** ✅

### Test 5: Sprawdź Logi
```bash
docker-compose logs odoo-web | grep -i "product" | tail -20
```

Powinno pokazywać:
```
✓ Found X products for order 12345
✓ Added order 12345 (..., 5 products)
```

A **NIE** powinno pokazywać:
```
✗ Shoper API error 404: orders/12345/products
```

---

## 📊 Oczekiwane Rezultaty

### Przed Aktualizacją (v1.1.0):
```
Zamówienie #12345
├─ Klient: Jan Kowalski
├─ Suma: 250.00 PLN
└─ Produkty: 0 (❌ PUSTY!)
```

### Po Aktualizacji (v1.1.1):
```
Zamówienie #12345
├─ Klient: Jan Kowalski
├─ Suma: 250.00 PLN
└─ Produkty: 5 (✅ PEŁNA LISTA!)
    ├─ Produkt A × 2 = 100.00 PLN
    ├─ Produkt B × 1 = 120.00 PLN
    └─ Dostawa      = 30.00 PLN
```

---

## ⚠️ Ważne Uwagi

### Stare Zamówienia
- Zamówienia zaimportowane PRZED aktualizacją **NIE** zostaną automatycznie poprawione
- Będą nadal **bez produktów**

### Jak Naprawić Stare Zamówienia?

**Opcja 1: Re-import (zalecane)**
1. W Odoo usuń stare zamówienia bez produktów
2. Uruchom synchronizację ponownie
3. Zamówienia zaimportują się z produktami

**Opcja 2: Ręczne dodanie**
1. Otwórz zamówienie w Odoo
2. Dodaj produkty ręcznie w zakładce Order Lines
3. Sprawdź zamówienie w Shoper jako źródło danych

### Nowe Zamówienia
- **Wszystkie nowe** zamówienia od tej chwili będą importowane **z produktami** ✅

---

## 🔄 Automatyczna Synchronizacja

Jeśli masz włączoną automatyczną synchronizację:
1. Nie musisz nic robić
2. Cron będzie działał z poprawioną wersją
3. Nowe zamówienia będą importowane prawidłowo

Sprawdź ustawienia:
```
Shoper → Configuration
├─ Enable Automatic Synchronization: ✓
└─ Synchronization Interval: 1-2 hours
```

---

## 🐛 Jeśli Coś Nie Działa

### Problem 1: Moduł nie aktualizuje się
```bash
# Wymuś aktualizację
docker exec -it alpsys-odoo-web-1 odoo \
  -d postgres \
  -u odoo_shoper_integration \
  --stop-after-init \
  --log-level=debug
```

### Problem 2: Nadal brak produktów
1. Sprawdź logi szczegółowo:
   ```bash
   docker-compose logs odoo-web > odoo_debug.log
   ```
2. Szukaj linii z "order-products" w logach
3. Sprawdź czy API Token jest aktualny

### Problem 3: Błędy 404
- Sprawdź URL sklepu w konfiguracji
- Zweryfikuj token API w Shoper
- Test API ręcznie:
  ```bash
  curl -H "Authorization: Bearer YOUR_TOKEN" \
       "https://alpmeb.pl/webapi/rest/order-products?limit=1"
  ```

### Problem 4: Timeout podczas synchronizacji
- Zmniejsz "Max Orders Per Sync" do 25-50
- Zwiększ timeout w konfiguracji Docker (jeśli potrzeba)

---

## 📞 Wsparcie

### Logi do Sprawdzenia:
```bash
# Wszystkie logi Odoo
docker-compose logs odoo-web

# Tylko błędy
docker-compose logs odoo-web | grep -i "error"

# Tylko Shoper
docker-compose logs odoo-web | grep -i "shoper"

# Monitoring na żywo
docker-compose logs -f odoo-web
```

### Pliki do Sprawdzenia:
```
C:\AlpSys\data\odoo\addons\odoo_shoper_integration\
├─ models/shoper_api_client.py (główna zmiana)
├─ __manifest__.py (wersja 1.1.1)
├─ HOTFIX_v1.1.1.md (szczegóły techniczne)
└─ README_v1.1.1.md (podsumowanie)
```

---

## ✅ Checklist Aktualizacji

Upewnij się że wykonałeś:

- [ ] Zatrzymałeś Odoo
- [ ] Pliki są zaktualizowane (już są!)
- [ ] Uruchomiłeś Odoo
- [ ] Zaktualizowałeś moduł w Odoo
- [ ] Zrestartowałeś Odoo
- [ ] Sprawdziłeś wersję (1.1.1)
- [ ] Przetestowałeś połączenie
- [ ] Uruchomiłeś synchronizację testową
- [ ] Sprawdziłeś produkty w zamówieniu
- [ ] Zweryfikowałeś logi

---

## 🎯 Status

**Wersja modułu:** 1.1.1  
**Status plików:** ✅ Zaktualizowane  
**Wymagane działania:** Restart Odoo + Upgrade modułu  
**Priorytet:** 🔥 KRYTYCZNY - zastosuj jak najszybciej  
**Czas wdrożenia:** ~5-10 minut  

---

**Powodzenia! Po aktualizacji zamówienia będą importowane z pełną listą produktów.** 🎉
