--
-- PostgreSQL database dump
--

-- Dumped from database version 16.9 (165f042)
-- Dumped by pg_dump version 16.9

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: allegro; Type: SCHEMA; Schema: -; Owner: neondb_owner
--

CREATE SCHEMA allegro;


ALTER SCHEMA allegro OWNER TO neondb_owner;

--
-- Name: catalog; Type: SCHEMA; Schema: -; Owner: neondb_owner
--

CREATE SCHEMA catalog;


ALTER SCHEMA catalog OWNER TO neondb_owner;

--
-- Name: commerce; Type: SCHEMA; Schema: -; Owner: neondb_owner
--

CREATE SCHEMA commerce;


ALTER SCHEMA commerce OWNER TO neondb_owner;

--
-- Name: shoper; Type: SCHEMA; Schema: -; Owner: neondb_owner
--

CREATE SCHEMA shoper;


ALTER SCHEMA shoper OWNER TO neondb_owner;

--
-- Name: order_source; Type: TYPE; Schema: commerce; Owner: neondb_owner
--

CREATE TYPE commerce.order_source AS ENUM (
    'ALLEGRO',
    'SHOPER'
);


ALTER TYPE commerce.order_source OWNER TO neondb_owner;

--
-- Name: sync_allegro_to_commerce(); Type: FUNCTION; Schema: public; Owner: neondb_owner
--

CREATE FUNCTION public.sync_allegro_to_commerce() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    v_first_name VARCHAR;
    v_last_name VARCHAR;
    name_parts TEXT[];
BEGIN
    -- Rozdziel imię i nazwisko (jeśli istnieje)
    IF NEW.buyer_name IS NOT NULL THEN
        name_parts := string_to_array(TRIM(NEW.buyer_name), ' ');
        v_first_name := name_parts[1];
        IF array_length(name_parts, 1) > 1 THEN
            v_last_name := array_to_string(name_parts[2:array_length(name_parts, 1)], ' ');
        END IF;
    END IF;
    
    -- Wstaw lub zaktualizuj w commerce.orders
    INSERT INTO commerce.orders (
        id,
        source,
        source_order_id,
        order_date,
        status,
        buyer_login,
        buyer_email,
        buyer_company,
        buyer_first_name,
        buyer_last_name,
        buyer_phone,
        buyer_address,
        buyer_zip,
        buyer_city,
        buyer_country_code,
        payment_id,
        payment_status,
        payment_type,
        payment_provider,
        payment_amount,
        payment_currency,
        delivery_method,
        delivery_amount,
        delivery_currency,
        total_to_pay_amount,
        total_to_pay_currency,
        buyer_notes,
        invoice_required,
        tracking_numbers,
        raw_payload,
        created_at,
        updated_at
    ) VALUES (
        gen_random_uuid(),
        'ALLEGRO',
        NEW.order_id,
        NEW.order_date,
        NEW.seller_status,
        NEW.buyer_login,
        NEW.buyer_email,
        NEW.buyer_company,
        v_first_name,
        v_last_name,
        NEW.buyer_phone,
        NEW.buyer_address,
        NEW.buyer_zip,
        NEW.buyer_city,
        NEW.buyer_country_code,
        NEW.payment_id,
        NEW.payment_status,
        NEW.payment_type,
        NEW.payment_provider,
        NEW.payment_amount,
        NEW.payment_currency,
        NEW.delivery_method,
        NEW.delivery_amount,
        NEW.delivery_currency,
        NEW.total_to_pay_amount,
        NEW.total_to_pay_currency,
        NEW.buyer_notes,
        NEW.invoice_required,
        NEW.tracking_numbers,
        jsonb_build_object(
            'order_id', NEW.order_id,
            'marketplace', NEW.marketplace,
            'smart', NEW.smart,
            'allegro_pay', NEW.allegro_pay
        ),
        NOW(),
        NOW()
    )
    ON CONFLICT (source_order_id, source) DO UPDATE SET
        order_date = EXCLUDED.order_date,
        status = EXCLUDED.status,
        buyer_login = EXCLUDED.buyer_login,
        buyer_email = EXCLUDED.buyer_email,
        buyer_company = EXCLUDED.buyer_company,
        buyer_first_name = EXCLUDED.buyer_first_name,
        buyer_last_name = EXCLUDED.buyer_last_name,
        buyer_phone = EXCLUDED.buyer_phone,
        buyer_address = EXCLUDED.buyer_address,
        buyer_zip = EXCLUDED.buyer_zip,
        buyer_city = EXCLUDED.buyer_city,
        buyer_country_code = EXCLUDED.buyer_country_code,
        payment_id = EXCLUDED.payment_id,
        payment_status = EXCLUDED.payment_status,
        payment_type = EXCLUDED.payment_type,
        payment_provider = EXCLUDED.payment_provider,
        payment_amount = EXCLUDED.payment_amount,
        payment_currency = EXCLUDED.payment_currency,
        delivery_method = EXCLUDED.delivery_method,
        delivery_amount = EXCLUDED.delivery_amount,
        delivery_currency = EXCLUDED.delivery_currency,
        total_to_pay_amount = EXCLUDED.total_to_pay_amount,
        total_to_pay_currency = EXCLUDED.total_to_pay_currency,
        buyer_notes = EXCLUDED.buyer_notes,
        invoice_required = EXCLUDED.invoice_required,
        tracking_numbers = EXCLUDED.tracking_numbers,
        updated_at = NOW();
    
    RETURN NEW;
END;
$$;


ALTER FUNCTION public.sync_allegro_to_commerce() OWNER TO neondb_owner;

--
-- Name: sync_shoper_to_commerce(); Type: FUNCTION; Schema: public; Owner: neondb_owner
--

CREATE FUNCTION public.sync_shoper_to_commerce() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    v_raw jsonb;
    v_billing_address jsonb;
    v_delivery_address jsonb;
    v_first_name VARCHAR;
    v_last_name VARCHAR;
    v_phone VARCHAR;
    v_company VARCHAR;
    v_street VARCHAR;
    v_zip VARCHAR;
    v_city VARCHAR;
    v_country_code VARCHAR;
    v_delivery_cost NUMERIC;
BEGIN
    v_raw := NEW.raw_data;
    
    -- Wyciągnij dane z billing_address
    IF v_raw->>'billing_address' IS NOT NULL THEN
        v_billing_address := (v_raw->>'billing_address')::jsonb;
        v_first_name := v_billing_address->>'firstname';
        v_last_name := v_billing_address->>'lastname';
        v_phone := v_billing_address->>'phone';
        v_company := v_billing_address->>'company';
    END IF;
    
    -- Wyciągnij dane z delivery_address
    IF v_raw->>'delivery_address' IS NOT NULL THEN
        v_delivery_address := (v_raw->>'delivery_address')::jsonb;
        v_street := v_delivery_address->>'street1';
        v_zip := v_delivery_address->>'postcode';
        v_city := v_delivery_address->>'city';
        v_country_code := v_delivery_address->>'country_code';
    END IF;
    
    v_delivery_cost := (v_raw->>'shipping_cost')::numeric;
    
    -- Wstaw lub zaktualizuj w commerce.orders
    INSERT INTO commerce.orders (
        id,
        source,
        source_order_id,
        order_date,
        status,
        buyer_login,
        buyer_email,
        buyer_company,
        buyer_first_name,
        buyer_last_name,
        buyer_phone,
        buyer_address,
        buyer_zip,
        buyer_city,
        buyer_country_code,
        payment_status,
        payment_type,
        payment_amount,
        payment_currency,
        delivery_amount,
        delivery_currency,
        total_to_pay_amount,
        total_to_pay_currency,
        buyer_notes,
        invoice_required,
        raw_payload,
        created_at,
        updated_at
    ) VALUES (
        gen_random_uuid(),
        'SHOPER',
        NEW.shoper_order_id,
        NEW.order_date,
        NEW.fulfillment_status,
        NEW.buyer_login,
        NEW.buyer_email,
        v_company,
        v_first_name,
        v_last_name,
        v_phone,
        v_street,
        v_zip,
        v_city,
        v_country_code,
        NEW.payment_status,
        CASE 
            WHEN (v_raw->>'payment_id')::int = 2 THEN 'ONLINE'
            ELSE 'CASH_ON_DELIVERY'
        END,
        NEW.total_amount,
        NEW.currency,
        v_delivery_cost,
        NEW.currency,
        NEW.total_amount,
        NEW.currency,
        v_raw->>'notes',
        false,
        v_raw,
        NOW(),
        NOW()
    )
    ON CONFLICT (source_order_id, source) DO UPDATE SET
        order_date = EXCLUDED.order_date,
        status = EXCLUDED.status,
        buyer_login = EXCLUDED.buyer_login,
        buyer_email = EXCLUDED.buyer_email,
        buyer_company = EXCLUDED.buyer_company,
        buyer_first_name = EXCLUDED.buyer_first_name,
        buyer_last_name = EXCLUDED.buyer_last_name,
        buyer_phone = EXCLUDED.buyer_phone,
        buyer_address = EXCLUDED.buyer_address,
        buyer_zip = EXCLUDED.buyer_zip,
        buyer_city = EXCLUDED.buyer_city,
        buyer_country_code = EXCLUDED.buyer_country_code,
        payment_status = EXCLUDED.payment_status,
        payment_type = EXCLUDED.payment_type,
        payment_amount = EXCLUDED.payment_amount,
        delivery_amount = EXCLUDED.delivery_amount,
        total_to_pay_amount = EXCLUDED.total_to_pay_amount,
        buyer_notes = EXCLUDED.buyer_notes,
        raw_payload = EXCLUDED.raw_payload,
        updated_at = NOW();
    
    RETURN NEW;
END;
$$;


ALTER FUNCTION public.sync_shoper_to_commerce() OWNER TO neondb_owner;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: order_items; Type: TABLE; Schema: allegro; Owner: neondb_owner
--

CREATE TABLE allegro.order_items (
    id integer NOT NULL,
    order_id character varying(255) NOT NULL,
    line_item_id character varying(255) NOT NULL,
    offer_id character varying(100),
    offer_external_id character varying(100),
    name text,
    quantity integer,
    price numeric(10,2),
    currency character varying(10),
    tax_rate numeric(5,2),
    tax_subject character varying(50),
    tax_exemption character varying(50),
    fundraising_campaign character varying(255),
    sending_country character varying(10),
    returns_quantity integer DEFAULT 0,
    imported_at timestamp without time zone DEFAULT now(),
    image_url text,
    product_id integer
);


ALTER TABLE allegro.order_items OWNER TO neondb_owner;

--
-- Name: order_items_id_seq; Type: SEQUENCE; Schema: allegro; Owner: neondb_owner
--

CREATE SEQUENCE allegro.order_items_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE allegro.order_items_id_seq OWNER TO neondb_owner;

--
-- Name: order_items_id_seq; Type: SEQUENCE OWNED BY; Schema: allegro; Owner: neondb_owner
--

ALTER SEQUENCE allegro.order_items_id_seq OWNED BY allegro.order_items.id;


--
-- Name: orders; Type: TABLE; Schema: allegro; Owner: neondb_owner
--

CREATE TABLE allegro.orders (
    id integer NOT NULL,
    order_id character varying(255) NOT NULL,
    seller_id character varying(100),
    seller_login character varying(100),
    order_date timestamp without time zone,
    seller_status character varying(50),
    marketplace character varying(50),
    buyer_id character varying(100),
    buyer_login character varying(100),
    buyer_email character varying(255),
    buyer_company character varying(255),
    buyer_name character varying(255),
    buyer_phone character varying(50),
    buyer_address text,
    buyer_zip character varying(20),
    buyer_city character varying(100),
    buyer_country_code character varying(10),
    payment_id character varying(255),
    payment_status character varying(50),
    payment_provider character varying(50),
    allegro_pay boolean,
    payment_amount numeric(10,2),
    payment_currency character varying(10),
    delivery_method character varying(255),
    delivery_amount numeric(10,2),
    delivery_currency character varying(10),
    total_to_pay_amount numeric(10,2),
    total_to_pay_currency character varying(10),
    buyer_notes text,
    smart boolean,
    tracking_numbers text,
    payment_last_date timestamp without time zone,
    buyer_account_type character varying(50),
    imported_at timestamp without time zone DEFAULT now(),
    payment_type character varying(50),
    invoice_required boolean DEFAULT false,
    shipments jsonb,
    billing_address text,
    refund_amount numeric(10,2) DEFAULT 0,
    refund_date timestamp without time zone,
    refund_reconciliation jsonb,
    has_returns boolean DEFAULT false
);


ALTER TABLE allegro.orders OWNER TO neondb_owner;

--
-- Name: orders_id_seq; Type: SEQUENCE; Schema: allegro; Owner: neondb_owner
--

CREATE SEQUENCE allegro.orders_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE allegro.orders_id_seq OWNER TO neondb_owner;

--
-- Name: orders_id_seq; Type: SEQUENCE OWNED BY; Schema: allegro; Owner: neondb_owner
--

ALTER SEQUENCE allegro.orders_id_seq OWNED BY allegro.orders.id;


--
-- Name: products; Type: TABLE; Schema: allegro; Owner: neondb_owner
--

CREATE TABLE allegro.products (
    id integer NOT NULL,
    product_id character varying(255),
    external_id character varying(255) NOT NULL,
    name text NOT NULL,
    description text,
    image_url text,
    category text,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE allegro.products OWNER TO neondb_owner;

--
-- Name: products_id_seq; Type: SEQUENCE; Schema: allegro; Owner: neondb_owner
--

CREATE SEQUENCE allegro.products_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE allegro.products_id_seq OWNER TO neondb_owner;

--
-- Name: products_id_seq; Type: SEQUENCE OWNED BY; Schema: allegro; Owner: neondb_owner
--

ALTER SEQUENCE allegro.products_id_seq OWNED BY allegro.products.id;


--
-- Name: sync_logs; Type: TABLE; Schema: allegro; Owner: neondb_owner
--

CREATE TABLE allegro.sync_logs (
    id integer NOT NULL,
    sync_started_at timestamp without time zone NOT NULL,
    sync_completed_at timestamp without time zone,
    status character varying(50) NOT NULL,
    orders_fetched integer DEFAULT 0,
    orders_new integer DEFAULT 0,
    orders_updated integer DEFAULT 0,
    error_message text,
    sync_duration_ms integer
);


ALTER TABLE allegro.sync_logs OWNER TO neondb_owner;

--
-- Name: sync_logs_id_seq; Type: SEQUENCE; Schema: allegro; Owner: neondb_owner
--

CREATE SEQUENCE allegro.sync_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE allegro.sync_logs_id_seq OWNER TO neondb_owner;

--
-- Name: sync_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: allegro; Owner: neondb_owner
--

ALTER SEQUENCE allegro.sync_logs_id_seq OWNED BY allegro.sync_logs.id;


--
-- Name: products; Type: TABLE; Schema: catalog; Owner: neondb_owner
--

CREATE TABLE catalog.products (
    id integer NOT NULL,
    source commerce.order_source NOT NULL,
    product_id character varying,
    external_id character varying NOT NULL,
    name text NOT NULL,
    description text,
    image_url text,
    category text,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    raw_data jsonb
);


ALTER TABLE catalog.products OWNER TO neondb_owner;

--
-- Name: products_id_seq; Type: SEQUENCE; Schema: catalog; Owner: neondb_owner
--

CREATE SEQUENCE catalog.products_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE catalog.products_id_seq OWNER TO neondb_owner;

--
-- Name: products_id_seq; Type: SEQUENCE OWNED BY; Schema: catalog; Owner: neondb_owner
--

ALTER SEQUENCE catalog.products_id_seq OWNED BY catalog.products.id;


--
-- Name: order_items; Type: TABLE; Schema: commerce; Owner: neondb_owner
--

CREATE TABLE commerce.order_items (
    id integer NOT NULL,
    order_id character varying NOT NULL,
    source commerce.order_source NOT NULL,
    source_item_id character varying,
    product_id integer,
    offer_id character varying,
    offer_external_id character varying,
    name text,
    quantity integer,
    price numeric,
    currency character varying,
    tax_rate numeric,
    tax_subject character varying,
    image_url text,
    created_at timestamp without time zone DEFAULT now(),
    offer_name text,
    unit_price numeric(10,2),
    total_price numeric(10,2),
    country_code character varying(10),
    payment_type character varying(50),
    invoice_required boolean DEFAULT false,
    raw_data jsonb,
    returns_quantity integer DEFAULT 0
);


ALTER TABLE commerce.order_items OWNER TO neondb_owner;

--
-- Name: order_items_id_seq; Type: SEQUENCE; Schema: commerce; Owner: neondb_owner
--

CREATE SEQUENCE commerce.order_items_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE commerce.order_items_id_seq OWNER TO neondb_owner;

--
-- Name: order_items_id_seq; Type: SEQUENCE OWNED BY; Schema: commerce; Owner: neondb_owner
--

ALTER SEQUENCE commerce.order_items_id_seq OWNED BY commerce.order_items.id;


--
-- Name: order_number_seq; Type: SEQUENCE; Schema: commerce; Owner: neondb_owner
--

CREATE SEQUENCE commerce.order_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE commerce.order_number_seq OWNER TO neondb_owner;

--
-- Name: orders; Type: TABLE; Schema: commerce; Owner: neondb_owner
--

CREATE TABLE commerce.orders (
    id character varying DEFAULT (gen_random_uuid())::text NOT NULL,
    order_number bigint DEFAULT nextval('commerce.order_number_seq'::regclass),
    source commerce.order_source NOT NULL,
    source_order_id character varying NOT NULL,
    order_date timestamp without time zone,
    status character varying,
    buyer_login character varying,
    buyer_email character varying,
    buyer_company character varying,
    buyer_first_name character varying,
    buyer_last_name character varying,
    buyer_phone character varying,
    buyer_address text,
    buyer_zip character varying,
    buyer_city character varying,
    buyer_country_code character varying,
    payment_id character varying,
    payment_status character varying,
    payment_type character varying,
    payment_provider character varying,
    payment_amount numeric,
    payment_currency character varying,
    delivery_method character varying,
    delivery_amount numeric,
    delivery_currency character varying,
    total_to_pay_amount numeric,
    total_to_pay_currency character varying,
    buyer_notes text,
    invoice_required boolean DEFAULT false,
    tracking_numbers text,
    raw_payload jsonb,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    buyer_company_name text,
    delivery_address jsonb,
    refund_amount numeric(10,2) DEFAULT 0,
    has_returns boolean DEFAULT false,
    billing_address text,
    shipments jsonb,
    refund_date timestamp without time zone,
    refund_reconciliation jsonb DEFAULT '[]'::jsonb,
    payment_last_date timestamp without time zone,
    billing_zip character varying(50),
    billing_city character varying(255),
    billing_country_code character varying(10),
    tax_id character varying(50),
    smart text,
    allegro_pay text,
    odoo_order_id integer
);


ALTER TABLE commerce.orders OWNER TO neondb_owner;

--
-- Name: allegro_connections; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.allegro_connections (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    client_id text NOT NULL,
    client_secret text NOT NULL,
    access_token text,
    refresh_token text,
    token_expires_at timestamp without time zone,
    is_active boolean DEFAULT false,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.allegro_connections OWNER TO neondb_owner;

--
-- Name: allegro_orders; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.allegro_orders (
    id character varying NOT NULL,
    allegro_order_id text NOT NULL,
    buyer_login text NOT NULL,
    buyer_email text,
    total_amount numeric(10,2) NOT NULL,
    currency text DEFAULT 'PLN'::text,
    payment_status text NOT NULL,
    fulfillment_status text,
    items_count text NOT NULL,
    order_date timestamp without time zone NOT NULL,
    payment_date timestamp without time zone,
    raw_data jsonb,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.allegro_orders OWNER TO neondb_owner;

--
-- Name: api_request_logs; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.api_request_logs (
    id integer NOT NULL,
    token_id integer,
    method character varying(10) NOT NULL,
    path text NOT NULL,
    status_code integer,
    response_time integer,
    ip_address character varying(45),
    user_agent text,
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.api_request_logs OWNER TO neondb_owner;

--
-- Name: api_request_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.api_request_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.api_request_logs_id_seq OWNER TO neondb_owner;

--
-- Name: api_request_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.api_request_logs_id_seq OWNED BY public.api_request_logs.id;


--
-- Name: api_tokens; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.api_tokens (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    description text,
    token text NOT NULL,
    token_prefix character varying(16),
    permissions jsonb DEFAULT '[]'::jsonb,
    is_active boolean DEFAULT true,
    last_used_at timestamp without time zone,
    expires_at timestamp without time zone,
    created_by_user_id integer,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.api_tokens OWNER TO neondb_owner;

--
-- Name: api_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.api_tokens_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.api_tokens_id_seq OWNER TO neondb_owner;

--
-- Name: api_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.api_tokens_id_seq OWNED BY public.api_tokens.id;


--
-- Name: odoo_config; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.odoo_config (
    id integer NOT NULL,
    url text NOT NULL,
    database character varying(255) NOT NULL,
    username character varying(255) NOT NULL,
    is_active boolean DEFAULT true,
    auto_confirm_orders boolean DEFAULT false,
    sync_interval_minutes integer DEFAULT 3,
    last_sync_at timestamp without time zone,
    last_sync_status character varying(50),
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    user_url text
);


ALTER TABLE public.odoo_config OWNER TO neondb_owner;

--
-- Name: odoo_config_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.odoo_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.odoo_config_id_seq OWNER TO neondb_owner;

--
-- Name: odoo_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.odoo_config_id_seq OWNED BY public.odoo_config.id;


--
-- Name: odoo_sync_logs; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.odoo_sync_logs (
    id integer NOT NULL,
    queue_id integer,
    operation character varying(20) NOT NULL,
    status character varying(50) NOT NULL,
    message text,
    error_details jsonb,
    request_payload jsonb,
    response_data jsonb,
    duration integer,
    odoo_order_id integer,
    created_at timestamp without time zone DEFAULT now(),
    order_number integer
);


ALTER TABLE public.odoo_sync_logs OWNER TO neondb_owner;

--
-- Name: odoo_sync_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.odoo_sync_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.odoo_sync_logs_id_seq OWNER TO neondb_owner;

--
-- Name: odoo_sync_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.odoo_sync_logs_id_seq OWNED BY public.odoo_sync_logs.id;


--
-- Name: odoo_sync_queue; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.odoo_sync_queue (
    id integer NOT NULL,
    source character varying(20) NOT NULL,
    operation character varying(20) DEFAULT 'create'::character varying NOT NULL,
    status character varying(50) DEFAULT 'pending'::character varying NOT NULL,
    attempts integer DEFAULT 0,
    max_attempts integer DEFAULT 3,
    last_error text,
    odoo_order_id integer,
    scheduled_at timestamp without time zone DEFAULT now(),
    processed_at timestamp without time zone,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    order_number integer NOT NULL
);


ALTER TABLE public.odoo_sync_queue OWNER TO neondb_owner;

--
-- Name: odoo_sync_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.odoo_sync_queue_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.odoo_sync_queue_id_seq OWNER TO neondb_owner;

--
-- Name: odoo_sync_queue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.odoo_sync_queue_id_seq OWNED BY public.odoo_sync_queue.id;


--
-- Name: order_changes; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.order_changes (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    order_id character varying NOT NULL,
    order_number text,
    source text NOT NULL,
    change_type text NOT NULL,
    field_changed text,
    old_value text,
    new_value text,
    detected_at timestamp without time zone DEFAULT now(),
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.order_changes OWNER TO neondb_owner;

--
-- Name: password_reset_tokens; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.password_reset_tokens (
    id integer NOT NULL,
    user_id integer NOT NULL,
    token character varying(255) NOT NULL,
    expires_at timestamp without time zone NOT NULL,
    used boolean DEFAULT false,
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.password_reset_tokens OWNER TO neondb_owner;

--
-- Name: password_reset_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.password_reset_tokens_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.password_reset_tokens_id_seq OWNER TO neondb_owner;

--
-- Name: password_reset_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.password_reset_tokens_id_seq OWNED BY public.password_reset_tokens.id;


--
-- Name: sessions; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.sessions (
    sid character varying NOT NULL,
    sess jsonb NOT NULL,
    expire timestamp without time zone NOT NULL
);


ALTER TABLE public.sessions OWNER TO neondb_owner;

--
-- Name: sync_settings; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.sync_settings (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    auto_refresh_enabled boolean DEFAULT true,
    refresh_interval_minutes text DEFAULT '3'::text,
    last_sync_at timestamp without time zone,
    shoper_auto_refresh_enabled boolean DEFAULT true,
    shoper_refresh_interval_minutes text DEFAULT '5'::text,
    last_shoper_sync_at timestamp without time zone,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.sync_settings OWNER TO neondb_owner;

--
-- Name: users; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.users (
    id integer NOT NULL,
    username character varying(255) NOT NULL,
    email character varying(255) NOT NULL,
    password text NOT NULL,
    first_name character varying(255),
    last_name character varying(255),
    role character varying(50) DEFAULT 'user'::character varying NOT NULL,
    permissions jsonb DEFAULT '[]'::jsonb,
    is_active boolean DEFAULT true,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.users OWNER TO neondb_owner;

--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.users_id_seq OWNER TO neondb_owner;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.users_id_seq OWNED BY public.users.id;


--
-- Name: webhook_configs; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.webhook_configs (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    url text NOT NULL,
    secret text,
    events jsonb DEFAULT '[]'::jsonb,
    is_active boolean DEFAULT true,
    retry_attempts integer DEFAULT 3,
    last_triggered_at timestamp without time zone,
    created_by integer,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.webhook_configs OWNER TO neondb_owner;

--
-- Name: webhook_configs_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.webhook_configs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.webhook_configs_id_seq OWNER TO neondb_owner;

--
-- Name: webhook_configs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.webhook_configs_id_seq OWNED BY public.webhook_configs.id;


--
-- Name: webhook_logs; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.webhook_logs (
    id integer NOT NULL,
    webhook_id integer,
    event character varying(100) NOT NULL,
    payload jsonb,
    status_code integer,
    response_body text,
    attempt_number integer DEFAULT 1,
    success boolean DEFAULT false,
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE public.webhook_logs OWNER TO neondb_owner;

--
-- Name: webhook_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.webhook_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.webhook_logs_id_seq OWNER TO neondb_owner;

--
-- Name: webhook_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.webhook_logs_id_seq OWNED BY public.webhook_logs.id;


--
-- Name: connections; Type: TABLE; Schema: shoper; Owner: neondb_owner
--

CREATE TABLE shoper.connections (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    shop_url text NOT NULL,
    access_token text,
    refresh_token text,
    token_expires_at timestamp without time zone,
    is_active boolean DEFAULT false,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE shoper.connections OWNER TO neondb_owner;

--
-- Name: order_items; Type: TABLE; Schema: shoper; Owner: neondb_owner
--

CREATE TABLE shoper.order_items (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    order_id character varying NOT NULL,
    shoper_product_id text,
    product_name text NOT NULL,
    quantity integer NOT NULL,
    unit_price numeric(10,2) NOT NULL,
    total_price numeric(10,2) NOT NULL,
    image_url text,
    payment_type text,
    invoice_required boolean DEFAULT false,
    raw_data jsonb,
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE shoper.order_items OWNER TO neondb_owner;

--
-- Name: orders; Type: TABLE; Schema: shoper; Owner: neondb_owner
--

CREATE TABLE shoper.orders (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    shoper_order_id text NOT NULL,
    buyer_login text NOT NULL,
    buyer_email text,
    total_amount numeric(10,2) NOT NULL,
    currency text DEFAULT 'PLN'::text,
    payment_status text NOT NULL,
    fulfillment_status text,
    items_count text NOT NULL,
    order_date timestamp without time zone NOT NULL,
    payment_date timestamp without time zone,
    raw_data jsonb,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    shipments jsonb
);


ALTER TABLE shoper.orders OWNER TO neondb_owner;

--
-- Name: products; Type: TABLE; Schema: shoper; Owner: neondb_owner
--

CREATE TABLE shoper.products (
    id character varying DEFAULT gen_random_uuid() NOT NULL,
    shoper_product_id text NOT NULL,
    name text NOT NULL,
    sku text,
    price numeric(10,2),
    stock_quantity integer,
    image_url text,
    raw_data jsonb,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now()
);


ALTER TABLE shoper.products OWNER TO neondb_owner;

--
-- Name: sync_logs; Type: TABLE; Schema: shoper; Owner: neondb_owner
--

CREATE TABLE shoper.sync_logs (
    id integer NOT NULL,
    sync_started_at timestamp without time zone NOT NULL,
    sync_finished_at timestamp without time zone,
    orders_count integer DEFAULT 0,
    success boolean DEFAULT false,
    error_message text,
    created_at timestamp without time zone DEFAULT now()
);


ALTER TABLE shoper.sync_logs OWNER TO neondb_owner;

--
-- Name: sync_logs_id_seq; Type: SEQUENCE; Schema: shoper; Owner: neondb_owner
--

CREATE SEQUENCE shoper.sync_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE shoper.sync_logs_id_seq OWNER TO neondb_owner;

--
-- Name: sync_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: shoper; Owner: neondb_owner
--

ALTER SEQUENCE shoper.sync_logs_id_seq OWNED BY shoper.sync_logs.id;


--
-- Name: order_items id; Type: DEFAULT; Schema: allegro; Owner: neondb_owner
--

ALTER TABLE ONLY allegro.order_items ALTER COLUMN id SET DEFAULT nextval('allegro.order_items_id_seq'::regclass);


--
-- Name: orders id; Type: DEFAULT; Schema: allegro; Owner: neondb_owner
--

ALTER TABLE ONLY allegro.orders ALTER COLUMN id SET DEFAULT nextval('allegro.orders_id_seq'::regclass);


--
-- Name: products id; Type: DEFAULT; Schema: allegro; Owner: neondb_owner
--

ALTER TABLE ONLY allegro.products ALTER COLUMN id SET DEFAULT nextval('allegro.products_id_seq'::regclass);


--
-- Name: sync_logs id; Type: DEFAULT; Schema: allegro; Owner: neondb_owner
--

ALTER TABLE ONLY allegro.sync_logs ALTER COLUMN id SET DEFAULT nextval('allegro.sync_logs_id_seq'::regclass);


--
-- Name: products id; Type: DEFAULT; Schema: catalog; Owner: neondb_owner
--

ALTER TABLE ONLY catalog.products ALTER COLUMN id SET DEFAULT nextval('catalog.products_id_seq'::regclass);


--
-- Name: order_items id; Type: DEFAULT; Schema: commerce; Owner: neondb_owner
--

ALTER TABLE ONLY commerce.order_items ALTER COLUMN id SET DEFAULT nextval('commerce.order_items_id_seq'::regclass);


--
-- Name: api_request_logs id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.api_request_logs ALTER COLUMN id SET DEFAULT nextval('public.api_request_logs_id_seq'::regclass);


--
-- Name: api_tokens id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.api_tokens ALTER COLUMN id SET DEFAULT nextval('public.api_tokens_id_seq'::regclass);


--
-- Name: odoo_config id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.odoo_config ALTER COLUMN id SET DEFAULT nextval('public.odoo_config_id_seq'::regclass);


--
-- Name: odoo_sync_logs id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.odoo_sync_logs ALTER COLUMN id SET DEFAULT nextval('public.odoo_sync_logs_id_seq'::regclass);


--
-- Name: odoo_sync_queue id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.odoo_sync_queue ALTER COLUMN id SET DEFAULT nextval('public.odoo_sync_queue_id_seq'::regclass);


--
-- Name: password_reset_tokens id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.password_reset_tokens ALTER COLUMN id SET DEFAULT nextval('public.password_reset_tokens_id_seq'::regclass);


--
-- Name: users id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.users ALTER COLUMN id SET DEFAULT nextval('public.users_id_seq'::regclass);


--
-- Name: webhook_configs id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.webhook_configs ALTER COLUMN id SET DEFAULT nextval('public.webhook_configs_id_seq'::regclass);


--
-- Name: webhook_logs id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.webhook_logs ALTER COLUMN id SET DEFAULT nextval('public.webhook_logs_id_seq'::regclass);


--
-- Name: sync_logs id; Type: DEFAULT; Schema: shoper; Owner: neondb_owner
--

ALTER TABLE ONLY shoper.sync_logs ALTER COLUMN id SET DEFAULT nextval('shoper.sync_logs_id_seq'::regclass);


--
-- Data for Name: order_items; Type: TABLE DATA; Schema: allegro; Owner: neondb_owner
--

COPY allegro.order_items (id, order_id, line_item_id, offer_id, offer_external_id, name, quantity, price, currency, tax_rate, tax_subject, tax_exemption, fundraising_campaign, sending_country, returns_quantity, imported_at, image_url, product_id) FROM stdin;
799	2472fa10-a2c4-11f0-8e98-fdfd51e10ba4	246b58f0-a2c4-11f0-8e98-fdfd51e10ba4	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:46.315283	\N	7
39	a997f0e0-a217-11f0-83df-53954cf6c551	a9904fc0-a217-11f0-83df-53954cf6c551	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:05.138351	\N	16
54	bce3c350-a1f8-11f0-a6cc-b3145592fdde	bcdce582-a1f8-11f0-a6cc-b3145592fdde	15440328552	5905806216875	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko LANCELOT	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:20.304219	\N	61
79	95595a70-a1bc-11f0-a6cc-b3145592fdde	95525590-a1bc-11f0-a6cc-b3145592fdde	11750203551	5905806208344	Szafka na buty z szufladą Tres 60x36 Biały	1	434.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:52.977557	\N	84
7303	c8e0d140-a2e6-11f0-a638-c7e352f2113f	c8d78271-a2e6-11f0-a638-c7e352f2113f	15250482464	5905806215212	Garderoba 110x36D1N1 SUPRA60 TRES50 3PAN-WP50 CZARNY ARTISAN	1	1832.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:39.878245	\N	2464
5039	25f49990-a2db-11f0-bfbd-d3aacc6a2e00	25f005b0-a2db-11f0-bfbd-d3aacc6a2e00	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:41.64475	\N	49
5040	35868030-a2db-11f0-8b51-87d1833631ec	35817720-a2db-11f0-8b51-87d1833631ec	15919784886	5905806228991	Komoda Bones 50x36D1N1 WOTAN	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:42.05297	\N	347
5041	13300610-a2da-11f0-96ea-bf4f56b08af2	132bc050-a2da-11f0-96ea-bf4f56b08af2	16859417789	5905806210613	Półka ścienna 80x18x20cm CZARNY	1	98.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:42.462722	\N	348
10	74ee70b0-a28c-11f0-9d66-3d00eb1ccfed	74e6a880-a28c-11f0-9d66-3d00eb1ccfed	15919529373	5905806228229	Komoda Bones 60x36D4N1 SONOMA	1	725.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:50.851745	\N	17
6515	7a343390-a2e4-11f0-bee6-2fee815ffc9f	7a2d07a0-a2e4-11f0-bee6-2fee815ffc9f	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:40.833471	\N	49
5654	b2342af0-a2e1-11f0-aba2-b3553c261cc2	b22cb0e0-a2e1-11f0-aba2-b3553c261cc2	16901470101	5905806211528	Wieszak ścienny WP100 na ubrania 100cm WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:41.2389	\N	921
5043	61869be0-a2d9-11f0-a638-c7e352f2113f	617f48e0-a2d9-11f0-a638-c7e352f2113f	17395006524	5905806238310	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:43.348278	\N	350
1	989a5e50-a2b1-11f0-96ea-bf4f56b08af2	989491f0-a2b1-11f0-96ea-bf4f56b08af2	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:47.538854	\N	4
4424	898146d0-a2d5-11f0-9468-2bd22967b382	8979ccc0-a2d5-11f0-9468-2bd22967b382	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	1	457.80	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:43.753422	\N	1
3	05ff2210-a2a7-11f0-a638-c7e352f2113f	05f81d30-a2a7-11f0-a638-c7e352f2113f	17567410245	\N	Poduszka ozdobna, dekoracyjna 50x30cm	1	37.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:48.36032	\N	\N
12	092d0510-a289-11f0-b024-2112831760cb	0927d4f0-a289-11f0-b024-2112831760cb	12266463730	5905806203899	Szafka na buty z szufladą Tres 30x30x82 Biały	1	341.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:51.668214	\N	19
8302	0b61c0f0-a2ed-11f0-8e98-fdfd51e10ba4	0b5a9500-a2ed-11f0-8e98-fdfd51e10ba4	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:39.001216	\N	71
7800	c0249260-a2e8-11f0-8144-0ba8ff5b8d19	c01fd770-a2e8-11f0-8144-0ba8ff5b8d19	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:39.460395	\N	23
3556	0861c630-a2d3-11f0-bfbd-d3aacc6a2e00	085ce430-a2d3-11f0-bfbd-d3aacc6a2e00	15410022839	5905806218855	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Dąb Wotan	1	1136.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:44.62111	\N	3
2	3f589880-a2b0-11f0-9468-2bd22967b382	3f514580-a2b0-11f0-9468-2bd22967b382	17380187713	5905806202045	Szafka na buty VB60x30D1N1 Dąb Olejowany	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:47.944898	\N	11
11	b5925ca0-a28a-11f0-abd8-f5344f24907b	b58b30b0-a28a-11f0-abd8-f5344f24907b	15179529808	5905806213034	Szafka komoda na buty 50x30 D2N1 Altus Czarny	1	471.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:51.264554	\N	18
110	68bf4590-a0f6-11f0-8323-6df02f435f6c	68bad8c0-a0f6-11f0-8323-6df02f435f6c	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 17:22:43.295573	\N	41
38	ebc198d0-a21d-11f0-a6cc-b3145592fdde	ebb87110-a21d-11f0-a6cc-b3145592fdde	16602435582	5905806234596	Komoda Bini 80x30x82 D1N1 BIAŁY	1	550.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:03.351154	\N	45
4	38d3bef0-a2a5-11f0-a6c9-036cfc044caf	38cc44e0-a2a5-11f0-a6c9-036cfc044caf	17736445207	\N	Szafka na buty VB60x30D1N1 KASZMIR	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:48.732294	\N	\N
7304	c8e0d140-a2e6-11f0-a638-c7e352f2113f	c8d78270-a2e6-11f0-a638-c7e352f2113f	15463830012	5905806220605	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Czarny Dąb Artisan	1	1052.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:39.878245	\N	2465
5042	b0967a20-a2d9-11f0-abd8-f5344f24907b	b08f0010-a2d9-11f0-abd8-f5344f24907b	12487594410	5905204699560	Garderoba 80x30cm V50 Supra30 4 Panele D1 BIAŁY	1	1283.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:42.937473	\N	349
1171	b5ec64e0-a2c9-11f0-abd8-f5344f24907b	b5e56000-a2c9-11f0-abd8-f5344f24907b	15225572646	5905806213423	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 WOTAN	1	1705.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:45.860476	\N	6
800	e783f970-a2bd-11f0-b024-2112831760cb	e77ea240-a2bd-11f0-b024-2112831760cb	12487594818	5905806204988	Garderoba 80x30cm V50 Supra30 4 Panele D1N1 LANCELOT	1	1283.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:46.71877	\N	8
9217	274751f0-a544-11f0-bb74-8b6fbb6f100b	27407420-a544-11f0-bb74-8b6fbb6f100b	13855292522	5905806200010	Szafka na buty VB50x30 D1N1 siedzisko, schowek DĄB LANCELOT	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:32:59.478629	\N	4261
9218	9b0d65e0-a53d-11f0-a008-2360f331b758	9b096e40-a53d-11f0-a008-2360f331b758	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:01.106023	\N	49
9219	b54142b0-a538-11f0-9da2-81c6f7d897d8	b53a64e0-a538-11f0-9da2-81c6f7d897d8	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:02.474009	\N	98
25	293909b0-a22c-11f0-809f-f9f6de958f67	2931ddc0-a22c-11f0-809f-f9f6de958f67	15221331957	5905806214109	Szafka na buty z szufladą Tres 50x36 Czarny	1	447.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:51.969786	\N	32
32	568e1d20-a221-11f0-83df-53954cf6c551	56867c00-a221-11f0-83df-53954cf6c551	16723583463	5905806237160	Szafka na buty z lustrem Supra 60x36 Szafa z szufladą D1N1 DĄB WOTAN	1	1352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:58.724698	\N	39
34	c5ae0f50-a21f-11f0-96ea-bf4f56b08af2	c5a90640-a21f-11f0-96ea-bf4f56b08af2	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:00.385471	\N	41
35	1ece4030-a21d-11f0-8c5e-eb0a288ebc91	1ec95e30-a21d-11f0-8c5e-eb0a288ebc91	16276323396	5905806233933	Komoda Bini 60x30D1N1 SONOMA	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:01.827597	\N	42
19	ed908310-a236-11f0-b1e3-b7ce882fc700	ed8c3d50-a236-11f0-b1e3-b7ce882fc700	15155170458	5905806208788	Szafka na buty z szufladą Tres 80x30D1N1 CZARNY BIAŁY	1	564.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:47.255143	\N	26
15	952bb881-a271-11f0-9468-2bd22967b382	95248c91-a271-11f0-9468-2bd22967b382	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:52.886558	\N	7
22	68cb3021-a22d-11f0-954f-f9092bddbf0d	68c5d8f1-a22d-11f0-954f-f9092bddbf0d	14387673937	5905806202366	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Czarny BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:50.461152	\N	29
20	93c15c40-a233-11f0-a6cc-b3145592fdde	93baa581-a233-11f0-a6cc-b3145592fdde	10862951244	5905806209020	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	1	471.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:48.761018	\N	27
45	e4f4e930-a204-11f0-9d66-3d00eb1ccfed	e4edbd40-a204-11f0-9d66-3d00eb1ccfed	17946229799	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:11.385311	\N	12
48	c68fea00-a202-11f0-9468-2bd22967b382	c688be10-a202-11f0-9468-2bd22967b382	16415950409	5905806231922	Szafka na buty VB50x36 D2N1 DĄB ARTISAN	1	344.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:15.890965	\N	55
50	0dc59e40-a200-11f0-a6cc-b3145592fdde	0dbe4b40-a200-11f0-a6cc-b3145592fdde	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:17.518733	\N	57
55	8900fcb0-a1f8-11f0-8865-a987ea6c1e01	88f95b90-a1f8-11f0-8865-a987ea6c1e01	17532811873	\N	Szafka na buty, słupek SUPRA-TRES 30x30 Biały	1	532.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:22.039809	\N	\N
17	969f5ca0-a238-11f0-b1e3-b7ce882fc700	963f6250-a238-11f0-b1e3-b7ce882fc700	17496557717	5905806238860	Szafka na buty VB100x30 D3N3 CZARNY	1	595.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:45.567104	\N	24
8550	24befdc0-a2f1-11f0-8144-0ba8ff5b8d19	24b42850-a2f1-11f0-8144-0ba8ff5b8d19	12258666208	5905806216974	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	1	1807.60	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:38.433125	\N	14
6884	907c6f90-a2e5-11f0-bfbd-d3aacc6a2e00	90776680-a2e5-11f0-bfbd-d3aacc6a2e00	14384920401	5905806201840	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm DĄB ARTISAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:40.421628	\N	2071
9	d840e830-a293-11f0-997b-19b8e7655382	d8377250-a293-11f0-997b-19b8e7655382	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:50.440623	\N	16
23	293909b0-a22c-11f0-809f-f9f6de958f67	2931ddc2-a22c-11f0-809f-f9f6de958f67	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:51.969786	\N	30
24	293909b0-a22c-11f0-809f-f9f6de958f67	2931ddc1-a22c-11f0-809f-f9f6de958f67	16602437468	5905806234688	Komoda Bini 80x36 D1N1 CZARNY	1	594.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:51.969786	\N	31
26	52cd4060-a228-11f0-a6cc-b3145592fdde	52c3f190-a228-11f0-a6cc-b3145592fdde	15221503220	5905806214192	Szafka na buty z szufladą Tres 80x30 Dąb Wotan	1	564.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:53.773874	\N	33
27	56379be0-a225-11f0-a82d-fde841cbe8d5	56326bc1-a225-11f0-a82d-fde841cbe8d5	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:55.275374	\N	34
28	56379be0-a225-11f0-a82d-fde841cbe8d5	56326bc2-a225-11f0-a82d-fde841cbe8d5	11873260685	5905806214246	Szafka na buty z szufladą Tres 80x82x36 SONOMA	1	600.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:55.275374	\N	35
30	26221bd0-a223-11f0-bddc-ebae77b3e555	261aefe0-a223-11f0-bddc-ebae77b3e555	15155236665	5905806209099	Szafka na buty z szufladą Tres 60x30D2N1 LANCELOT	1	508.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:57.070851	\N	37
33	568e1d20-a221-11f0-83df-53954cf6c551	56867c01-a221-11f0-83df-53954cf6c551	16458885091	5905806221473	Zestaw Tres60x36D1N1 3PAN WP60 WOTAN	1	857.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:58.724698	\N	40
36	ebc198d0-a21d-11f0-a6cc-b3145592fdde	ebb87112-a21d-11f0-a6cc-b3145592fdde	16602433072	5905806234473	Komoda Bini 50x30x82 D1N1 BIAŁY	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:03.351154	\N	43
37	ebc198d0-a21d-11f0-a6cc-b3145592fdde	ebb87111-a21d-11f0-a6cc-b3145592fdde	16276316851	5905806233896	Komoda Bini 60x30D1N1 BIAŁY	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:03.351154	\N	44
46	9f49fb00-a204-11f0-b1e3-b7ce882fc700	9f451900-a204-11f0-b1e3-b7ce882fc700	14563825336	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan	1	278.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:12.904683	\N	53
16	363671e0-a270-11f0-8e98-fdfd51e10ba4	36303050-a270-11f0-8e98-fdfd51e10ba4	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:53.299783	\N	23
47	2dddfd50-a203-11f0-bdc8-e34a18959311	2dd9b790-a203-11f0-bdc8-e34a18959311	15440331779	5905806218077	Zestaw VB80x30 Tres80x30 D1N1 szafka na buty siedzisko ARTISAN	1	963.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:14.39478	\N	54
9224	201f4571-a537-11f0-b89d-d9b346103272	200fb511-a537-11f0-b89d-d9b346103272	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:02.352246	\N	7
31	26221bd0-a223-11f0-bddc-ebae77b3e555	261aefe1-a223-11f0-bddc-ebae77b3e555	12196322651	5905806203714	Wieszak ścienny WP60 na ubrania 60cm Lancelot	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:57.070851	\N	38
9225	137c4160-a537-11f0-9cb2-b90a5baab897	13758aa0-a537-11f0-9cb2-b90a5baab897	16859415981	5905806210293	Półka ścienna 50x18x20cm WOTAN	1	76.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:05.168128	\N	4269
9226	69c2c560-a534-11f0-a008-2360f331b758	69bea6b0-a534-11f0-a008-2360f331b758	15155167503	5905806208443	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:06.492133	\N	4270
9227	84ca8da0-a527-11f0-a444-6d64b3cc877f	84c5aba0-a527-11f0-a444-6d64b3cc877f	17395006524	5905806238310	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	2	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:07.807719	\N	350
64	394fc140-a1eb-11f0-b1e3-b7ce882fc700	394b5470-a1eb-11f0-b1e3-b7ce882fc700	17736463271	\N	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm KASZMIR	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:27.436274	\N	\N
72	33875f10-a1ce-11f0-954f-f9092bddbf0d	337c3b80-a1ce-11f0-954f-f9092bddbf0d	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:43.902051	\N	77
76	ed350e50-a1c2-11f0-9468-2bd22967b382	ed2dbb50-a1c2-11f0-9468-2bd22967b382	15221043005	5905806208320	Szafka na buty z szufladą Tres 60x36 Dąb Artisan	2	478.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:49.965101	\N	81
102	66a16aa0-a122-11f0-baf0-af7ea74e3d0e	6699c980-a122-11f0-baf0-af7ea74e3d0e	17532641274	\N	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	3	3.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:22.997025	\N	\N
52	bce3c350-a1f8-11f0-a6cc-b3145592fdde	bcdce581-a1f8-11f0-a6cc-b3145592fdde	11769358337	5905806222357	Panel ścienny tapicerowany pan1x50x35	1	54.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:20.304219	\N	59
56	caf7ce70-a1f6-11f0-9468-2bd22967b382	caf0a280-a1f6-11f0-9468-2bd22967b382	15176152026	5905806212952	Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan	3	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:23.4191	\N	62
57	463f6510-a1f3-11f0-9468-2bd22967b382	46381210-a1f3-11f0-9468-2bd22967b382	15225570547	5905806213379	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 BIAŁY	1	1705.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:24.949312	\N	63
60	698624e0-a1ef-11f0-84a0-0fb86e0c96e9	6981df20-a1ef-11f0-84a0-0fb86e0c96e9	15315950401	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	1	611.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:29.418346	\N	66
67	c9711b50-a1de-11f0-954f-f9092bddbf0d	c96cfca0-a1de-11f0-954f-f9092bddbf0d	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:35.667074	\N	72
61	6c211080-a1ee-11f0-ac86-5dc583ff1e95	6c1a80d0-a1ee-11f0-ac86-5dc583ff1e95	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:30.915188	\N	4
62	9a2d1e40-a1eb-11f0-9d66-3d00eb1ccfed	9a25cb41-a1eb-11f0-9d66-3d00eb1ccfed	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	1	478.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:32.414177	\N	1
68	a209e250-a1d8-11f0-aa33-a79405b55c6d	a2030480-a1d8-11f0-aa33-a79405b55c6d	15919782083	5905806228946	Komoda Bones 50x36D1N1 ARTISAN	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:37.130684	\N	73
69	d47b0d00-a1d7-11f0-9d66-3d00eb1ccfed	d4736be0-a1d7-11f0-9d66-3d00eb1ccfed	15109022782	5905806207569	Garderoba 80x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	1	977.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:38.630984	\N	74
77	7eb9b2d0-a1bf-11f0-bfbd-d3aacc6a2e00	7eb56d10-a1bf-11f0-bfbd-d3aacc6a2e00	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:51.486052	\N	82
84	8eab3fe0-a162-11f0-a6cc-b3145592fdde	8ea377b0-a162-11f0-a6cc-b3145592fdde	17736467450	\N	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:59.247977	\N	\N
58	3bdeafe0-a1f3-11f0-a6cc-b3145592fdde	3bd7f920-a1f3-11f0-a6cc-b3145592fdde	12476639410	5905204699454	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Dąb Sonoma	1	954.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:26.431286	\N	64
65	c50f7971-a1df-11f0-ac86-5dc583ff1e95	c507ff61-a1df-11f0-ac86-5dc583ff1e95	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	1	592.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:34.036455	\N	70
9228	78eca3c0-a526-11f0-8895-094b8cada9e7	78e66230-a526-11f0-8895-094b8cada9e7	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:09.134561	\N	75
51	935f63c0-a1ff-11f0-8e98-fdfd51e10ba4	9357c2a0-a1ff-11f0-8e98-fdfd51e10ba4	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:18.981615	\N	57
59	d63f36f0-a1f2-11f0-b871-03a75625f948	d63af130-a1f2-11f0-b871-03a75625f948	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:27.941967	\N	65
63	9a2d1e40-a1eb-11f0-9d66-3d00eb1ccfed	9a25cb40-a1eb-11f0-9d66-3d00eb1ccfed	17946230281	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:32.414177	\N	13
66	c50f7971-a1df-11f0-ac86-5dc583ff1e95	c507ff62-a1df-11f0-ac86-5dc583ff1e95	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:34.036455	\N	71
71	da174e91-a1d2-11f0-9d66-3d00eb1ccfed	da1070c0-a1d2-11f0-9d66-3d00eb1ccfed	15121615649	5905806205138	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1D1Wotan	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:41.82403	\N	76
86	db63fdd0-a159-11f0-9468-2bd22967b382	db5d2000-a159-11f0-9468-2bd22967b382	17739061173	\N	Wieszak ścienny WP60 na ubrania 60cm SONOMA CZARNY	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:02.125041	\N	\N
88	f041b5b0-a14c-11f0-a6cc-b3145592fdde	f03afef0-a14c-11f0-a6cc-b3145592fdde	17532641274	\N	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	1	3.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:03.693467	\N	\N
70	e23a1a50-a1d5-11f0-8865-a987ea6c1e01	e2333c80-a1d5-11f0-8865-a987ea6c1e01	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	828.00	PLN	\N	\N	\N	\N	PL	1	2025-10-09 19:40:40.095051	\N	75
9229	6a9651c0-a523-11f0-a204-f12f4b71e7fe	6a923310-a523-11f0-a204-f12f4b71e7fe	16271341145	5905806233391	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 WOTAN	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:10.435375	\N	4273
9230	e9aba750-a521-11f0-b989-75c7faccd1ca	e9a4c980-a521-11f0-b989-75c7faccd1ca	12266508963	5905204699102	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:11.777365	\N	4274
9231	6d4cfc60-a51a-11f0-a588-b391296a673a	6d481a60-a51a-11f0-a588-b391296a673a	16602435285	5905806234589	Komoda Bini 50x36 D1N1 WOTAN	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:13.158206	\N	4275
9232	5448b830-a51a-11f0-9bfc-3dd64ee50ad6	5441b350-a51a-11f0-9bfc-3dd64ee50ad6	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:14.468451	\N	82
9233	b3f8dca0-a516-11f0-a5d7-371746f07634	b3ee0730-a516-11f0-a5d7-371746f07634	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:15.780528	\N	2
9234	8922fc00-a50b-11f0-9b0c-e511fc7361fa	891abea0-a50b-11f0-9b0c-e511fc7361fa	16698543601	5905806237023	Garderoba z lustrem 90x30cm V60 Supra30 4 Panele D1N1 Dąb Wotan	1	1430.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:17.087355	\N	4278
18	969f5ca0-a238-11f0-b1e3-b7ce882fc700	963f6251-a238-11f0-b1e3-b7ce882fc700	15685809460	5905806222005	Szafka na buty z szufladą Tres 60x36D1N3 CZARNY	1	545.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:45.567104	\N	25
9235	268f0bd1-a4ff-11f0-b9bf-2795de008363	2688a332-a4ff-11f0-b9bf-2795de008363	14387672711	5905806202335	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Cza Wotan	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:18.40805	\N	4279
6	8d77a490-a2a4-11f0-8d49-a16d7ed74f8d	8d6be4c0-a2a4-11f0-8d49-a16d7ed74f8d	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:49.071642	\N	13
40	a997f0e0-a217-11f0-83df-53954cf6c551	a9904fc1-a217-11f0-83df-53954cf6c551	11906888620	5905806203578	Szafka na buty VB100x30D S1 siedzisko schowek 100cm DĄB SONOMA	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:05.138351	\N	47
75	65d8f0a0-a1c9-11f0-9d66-3d00eb1ccfed	65d12870-a1c9-11f0-9d66-3d00eb1ccfed	16271360906	5905806233643	Szafka na buty Supra-Nex 30x30D1N1 SONOMA	1	715.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:48.482457	\N	80
83	0f4702d1-a16b-11f0-8e98-fdfd51e10ba4	0f3d3ed1-a16b-11f0-8e98-fdfd51e10ba4	16602433840	5905806234503	Komoda Bini 50x30x82 D1N1 LANCELOT	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:57.767472	\N	88
85	6a9bb600-a15f-11f0-8e98-fdfd51e10ba4	6a952650-a15f-11f0-8e98-fdfd51e10ba4	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:00.64849	\N	30
78	95595a70-a1bc-11f0-a6cc-b3145592fdde	95525592-a1bc-11f0-a6cc-b3145592fdde	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:52.977557	\N	83
81	61bbd700-a1b8-11f0-96ea-bf4f56b08af2	61b176c0-a1b8-11f0-96ea-bf4f56b08af2	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:54.766485	\N	2
82	00cde260-a16f-11f0-a6cc-b3145592fdde	00c72ba0-a16f-11f0-a6cc-b3145592fdde	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	1	434.90	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:56.295878	\N	87
90	28710f90-a14c-11f0-9468-2bd22967b382	286a31c0-a14c-11f0-9468-2bd22967b382	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:05.266723	\N	92
91	80593270-a145-11f0-96ea-bf4f56b08af2	8054c5a0-a145-11f0-96ea-bf4f56b08af2	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:06.740201	\N	93
92	2fb0e140-a142-11f0-9d66-3d00eb1ccfed	2faa5190-a142-11f0-9d66-3d00eb1ccfed	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:08.213471	\N	94
94	2413b570-a137-11f0-8323-6df02f435f6c	240ed370-a137-11f0-8323-6df02f435f6c	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:11.166047	\N	7
95	893ee8c2-a137-11f0-9d66-3d00eb1ccfed	89365d47-a137-11f0-9d66-3d00eb1ccfed	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:12.644539	\N	97
96	dc074280-a134-11f0-96ea-bf4f56b08af2	dc02d5b0-a134-11f0-96ea-bf4f56b08af2	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:14.126933	\N	98
98	cee26871-a12d-11f0-b1e3-b7ce882fc700	cedcea31-a12d-11f0-b1e3-b7ce882fc700	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:17.079634	\N	41
99	985df1b0-a129-11f0-bfbd-d3aacc6a2e00	985984e0-a129-11f0-bfbd-d3aacc6a2e00	15176150939	5905806209549	Szafka komoda na buty 80x30 D2N1 Altus CZARNY	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:18.581203	\N	101
9240	f621b350-a4f2-11f0-9b0c-e511fc7361fa	f61927d0-a4f2-11f0-9b0c-e511fc7361fa	15919776759	5905806228861	Komoda Bones 60x36D1N1 SONOMA	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 20:15:49.82405	\N	4282
13	ea829fd0-a283-11f0-aba2-b3553c261cc2	ea7b73e0-a283-11f0-aba2-b3553c261cc2	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:52.071739	\N	12
100	962c7da0-a127-11f0-b1e3-b7ce882fc700	96277490-a127-11f0-b1e3-b7ce882fc700	15176150526	5905806209525	Szafka komoda na buty 80x30 D2N1 Altus WOTAN	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:20.077393	\N	102
101	4a9b1490-a123-11f0-a6cc-b3145592fdde	4a945dd0-a123-11f0-a6cc-b3145592fdde	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:21.538709	\N	65
14	fe9dd160-a27e-11f0-a6cc-b3145592fdde	fe967e60-a27e-11f0-a6cc-b3145592fdde	16319665889	5905806234268	Komoda szafka NEX 80x30x124 sypialnia salon przedpokój D1N1 BIAŁY	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:52.478694	\N	21
42	68ef7970-a20b-11f0-b1e3-b7ce882fc700	68eb0ca0-a20b-11f0-b1e3-b7ce882fc700	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:08.266022	\N	49
73	4e91fa90-a1ce-11f0-954f-f9092bddbf0d	4e8d66b0-a1ce-11f0-954f-f9092bddbf0d	15977138561	5905806229035	Komoda Bones 50x36D4N1 CZARNY	1	692.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:45.426522	\N	78
74	4289c930-a1c9-11f0-b871-03a75625f948	4284e730-a1c9-11f0-b871-03a75625f948	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	2	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:46.948068	\N	49
87	db63fdd0-a159-11f0-9468-2bd22967b382	db5d2001-a159-11f0-9468-2bd22967b382	15112615224	5905806208528	Zestaw szafka na buty siedzisko VB60x30D1N1 Tres60 z szufladą Czarny Sonoma	1	780.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:02.125041	\N	90
93	20dbfe80-a141-11f0-8e98-fdfd51e10ba4	20d547c0-a141-11f0-8e98-fdfd51e10ba4	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:09.706651	\N	75
89	f041b5b0-a14c-11f0-a6cc-b3145592fdde	f03afef1-a14c-11f0-a6cc-b3145592fdde	11769334649	5905806208429	Panel ścienny tapicerowany pan1x60x30	1	64.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:03.693467	\N	91
97	b661cf00-a134-11f0-8323-6df02f435f6c	b6576ec0-a134-11f0-8323-6df02f435f6c	12487659714	5905204699591	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 Lancelot	1	1286.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:15.60664	\N	99
9237	ce8de6e0-a4fe-11f0-961e-6d069f850ff8	ce875730-a4fe-11f0-961e-6d069f850ff8	17731209472	\N	Szafka na buty VB60x30D1N2 BIAŁY	1	370.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:19.876483	\N	\N
9238	8c2ca9a0-a4f7-11f0-a444-6d64b3cc877f	8c283cd0-a4f7-11f0-a444-6d64b3cc877f	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:21.116625	\N	4281
9239	243cd4e0-a4f3-11f0-a588-b391296a673a	24386810-a4f3-11f0-a588-b391296a673a	15919776759	5905806228861	Komoda Bones 60x36D1N1 SONOMA	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:22.970421	\N	4282
29	56379be0-a225-11f0-a82d-fde841cbe8d5	56326bc0-a225-11f0-a82d-fde841cbe8d5	11711299117	5905806203677	Wieszak ścienny WP60 na ubrania 60cm Sonoma	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:55.275374	\N	36
5	8d77a490-a2a4-11f0-8d49-a16d7ed74f8d	8d6be4c1-a2a4-11f0-8d49-a16d7ed74f8d	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:49.071642	\N	12
7	5bd33960-a29d-11f0-a638-c7e352f2113f	5bcb2310-a29d-11f0-a638-c7e352f2113f	12258666208	5905806216974	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	1	1807.60	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:49.624446	\N	14
8	59852450-a295-11f0-bee6-2fee815ffc9f	597b6050-a295-11f0-bee6-2fee815ffc9f	10983158854	5905806203691	Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów BIAŁY	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:50.028838	\N	15
9241	2cec7420-a4f2-11f0-9da2-81c6f7d897d8	2ce52120-a4f2-11f0-9da2-81c6f7d897d8	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:25.766553	\N	57
9242	a9729de0-a4f1-11f0-a402-d9289fd02c21	a96e3110-a4f1-11f0-a402-d9289fd02c21	17533930958	\N	Szafka na buty Supra 30 słupek 30x36 Kaszmir	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:27.218214	\N	\N
9243	3df7e2c0-a4ef-11f0-b9bf-2795de008363	3ded5b70-a4ef-11f0-b9bf-2795de008363	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	335.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:28.564613	\N	34
9244	b8cfe420-a4ea-11f0-b89d-d9b346103272	b8c50eb0-a4ea-11f0-b89d-d9b346103272	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:29.989278	\N	12
9245	5ce2e000-a4df-11f0-961e-6d069f850ff8	5cdbdb20-a4df-11f0-961e-6d069f850ff8	12224099030	5905204699249	Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma	1	884.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:31.441819	\N	4287
9246	6d4c85d0-a4db-11f0-a444-6d64b3cc877f	6d47a3d0-a4db-11f0-a444-6d64b3cc877f	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:32.852629	\N	71
9305	cad06af0-a454-11f0-a471-6bb0586de370	cac93f00-a454-11f0-a471-6bb0586de370	10862932479	5905806209532	Szafka komoda na buty 80x30 D2N1 Altus BIAŁY	1	532.60	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:55.297684	\N	4345
9306	71cfc9a0-a44f-11f0-a4f0-7ba876f09f6f	71c4a610-a44f-11f0-a4f0-7ba876f09f6f	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:56.822981	\N	41
9307	3b69b380-a44f-11f0-88a6-1f93f938b7b3	3b62aea0-a44f-11f0-88a6-1f93f938b7b3	15178440255	5905806210118	Szafka komoda na buty 80x36 D2N2 Altus ARTISAN	1	636.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:58.363732	\N	4347
9308	25b7bdb0-a446-11f0-9322-81ad33e97c6b	25b23f70-a446-11f0-9322-81ad33e97c6b	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:59.964151	\N	23
9309	8eddd0e0-a43c-11f0-96d3-f7121b08a32c	8ed915f0-a43c-11f0-96d3-f7121b08a32c	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:01.533573	\N	4349
9310	c0ad0550-a432-11f0-a6cc-b3145592fdde	c0a51610-a432-11f0-a6cc-b3145592fdde	14655550516	5905806205015	Garderoba 80x30cm SU30 VB-4PAN-WP50 D1N1 Wotan	1	1283.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:03.124553	\N	4350
9311	bce878b1-a431-11f0-af7e-5f793825db67	bce19ae0-a431-11f0-af7e-5f793825db67	15919730348	5905806228830	Komoda Bones 60x30D1N1 SONOMA	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:04.745058	\N	4351
41	6fcc9b40-a20d-11f0-bdc8-e34a18959311	6fc7b940-a20d-11f0-bdc8-e34a18959311	15251020703	5905806218220	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 CZARNY	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:06.790098	\N	48
43	68ef7970-a20b-11f0-b1e3-b7ce882fc700	68eb0ca1-a20b-11f0-b1e3-b7ce882fc700	15258808621	5905806210873	Wieszak ścienny W50 na ubrania 50cm WOTAN	1	169.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:08.266022	\N	50
44	2aff7c30-a208-11f0-a6cc-b3145592fdde	2af87750-a208-11f0-a6cc-b3145592fdde	11957206330	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	1	780.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:09.875236	\N	51
49	c68fea00-a202-11f0-9468-2bd22967b382	c688be11-a202-11f0-9468-2bd22967b382	15155237434	5905806209129	Szafka na buty z szufladą Tres 60x36D2N1 ARTISAN	1	531.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:15.890965	\N	56
9247	550c2350-a4da-11f0-9b0c-e511fc7361fa	55056c90-a4da-11f0-9b0c-e511fc7361fa	15876902214	5905806215175	Szafka nocna 40x36 Nox dwie szuflady schowek CZARNY	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:34.232752	\N	4289
9248	6af85971-a4d7-11f0-8311-bd038e33f1de	6af0df61-a4d7-11f0-8311-bd038e33f1de	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:35.64642	\N	9
9249	a9d70f60-a4cd-11f0-a588-b391296a673a	a9d22d60-a4cd-11f0-a588-b391296a673a	15225620833	5905806213386	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY	1	1705.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:37.044975	\N	4291
9256	05ac2481-a472-11f0-a685-3b2ebe8a80a1	05a100f2-a472-11f0-a685-3b2ebe8a80a1	14705411728	5905806203790	Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma	1	196.30	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:46.842809	\N	28
9257	05ac2481-a472-11f0-a685-3b2ebe8a80a1	05a100f1-a472-11f0-a685-3b2ebe8a80a1	11957206330	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	1	747.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:46.842809	\N	51
9258	d754ab50-a473-11f0-b12e-53a023ce25d9	d74d5850-a473-11f0-b12e-53a023ce25d9	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:48.41784	\N	49
9259	a8a50430-a46e-11f0-b989-75c7faccd1ca	a89e4d70-a46e-11f0-b989-75c7faccd1ca	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	335.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:49.816947	\N	34
9260	95930970-a46c-11f0-a685-3b2ebe8a80a1	958e7590-a46c-11f0-a685-3b2ebe8a80a1	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:51.19413	\N	92
9312	36778280-a431-11f0-8f13-933da22fca3d	36702f81-a431-11f0-8f13-933da22fca3d	16521833793	5905806227130	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1N1 WOTAN BIAŁY	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:06.275499	\N	4352
9313	36778280-a431-11f0-8f13-933da22fca3d	36702f80-a431-11f0-8f13-933da22fca3d	15408455867	5905806218688	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 WOTAN BIAŁY	1	1015.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:06.275499	\N	4353
9253	dfc1f3f0-a47e-11f0-a4f0-7ba876f09f6f	dfb68240-a47e-11f0-a4f0-7ba876f09f6f	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:42.627656	\N	2
9254	88fcb1c0-a47b-11f0-a471-6bb0586de370	88f62210-a47b-11f0-a471-6bb0586de370	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	335.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:44.093976	\N	34
9255	a86e7f50-a478-11f0-8895-094b8cada9e7	a867c890-a478-11f0-8895-094b8cada9e7	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:45.474263	\N	49
9261	2756b3c0-a45e-11f0-9583-47424f8c2810	274f87d0-a45e-11f0-9583-47424f8c2810	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:52.568984	\N	94
118	db0dc990-a07f-11f0-9a42-bb8e9ffafe52	db036950-a07f-11f0-9a42-bb8e9ffafe52	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:28.20184	\N	4281
9262	5da97f10-a455-11f0-b989-75c7faccd1ca	5da1b6e0-a455-11f0-b989-75c7faccd1ca	16271340785	5905806233292	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA	1	368.80	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:53.953576	\N	4304
9314	97ae46f0-a42d-11f0-a6cc-b3145592fdde	97a6a5d0-a42d-11f0-a6cc-b3145592fdde	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:08.004649	\N	41
122	b85b60b0-a066-11f0-96ea-bf4f56b08af2	b856a5c0-a066-11f0-96ea-bf4f56b08af2	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:34.156421	\N	92
9315	83027ce0-a42c-11f0-96ea-bf4f56b08af2	82f7f590-a42c-11f0-96ea-bf4f56b08af2	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:09.582562	\N	12
9324	7ed27320-a3fd-11f0-b1e3-b7ce882fc700	7ecddf40-a3fd-11f0-b1e3-b7ce882fc700	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:23.811542	\N	30
9325	3bc5ddb0-a3d5-11f0-a6cc-b3145592fdde	3bbe63a0-a3d5-11f0-a6cc-b3145592fdde	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:25.56247	\N	71
2688	6189e650-a2d0-11f0-abc1-17dd0035cfdf	61829350-a2d0-11f0-abc1-17dd0035cfdf	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:45.03508	\N	4
1448	aa7dfe50-a2cb-11f0-8144-0ba8ff5b8d19	aa78ce30-a2cb-11f0-8144-0ba8ff5b8d19	16724404597	5905806237191	Szafka na buty VB60x30D1N1 Dąb Estana	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:45.449282	\N	5
689	c301a2d0-a2b5-11f0-abc1-17dd0035cfdf	c2fa28c0-a2b5-11f0-abc1-17dd0035cfdf	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:47.126296	\N	9
9326	bd085b30-a3cd-11f0-bfbd-d3aacc6a2e00	bd041570-a3cd-11f0-bfbd-d3aacc6a2e00	14910130346	5905806204049	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	1	811.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:27.019116	\N	4366
9327	3ccf7490-a3cc-11f0-a6cc-b3145592fdde	3cc896c0-a3cc-11f0-a6cc-b3145592fdde	14910130495	5905806204056	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele BIAŁY	1	811.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:28.488246	\N	4367
9328	bb165360-a3c6-11f0-9d66-3d00eb1ccfed	bb0feac0-a3c6-11f0-9d66-3d00eb1ccfed	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:29.944915	\N	4368
9250	e64fe9b0-a493-11f0-a471-6bb0586de370	e64932f0-a493-11f0-a471-6bb0586de370	14388158414	5905806202694	Garderoba 50x36P2WPB szafka na buty wieszak Sonoma	1	643.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:38.4484	\N	4292
9251	63e21820-a486-11f0-b989-75c7faccd1ca	63dbd690-a486-11f0-b989-75c7faccd1ca	15321913673	5905806216943	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan	1	1750.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:39.841229	\N	4293
9252	04361df1-a480-11f0-bfb1-c5232bd647f2	04305191-a480-11f0-bfb1-c5232bd647f2	17358967427	5905806237825	Garderoba 60x36D1N1-4PAN WP szafka na buty wieszak panele Kaszmir	1	835.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:41.242995	\N	4294
9329	877577c0-a3c6-11f0-9a42-bb8e9ffafe52	876a7b41-a3c6-11f0-9a42-bb8e9ffafe52	17532641274	\N	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	4	3.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:31.511017	\N	\N
9330	877577c0-a3c6-11f0-9a42-bb8e9ffafe52	876a7b40-a3c6-11f0-9a42-bb8e9ffafe52	16859419202	5905806210439	Półka ścienna 60x18x20cm WOTAN	1	87.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:31.511017	\N	4369
9332	3f06f230-a3c5-11f0-96ea-bf4f56b08af2	3f028560-a3c5-11f0-96ea-bf4f56b08af2	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	1	2025-10-09 19:34:33.083616	\N	4368
9331	3f06f230-a3c5-11f0-96ea-bf4f56b08af2	3f028561-a3c5-11f0-96ea-bf4f56b08af2	16859419202	5905806210439	Półka ścienna 60x18x20cm WOTAN	1	87.00	PLN	\N	\N	\N	\N	PL	1	2025-10-09 19:34:33.083616	\N	4369
9333	6fe2d080-a3bc-11f0-bfbd-d3aacc6a2e00	6fd785e0-a3bc-11f0-bfbd-d3aacc6a2e00	14383316918	5905806201758	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały	1	1263.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:35.013449	\N	4372
9334	0a1d8ba0-a3b2-11f0-b871-03a75625f948	0a12b630-a3b2-11f0-b871-03a75625f948	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:36.502939	\N	77
9335	8f91a0b0-a3b1-11f0-b1e3-b7ce882fc700	8f862f00-a3b1-11f0-b1e3-b7ce882fc700	16319658329	5905806234398	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	1	674.30	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:37.971936	\N	4361
9336	a1d33ad0-a3ad-11f0-a3bc-ef5c37833579	a1cdbc90-a3ad-11f0-a3bc-ef5c37833579	15319542575	5905806213973	Garderoba 110x36D1N2 Supra30 VB80 4 Panele WP80 WOTAN	1	1645.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:39.487081	\N	4375
9337	a1d33ad0-a3ad-11f0-a3bc-ef5c37833579	a1cdbc91-a3ad-11f0-a3bc-ef5c37833579	17532641274	\N	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	8	3.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:39.487081	\N	\N
117	931ad870-a085-11f0-ba82-ed153ccc4447	9315a850-a085-11f0-ba82-ed153ccc4447	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:26.741725	\N	4380
119	1161a220-a07e-11f0-a6cc-b3145592fdde	115a0100-a07e-11f0-a6cc-b3145592fdde	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:29.679006	\N	94
123	49190450-a066-11f0-b871-03a75625f948	49144960-a066-11f0-b871-03a75625f948	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:35.935596	\N	4349
124	03bcd260-a066-11f0-aafc-c30e0e10a738	03b81770-a066-11f0-aafc-c30e0e10a738	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 08:52:51.907556	\N	4349
103	66a16aa0-a122-11f0-baf0-af7ea74e3d0e	6699c981-a122-11f0-baf0-af7ea74e3d0e	16625973548	5905806222531	Siedzisko tapicerowane 50x29cm do szafki 50x30	1	58.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:22.997025	\N	104
104	015ac010-a122-11f0-9d66-3d00eb1ccfed	01540950-a122-11f0-9d66-3d00eb1ccfed	14387674513	5905806202397	Szafka na buty VB80x36D S1 siedzisko schowek 80cm SO	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:41:24.543023	\N	105
105	a1606580-a120-11f0-9d66-3d00eb1ccfed	a1584f30-a120-11f0-9d66-3d00eb1ccfed	15225857105	5905806206678	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	1	523.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 19:16:53.328786	\N	106
113	45695940-a0a7-11f0-a6cc-b3145592fdde	45619110-a0a7-11f0-a6cc-b3145592fdde	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:21.909094	\N	114
3680	9a4e25d0-a2d2-11f0-a6cc-b3145592fdde	9a46abc0-a2d2-11f0-a6cc-b3145592fdde	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-06 20:34:44.213626	\N	2
9236	268f0bd1-a4ff-11f0-b9bf-2795de008363	2688a331-a4ff-11f0-b9bf-2795de008363	16901480273	5905806234022	Wieszak ścienny WP60 na ubrania 60cm CZARNY WOTAN	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:33:18.40805	\N	4280
9316	a92e4620-a426-11f0-96d3-f7121b08a32c	a9221120-a426-11f0-96d3-f7121b08a32c	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	335.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:11.119521	\N	34
9317	c32a2630-a425-11f0-b1f1-69448e84eb62	c322ac20-a425-11f0-b1f1-69448e84eb62	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:12.650332	\N	92
107	90c6f9c0-a0fb-11f0-bfbd-d3aacc6a2e00	90c2b400-a0fb-11f0-bfbd-d3aacc6a2e00	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 18:52:54.929446	\N	97
109	42cb5c90-a0f9-11f0-baf0-af7ea74e3d0e	42c47ec0-a0f9-11f0-baf0-af7ea74e3d0e	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 18:16:40.471163	\N	77
106	37e72b40-a114-11f0-9e86-bf15ec8cf3e6	37e02660-a114-11f0-9e86-bf15ec8cf3e6	14563824746	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	1	278.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 19:00:55.116661	\N	53
9318	c35e0ed0-a422-11f0-af7e-5f793825db67	c35646a0-a422-11f0-af7e-5f793825db67	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:14.18697	\N	4
108	d0b6e280-a0fa-11f0-b1e3-b7ce882fc700	d0b22790-a0fa-11f0-b1e3-b7ce882fc700	11769094598	5905806204087	Szafka na buty VB100x30D S1 siedzisko schowek 100cm BIAŁY	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 18:44:05.727554	\N	109
114	04ed7ed0-a095-11f0-9468-2bd22967b382	04e679f0-a095-11f0-9468-2bd22967b382	16602440992	5905806234763	Komoda Bini 100x36 D1N1 SONOMA	1	682.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:23.59694	\N	115
9319	ae6b5810-a41e-11f0-8e98-fdfd51e10ba4	ae640510-a41e-11f0-8e98-fdfd51e10ba4	15321911032	5905806216912	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Artisan	1	1750.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:15.671607	\N	4359
9320	76ac5390-a41c-11f0-a40a-ffbafd460211	76a77190-a41c-11f0-a40a-ffbafd460211	17453875719	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:17.210194	\N	57
9321	2b10c010-a412-11f0-b871-03a75625f948	2b052750-a412-11f0-b871-03a75625f948	16319658329	5905806234398	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	1	674.30	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:18.70771	\N	4361
111	e0e984b0-a0f4-11f0-8323-6df02f435f6c	e0e56600-a0f4-11f0-8323-6df02f435f6c	15685820231	5905806221923	Szafka na buty z szufladą Tres 60x30D1N3 CZARNY	1	521.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 17:22:43.502874	\N	112
112	2fefe050-a0e5-11f0-96ea-bf4f56b08af2	2febe8b0-a0e5-11f0-96ea-bf4f56b08af2	16645309565	5905806216813	Szafka na buty VB80x30D1N2 LANCELOT	1	443.00	PLN	\N	\N	\N	\N	PL	0	2025-10-06 17:22:43.709715	\N	113
120	6d6894b0-a07a-11f0-a6cc-b3145592fdde	6d5d7120-a07a-11f0-a6cc-b3145592fdde	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:31.15798	\N	72
115	ce2b1f40-a091-11f0-bfbd-d3aacc6a2e00	ce26b270-a091-11f0-bfbd-d3aacc6a2e00	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:25.112887	\N	13
116	ce2b1f40-a091-11f0-bfbd-d3aacc6a2e00	ce26b271-a091-11f0-bfbd-d3aacc6a2e00	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:25.112887	\N	57
121	2f557250-a067-11f0-9d66-3d00eb1ccfed	2f4df840-a067-11f0-9d66-3d00eb1ccfed	15112696167	5905806208566	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Biały	1	793.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:32.634675	\N	4503
9322	8fee01d0-a40f-11f0-b871-03a75625f948	8fe8aaa0-a40f-11f0-b871-03a75625f948	12258723368	5905806216981	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	1	1887.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:20.228418	\N	4362
9323	4b642d51-a40a-11f0-a6cc-b3145592fdde	4b5cda51-a40a-11f0-a6cc-b3145592fdde	17453875719	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:22.334641	\N	57
9338	7c71b580-a3aa-11f0-a15e-754093089519	7c6a6280-a3aa-11f0-a15e-754093089519	16625971969	5905806222524	Siedzisko tapicerowane 80x29cm do szafki 80x30	1	75.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:41.063664	\N	4376
9339	b1c3ae70-a3a8-11f0-995e-7bc10d9eb16f	b1b83cc0-a3a8-11f0-995e-7bc10d9eb16f	14383316918	5905806201758	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały	1	1263.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:42.565499	\N	4372
9340	d30c2a10-a3a0-11f0-8e98-fdfd51e10ba4	d303ecb0-a3a0-11f0-8e98-fdfd51e10ba4	17636751422	5905806205121	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 SONOMA	1	1263.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:44.063468	\N	4378
9341	470fa2e0-a39f-11f0-9468-2bd22967b382	47073e71-a39f-11f0-9468-2bd22967b382	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:45.591752	\N	2
9342	470fa2e0-a39f-11f0-9468-2bd22967b382	47073e70-a39f-11f0-9468-2bd22967b382	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:45.591752	\N	4380
9343	14e058a0-a39f-11f0-b56d-0ba559d87e46	14d905a1-a39f-11f0-b56d-0ba559d87e46	16602434536	5905806234527	Komoda Bini 50x30x82 D1N1 WOTAN	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:47.220975	\N	4381
9344	14e058a0-a39f-11f0-b56d-0ba559d87e46	14d905a0-a39f-11f0-b56d-0ba559d87e46	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:47.220975	\N	49
9345	5b9f1d40-a39e-11f0-9468-2bd22967b382	5b983f70-a39e-11f0-9468-2bd22967b382	12196226645	5905806203615	Wieszak ścienny WP80 na ubrania 80cm Lancelot	1	278.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:48.866238	\N	4383
9346	f1c974b0-a39d-11f0-8d43-e5c6c6646cd8	f1c1d391-a39d-11f0-8d43-e5c6c6646cd8	15919728876	5905806228793	Komoda Bones 60x36D1N1 ARTISAN	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:50.349499	\N	4384
9347	f1c974b0-a39d-11f0-8d43-e5c6c6646cd8	f1c1d390-a39d-11f0-8d43-e5c6c6646cd8	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:50.349499	\N	4368
9348	1e0e9330-a39d-11f0-9a42-bb8e9ffafe52	1e0396b1-a39d-11f0-9a42-bb8e9ffafe52	15919728876	5905806228793	Komoda Bones 60x36D1N1 ARTISAN	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:51.982135	\N	4384
9349	1e0e9330-a39d-11f0-9a42-bb8e9ffafe52	1e0396b0-a39d-11f0-9a42-bb8e9ffafe52	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:51.982135	\N	4368
9350	0a3ff4a0-a39a-11f0-bfbd-d3aacc6a2e00	0a3bd5f0-a39a-11f0-bfbd-d3aacc6a2e00	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:53.415426	\N	83
9351	d274a930-a399-11f0-a3bc-ef5c37833579	d2701550-a399-11f0-a3bc-ef5c37833579	15319529269	5905806213812	Garderoba 110x36D1N1 Supra30 VB80 4 Panele WP80 CZARNY WOTAN	1	1557.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:54.833203	\N	4389
9352	aa425b30-a397-11f0-8e98-fdfd51e10ba4	aa3a44e0-a397-11f0-8e98-fdfd51e10ba4	15221332021	5905806214130	Szafka na buty z szufladą Tres 50x36 Dąb Wotan	1	447.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:56.309954	\N	4390
9353	8173bb40-a397-11f0-9288-ef897151e2e1	816e3d00-a397-11f0-9288-ef897151e2e1	16276325492	5905806233957	Komoda Bini 60x36D1N1 BIAŁY	1	462.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:57.866778	\N	4391
9354	8a869080-a393-11f0-bc71-87ddccc94446	8a81ae80-a393-11f0-bc71-87ddccc94446	16415944014	5905806231885	Szafka na buty VB100x30D2N1 ARTISAN	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:34:59.370898	\N	4392
9355	e7b9ffb0-a390-11f0-8d43-e5c6c6646cd8	e7b2d3c0-a390-11f0-8d43-e5c6c6646cd8	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:00.89155	\N	92
9356	eec49e50-a38b-11f0-a6cc-b3145592fdde	eebcaf10-a38b-11f0-a6cc-b3145592fdde	16319658329	5905806234398	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	1	674.30	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:02.367047	\N	4361
9357	e173d570-a388-11f0-8e98-fdfd51e10ba4	e16d1eb0-a388-11f0-8e98-fdfd51e10ba4	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:03.842614	\N	4281
9358	523a61d0-a37e-11f0-8d43-e5c6c6646cd8	5233d220-a37e-11f0-8d43-e5c6c6646cd8	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:05.323924	\N	9
9359	8af73a30-a373-11f0-a6cc-b3145592fdde	8aed7630-a373-11f0-a6cc-b3145592fdde	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	1	350.00	PLN	\N	\N	\N	\N	PL	1	2025-10-09 19:35:06.788188	\N	82
9360	d16fb191-a373-11f0-9468-2bd22967b382	d16885a0-a373-11f0-9468-2bd22967b382	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	1	592.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:08.524972	\N	70
9361	04b51c30-a373-11f0-9468-2bd22967b382	04ad5400-a373-11f0-9468-2bd22967b382	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:10.006375	\N	7
9362	79d896e0-a364-11f0-a3bc-ef5c37833579	79d42a10-a364-11f0-a3bc-ef5c37833579	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:11.487078	\N	97
9363	88b45fd1-a357-11f0-bc71-87ddccc94446	88af56c1-a357-11f0-bc71-87ddccc94446	12263585961	5905204699218	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Dąb Sonoma	1	1052.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:12.962774	\N	4401
9364	6b11b120-a353-11f0-a15e-754093089519	6b0a8530-a353-11f0-a15e-754093089519	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:14.481877	\N	65
9365	628c6f80-a34f-11f0-b861-bd1e9af656a8	6287b490-a34f-11f0-b861-bd1e9af656a8	14024671782	5905806201307	Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Lancelot	1	532.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:15.94631	\N	4403
9366	b4dad3c0-a34b-11f0-87ab-43c4d16d6a38	b4d359b0-a34b-11f0-87ab-43c4d16d6a38	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:17.471156	\N	4404
9367	a6aa15b2-a349-11f0-9d2c-bd0fd501dc68	a6a3fb32-a349-11f0-9d2c-bd0fd501dc68	13854397976	5905204699997	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:18.983524	\N	4405
9368	865e98b0-a346-11f0-9fcc-bf32f2dae555	865793d0-a346-11f0-9fcc-bf32f2dae555	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:20.522399	\N	4404
9369	a6fb8ab0-a341-11f0-9a42-bb8e9ffafe52	a6f1c6b0-a341-11f0-9a42-bb8e9ffafe52	16271344068	5905806233490	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:22.641558	\N	4407
9370	dcd790a2-a33e-11f0-b871-03a75625f948	dcd26082-a33e-11f0-b871-03a75625f948	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:24.240742	\N	83
9371	3a93dcb0-a32d-11f0-9d66-3d00eb1ccfed	3a8cd7d0-a32d-11f0-9d66-3d00eb1ccfed	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:25.830315	\N	12
9373	ef3fe2b0-9e02-11f0-96ea-bf4f56b08af2	ef3b4ed0-9e02-11f0-96ea-bf4f56b08af2	12258723368	5905806216981	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	1	1887.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:28.936689	\N	4362
9374	30520490-9d63-11f0-a677-a5b8c1586284	304affb0-9d63-11f0-a677-a5b8c1586284	17358940752	5905806237801	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:30.351716	\N	4411
9375	0e64f410-9d35-11f0-8058-6bb39f24a57a	0e603920-9d35-11f0-8058-6bb39f24a57a	17358940752	5905806237801	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:35:31.762006	\N	4411
21	93c15c40-a233-11f0-a6cc-b3145592fdde	93baa580-a233-11f0-a6cc-b3145592fdde	14705411728	5905806203790	Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma	1	205.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:39:48.761018	\N	28
53	bce3c350-a1f8-11f0-a6cc-b3145592fdde	bcdce580-a1f8-11f0-a6cc-b3145592fdde	13463849818	5905806203813	Wieszak ścienny WP50 ubrania 50cm 4 haki Lancelot	1	205.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:20.304219	\N	60
80	95595a70-a1bc-11f0-a6cc-b3145592fdde	95525591-a1bc-11f0-a6cc-b3145592fdde	11750247503	5905806214208	Szafka na buty z szufladą Tres 80x36D1N1 Biały	1	600.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:40:52.977557	\N	85
9474	2ec843f0-a05b-11f0-819e-1344c439828f	2ebd6e82-a05b-11f0-819e-1344c439828f	12258788829	5905806216936	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Sonoma	1	1827.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:37.640577	\N	4506
9475	2ec843f0-a05b-11f0-819e-1344c439828f	2ebd6e83-a05b-11f0-819e-1344c439828f	11742813479	5905806204025	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele SONOMA	1	776.80	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:37.640577	\N	4507
9476	2ec843f0-a05b-11f0-819e-1344c439828f	2ebd6e81-a05b-11f0-819e-1344c439828f	15446678390	5905806219623	Szafka na buty 60x30D2N1Supra SONOMA	1	1105.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:37.640577	\N	4508
9477	2ec843f0-a05b-11f0-819e-1344c439828f	2ebd6e80-a05b-11f0-819e-1344c439828f	15221504597	5905806214253	Szafka na buty z szufladą Tres 80x36 Dąb Wotan	1	600.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:37.640577	\N	4509
9478	89083cb0-a058-11f0-9468-2bd22967b382	89015ee0-a058-11f0-9468-2bd22967b382	15225574066	5905806213461	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY BIAŁY	1	1705.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:39.753389	\N	4510
9479	f6464f80-a056-11f0-bc87-8159fe565898	f63e1220-a056-11f0-bc87-8159fe565898	15321913673	5905806216943	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan	1	1827.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:41.570887	\N	4293
9480	a7a598b0-a054-11f0-8e98-fdfd51e10ba4	a79e45b0-a054-11f0-8e98-fdfd51e10ba4	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:43.152649	\N	41
9481	19d100b0-a054-11f0-b871-03a75625f948	19cc45c1-a054-11f0-b871-03a75625f948	16383693560	5905806234046	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój BIAŁY	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:44.773914	\N	4513
9482	19d100b0-a054-11f0-b871-03a75625f948	19cc45c0-a054-11f0-b871-03a75625f948	17567410245	\N	Poduszka ozdobna, dekoracyjna 50x30cm	1	37.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:44.773914	\N	\N
9483	c1c0f760-a042-11f0-8c4d-9bd96e1ccd86	c1bba030-a042-11f0-8c4d-9bd96e1ccd86	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:46.497018	\N	57
9484	029c0ad0-a03f-11f0-bc5e-258a5e1e619a	029505f0-a03f-11f0-bc5e-258a5e1e619a	15229738794	5905806214574	Szafka na buty z szufladą Tres 100x36D1N1 WOTAN	1	611.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:48.104858	\N	4515
9485	b3746960-a03f-11f0-8737-b36df7580750	b369bb00-a03f-11f0-8737-b36df7580750	15410023447	5905806218879	Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan	1	1123.60	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:49.691873	\N	4516
9486	933c1fe0-a034-11f0-ba82-ed153ccc4447	93373de0-a034-11f0-ba82-ed153ccc4447	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:51.327492	\N	98
9487	c96f6d90-a031-11f0-8e98-fdfd51e10ba4	c967f380-a031-11f0-8e98-fdfd51e10ba4	16644957145	5905806204179	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele WOTAN	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:52.87265	\N	4518
9488	0b578860-a027-11f0-93a2-8fc85806f760	0b50d1a0-a027-11f0-93a2-8fc85806f760	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:54.443322	\N	7
9489	6a50f510-a025-11f0-bc5e-258a5e1e619a	6a4a1740-a025-11f0-bc5e-258a5e1e619a	15221503220	5905806214192	Szafka na buty z szufladą Tres 80x30 Dąb Wotan	1	564.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:56.006326	\N	33
9490	a9ba08f0-9fd4-11f0-9468-2bd22967b382	a9b37940-9fd4-11f0-9468-2bd22967b382	15315950401	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	1	611.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:57.528802	\N	66
9491	839dfc50-9fc8-11f0-9d66-3d00eb1ccfed	8396a950-9fc8-11f0-9d66-3d00eb1ccfed	15440332407	5905806218176	Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko ARTISAN	1	1023.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:52:59.035883	\N	4522
9492	70857c70-9fc7-11f0-9d66-3d00eb1ccfed	707e9ea0-9fc7-11f0-9d66-3d00eb1ccfed	15315961595	5905806214673	Szafka na buty z szufladą Tres 100x30D1N1 BIAŁY	1	587.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:00.995018	\N	4523
9494	a248daf0-9fc6-11f0-8c53-b9e6d89e658e	a241d610-9fc6-11f0-8c53-b9e6d89e658e	10945431249	5905806208191	Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały	1	332.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:02.566909	\N	4525
9495	91d17a80-9fbf-11f0-8234-ff8a51029ee2	91cc9880-9fbf-11f0-8234-ff8a51029ee2	12258723368	5905806216981	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	1	1887.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:04.368113	\N	4362
9496	42529150-9fc0-11f0-8509-57e61af36c1f	424b1740-9fc0-11f0-8509-57e61af36c1f	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	1	462.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:05.921164	\N	4527
9497	4c292230-9fb0-11f0-b42c-9325c9d7bd4d	4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d	15155167503	5905806208443	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:07.494846	\N	4270
9498	7862c470-9fae-11f0-8d27-959e7a05a75b	785dbb60-9fae-11f0-8d27-959e7a05a75b	12266508963	5905204699102	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:08.982673	\N	4274
9499	c8cc0a70-9fa9-11f0-9a42-bb8e9ffafe52	c8c357e0-9fa9-11f0-9a42-bb8e9ffafe52	12476571893	5905204699492	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Biały	1	1015.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:10.465002	\N	4530
9500	035de560-9fa9-11f0-9d66-3d00eb1ccfed	0356e080-9fa9-11f0-9d66-3d00eb1ccfed	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:11.994259	\N	83
9501	e451b440-9fa7-11f0-8e98-fdfd51e10ba4	e44aaf60-9fa7-11f0-8e98-fdfd51e10ba4	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:13.524776	\N	4349
9502	e194c910-9fa5-11f0-ad8a-5d9c081a41b2	e18d9d21-9fa5-11f0-ad8a-5d9c081a41b2	16602441323	5905806234770	Komoda Bini 100x36 D1N1 WOTAN	1	682.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:15.032791	\N	4533
9503	87ed6070-9fa0-11f0-89e4-21adac12f2a9	87e8a580-9fa0-11f0-89e4-21adac12f2a9	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:16.741965	\N	92
9504	65161d90-9f9f-11f0-8234-ff8a51029ee2	651189b0-9f9f-11f0-8234-ff8a51029ee2	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	1	478.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:18.25358	\N	1
9505	ed2acaf0-9f9a-11f0-9d66-3d00eb1ccfed	ed23c610-9f9a-11f0-9d66-3d00eb1ccfed	15440329487	5905806217995	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko SONOMA	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:19.823755	\N	4536
9506	c0eec9a0-9f9a-11f0-8509-57e61af36c1f	c0e5a1e1-9f9a-11f0-8509-57e61af36c1f	15251019919	5905806204162	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 WOTAN	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:21.391471	\N	4537
9507	c0eec9a0-9f9a-11f0-8509-57e61af36c1f	c0e5a1e0-9f9a-11f0-8509-57e61af36c1f	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	1	592.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:21.391471	\N	70
9508	2f4e0e71-9f9a-11f0-96ea-bf4f56b08af2	2f47cce2-9f9a-11f0-96ea-bf4f56b08af2	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:23.050134	\N	13
9509	2f4e0e71-9f9a-11f0-96ea-bf4f56b08af2	2f47cce1-9f9a-11f0-96ea-bf4f56b08af2	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:23.050134	\N	4404
9510	ec7230b0-9f97-11f0-86d6-599d2223cd68	ec69f350-9f97-11f0-86d6-599d2223cd68	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:24.66678	\N	49
9511	2204e780-9f67-11f0-a6ba-19e7472c74e3	2200c8d0-9f67-11f0-a6ba-19e7472c74e3	16383698094	5905806234084	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój CZARNY	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:26.173347	\N	4542
9512	b004e730-9f65-11f0-8234-ff8a51029ee2	affef3c0-9f65-11f0-8234-ff8a51029ee2	15134391509	5905806209372	Szafka 60x30D1N2 komoda wysoka Supra T2 BIAŁY CZARNY	1	1016.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:27.696527	\N	4543
9513	2bf328a0-9f63-11f0-8509-57e61af36c1f	2beb8780-9f63-11f0-8509-57e61af36c1f	15225857105	5905806206678	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	1	523.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:29.220197	\N	106
9514	8a61c600-9f57-11f0-8509-57e61af36c1f	8a5ac120-9f57-11f0-8509-57e61af36c1f	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:53:30.70906	\N	93
9516	e8756a60-9f04-11f0-bfbd-d3aacc6a2e00	e870d680-9f04-11f0-bfbd-d3aacc6a2e00	12266500239	5905204699126	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele SONOMA	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:32.292077	\N	4547
9517	a1e0a350-9f02-11f0-b871-03a75625f948	a1dbe860-9f02-11f0-b871-03a75625f948	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:33.686565	\N	7
9518	c68f7410-9efd-11f0-88a7-41bf7e4bf551	c686e890-9efd-11f0-88a7-41bf7e4bf551	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:35.082567	\N	4380
9519	7cab93f0-9ef9-11f0-a910-6fc8854d80a9	7ca46800-9ef9-11f0-a910-6fc8854d80a9	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	1	454.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:36.504283	\N	87
9520	53444b90-9efb-11f0-9e10-59ae2eaec9de	533d46b0-9efb-11f0-9e10-59ae2eaec9de	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:37.890424	\N	4551
9522	506a6d11-9efa-11f0-a6cc-b3145592fdde	5062f301-9efa-11f0-a6cc-b3145592fdde	17736467450	\N	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:40.880156	\N	\N
9523	506a6d11-9efa-11f0-a6cc-b3145592fdde	5062f300-9efa-11f0-a6cc-b3145592fdde	17358870548	5905806237849	Szafka na buty z szufladą Tres 30x36D1N1 Kaszmir	1	363.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:40.880156	\N	4553
9524	9c74d050-9ef6-11f0-b1e3-b7ce882fc700	9c695ea0-9ef6-11f0-b1e3-b7ce882fc700	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:42.365344	\N	2
9525	a6a4ce00-9ef5-11f0-817a-fb3753e68c2d	a69df030-9ef5-11f0-817a-fb3753e68c2d	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:43.629286	\N	7
9526	a07eb210-9ef1-11f0-9dc3-f9a3debc1314	a0795ae0-9ef1-11f0-9dc3-f9a3debc1314	17475498034	\N	Szafka na buty z siedziskiem i schowkiem VB80x30D1N1 Dąb Estana	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:45.005664	\N	\N
9527	9eabe350-9ef0-11f0-88a7-41bf7e4bf551	9ea46940-9ef0-11f0-88a7-41bf7e4bf551	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:46.384312	\N	93
9528	ebf4b2a0-9eef-11f0-9efe-27a29450b6fd	ebefa990-9eef-11f0-9efe-27a29450b6fd	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:47.728981	\N	41
9529	302ccc60-9eef-11f0-9dc3-f9a3debc1314	30285f90-9eef-11f0-9dc3-f9a3debc1314	12405971238	5905204699140	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Biały	1	1136.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:49.168469	\N	4558
9530	0999c490-9eef-11f0-96ea-bf4f56b08af2	099509a0-9eef-11f0-96ea-bf4f56b08af2	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:50.506069	\N	4404
9532	d9e76130-9eee-11f0-b465-492415e4339b	d9e03540-9eee-11f0-b465-492415e4339b	11769341228	5905806208412	Panel ścienny tapicerowany pan1x80x30	1	75.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:51.957313	\N	4561
9533	1fad91d0-9eea-11f0-96ea-bf4f56b08af2	1fa29550-9eea-11f0-96ea-bf4f56b08af2	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	382.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:53.308922	\N	9
9534	304bca40-9ee8-11f0-a30a-89acbba18695	3046e840-9ee8-11f0-a30a-89acbba18695	15176152026	5905806212952	Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:54.685248	\N	62
9535	1c67b9d0-9ee3-11f0-9dc3-f9a3debc1314	1c637410-9ee3-11f0-9dc3-f9a3debc1314	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:56.000052	\N	23
9536	7421cf30-9ed9-11f0-b465-492415e4339b	741a7c31-9ed9-11f0-b465-492415e4339b	17477972814	5905806238716 	Garderoba 80x36D1N1 Supra30Tres50 3PAN WP50 KASZMIR	1	1373.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:57.338125	\N	4565
9537	7421cf30-9ed9-11f0-b465-492415e4339b	741a7c30-9ed9-11f0-b465-492415e4339b	17478159653	5905806238679	Zestaw Tres60x36D1N1 3PAN WP60 KASZMIR	1	857.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:57.338125	\N	4566
9538	a8520470-9ed7-11f0-bfbd-d3aacc6a2e00	a84cd450-9ed7-11f0-bfbd-d3aacc6a2e00	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:58.835539	\N	4404
9539	38ccaba0-9ed7-11f0-a7f2-a59be15353c3	38c53190-9ed7-11f0-a7f2-a59be15353c3	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:00.131947	\N	83
9540	10ac49e0-9ed3-11f0-a0f2-ad990a13a62d	10a4f6e0-9ed3-11f0-a0f2-ad990a13a62d	11873257937	5905806208351	Szafka na buty z szufladą Tres 60x36 Dąb Sonoma	1	434.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:01.41938	\N	4569
9541	d60883b0-9eca-11f0-b1e3-b7ce882fc700	d603c8c0-9eca-11f0-b1e3-b7ce882fc700	10862951244	5905806209020	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	1	471.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:02.766441	\N	27
9560	9162c891-997c-11f0-b7ad-bf8cbe88f0cf	915b4e80-997c-11f0-b7ad-bf8cbe88f0cf	15193798429	5905806213133	Garderoba 100x36cm Supra50 VB50 4 Panele WP50 D1N1 Biały	1	1704.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:54:36.654006	\N	4589
9515	1b962310-9f11-11f0-9d66-3d00eb1ccfed	1b8f9360-9f11-11f0-9d66-3d00eb1ccfed	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:30.606999	\N	71
9521	19377490-9efb-11f0-96ea-bf4f56b08af2	19329290-9efb-11f0-96ea-bf4f56b08af2	15221504597	5905806214253	Szafka na buty z szufladą Tres 80x36 Dąb Wotan	1	600.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:39.284741	\N	4509
9531	0999c490-9eef-11f0-96ea-bf4f56b08af2	099509a1-9eef-11f0-96ea-bf4f56b08af2	15258837181	5905806211023	Wieszak ścienny W60 na ubrania 60cm LANCELOT	1	193.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:56:50.506069	\N	4560
9542	e55fb2a0-9ec7-11f0-a30a-89acbba18695	e55ad0a0-9ec7-11f0-a30a-89acbba18695	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:04.087597	\N	4368
9543	cf3fa2a0-9ec7-11f0-9d66-3d00eb1ccfed	cf384fa0-9ec7-11f0-9d66-3d00eb1ccfed	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:05.397666	\N	12
9544	4dc92860-9ec5-11f0-9e10-59ae2eaec9de	4dc1d560-9ec5-11f0-9e10-59ae2eaec9de	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:06.705213	\N	4551
9545	ab770670-9ebc-11f0-96ea-bf4f56b08af2	ab724b80-9ebc-11f0-96ea-bf4f56b08af2	16271343737	5905806233476	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 LANCELOT	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:08.02041	\N	4574
9546	3099f270-9eb5-11f0-8bdf-5dc6c72e14d7	30933bb0-9eb5-11f0-8bdf-5dc6c72e14d7	16602434536	5905806234527	Komoda Bini 50x30x82 D1N1 WOTAN	2	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:09.349826	\N	4381
9547	40166730-9eb3-11f0-908e-ff3baa2fe7b0	400f1430-9eb3-11f0-908e-ff3baa2fe7b0	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:10.639494	\N	7
9548	2e56f660-9eac-11f0-9468-2bd22967b382	2e4f7c50-9eac-11f0-9468-2bd22967b382	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	488.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:12.194263	\N	72
9549	dc70e320-9eaa-11f0-8ace-e54796c9c1e2	dc660db0-9eaa-11f0-8ace-e54796c9c1e2	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	793.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:13.518163	\N	75
9550	81c7cfb0-9eaa-11f0-bc92-992b6815467a	81c1b530-9eaa-11f0-bc92-992b6815467a	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:14.883124	\N	12
9551	5f2c19c0-9eaa-11f0-817a-fb3753e68c2d	5f2514e0-9eaa-11f0-817a-fb3753e68c2d	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	793.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:16.230465	\N	75
9552	f1a501f0-9ea9-11f0-908e-ff3baa2fe7b0	f19d39c0-9ea9-11f0-908e-ff3baa2fe7b0	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	488.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:17.494417	\N	72
9553	779405a0-9ea4-11f0-8996-07b46275101a	778e3940-9ea4-11f0-8996-07b46275101a	15112614579	5905806208504	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Wotan	1	780.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:18.846639	\N	4582
9554	2a06f6d0-9ea4-11f0-9dc3-f9a3debc1314	29fbd340-9ea4-11f0-9dc3-f9a3debc1314	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	793.10	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:20.184865	\N	75
9555	52261250-9ea3-11f0-bc92-992b6815467a	52209410-9ea3-11f0-bc92-992b6815467a	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:21.523599	\N	9
9556	d41ce880-9e97-11f0-8996-07b46275101a	d41854a0-9e97-11f0-8996-07b46275101a	16760747405	5905806236156	Garderoba 80x36D1N2 4PAN szafka na buty wieszak panele ARTISAN	1	1045.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:22.849985	\N	4585
9557	f6358130-9e96-11f0-817a-fb3753e68c2d	f62ea360-9e96-11f0-817a-fb3753e68c2d	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	488.50	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:24.177602	\N	72
9558	62229f70-9e94-11f0-8fc5-3736e68905c7	62172dc0-9e94-11f0-8fc5-3736e68905c7	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:25.539499	\N	94
9605	dfc2f4f0-9e55-11f0-b871-03a75625f948	dfbeaf30-9e55-11f0-b871-03a75625f948	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:26.879438	\N	49
9606	93cb0710-9e3f-11f0-9325-2757f66ce3c4	93c67330-9e3f-11f0-9325-2757f66ce3c4	17736467450	\N	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:28.363695	\N	\N
9607	0dc8aad0-9e37-11f0-8fb0-7b363fae20c7	0dc416f0-9e37-11f0-8fb0-7b363fae20c7	15919629053	5905806228588	Garderoba Bones 120x36D4N1 VB60 3PWP60 SONOMA	1	1540.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:29.728304	\N	4633
9559	40649dc0-9e30-11f0-b286-41f712537da1	405d98e0-9e30-11f0-b286-41f712537da1	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:32.670068	\N	114
10266	db37fc60-a75a-11f0-b9bf-2795de008363	db338f90-a75a-11f0-b9bf-2795de008363	17736445207	\N	Szafka na buty VB60x30D1N1 KASZMIR	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 11:07:37.715441	\N	\N
9608	8f544d00-9e34-11f0-8cf9-590a844f62e8	8f495080-9e34-11f0-8cf9-590a844f62e8	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:31.206095	\N	2
9610	6bba81a0-9e2c-11f0-a459-a9c1a10b0527	6bb1a800-9e2c-11f0-a459-a9c1a10b0527	12266500390	5905204699133	Garderoba 90x30cm VB60 Supra30 4 Panele D1N1 LANCELOT	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:34.124208	\N	4636
9611	9687df20-9e29-11f0-a07b-27f19dcfd61a	9682fd20-9e29-11f0-a07b-27f19dcfd61a	16271340785	5905806233292	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:35.69216	\N	4304
9612	d2623fa0-9e28-11f0-a6cc-b3145592fdde	d25ac590-9e28-11f0-a6cc-b3145592fdde	10945431249	5905806208191	Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały	1	332.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:37.239716	\N	4525
9613	f42c0090-9e1d-11f0-820b-7b684c0899aa	f42522c0-9e1d-11f0-820b-7b684c0899aa	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:38.745835	\N	57
9614	221d3350-9e1b-11f0-8e98-fdfd51e10ba4	22156b20-9e1b-11f0-8e98-fdfd51e10ba4	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:40.882458	\N	4640
9615	881920f1-9e17-11f0-b871-03a75625f948	880cc4e1-9e17-11f0-b871-03a75625f948	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:42.387318	\N	4551
9616	0305dfa0-9e0f-11f0-9fa0-ab34abe0805b	02fe8ca0-9e0f-11f0-9fa0-ab34abe0805b	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:43.912526	\N	41
9617	dc71b140-9e0c-11f0-a758-8bcc0e9ae972	dc6afa80-9e0c-11f0-a758-8bcc0e9ae972	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	1	462.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:45.32572	\N	4527
9618	b291b770-9e03-11f0-9a42-bb8e9ffafe52	b2861eb0-9e03-11f0-9a42-bb8e9ffafe52	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	2	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:46.731225	\N	94
9619	a5d6df40-9dfb-11f0-b871-03a75625f948	a5d22450-9dfb-11f0-b871-03a75625f948	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:48.157165	\N	41
9620	7d54c060-9df5-11f0-8cf9-590a844f62e8	7d4fde60-9df5-11f0-8cf9-590a844f62e8	15155167503	5905806208443	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:49.555196	\N	4270
9621	42171941-9def-11f0-8498-f546d68c9b4c	420f5111-9def-11f0-8498-f546d68c9b4c	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:50.952607	\N	12
9622	d24b4190-9dee-11f0-8dfb-8df075740e6d	d243ee91-9dee-11f0-8dfb-8df075740e6d	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:52.411291	\N	4380
9623	d24b4190-9dee-11f0-8dfb-8df075740e6d	d243ee90-9dee-11f0-8dfb-8df075740e6d	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:52.411291	\N	7
9624	ae763330-9dec-11f0-b286-41f712537da1	ae6eb920-9dec-11f0-b286-41f712537da1	16602435161	5905806234572	Komoda Bini 50x36 D1N1 SONOMA	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:53.994553	\N	4650
9625	0cb72551-9deb-11f0-8cf9-590a844f62e8	0cb131e1-9deb-11f0-8cf9-590a844f62e8	14209799601	5905806201659	Szafka na buty Supra 30x30 D1N1 słupek Wotan	1	532.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:55.455939	\N	4651
9626	7379e230-9de3-11f0-9fa0-ab34abe0805b	7372dd50-9de3-11f0-9fa0-ab34abe0805b	15315950401	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	1	611.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:56.94902	\N	66
9627	0c5badf0-9de2-11f0-a07b-27f19dcfd61a	0c56a4e0-9de2-11f0-a07b-27f19dcfd61a	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:57:58.390649	\N	41
9628	3eb44790-9de1-11f0-86f1-176f8757ee95	3eafb3b0-9de1-11f0-86f1-176f8757ee95	17358940752	5905806237801	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:58:00.080525	\N	4411
9629	85dfad80-9ddc-11f0-bfbd-d3aacc6a2e00	85db67c0-9ddc-11f0-bfbd-d3aacc6a2e00	15258837630	5905806211030	Wieszak ścienny W60 na ubrania 60cm ARISTAN	1	193.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:58:01.535305	\N	4655
9630	b5d243a0-9ddb-11f0-956d-ab7d0b07bcfc	b5cd61a0-9ddb-11f0-956d-ab7d0b07bcfc	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	1	454.00	PLN	\N	\N	\N	\N	PL	0	2025-10-09 19:58:03.011366	\N	87
9703	3c44a380-a5aa-11f0-833e-e3bb93fde64a	3c3decc0-a5aa-11f0-833e-e3bb93fde64a	15319529269	5905806213812	Garderoba 110x36D1N1 Supra30 VB80 4 Panele WP80 CZARNY WOTAN	1	1557.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 08:02:28.460366	\N	4389
9674	83e31360-a5a1-11f0-acf3-212576f15d8a	83dc5ca0-a5a1-11f0-acf3-212576f15d8a	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-10 08:02:31.395937	\N	41
9764	c5208260-a5ae-11f0-8399-c1bb86b8e44b	c51cd8e0-a5ae-11f0-8399-c1bb86b8e44b	15048053986	5905806205466	Szafka na buty VB100x36D S1 siedzisko schowek 100cm Wotan	1	546.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 08:02:21.199439	\N	4790
9662	c3a14f50-a554-11f0-a588-b391296a673a	c39d0990-a554-11f0-a588-b391296a673a	16602436084	5905806234619	Komoda Bini 80x30x82 D1N1 CZARNY	1	550.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 06:52:47.535333	\N	4688
9631	093fd080-a54c-11f0-b989-75c7faccd1ca	0938cba0-a54c-11f0-b989-75c7faccd1ca	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 06:52:49.35719	\N	4551
9678	1d2e1650-a5a2-11f0-8c00-69a8c96cc639	1d27adb0-a5a2-11f0-8c00-69a8c96cc639	15919781224	5905806228939	Komoda Bones 50x30D1N1 WOTAN	1	605.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 08:02:29.93418	\N	4704
9765	4eb511a0-a5ad-11f0-a2ef-21d979b3b861	4eb02fa0-a5ad-11f0-a2ef-21d979b3b861	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 08:02:22.700453	\N	4349
9766	0cdf9570-a5ad-11f0-833e-e3bb93fde64a	0cd92cd0-a5ad-11f0-833e-e3bb93fde64a	10983158854	5905806203691	Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów BIAŁY	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 08:02:24.096152	\N	15
9740	ac66e320-a5ab-11f0-b9bf-2795de008363	ac5c34c0-a5ab-11f0-b9bf-2795de008363	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-10 08:02:25.693513	\N	94
9713	7dd21a30-a5aa-11f0-86f8-1b20137f27b1	7dcb8a80-a5aa-11f0-86f8-1b20137f27b1	15319529269	5905806213812	Garderoba 110x36D1N1 Supra30 VB80 4 Panele WP80 CZARNY WOTAN	1	1557.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 08:02:27.085638	\N	4389
9675	8dd7d240-a59f-11f0-8399-c1bb86b8e44b	8dd38c80-a59f-11f0-8399-c1bb86b8e44b	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 08:02:32.946685	\N	93
9787	9f604910-9b28-11f0-b1e3-b7ce882fc700	9f5b8e20-9b28-11f0-b1e3-b7ce882fc700	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:04:52.078521	\N	71
9788	d88190f0-9b0f-11f0-b871-03a75625f948	d87d4b30-9b0f-11f0-b871-03a75625f948	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:04:53.35606	\N	94
9789	e89dc4f0-9b09-11f0-b76a-5bd8a4bc482c	e8997f30-9b09-11f0-b76a-5bd8a4bc482c	16901480801	5905806236439	Wieszak ścienny WP60 na ubrania 60cm ARTISAN CZARNY	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:04:54.445973	\N	4815
9790	54495840-9b05-11f0-a6cc-b3145592fdde	54427a70-9b05-11f0-a6cc-b3145592fdde	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:04:55.583902	\N	12
9791	304aa1d0-9b03-11f0-8e98-fdfd51e10ba4	30434ed0-9b03-11f0-8e98-fdfd51e10ba4	16458883972	5905806221466	Zestaw Tres60x36D1N1 3PAN WP60 SONOMA	1	857.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:04:56.676577	\N	4817
9792	7d9f0380-9afa-11f0-9468-2bd22967b382	7d9825b0-9afa-11f0-9468-2bd22967b382	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:04:57.792072	\N	4640
9793	143ea770-9af9-11f0-993e-ed3f3ef1a290	143aafd0-9af9-11f0-993e-ed3f3ef1a290	10983158854	5905806203691	Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów BIAŁY	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:04:59.177795	\N	15
9794	b970f1d0-9af4-11f0-993e-ed3f3ef1a290	b965ce40-9af4-11f0-993e-ed3f3ef1a290	10862742707	5905806202267	Szafka na buty VB80x30D1N1 SONOMA	1	382.20	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:00.358808	\N	4820
9795	9f9f3660-9af2-11f0-9d66-3d00eb1ccfed	9f985890-9af2-11f0-9d66-3d00eb1ccfed	15229738794	5905806214574	Szafka na buty z szufladą Tres 100x36D1N1 WOTAN	1	611.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:01.522419	\N	4515
9796	f6873c70-9aed-11f0-a6cc-b3145592fdde	f67ed800-9aed-11f0-a6cc-b3145592fdde	11769341228	5905806208412	Panel ścienny tapicerowany pan1x80x30	1	75.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:02.716351	\N	4561
9797	f6873c70-9aed-11f0-a6cc-b3145592fdde	f67ed803-9aed-11f0-a6cc-b3145592fdde	11769354306	5905806222432	Panel ścienny tapicerowany pan1x80x35	3	80.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:02.716351	\N	4823
9798	f6873c70-9aed-11f0-a6cc-b3145592fdde	f67ed801-9aed-11f0-a6cc-b3145592fdde	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:02.716351	\N	9
9799	f6873c70-9aed-11f0-a6cc-b3145592fdde	f67ed802-9aed-11f0-a6cc-b3145592fdde	11711339631	5905806211184	Wieszak ścienny W80 na ubrania 80cm BIAŁY	1	217.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:02.716351	\N	4825
9800	c34e2ee0-9ae3-11f0-993e-ed3f3ef1a290	c3499b00-9ae3-11f0-993e-ed3f3ef1a290	12619279717	5905806229974	Szafka szafa wysoka supra VINI 50x36x202D1-BIA	1	1163.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:04.121767	\N	4826
9801	56a1e050-9adb-11f0-98a2-f73d3272aefa	569d4c70-9adb-11f0-98a2-f73d3272aefa	12619326684	5905806230390	Szafka szafa wysoka supra VINI 50x36x202D1-LAN	1	1163.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:05.295165	\N	4827
9802	d6cb8180-9ad8-11f0-905c-9777b176b77e	d6c6eda0-9ad8-11f0-905c-9777b176b77e	11587466207	5905806204223	Szafka na buty z wieszakiem 60x36WP60 N1D1 Dąb Sonoma	1	526.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:06.540663	\N	4828
9803	9bbaaf60-9ad5-11f0-8e98-fdfd51e10ba4	9badb710-9ad5-11f0-8e98-fdfd51e10ba4	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1332.40	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:07.745165	\N	2
9804	0f0a7db0-9ad6-11f0-bfbd-d3aacc6a2e00	0f052680-9ad6-11f0-bfbd-d3aacc6a2e00	17681537577	5905806202373	Szafka na buty VB80x30D1N1 CZARNY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:08.889367	\N	4830
9805	31f4d460-9acc-11f0-b76a-5bd8a4bc482c	31f04080-9acc-11f0-b76a-5bd8a4bc482c	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:10.085984	\N	41
9806	0c6fa500-9aca-11f0-9afa-2b3a9799076f	0c6348f0-9aca-11f0-9afa-2b3a9799076f	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:11.223239	\N	49
9807	ec999b90-9ac5-11f0-bfbd-d3aacc6a2e00	ec9507b0-9ac5-11f0-bfbd-d3aacc6a2e00	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:12.340337	\N	114
9808	bada71e0-9abd-11f0-b38f-9b7d2fc63178	bad2f7d0-9abd-11f0-b38f-9b7d2fc63178	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:13.464656	\N	4640
9809	bafbf5e0-9ab8-11f0-ac8c-e9906e3d05fd	baf1e3c0-9ab8-11f0-ac8c-e9906e3d05fd	11873257937	5905806208351	Szafka na buty z szufladą Tres 60x36 Dąb Sonoma	2	434.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:14.603879	\N	4569
9810	4e823af0-9aae-11f0-98a2-f73d3272aefa	4e7590c0-9aae-11f0-98a2-f73d3272aefa	15372387033	5905806217919	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko ARTISAN	1	705.90	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:15.750705	\N	4836
9811	7ac7aef1-9aaa-11f0-b76a-5bd8a4bc482c	7abed552-9aaa-11f0-b76a-5bd8a4bc482c	14705402999	5905806203769	Wieszak ścienny WP50 na ubrania 50cm Dąb Wotan	1	205.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:16.887598	\N	4837
9812	47e6db80-9a48-11f0-acef-296b8620eb98	47df3a60-9a48-11f0-acef-296b8620eb98	12266508963	5905204699102	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:18.010102	\N	4274
9813	ce46e0c0-9a53-11f0-aa4b-670b18f2acf3	ce41d7b1-9a53-11f0-aa4b-670b18f2acf3	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:19.145064	\N	12
9814	ce46e0c0-9a53-11f0-aa4b-670b18f2acf3	ce41d7b0-9a53-11f0-aa4b-670b18f2acf3	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:19.145064	\N	13
9815	8b781170-9a48-11f0-9d91-310fed739d04	8b70be70-9a48-11f0-9d91-310fed739d04	15026476159	5905806204742	Szafka na buty VB60x36D S1 siedzisko schowek 60cm CZARNY	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:20.341392	\N	4841
9816	704d7230-9a45-11f0-b2e0-e7b4c74cb84b	70461f30-9a45-11f0-b2e0-e7b4c74cb84b	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:21.488846	\N	12
9817	54a3fea0-9a45-11f0-b2e0-e7b4c74cb84b	549a1390-9a45-11f0-b2e0-e7b4c74cb84b	14933823645	5905806204124	Szafka na buty VB100x30D siedzisko schowek WOTAN	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:22.60755	\N	4843
9818	b90a77d0-9a44-11f0-a0cf-655d3976444d	b9063210-9a44-11f0-a0cf-655d3976444d	14384919344	5905806201826	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:23.761014	\N	4844
9819	3d6c3280-9a44-11f0-b55d-c5913dafd975	3d650690-9a44-11f0-b55d-c5913dafd975	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	793.10	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:24.871428	\N	75
9820	298aa0d0-9a44-11f0-acef-296b8620eb98	298374e0-9a44-11f0-acef-296b8620eb98	14655550516	5905806205015	Garderoba 80x30cm SU30 VB-4PAN-WP50 D1N1 Wotan	1	1283.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:25.990796	\N	4350
9821	73a550c0-9a3a-11f0-b1bc-794ec0214095	73a0e3f0-9a3a-11f0-b1bc-794ec0214095	15121482732	5905806201710	Garderoba 80x30cm SU30 VB-4PAN-WP50 N1 Cza D1 Wotan	1	1283.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:27.116693	\N	4847
9822	2f630d90-9a2a-11f0-8a8f-819744f4cb4b	2f5be1a0-9a2a-11f0-8a8f-819744f4cb4b	12405971611	5905204699171	Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Biały	1	1173.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:28.262313	\N	4848
9823	e3ed6d10-9a29-11f0-9c1c-634c8fb78ee1	e3e64120-9a29-11f0-9c1c-634c8fb78ee1	14387675064	5905806202434	Szafka na buty VB80x36D S1 siedzisko schowek 80cm LANCELOT	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:29.399928	\N	4849
9824	8c5ac160-9a29-11f0-8dbe-7ff68d0cb850	8c534750-9a29-11f0-8dbe-7ff68d0cb850	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:30.52403	\N	12
9825	4c2be490-9a0e-11f0-8dbe-7ff68d0cb850	4c24b8a0-9a0e-11f0-8dbe-7ff68d0cb850	16271344068	5905806233490	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:31.633859	\N	4407
9826	597901c0-9a02-11f0-a494-c34ff42b5735	597160a0-9a02-11f0-a494-c34ff42b5735	12266508806	5905204699096	Garderoba 90x36cm V60 Supra30 4 Panele D1 SO	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:32.744761	\N	4852
9827	95ad4ca0-9a02-11f0-bbaa-c715bb9c3bb4	95a49a10-9a02-11f0-bbaa-c715bb9c3bb4	15179691397	5905806203912	Szafka na buty z szufladą Tres 30x30x82 Dąb Wotan	1	341.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:33.905502	\N	4853
9828	6aa904d0-99fe-11f0-8f9b-4b841337a082	6aa3fbc0-99fe-11f0-8f9b-4b841337a082	15258837630	5905806211030	Wieszak ścienny W60 na ubrania 60cm ARISTAN	1	193.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:35.022959	\N	4655
9829	6aa904d0-99fe-11f0-8f9b-4b841337a082	6aa3fbc1-99fe-11f0-8f9b-4b841337a082	14604283135	5905806203684	Wieszak ścienny WP60 na ubrania 60cm Dąb Artisan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:35.022959	\N	4855
9830	3a7894a0-99fa-11f0-9c1c-634c8fb78ee1	3a70f380-99fa-11f0-9c1c-634c8fb78ee1	17441796662	5905806238471	Szafka na buty z siedziskiem, schowek Vb50x30 D1N1 Dąb Estana	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:36.243704	\N	4856
9831	3f441be0-99f9-11f0-8a8f-819744f4cb4b	3f3c2ca0-99f9-11f0-8a8f-819744f4cb4b	17736463271	\N	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm KASZMIR	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:37.364369	\N	\N
9832	3e46b7d0-99f3-11f0-acef-296b8620eb98	3e3f3dc0-99f3-11f0-acef-296b8620eb98	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:38.439759	\N	92
9833	3e46b7d0-99f3-11f0-acef-296b8620eb98	3e3f3dc1-99f3-11f0-acef-296b8620eb98	15440329487	5905806217995	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko SONOMA	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:38.439759	\N	4536
9834	9824a880-99f2-11f0-a5bd-1108a8254a2c	981da3a0-99f2-11f0-a5bd-1108a8254a2c	15440332407	5905806218176	Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko ARTISAN	1	1023.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:39.657085	\N	4522
9835	ed8bf770-99ec-11f0-acef-296b8620eb98	ed83e120-99ec-11f0-acef-296b8620eb98	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:40.760982	\N	4640
9836	70874450-99ec-11f0-8f9b-4b841337a082	707eb8d1-99ec-11f0-8f9b-4b841337a082	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	2	462.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:41.87223	\N	4527
9837	70874450-99ec-11f0-8f9b-4b841337a082	707eb8d0-99ec-11f0-8f9b-4b841337a082	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	335.20	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:41.87223	\N	34
9838	31d3b380-99ea-11f0-b1bc-794ec0214095	31cf46b0-99ea-11f0-b1bc-794ec0214095	16602435161	5905806234572	Komoda Bini 50x36 D1N1 SONOMA	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:43.080348	\N	4650
9839	e61f4730-99e7-11f0-80ff-cf273d5b30c9	e61a3e20-99e7-11f0-80ff-cf273d5b30c9	16383705242	5905806234183	Komoda szafka NEX 60x36x124 D1N1 sypialnia salon przedpokój WOTAN	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:44.16789	\N	4864
9840	9c5666f0-99d4-11f0-9d91-310fed739d04	9c4fb030-99d4-11f0-9d91-310fed739d04	17358940752	5905806237801	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:45.303072	\N	4411
9841	3b766751-99d3-11f0-af8d-a355c40aec5a	3b71ac61-99d3-11f0-af8d-a355c40aec5a	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:46.420007	\N	98
9842	6fa24c40-99d0-11f0-bbaa-c715bb9c3bb4	6f9af940-99d0-11f0-bbaa-c715bb9c3bb4	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:47.534579	\N	49
9843	3899f820-99cf-11f0-b55d-c5913dafd975	38956440-99cf-11f0-b55d-c5913dafd975	16901470101	5905806211528	Wieszak ścienny WP100 na ubrania 100cm WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:48.634355	\N	921
9844	1cad9a10-99cd-11f0-851b-d74ab869f4ab	1ca8df21-99cd-11f0-851b-d74ab869f4ab	15250476488	5905806215076	Garderoba 110x30D1N1 SUPRA60 TRES50 3PAN-WP50 WOTAN	1	1809.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:49.773175	\N	4869
9845	1cad9a10-99cd-11f0-851b-d74ab869f4ab	1ca8df20-99cd-11f0-851b-d74ab869f4ab	15919776102	5905806228847	Komoda Bones 60x30D1N1 WOTAN	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:49.773175	\N	4870
9846	29e39880-998f-11f0-851b-d74ab869f4ab	29de6860-998f-11f0-851b-d74ab869f4ab	15229738794	5905806214574	Szafka na buty z szufladą Tres 100x36D1N1 WOTAN	1	611.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:51.019538	\N	4515
9847	1ec31e20-9981-11f0-93c9-41e212fc306a	1ebba410-9981-11f0-93c9-41e212fc306a	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:52.112951	\N	7
9848	4d2dd130-997f-11f0-9d91-310fed739d04	4d260900-997f-11f0-9d91-310fed739d04	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:53.211564	\N	41
9849	d9e3e130-997c-11f0-b930-877dd2cd2141	d9d7fa50-997c-11f0-b930-877dd2cd2141	15193798429	5905806213133	Garderoba 100x36cm Supra50 VB50 4 Panele WP50 D1N1 Biały	1	1704.10	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:54.322254	\N	4589
9850	8ae3db10-9974-11f0-b7ad-bf8cbe88f0cf	8ad6bbb0-9974-11f0-b7ad-bf8cbe88f0cf	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	335.20	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:55.431766	\N	34
9851	fa06e510-9973-11f0-b55d-c5913dafd975	fa027840-9973-11f0-b55d-c5913dafd975	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:56.557582	\N	98
9852	b585d0e0-9973-11f0-b398-bbf43c290c18	b58115f0-9973-11f0-b398-bbf43c290c18	15258856313	5905806211177	Wieszak ścienny W80 na ubrania 80cm ARTISAN	1	217.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:57.681164	\N	4877
9853	84f394d0-9973-11f0-af8d-a355c40aec5a	84e75fd0-9973-11f0-af8d-a355c40aec5a	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	335.20	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:05:59.499997	\N	34
9854	81d0bbe0-9971-11f0-8725-2db00e826402	81c7e240-9971-11f0-8725-2db00e826402	11769341228	5905806208412	Panel ścienny tapicerowany pan1x80x30	3	75.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:00.658867	\N	4561
9855	81d0bbe0-9971-11f0-8725-2db00e826402	81c7e241-9971-11f0-8725-2db00e826402	14563824746	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	1	266.30	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:00.658867	\N	53
9856	f847f3d0-996f-11f0-a0cf-655d3976444d	f8438700-996f-11f0-a0cf-655d3976444d	15919776759	5905806228861	Komoda Bones 60x36D1N1 SONOMA	2	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:01.861061	\N	4282
9857	7f322e20-996f-11f0-bdcf-f5e6598d901c	7f2d9a40-996f-11f0-bdcf-f5e6598d901c	15321915196	5905806216998	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Wotan	1	1887.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:02.973804	\N	4882
9858	89828510-996e-11f0-9c1c-634c8fb78ee1	897a20a0-996e-11f0-9c1c-634c8fb78ee1	16859417616	5905806210590	Półka ścienna 80x18x20cm ARTISAN	1	98.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:04.106554	\N	4883
9859	fc7180a0-996c-11f0-bdcf-f5e6598d901c	fc6cc5b0-996c-11f0-bdcf-f5e6598d901c	14209799601	5905806201659	Szafka na buty Supra 30x30 D1N1 słupek Wotan	1	532.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:05.282158	\N	4651
9860	6d4f1340-9969-11f0-b55d-c5913dafd975	6d4a3140-9969-11f0-b55d-c5913dafd975	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:06.424956	\N	49
9861	c7165dc0-995f-11f0-b930-877dd2cd2141	c711f0f0-995f-11f0-b930-877dd2cd2141	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	3	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:07.565248	\N	114
9913	6a382f10-97e4-11f0-aede-817e60f99fcc	6a30dc10-97e4-11f0-aede-817e60f99fcc	16678160899	5905806236781	Szafka na buty z wieszakiem VB100x36WP100 N1D1 Biały	1	860.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:56.557342	\N	4938
9914	c40f1ae0-97e3-11f0-8e9a-934b2f282e95	c40a5ff0-97e3-11f0-8e9a-934b2f282e95	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:57.697894	\N	4349
9915	c7303860-97e0-11f0-8e9a-934b2f282e95	c72b7d70-97e0-11f0-8e9a-934b2f282e95	12487594670	5905204699522	Garderoba 90x30cm Altus60 Supra2 3PanD2N1 Lancelot	1	1497.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:59.491131	\N	4940
9916	313264a0-97e0-11f0-8d2c-07b2a010202c	312aea90-97e0-11f0-8d2c-07b2a010202c	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:00.673569	\N	2
9917	9ac75020-97df-11f0-af8d-a355c40aec5a	9ac2e350-97df-11f0-af8d-a355c40aec5a	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:01.798412	\N	71
9918	746a06b0-97d1-11f0-8e9a-934b2f282e95	74646160-97d1-11f0-8e9a-934b2f282e95	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:02.93287	\N	65
9919	89f657a0-97d0-11f0-9447-998c918710a1	89ee8f70-97d0-11f0-9447-998c918710a1	15197586675	5905806213270	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Czarny	1	1015.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:04.20065	\N	4944
9921	eabdfd00-97c0-11f0-a361-4580bffe9bea	eab8f3f1-97c0-11f0-a361-4580bffe9bea	15919784886	5905806228991	Komoda Bones 50x36D1N1 WOTAN	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:06.455095	\N	347
9922	eabdfd00-97c0-11f0-a361-4580bffe9bea	eab8f3f0-97c0-11f0-a361-4580bffe9bea	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:06.455095	\N	4404
9923	e85e5ef0-97bc-11f0-8e9a-934b2f282e95	e8597cf0-97bc-11f0-8e9a-934b2f282e95	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:07.711963	\N	4281
9924	bead6790-97b7-11f0-a0cf-655d3976444d	bea8d3b0-97b7-11f0-a0cf-655d3976444d	15315951498	5905806214703	Szafka na buty z szufladą Tres 100x36D2N1 SONOMA	1	665.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:08.807329	\N	4949
9925	728a1760-97b6-11f0-9f34-dd75279ca6e9	72829d50-97b6-11f0-9f34-dd75279ca6e9	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:09.942368	\N	41
9926	abbb2e00-97ae-11f0-9076-59c352007ac5	abb365d0-97ae-11f0-9076-59c352007ac5	11957206330	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	1	780.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:11.067172	\N	51
9927	e60f8130-97a1-11f0-b4ff-d384dc24cd83	e60791f0-97a1-11f0-b4ff-d384dc24cd83	17395006524	5905806238310	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:12.171352	\N	350
9928	be5ee420-9790-11f0-a86f-afea5d07ba6b	be56f4e0-9790-11f0-a86f-afea5d07ba6b	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:13.260801	\N	71
9929	3c6ba350-978f-11f0-bf40-d93b8aae3dee	3c675d90-978f-11f0-bf40-d93b8aae3dee	16698543601	5905806237023	Garderoba z lustrem 90x30cm V60 Supra30 4 Panele D1N1 Dąb Wotan	1	1493.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:14.363358	\N	4278
9930	30c3c1c0-9787-11f0-bf40-d93b8aae3dee	30bf2de0-9787-11f0-bf40-d93b8aae3dee	16276324879	5905806233940	Komoda Bini 60x30D1N1 WOTAN	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:15.495914	\N	4955
9931	c00fd400-9786-11f0-9588-2bb9af9f5e5e	c00bb550-9786-11f0-9588-2bb9af9f5e5e	14604283135	5905806203684	Wieszak ścienny WP60 na ubrania 60cm Dąb Artisan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:16.617547	\N	4855
9932	057c0520-977f-11f0-84dc-a77b677a2f6a	0571f300-977f-11f0-84dc-a77b677a2f6a	15372387033	5905806217919	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko ARTISAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:17.733174	\N	4836
9933	29d60250-977e-11f0-8de6-e172c4c355e0	29ce8840-977e-11f0-8de6-e172c4c355e0	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:18.848739	\N	4368
9934	b94103b0-977c-11f0-af8d-a355c40aec5a	b93b5e60-977c-11f0-af8d-a355c40aec5a	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:19.975061	\N	114
9935	0b675310-9764-11f0-9447-998c918710a1	0b609c50-9764-11f0-9447-998c918710a1	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:21.078715	\N	114
9936	72176e20-9763-11f0-9f34-dd75279ca6e9	720e6d70-9763-11f0-9f34-dd75279ca6e9	14024673763	5905806201345	Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Wotan	1	532.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:22.195712	\N	4961
9862	3ce47280-9960-11f0-814f-31557d7cb244	3cdcf870-9960-11f0-814f-31557d7cb244	14209649341	5905806201628	Szafka na buty Supra 30 słupek 30x30 D1N1 Artisan	1	532.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:08.662077	\N	4887
9863	1d2fbea0-995a-11f0-9a0d-210301f9954d	1d2b51d0-995a-11f0-9a0d-210301f9954d	15225570547	5905806213379	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 BIAŁY	1	1705.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:09.834505	\N	63
9864	91f1b000-9959-11f0-acef-296b8620eb98	91ea35f0-9959-11f0-acef-296b8620eb98	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:10.948964	\N	12
9865	84a633c0-9955-11f0-9c1c-634c8fb78ee1	849e6b90-9955-11f0-9c1c-634c8fb78ee1	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:12.062696	\N	114
9866	629a4a70-9944-11f0-9c1c-634c8fb78ee1	62936ca0-9944-11f0-9c1c-634c8fb78ee1	11957206330	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	1	780.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:13.17692	\N	51
9867	780bdde0-9937-11f0-86e6-9981712fa0ed	77ffa8e1-9937-11f0-86e6-9981712fa0ed	12266464744	72144892264	Szafka na buty z szufladą Tres 30x36D1N1 LANCELOT	1	363.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:14.306109	\N	4892
9868	780bdde0-9937-11f0-86e6-9981712fa0ed	77ffa8e0-9937-11f0-86e6-9981712fa0ed	15019336887	10945550283	Szafka na buty z wieszakiem 60x36WP60 N1D1 Dąb Lancelot	1	555.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:14.306109	\N	4893
9869	760e8740-9937-11f0-93c9-41e212fc306a	7603d8e1-9937-11f0-93c9-41e212fc306a	11711322472	5905806211207	Wieszak ścienny W80 na ubrania 80cm Sonoma	1	217.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:15.542125	\N	4894
9870	760e8740-9937-11f0-93c9-41e212fc306a	7603d8e0-9937-11f0-93c9-41e212fc306a	16416064559	5905806231496	Zestaw 160x30 D2N1 Altus80 i VB80 szafka na buty z siedziskiem SONOMA	1	973.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:15.542125	\N	4895
9871	a8913e20-9936-11f0-86e6-9981712fa0ed	a8861a90-9936-11f0-86e6-9981712fa0ed	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:16.774116	\N	41
9872	16cc4e90-9935-11f0-96d9-9329354dd65b	16c6f760-9935-11f0-96d9-9329354dd65b	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:17.891805	\N	41
9873	7fcd3ed0-9931-11f0-9844-05ab8e749ed0	7fc2de90-9931-11f0-9844-05ab8e749ed0	15252962557	5905806215441	Garderoba 50x30D1N1 VB50 4Panele WP50 Dąb Artisan	1	751.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:19.006753	\N	4898
9874	753462a0-9931-11f0-87a5-21e3a348a117	752372b0-9931-11f0-87a5-21e3a348a117	15372387033	5905806217919	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko ARTISAN	1	705.90	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:20.141308	\N	4836
9875	8e3e7fc0-991c-11f0-af8d-a355c40aec5a	8e392890-991c-11f0-af8d-a355c40aec5a	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	1	773.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:21.269184	\N	93
9876	e9e08410-991a-11f0-8f7a-e9e1ea6a5c03	e9dba210-991a-11f0-8f7a-e9e1ea6a5c03	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:22.382075	\N	57
9877	f6860f40-9911-11f0-b930-877dd2cd2141	f6810630-9911-11f0-b930-877dd2cd2141	13854397976	5905204699997	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:23.499748	\N	4405
9878	84612d60-9906-11f0-a62b-45d36ea56312	8457b780-9906-11f0-a62b-45d36ea56312	12170501979	5905806217056	Komoda z szufladami Vini 60x30 D1N1 BIAŁY	1	594.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:24.618966	\N	4903
9879	30977ac0-98bd-11f0-b4ff-d384dc24cd83	309075e0-98bd-11f0-b4ff-d384dc24cd83	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	2	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:25.750688	\N	65
9880	cd030651-98b7-11f0-851b-d74ab869f4ab	ccfe4b61-98b7-11f0-851b-d74ab869f4ab	15121910649	5905806208993	Szafka na buty Supra 30 słupek 30x36 D1N1 Artisan	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:26.865947	\N	4905
9881	417d5cd0-98b6-11f0-851b-d74ab869f4ab	41782cb0-98b6-11f0-851b-d74ab869f4ab	11769266590	5905806218329	Szafka na buty z wieszakiem VB80x36WP80 N1D1 Sonoma	1	701.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:27.999834	\N	4906
9882	63505670-98b4-11f0-97af-5f765086be88	6347f200-98b4-11f0-97af-5f765086be88	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	1	592.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:29.126341	\N	70
9883	4a438390-98b0-11f0-90d3-c79ca01bf92f	4a3ea190-98b0-11f0-90d3-c79ca01bf92f	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:30.254947	\N	7
9884	da538210-98af-11f0-a1f1-f7dbf5017472	da4eee30-98af-11f0-a1f1-f7dbf5017472	11939053008	5905806210903	Wieszak ścienny W50 na ubrania 50cm BIAŁY	1	169.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:31.365566	\N	4909
9885	c215b7a0-98ae-11f0-96af-ed10c88f4a77	c20cde03-98ae-11f0-96af-ed10c88f4a77	10862951244	5905806209020	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	1	471.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:32.502392	\N	27
9886	c215b7a0-98ae-11f0-96af-ed10c88f4a77	c20cde00-98ae-11f0-96af-ed10c88f4a77	12224099030	5905204699249	Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma	1	923.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:32.502392	\N	4287
9887	c215b7a0-98ae-11f0-96af-ed10c88f4a77	c20cde02-98ae-11f0-96af-ed10c88f4a77	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:32.502392	\N	92
9888	c215b7a0-98ae-11f0-96af-ed10c88f4a77	c20cde01-98ae-11f0-96af-ed10c88f4a77	11711299117	5905806203677	Wieszak ścienny WP60 na ubrania 60cm Sonoma	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:32.502392	\N	36
9889	43100460-98ae-11f0-a0cf-655d3976444d	430b2260-98ae-11f0-a0cf-655d3976444d	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:33.846141	\N	7
9890	1c5d66a0-98ae-11f0-90d3-c79ca01bf92f	1c5884a0-98ae-11f0-90d3-c79ca01bf92f	17478159653	5905806238679	Zestaw Tres60x36D1N1 3PAN WP60 KASZMIR	1	857.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:34.958014	\N	4566
9891	78980c00-98ad-11f0-9f34-dd75279ca6e9	7890e010-98ad-11f0-9f34-dd75279ca6e9	15919776102	5905806228847	Komoda Bones 60x30D1N1 WOTAN	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:36.078469	\N	4870
9892	1178ef60-9896-11f0-b570-01c8ce4005c1	1174a9a1-9896-11f0-b570-01c8ce4005c1	15408455867	5905806218688	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 WOTAN BIAŁY	1	1015.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:37.180642	\N	4353
9893	1178ef60-9896-11f0-b570-01c8ce4005c1	1174a9a0-9896-11f0-b570-01c8ce4005c1	16941975822	5905806224856	Szafka na buty VB50x30 D1N1 BIAŁY WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:37.180642	\N	4918
9894	53194ea0-9892-11f0-9f34-dd75279ca6e9	53104df1-9892-11f0-9f34-dd75279ca6e9	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:38.383538	\N	77
9895	53194ea0-9892-11f0-9f34-dd75279ca6e9	53104df0-9892-11f0-9f34-dd75279ca6e9	14563824746	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	1	278.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:38.383538	\N	53
9896	b9cebdb0-988d-11f0-99e3-d7e982300479	b9ca02c0-988d-11f0-99e3-d7e982300479	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:39.560889	\N	7
9897	21fccb60-987b-11f0-b3d5-5da76e44d274	21f74d20-987b-11f0-b3d5-5da76e44d274	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:40.662435	\N	34
9898	ec5f4eb2-9875-11f0-b570-01c8ce4005c1	ec545232-9875-11f0-b570-01c8ce4005c1	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:41.775277	\N	41
9899	cbcf7380-9863-11f0-90d3-c79ca01bf92f	cbc98010-9863-11f0-90d3-c79ca01bf92f	13854397976	5905204699997	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:42.875146	\N	4405
9900	1fa28de0-985e-11f0-8d2c-07b2a010202c	1f9a9ea0-985e-11f0-8d2c-07b2a010202c	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:43.987168	\N	4404
9901	cb102381-9855-11f0-84dc-a77b677a2f6a	cb02dd11-9855-11f0-84dc-a77b677a2f6a	15112614579	5905806208504	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Wotan	1	780.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:45.08619	\N	4582
9902	ca8f45a0-9853-11f0-a2fa-3f11a044b83d	ca89ee70-9853-11f0-a2fa-3f11a044b83d	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:46.188299	\N	94
9903	31aee0d0-9852-11f0-b55d-c5913dafd975	31a9b0b1-9852-11f0-b55d-c5913dafd975	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:47.281936	\N	12
9904	31aee0d0-9852-11f0-b55d-c5913dafd975	31a9b0b0-9852-11f0-b55d-c5913dafd975	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:47.281936	\N	13
9905	c0d28380-9851-11f0-90d3-c79ca01bf92f	c0cc1ae1-9851-11f0-90d3-c79ca01bf92f	15462816021	5905806203783	Garderoba 140x30cm V60 Supra80 4 Panele D1N1 Dąb Wotan	1	2081.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:48.465439	\N	4930
9906	c0d28380-9851-11f0-90d3-c79ca01bf92f	c0cc1ae0-9851-11f0-90d3-c79ca01bf92f	15376846701	5905806218336	Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Wotan	1	1015.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:48.465439	\N	4931
9907	532bb610-984e-11f0-84dc-a77b677a2f6a	53232a90-984e-11f0-84dc-a77b677a2f6a	16624573640	5905806222517	Siedzisko tapicerowane 80x34cm do szafki 80x36	1	83.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:49.72532	\N	4932
9908	35e22e10-9801-11f0-8d2c-07b2a010202c	35dab400-9801-11f0-8d2c-07b2a010202c	12473744209	5905204699270	Garderoba 140x30cm V60 Supra80 4 Panele D1N1 Biały	1	1947.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:50.872419	\N	4933
9909	288f4de0-97f4-11f0-b6af-bb22abd5a541	288821f0-97f4-11f0-b6af-bb22abd5a541	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:52.039093	\N	4
9910	947e7280-97f2-11f0-a86f-afea5d07ba6b	94765c30-97f2-11f0-a86f-afea5d07ba6b	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:53.142032	\N	4281
9911	10c69e50-97f1-11f0-b6af-bb22abd5a541	10bf7260-97f1-11f0-b6af-bb22abd5a541	11750292362	5905806214024	Szafka na buty z szufladą Tres 50x30 Biały	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:54.278609	\N	4936
9912	ddecb5d0-97e8-11f0-9f02-6d91e0050fd1	dde7d3d0-97e8-11f0-9f02-6d91e0050fd1	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	1	462.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:06:55.42166	\N	4527
9920	9ebd12d0-97c8-11f0-9481-5f95c6e804a5	9eb830d0-97c8-11f0-9481-5f95c6e804a5	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:07:05.33329	\N	12
9937	68c543e0-8e7d-11f0-a0cf-655d3976444d	68beb430-8e7d-11f0-a0cf-655d3976444d	17395006524	5905806238310	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:12.252069	\N	350
9938	60eda000-8e7c-11f0-af8d-a355c40aec5a	60e73760-8e7c-11f0-af8d-a355c40aec5a	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:13.768633	\N	82
9939	b2925390-8e74-11f0-aa1b-13ad1f244880	b28b0091-8e74-11f0-aa1b-13ad1f244880	11769334649	5905806208429	Panel ścienny tapicerowany pan1x60x30	1	64.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:15.281997	\N	91
9940	b2925390-8e74-11f0-aa1b-13ad1f244880	b28b0090-8e74-11f0-aa1b-13ad1f244880	11750299498	5905806229042	Szafka na buty z szufladą i siedziskiem 60x36DP3B	1	1128.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:15.281997	\N	4965
9941	424b24a0-8e64-11f0-9661-81d63d825764	4244e310-8e64-11f0-9661-81d63d825764	11939053008	5905806210903	Wieszak ścienny W50 na ubrania 50cm BIAŁY	1	169.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:16.944249	\N	4909
9942	36b91b60-8e64-11f0-983b-35adfde55ba2	36b23d90-8e64-11f0-983b-35adfde55ba2	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	1	788.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:18.401888	\N	4380
9943	d77dae90-8e63-11f0-93e3-59d3457a2277	d7779410-8e63-11f0-93e3-59d3457a2277	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:19.848117	\N	41
9944	fb2f5440-8e56-11f0-983b-35adfde55ba2	fb289d80-8e56-11f0-983b-35adfde55ba2	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:21.318813	\N	75
9945	cdead5e0-8e51-11f0-9d9f-e176fe4b7fab	cde1fc40-8e51-11f0-9d9f-e176fe4b7fab	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:22.772886	\N	4281
9946	b9510b00-8e41-11f0-983b-35adfde55ba2	b94b3ea0-8e41-11f0-983b-35adfde55ba2	11743135331	5905806202663	Garderoba 50x36P2WPB szafka na buty wieszak panele	1	643.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:24.239043	\N	4971
9947	13898ab0-8e34-11f0-9847-878997e4dbc8	1382fb00-8e34-11f0-9847-878997e4dbc8	11873260685	5905806214246	Szafka na buty z szufladą Tres 80x82x36 SONOMA	1	600.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:25.736352	\N	35
9948	fd58d5b0-8e2f-11f0-9d9f-e176fe4b7fab	fd52bb30-8e2f-11f0-9d9f-e176fe4b7fab	12266488350	5905204699119	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele BIAŁY	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:27.183737	\N	4973
9949	e87bf410-8e2f-11f0-9847-878997e4dbc8	e873b6b0-8e2f-11f0-9847-878997e4dbc8	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	1	434.90	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:28.671307	\N	87
9950	b4717e00-8e2b-11f0-a05c-253781009547	b46b6380-8e2b-11f0-a05c-253781009547	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:30.173338	\N	4368
9951	39e74820-8e28-11f0-b55d-c5913dafd975	39e1a2d0-8e28-11f0-b55d-c5913dafd975	16772019498	5905806227147	Garderoba 90x30D1N2 SUPRA30 VB-4PAN-WP60 ARTISAN	1	1431.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:31.690864	\N	4976
9952	36a743e0-8e1e-11f0-a1aa-7ff8f29e1c92	36a10250-8e1e-11f0-a1aa-7ff8f29e1c92	16271344068	5905806233490	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:33.20268	\N	4407
9953	a4c122a0-8e1a-11f0-b55d-c5913dafd975	a4bb7d51-8e1a-11f0-b55d-c5913dafd975	15179532455	5905806212990	Szafka komoda na buty 50x36 D2N1 Altus Czarny	1	508.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:34.702378	\N	4978
9954	a4c122a0-8e1a-11f0-b55d-c5913dafd975	a4bb7d50-8e1a-11f0-b55d-c5913dafd975	14384926044	5905806201970	Szafka na buty VB50x36 D1N1 siedzisko 50cm Czarny	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:34.702378	\N	4979
9955	4423ffc0-8e16-11f0-a0cf-655d3976444d	441e0c50-8e16-11f0-a0cf-655d3976444d	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	1	462.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:36.401865	\N	4527
9956	54d06900-8e14-11f0-b896-03595c2585cc	54ca4e80-8e14-11f0-b896-03595c2585cc	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	1	462.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:37.870699	\N	4527
9957	85659a00-8e0e-11f0-a5da-275c3afcdf47	855ac490-8e0e-11f0-a5da-275c3afcdf47	11750203551	5905806208344	Szafka na buty z szufladą Tres 60x36 Biały	1	434.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:39.351059	\N	84
9958	fd85c700-8e0c-11f0-ade3-bbd58d1494c3	fd7c7830-8e0c-11f0-ade3-bbd58d1494c3	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	705.90	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:40.792367	\N	4404
9959	71960de0-8e07-11f0-8d2c-07b2a010202c	718f5720-8e07-11f0-8d2c-07b2a010202c	12258787126	5905806216929	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Biały	1	1827.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:42.263184	\N	4984
9960	9caaa670-8d68-11f0-af8d-a355c40aec5a	9ca4da10-8d68-11f0-af8d-a355c40aec5a	17499098907	\N	Szafka na buty VB60x30D1N1 CZARNY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:43.751274	\N	\N
9961	65cb6780-a5b8-11f0-b9cd-8fc0f1f312f6	65c09210-a5b8-11f0-b9cd-8fc0f1f312f6	17532641274	\N	Nóżka 2cmN1 z tworzywa sztucznego CZARNY	4	3.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:45.056978	\N	\N
9962	65cb6780-a5b8-11f0-b9cd-8fc0f1f312f6	65c09211-a5b8-11f0-b9cd-8fc0f1f312f6	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:45.056978	\N	41
9963	7f412a20-8717-11f0-bd05-1f77e3d5b44f	7f3b5dc0-8717-11f0-bd05-1f77e3d5b44f	11873232153	5905806214062	Szafka na buty z szufladą Tres 50x30 Dąb Sonoma	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:45.492832	\N	4986
9964	593890b0-8cf9-11f0-aeeb-f5bb2ff9b6b9	59333980-8cf9-11f0-aeeb-f5bb2ff9b6b9	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:47.236708	\N	4404
9965	e88172d0-8cf1-11f0-9224-234d838556fa	e87b5850-8cf1-11f0-9224-234d838556fa	11711331990	5905806211047	Wieszak ścienny W60 na ubrania 60cm BIAŁY	1	193.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:48.547713	\N	4988
9967	85964570-8ce6-11f0-bd84-15a8b9b09182	858f8eb0-8ce6-11f0-bd84-15a8b9b09182	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:50.844741	\N	4551
9968	6ce48ae0-8ce2-11f0-b999-71a0193671a8	6cd129f1-8ce2-11f0-b999-71a0193671a8	16602435161	5905806234572	Komoda Bini 50x36 D1N1 SONOMA	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:51.984445	\N	4650
9969	6ce48ae0-8ce2-11f0-b999-71a0193671a8	6cd129f0-8ce2-11f0-b999-71a0193671a8	15919776759	5905806228861	Komoda Bones 60x36D1N1 SONOMA	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:51.984445	\N	4282
9970	6ce48ae0-8ce2-11f0-b999-71a0193671a8	6cd129f2-8ce2-11f0-b999-71a0193671a8	12266416456	5905806208979	Szafka na buty Supra 30 słupek 30x36 D1N1 Sonoma	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:51.984445	\N	4993
9971	db6bb4f0-8cdf-11f0-a374-2b3f33c8293d	db657360-8cdf-11f0-a374-2b3f33c8293d	10862951244	5905806209020	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	1	471.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:53.327035	\N	27
9972	3e61d540-8cdf-11f0-928c-89798a350f7d	3e5bbac0-8cdf-11f0-928c-89798a350f7d	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:54.473445	\N	7
9973	73ffe071-8cdf-11f0-8eac-3373db8fdde9	73f88d71-8cdf-11f0-8eac-3373db8fdde9	15919778228	5905806228885	Komoda Bones 50x30D1N1 BIAŁY	1	605.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:55.597626	\N	4996
9974	712cdfc0-8cde-11f0-937d-89c40d48c215	7122f4b0-8cde-11f0-937d-89c40d48c215	15321914537	5905806216950	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Czarny	1	1827.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:56.761627	\N	4997
9975	023ddae0-8cdb-11f0-973f-af339170d9a3	023612b0-8cdb-11f0-973f-af339170d9a3	16602435161	5905806234572	Komoda Bini 50x36 D1N1 SONOMA	1	385.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:58.104979	\N	4650
9976	d263de30-8ccd-11f0-bf15-816520a36310	d25d7590-8ccd-11f0-bf15-816520a36310	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:08:59.481909	\N	82
9977	bf3852e0-8cc9-11f0-99cf-ab03232da32c	bf3322c0-8cc9-11f0-99cf-ab03232da32c	16602434536	5905806234527	Komoda Bini 50x30x82 D1N1 WOTAN	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:00.687175	\N	4381
9978	c1ffad10-8cc5-11f0-ad52-13dc957cc9dd	c1f9b9a0-8cc5-11f0-ad52-13dc957cc9dd	15410023447	5905806218879	Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan	1	1173.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:01.846009	\N	4516
9979	7c3db470-8cc5-11f0-ad52-13dc957cc9dd	7c374bd0-8cc5-11f0-ad52-13dc957cc9dd	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:03.011152	\N	9
9980	cc567a30-8ca4-11f0-bca6-415db17c0a9a	cc5038a0-8ca4-11f0-bca6-415db17c0a9a	12258666208	5905806216974	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	1	1887.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:04.175326	\N	14
9981	9b8dfaa0-8c9e-11f0-99cf-ab03232da32c	9b87e020-8c9e-11f0-99cf-ab03232da32c	15194005392	5905806213164	Garderoba 100x36cm Supra50 VB50 4 Panele WP50 D1N1 Dąb Wotan	1	1779.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:05.458149	\N	5004
9982	1dde9a80-8c9c-11f0-b999-71a0193671a8	1dd76e91-8c9c-11f0-b999-71a0193671a8	16319656327	5905806234367	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 ARTISAN	1	704.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:06.607262	\N	5005
9983	1dde9a80-8c9c-11f0-b999-71a0193671a8	1dd76e90-8c9c-11f0-b999-71a0193671a8	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:06.607262	\N	114
9984	f7c2e590-8c9b-11f0-9911-4b86842bcaca	f7bcf220-8c9b-11f0-9911-4b86842bcaca	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:07.88155	\N	16
9985	cdde1020-8c9a-11f0-9360-61e2679a32df	cdd78070-8c9a-11f0-9360-61e2679a32df	17567410245	\N	Poduszka ozdobna, dekoracyjna 50x30cm	2	37.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:09.02703	\N	\N
9986	b1d44660-8c95-11f0-ac29-997ddd4f1eae	b1cd8fa0-8c95-11f0-ac29-997ddd4f1eae	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:10.114258	\N	41
9987	6f1beba0-8c92-11f0-a42a-27f0acb7ed38	6f1534e1-8c92-11f0-a42a-27f0acb7ed38	16271296713	5905806233322	Komoda szafka NEX 50x30 sypialnia salon przedpokój D1N1 SONOMA	1	605.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:11.265188	\N	5009
9988	6f1beba0-8c92-11f0-a42a-27f0acb7ed38	6f1534e0-8c92-11f0-a42a-27f0acb7ed38	11873257937	5905806208351	Szafka na buty z szufladą Tres 60x36 Dąb Sonoma	2	434.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:11.265188	\N	4569
9989	6f1beba0-8c92-11f0-a42a-27f0acb7ed38	6f1534e2-8c92-11f0-a42a-27f0acb7ed38	11711309800	5905806205480	Wieszak ścienny WP100 na ubrania 100cm Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:11.265188	\N	5011
9991	38769ce0-8c82-11f0-a374-2b3f33c8293d	3870a970-8c82-11f0-a374-2b3f33c8293d	16276323396	5905806233933	Komoda Bini 60x30D1N1 SONOMA	1	418.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:13.790623	\N	42
9992	22ac83d0-8c7c-11f0-973f-af339170d9a3	22a3d140-8c7c-11f0-973f-af339170d9a3	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	1	592.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:14.910633	\N	70
9993	22ac83d0-8c7c-11f0-973f-af339170d9a3	22a3d141-8c7c-11f0-973f-af339170d9a3	14933823645	5905806204124	Szafka na buty VB100x30D siedzisko schowek WOTAN	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:14.910633	\N	4843
9994	2bc0a6b0-8c7a-11f0-b999-71a0193671a8	2bbb4f80-8c7a-11f0-b999-71a0193671a8	16319659755	5905806234411	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 CZARNY ARTISAN	1	704.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:16.113565	\N	5016
9995	c7eece30-8c3f-11f0-aeeb-f5bb2ff9b6b9	c7e8dac0-8c3f-11f0-aeeb-f5bb2ff9b6b9	14209799601	5905806201659	Szafka na buty Supra 30x30 D1N1 słupek Wotan	2	532.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:09:17.256463	\N	4651
9990	ea436631-8c85-11f0-bc28-c1ece5985fa4	ea3bc513-8c85-11f0-bc28-c1ece5985fa4	17453875719	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:14:36.027057	\N	57
9997	48d87520-8789-11f0-9663-29033773bab5	48d23390-8789-11f0-9663-29033773bab5	16859418115	5905806210620	Półka ścienna 80x18x20cm SONOMA	1	98.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:14:58.880964	\N	5019
9998	e57e3140-8788-11f0-a374-2b3f33c8293d	e5783dd0-8788-11f0-a374-2b3f33c8293d	16859418115	5905806210620	Półka ścienna 80x18x20cm SONOMA	1	98.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:00.15466	\N	5019
9966	66f458c1-8cee-11f0-99cf-ab03232da32c	66ecb7a1-8cee-11f0-99cf-ab03232da32c	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 10:18:42.842543	\N	4640
9999	f00e7530-8778-11f0-9663-29033773bab5	f0091e00-8778-11f0-9663-29033773bab5	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	1	592.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:01.381321	\N	70
10000	2db02500-8774-11f0-9bbd-0ba2c344c673	2daa58a0-8774-11f0-9bbd-0ba2c344c673	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:02.638995	\N	83
10001	9d2265a0-8761-11f0-932c-f3e4227fda85	9d1c9940-8761-11f0-932c-f3e4227fda85	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:03.849943	\N	71
10002	4d41d6a0-8771-11f0-bdda-f5fe64ec56c4	4d3be330-8771-11f0-bdda-f5fe64ec56c4	12266508963	5905204699102	Garderoba 90x36cm V60 Supra30 4 Panele D1 LAN	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:05.072119	\N	4274
10003	2959d1f0-876e-11f0-a374-2b3f33c8293d	2953b770-876e-11f0-a374-2b3f33c8293d	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:06.263963	\N	41
10004	9775a520-876d-11f0-8d99-95e42f81ac3a	97704df0-876d-11f0-8d99-95e42f81ac3a	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:07.862582	\N	4281
10005	ef0e87d0-876c-11f0-92f7-a7a918a71206	ef086d50-876c-11f0-92f7-a7a918a71206	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:09.271602	\N	9
10006	6e858ff0-876c-11f0-ab95-618100a958cf	6e7fc390-876c-11f0-ab95-618100a958cf	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:10.480049	\N	94
10007	d5703210-8762-11f0-852b-c3120c8c37fe	d56a8cc0-8762-11f0-852b-c3120c8c37fe	17495949501	5905806238723	Szafka na buty VB50x30 D3N3 BIAŁY	1	400.00	PLN	\N	\N	\N	\N	PL	1	2025-10-10 09:15:11.667186	\N	5029
10015	30d95140-874f-11f0-9bbd-0ba2c344c673	30d35dd0-874f-11f0-9bbd-0ba2c344c673	15919784886	5905806228991	Komoda Bones 50x36D1N1 WOTAN	2	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:20.638285	\N	347
10016	cea8e430-874a-11f0-b3ea-7b7b17505e79	cea317d0-874a-11f0-b3ea-7b7b17505e79	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:21.837018	\N	4640
10017	8ecea0f0-8738-11f0-b3ea-7b7b17505e79	8ec8d490-8738-11f0-b3ea-7b7b17505e79	12224099030	5905204699249	Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma	1	923.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:23.254274	\N	4287
10018	65b36470-8734-11f0-aae5-1913e565e695	65ad22e0-8734-11f0-aae5-1913e565e695	15176150526	5905806209525	Szafka komoda na buty 80x30 D2N1 Altus WOTAN	1	556.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:24.464693	\N	102
10019	49be9000-8734-11f0-b0fa-efded7e9e698	49b73d00-8734-11f0-b0fa-efded7e9e698	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:25.679899	\N	4640
10020	acbae750-8732-11f0-aae5-1913e565e695	acaa6c90-8732-11f0-aae5-1913e565e695	15225857105	5905806206678	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	1	523.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:26.886604	\N	106
10021	4d469ef0-872c-11f0-baaf-1b3feb3b2100	4d3c3eb0-872c-11f0-baaf-1b3feb3b2100	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	1	478.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:28.123644	\N	1
10022	be44e7b0-8722-11f0-84e1-03ec8438f346	be3ecd30-8722-11f0-84e1-03ec8438f346	12266488350	5905204699119	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele BIAŁY	1	1343.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:29.31533	\N	4973
10023	09fd5e90-8718-11f0-baaf-1b3feb3b2100	09f2d740-8718-11f0-baaf-1b3feb3b2100	11873232153	5905806214062	Szafka na buty z szufladą Tres 50x30 Dąb Sonoma	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:30.50539	\N	4986
10024	ae946540-8711-11f0-90bb-a54d0876967b	ae8ebff0-8711-11f0-90bb-a54d0876967b	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:31.699995	\N	72
10025	d52dd280-870d-11f0-90bb-a54d0876967b	d527df10-870d-11f0-90bb-a54d0876967b	16632260455	5905806225464	Szafka na buty VB50x30 D1N1 ARTISAN CZARNY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:32.905688	\N	5047
10026	61e490b0-8709-11f0-8f72-9176775e3e0f	61de2810-8709-11f0-8f72-9176775e3e0f	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:34.124347	\N	4281
10027	d4759520-8704-11f0-84e1-03ec8438f346	d46fa1b0-8704-11f0-84e1-03ec8438f346	15463007408	5905806220391	Garderoba 140x30cm V60 Supra80 4 Panele D1N1 Dąb Artisan	1	1947.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:35.323801	\N	5049
10028	f94b15d0-8701-11f0-aae5-1913e565e695	f945bea0-8701-11f0-aae5-1913e565e695	14387676426	5905806202502	Szafka na buty VB80x36D S1 siedzisko schowek 80cm Czarny BIAŁY	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:36.550505	\N	5050
10029	b66e2ad0-86f8-11f0-80ea-6fda5b3014ee	b668fab0-86f8-11f0-80ea-6fda5b3014ee	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:37.771363	\N	49
10030	87c7ef00-86f2-11f0-8f72-9176775e3e0f	87c249b0-86f2-11f0-8f72-9176775e3e0f	15451878639	5905806208658	Zestaw VB60x36 Tres60x36 D1N1 szafka na buty siedzisko SONOMA	1	780.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:38.988943	\N	5052
10008	442948f0-875d-11f0-a4db-2f9c265ced69	4423a3a0-875d-11f0-a4db-2f9c265ced69	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:13.068956	\N	12
10009	035369d1-875a-11f0-9035-99f977ef67ee	034cb312-875a-11f0-9035-99f977ef67ee	15321911032	5905806216912	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Artisan	1	1827.00	PLN	\N	\N	\N	\N	PL	1	2025-10-10 09:15:14.295526	\N	4359
10010	301bf080-8756-11f0-b999-71a0193671a8	301587e0-8756-11f0-b999-71a0193671a8	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:15.658562	\N	4640
10011	301bf080-8756-11f0-b999-71a0193671a8	301587e1-8756-11f0-b999-71a0193671a8	16631278773	5905806236668	Szafka na buty z szufladą Tres 80x30D2N1 SONOMA	1	617.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:15.658562	\N	5033
10012	f532a390-8752-11f0-b999-71a0193671a8	f52cfe40-8752-11f0-b999-71a0193671a8	15319529269	5905806213812	Garderoba 110x36D1N1 Supra30 VB80 4 Panele WP80 CZARNY WOTAN	1	1557.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:16.97062	\N	4389
10013	6ff57270-8752-11f0-b999-71a0193671a8	6fefcd21-8752-11f0-b999-71a0193671a8	16602441568	5905806234794	Komoda Bini 100x30x82 D1N1 BIAŁY	1	616.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:18.168459	\N	5035
10014	e1aa8e70-8750-11f0-b999-71a0193671a8	e1a425d0-8750-11f0-b999-71a0193671a8	16724405338	5905806237207	Szafka na buty VB60x36D1N1 Dąb Estana	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 09:15:19.393478	\N	5036
10151	5f3caba0-a5e9-11f0-9b0c-e511fc7361fa	5f34bc62-a5e9-11f0-9b0c-e511fc7361fa	11711299117	5905806203677	Wieszak ścienny WP60 na ubrania 60cm Sonoma	1	229.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 15:05:19.598918	\N	36
10165	9a0dac40-a605-11f0-805b-5b33cfcb1907	9a071c90-a605-11f0-805b-5b33cfcb1907	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	1	592.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 18:24:08.717366	\N	70
10130	a54f53c0-a5d2-11f0-833e-e3bb93fde64a	a54875f1-a5d2-11f0-833e-e3bb93fde64a	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 12:20:02.541601	\N	7
10131	a54f53c0-a5d2-11f0-833e-e3bb93fde64a	a54875f0-a5d2-11f0-833e-e3bb93fde64a	17739053516	\N	Wieszak ścienny WP50 na ubrania 50cm Biały	1	205.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 12:20:02.541601	\N	\N
10031	b68be680-a5b9-11f0-b947-e52733e9ad15	b6870480-a5b9-11f0-b947-e52733e9ad15	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 10:15:33.711674	\N	4368
10144	3dce85c0-a5d4-11f0-861f-cb3d7d4327c9	3dc7cf00-a5d4-11f0-861f-cb3d7d4327c9	15919776102	5905806228847	Komoda Bones 60x30D1N1 WOTAN	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 12:30:02.663054	\N	4870
10039	d747fb70-a5c3-11f0-a588-b391296a673a	d7438ea0-a5c3-11f0-a588-b391296a673a	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 10:51:36.162705	\N	7
10040	d747fb70-a5c3-11f0-a588-b391296a673a	d7438ea1-a5c3-11f0-a588-b391296a673a	11750242493	5905806214086	Szafka na buty z szufladą Tres 50x36 Biały	1	447.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 10:51:36.162705	\N	5062
10109	42b1ea80-a5c2-11f0-805b-5b33cfcb1907	42ab5ad0-a5c2-11f0-805b-5b33cfcb1907	15919780554	5905806228922	Komoda Bones 50x30D1N1 SONOMA	1	605.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 11:12:02.521501	\N	5131
10116	29136bb0-a5ce-11f0-8895-094b8cada9e7	290c8de0-a5ce-11f0-8895-094b8cada9e7	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	1	423.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 11:57:15.495963	\N	114
10113	cf84c5c0-a5c9-11f0-861f-cb3d7d4327c9	cf7e3610-a5c9-11f0-861f-cb3d7d4327c9	15440332896	5905806218190	Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko WOTAN	1	1023.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 11:13:45.38649	\N	5135
10110	8a77e1c0-a5c8-11f0-8895-094b8cada9e7	8a715210-a5c8-11f0-8895-094b8cada9e7	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 11:13:47.267817	\N	4640
10146	9fc75c80-a5e2-11f0-a5d7-371746f07634	9fbcd530-a5e2-11f0-a5d7-371746f07634	12158414735	5905806217124	Komoda z szufladami Vini 80x30 D1N1 BIAŁY	1	600.60	PLN	\N	\N	\N	\N	PL	0	2025-10-10 14:27:28.459355	\N	5161
10147	e444aab0-a5e3-11f0-86f8-1b20137f27b1	e43b0dc0-a5e3-11f0-86f8-1b20137f27b1	17736467450	\N	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm KASZMIR	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 14:27:39.459464	\N	\N
10148	213e5de0-a5e3-11f0-9b0c-e511fc7361fa	2137a720-a5e3-11f0-9b0c-e511fc7361fa	15410022839	5905806218855	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Dąb Wotan	1	1136.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 14:27:45.459277	\N	3
10166	9a0dac40-a605-11f0-805b-5b33cfcb1907	9a071c91-a605-11f0-805b-5b33cfcb1907	14384919344	5905806201826	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm WOTAN	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-10 18:24:08.717366	\N	4844
10169	c6fe5030-a608-11f0-a45a-cf4899467cb9	c6fa0a70-a608-11f0-a45a-cf4899467cb9	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 18:58:29.338263	\N	4404
10170	27d863c0-a607-11f0-805b-5b33cfcb1907	27d1ad00-a607-11f0-805b-5b33cfcb1907	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	1	312.20	PLN	\N	\N	\N	\N	PL	0	2025-10-10 18:58:47.63957	\N	41
10149	5f3caba0-a5e9-11f0-9b0c-e511fc7361fa	5f34bc60-a5e9-11f0-9b0c-e511fc7361fa	15919776759	5905806228861	Komoda Bones 60x36D1N1 SONOMA	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 15:05:19.598918	\N	4282
10150	5f3caba0-a5e9-11f0-9b0c-e511fc7361fa	5f34bc61-a5e9-11f0-9b0c-e511fc7361fa	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	1	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 15:05:19.598918	\N	92
10162	0286d970-a603-11f0-acf3-212576f15d8a	027ffba0-a603-11f0-acf3-212576f15d8a	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 18:14:06.318187	\N	4404
10163	7f9c4050-a601-11f0-86f8-1b20137f27b1	7f95d7b0-a601-11f0-86f8-1b20137f27b1	11225775551	5905806215434	Garderoba 50x30D1N1 VB50 4Panele WP50 Biały	1	751.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 18:14:14.617168	\N	5177
10145	9d176340-a5d8-11f0-a45a-cf4899467cb9	9d12f670-a5d8-11f0-a45a-cf4899467cb9	16602440992	5905806234763	Komoda Bini 100x36 D1N1 SONOMA	1	682.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 21:58:54.161418	\N	115
10155	567ba210-a5fc-11f0-b989-75c7faccd1ca	5674c440-a5fc-11f0-b989-75c7faccd1ca	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	1	405.20	PLN	\N	\N	\N	\N	PL	0	2025-10-10 20:52:42.827959	\N	94
10171	1e795430-a614-11f0-b989-75c7faccd1ca	1e7312a0-a614-11f0-b989-75c7faccd1ca	14563824746	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	1	278.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 20:17:50.309765	\N	53
10184	f6ea9f90-a619-11f0-a685-3b2ebe8a80a1	f6e632c0-a619-11f0-a685-3b2ebe8a80a1	12266508963	5905204699102	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 20:52:33.228359	\N	4274
10128	388cd660-a5d0-11f0-8895-094b8cada9e7	388646b0-a5d0-11f0-8895-094b8cada9e7	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 22:01:23.875625	\N	4281
10186	276add70-a61e-11f0-9b0c-e511fc7361fa	276474d0-a61e-11f0-9b0c-e511fc7361fa	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-10 21:57:42.30594	\N	9
10190	ff70ad70-a67e-11f0-b410-a9ff53c96dc9	ff6c67b0-a67e-11f0-b410-a9ff53c96dc9	13854397976	5905204699997	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN	2	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 08:52:43.159432	\N	4405
10191	cac5a710-a679-11f0-84af-1520c30fa31d	cabbbc00-a679-11f0-84af-1520c30fa31d	17736455042	\N	Szafka na buty VB60x36 D1N1 siedzisko, schowek KASZMIR	1	350.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 08:52:44.582275	\N	\N
10192	c3e39250-a66e-11f0-86f8-1b20137f27b1	c3dd02a0-a66e-11f0-86f8-1b20137f27b1	14933823645	5905806204124	Szafka na buty VB100x30D siedzisko schowek WOTAN	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 08:52:45.808528	\N	4843
10194	ace79380-a669-11f0-8895-094b8cada9e7	ace103d0-a669-11f0-8895-094b8cada9e7	15229738794	5905806214574	Szafka na buty z szufladą Tres 100x36D1N1 WOTAN	1	611.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 08:52:48.250918	\N	4515
10195	0f8d5bd0-a667-11f0-a685-3b2ebe8a80a1	0f891610-a667-11f0-a685-3b2ebe8a80a1	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 08:52:49.46183	\N	9
10196	432c9eb0-a644-11f0-a685-3b2ebe8a80a1	43265d20-a644-11f0-a685-3b2ebe8a80a1	16319667125	5905806234299	Komoda szafka NEX 80x30x124 sypialnia salon przedpokój D1N1 WOTAN	1	671.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 08:52:50.680393	\N	5209
10198	7f958c50-a67f-11f0-a588-b391296a673a	7f90d160-a67f-11f0-a588-b391296a673a	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	2	326.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 08:53:53.391493	\N	65
10201	d9ee23e0-a681-11f0-bff7-bf511d875719	d9e968f0-a681-11f0-bff7-bf511d875719	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 09:10:04.257892	\N	16
10220	bfbfb8f0-a6c0-11f0-a588-b391296a673a	bfbb2510-a6c0-11f0-a588-b391296a673a	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 16:41:23.429421	\N	71
10199	c3c27b20-a681-11f0-9d9f-ab7e5bc5b8f5	c3bc1280-a681-11f0-9d9f-ab7e5bc5b8f5	12170497350	5905806217063	Komoda z szufladami Vini 60x30 D1N1 LANCELOT	1	594.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 09:10:06.256971	\N	5212
10205	6b3f9450-a687-11f0-bff7-bf511d875719	6b3b2780-a687-11f0-bff7-bf511d875719	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 09:53:38.665231	\N	4404
10237	07694630-a6d5-11f0-a588-b391296a673a	07650070-a6d5-11f0-a588-b391296a673a	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 19:06:23.296897	\N	4404
10224	53f44c21-a6c6-11f0-a685-3b2ebe8a80a1	53e976b1-a6c6-11f0-a685-3b2ebe8a80a1	11711309800	5905806205480	Wieszak ścienny WP100 na ubrania 100cm Sonoma	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 17:32:47.282074	\N	5011
10193	b27a9730-a66d-11f0-84af-1520c30fa31d	b270ac20-a66d-11f0-84af-1520c30fa31d	14933823645	5905806204124	Szafka na buty VB100x30D siedzisko schowek WOTAN	1	510.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 11:22:14.537581	\N	4843
10216	0a671880-a6b7-11f0-86f8-1b20137f27b1	0a60fe00-a6b7-11f0-86f8-1b20137f27b1	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 16:01:46.155843	\N	4281
10245	a914f320-a6d6-11f0-a685-3b2ebe8a80a1	a9112290-a6d6-11f0-a685-3b2ebe8a80a1	15410023447	5905806218879	Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan	1	1173.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 21:16:53.127281	\N	4516
10215	176e1b10-a6a2-11f0-bbf9-7f3870292d20	1767b270-a6a2-11f0-bbf9-7f3870292d20	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 21:43:50.233371	\N	7
10231	de8bf6b0-a6c8-11f0-8895-094b8cada9e7	de836b30-a6c8-11f0-8895-094b8cada9e7	15121493570	5905806205091	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 Artisan	1	1319.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 17:54:17.739795	\N	5244
10250	da57adf0-a6eb-11f0-86f8-1b20137f27b1	da514550-a6eb-11f0-86f8-1b20137f27b1	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	1	314.00	PLN	\N	\N	\N	\N	PL	0	2025-10-11 21:51:37.251859	\N	7
10241	e61fb2c2-a6d4-11f0-a5d7-371746f07634	e619bf53-a6d4-11f0-a5d7-371746f07634	15408459144	5905806218732	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Czarny Wotan	1	1015.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 00:12:09.456918	\N	5254
10252	6839cf50-a740-11f0-8895-094b8cada9e7	6832a360-a740-11f0-8895-094b8cada9e7	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	1	828.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 07:54:28.114931	\N	57
10253	ee9e4260-a740-11f0-bed1-ff1b110238ef	ee9a23b0-a740-11f0-bed1-ff1b110238ef	16383696059	5905806234060	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój SONOMA	1	638.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 07:57:25.315005	\N	5266
10254	4bc5dba0-a747-11f0-86f8-1b20137f27b1	4bbf7300-a747-11f0-86f8-1b20137f27b1	16602433072	5905806234473	Komoda Bini 50x30x82 D1N1 BIAŁY	1	352.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 08:49:13.866852	\N	43
10255	829009c0-a752-11f0-86f8-1b20137f27b1	82892bf0-a752-11f0-86f8-1b20137f27b1	17477972814	5905806238716 	Garderoba 80x36D1N1 Supra30Tres50 3PAN WP50 KASZMIR	1	1373.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 10:06:24.359614	\N	4565
10257	ebc78111-a753-11f0-a5d7-371746f07634	ebc31441-a753-11f0-a5d7-371746f07634	15125437469	5905806204407	Szafka na buty z wieszakiem VB50x30WP50 N1D1 Biały Czarny	1	519.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 10:13:29.958813	\N	5270
10259	f0f84081-a757-11f0-9676-73245b6f515f	f0f35e81-a757-11f0-9676-73245b6f515f	12476639410	5905204699454	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Dąb Sonoma	1	954.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 10:53:35.288788	\N	64
10262	77e63970-a759-11f0-8b8d-c5b44d4871fc	77e17e80-a759-11f0-8b8d-c5b44d4871fc	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	1	399.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 10:57:57.475181	\N	9
10268	4ff34190-a75b-11f0-86f8-1b20137f27b1	4fec63c0-a75b-11f0-86f8-1b20137f27b1	12600923141	5905806210347	Półka ścienna 50x18x20cm solidna Dąb Sonoma	1	76.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 11:07:35.68496	\N	5279
10286	e7ad75e0-a75c-11f0-a045-bdd383b29371	e7a6e630-a75c-11f0-a045-bdd383b29371	17496406633	5905806238846	Szafka na buty VB80x30 D3N3 CZARNY	1	485.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 11:21:39.247935	\N	5294
10274	08830740-a75c-11f0-86f8-1b20137f27b1	087c5080-a75c-11f0-86f8-1b20137f27b1	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	1	737.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 11:16:49.24788	\N	4404
10313	7411ada0-a760-11f0-8b8d-c5b44d4871fc	740d40d0-a760-11f0-8b8d-c5b44d4871fc	12266508806	5905204699096	Garderoba 90x36cm V60 Supra30 4 Panele D1 SO	1	1391.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 11:43:02.233555	\N	4852
10297	4e267400-a75f-11f0-a209-db57faeef72f	4e1e5db0-a75f-11f0-a209-db57faeef72f	15178440763	5905806210156	Szafka komoda na buty 80x36 D2N2 Altus WOTAN	1	636.00	PLN	\N	\N	\N	\N	PL	0	2025-10-12 11:43:12.087935	\N	5305
\.


--
-- Data for Name: orders; Type: TABLE DATA; Schema: allegro; Owner: neondb_owner
--

COPY allegro.orders (id, order_id, seller_id, seller_login, order_date, seller_status, marketplace, buyer_id, buyer_login, buyer_email, buyer_company, buyer_name, buyer_phone, buyer_address, buyer_zip, buyer_city, buyer_country_code, payment_id, payment_status, payment_provider, allegro_pay, payment_amount, payment_currency, delivery_method, delivery_amount, delivery_currency, total_to_pay_amount, total_to_pay_currency, buyer_notes, smart, tracking_numbers, payment_last_date, buyer_account_type, imported_at, payment_type, invoice_required, shipments, billing_address, refund_amount, refund_date, refund_reconciliation, has_returns) FROM stdin;
8432	da57adf0-a6eb-11f0-86f8-1b20137f27b1	\N	\N	2025-10-11 21:51:29.553	FILLED_IN	allegro-pl	3059373	magdusia30	ovzhog0ueo+17ff434b7@allegromail.pl	\N	Magdalena Pękala	+48 784 533 828	\N	\N	\N	\N	415334c7-a6ec-11f0-91d4-7961b40d7b05	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	proszę o wysłanie szafki z obiciem WE1 CZRANY WELUR 	t	\N	2025-10-11 21:51:29.553	\N	2025-10-11 21:51:37.251859	ONLINE	f	[]	\N	0.00	\N	[]	f
11	092d0510-a289-11f0-b024-2112831760cb	\N	\N	2025-10-06 07:50:25.839	Gotowe do realizacji	allegro-pl	12160923	verbum33	2qm541yucu+41ba7bc8@allegromail.pl	\N	Mariola Lewicka	+48 512 461 068	Zagruszany 35	16-060	Zabłudów	PL	13654ae9-a289-11f0-91d4-7961b40d7b05	PAID	PAYU	t	341.00	PLN	Allegro Kurier DPD	0.00	PLN	341.00	PLN	\N	t	\N	2025-10-06 07:50:25.839	\N	2025-10-06 20:34:51.668214	ONLINE	f	\N	\N	0.00	\N	\N	f
8434	6839cf50-a740-11f0-8895-094b8cada9e7	\N	\N	2025-10-12 07:53:29.006	Gotowe do realizacji	allegro-pl	20035552	mateja7474	l3njglgfg2+72e59aac3@allegromail.pl	\N	Mateusz Tołczyk	+48 505 514 737	Zaczerlany 12E	16-070	Choroszcz	PL	6873cbc5-a740-11f0-96eb-67f4404dbe40	PAID	AF	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	\N	t	\N	2025-10-12 07:53:29.006	\N	2025-10-12 07:54:28.114931	ONLINE	f	[]	\N	0.00	\N	[]	f
8436	4bc5dba0-a747-11f0-86f8-1b20137f27b1	\N	\N	2025-10-12 08:42:37.379	Gotowe do realizacji	allegro-pl	37711564	Client:37711564	a0c5zci5cj+42a1343b1@allegromail.pl	\N	Adam Ignasiak	+48 574 680 335	Władysława Reymonta 10	89-600	Chojnice	PL	4bedfde9-a747-11f0-ae11-e76c74c7cf77	PAID	AF	t	352.00	PLN	Allegro Kurier DPD	0.00	PLN	352.00	PLN	\N	t	\N	2025-10-12 08:42:37.379	\N	2025-10-12 08:49:13.866852	ONLINE	f	[]	\N	0.00	\N	[]	f
8437	829009c0-a752-11f0-86f8-1b20137f27b1	\N	\N	2025-10-12 10:04:59.602	Gotowe do realizacji	allegro-pl	9708609	sun_m1	lnv7bbh03v+2d0896256@allegromail.pl	\N	Monika Maruszczak	+48 502 348 205	Łubinowa 58/5	70-785	Szczecin	\N	dfcd5d7c-a752-11f0-a284-071dd65bf45d	PAID	PAYU	t	1373.00	\N	Allegro Kurier DPD	0.00	PLN	1373.00	PLN	kolor uchwytu czarny H1, kolor paneli skóra pikowana czarna EP2	t	\N	2025-10-12 10:05:20.179	\N	2025-10-12 10:06:24.359614	ONLINE	f	[]	\N	0.00	\N	[]	f
8441	f0f84081-a757-11f0-9676-73245b6f515f	\N	\N	2025-10-12 10:44:28.763	Wypełnione	allegro-pl	3981851	cervantesj	psy90lzy7g+5afc64ee1@allegromail.pl	Ster4Eko Paweł Drosio Automatyka Przemysłowa	Paweł Drosio	+48 508 064 875	\N	\N	\N	\N	f1308f52-a757-11f0-b9a1-9fd75769370f	UNPAID	PAYU	t	\N	\N	Allegro Kurier DPD	0.00	PLN	954.00	PLN	\N	t	\N	\N	\N	2025-10-12 10:53:35.288788	ONLINE	t	[]	\N	0.00	\N	[]	f
37	935f63c0-a1ff-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-05 15:28:56.284	Anulowane	allegro-pl	12734940	csae	7g2ohrayar+67f56c8f1@allegromail.pl	\N	Anna Wistuba	+49 171 9078018	\N	\N	\N	\N	e1107582-a1ff-11f0-ae11-e76c74c7cf77	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	14.99	PLN	842.99	PLN	\N	f	\N	\N	\N	2025-10-09 19:40:18.981615	ONLINE	f	[]	\N	0.00	\N	[]	f
7539	f621b350-a4f2-11f0-9b0c-e511fc7361fa	\N	\N	2025-10-09 09:33:27.735	Wypełnione	allegro-pl	44621517	Client:44621517	la2neq8wyx+4f88e2345@allegromail.pl	\N	Dariusz Wiśniewski	+48 695 634 289	\N	\N	\N	\N	f64bd174-a4f2-11f0-a417-fd831f6ae8ec	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	\N	\N	2025-10-09 20:15:49.82405	ONLINE	f	[]	\N	0.00	\N	[]	f
8435	ee9e4260-a740-11f0-bed1-ff1b110238ef	\N	\N	2025-10-12 07:56:59.852	Gotowe do realizacji	allegro-pl	48392624	Client:48392624	svmgymox6c+565d41983@allegromail.pl	\N	Żaneta Boksa	+48 693 616 522	Wolności 28	26-020	Chmielnik	PL	fff61cd6-a740-11f0-91d4-7961b40d7b05	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	642.99	PLN	\N	t	\N	2025-10-12 07:56:59.852	\N	2025-10-12 07:57:25.315005	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
8439	ebc78111-a753-11f0-a5d7-371746f07634	\N	\N	2025-10-12 10:13:04.898	Gotowe do realizacji	allegro-pl	24132822	furious20	lk3c62y8dw+44d83b527@allegromail.pl	\N	Bartek Ptaszyński	+48 607 753 796	Wojska Polskiego 31/20	88-100	Inowrocław	PL	ebe801fc-a753-11f0-91d4-7961b40d7b05	PAID	PAYU	t	519.00	PLN	Allegro Kurier DPD	0.00	PLN	519.00	PLN	\N	t	\N	2025-10-12 10:13:04.898	\N	2025-10-12 10:13:29.958813	ONLINE	f	[]	\N	0.00	\N	[]	f
7538	243cd4e0-a4f3-11f0-a588-b391296a673a	\N	\N	2025-10-09 09:35:57.424	Gotowe do realizacji	allegro-pl	44621517	Client:44621517	la2neq8wyx+14c282704@allegromail.pl	\N	Dariusz Wiśniewski	+48 695 634 289	ciechocinska 38 B	87-730	Nieszawa	PL	28c93b32-a4f3-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	671.00	PLN	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	2025-10-09 09:35:57.424	\N	2025-10-09 19:33:22.970421	ONLINE	f	[]	\N	0.00	\N	[]	f
8444	77e63970-a759-11f0-8b8d-c5b44d4871fc	\N	\N	2025-10-12 10:54:11.628	Gotowe do realizacji	allegro-pl	34332272	Furdanowicz	9voezo4fda+7fe8a7fc8@allegromail.pl	\N	Paweł Grudzień	+48 600 487 237	Kokotów 490	32-002	Węgrzce Wielkie	PL	7803865f-a759-11f0-91d4-7961b40d7b05	PAID	P24	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	Kolor obicia F03	t	\N	2025-10-12 10:54:11.628	\N	2025-10-12 10:57:57.475181	ONLINE	f	[]	\N	0.00	\N	[]	f
7549	e64fe9b0-a493-11f0-a471-6bb0586de370	\N	\N	2025-10-08 22:17:02.482	Gotowe do realizacji	allegro-pl	70223087	Black95955	fzvh83qudq+4521d8169@allegromail.pl	\N	Konrad Żak	+48 534 947 293	Uniwersytecka 5	25-351	Kielce	PL	e6848f03-a493-11f0-a284-071dd65bf45d	PAID	AF	t	657.99	PLN	Allegro Kurier DPD	14.99	PLN	657.99	PLN	H1\nTH1	f	\N	2025-10-08 22:17:02.482	\N	2025-10-09 19:33:38.4484	ONLINE	f	[]	\N	0.00	\N	[]	f
8448	db37fc60-a75a-11f0-b9bf-2795de008363	\N	\N	2025-10-12 11:03:24.909	Gotowe do realizacji	allegro-pl	33833543	Client:33833543	2wfiic2sks+76b9a53d2@allegromail.pl	\N	Justyna Major	+48 517 983 426	Wacława Potockiego 13/2	51-153	Wrocław	PL	db556fa9-a75a-11f0-b9a1-9fd75769370f	PAID	P24	t	340.99	PLN	Allegro Kurier DPD	14.99	PLN	340.99	PLN	THP2 - Tkanina Hugo Pik Jasno szary	f	\N	2025-10-12 11:03:24.909	\N	2025-10-12 11:07:37.715441	ONLINE	f	[]	\N	0.00	\N	[]	f
7551	04361df1-a480-11f0-bfb1-c5232bd647f2	\N	\N	2025-10-08 19:51:34.836	Gotowe do realizacji	allegro-pl	46745275	kubarantArenam	dufxfoazqp+7f5035587@allegromail.pl	\N	Jakub Wiercioch	+48 500 141 806	Marynin 33A / 81	01-469	Warszawa	PL	196d5574-a480-11f0-baf9-a33944a1116d	PAID	P24	t	835.00	PLN	Allegro Kurier DPD	0.00	PLN	835.00	PLN	\N	t	\N	2025-10-08 19:51:34.836	\N	2025-10-09 19:33:41.242995	ONLINE	f	[]	\N	0.00	\N	[]	f
8450	4ff34190-a75b-11f0-86f8-1b20137f27b1	\N	\N	2025-10-12 11:05:23.777	Gotowe do realizacji	allegro-pl	26565364	Damian26011993	z8pr2c5m17+50128d810@allegromail.pl	\N	Damian Nieznalski	+48 880 848 571	Obice,ul.Kwiatowa 47	26-026	Morawica	PL	5638f12d-a75b-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	95.99	PLN	\N	f	\N	2025-10-12 11:05:23.777	\N	2025-10-12 11:07:35.68496	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
84	90c6f9c0-a0fb-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-04 08:25:06.902	Gotowe do realizacji	allegro-pl	38872915	Adrianx1995	wx47gm85wf+2dc50c4d9@allegromail.pl	\N	Adrian Wasiluk	+48 796 138 732	Porzeczkowa 4	21-300	Radzyń Podlaski	PL	93799703-a0fb-11f0-b9a1-9fd75769370f	PAID	P24	t	671.00	PLN	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	2025-10-04 08:25:06.902	\N	2025-10-06 18:52:54.929446	ONLINE	f	\N	\N	0.00	\N	\N	f
551	c301a2d0-a2b5-11f0-abc1-17dd0035cfdf	\N	\N	2025-10-06 13:12:17.977	Gotowe do realizacji	allegro-pl	49717061	Client:49717061	lrd4l7ftbx+4a54f4f56@allegromail.pl	\N	Katarzyna Bąk	+48 608 422 616	Zacisze 3	62-800	Kalisz	PL	c34403db-a2b5-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	kolor siedziska czarny welur	t	\N	2025-10-06 13:12:17.977	\N	2025-10-06 20:34:47.126296	ONLINE	f	\N	\N	0.00	\N	\N	f
8456	08830740-a75c-11f0-86f8-1b20137f27b1	\N	\N	2025-10-12 11:13:51.836	Gotowe do realizacji	allegro-pl	123325912	Client:123325912	5wtdzwyc0u+49449bed3@allegromail.pl	\N	Katarzyna Domańska	+48 505 927 000	Pościsze 5	21-500	Międzyrzec Podlaski	PL	08ba92d2-a75c-11f0-ae11-e76c74c7cf77	PAID	P24	t	737.00	PLN	Allegro Kurier DPD	0.00	PLN	737.00	PLN	kolor obicia siedziska fiord f03 grafit.kolor mebla dąb wotan szer 100 głębokość 30 wysokość 82	t	\N	2025-10-12 11:13:51.836	\N	2025-10-12 11:16:49.24788	ONLINE	f	[]	\N	0.00	\N	[]	f
9	74ee70b0-a28c-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-06 08:15:15.723	Gotowe do realizacji	allegro-pl	11928754	Just810	dk0m11lgy2+304bf82c0@allegromail.pl	\N	Justyna Łyczewska	+48 504 122 495	ul. Kasjopei 15/3	71-771	Szczecin	PL	77f150e0-a28c-11f0-ae11-e76c74c7cf77	PAID	AF	t	725.00	PLN	Allegro Kurier DPD	0.00	PLN	725.00	PLN	\N	t	\N	2025-10-06 08:15:15.723	\N	2025-10-06 20:34:50.851745	ONLINE	t	\N	\N	0.00	\N	\N	f
4	38d3bef0-a2a5-11f0-a6c9-036cfc044caf	\N	\N	2025-10-06 11:13:10.852	Gotowe do realizacji	allegro-pl	5544044	bratka52	h1ant1z1sm+2c9e6030@allegromail.pl	\N	Beata Górska	+48 665 180 908	Kraszewskiego 45a / 199	15-025	Białystok	PL	3913392a-a2a5-11f0-a417-fd831f6ae8ec	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	F04	t	\N	2025-10-06 11:13:10.852	\N	2025-10-06 20:34:48.732294	ONLINE	f	\N	\N	0.00	\N	\N	f
8468	e7ad75e0-a75c-11f0-a045-bdd383b29371	\N	\N	2025-10-12 11:19:28.586	Gotowe do realizacji	allegro-pl	39031425	Client:39031425	w3o76wvhti+733e1fb96@allegromail.pl	\N	Agnieszka Chojnowska	+48 795 235 266	ul. Witosa 3/9	18-500	Kolno	\N	e7ea5836-a75c-11f0-a417-fd831f6ae8ec	PAID	AF	t	485.00	\N	Allegro Kurier DPD	0.00	PLN	485.00	PLN	Dzień dobry,\nproszę siedzisko z tkaniny Hugo czarny TH1\npozdrawiam 🙂	t	\N	2025-10-12 11:19:43.939	\N	2025-10-12 11:21:39.247935	ONLINE	f	[]	\N	0.00	\N	[]	f
30	68ef7970-a20b-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-05 16:51:49.713	Gotowe do realizacji	allegro-pl	9351032	Marti2808	xxa4uxxi68+23935c165@allegromail.pl	\N	Ewelina Martinowska	+48 667 202 822	Nowogrodzka 38	59-730	Nowogrodziec	PL	6912b99a-a20b-11f0-91d4-7961b40d7b05	PAID	P24	t	483.00	PLN	Allegro Kurier DPD	0.00	PLN	483.00	PLN	Kolor siedziska - ES1 - Eko skóra Czarny	t	\N	2025-10-05 16:51:49.713	\N	2025-10-09 19:40:08.266022	ONLINE	f	[{"id": "RFBEOjEwMjY5NjkyMDA1NzFV", "waybill": "1026969200571U", "carrierId": "DPD", "createdAt": "2025-10-07T07:01:40.004Z", "lineItems": [{"id": "68eb0ca0-a20b-11f0-b1e3-b7ce882fc700"}, {"id": "68eb0ca1-a20b-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
8479	4e267400-a75f-11f0-a209-db57faeef72f	\N	\N	2025-10-12 11:34:32.575	Gotowe do realizacji	allegro-pl	15509422	agusia191191	vu6bw4ivus+2cb262fe7@allegromail.pl	\N	Agnieszka Kwiecień	+48 726 315 156	Jakubów 68B	28-313	Imielno	\N	4e75ccbe-a75f-11f0-ae11-e76c74c7cf77	PAID	P24	t	636.00	\N	Allegro Kurier DPD	0.00	PLN	636.00	PLN	\N	t	\N	2025-10-12 11:34:56.299	\N	2025-10-12 11:43:12.087935	ONLINE	f	[]	\N	0.00	\N	[]	f
65	6a9bb600-a15f-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-04 20:21:06.77	Gotowe do realizacji	allegro-pl	94463102	Client:94463102	bpxc0ab8qf+1d648aaf0@allegromail.pl	\N	Marta Olszewska	+48 518 494 007	Piotra Wysockiego 16A / 9	96-300	Żyrardów	PL	a4df2e59-a15f-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	389.99	PLN	\N	t	\N	2025-10-04 20:21:06.77	\N	2025-10-09 19:41:00.64849	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
82	a1606580-a120-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-04 12:51:51.066	Gotowe do realizacji	allegro-pl	100955580	Client:100955580	2inxpnp9b5+7c6f6a699@allegromail.pl	\N	Daniel Stelmaszek	+48 730 869 099	Jana Pawła II 4B / 20	59-700	Bolesławiec	PL	b41bee46-a120-11f0-96eb-67f4404dbe40	PAID	AF	t	523.00	PLN	Allegro Kurier DPD	0.00	PLN	523.00	PLN	\N	t	\N	2025-10-04 12:51:51.066	\N	2025-10-06 19:16:53.328786	ONLINE	f	\N	\N	0.00	\N	\N	f
8495	7411ada0-a760-11f0-8b8d-c5b44d4871fc	\N	\N	2025-10-12 11:42:41.806	Gotowe do realizacji	allegro-pl	50329546	pmuzyczuk	nc6a6h504a+45676c652@allegromail.pl	\N	Paweł Muzyczuk	+48 881 348 755	Kostry 14 A	21-210	Milanów	PL	743080ac-a760-11f0-91d4-7961b40d7b05	PAID	AF	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	es1 wzór	t	\N	2025-10-12 11:42:41.806	\N	2025-10-12 11:43:02.233555	ONLINE	f	[]	\N	0.00	\N	[]	f
86	42cb5c90-a0f9-11f0-baf0-af7ea74e3d0e	\N	\N	2025-10-04 08:09:56.345	Gotowe do realizacji	allegro-pl	44735813	Client:44735813	qz6u7426gc+3909bdc41@allegromail.pl	\N	Karolina Majewska	+48 601 094 628	Rogówko 10 B	87-162	Lubicz Górny	PL	5cadcbfc-a0f9-11f0-baf9-a33944a1116d	PAID	P24	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	tkanina F04	t	\N	2025-10-04 08:09:56.345	\N	2025-10-06 18:16:40.471163	ONLINE	f	\N	\N	0.00	\N	\N	f
7629	a1d33ad0-a3ad-11f0-a3bc-ef5c37833579	\N	\N	2025-10-07 18:49:42.091	Gotowe do realizacji	allegro-pl	4507545	marcus5606	zlybo7xk7y+7f7e1d309@allegromail.pl	\N	Sławomir Telepski	+48 504 616 017	Grażyny 17/8	20-605	Lublin	PL	c19b113f-a3ad-11f0-ae11-e76c74c7cf77	PAID	P24	t	1669.00	PLN	Allegro Kurier DPD	0.00	PLN	1669.00	PLN	Tkanina na obicia F03 Fjord Grafit	t	\N	2025-10-07 18:49:42.091	\N	2025-10-09 19:34:39.487081	ONLINE	f	[]	\N	0.00	\N	[]	f
7617	8fee01d0-a40f-11f0-b871-03a75625f948	\N	\N	2025-10-08 06:26:37.855	Gotowe do realizacji	allegro-pl	21868358	sylwia4258	aqxzyoslha+558841238@allegromail.pl	\N	Sylwia Rejman	+48 607 676 799	T. Kościuszki107	66-016	Nietków	PL	9010a585-a40f-11f0-91d4-7961b40d7b05	PAID	AF	t	1887.00	PLN	Allegro Kurier DPD	0.00	PLN	1887.00	PLN	wieszaki Czernej a kolor obicia welur jasno szart	t	\N	2025-10-08 06:26:37.855	\N	2025-10-09 19:34:20.228418	ONLINE	f	[{"id": "RFBEOjEwMjcxNjM1MjMzMzFV", "waybill": "1027163523331U", "carrierId": "DPD", "createdAt": "2025-10-09T09:36:45.530Z", "lineItems": [{"id": "8fe8aaa0-a40f-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjcxNjM1MjM0MzRV", "waybill": "1027163523434U", "carrierId": "DPD", "createdAt": "2025-10-09T09:36:45.784Z", "lineItems": [{"id": "8fe8aaa0-a40f-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjcxNjM1MjM1NDdV", "waybill": "1027163523547U", "carrierId": "DPD", "createdAt": "2025-10-09T09:36:46.054Z", "lineItems": [{"id": "8fe8aaa0-a40f-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjcxNjM1MjM2NTVV", "waybill": "1027163523655U", "carrierId": "DPD", "createdAt": "2025-10-09T09:36:46.270Z", "lineItems": [{"id": "8fe8aaa0-a40f-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7618	4b642d51-a40a-11f0-a6cc-b3145592fdde	\N	\N	2025-10-08 05:51:28.272	Gotowe do realizacji	allegro-pl	102185335	Client:102185335	2sdgnq87yd+3a6a03da8@allegromail.pl	\N	Paulina Jędruś	+48 506 125 614	Gen. Andersa 34A / 5	42-600	Tarnowskie Góry	PL	4bbb006f-a40a-11f0-a417-fd831f6ae8ec	PAID	AF	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	\N	t	\N	2025-10-08 05:51:28.272	\N	2025-10-09 19:34:22.334641	ONLINE	f	[{"id": "RFBEOjEwMjcwOTU4MjI5MTJV", "waybill": "1027095822912U", "carrierId": "DPD", "createdAt": "2025-10-08T11:51:59.732Z", "lineItems": [{"id": "4b5cda51-a40a-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjcwOTU4MjMwODFV", "waybill": "1027095823081U", "carrierId": "DPD", "createdAt": "2025-10-08T11:51:59.948Z", "lineItems": [{"id": "4b5cda51-a40a-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
96	6d6894b0-a07a-11f0-a6cc-b3145592fdde	\N	\N	2025-10-03 17:01:11.041	Gotowe do realizacji	allegro-pl	54712970	Client:54712970	qgyp4ddcna+7cb2c9843@allegromail.pl	\N	Marta Witkowska	+48 669 763 958	Rzeczna 10	84-123	Mrzezino	PL	8c7ef55c-a07a-11f0-96eb-67f4404dbe40	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	529.99	PLN	\N	f	\N	2025-10-03 17:01:11.041	\N	2025-10-09 19:52:31.15798	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5MDM3MTE0ODZV", "waybill": "1026903711486U", "carrierId": "DPD", "createdAt": "2025-10-06T10:40:16.165Z", "lineItems": [{"id": "6d5d7120-a07a-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7744	19d100b0-a054-11f0-b871-03a75625f948	\N	\N	2025-10-03 12:28:30.79	Gotowe do realizacji	allegro-pl	5638811	chomiczek_20	juv6uofpjb+50265e062@allegromail.pl	\N	Agnieszka Rybienik	+48 667 125 100	ul. Rogozińskiego 3/16	37-700	Przemyśl	PL	1dce1ef8-a054-11f0-91d4-7961b40d7b05	PAID	AF	t	675.00	PLN	Allegro Kurier DPD	0.00	PLN	675.00	PLN	zamiast poduszki ma byc dodatkowa pólka do szafki zgodnie z wczesniejsza rozmową	t	\N	2025-10-03 12:28:30.79	\N	2025-10-09 19:52:44.773914	ONLINE	f	[{"id": "RFBEOjEwMjY5MDIwNzkwMTJV", "waybill": "1026902079012U", "carrierId": "DPD", "createdAt": "2025-10-06T10:31:50.735Z", "lineItems": [{"id": "19cc45c1-a054-11f0-b871-03a75625f948"}, {"id": "19cc45c0-a054-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjY5MDIwNzkxNTNV", "waybill": "1026902079153U", "carrierId": "DPD", "createdAt": "2025-10-06T10:31:51.114Z", "lineItems": [{"id": "19cc45c1-a054-11f0-b871-03a75625f948"}, {"id": "19cc45c0-a054-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7745	c1c0f760-a042-11f0-8c4d-9bd96e1ccd86	\N	\N	2025-10-03 10:23:41.774	Gotowe do realizacji	allegro-pl	102756293	Client:102756293	wy5hfqykfd+e2cd8e96@allegromail.pl	\N	Kinga Filipek	+48 535 268 412	Spacerowa 20 C	08-530	Dęblin	PL	cb99b84e-a042-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	832.99	PLN	Kolor obicia - welur grafitowy 	t	\N	2025-10-03 10:23:41.774	\N	2025-10-09 19:52:46.497018	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY4NDQxMTgxMjhV", "waybill": "1026844118128U", "carrierId": "DPD", "createdAt": "2025-10-06T04:52:28.731Z", "lineItems": [{"id": "c1bba030-a042-11f0-8c4d-9bd96e1ccd86"}]}, {"id": "RFBEOjEwMjY4NDQxMTgyNDhV", "waybill": "1026844118248U", "carrierId": "DPD", "createdAt": "2025-10-06T04:52:28.876Z", "lineItems": [{"id": "c1bba030-a042-11f0-8c4d-9bd96e1ccd86"}]}]	\N	0.00	\N	[]	f
7746	029c0ad0-a03f-11f0-bc5e-258a5e1e619a	\N	\N	2025-10-03 10:04:06.239	Gotowe do realizacji	allegro-pl	86209546	Client:86209546	s1ulppy30x+769529b61@allegromail.pl	\N	Marta Pietrańczyk	+48 665 747 821	Poręba Wielka ul. Lachetówka2	32-600	Poręba Wielka	PL	243d3433-a03f-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	615.99	PLN	\N	t	\N	2025-10-03 10:04:06.239	\N	2025-10-09 19:52:48.104858	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5MDYwMDAzMjJV", "waybill": "1026906000322U", "carrierId": "DPD", "createdAt": "2025-10-06T10:53:22.130Z", "lineItems": [{"id": "029505f0-a03f-11f0-bc5e-258a5e1e619a"}]}, {"id": "RFBEOjEwMjY5MDYwMDA0MTVV", "waybill": "1026906000415U", "carrierId": "DPD", "createdAt": "2025-10-06T10:53:22.380Z", "lineItems": [{"id": "029505f0-a03f-11f0-bc5e-258a5e1e619a"}]}, {"id": "RFBEOjEwMjcxMjg3MTMzMzBV", "waybill": "1027128713330U", "carrierId": "DPD", "createdAt": "2025-10-09T04:14:07Z", "lineItems": [{"id": "029505f0-a03f-11f0-bc5e-258a5e1e619a"}]}]	\N	0.00	\N	[]	f
7748	933c1fe0-a034-11f0-ba82-ed153ccc4447	\N	\N	2025-10-03 08:40:57.259	Gotowe do realizacji	allegro-pl	24345630	alisshiaa	dnxinr3iaf+5b6b9f046@allegromail.pl	\N	Alicja Dąbrowa	+48 663 621 355	Sowia 7B / 38	61-131	Poznań	PL	99e7e362-a034-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	Czarny welur	t	\N	2025-10-03 08:40:57.259	\N	2025-10-09 19:52:51.327492	ONLINE	t	[{"id": "RFBEOjEwMjY5MDc2NjI2MDJV", "waybill": "1026907662602U", "carrierId": "DPD", "createdAt": "2025-10-06T11:04:04.116Z", "lineItems": [{"id": "93373de0-a034-11f0-ba82-ed153ccc4447"}]}]	Szara 11/2	0.00	\N	[]	f
7769	2f4e0e71-9f9a-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-02 14:15:45.56	Gotowe do realizacji	allegro-pl	41766359	Talaxo	dq2itggs7l+23d6608d1@allegromail.pl	\N	Natalia Nowacka 	+48 535 440 934	Wrzesiny 16	98-160	Sędziejowice	PL	2f8af11a-9f9a-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	966.00	PLN	Allegro Kurier DPD	0.00	PLN	966.00	PLN	\N	t	\N	2025-10-02 14:15:45.56	\N	2025-10-09 19:53:23.050134	ONLINE	f	[{"id": "RFBEOjEwMjY3Mjc1MDU0ODNV", "waybill": "1026727505483U", "carrierId": "DPD", "createdAt": "2025-10-03T06:04:41.299Z", "lineItems": [{"id": "2f47cce2-9f9a-11f0-96ea-bf4f56b08af2"}, {"id": "2f47cce1-9f9a-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY3Mjc1MDU1NzBV", "waybill": "1026727505570U", "carrierId": "DPD", "createdAt": "2025-10-03T06:04:41.488Z", "lineItems": [{"id": "2f47cce2-9f9a-11f0-96ea-bf4f56b08af2"}, {"id": "2f47cce1-9f9a-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7770	ec7230b0-9f97-11f0-86d6-599d2223cd68	\N	\N	2025-10-02 13:59:36.392	Gotowe do realizacji	allegro-pl	38728891	PedzacyKefir	pvdiaqhto6+1305df571@allegromail.pl	\N	Marcin Zdanowicz	+48 515 750 925	Aleja wojska Polskiego 16 / 34	05-800	Pruszków	PL	ecaddadc-9f97-11f0-ae11-e76c74c7cf77	PAID	AF	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	\N	f	\N	2025-10-02 13:59:36.392	\N	2025-10-09 19:53:24.66678	ONLINE	f	[{"id": "RFBEOjEwMjY3MjY5OTM1NjNV", "waybill": "1026726993563U", "carrierId": "DPD", "createdAt": "2025-10-03T05:58:14Z", "lineItems": [{"id": "ec69f350-9f97-11f0-86d6-599d2223cd68"}]}]	\N	0.00	\N	[]	f
7779	7cab93f0-9ef9-11f0-a910-6fc8854d80a9	\N	\N	2025-10-01 19:21:16.193	Gotowe do realizacji	allegro-pl	19591819	Joanna0531	lfyotcu4q7+71f6d02a9@allegromail.pl	\N	Joanna Glonka	+48 602 333 941	pl.Świętej Barbary 4 / 2	41-902	Bytom	PL	9fa8568f-9ef9-11f0-ae11-e76c74c7cf77	PAID	P24	t	454.00	PLN	Allegro Kurier DPD	0.00	PLN	454.00	PLN	\N	t	\N	2025-10-01 19:21:16.193	\N	2025-10-09 19:56:36.504283	ONLINE	f	[{"id": "RFBEOjEwMjY2NDA0MjYwNTlV", "waybill": "1026640426059U", "carrierId": "DPD", "createdAt": "2025-10-02T04:38:33.447Z", "lineItems": [{"id": "7ca46800-9ef9-11f0-a910-6fc8854d80a9"}]}]	\N	0.00	\N	[]	f
7781	19377490-9efb-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-01 19:17:24.913	Gotowe do realizacji	allegro-pl	68399891	Client:68399891	scbkxp9q8b+14253f064@allegromail.pl	\N	Beata Kozioł	+48 507 976 102	Wiśniowa Góra, Konopnickiej 31/2	95-020	Andrespol	PL	195dc155-9efb-11f0-baf9-a33944a1116d	PAID	P24	t	600.00	PLN	Allegro Kurier DPD	0.00	PLN	600.00	PLN	\N	t	\N	2025-10-01 19:17:24.913	\N	2025-10-09 19:56:39.284741	ONLINE	f	[{"id": "RFBEOjEwMjY3MjMyNzI5MjFV", "waybill": "1026723272921U", "carrierId": "DPD", "createdAt": "2025-10-03T04:59:02.627Z", "lineItems": [{"id": "19329290-9efb-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY3MjMyNzMwMjhV", "waybill": "1026723273028U", "carrierId": "DPD", "createdAt": "2025-10-03T04:59:02.771Z", "lineItems": [{"id": "19329290-9efb-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjcwMDE5Mjk3NTBV", "waybill": "1027001929750U", "carrierId": "DPD", "createdAt": "2025-10-07T11:01:58Z", "lineItems": [{"id": "19329290-9efb-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7783	9c74d050-9ef6-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-01 19:10:15.625	Anulowane	allegro-pl	22091132	andygut	vs638z6rka+1f95337f8@allegromail.pl	\N	Adrian Chyła	+48 691 323 822	\N	\N	\N	\N	bf3db0f4-9ef6-11f0-b9a1-9fd75769370f	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1332.40	PLN	\N	t	\N	2025-10-01 19:00:32.188	\N	2025-10-09 19:56:42.365344	ONLINE	f	[]	\N	0.00	\N	[]	f
7785	a07eb210-9ef1-11f0-9dc3-f9a3debc1314	\N	\N	2025-10-01 18:09:17.432	Gotowe do realizacji	allegro-pl	26814807	SylwesterMical	id90bp4yxj+63aaae8d2@allegromail.pl	\N	Sylwester MIcał	+48 696 167 721	ul. Leśne Wzgórze 59	35-213	Rzeszów	PL	a0a1cb6e-9ef1-11f0-baf9-a33944a1116d	PAID	AF	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-10-01 18:09:17.432	\N	2025-10-09 19:56:45.005664	ONLINE	f	[{"id": "RFBEOjEwMjY3MjMzMTc5NDNV", "waybill": "1026723317943U", "carrierId": "DPD", "createdAt": "2025-10-03T05:00:05.271Z", "lineItems": [{"id": "a0795ae0-9ef1-11f0-9dc3-f9a3debc1314"}]}]	\N	0.00	\N	[]	f
7789	0999c490-9eef-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-01 17:53:21.613	Gotowe do realizacji	allegro-pl	101260963	Client:101260963	wyt1s80a8q+76769ace2@allegromail.pl	\N	Małgorzata Jankiewicz	+48 505 996 385	Fałata 20a / 3	41-902	Bytom	PL	09c123ae-9eef-11f0-baf9-a33944a1116d	PAID	AF	t	930.00	PLN	Allegro Kurier DPD	0.00	PLN	930.00	PLN	Siedzisko eko skóra pikowana czarna	t	\N	2025-10-01 17:53:21.613	\N	2025-10-09 19:56:50.506069	ONLINE	f	[{"id": "RFBEOjEwMjY2NzM5NTMzMzVV", "waybill": "1026673953335U", "carrierId": "DPD", "createdAt": "2025-10-02T09:29:17.786Z", "lineItems": [{"id": "099509a0-9eef-11f0-96ea-bf4f56b08af2"}, {"id": "099509a1-9eef-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY2NzM5NTM0NzBV", "waybill": "1026673953470U", "carrierId": "DPD", "createdAt": "2025-10-02T09:29:17.961Z", "lineItems": [{"id": "099509a0-9eef-11f0-96ea-bf4f56b08af2"}, {"id": "099509a1-9eef-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7797	10ac49e0-9ed3-11f0-a0f2-ad990a13a62d	\N	\N	2025-10-01 14:31:32.941	Gotowe do realizacji	allegro-pl	38111450	Client:38111450	g4fufv360p+1c1751256@allegromail.pl	\N	Adrian Rugieł	+48 796 405 178	J.Narodowej 91 U1	50-301	Wrocław	PL	1a1c84a3-9ed3-11f0-96eb-67f4404dbe40	PAID	P24	t	434.00	PLN	Allegro Kurier DPD	0.00	PLN	434.00	PLN	\N	t	\N	2025-10-01 14:31:32.941	\N	2025-10-09 19:57:01.41938	ONLINE	t	[{"id": "RFBEOjEwMjY3MjM4MjgwNTZV", "waybill": "1026723828056U", "carrierId": "DPD", "createdAt": "2025-10-03T05:10:11.110Z", "lineItems": [{"id": "10a4f6e0-9ed3-11f0-a0f2-ad990a13a62d"}]}]	Ul. Jedności Narodowej 91/ U1	0.00	\N	[]	f
7817	9162c891-997c-11f0-b7ad-bf8cbe88f0cf	\N	\N	2025-10-02 01:16:12.156	Anulowane	allegro-pl	34257770	Client:34257770	z5j7zw9sdu+a4c98294@allegromail.pl	\N	Dorota Życińska	+48 607 989 771	\N	\N	\N	\N	919a2d11-997c-11f0-ab95-f7c208471a67	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1704.10	PLN	\N	t	\N	\N	\N	2025-10-09 19:54:36.654006	ONLINE	f	[]	\N	0.00	\N	[]	f
7881	3eb44790-9de1-11f0-86f1-176f8757ee95	\N	\N	2025-09-30 09:42:14.277	Gotowe do realizacji	allegro-pl	90892065	Falcon-14-	rp9su4q41p+389242421@allegromail.pl	\N	Krystian Pietruszka	+48 888 664 913	Ubieszyn 200	37-204	Tryńcza	PL	3edbf3f4-9de1-11f0-91d4-7961b40d7b05	PAID	AF	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	H1 czarny, WE1 welur czarny	t	\N	2025-09-30 09:42:14.277	\N	2025-10-09 19:58:00.080525	ONLINE	f	[{"id": "RFBEOjEwMjY2NDY0ODIyNDhV", "waybill": "1026646482248U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:24Z", "lineItems": [{"id": "3eafb3b0-9de1-11f0-86f1-176f8757ee95"}]}, {"id": "RFBEOjEwMjY2NDY0ODIwNDlV", "waybill": "1026646482049U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:25.328Z", "lineItems": [{"id": "3eafb3b0-9de1-11f0-86f1-176f8757ee95"}]}, {"id": "RFBEOjEwMjY2NDY0ODIxNTZV", "waybill": "1026646482156U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:25.472Z", "lineItems": [{"id": "3eafb3b0-9de1-11f0-86f1-176f8757ee95"}]}]	\N	0.00	\N	[]	f
7882	85dfad80-9ddc-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-09-30 09:08:00.451	Gotowe do realizacji	allegro-pl	48995678	Client:48995678	5h9di18g00+593958fc1@allegromail.pl	\N	Urszula Wasielewska	+48 507 682 471	Górki 29	05-155	Leoncin	PL	9122d40f-9ddc-11f0-b9a1-9fd75769370f	PAID	P24	t	193.00	PLN	Allegro Kurier DPD	0.00	PLN	193.00	PLN	\N	t	\N	2025-09-30 09:08:00.451	\N	2025-10-09 19:58:01.535305	ONLINE	f	[{"id": "RFBEOjEwMjY2NDcxMzI1NzdV", "waybill": "1026647132577U", "carrierId": "DPD", "createdAt": "2025-10-02T06:02:49.813Z", "lineItems": [{"id": "85db67c0-9ddc-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
7883	b5d243a0-9ddb-11f0-956d-ab7d0b07bcfc	\N	\N	2025-09-30 09:02:28.042	Gotowe do realizacji	allegro-pl	43076655	Client:43076655	p14qj8aomw+242978729@allegromail.pl	\N	Bożena Rozynek-Kloc	+48 501 975 512	Złota 3 / 20	78-100	Kołobrzeg	PL	d32b8ad7-9ddb-11f0-91d4-7961b40d7b05	PAID	AF	t	454.00	PLN	Allegro Kurier DPD	0.00	PLN	454.00	PLN	\N	t	\N	2025-09-30 09:02:28.042	\N	2025-10-09 19:58:03.011366	ONLINE	f	[{"id": "RFBEOjEwMjY1MjIyMjcyOTdV", "waybill": "1026522227297U", "carrierId": "DPD", "createdAt": "2025-09-30T11:27:55.502Z", "lineItems": [{"id": "b5cd61a0-9ddb-11f0-956d-ab7d0b07bcfc"}]}]	\N	0.00	\N	[]	f
8075	298aa0d0-9a44-11f0-acef-296b8620eb98	\N	\N	2025-09-25 19:17:18.396	Gotowe do realizacji	allegro-pl	103357506	Client:103357506	cr75c23571+7cc6aef81@allegromail.pl	\N	Beata Bereziuk	+48 532 067 273	Pastoriusza, 10 / 6	80-707	Gdansk	PL	3b3c0c51-9a44-11f0-b639-55f338bcddbf	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	1302.99	PLN	\N	f	\N	2025-09-25 19:17:18.396	\N	2025-10-10 09:05:25.990796	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYyNjUwNjYzMTVV", "waybill": "1026265066315U", "carrierId": "DPD", "createdAt": "2025-09-26T05:02:31.529Z", "lineItems": [{"id": "298374e0-9a44-11f0-acef-296b8620eb98"}]}, {"id": "RFBEOjEwMjYyNjUwNjY0ODJV", "waybill": "1026265066482U", "carrierId": "DPD", "createdAt": "2025-09-26T05:02:31.684Z", "lineItems": [{"id": "298374e0-9a44-11f0-acef-296b8620eb98"}]}, {"id": "RFBEOjEwMjYyNjUwNjY1MzFV", "waybill": "1026265066531U", "carrierId": "DPD", "createdAt": "2025-09-26T05:02:31.814Z", "lineItems": [{"id": "298374e0-9a44-11f0-acef-296b8620eb98"}]}, {"id": "RFBEOjEwMjY3MzczNTAwMjRV", "waybill": "1026737350024U", "carrierId": "DPD", "createdAt": "2025-10-03T07:44:54Z", "lineItems": [{"id": "298374e0-9a44-11f0-acef-296b8620eb98"}]}]	\N	0.00	\N	[]	f
8076	73a550c0-9a3a-11f0-b1bc-794ec0214095	\N	\N	2025-09-25 18:08:28.856	Gotowe do realizacji	allegro-pl	40843377	martipop89	q3wjv16322+46ecbbd67@allegromail.pl	\N	Marcin Poprawa	+48 505 145 867	Piękna 4/7	71-081	Szczecin	PL	7c51ed77-9a3a-11f0-83b2-ff1b510348d5	UNPAID	\N	f	\N	\N	Kurier DPD pobranie	22.00	PLN	1305.00	PLN	kolor czarny z brazym drewnem \nszerokość 80 cm\ngłębokość 30 cm \nwysokość 202 cm	f	\N	2025-09-25 18:08:28.856	\N	2025-10-10 09:05:27.116693	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYzMDA3OTMxOTZV", "waybill": "1026300793196U", "carrierId": "DPD", "createdAt": "2025-09-26T11:49:54.239Z", "lineItems": [{"id": "73a0e3f0-9a3a-11f0-b1bc-794ec0214095"}]}, {"id": "RFBEOjEwMjYzMDA3OTMyODhV", "waybill": "1026300793288U", "carrierId": "DPD", "createdAt": "2025-09-26T11:49:54.394Z", "lineItems": [{"id": "73a0e3f0-9a3a-11f0-b1bc-794ec0214095"}]}, {"id": "RFBEOjEwMjYzMDA3OTMzMjlV", "waybill": "1026300793329U", "carrierId": "DPD", "createdAt": "2025-09-26T11:49:54.538Z", "lineItems": [{"id": "73a0e3f0-9a3a-11f0-b1bc-794ec0214095"}]}]	\N	0.00	\N	[]	f
8111	c7165dc0-995f-11f0-b930-877dd2cd2141	\N	\N	2025-09-24 16:17:47.187	Gotowe do realizacji	allegro-pl	26407005	alojzy_jougan	l4z556gahm+387537ec6@allegromail.pl	\N	Michał Kiełbasa	+48 664 083 584	ul. Ludowa 20	64-920	Piła	PL	c73caac9-995f-11f0-84ba-8f13ba8ab30b	PAID	P24	t	1269.00	PLN	Allegro Kurier DPD	0.00	PLN	1269.00	PLN	Kolor tkaniny: TH3 - Tkanina Hugo Grafitowy	t	\N	2025-09-24 16:17:47.187	\N	2025-10-10 09:06:07.565248	ONLINE	f	[{"id": "RFBEOjEwMjYyNjg1ODk2NDJV", "waybill": "1026268589642U", "carrierId": "DPD", "createdAt": "2025-09-26T05:59:58Z", "lineItems": [{"id": "c711f0f0-995f-11f0-b930-877dd2cd2141"}]}, {"id": "RFBEOjEwMjYyNjg1ODk3OTVV", "waybill": "1026268589795U", "carrierId": "DPD", "createdAt": "2025-09-26T05:59:58Z", "lineItems": [{"id": "c711f0f0-995f-11f0-b930-877dd2cd2141"}]}, {"id": "RFBEOjEwMjYyNjg1ODk4NTVV", "waybill": "1026268589855U", "carrierId": "DPD", "createdAt": "2025-09-26T05:59:58Z", "lineItems": [{"id": "c711f0f0-995f-11f0-b930-877dd2cd2141"}]}]	\N	0.00	\N	[]	f
8196	fd85c700-8e0c-11f0-ade3-bbd58d1494c3	\N	\N	2025-09-10 06:12:45.373	Gotowe do realizacji	allegro-pl	20502098	Daw1995id	itflt4gwg4+784ceeaa4@allegromail.pl	\N	Dawid Suwała	+48 792 029 886	Brzyków 36	98-170	Widawa	PL	fdb4c66b-8e0c-11f0-89b4-db2a3c3ca4b7	PAID	P24	t	705.90	PLN	Allegro Kurier DPD	0.00	PLN	705.90	PLN	Tkanina Hugo:\n\nTH1 - Tkanina Hugo Czarny	t	\N	2025-09-10 06:12:45.373	\N	2025-10-10 09:08:40.792367	ONLINE	f	[{"id": "RFBEOjEwMjU1NDAzMTIxMDJV", "waybill": "1025540312102U", "carrierId": "DPD", "createdAt": "2025-09-15T08:58:57.719Z", "lineItems": [{"id": "fd7c7830-8e0c-11f0-ade3-bbd58d1494c3"}]}, {"id": "RFBEOjEwMjU1NDAzMTIyODJV", "waybill": "1025540312282U", "carrierId": "DPD", "createdAt": "2025-09-15T08:58:57.924Z", "lineItems": [{"id": "fd7c7830-8e0c-11f0-ade3-bbd58d1494c3"}]}]	\N	0.00	\N	[]	f
8197	71960de0-8e07-11f0-8d2c-07b2a010202c	\N	\N	2025-09-10 05:33:00.392	Gotowe do realizacji	allegro-pl	14761346	tomekelbud	kl0c42qdly+23bc4c3a3@allegromail.pl	\N	Tomasz Ruszczyk	+48 792 231 875	Nowowiejskiego 47/5	82-200	Malbork	PL	73bc227d-8e07-11f0-89b4-db2a3c3ca4b7	PAID	P24	t	1827.00	PLN	Allegro Kurier DPD	0.00	PLN	1827.00	PLN	TH3 - Tkanina Hugo Grafitowy	t	\N	2025-09-10 05:33:00.392	\N	2025-10-10 09:08:42.263184	ONLINE	f	[{"id": "RFBEOjEwMjU1NDA3MDQ1NDBV", "waybill": "1025540704540U", "carrierId": "DPD", "createdAt": "2025-09-15T09:01:08.582Z", "lineItems": [{"id": "718f5720-8e07-11f0-8d2c-07b2a010202c"}]}, {"id": "RFBEOjEwMjU1NDA3MDQ2NjBV", "waybill": "1025540704660U", "carrierId": "DPD", "createdAt": "2025-09-15T09:01:08.902Z", "lineItems": [{"id": "718f5720-8e07-11f0-8d2c-07b2a010202c"}]}, {"id": "RFBEOjEwMjU1NDA3MDQ3ODVV", "waybill": "1025540704785U", "carrierId": "DPD", "createdAt": "2025-09-15T09:01:09.315Z", "lineItems": [{"id": "718f5720-8e07-11f0-8d2c-07b2a010202c"}]}]	\N	0.00	\N	[]	f
8198	9caaa670-8d68-11f0-af8d-a355c40aec5a	\N	\N	2025-09-10 14:32:23.619	Anulowane	allegro-pl	5600190	RENASAN	r629c806s1+5d0f2f445@allegromail.pl	\N	Patrycja Sanduł	+48 886 088 330	Wiśniowa 1	09-213	Gozdowo	PL	9ce16e55-8d68-11f0-a511-b3d4cdf381f7	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Tkanina obicia czarna eko skóra ES1	t	\N	2025-09-09 10:37:45.696	\N	2025-10-10 09:08:43.751274	ONLINE	f	[{"id": "RFBEOjEwMjUzNDM3MTcwMDNV", "waybill": "1025343717003U", "carrierId": "DPD", "createdAt": "2025-09-11T10:46:05.261Z", "lineItems": [{"id": "9ca4da10-8d68-11f0-af8d-a355c40aec5a"}]}]	\N	326.00	2025-09-10 14:33:28.406	[{"id": "1dd9389e-8e53-11f0-8401-eb74f68b6af5", "order": {"id": "9caaa670-8d68-11f0-af8d-a355c40aec5a"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "9ce16e55-8d68-11f0-a511-b3d4cdf381f7"}, "deposits": [], "createdAt": "2025-09-10T14:33:28.406Z", "lineItems": [{"id": "9ca4da10-8d68-11f0-af8d-a355c40aec5a", "type": "AMOUNT", "value": {"amount": "326.00", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "326.00", "currency": "PLN"}}]	f
8200	7f412a20-8717-11f0-bd05-1f77e3d5b44f	\N	\N	2025-09-10 01:03:02.325	Anulowane	allegro-pl	3757007	irs21	m5qgnrv3zw+e30c6ee7@allegromail.pl	\N	Iwonka Rajza-Spryszyńska	+48 510 079 501	\N	\N	\N	\N	7f990e50-8717-11f0-919c-bfc54d4f7bb1	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	0.00	PLN	423.00	PLN	\N	t	\N	\N	\N	2025-10-10 09:08:45.492832	ONLINE	f	[]	\N	0.00	\N	[]	f
8202	e88172d0-8cf1-11f0-9224-234d838556fa	\N	\N	2025-09-08 20:25:39.17	Gotowe do realizacji	allegro-pl	9707181	M44M	eb3wglhq8s+643201749@allegromail.pl	\N	Jacek Margalski	+48 571 484 295	Nerudy 4 / 51	01-926	Warszawa	PL	e8ad8c75-8cf1-11f0-89b4-db2a3c3ca4b7	PAID	P24	t	193.00	PLN	Allegro Kurier DPD	0.00	PLN	193.00	PLN	\N	t	\N	2025-09-08 20:25:39.17	\N	2025-10-10 09:08:48.547713	ONLINE	f	[{"id": "RFBEOjEwMjUyNTI3OTM0ODFV", "waybill": "1025252793481U", "carrierId": "DPD", "createdAt": "2025-09-10T09:29:43.743Z", "lineItems": [{"id": "e87b5850-8cf1-11f0-9224-234d838556fa"}]}]	\N	0.00	\N	[]	f
8218	f7c2e590-8c9b-11f0-9911-4b86842bcaca	\N	\N	2025-09-08 10:10:05.914	Gotowe do realizacji	allegro-pl	39786871	Bartek__N	zyur9mq8xa+6bca0e4c4@allegromail.pl	\N	Bartosz Najbar	+48 515 931 226	Felińskiego 47/14	41-923	Bytom	PL	f7f76361-8c9b-11f0-a511-b3d4cdf381f7	PAID	AF	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-09-08 10:10:05.914	\N	2025-10-10 09:09:07.88155	ONLINE	f	[{"id": "RFBEOjEwMjUyNTc2MjcwNjJV", "waybill": "1025257627062U", "carrierId": "DPD", "createdAt": "2025-09-10T10:07:06.976Z", "lineItems": [{"id": "f7bcf220-8c9b-11f0-9911-4b86842bcaca"}]}, {"id": "RFBEOjEwMjUyNTc2MjcxNzFV", "waybill": "1025257627171U", "carrierId": "DPD", "createdAt": "2025-09-10T10:07:07.207Z", "lineItems": [{"id": "f7bcf220-8c9b-11f0-9911-4b86842bcaca"}]}]	\N	0.00	\N	[]	f
8224	22ac83d0-8c7c-11f0-973f-af339170d9a3	\N	\N	2025-09-08 06:22:27.225	Gotowe do realizacji	allegro-pl	5534056	kasiaBuczer	6z0ljummoa+26e1654b2@allegromail.pl	\N	Katarzyna Juszczuk	+48 663 125 829	Handlowa 1	34-331	Pewel Mała	PL	22dbf868-8c7c-11f0-89b4-db2a3c3ca4b7	PAID	AF	t	1102.00	PLN	Allegro Kurier DPD	0.00	PLN	1102.00	PLN	\N	t	\N	2025-09-08 06:22:27.225	\N	2025-10-10 09:09:14.910633	ONLINE	f	[{"id": "RFBEOjEwMjUyNjA4ODg0NjFV", "waybill": "1025260888461U", "carrierId": "DPD", "createdAt": "2025-09-10T10:33:09.866Z", "lineItems": [{"id": "22a3d140-8c7c-11f0-973f-af339170d9a3"}, {"id": "22a3d141-8c7c-11f0-973f-af339170d9a3"}]}, {"id": "RFBEOjEwMjUyNjA4ODg1MTJV", "waybill": "1025260888512U", "carrierId": "DPD", "createdAt": "2025-09-10T10:33:10.093Z", "lineItems": [{"id": "22a3d140-8c7c-11f0-973f-af339170d9a3"}, {"id": "22a3d141-8c7c-11f0-973f-af339170d9a3"}]}, {"id": "RFBEOjEwMjUyNjA4ODg2MDRV", "waybill": "1025260888604U", "carrierId": "DPD", "createdAt": "2025-09-10T10:33:10.333Z", "lineItems": [{"id": "22a3d140-8c7c-11f0-973f-af339170d9a3"}, {"id": "22a3d141-8c7c-11f0-973f-af339170d9a3"}]}]	\N	0.00	\N	[]	f
8225	2bc0a6b0-8c7a-11f0-b999-71a0193671a8	\N	\N	2025-09-08 06:13:46.95	Gotowe do realizacji	allegro-pl	105096932	Client:105096932	9xm030jmzg+53cf8a5a1@allegromail.pl	\N	Artur Pasek	+48 698 212 884	Janów 52	26-706	Tczów	PL	2bf91c9a-8c7a-11f0-8938-6fc9c1096c5c	PAID	AF	t	704.00	PLN	Allegro Kurier DPD	0.00	PLN	704.00	PLN	\N	t	\N	2025-09-08 06:13:46.95	\N	2025-10-10 09:09:16.113565	ONLINE	f	[{"id": "RFBEOjEwMjUyNjEwNjE1NzJV", "waybill": "1025261061572U", "carrierId": "DPD", "createdAt": "2025-09-10T10:34:32Z", "lineItems": [{"id": "2bbb4f80-8c7a-11f0-b999-71a0193671a8"}]}, {"id": "RFBEOjEwMjUyNjEwNjE2ODBV", "waybill": "1025261061680U", "carrierId": "DPD", "createdAt": "2025-09-10T10:34:32Z", "lineItems": [{"id": "2bbb4f80-8c7a-11f0-b999-71a0193671a8"}]}]	\N	0.00	\N	[]	f
8226	c7eece30-8c3f-11f0-aeeb-f5bb2ff9b6b9	\N	\N	2025-09-08 23:42:50.287	Anulowane	allegro-pl	9488096	pablosz5	sjb4lu8o2g+2f39833e5@allegromail.pl	\N	Paweł Szczęch	+48 668 623 764	Szynwałd 191A	33-158	Szynwałd	PL	c821029c-8c3f-11f0-8e7f-55e86f66c26b	PAID	AF	t	1064.00	PLN	Allegro Kurier DPD	0.00	PLN	1064.00	PLN	\N	t	\N	2025-09-07 23:11:22.957	\N	2025-10-10 09:09:17.256463	ONLINE	f	[]	\N	1064.00	2025-09-08 23:44:26.099	[{"id": "c0f5c971-8d0d-11f0-85b1-a96385644454", "order": {"id": "c7eece30-8c3f-11f0-aeeb-f5bb2ff9b6b9"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "c821029c-8c3f-11f0-8e7f-55e86f66c26b"}, "deposits": [], "createdAt": "2025-09-08T23:44:26.099Z", "lineItems": [{"id": "c7e8dac0-8c3f-11f0-aeeb-f5bb2ff9b6b9", "type": "AMOUNT", "value": {"amount": "1064.00", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "1064.00", "currency": "PLN"}}]	f
8239	442948f0-875d-11f0-a4db-2f9c265ced69	\N	\N	2025-09-01 18:01:24.516	Gotowe do realizacji	allegro-pl	4970816	pawtomas	r8o2cim6hs+140a9d0b6@allegromail.pl	\N	Paweł Deliś	+48 501 864 687	Kickiego 5 / 55	04-373	Warszawa	PL	6c10bdd6-875d-11f0-919c-bfc54d4f7bb1	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Materiał WE 02 welur jasno szary	t	\N	2025-09-01 18:01:24.516	\N	2025-10-10 09:15:13.068956	ONLINE	f	[{"id": "RFBEOjEwMjQ3Mjc4NDg0ODlV", "waybill": "1024727848489U", "carrierId": "DPD", "createdAt": "2025-09-02T10:09:00.494Z", "lineItems": [{"id": "4423a3a0-875d-11f0-a4db-2f9c265ced69"}]}]	\N	0.00	\N	[]	f
8240	035369d1-875a-11f0-9035-99f977ef67ee	\N	\N	2025-09-01 17:35:23.299	Gotowe do realizacji	allegro-pl	21868358	sylwia4258	aqxzyoslha+3e75868f6@allegromail.pl	\N	Sylwia Rejman	+48 607 676 799	T. Kościuszki107	66-016	Nietków	PL	038c7bb3-875a-11f0-96b8-85ef45c63d69	PAID	AF	t	1827.00	PLN	Allegro Kurier DPD	0.00	PLN	1827.00	PLN	\N	t	\N	2025-09-01 17:35:23.299	\N	2025-10-10 09:15:14.295526	ONLINE	f	[{"id": "RFBEOjEwMjQ3Mjc5OTEwNTBV", "waybill": "1024727991050U", "carrierId": "DPD", "createdAt": "2025-09-02T10:10:18.044Z", "lineItems": [{"id": "034cb312-875a-11f0-9035-99f977ef67ee"}]}, {"id": "RFBEOjEwMjQ3Mjc5OTExNzVV", "waybill": "1024727991175U", "carrierId": "DPD", "createdAt": "2025-09-02T10:10:18.285Z", "lineItems": [{"id": "034cb312-875a-11f0-9035-99f977ef67ee"}]}, {"id": "RFBEOjEwMjQ3Mjc5OTEyODNV", "waybill": "1024727991283U", "carrierId": "DPD", "createdAt": "2025-09-02T10:10:18.551Z", "lineItems": [{"id": "034cb312-875a-11f0-9035-99f977ef67ee"}]}]	\N	1827.00	2025-09-03 04:15:24.264	[{"id": "9d17cbdd-887c-11f0-91e0-6f012c49df20", "order": {"id": "035369d1-875a-11f0-9035-99f977ef67ee"}, "reason": "CANCELLED_BY_BUYER", "status": "SUCCESS", "payment": {"id": "038c7bb3-875a-11f0-96b8-85ef45c63d69"}, "deposits": [], "createdAt": "2025-09-03T04:15:24.264Z", "lineItems": [{"id": "034cb312-875a-11f0-9035-99f977ef67ee", "type": "QUANTITY", "quantity": 1}], "surcharges": [], "totalValue": {"amount": "1827.00", "currency": "PLN"}}]	t
8337	5f3caba0-a5e9-11f0-9b0c-e511fc7361fa	\N	\N	2025-10-10 15:03:11.809	Wypełnione	allegro-pl	10871356	martha744	u8qfjyrmda+53eb6e795@allegromail.pl	\N	Natalia Garczyńska	+48 603 613 323	\N	\N	\N	\N	e547dbdb-a5e9-11f0-91d4-7961b40d7b05	PAID	PAYU	t	1226.00	\N	Allegro Kurier DPD	0.00	PLN	1226.00	PLN	\N	t	\N	2025-10-10 15:05:07.965	\N	2025-10-10 15:05:19.598918	ONLINE	f	[]	\N	0.00	\N	[]	f
8260	87c7ef00-86f2-11f0-8f72-9176775e3e0f	\N	\N	2025-09-01 08:39:09.811	Gotowe do realizacji	allegro-pl	112016258	BuyBoxas	e743b2qu53+591d8d9d3@allegromail.pl	Buyboxas MB	BuyBoxas	+370 648 20196	Żytnia 86	05-850	Duchnice	PL	1d052136-870f-11f0-8ace-d9e9fdebaadd	PAID	PAYU	t	780.00	PLN	Allegro Kurier DPD	0.00	PLN	780.00	PLN	please generate invoice.\n\n46914620	t	\N	2025-09-01 08:39:09.811	\N	2025-10-10 09:15:38.988943	ONLINE	t	[{"id": "RFBEOjEwMjQ3MzM2NTA2NzJV", "waybill": "1024733650672U", "carrierId": "DPD", "createdAt": "2025-09-02T10:57:45.838Z", "lineItems": [{"id": "87c249b0-86f2-11f0-8f72-9176775e3e0f"}]}, {"id": "RFBEOjEwMjQ3MzM2NTA3ODlV", "waybill": "1024733650789U", "carrierId": "DPD", "createdAt": "2025-09-02T10:57:46.120Z", "lineItems": [{"id": "87c249b0-86f2-11f0-8f72-9176775e3e0f"}]}]	Jazminų g. 2	0.00	\N	[]	f
8203	66f458c1-8cee-11f0-99cf-ab03232da32c	\N	\N	2025-09-08 20:02:58.294	Gotowe do realizacji	allegro-pl	104552256	Client:104552256	7pabxyqjx1+2b6daa83@allegromail.pl	\N	Sylwia Bogacka	+48 784 438 519	Gdańska 38/6	14-260	Lubawa	PL	9c769f74-8cee-11f0-8938-6fc9c1096c5c	PAID	P24	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	HUGO GRAFITOWY TH3	f	\N	2025-09-08 20:02:58.294	\N	2025-10-10 10:18:42.842543	ONLINE	f	[{"id": "RFBEOjEwMjUyNTI4Nzg4MTZV", "waybill": "1025252878816U", "carrierId": "DPD", "createdAt": "2025-09-10T09:30:23.942Z", "lineItems": [{"id": "66ecb7a1-8cee-11f0-99cf-ab03232da32c"}]}]	\N	0.00	\N	[]	f
8325	a54f53c0-a5d2-11f0-833e-e3bb93fde64a	\N	\N	2025-10-10 12:16:31.027	Gotowe do realizacji	allegro-pl	3761197	litusia	gxstcxhrb1+2cad174d0@allegromail.pl	Akdil Lidia Trydulska	Lidia Trydulska	+48 608 620 558	Białostocka 33/17	18-300	Zambrów	PL	e188cf68-a5d2-11f0-a417-fd831f6ae8ec	PAID	P24	t	519.00	PLN	Allegro Kurier DPD	0.00	PLN	519.00	PLN	prosze wieszaki w kolorze chrom H2 i siedzisko  w kolorze welur jasnoszary WE2	t	\N	2025-10-10 12:16:31.027	\N	2025-10-10 12:20:02.541601	ONLINE	f	[]	\N	0.00	\N	[]	f
8332	3dce85c0-a5d4-11f0-861f-cb3d7d4327c9	\N	\N	2025-10-10 12:29:09.872	Gotowe do realizacji	allegro-pl	52472448	Client:52472448	mkuryyo0a1+5a28fa162@allegromail.pl	\N	Alina Khomych	+48 538 987 327	ul. Gerberowa 20 / 16	52-221	Wrocław	PL	abe9a101-a5d4-11f0-a284-071dd65bf45d	PAID	PAYU	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-10-10 12:29:09.872	\N	2025-10-10 12:30:02.663054	ONLINE	t	[]	ul. Boczna 2B	0.00	\N	[]	f
8334	9fc75c80-a5e2-11f0-a5d7-371746f07634	\N	\N	2025-10-10 14:23:21.737	Gotowe do realizacji	allegro-pl	3761197	litusia	gxstcxhrb1+3628c3027@allegromail.pl	Akdil Lidia Trydulska	Lidia Trydulska	+48 608 620 558	Białostocka 33/17	18-300	Zambrów	PL	9fece5e6-a5e2-11f0-b9a1-9fd75769370f	PAID	AF	t	600.60	PLN	Allegro Kurier DPD	0.00	PLN	600.60	PLN	\N	t	\N	2025-10-10 14:23:21.737	\N	2025-10-10 14:27:28.459355	ONLINE	f	[]	\N	0.00	\N	[]	f
8335	e444aab0-a5e3-11f0-86f8-1b20137f27b1	\N	\N	2025-10-10 14:18:22.262	Gotowe do realizacji	allegro-pl	36119780	Adwen	a36nkwpkhv+7a08bd0c0@allegromail.pl	\N	Mateusz Broja	+48 576 142 222	ul. Okrąg 5 / 52	00-415	Warszawa	PL	e4b08cb0-a5e3-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-10-10 14:18:22.262	\N	2025-10-10 14:27:39.459464	ONLINE	f	[]	\N	0.00	\N	[]	f
8336	213e5de0-a5e3-11f0-9b0c-e511fc7361fa	\N	\N	2025-10-10 14:14:59.101	Gotowe do realizacji	allegro-pl	90180020	Client:90180020	mjm6y962ad+7bc91dd92@allegromail.pl	\N	Paweł Brajczewski	+48 501 786 396	Puchały 28	18-400	Łomża	PL	2757a59b-a5e3-11f0-ae11-e76c74c7cf77	PAID	P24	t	1136.00	PLN	Allegro Kurier DPD	0.00	PLN	1136.00	PLN	\N	t	\N	2025-10-10 14:14:59.101	\N	2025-10-10 14:27:45.459277	ONLINE	f	[]	\N	0.00	\N	[]	f
8311	29136bb0-a5ce-11f0-8895-094b8cada9e7	\N	\N	2025-10-10 11:44:39.007	Gotowe do realizacji	allegro-pl	43719928	Client:43719928	lpm7chydqm+aa9e1ed2@allegromail.pl	\N	Dawid Cielemęcki	+48 723 772 902	Gospodarcza 19 / 46	08-110	Siedlce	PL	40a44a39-a5ce-11f0-baf9-a33944a1116d	PAID	P24	t	437.99	PLN	Allegro Kurier DPD	14.99	PLN	437.99	PLN	F04 fjord czarny	f	\N	2025-10-10 11:44:39.007	\N	2025-10-10 11:57:15.495963	ONLINE	f	[]	\N	0.00	\N	[]	f
8346	0286d970-a603-11f0-acf3-212576f15d8a	\N	\N	2025-10-10 18:01:46.781	Gotowe do realizacji	allegro-pl	88724312	Client:88724312	mxm6wjm123+1e0be5a89@allegromail.pl	\N	Wiktor Skorupiński	+48 798 130 553	Przemęcka 3	64-234	Nowa Wieś	PL	222d44dd-a603-11f0-96eb-67f4404dbe40	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	756.99	PLN	\N	f	\N	2025-10-10 18:01:46.781	\N	2025-10-10 18:14:06.318187	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
8347	7f9c4050-a601-11f0-86f8-1b20137f27b1	\N	\N	2025-10-10 17:50:57.901	Gotowe do realizacji	allegro-pl	24488597	moniam91	4jg43zvjm0+44f96f4b6@allegromail.pl	\N	monika medwid	+48 662 139 721	Ustecka 38	76-270	Przewłoka	PL	7fd6fffe-a601-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	751.00	PLN	Allegro Kurier DPD	0.00	PLN	751.00	PLN	\N	t	\N	2025-10-10 17:50:57.901	\N	2025-10-10 18:14:14.617168	ONLINE	f	[]	\N	0.00	\N	[]	f
8349	9a0dac40-a605-11f0-805b-5b33cfcb1907	\N	\N	2025-10-10 18:21:18.894	Gotowe do realizacji	allegro-pl	22610202	belmek68	mfo8o7863y+3107899a6@allegromail.pl	\N	Robert Ujma	+48 693 789 226	rzędowie 93	98-331	Nowa Brzeżnica	\N	a44110b6-a605-11f0-96eb-67f4404dbe40	PAID	AF	t	904.20	\N	Allegro Kurier DPD	0.00	PLN	904.20	PLN	tkanina TH1 oraz uchwyty do szafki U1	t	\N	2025-10-10 18:23:32.263	\N	2025-10-10 18:24:08.717366	ONLINE	f	[]	\N	0.00	\N	[]	f
8352	27d863c0-a607-11f0-805b-5b33cfcb1907	\N	\N	2025-10-10 18:32:40.543	Gotowe do realizacji	allegro-pl	44516589	Client:44516589	msiungudrv+38927cd6@allegromail.pl	\N	Małgorzata Sołtys	+48 792 280 402	Studniska Górne 92	59-975	Sulików	PL	28103cdf-a607-11f0-a417-fd831f6ae8ec	PAID	AF	t	312.20	PLN	Allegro Kurier DPD	0.00	PLN	312.20	PLN	Dzień dobry, poproszę o tkaninę Hugo jasno szary TH2\ndziękuję.\npozdrawiam \nMałgorzata 	t	\N	2025-10-10 18:32:40.543	\N	2025-10-10 18:58:47.63957	ONLINE	f	[]	\N	0.00	\N	[]	f
8353	1e795430-a614-11f0-b989-75c7faccd1ca	\N	\N	2025-10-10 20:04:09.59	Gotowe do realizacji	allegro-pl	8993098	EDI734	du9olxiuhg+5b0ea1d95@allegromail.pl	\N	Włodzimierz Borys	+48 508 113 430	ul.Kolonia 6B/2	58-420	Chełmsko Śląskie	PL	1eb3ed15-a614-11f0-ae11-e76c74c7cf77	PAID	AF	t	278.00	PLN	Allegro Kurier DPD	0.00	PLN	278.00	PLN	\N	t	\N	2025-10-10 20:04:09.59	\N	2025-10-10 20:17:50.309765	ONLINE	f	[]	\N	0.00	\N	[]	f
8366	f6ea9f90-a619-11f0-a685-3b2ebe8a80a1	\N	\N	2025-10-10 20:45:28.495	Gotowe do realizacji	allegro-pl	5897457	AdaskoT1	v8f702diep+4ba0f3045@allegromail.pl	\N	Adam Balak	+48 519 534 871	Trzebów 32d/3	67-320	Trzebów	PL	0107201e-a61a-11f0-baf9-a33944a1116d	PAID	AF	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	\N	t	\N	2025-10-10 20:45:28.495	\N	2025-10-10 20:52:33.228359	ONLINE	f	[]	\N	0.00	\N	[]	f
8368	276add70-a61e-11f0-9b0c-e511fc7361fa	\N	\N	2025-10-10 21:15:15.072	Gotowe do realizacji	allegro-pl	87199662	Client:87199662	rph6a1n34f+1c0820d03@allegromail.pl	\N	Emilia  Pomińska	+48 537 503 175	Grunwaldzka 25 / 9	06-330	Chorzele	\N	27a28ff9-a61e-11f0-a284-071dd65bf45d	PAID	AF	t	399.00	\N	Allegro Kurier DPD	0.00	PLN	399.00	PLN	eko skóra czarny ES1	t	\N	2025-10-10 21:15:32.134	\N	2025-10-10 21:57:42.30594	ONLINE	f	[]	\N	0.00	\N	[]	f
8419	07694630-a6d5-11f0-a588-b391296a673a	\N	\N	2025-10-11 19:04:03.989	Gotowe do realizacji	allegro-pl	3350472	szwagierw	cs19hz0vxu+3fbebe668@allegromail.pl	\N	Wojciech Szwagrzyk	+48 785 153 535	Konopnickiej 15	85-124	Bydgoszcz	PL	078867cf-a6d5-11f0-baf9-a33944a1116d	PAID	AF	t	737.00	PLN	Allegro Kurier DPD	0.00	PLN	737.00	PLN	\N	t	\N	2025-10-11 19:04:03.989	\N	2025-10-11 19:06:23.296897	ONLINE	f	[]	\N	0.00	\N	[]	f
8423	e61fb2c2-a6d4-11f0-a5d7-371746f07634	\N	\N	2025-10-11 19:05:48.379	Gotowe do realizacji	allegro-pl	16126305	Bomir-K	j9kh2792tg+244062e44@allegromail.pl	\N	Bogumiła Kotłowska	+48 513 416 191	Sikorskiego 160/30	84-200	Wejherowo	PL	335b1fd5-a6d5-11f0-baf9-a33944a1116d	PAID	AF	t	1015.00	PLN	Allegro Kurier DPD	0.00	PLN	1015.00	PLN	\N	t	\N	2025-10-11 19:05:48.379	\N	2025-10-12 00:12:09.456918	ONLINE	f	[]	\N	0.00	\N	[]	f
8427	a914f320-a6d6-11f0-a685-3b2ebe8a80a1	\N	\N	2025-10-11 19:16:01.541	Gotowe do realizacji	allegro-pl	28664363	karolkor1	7ec3qhjtsp+47edd9700@allegromail.pl	\N	Karol Kordowski	+48 662 645 906	Sympatyczna 28	11-500	Giżycko	\N	a92a296b-a6d6-11f0-b9a1-9fd75769370f	PAID	PAYU	t	1173.00	\N	Allegro Kurier DPD	0.00	PLN	1173.00	PLN	\N	t	\N	2025-10-11 19:19:20.825	\N	2025-10-11 21:16:53.127281	ONLINE	f	[]	\N	0.00	\N	[]	f
3562	898146d0-a2d5-11f0-9468-2bd22967b382	\N	\N	2025-10-06 17:01:25.786	Gotowe do realizacji	allegro-pl	24156578	Client:24156578	hygu52ql8t+29e473597@allegromail.pl	\N	Magdalena Zakrzewska	+48 603 059 844	ul.Pszczyńska 6 C	60-102	Poznań	PL	949f8048-a2d5-11f0-96eb-67f4404dbe40	PAID	P24	t	457.80	PLN	Allegro Kurier DPD	0.00	PLN	457.80	PLN	\N	t	\N	2025-10-06 17:01:25.786	\N	2025-10-06 20:34:43.753422	ONLINE	f	\N	\N	0.00	\N	\N	f
5562	907c6f90-a2e5-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-06 18:52:40.693	Gotowe do realizacji	allegro-pl	5063455	violwicz321	l715sn3opm+6e5eda634@allegromail.pl	\N	Violetta Ziubroniewicz	+48 600 223 482	Namysłowska, 28, 1	46-250	Wołczyn	\N	90a358fb-a2e5-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	326.00	\N	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-10-06 18:57:01.368	\N	2025-10-06 20:34:40.421628	ONLINE	f	\N	\N	0.00	\N	\N	f
4063	35868030-a2db-11f0-8b51-87d1833631ec	\N	\N	2025-10-06 17:38:35.774	Gotowe do realizacji	allegro-pl	4935621	kasiaarndt	u22ba6fw6r+190dbcd37@allegromail.pl	\N	Katarzyna Smoleń	+48 888 762 267	ul. Główna 33	95-040	Kaletnik	PL	35a7ebc4-a2db-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-10-06 17:38:35.774	\N	2025-10-06 20:34:42.05297	ONLINE	f	\N	\N	0.00	\N	\N	f
5262	7a343390-a2e4-11f0-bee6-2fee815ffc9f	\N	\N	2025-10-06 18:45:13.182	Gotowe do realizacji	allegro-pl	101628696	Client:101628696	gih9oss5je+71f89c3d9@allegromail.pl	\N	Szymon Gapinski	+48 661 532 273	Kujawska 6/9	88-153	Kruszwica	PL	8b0e03d4-a2e4-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Kurier DPD pobranie	22.00	PLN	336.00	PLN	EP2	f	\N	2025-10-06 18:45:13.182	\N	2025-10-06 20:34:40.833471	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
4562	b2342af0-a2e1-11f0-aba2-b3553c261cc2	\N	\N	2025-10-06 18:26:20.805	Gotowe do realizacji	allegro-pl	100240883	Client:100240883	vvrncuiwki+229787922@allegromail.pl	\N	Aleksandra Saracka	+48 517 500 946	Dziekanowice 85a	28-440	Dziekanowice	PL	b27b6d4c-a2e1-11f0-96eb-67f4404dbe40	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Wieszak dąb wotan\nKolor haków h1 czarny	t	\N	2025-10-06 18:26:20.805	\N	2025-10-06 20:34:41.2389	ONLINE	f	\N	\N	0.00	\N	\N	f
4062	25f49990-a2db-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-06 17:38:50.551	Gotowe do realizacji	allegro-pl	19743339	patka12348	e6f4d6oa4y+72cbefad6@allegromail.pl	\N	Patrycja Dąbrowska	+48 517 479 298	Swoboda 16E	95-001	Biała	PL	26167a46-a2db-11f0-baf9-a33944a1116d	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Hugo Grafit (TH3)	t	\N	2025-10-06 17:38:50.551	\N	2025-10-06 20:34:41.64475	ONLINE	f	\N	\N	0.00	\N	\N	f
4064	13300610-a2da-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-06 17:30:46.038	Gotowe do realizacji	allegro-pl	651669	dodziu	3nimpglpbm+1d0c107c4@allegromail.pl	\N	Tomasz Dotka	+48 796 727 517	Łąkowa 7/2	62-090	Rokietnica	PL	1365e37c-a2da-11f0-b9a1-9fd75769370f	PAID	AF	t	98.00	PLN	Allegro Kurier DPD	0.00	PLN	98.00	PLN	\N	t	\N	2025-10-06 17:30:46.038	\N	2025-10-06 20:34:42.462722	ONLINE	f	\N	\N	0.00	\N	\N	f
4065	b0967a20-a2d9-11f0-abd8-f5344f24907b	\N	\N	2025-10-06 17:29:42.598	Gotowe do realizacji	allegro-pl	45057119	Client:45057119	ack4u59ivr+17c1e4550@allegromail.pl	\N	Aneta Suchoń	+48 698 483 124	Darwina 4 / 59	43-100	Tychy	PL	f00508d6-a2d9-11f0-a417-fd831f6ae8ec	PAID	P24	t	1283.00	PLN	Allegro Kurier DPD	0.00	PLN	1283.00	PLN	Poproszę białą garderobę, czarne haczyki a na siedzisko i oparcie materiał welur grafit. 	t	\N	2025-10-06 17:29:42.598	\N	2025-10-06 20:34:42.937473	ONLINE	f	\N	\N	0.00	\N	\N	f
2862	0861c630-a2d3-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-06 16:43:00.06	Gotowe do realizacji	allegro-pl	3270348	marcin2123	h4umw7ofsw+f9f68f93@allegromail.pl	\N	Marcin Janiec	+48 605 440 507	Wydrza 254	39-410	Wydrza	PL	0f1a5b0a-a2d3-11f0-baf9-a33944a1116d	PAID	AF	t	1136.00	PLN	Allegro Kurier DPD	0.00	PLN	1136.00	PLN	\N	t	\N	2025-10-06 16:43:00.06	\N	2025-10-06 20:34:44.62111	ONLINE	f	\N	\N	0.00	\N	\N	f
7517	274751f0-a544-11f0-bb74-8b6fbb6f100b	\N	\N	2025-10-09 19:15:39.15	Gotowe do realizacji	allegro-pl	9633306	louisstevens	9nyldwsjgo+c7741a50@allegromail.pl	\N	Błażej Chalecki	+48 609 752 603	Diamentowa 55	21-500	Rakowiska	PL	36d2343a-a544-11f0-91d4-7961b40d7b05	PAID	PAYU	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	\N	t	\N	2025-10-09 19:15:39.15	\N	2025-10-09 19:32:59.478629	ONLINE	f	[]	\N	0.00	\N	[]	f
4066	61869be0-a2d9-11f0-a638-c7e352f2113f	\N	\N	2025-10-06 17:27:03.108	Gotowe do realizacji	allegro-pl	25730455	wojtec9	eyaoc54pmh+4984d3586@allegromail.pl	\N	WOJCIECH ZIELIŃSKI	+48 726 452 827	Chełmińska 29 / 12	78-600	Walcz	PL	74e5b7ae-a2d9-11f0-baf9-a33944a1116d	PAID	P24	t	788.00	PLN	Allegro Kurier DPD	0.00	PLN	788.00	PLN	\N	t	\N	2025-10-06 17:27:03.108	\N	2025-10-06 20:34:43.348278	ONLINE	f	\N	\N	0.00	\N	\N	f
7607	bce878b1-a431-11f0-af7e-5f793825db67	\N	\N	2025-10-08 10:31:20.681	Gotowe do realizacji	allegro-pl	18355524	kasia_galecka	5qniq3hq50+2da9b1f93@allegromail.pl	\N	Katarzyna Gałecka	+48 510 239 621	Szkolna 1 / 3	55-320	Malczyce	PL	bd26940c-a431-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-10-08 10:31:20.681	\N	2025-10-09 19:34:04.745058	ONLINE	f	[]	\N	0.00	\N	[]	f
2162	6189e650-a2d0-11f0-abc1-17dd0035cfdf	\N	\N	2025-10-06 16:22:56.545	Gotowe do realizacji	allegro-pl	39428833	bru_69	2qo6jx0op3+34a54f762@allegromail.pl	\N	Arleta Karpińska	+48 535 991 409	Słowiańska 10b / 15	78-400	Szczecinek	PL	6a8fc682-a2d0-11f0-ae11-e76c74c7cf77	PAID	AF	t	1343.00	PLN	Allegro Kurier DPD	0.00	PLN	1343.00	PLN	Dzień dobry. Tkanina WE1 czarny welur a wieszak H3 złoto szczotkowane. Pozdrawiam	t	\N	2025-10-06 16:22:56.545	\N	2025-10-06 20:34:45.03508	ONLINE	f	\N	\N	0.00	\N	\N	f
1162	aa7dfe50-a2cb-11f0-8144-0ba8ff5b8d19	\N	\N	2025-10-06 15:48:52.111	Gotowe do realizacji	allegro-pl	100961463	Client:100961463	94ueufhuma+10591b4b7@allegromail.pl	\N	Teresa Kondecka	+48 511 630 099	Gotartowicka 37F	44-251	Rybnik	PL	e64b9877-a2cb-11f0-b9a1-9fd75769370f	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	345.99	PLN	Kolor siedziska eko skóra grafit ES3 .	f	\N	2025-10-06 15:48:52.111	\N	2025-10-06 20:34:45.449282	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
6773	0b61c0f0-a2ed-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-06 19:47:14.328	Gotowe do realizacji	allegro-pl	3234709	szumi00_2005	osv4cggk00+52a99a7e1@allegromail.pl	\N	Krzysztof Szubert	+48 502 235 145	Jeziorańska 28	60-461	Poznań	PL	0ee346fa-a2ed-11f0-ae11-e76c74c7cf77	PAID	P24	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	Kolor siedziska: TH3 - Tkanina Hugo Grafitowy	t	\N	2025-10-06 19:47:14.328	\N	2025-10-06 20:34:39.001216	ONLINE	t	\N	\N	0.00	\N	\N	f
6304	c0249260-a2e8-11f0-8144-0ba8ff5b8d19	\N	\N	2025-10-06 19:20:03.259	Gotowe do realizacji	allegro-pl	25737342	Jagus100234	tewvow7o0h+3de764dc4@allegromail.pl	\N	Jagoda Gniazdowska	+48 782 039 386	Starogrodzka 7	63-700	Lutogniew	PL	20dc18aa-a2e9-11f0-a417-fd831f6ae8ec	PAID	P24	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	TH3	t	\N	2025-10-06 19:20:03.259	\N	2025-10-06 20:34:39.460395	ONLINE	f	\N	\N	0.00	\N	\N	f
7518	9b0d65e0-a53d-11f0-a008-2360f331b758	\N	\N	2025-10-09 18:30:09.212	Gotowe do realizacji	allegro-pl	109512317	Client:109512317	9xf199x5rf+750872565@allegromail.pl	\N	Aleksandra Fionik	+48 607 791 187	Konwaliowa 4/21 4 / 21	15-674	Białystok	PL	ca7e05c6-a53d-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	EP2 pik czarny	f	\N	2025-10-09 18:30:09.212	\N	2025-10-09 19:33:01.106023	ONLINE	f	[]	\N	0.00	\N	[]	f
7519	b54142b0-a538-11f0-9da2-81c6f7d897d8	\N	\N	2025-10-09 17:54:29.16	Gotowe do realizacji	allegro-pl	51433172	kupidynsklep24	owdmy4gftg+5bac3d897@allegromail.pl	KUPIDYN RAFAŁ KWIATKOWSKI	Rafał Kwiatkowski	+48 531 847 695	Jarzębinowa 69A / 2	21-007	Krępiec	PL	b57bdb0f-a538-11f0-a284-071dd65bf45d	PAID	P24	t	405.20	PLN	Allegro Kurier DPD	0.00	PLN	405.20	PLN	TH1 - Tkanina Hugo Czarny , proszę o nieuszkodzony, nowy mebel.\nPozdrawiam	t	\N	2025-10-09 17:54:29.16	\N	2025-10-09 19:33:02.474009	ONLINE	f	[]	\N	0.00	\N	[]	f
7640	aa425b30-a397-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-07 16:08:14.471	Gotowe do realizacji	allegro-pl	7812128	ptyska11	p67r4ra55e+6754a49e6@allegromail.pl	\N	Anna Dylińska	+48 509 773 260	Malczewskiego 17b/3	71-612	Szczecin	PL	bbe79181-a397-11f0-a284-071dd65bf45d	PAID	P24	t	447.00	PLN	Allegro Kurier DPD	0.00	PLN	447.00	PLN	\N	t	\N	2025-10-07 16:08:14.471	\N	2025-10-09 19:34:56.309954	ONLINE	f	[]	\N	0.00	\N	[]	f
6973	24befdc0-a2f1-11f0-8144-0ba8ff5b8d19	\N	\N	2025-10-06 20:15:47.012	Gotowe do realizacji	allegro-pl	18918579	Kzrychu-K1	y8owiikt69+295ecb0e8@allegromail.pl	\N	Krzysztof Dwornik	+48 519 125 219	Jana Kantego 29 G	32-650	Kęty	PL	24e4af16-a2f1-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	1807.60	PLN	Allegro Kurier DPD	0.00	PLN	1807.60	PLN	\N	t	\N	2025-10-06 20:15:47.012	\N	2025-10-06 20:34:38.433125	ONLINE	f	\N	\N	0.00	\N	\N	f
5903	c8e0d140-a2e6-11f0-a638-c7e352f2113f	\N	\N	2025-10-06 19:02:13.869	Gotowe do realizacji	allegro-pl	4206245	mmmagdaa	jr2x52eptl+453d60b82@allegromail.pl	\N	Magda Wróbel	+48 606 352 891	ul. Rokicka 4	42-450	Rokitno Szlacheckie	PL	d3005f15-a2e6-11f0-96eb-67f4404dbe40	PAID	AF	t	2884.00	PLN	Allegro Kurier DPD	0.00	PLN	2884.00	PLN	\N	t	\N	2025-10-06 19:02:13.869	\N	2025-10-06 20:34:39.878245	ONLINE	t	\N	\N	0.00	\N	\N	f
7525	137c4160-a537-11f0-9cb2-b90a5baab897	\N	\N	2025-10-09 17:41:49.788	Gotowe do realizacji	allegro-pl	23355766	antonina1859	mumxb1xw1x+637e44d70@allegromail.pl	\N	Sebastian Łaszczewski	+48 696 524 012	Kolejowa 3 / 1	56-320	Krośnice	PL	13cef549-a537-11f0-96eb-67f4404dbe40	PAID	AF	t	76.00	PLN	Allegro Kurier DPD	0.00	PLN	76.00	PLN	\N	t	\N	2025-10-09 17:41:49.788	\N	2025-10-09 19:33:05.168128	ONLINE	f	[]	\N	0.00	\N	[]	f
2962	9a4e25d0-a2d2-11f0-a6cc-b3145592fdde	\N	\N	2025-10-06 16:43:55.09	Gotowe do realizacji	allegro-pl	24840609	PaulinaStecyk	7ah7rhlx9d+11a405ed3@allegromail.pl	\N	Paulina Stecyk	+48 665 928 245	Elizy Orzeszkowej 4e / 7	73-150	Łobez	PL	336c4cd1-a2d3-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Kurier DPD pobranie	22.00	PLN	1354.40	PLN	Haki H2 - Chrom\nSiedzisko i panel WE3 - Welur grafitowy\nPłatność kartą u kuriera	f	\N	2025-10-06 16:43:55.09	\N	2025-10-06 20:34:44.213626	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
7526	69c2c560-a534-11f0-a008-2360f331b758	\N	\N	2025-10-09 17:24:16.631	Gotowe do realizacji	allegro-pl	10333698	maryska_b	890b9n5d6e+5d9352431@allegromail.pl	\N	martyna borkowska	+48 504 753 369	Witosa 1f / 1	10-900	olsztyn	PL	8a5da33c-a534-11f0-a284-071dd65bf45d	PAID	AF	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	ES2 eko skóra jasnoszary 	t	\N	2025-10-09 17:24:16.631	\N	2025-10-09 19:33:06.492133	ONLINE	f	[]	\N	0.00	\N	[]	f
7527	84ca8da0-a527-11f0-a444-6d64b3cc877f	\N	\N	2025-10-09 16:05:40.152	Gotowe do realizacji	allegro-pl	40456283	Secinst	4vd0nmwkj4+6e572c818@allegromail.pl	SECURITAS - INSTALACJE ZENON PACUKIEWICZ	Zenon Pacukiewicz	+48 606 278 448	Klonowica 24 / 5	71-247	Szczecin	PL	383297f6-a528-11f0-91d4-7961b40d7b05	PAID	PAYU	t	1605.98	PLN	Allegro Kurier DPD	29.98	PLN	1605.98	PLN	\N	f	\N	2025-10-09 16:05:40.152	\N	2025-10-09 19:33:07.807719	ONLINE	t	[]	ul. Jesienny Sad 15	0.00	\N	[]	f
7528	78eca3c0-a526-11f0-8895-094b8cada9e7	\N	\N	2025-10-09 16:01:55.31	Gotowe do realizacji	allegro-pl	78381676	izabela_giezek	45fsywqup8+259aba468@allegromail.pl	\N	Anna Michalska	+48 784 377 522	Lipowa 50E / 3	59-180	Gaworzyce	PL	3d212624-a529-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	832.99	PLN	Dzień dobry,\nProszę o wysłanie koloru siedziska takie jak jest na zdjęciu (czarne).\n\nDziękuję 	t	\N	2025-10-09 16:01:55.31	\N	2025-10-09 19:33:09.134561	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7529	6a9651c0-a523-11f0-a204-f12f4b71e7fe	\N	\N	2025-10-09 15:22:17.093	Gotowe do realizacji	allegro-pl	82941713	Client:82941713	fzzkamasdt+7732eaec6@allegromail.pl	\N	Eliza Gałczyńska	+48 505 164 024	Upałty Małe 4/2	11-500	Giżycko	PL	a195e925-a523-11f0-96eb-67f4404dbe40	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	389.99	PLN	\N	t	\N	2025-10-09 15:22:17.093	\N	2025-10-09 19:33:10.435375	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7530	e9aba750-a521-11f0-b989-75c7faccd1ca	\N	\N	2025-10-09 15:14:49.748	Gotowe do realizacji	allegro-pl	29199083	serpent90	19ubcvl8le+1db7bd209@allegromail.pl	\N	Adam Kośnikowski	+48 880 256 389	10, 3-go Maja	68-120	Iłowa	PL	e9e86299-a521-11f0-96eb-67f4404dbe40	PAID	PAYU	t	1332.40	PLN	Allegro Kurier DPD	0.00	PLN	1332.40	PLN	Kolor: F03 Fjord Grafit	t	\N	2025-10-09 15:14:49.748	\N	2025-10-09 19:33:11.777365	ONLINE	f	[]	\N	0.00	\N	[]	f
7531	6d4cfc60-a51a-11f0-a588-b391296a673a	\N	\N	2025-10-09 14:18:24.449	Gotowe do realizacji	allegro-pl	21834983	mruczka240	zmj56e18dq+6fac5ded9@allegromail.pl	\N	Alicja Drozd	+48 724 522 142	Gnojnica 214	39-105	Gnojnica	PL	70814cf1-a51a-11f0-b9a1-9fd75769370f	PAID	P24	t	385.00	PLN	Allegro Kurier DPD	0.00	PLN	385.00	PLN	\N	t	\N	2025-10-09 14:18:24.449	\N	2025-10-09 19:33:13.158206	ONLINE	f	[]	\N	0.00	\N	[]	f
7532	5448b830-a51a-11f0-9bfc-3dd64ee50ad6	\N	\N	2025-10-09 14:18:17.364	Gotowe do realizacji	allegro-pl	86161412	Client:86161412	kuzf2ibpbe+fce55208@allegromail.pl	\N	Magdalena Ratajczak	+48 666 673 307	Romanów 28	98-235	Błaszki	PL	5486d325-a51a-11f0-ae11-e76c74c7cf77	PAID	AF	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	\N	t	\N	2025-10-09 14:18:17.364	\N	2025-10-09 19:33:14.468451	ONLINE	f	[]	\N	0.00	\N	[]	f
7533	b3f8dca0-a516-11f0-a5d7-371746f07634	\N	\N	2025-10-09 13:51:11.355	Gotowe do realizacji	allegro-pl	3894840	Arro77	qudw7466dh+110840545@allegromail.pl	\N	Artur Kaczmarczyk	+48 691 795 430	Socjalna 11 m.10	93-324	Łódź	PL	dbd072f9-a516-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1337.39	PLN	TH3 - Tkanina Hugo Grafitowy\nH1 - Czarny Wieszki\n\nDostawę poproszę po godzinie 14	t	\N	2025-10-09 13:51:11.355	\N	2025-10-09 19:33:15.780528	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7534	8922fc00-a50b-11f0-9b0c-e511fc7361fa	\N	\N	2025-10-09 12:31:56.06	Gotowe do realizacji	allegro-pl	78894080	Client:78894080	o0jutxr2o8+1418a6b80@allegromail.pl	\N	Andrii Fomenko	+48 727 874 071	Przemysłowa 23 / 13	67-200	Głogów	PL	895de2f8-a50b-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	1430.10	PLN	Allegro Kurier DPD	0.00	PLN	1430.10	PLN	Kolor haków :H1 - Czarny\nKolor siedzisk: ES1 - Eko skóra Czarny	t	\N	2025-10-09 12:31:56.06	\N	2025-10-09 19:33:17.087355	ONLINE	f	[]	\N	0.00	\N	[]	f
7535	268f0bd1-a4ff-11f0-b9bf-2795de008363	\N	\N	2025-10-09 11:07:03.89	Gotowe do realizacji	allegro-pl	13241999	5y1a	il4f3vmzoe+585461f62@allegromail.pl	\N	Sylwia Sewastianowicz	+48 691 303 397	Kapitańska 35/37	81-249	Gdynia	PL	2dc4e7a1-a4ff-11f0-b9a1-9fd75769370f	PAID	AF	t	628.00	PLN	Allegro Kurier DPD	0.00	PLN	628.00	PLN	Dzien dobry. Material wierzchni na siedzisko: czarny welur WE1.	t	\N	2025-10-09 11:07:03.89	\N	2025-10-09 19:33:18.40805	ONLINE	f	[]	\N	0.00	\N	[]	f
7536	ce8de6e0-a4fe-11f0-961e-6d069f850ff8	\N	\N	2025-10-09 10:58:16.663	Gotowe do realizacji	allegro-pl	9532379	ania_szablowska	ukfjpgzlk5+74b354060@allegromail.pl	\N	Anna Dzikuć	+48 510 052 065	Ul.Pułaskiego 37a/40	66-620	Gubin	PL	cec54b3b-a4fe-11f0-ae11-e76c74c7cf77	PAID	AF	t	370.00	PLN	Allegro Kurier DPD	0.00	PLN	370.00	PLN	We3 welur grafit	t	\N	2025-10-09 10:58:16.663	\N	2025-10-09 19:33:19.876483	ONLINE	f	[]	\N	0.00	\N	[]	f
7537	8c2ca9a0-a4f7-11f0-a444-6d64b3cc877f	\N	\N	2025-10-09 10:07:54.831	Gotowe do realizacji	allegro-pl	570847	altair1	gth1328whn+dc114dc0@allegromail.pl	\N	Krzysztof Setnik	+48 500 235 485	Stefana Kisielewskiego 7/122	41-219	Sosnowiec	PL	c72233bd-a4f7-11f0-baf9-a33944a1116d	PAID	P24	t	352.00	PLN	Allegro Kurier DPD	0.00	PLN	352.00	PLN	\N	t	\N	2025-10-09 10:07:54.831	\N	2025-10-09 19:33:21.116625	ONLINE	f	[]	\N	0.00	\N	[]	f
32	e4f4e930-a204-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-05 16:05:39.967	Gotowe do realizacji	allegro-pl	15637789	husky091	dcyqf6aglr+481907e30@allegromail.pl	\N	Adam Jankowski	+48 601 572 895	hallera 8/5	88-300	mogilno	PL	f4ae2ea9-a204-11f0-a284-071dd65bf45d	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	tkanina   TH3	t	\N	2025-10-05 16:05:39.967	\N	2025-10-09 19:40:11.385311	ONLINE	f	[{"id": "RFBEOjEwMjY4NDUwOTEwMThV", "waybill": "1026845091018U", "carrierId": "DPD", "createdAt": "2025-10-06T05:04:01.043Z", "lineItems": [{"id": "e4edbd40-a204-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7546	550c2350-a4da-11f0-9b0c-e511fc7361fa	\N	\N	2025-10-09 06:38:57.931	Gotowe do realizacji	allegro-pl	4312052	Y_timer	vg9bfka3j8+67da51d12@allegromail.pl	\N	Dawid Dobecki	+48 600 470 581	Małe Błonia 3	64-920	Piła	PL	5544241b-a4da-11f0-a417-fd831f6ae8ec	PAID	P24	t	352.00	PLN	Allegro Kurier DPD	0.00	PLN	352.00	PLN	Uchwyty CZARNE	t	\N	2025-10-09 06:38:57.931	\N	2025-10-09 19:33:34.232752	ONLINE	f	[]	\N	0.00	\N	[]	f
7547	6af85971-a4d7-11f0-8311-bd038e33f1de	\N	\N	2025-10-09 06:23:12.861	Gotowe do realizacji	allegro-pl	107562636	Client:107562636	u1rwvxfsin+4ab2801b7@allegromail.pl	\N	Andrzej Lelito	+48 882 593 788	29 Listopada 18C / 24	33-300	Nowy Sącz	PL	2b5d2136-a4d8-11f0-96eb-67f4404dbe40	PAID	AF	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	Kolor siedziska THP2  ( Pikowany materiał jasno- szary).  Bardzo Proszę o towar dokładnie zgodny z opisem i jakością wykonania przedstawioną w ofercie sprzedaży oraz solidne zabezpieczenie towaru przed jakimkolwiek innym zniszczeniem w czasie transportu drogowego. Bardzo Proszę o Zrozumienie i pozdrawiam serdecznie.	t	\N	2025-10-09 06:23:12.861	\N	2025-10-09 19:33:35.64642	ONLINE	f	[]	\N	0.00	\N	[]	f
7548	a9d70f60-a4cd-11f0-a588-b391296a673a	\N	\N	2025-10-09 05:09:23.521	Gotowe do realizacji	allegro-pl	10284449	WOLKA8	u7xhxqxpk9+69feec162@allegromail.pl	\N	Kamil Wolski	+48 502 231 760	Hodowców 88b	43-243	Wisła wielka	PL	cb2adcf4-a4cd-11f0-b9a1-9fd75769370f	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1709.99	PLN	Kolor obicia welur głodki WE3\nKolor wieszaków czarny H1	t	\N	2025-10-09 05:09:23.521	\N	2025-10-09 19:33:37.044975	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7555	05ac2481-a472-11f0-a685-3b2ebe8a80a1	\N	\N	2025-10-08 18:32:38.805	Gotowe do realizacji	allegro-pl	35407805	Client:35407805	o0u3e37351+634b37453@allegromail.pl	\N	Katarzyna Hoska	+48 667 264 939	Jeżewo 22/6	63-810	Borek Wielkopolski	PL	ca4c242d-a472-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	977.40	PLN	Kurier DPD	34.00	PLN	977.40	PLN	Siedzisko- eko skóra czarny 	f	\N	2025-10-08 18:32:38.805	\N	2025-10-09 19:33:46.842809	ONLINE	f	[{"id": "RFBEOjEwMjcxODAxNzgyODlV", "waybill": "1027180178289U", "carrierId": "DPD", "createdAt": "2025-10-09T11:59:18.537Z", "lineItems": [{"id": "05a100f2-a472-11f0-a685-3b2ebe8a80a1"}, {"id": "05a100f1-a472-11f0-a685-3b2ebe8a80a1"}]}, {"id": "RFBEOjEwMjcxODAxNzgzNzJV", "waybill": "1027180178372U", "carrierId": "DPD", "createdAt": "2025-10-09T11:59:18.758Z", "lineItems": [{"id": "05a100f2-a472-11f0-a685-3b2ebe8a80a1"}, {"id": "05a100f1-a472-11f0-a685-3b2ebe8a80a1"}]}]	\N	0.00	\N	[]	f
7556	d754ab50-a473-11f0-b12e-53a023ce25d9	\N	\N	2025-10-08 18:24:57.541	Gotowe do realizacji	allegro-pl	41571664	Lin86	fx0un4lw45+426e7526@allegromail.pl	\N	Piotr Linkiewicz	+48 693 455 787	Wiszesława 14/9	71-721	Szczecin	PL	fb39f93d-a473-11f0-91d4-7961b40d7b05	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Witam siedzisko welur grafit 	t	\N	2025-10-08 18:24:57.541	\N	2025-10-09 19:33:48.41784	ONLINE	f	[{"id": "RFBEOjEwMjcxMzEwMjY4NjhV", "waybill": "1027131026868U", "carrierId": "DPD", "createdAt": "2025-10-09T05:03:33.893Z", "lineItems": [{"id": "d74d5850-a473-11f0-b12e-53a023ce25d9"}]}]	\N	0.00	\N	[]	f
7557	a8a50430-a46e-11f0-b989-75c7faccd1ca	\N	\N	2025-10-08 17:48:08.828	Gotowe do realizacji	allegro-pl	6622301	maciej526	u7v3ifaeyr+4cd828370@allegromail.pl	\N	Maciej Pawlak	+48 505 084 620	Kościuszki 12 / 3	67-400	Wschowa	PL	a8e2a9f0-a46e-11f0-a284-071dd65bf45d	PAID	AF	t	335.20	PLN	Allegro Kurier DPD	0.00	PLN	335.20	PLN	Tkanina F04	t	\N	2025-10-08 17:48:08.828	\N	2025-10-09 19:33:49.816947	ONLINE	f	[]	\N	0.00	\N	[]	f
7558	95930970-a46c-11f0-a685-3b2ebe8a80a1	\N	\N	2025-10-08 17:45:03.705	Anulowane	allegro-pl	6622301	maciej526	u7v3ifaeyr+242c16573@allegromail.pl	\N	Maciej Pawlak	+48 505 084 620	Kościuszki 12 / 3	67-400	Wschowa	PL	95b6bef4-a46c-11f0-91d4-7961b40d7b05	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Tkanina F04	t	\N	2025-10-08 17:32:09.367	\N	2025-10-09 19:33:51.19413	ONLINE	f	[]	\N	326.00	2025-10-08 17:45:59.227	[{"id": "a63822e6-a46e-11f0-9a6c-5b23ef27fcef", "order": {"id": "95930970-a46c-11f0-a685-3b2ebe8a80a1"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "95b6bef4-a46c-11f0-91d4-7961b40d7b05"}, "deposits": [], "createdAt": "2025-10-08T17:45:59.227Z", "lineItems": [{"id": "958e7590-a46c-11f0-a685-3b2ebe8a80a1", "type": "AMOUNT", "value": {"amount": "326.00", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "326.00", "currency": "PLN"}}]	f
7606	c0ad0550-a432-11f0-a6cc-b3145592fdde	\N	\N	2025-10-08 10:41:00.893	Gotowe do realizacji	allegro-pl	49535681	Client:49535681	483xs97xtk+43a7031e3@allegromail.pl	\N	LIUDMYLA Śmiałek	+48 722 702 320	Królewicza 3 / 2	66-200	Świebodzin	PL	c0eb6de2-a432-11f0-a284-071dd65bf45d	PAID	AF	t	1283.00	PLN	Allegro Kurier DPD	0.00	PLN	1283.00	PLN	Dzień dobry. Wieszaki złoto szcotkowane . Welur grafitowy ( WE3) dziękuję . Pozdrawiam 	t	\N	2025-10-08 10:41:00.893	\N	2025-10-09 19:34:03.124553	ONLINE	f	[{"id": "RFBEOjEwMjcwOTQ4MTEyNTZV", "waybill": "1027094811256U", "carrierId": "DPD", "createdAt": "2025-10-08T11:43:05.038Z", "lineItems": [{"id": "c0a51610-a432-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjcwOTQ4MTEzNDFV", "waybill": "1027094811341U", "carrierId": "DPD", "createdAt": "2025-10-08T11:43:05.263Z", "lineItems": [{"id": "c0a51610-a432-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjcwOTQ4MTE0NDBV", "waybill": "1027094811440U", "carrierId": "DPD", "createdAt": "2025-10-08T11:43:05.453Z", "lineItems": [{"id": "c0a51610-a432-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7608	36778280-a431-11f0-8f13-933da22fca3d	\N	\N	2025-10-08 10:30:15.503	Gotowe do realizacji	allegro-pl	24622440	Elizz94	lruia3wras+5f27e1801@allegromail.pl	\N	Irmina Kundys	+48 504 989 662	Małęczyńska 21	26-603	Radom	PL	36b9bbc4-a431-11f0-a284-071dd65bf45d	PAID	AF	t	2334.00	PLN	Allegro Kurier DPD	0.00	PLN	2334.00	PLN	Dąb wotan + białe fronty, obicie materiałowe w kolorze niebieskiego weluru 	t	\N	2025-10-08 10:30:15.503	\N	2025-10-09 19:34:06.275499	ONLINE	f	[]	\N	0.00	\N	[]	f
7657	a6fb8ab0-a341-11f0-9a42-bb8e9ffafe52	\N	\N	2025-10-07 05:52:10.974	Gotowe do realizacji	allegro-pl	3274168	rekinek77	dfm9l26k6g+38e8e0711@allegromail.pl	\N	Magdalena Lewandowska	+48 796 603 313	Mała Wieś 2	05-622	Belsk Duży	PL	a726926f-a341-11f0-bb32-51209e96d6bb	PAID	P24	t	432.99	PLN	Allegro Kurier DPD	14.99	PLN	432.99	PLN	\N	f	\N	2025-10-07 05:52:10.974	\N	2025-10-09 19:35:22.641558	ONLINE	f	[]	\N	0.00	\N	[]	f
7540	2cec7420-a4f2-11f0-9da2-81c6f7d897d8	\N	\N	2025-10-09 09:29:25.061	Gotowe do realizacji	allegro-pl	111337136	Client:111337136	2hfupk91w0+235235616@allegromail.pl	\N	Waldemar  Rakowski 	+48 502 930 494	Klonowo 78	89-526	Klonowo	PL	2d29f251-a4f2-11f0-a417-fd831f6ae8ec	PAID	P24	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	\N	t	\N	2025-10-09 09:29:25.061	\N	2025-10-09 19:33:25.766553	ONLINE	f	[]	\N	0.00	\N	[]	f
7541	a9729de0-a4f1-11f0-a402-d9289fd02c21	\N	\N	2025-10-09 09:24:37.524	Gotowe do realizacji	allegro-pl	17620245	macwinnicki	bbpcgmvkek+7a78e4194@allegromail.pl	\N	Martyna Winnicka	+48 515 542 518	Jagiełły 8C / 43	41-219	Sosnowiec	PL	a995dded-a4f1-11f0-baf9-a33944a1116d	PAID	AF	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-09 09:24:37.524	\N	2025-10-09 19:33:27.218214	ONLINE	f	[]	\N	0.00	\N	[]	f
7542	3df7e2c0-a4ef-11f0-b9bf-2795de008363	\N	\N	2025-10-09 09:06:41.301	Gotowe do realizacji	allegro-pl	2556474	aniamuzyk	x39lntlejm+3492962c6@allegromail.pl	\N	Anna Smolarek-Łągiewczyk	+48 792 015 508	Mickiewicza 3	98-170	Widawa	PL	3e253520-a4ef-11f0-91d4-7961b40d7b05	PAID	AF	t	335.20	PLN	Allegro Kurier DPD	0.00	PLN	335.20	PLN	\N	t	\N	2025-10-09 09:06:41.301	\N	2025-10-09 19:33:28.564613	ONLINE	f	[]	\N	0.00	\N	[]	f
7543	b8cfe420-a4ea-11f0-b89d-d9b346103272	\N	\N	2025-10-09 08:36:01.604	Gotowe do realizacji	allegro-pl	23935684	Client:23935684	1uevcwon3v+5ef0f87c9@allegromail.pl	\N	Iwona Łoś	+48 602 116 466	Cisowa 27 / 8	21-040	Świdnik	PL	d7d37f5f-a4ea-11f0-b9a1-9fd75769370f	PAID	AF	t	327.19	PLN	Allegro Kurier DPD	14.99	PLN	327.19	PLN	ES1	f	\N	2025-10-09 08:36:01.604	\N	2025-10-09 19:33:29.989278	ONLINE	f	[]	\N	0.00	\N	[]	f
7544	5ce2e000-a4df-11f0-961e-6d069f850ff8	\N	\N	2025-10-09 07:13:54.111	Gotowe do realizacji	allegro-pl	9488096	pablosz5	sjb4lu8o2g+55e81a2d5@allegromail.pl	\N	Paweł Szczęch	+48 668 623 764	Szynwałd 191A	33-158	Szynwałd	PL	5d1a6bb3-a4df-11f0-a417-fd831f6ae8ec	PAID	AF	t	884.10	PLN	Allegro Kurier DPD	0.00	PLN	884.10	PLN	\N	t	\N	2025-10-09 07:13:54.111	\N	2025-10-09 19:33:31.441819	ONLINE	f	[]	\N	0.00	\N	[]	f
7545	6d4c85d0-a4db-11f0-a444-6d64b3cc877f	\N	\N	2025-10-09 06:45:37.635	Gotowe do realizacji	allegro-pl	24105007	pabl4	wfzmsnt2f7+2045ce863@allegromail.pl	\N	Paulina Blat	+48 661 089 421	Lasowiacka 15	36-105	Cmolas	PL	6d6dc978-a4db-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-10-09 06:45:37.635	\N	2025-10-09 19:33:32.852629	ONLINE	f	[]	\N	0.00	\N	[]	f
7609	97ae46f0-a42d-11f0-a6cc-b3145592fdde	\N	\N	2025-10-08 10:01:04.518	Gotowe do realizacji	allegro-pl	1261425	tommiboss	cab50f9f1y+5bef048d6@allegromail.pl	\N	Tomasz Graniczny	+48 726 150 482	Lazarówka 3	41-935	Bytom	PL	ab735035-a42d-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	317.19	PLN	Tkanina: TH1 HUGO CZARNY	t	\N	2025-10-08 10:01:04.518	\N	2025-10-09 19:34:08.004649	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjcwOTQ5OTM5MzJV", "waybill": "1027094993932U", "carrierId": "DPD", "createdAt": "2025-10-08T11:44:49.580Z", "lineItems": [{"id": "97a6a5d0-a42d-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7610	83027ce0-a42c-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-08 09:54:11.5	Gotowe do realizacji	allegro-pl	40482476	Kamilcia1305	fp8vn0chtv+2540dfde9@allegromail.pl	\N	Kamila Nonckiewicz	+48 695 821 522	Piekary 50C	98-338	Sulmierzyce	PL	a600020d-a42c-11f0-b9a1-9fd75769370f	PAID	AF	t	312.20	PLN	Allegro Kurier DPD	0.00	PLN	312.20	PLN	WE welur niebieski 	t	\N	2025-10-08 09:54:11.5	\N	2025-10-09 19:34:09.582562	ONLINE	f	[{"id": "RFBEOjEwMjcwOTUwOTYwMDlV", "waybill": "1027095096009U", "carrierId": "DPD", "createdAt": "2025-10-08T11:45:39.289Z", "lineItems": [{"id": "82f7f590-a42c-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7625	3f06f230-a3c5-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-07 21:34:53.943	Gotowe do realizacji	allegro-pl	4814806	mmax88	cqyhifo1t4+39bc6c0@allegromail.pl	\N	Michał Wańczyk	+48 796 208 795	Buchowieckiego 30	32-300	Olkusz	PL	3f250185-a3c5-11f0-b9a1-9fd75769370f	PAID	AF	t	437.00	PLN	Allegro Kurier DPD	0.00	PLN	437.00	PLN	proszę o szafkę z tkaniną Hugo THP1 - tkanina hugo pik grafitowy	t	\N	2025-10-07 21:34:53.943	\N	2025-10-09 19:34:33.083616	ONLINE	f	[]	\N	437.00	2025-10-08 07:06:38.348	[{"id": "556a17d7-a415-11f0-adca-df1f4c83d3c5", "order": {"id": "3f06f230-a3c5-11f0-96ea-bf4f56b08af2"}, "reason": "CANCELLED_BY_BUYER", "status": "SUCCESS", "payment": {"id": "3f250185-a3c5-11f0-b9a1-9fd75769370f"}, "deposits": [], "createdAt": "2025-10-08T07:06:38.348Z", "lineItems": [{"id": "3f028560-a3c5-11f0-96ea-bf4f56b08af2", "type": "QUANTITY", "quantity": 1}, {"id": "3f028561-a3c5-11f0-96ea-bf4f56b08af2", "type": "QUANTITY", "quantity": 1}], "surcharges": [], "totalValue": {"amount": "437.00", "currency": "PLN"}}]	t
7626	6fe2d080-a3bc-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-07 21:11:17.346	Gotowe do realizacji	allegro-pl	125672665	Client:125672665	b78hv0518y+48dd74425@allegromail.pl	\N	Klaudia Pobudkiewicz	+48 792 928 407	Kościuszki 25 / 2	87-140	Chełmża	PL	7005742e-a3bc-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	1263.50	PLN	Allegro Kurier DPD	0.00	PLN	1263.50	PLN	wieszak czarny tkanina welur czarny	t	\N	2025-10-07 21:11:17.346	\N	2025-10-09 19:34:35.013449	ONLINE	f	[{"id": "RFBEOjEwMjcwNjAyMjA5NTBV", "waybill": "1027060220950U", "carrierId": "DPD", "createdAt": "2025-10-08T07:16:44.091Z", "lineItems": [{"id": "6fd785e0-a3bc-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjcwNjAyMjEwMTFV", "waybill": "1027060221011U", "carrierId": "DPD", "createdAt": "2025-10-08T07:16:44.314Z", "lineItems": [{"id": "6fd785e0-a3bc-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjcwNjAyMjExNTBV", "waybill": "1027060221150U", "carrierId": "DPD", "createdAt": "2025-10-08T07:16:44.512Z", "lineItems": [{"id": "6fd785e0-a3bc-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
7627	0a1d8ba0-a3b2-11f0-b871-03a75625f948	\N	\N	2025-10-07 19:17:35.232	Gotowe do realizacji	allegro-pl	45986631	falatag	v8nw8r20dg+2c93c12c8@allegromail.pl	\N	Agnieszka Kęsik	+48 506 343 687	Maciejkowa 11/10	71-784	Szczecin	PL	0feb9955-a3b2-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	405.20	PLN	Allegro Kurier DPD	0.00	PLN	405.20	PLN	Siedzisko F03	t	\N	2025-10-07 19:17:35.232	\N	2025-10-09 19:34:36.502939	ONLINE	f	[]	\N	0.00	\N	[]	f
7628	8f91a0b0-a3b1-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-07 19:16:10.607	Gotowe do realizacji	allegro-pl	3837601	magdzia29	xy6kx1v1ux+24452ab16@allegromail.pl	\N	Magdalena Karaś	+48 600 053 649	Nickla 82/10	41-923	Bytom	PL	9d817071-a3b1-11f0-91d4-7961b40d7b05	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	679.29	PLN	Dzień dobry,\nCzy byłaby możliwość dostawy na sobotę 11.10.2025?	t	\N	2025-10-07 19:16:10.607	\N	2025-10-09 19:34:37.971936	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjcxNjUwOTIxMDZV", "waybill": "1027165092106U", "carrierId": "DPD", "createdAt": "2025-10-09T09:49:09Z", "lineItems": [{"id": "8f862f00-a3b1-11f0-b1e3-b7ce882fc700"}]}, {"id": "RFBEOjEwMjcxNjUwOTIyOThV", "waybill": "1027165092298U", "carrierId": "DPD", "createdAt": "2025-10-09T09:49:09Z", "lineItems": [{"id": "8f862f00-a3b1-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
74	dc074280-a134-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-04 15:15:30.453	Gotowe do realizacji	allegro-pl	47903547	ZuzannaKula99	6qktvembj0+1d0698a76@allegromail.pl	\N	Zuzanna Kula	+48 669 525 505	Niklowa 4	85-453	Bydgoszcz	PL	dc2244c4-a134-11f0-91d4-7961b40d7b05	PAID	AF	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	\N	t	\N	2025-10-04 15:15:30.453	\N	2025-10-09 19:41:14.126933	ONLINE	f	[{"id": "RFBEOjEwMjY5NjY4NDk2MTVV", "waybill": "1026966849615U", "carrierId": "DPD", "createdAt": "2025-10-07T06:44:19.968Z", "lineItems": [{"id": "dc02d5b0-a134-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
8351	c6fe5030-a608-11f0-a45a-cf4899467cb9	\N	\N	2025-10-10 18:43:11.651	Gotowe do realizacji	allegro-pl	14568111	amierzejewskaa	t52dwupzd2+6f24d2676@allegromail.pl	\N	Aleksandra Łapińska	+48 516 599 201	Szpitalna 3	18-100	Łapy	PL	d501f665-a608-11f0-b9a1-9fd75769370f	PAID	AF	t	737.00	PLN	Allegro Kurier DPD	0.00	PLN	737.00	PLN	\N	t	\N	2025-10-10 18:43:11.651	\N	2025-10-10 18:58:29.338263	ONLINE	f	[]	\N	0.00	\N	[]	f
7552	dfc1f3f0-a47e-11f0-a4f0-7ba876f09f6f	\N	\N	2025-10-08 19:49:10.098	Gotowe do realizacji	allegro-pl	42049166	Kamilu9825	pwu3lxk9ef+c891d3e7@allegromail.pl	\N	Kamil Urbanek	+48 693 923 901	Tuwima 49/1	59-900	Zgorzelec	PL	dfe5a8fe-a47e-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	1332.40	PLN	Allegro Kurier DPD	0.00	PLN	1332.40	PLN	\N	t	\N	2025-10-08 19:49:10.098	\N	2025-10-09 19:33:42.627656	ONLINE	f	[{"id": "RFBEOjEwMjcxMzA0NTI0NzlV", "waybill": "1027130452479U", "carrierId": "DPD", "createdAt": "2025-10-09T04:53:39.682Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}, {"id": "RFBEOjEwMjcxMzA0NTI1NjZV", "waybill": "1027130452566U", "carrierId": "DPD", "createdAt": "2025-10-09T04:53:39.859Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}, {"id": "RFBEOjEwMjcxMzA0NTI2NDZV", "waybill": "1027130452646U", "carrierId": "DPD", "createdAt": "2025-10-09T04:53:40.052Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}, {"id": "RFBEOjEwMjcxMzA2MDE4NzRV", "waybill": "1027130601874U", "carrierId": "DPD", "createdAt": "2025-10-09T04:56:29.303Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}, {"id": "RFBEOjEwMjcxMzA2MDE5OTVV", "waybill": "1027130601995U", "carrierId": "DPD", "createdAt": "2025-10-09T04:56:29.484Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}, {"id": "RFBEOjEwMjcxMzA2MDIwMDdV", "waybill": "1027130602007U", "carrierId": "DPD", "createdAt": "2025-10-09T04:56:29.685Z", "lineItems": [{"id": "dfb68240-a47e-11f0-a4f0-7ba876f09f6f"}]}]	\N	0.00	\N	[]	f
7553	88fcb1c0-a47b-11f0-a471-6bb0586de370	\N	\N	2025-10-08 19:23:45.81	Gotowe do realizacji	allegro-pl	133864326	Wojtastralis2	7ay0m0qozm+cce3eed5@allegromail.pl	\N	Wojciech Kaczmarek	+48 608 350 301	Dąbrowskiego 153 / 20	60-588	Poznań	PL	04bf96c8-a47c-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	335.20	PLN	Allegro Kurier DPD	0.00	PLN	335.20	PLN	EKO SKÓRA JASNY SZARY ES2	t	\N	2025-10-08 19:23:45.81	\N	2025-10-09 19:33:44.093976	ONLINE	f	[{"id": "RFBEOjEwMjcxNzQzOTg0MjRV", "waybill": "1027174398424U", "carrierId": "DPD", "createdAt": "2025-10-09T11:04:42.326Z", "lineItems": [{"id": "88f62210-a47b-11f0-a471-6bb0586de370"}]}]	\N	0.00	\N	[]	f
7554	a86e7f50-a478-11f0-8895-094b8cada9e7	\N	\N	2025-10-08 18:58:51.018	Gotowe do realizacji	allegro-pl	69688753	Client:69688753	iam58kdsgq+56ce521c6@allegromail.pl	\N	Kamila Zapalska	+48 794 203 096	Rynek 8/6	26-110	Skarżysko - Kamienna	PL	a8a63140-a478-11f0-ae11-e76c74c7cf77	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Ekoskóra Grafit 	t	\N	2025-10-08 18:58:51.018	\N	2025-10-09 19:33:45.474263	ONLINE	f	[{"id": "RFBEOjEwMjcxNzQ0OTI5MTBV", "waybill": "1027174492910U", "carrierId": "DPD", "createdAt": "2025-10-09T11:05:33Z", "lineItems": [{"id": "a867c890-a478-11f0-8895-094b8cada9e7"}]}]	\N	0.00	\N	[]	f
7559	2756b3c0-a45e-11f0-9583-47424f8c2810	\N	\N	2025-10-08 15:50:40.268	Gotowe do realizacji	allegro-pl	48634058	Niki1203	9q8k1nonqm+766803267@allegromail.pl	\N	Nikola Sawka	+48 570 788 321	Szybowcowa 67H / 4	70-843	Szczecin	PL	2b00f7b8-a45e-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	405.20	PLN	Allegro Kurier DPD	0.00	PLN	405.20	PLN	Poproszę tkaninę welur jasno szary (WE2) 	t	\N	2025-10-08 15:50:40.268	\N	2025-10-09 19:33:52.568984	ONLINE	f	[]	\N	0.00	\N	[]	f
7560	5da97f10-a455-11f0-b989-75c7faccd1ca	\N	\N	2025-10-08 14:46:13.498	Anulowane	allegro-pl	66165003	Client:66165003	jat3os9v4h+2c7084cf8@allegromail.pl	\N	Violetta Januszewska	+48 665 128 162	Kaszubska 10	78-400	Szczecinek	PL	5df09aa6-a455-11f0-ae11-e76c74c7cf77	PAID	AF	t	383.79	PLN	Allegro Kurier DPD	14.99	PLN	383.79	PLN	\N	f	\N	2025-10-08 14:45:08.393	\N	2025-10-09 19:33:53.953576	ONLINE	f	[]	\N	383.79	2025-10-08 14:47:11.038	[{"id": "abc90a94-a455-11f0-adca-0d13b73a234b", "order": {"id": "5da97f10-a455-11f0-b989-75c7faccd1ca"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "5df09aa6-a455-11f0-ae11-e76c74c7cf77"}, "delivery": {"value": {"amount": "14.99", "currency": "PLN"}}, "deposits": [], "createdAt": "2025-10-08T14:47:11.038Z", "lineItems": [{"id": "5da1b6e0-a455-11f0-b989-75c7faccd1ca", "type": "AMOUNT", "value": {"amount": "368.80", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "383.79", "currency": "PLN"}}]	f
7611	a92e4620-a426-11f0-96d3-f7121b08a32c	\N	\N	2025-10-08 09:12:49.867	Gotowe do realizacji	allegro-pl	58434299	Client:58434299	451fu3zshz+2627cca32@allegromail.pl	\N	Lucyna Szaraniec	+48 661 378 906	Ul.Leśny Stok 4/52	80-260	Gdańsk	PL	b75cccfe-a426-11f0-baf9-a33944a1116d	PAID	P24	t	335.20	PLN	Allegro Kurier DPD	0.00	PLN	335.20	PLN	Proszę o kolor siedziska welur brązowy WE 4	t	\N	2025-10-08 09:12:49.867	\N	2025-10-09 19:34:11.119521	ONLINE	f	[]	\N	0.00	\N	[]	f
7612	c32a2630-a425-11f0-b1f1-69448e84eb62	\N	\N	2025-10-08 09:07:37.644	Gotowe do realizacji	allegro-pl	44921906	gorznat	ya566vw3ea+7f2bf4426@allegromail.pl	\N	Natalia Gorzałka	+48 510 144 879	okopowa 31 / 21	01-059	warszawa	PL	edd37a88-a425-11f0-baf9-a33944a1116d	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	bardzo prosze o kolor SIEDZISKA ES3 - EKO SKORA GRAFITOWY	t	\N	2025-10-08 09:07:37.644	\N	2025-10-09 19:34:12.650332	ONLINE	f	[{"id": "RFBEOjEwMjcwOTUzMjg2NDBV", "waybill": "1027095328640U", "carrierId": "DPD", "createdAt": "2025-10-08T11:47:55.769Z", "lineItems": [{"id": "c322ac20-a425-11f0-b1f1-69448e84eb62"}]}]	\N	0.00	\N	[]	f
7613	c35e0ed0-a422-11f0-af7e-5f793825db67	\N	\N	2025-10-08 08:46:35.061	Gotowe do realizacji	allegro-pl	122376187	Client:122376187	qb1px6syzp+37e0ec21@allegromail.pl	\N	Ewa Wieckowska	+48 507 409 364	dabrowa19	06-445	strzegowo	PL	3c066d67-a423-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1347.99	PLN	Siedzisko i panel ścienny WE2 (welur jasno szary)\nhaki H3 (złoto szczotkowanie)	t	\N	2025-10-08 08:46:35.061	\N	2025-10-09 19:34:14.18697	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7614	ae6b5810-a41e-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-08 08:16:36.738	Gotowe do realizacji	allegro-pl	41230971	Client:41230971	f9ow5lznvi+2202d8ab4@allegromail.pl	\N	Bartosz Mikulski	+48 530 318 472	os. Pod Lipami 2e / 60	61-628	Poznań	PL	c34469ff-a41e-11f0-a417-fd831f6ae8ec	PAID	AF	t	1750.10	PLN	Allegro Kurier DPD	0.00	PLN	1750.10	PLN	\N	t	\N	2025-10-08 08:16:36.738	\N	2025-10-09 19:34:15.671607	ONLINE	f	[]	\N	0.00	\N	[]	f
18	93c15c40-a233-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 21:49:02.494	Gotowe do realizacji	allegro-pl	81432587	Client:81432587	khz3pnbc46+2e835c1b6@allegromail.pl	\N	Lucjan Szewczyk	+48 668 776 645	Osiedle 700-lecia 6 / 36	32-650	Kęty	PL	9894b6f3-a233-11f0-96eb-67f4404dbe40	PAID	PAYU	t	676.00	PLN	Allegro Kurier DPD	0.00	PLN	676.00	PLN	\N	t	\N	2025-10-05 21:49:02.494	\N	2025-10-09 19:39:48.761018	ONLINE	f	[{"id": "RFBEOjEwMjY5Njc0MDc1NTZV", "waybill": "1026967407556U", "carrierId": "DPD", "createdAt": "2025-10-07T06:48:25.090Z", "lineItems": [{"id": "93baa581-a233-11f0-a6cc-b3145592fdde"}, {"id": "93baa580-a233-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
19	68cb3021-a22d-11f0-954f-f9092bddbf0d	\N	\N	2025-10-05 20:55:55.393	Gotowe do realizacji	allegro-pl	5919292	magdat8	kyqw9kab2w+3aa90e3d0@allegromail.pl	\N	Magdalena Lupzik	+48 883 602 203	E. PLATER 2a /9 	75-348	KOSZALIN	PL	6dd307da-a22d-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-10-05 20:55:55.393	\N	2025-10-09 19:39:50.461152	ONLINE	t	[{"id": "RFBEOjEwMjY5NjQyNTA0ODNV", "waybill": "1026964250483U", "carrierId": "DPD", "createdAt": "2025-10-07T06:25:25.095Z", "lineItems": [{"id": "68c5d8f1-a22d-11f0-954f-f9092bddbf0d"}]}]	E. PLATER 2a /9	0.00	\N	[]	f
21	52cd4060-a228-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 20:23:28.505	Gotowe do realizacji	allegro-pl	46996151	aleksandra19969	p1ejmaixha+46ec67a11@allegromail.pl	\N	Aleksandra Ambroziak	+48 502 893 283	Justynów 52a	08-300	Sokołów Podlaski	PL	f2d96410-a228-11f0-a417-fd831f6ae8ec	PAID	P24	t	564.00	PLN	Allegro Kurier DPD	0.00	PLN	564.00	PLN	\N	t	\N	2025-10-05 20:23:28.505	\N	2025-10-09 19:39:53.773874	ONLINE	f	[{"id": "RFBEOjEwMjY5Njc1NTQ5ODlV", "waybill": "1026967554989U", "carrierId": "DPD", "createdAt": "2025-10-07T06:49:35.789Z", "lineItems": [{"id": "52c3f190-a228-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Njc1NTUwODRV", "waybill": "1026967555084U", "carrierId": "DPD", "createdAt": "2025-10-07T06:49:35.959Z", "lineItems": [{"id": "52c3f190-a228-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7524	201f4571-a537-11f0-b89d-d9b346103272	\N	\N	2025-10-09 17:43:26.635	Gotowe do realizacji	allegro-pl	87562472	Client:87562472	v1ioqro9xp+9eb63636@allegromail.pl	\N	Kaja Makuszewska	+48 667 426 587	Modrakowa 48 / 9	85-864	Bydgoszcz	PL	20ad0713-a537-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	\N	f	\N	2025-10-09 17:43:26.635	\N	2025-10-09 19:53:02.352246	ONLINE	f	[]	\N	0.00	\N	[]	f
7615	76ac5390-a41c-11f0-a40a-ffbafd460211	\N	\N	2025-10-08 08:02:09.335	Gotowe do realizacji	allegro-pl	7120457	michacz4	eez79sg6ql+a5e0f5b1@allegromail.pl	\N	Michał Kupiński	+48 508 163 809	Kasztanowa 3	59-140	Chocianów	PL	d38629d8-a41c-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	832.99	PLN	siedzisko : fjord gafit	t	\N	2025-10-08 08:02:09.335	\N	2025-10-09 19:34:17.210194	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjcwOTU2MDc4NjVV", "waybill": "1027095607865U", "carrierId": "DPD", "createdAt": "2025-10-08T11:50:09Z", "lineItems": [{"id": "76a77190-a41c-11f0-a40a-ffbafd460211"}]}, {"id": "RFBEOjEwMjcwOTU2MDc5NDRV", "waybill": "1027095607944U", "carrierId": "DPD", "createdAt": "2025-10-08T11:50:09Z", "lineItems": [{"id": "76a77190-a41c-11f0-a40a-ffbafd460211"}]}]	\N	0.00	\N	[]	f
7616	2b10c010-a412-11f0-b871-03a75625f948	\N	\N	2025-10-08 06:44:07.079	Gotowe do realizacji	allegro-pl	7935998	monikatn	4vwx90fz41+3e4dec582@allegromail.pl	\N	monika nowak	+48 667 168 344	ul.jana matejki 21	36-100	kolbuszowa	PL	2b2f1e31-a412-11f0-b9a1-9fd75769370f	PAID	AF	t	674.30	PLN	Allegro Kurier DPD	0.00	PLN	674.30	PLN	\N	t	\N	2025-10-08 06:44:07.079	\N	2025-10-09 19:34:18.70771	ONLINE	f	[{"id": "RFBEOjEwMjcxNDg0MDUzNTJV", "waybill": "1027148405352U", "carrierId": "DPD", "createdAt": "2025-10-09T07:37:21.098Z", "lineItems": [{"id": "2b052750-a412-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjcxNDg0MDU0NDVV", "waybill": "1027148405445U", "carrierId": "DPD", "createdAt": "2025-10-09T07:37:21.289Z", "lineItems": [{"id": "2b052750-a412-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
12	ea829fd0-a283-11f0-aba2-b3553c261cc2	\N	\N	2025-10-06 07:13:42.085	Gotowe do realizacji	allegro-pl	11107959	koloop	ml62fin7qr+15e1fac42@allegromail.pl	\N	Marta Kołakowska	+48 516 072 084	Jana Pawła II 23lok c2	05-077	Warszawa	PL	f307b823-a283-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	330.99	PLN	\N	t	\N	2025-10-06 07:13:42.085	\N	2025-10-06 20:34:52.071739	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
13	fe9dd160-a27e-11f0-a6cc-b3145592fdde	\N	\N	2025-10-06 06:41:34.2	Gotowe do realizacji	allegro-pl	24131428	sylkle	1fh44rcylq+2561b7368@allegromail.pl	\N	Sylwia Kleniuk	+48 535 888 349	Robotnicza 20	45-052	Opole	PL	feda3eea-a27e-11f0-a417-fd831f6ae8ec	PAID	AF	t	671.00	PLN	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	2025-10-06 06:41:34.2	\N	2025-10-06 20:34:52.478694	ONLINE	f	\N	\N	0.00	\N	\N	f
14	952bb881-a271-11f0-9468-2bd22967b382	\N	\N	2025-10-06 05:03:11.243	Gotowe do realizacji	allegro-pl	21734126	bassmonster1	6ruy4zz282+682d82112@allegromail.pl	\N	Izabela Śliwińska	+48 722 176 142	Brzostków 43	37-500	Jarosław	PL	956b5a6c-a271-11f0-ae11-e76c74c7cf77	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Ekoskora pikowana czarna 	t	\N	2025-10-06 05:03:11.243	\N	2025-10-06 20:34:52.886558	ONLINE	f	\N	\N	0.00	\N	\N	f
7619	7ed27320-a3fd-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-08 04:16:19.786	Gotowe do realizacji	allegro-pl	14105915	Maniazegar	vdzq002zam+36692e6b6@allegromail.pl	\N	Marzena Kuran	+48 697 202 044	Warynskiego 44 / 10	96-300	Żyrardów	PL	88fb01ee-a3fd-11f0-b9a1-9fd75769370f	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	404.99	PLN	\N	f	\N	2025-10-08 04:16:19.786	\N	2025-10-09 19:34:23.811542	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7620	3bc5ddb0-a3d5-11f0-a6cc-b3145592fdde	\N	\N	2025-10-07 23:28:25.694	Gotowe do realizacji	allegro-pl	71914437	Client:71914437	brjuba1p42+22e019d06@allegromail.pl	\N	Mateusz Grzyb	+48 601 903 199	Św. Wincentego 19 / 7	50-252	Wrocław	PL	3bff8bd3-a3d5-11f0-96eb-67f4404dbe40	PAID	PAYU	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	Th1 hugo czarny	t	\N	2025-10-07 23:28:25.694	\N	2025-10-09 19:34:25.56247	ONLINE	f	[]	\N	0.00	\N	[]	f
15	363671e0-a270-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-06 04:53:43.949	Gotowe do realizacji	allegro-pl	35047482	Seki21695	8gigwp1ekg+7d3cf2551@allegromail.pl	\N	Łukasz Szkaradek	+48 570 457 313	Czecha 3 / 20	33-300	Nowy Sącz	PL	366fd1aa-a270-11f0-a284-071dd65bf45d	PAID	AF	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	kolor siedziska- welur grafitowy WE3	t	\N	2025-10-06 04:53:43.949	\N	2025-10-06 20:34:53.299783	ONLINE	f	\N	\N	0.00	\N	\N	f
10	b5925ca0-a28a-11f0-abd8-f5344f24907b	\N	\N	2025-10-06 08:07:19.936	Gotowe do realizacji	allegro-pl	87353891	Client:87353891	tbkovjlrgh+5e8bfc730@allegromail.pl	\N	Agnieszka Krysiak	+48 608 295 559	Armii Krajowej 56\\23	09-410	Płock	PL	b5d11396-a28a-11f0-a284-071dd65bf45d	PAID	AF	t	471.00	PLN	Allegro Kurier DPD	0.00	PLN	471.00	PLN	uchwyty czarne U1	t	\N	2025-10-06 08:07:19.936	\N	2025-10-06 20:34:51.264554	ONLINE	f	\N	\N	0.00	\N	\N	f
33	9f49fb00-a204-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-05 16:03:08.905	Gotowe do realizacji	allegro-pl	41335273	Client:41335273	hp8kfi5mca+79a394f81@allegromail.pl	\N	Małgorzata Pietrzal	+48 695 145 653	Walecznych 8 / 19	09-410	Płock	PL	bd190df4-a204-11f0-91d4-7961b40d7b05	PAID	PAYU	t	278.00	PLN	Allegro Kurier DPD	0.00	PLN	278.00	PLN	\N	t	\N	2025-10-05 16:03:08.905	\N	2025-10-09 19:40:12.904683	ONLINE	f	[{"id": "RFBEOjEwMjY5NjkzNzE0MzFV", "waybill": "1026969371431U", "carrierId": "DPD", "createdAt": "2025-10-07T07:02:43.343Z", "lineItems": [{"id": "9f451900-a204-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
36	0dc59e40-a200-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 15:30:54.015	Gotowe do realizacji	allegro-pl	12734940	csae	7g2ohrayar+2c6f9e18@allegromail.pl	\N	Anna Wistuba	+49 171 9078018	Zachodnia 7	55-010	Radwanice	PL	17ea0e2b-a200-11f0-96eb-67f4404dbe40	PAID	PAYU	t	842.99	PLN	Allegro Kurier DPD	14.99	PLN	842.99	PLN	\N	f	\N	2025-10-05 15:30:54.015	\N	2025-10-09 19:40:17.518733	ONLINE	f	[{"id": "RFBEOjEwMjY4NzM3MTAwMzlV", "waybill": "1026873710039U", "carrierId": "DPD", "createdAt": "2025-10-06T07:50:34.116Z", "lineItems": [{"id": "0dbe4b40-a200-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY4NzM3MTAyMzhV", "waybill": "1026873710238U", "carrierId": "DPD", "createdAt": "2025-10-06T07:50:34.336Z", "lineItems": [{"id": "0dbe4b40-a200-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7623	bb165360-a3c6-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-07 21:44:17.179	Gotowe do realizacji	allegro-pl	4814806	mmax88	cqyhifo1t4+67e98d1c3@allegromail.pl	\N	Michał Wańczyk	+48 796 208 795	Buchowieckiego 30	32-300	Olkusz	PL	bb4c7f75-a3c6-11f0-ae11-e76c74c7cf77	PAID	P24	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	\N	t	\N	2025-10-07 21:44:17.179	\N	2025-10-09 19:34:29.944915	ONLINE	f	[]	\N	0.00	\N	[]	f
39	8900fcb0-a1f8-11f0-8865-a987ea6c1e01	\N	\N	2025-10-05 14:35:55.709	Gotowe do realizacji	allegro-pl	5325388	BaRtEzZ16LK	sfll8qz28u+69fd1a8d2@allegromail.pl	\N	Krystian Kopiński	+48 83 356 03 13	Szafirowa 19 / 20	20-573	Lublin	PL	97fae9b6-a1f8-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	551.99	PLN	\N	f	\N	2025-10-05 14:35:55.709	\N	2025-10-09 19:40:22.039809	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY4NDI2NDUxMTNV", "waybill": "1026842645113U", "carrierId": "DPD", "createdAt": "2025-10-06T04:31:53Z", "lineItems": [{"id": "88f95b90-a1f8-11f0-8865-a987ea6c1e01"}]}, {"id": "RFBEOjEwMjY4NDI2NDUyMjFV", "waybill": "1026842645221U", "carrierId": "DPD", "createdAt": "2025-10-06T04:31:53Z", "lineItems": [{"id": "88f95b90-a1f8-11f0-8865-a987ea6c1e01"}]}]	\N	0.00	\N	[]	f
5	8d77a490-a2a4-11f0-8d49-a16d7ed74f8d	\N	\N	2025-10-06 11:09:26.075	Gotowe do realizacji	allegro-pl	75893655	Client:75893655	fdj4i81w9p+4195ef356@allegromail.pl	\N	Marta Barys	+48 690 433 089	Mochnackiego 9/13 / 16	93-160	Łódź	PL	9d8dafa1-a2a4-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	541.20	PLN	Allegro Kurier DPD	0.00	PLN	541.20	PLN	TH3 - Tkanina Hugo Grafitowy\n\n	t	\N	2025-10-06 11:09:26.075	\N	2025-10-06 20:34:49.071642	ONLINE	f	\N	\N	0.00	\N	\N	f
40	caf7ce70-a1f6-11f0-9468-2bd22967b382	\N	\N	2025-10-05 14:29:01.752	Gotowe do realizacji	allegro-pl	46424598	MarcjannaK	arkvlb82z8+7445400b4@allegromail.pl	\N	Marcjanna Kozicka	+48 798 292 906	Żarska Wieś 91	59-900	Zgorzelec	PL	9269177c-a1f7-11f0-a417-fd831f6ae8ec	PAID	P24	t	1668.00	PLN	Allegro Kurier DPD	0.00	PLN	1668.00	PLN	\N	t	\N	2025-10-05 14:29:01.752	\N	2025-10-09 19:40:23.4191	ONLINE	f	[{"id": "RFBEOjEwMjY5NzIzNTU0MjBV", "waybill": "1026972355420U", "carrierId": "DPD", "createdAt": "2025-10-07T07:23:12.775Z", "lineItems": [{"id": "caf0a280-a1f6-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NzIzNTU1MDlV", "waybill": "1026972355509U", "carrierId": "DPD", "createdAt": "2025-10-07T07:23:12.964Z", "lineItems": [{"id": "caf0a280-a1f6-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NzIzNTU2ODlV", "waybill": "1026972355689U", "carrierId": "DPD", "createdAt": "2025-10-07T07:23:13.165Z", "lineItems": [{"id": "caf0a280-a1f6-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7621	bd085b30-a3cd-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-07 22:37:03.799	Gotowe do realizacji	allegro-pl	19852095	calineczka_ania	t005n3nk91+214566759@allegromail.pl	\N	Anna Mitoraj-Broda	+48 504 980 955	Wieniawskiego 18	27-400	Ostrowiec Świętokrzyski	PL	c60bf166-a3cd-11f0-baf9-a33944a1116d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	830.99	PLN	Proszę kolor wieszaków czarny H1 , kolor obicia czarny pikiowany EP2 . (ZAMOWILEM ROWNIEŻ TAKA SAMA SZAFKE W KOLORZE BIAŁYM, PROSZĘ O nierealizowanie tamtego zamówienia ponieważ była to pomyłka) pozdrawiam .	f	\N	2025-10-07 22:37:03.799	\N	2025-10-09 19:34:27.019116	CASH_ON_DELIVERY	t	[{"id": "RFBEOjEwMjcwNDYyNTczMzZV", "waybill": "1027046257336U", "carrierId": "DPD", "createdAt": "2025-10-08T05:21:20.568Z", "lineItems": [{"id": "bd041570-a3cd-11f0-bfbd-d3aacc6a2e00"}]}]	H. Wieniawskiego 18	0.00	\N	[]	f
3	05ff2210-a2a7-11f0-a638-c7e352f2113f	\N	\N	2025-10-06 11:27:11.398	Gotowe do realizacji	allegro-pl	9970384	Przemekpp5555	it5ppicacs+218fe3f24@allegromail.pl	\N	Przemysław Karpiński	+48 667 253 776	Pl. Konstytucji 12	78-500	Drawsko Pom.	PL	37916962-a2a7-11f0-b9a1-9fd75769370f	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	56.99	PLN	Ekoskóra gładka:\nES1 - Eko skóra Czarny	f	\N	2025-10-06 11:27:11.398	\N	2025-10-06 20:34:48.36032	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
7	59852450-a295-11f0-bee6-2fee815ffc9f	\N	\N	2025-10-06 09:18:28.596	Gotowe do realizacji	allegro-pl	50539956	Client:50539956	xzdek9aiyu+52e09dae4@allegromail.pl	\N	Karolina Wałęga	+48 693 642 654	Iwanowice Dworskie, ul. Jurajska 27	32-095	Iwanowice	PL	5bfe3b37-a295-11f0-a417-fd831f6ae8ec	PAID	AF	t	229.00	PLN	Allegro Kurier DPD	0.00	PLN	229.00	PLN	\N	t	\N	2025-10-06 09:18:28.596	\N	2025-10-06 20:34:50.028838	ONLINE	t	\N	\N	0.00	\N	\N	f
8	d840e830-a293-11f0-997b-19b8e7655382	\N	\N	2025-10-06 09:10:41.791	Gotowe do realizacji	allegro-pl	5082501	kroll77777	fxsxm0va3c+73e4c9c23@allegromail.pl	\N	Piotr Knop	+48 693 922 766	Łazowskiego 40 / 39	93-379	łódź	PL	f08474b0-a293-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-10-06 09:10:41.791	\N	2025-10-06 20:34:50.440623	ONLINE	t	\N	\N	0.00	\N	\N	f
6	5bd33960-a29d-11f0-a638-c7e352f2113f	\N	\N	2025-10-06 10:17:07.15	Gotowe do realizacji	allegro-pl	17040546	pawelbisewski	42vcsw41xu+769f258f0@allegromail.pl	\N	Paweł Bisewski	+48 502 604 416	Sikorskiego 4 m 22	95-070	Aleksandrów Łódzki	PL	5c174753-a29d-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	1807.60	PLN	Allegro Kurier DPD	0.00	PLN	1807.60	PLN	haki czarne, tkanina hugo czarna th1	t	\N	2025-10-06 10:17:07.15	\N	2025-10-06 20:34:49.624446	ONLINE	f	\N	\N	0.00	\N	\N	f
31	2aff7c30-a208-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 16:32:55.307	Gotowe do realizacji	allegro-pl	108778565	Client:108778565	sbeo45d60s+58a5917d7@allegromail.pl	\N	Patrycja Olek	+48 791 510 689	Wajdy 10 / 13	40-175	Katowice	PL	c707f226-a208-11f0-ae11-e76c74c7cf77	PAID	P24	t	780.00	PLN	Allegro Kurier DPD	0.00	PLN	780.00	PLN	ES1- Eko skóra Czarny	t	\N	2025-10-05 16:32:55.307	\N	2025-10-09 19:40:09.875236	ONLINE	f	[{"id": "RFBEOjEwMjY4NjE3NjQ2NzJV", "waybill": "1026861764672U", "carrierId": "DPD", "createdAt": "2025-10-06T06:49:24.448Z", "lineItems": [{"id": "2af87750-a208-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY4NjE3NjQ3OTNV", "waybill": "1026861764793U", "carrierId": "DPD", "createdAt": "2025-10-06T06:49:24.640Z", "lineItems": [{"id": "2af87750-a208-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
43	d63f36f0-a1f2-11f0-b871-03a75625f948	\N	\N	2025-10-05 13:55:18.2	Gotowe do realizacji	allegro-pl	60832280	Client:60832280	p4w41eeb35+343b49e75@allegromail.pl	\N	katarzyna Nowak	+48 730 896 213	Jabłoniowa 32a	62-090	ROGIEROWKO	PL	d6607aaf-a1f2-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-10-05 13:55:18.2	\N	2025-10-09 19:40:27.941967	ONLINE	f	[{"id": "RFBEOjEwMjY4NjIxMzkwMjRV", "waybill": "1026862139024U", "carrierId": "DPD", "createdAt": "2025-10-06T06:51:16.944Z", "lineItems": [{"id": "d63af130-a1f2-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
50	a209e250-a1d8-11f0-aa33-a79405b55c6d	\N	\N	2025-10-05 10:49:18.387	Gotowe do realizacji	allegro-pl	10695381	Master1514	6up6oqwmo7+2eacaf502@allegromail.pl	\N	Wojciech Wojewódka	+48 781 448 945	Jawornik, 35	38-114	Niebylec	PL	efdad86e-a1d8-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	642.99	PLN	\N	t	\N	2025-10-05 10:49:18.387	\N	2025-10-09 19:40:37.130684	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzU3OTYyODhV", "waybill": "1026975796288U", "carrierId": "DPD", "createdAt": "2025-10-07T07:47:19Z", "lineItems": [{"id": "a2030480-a1d8-11f0-aa33-a79405b55c6d"}]}, {"id": "RFBEOjEwMjY5NzU3OTYzMDVV", "waybill": "1026975796305U", "carrierId": "DPD", "createdAt": "2025-10-07T07:47:19Z", "lineItems": [{"id": "a2030480-a1d8-11f0-aa33-a79405b55c6d"}]}]	\N	0.00	\N	[]	f
54	33875f10-a1ce-11f0-954f-f9092bddbf0d	\N	\N	2025-10-05 09:36:51.369	Gotowe do realizacji	allegro-pl	12392705	cezaryoo7	o8mqtphsix+599812807@allegromail.pl	\N	cezary pyra	+48 608 795 880	Karszew 35	98-100	Łask	PL	be07c340-a1ce-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	425.19	PLN	\N	f	\N	2025-10-05 09:36:51.369	\N	2025-10-09 19:40:43.902051	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzY1Nzk4ODlV", "waybill": "1026976579889U", "carrierId": "DPD", "createdAt": "2025-10-07T07:53:12.962Z", "lineItems": [{"id": "337c3b80-a1ce-11f0-954f-f9092bddbf0d"}]}]	\N	0.00	\N	[]	f
85	d0b6e280-a0fa-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-04 08:21:50.98	Gotowe do realizacji	allegro-pl	74675843	Client:74675843	ax4pd47iq2+5d420f6a2@allegromail.pl	\N	Agnieszka Thakkar	+48 695 855 675	NOWODWORSKA 27 / 8	16-315	Lipsk	PL	f76f2677-a0fa-11f0-b9a1-9fd75769370f	PAID	AF	t	510.00	PLN	Allegro Kurier DPD	0.00	PLN	510.00	PLN	kolor siedziska Hugo Brązowy 	t	\N	2025-10-04 08:21:50.98	\N	2025-10-06 18:44:05.727554	ONLINE	f	\N	\N	0.00	\N	\N	f
55	4e91fa90-a1ce-11f0-954f-f9092bddbf0d	\N	\N	2025-10-05 09:34:01.576	Gotowe do realizacji	allegro-pl	94463102	Client:94463102	bpxc0ab8qf+1c3c950c8@allegromail.pl	\N	Marta Olszewska	+48 518 494 007	Piotra Wysockiego 16A / 9	96-300	Żyrardów	PL	5f98ce13-a1ce-11f0-91d4-7961b40d7b05	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	696.99	PLN	\N	t	\N	2025-10-05 09:34:01.576	\N	2025-10-09 19:40:45.426522	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NjU5MDEwMjBV", "waybill": "1026965901020U", "carrierId": "DPD", "createdAt": "2025-10-07T06:37:21.828Z", "lineItems": [{"id": "4e8d66b0-a1ce-11f0-954f-f9092bddbf0d"}]}, {"id": "RFBEOjEwMjY5NjU5MDExNjFV", "waybill": "1026965901161U", "carrierId": "DPD", "createdAt": "2025-10-07T06:37:22.035Z", "lineItems": [{"id": "4e8d66b0-a1ce-11f0-954f-f9092bddbf0d"}]}]	\N	0.00	\N	[]	f
57	65d8f0a0-a1c9-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-05 08:59:31.756	Gotowe do realizacji	allegro-pl	105223917	wiktoria_1410	66izfjo1we+6d12298a6@allegromail.pl	\N	Wiktoria  Dominikowska	+48 722 059 645	Al. Chopina 16/38	87-800	Włocławek	PL	7936ac74-a1c9-11f0-96eb-67f4404dbe40	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	734.99	PLN	\N	f	\N	2025-10-05 08:59:31.756	\N	2025-10-09 19:40:48.482457	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzY3NDQzMTNV", "waybill": "1026976744313U", "carrierId": "DPD", "createdAt": "2025-10-07T07:54:31.312Z", "lineItems": [{"id": "65d12870-a1c9-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY5NzY3NDQ0MjBV", "waybill": "1026976744420U", "carrierId": "DPD", "createdAt": "2025-10-07T07:54:31.559Z", "lineItems": [{"id": "65d12870-a1c9-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
59	7eb9b2d0-a1bf-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-05 07:47:22.551	Gotowe do realizacji	allegro-pl	26164791	JANKO3103	nbhtkvfefk+175ca7414@allegromail.pl	\N	JANUSZ SZCZYGLAK	+48 660 669 616	Wygoda 5a	06-300	Przasnysz	PL	7ece2554-a1bf-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	\N	t	\N	2025-10-05 07:47:22.551	\N	2025-10-09 19:40:51.486052	ONLINE	f	[{"id": "RFBEOjEwMjY4NjA0MTUyNjRV", "waybill": "1026860415264U", "carrierId": "DPD", "createdAt": "2025-10-06T06:42:27.804Z", "lineItems": [{"id": "7eb56d10-a1bf-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
62	00cde260-a16f-11f0-a6cc-b3145592fdde	\N	\N	2025-10-04 22:11:46.229	Gotowe do realizacji	allegro-pl	22912167	wiewiora167	a3a0s7noco+3143deac4@allegromail.pl	\N	Sylwia Ferenz	+48 668 667 749	Ul. Anny Walentynowicz  5 /6	58-370	Boguszow-Gorce	PL	0106307b-a16f-11f0-ae11-e76c74c7cf77	PAID	AF	t	434.90	PLN	Allegro Kurier DPD	0.00	PLN	434.90	PLN	\N	t	\N	2025-10-04 22:11:46.229	\N	2025-10-09 19:40:56.295878	ONLINE	f	[{"id": "RFBEOjEwMjY4NDMzMDI4ODNV", "waybill": "1026843302883U", "carrierId": "DPD", "createdAt": "2025-10-06T04:40:26.428Z", "lineItems": [{"id": "00c72ba0-a16f-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7622	3ccf7490-a3cc-11f0-a6cc-b3145592fdde	\N	\N	2025-10-07 22:27:10.887	Gotowe do realizacji	allegro-pl	19852095	calineczka_ania	t005n3nk91+6ac2a7e77@allegromail.pl	\N	Anna Mitoraj-Broda	+48 504 980 955	Wieniawskiego 18	27-400	Ostrowiec Świętokrzyski	PL	6d9173cb-a3cc-11f0-bb32-51209e96d6bb	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	830.99	PLN	Kolor wieszaków czarny h1 , kolor obicia czarna pikowana skórą EP2	f	\N	2025-10-07 22:27:10.887	\N	2025-10-09 19:34:28.488246	CASH_ON_DELIVERY	t	[]	H. Wieniawskiego 18	0.00	\N	[]	f
67	f041b5b0-a14c-11f0-a6cc-b3145592fdde	\N	\N	2025-10-04 18:10:02.239	Gotowe do realizacji	allegro-pl	17900738	Aneta87-Sylwek	e9ydxg9tng+69d3dd938@allegromail.pl	\N	Aneta Bledziewska	+48 727 925 447	Północna 39	87-300	Brodnica	PL	f07fd100-a14c-11f0-ae11-e76c74c7cf77	PAID	AF	t	67.00	PLN	Allegro Kurier DPD	0.00	PLN	67.00	PLN	czarny welur 	t	\N	2025-10-04 18:10:02.239	\N	2025-10-09 19:41:03.693467	ONLINE	f	[{"id": "RFBEOjEwMjY4NDU5ODQ1NzVV", "waybill": "1026845984575U", "carrierId": "DPD", "createdAt": "2025-10-06T05:11:36.439Z", "lineItems": [{"id": "f03afef0-a14c-11f0-a6cc-b3145592fdde"}, {"id": "f03afef1-a14c-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
68	28710f90-a14c-11f0-9468-2bd22967b382	\N	\N	2025-10-04 18:07:14.254	Gotowe do realizacji	allegro-pl	41757376	MarGaj998	cb4zprzp20+6f270e4f3@allegromail.pl	\N	Marcin Gajewski	+48 733 800 965	Mokruska 23	42-440	Giebło	PL	bbba2465-a14c-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Sonoma szerokość 60cm \nKolor obicia Hugo czarny TH1	t	\N	2025-10-04 18:07:14.254	\N	2025-10-09 19:41:05.266723	ONLINE	f	[{"id": "RFBEOjEwMjY4NDYwODgzODlV", "waybill": "1026846088389U", "carrierId": "DPD", "createdAt": "2025-10-06T05:12:38.173Z", "lineItems": [{"id": "286a31c0-a14c-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
75	b661cf00-a134-11f0-8323-6df02f435f6c	\N	\N	2025-10-04 15:19:37.217	Gotowe do realizacji	allegro-pl	88024175	Client:88024175	9n8zyvpofi+168aba7b8@allegromail.pl	\N	Grażyna Słotwińska	+48 605 259 325	Jelenica, 75	43-450	Ustroń	PL	b68201df-a134-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	1286.40	PLN	Allegro Kurier DPD	0.00	PLN	1286.40	PLN	SIEDZISKO: F02\nWIESZAK:CHROM H2	t	\N	2025-10-04 15:19:37.217	\N	2025-10-09 19:41:15.60664	ONLINE	f	[{"id": "RFBEOjEwMjY5ODQ4ODU2NTBV", "waybill": "1026984885650U", "carrierId": "DPD", "createdAt": "2025-10-07T08:54:01.180Z", "lineItems": [{"id": "b6576ec0-a134-11f0-8323-6df02f435f6c"}]}, {"id": "RFBEOjEwMjY5ODQ4ODU3OTFV", "waybill": "1026984885791U", "carrierId": "DPD", "createdAt": "2025-10-07T08:54:01.460Z", "lineItems": [{"id": "b6576ec0-a134-11f0-8323-6df02f435f6c"}]}, {"id": "RFBEOjEwMjY5ODQ4ODU4NTFV", "waybill": "1026984885851U", "carrierId": "DPD", "createdAt": "2025-10-07T08:54:01.735Z", "lineItems": [{"id": "b6576ec0-a134-11f0-8323-6df02f435f6c"}]}]	\N	0.00	\N	[]	f
77	985df1b0-a129-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-04 13:55:18.781	Gotowe do realizacji	allegro-pl	16524194	anecia19915	nhwmrfuouo+6f52ec5c5@allegromail.pl	\N	Aneta Bogucka	+48 504 717 308	Piotra Skargi 5BA	05-420	Józefów	PL	987f83f8-a129-11f0-b9a1-9fd75769370f	PAID	P24	t	570.99	PLN	Allegro Kurier DPD	14.99	PLN	570.99	PLN	\N	f	\N	2025-10-04 13:55:18.781	\N	2025-10-09 19:41:18.581203	ONLINE	f	[{"id": "RFBEOjEwMjY5NjY5Nzk0OTlV", "waybill": "1026966979499U", "carrierId": "DPD", "createdAt": "2025-10-07T06:45:16.653Z", "lineItems": [{"id": "985984e0-a129-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
78	962c7da0-a127-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-04 13:41:20.432	Gotowe do realizacji	allegro-pl	44131948	Client:44131948	wci58v6808+29698b440@allegromail.pl	\N	Anna Andrzejewska	+48 791 934 305	Kolonia Leśna 6	66-235	Torzym	PL	a17e9830-a127-11f0-91d4-7961b40d7b05	PAID	P24	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-04 13:41:20.432	\N	2025-10-09 19:41:20.077393	ONLINE	f	[{"id": "RFBEOjEwMjY5ODUwODgyMTJV", "waybill": "1026985088212U", "carrierId": "DPD", "createdAt": "2025-10-07T08:55:36.230Z", "lineItems": [{"id": "96277490-a127-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
80	66a16aa0-a122-11f0-baf0-af7ea74e3d0e	\N	\N	2025-10-04 13:03:06.946	Gotowe do realizacji	allegro-pl	16509717	rzanetka88	9f35o43p1l+7ab5c19e5@allegromail.pl	\N	Żaneta Luber - Kleta	+48 794 247 180	Osiedle Paderewskiego 8/2/16	32-626	Jawiszowice	PL	66dd3c0d-a122-11f0-a284-071dd65bf45d	PAID	AF	t	67.00	PLN	Allegro Kurier DPD	0.00	PLN	67.00	PLN	kolor CZARNY WELUR 	t	\N	2025-10-04 13:03:06.946	\N	2025-10-09 19:41:22.997025	ONLINE	f	[{"id": "RFBEOjEwMjY4NDY3OTUyNzJV", "waybill": "1026846795272U", "carrierId": "DPD", "createdAt": "2025-10-06T05:18:17.213Z", "lineItems": [{"id": "6699c980-a122-11f0-baf0-af7ea74e3d0e"}, {"id": "6699c981-a122-11f0-baf0-af7ea74e3d0e"}]}]	\N	0.00	\N	[]	f
83	37e72b40-a114-11f0-9e86-bf15ec8cf3e6	\N	\N	2025-10-04 11:24:00.243	Gotowe do realizacji	allegro-pl	75742473	Client:75742473	46wnp65uxq+6b87203f8@allegromail.pl	\N	Joanna Cyrańska	+48 662 983 607	Ruszelczyce 21	37-755	Krzywcza	PL	6d4c9ab8-a114-11f0-bb32-51209e96d6bb	PAID	P24	t	292.99	PLN	Allegro Kurier DPD	14.99	PLN	292.99	PLN	\N	f	\N	2025-10-04 11:24:00.243	\N	2025-10-06 19:00:55.116661	ONLINE	f	\N	\N	0.00	\N	\N	f
49	c9711b50-a1de-11f0-954f-f9092bddbf0d	\N	\N	2025-10-05 11:35:34.857	Gotowe do realizacji	allegro-pl	1995009	gadzeta8	od4cqij8os+601b41d28@allegromail.pl	\N	Monika Szczepańska	+48 792 173 334	21 Stycznia 27/1	14-100	Ostróda	PL	c98feeee-a1de-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	510.00	PLN	Allegro Kurier DPD	0.00	PLN	510.00	PLN	THP1 - Tkanina Hugo Pik Grafitowy	t	\N	2025-10-05 11:35:34.857	\N	2025-10-09 19:40:35.667074	ONLINE	f	[{"id": "RFBEOjEwMjY5NjU3MDc1MjVV", "waybill": "1026965707525U", "carrierId": "DPD", "createdAt": "2025-10-07T06:35:54.679Z", "lineItems": [{"id": "c96cfca0-a1de-11f0-954f-f9092bddbf0d"}]}]	\N	0.00	\N	[]	f
64	8eab3fe0-a162-11f0-a6cc-b3145592fdde	\N	\N	2025-10-04 20:42:54.955	Gotowe do realizacji	allegro-pl	5179759	kris1126	bug8hcuum9+2843a91c8@allegromail.pl	\N	Krzysztof Gogolewski	+48 504 247 880	Paryska 10	06-400	Ciechanów	PL	8efe69ee-a162-11f0-ae11-e76c74c7cf77	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	kolor grafit 	t	\N	2025-10-04 20:42:54.955	\N	2025-10-09 19:40:59.247977	ONLINE	f	[{"id": "RFBEOjEwMjY5ODA2MzI5NzRV", "waybill": "1026980632974U", "carrierId": "DPD", "createdAt": "2025-10-07T08:23:17.656Z", "lineItems": [{"id": "8ea377b0-a162-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
70	2fb0e140-a142-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-04 16:50:53.739	Gotowe do realizacji	allegro-pl	14645126	liponoga_anna	yf9yhaxe96+490c28608@allegromail.pl	\N	Anna Liponoga	+48 535 669 933	ul. gen. Ludomiła Rayskiego 7 m 70	01-307	Warszawa	PL	40d6ae91-a142-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	410.19	PLN	\N	t	\N	2025-10-04 16:50:53.739	\N	2025-10-09 19:41:08.213471	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5ODIwMjk1OTdV", "waybill": "1026982029597U", "carrierId": "DPD", "createdAt": "2025-10-07T08:33:43.390Z", "lineItems": [{"id": "2faa5190-a142-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
90	45695940-a0a7-11f0-a6cc-b3145592fdde	\N	\N	2025-10-03 22:22:18.322	Gotowe do realizacji	allegro-pl	4133275	mardc	94yhz94xt2+5938469d1@allegromail.pl	\N	Mariusz Żelezik	+48 511 123 067	Ogrodowa 19	08-130	Kotuń	PL	45b52ffa-a0a7-11f0-a417-fd831f6ae8ec	PAID	AF	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	TH3	t	\N	2025-10-03 22:22:18.322	\N	2025-10-09 19:52:21.909094	ONLINE	f	[{"id": "RFBEOjEwMjY5ODYyMDI5NjdV", "waybill": "1026986202967U", "carrierId": "DPD", "createdAt": "2025-10-07T09:03:44.388Z", "lineItems": [{"id": "45619110-a0a7-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
94	db0dc990-a07f-11f0-9a42-bb8e9ffafe52	\N	\N	2025-10-03 17:40:35.438	Gotowe do realizacji	allegro-pl	38831160	Client:38831160	xkpua6wm6c+c7953d90@allegromail.pl	\N	Sławomir Nowakowski	+48 600 925 902	Rębkowska 14 m 4	04-375	Warszawa	PL	db38ab1b-a07f-11f0-bb32-51209e96d6bb	PAID	P24	t	366.99	PLN	Allegro Kurier DPD	14.99	PLN	366.99	PLN	\N	f	\N	2025-10-03 17:40:35.438	\N	2025-10-09 19:52:28.20184	ONLINE	f	[{"id": "RFBEOjEwMjY4OTczODcwMzJV", "waybill": "1026897387032U", "carrierId": "DPD", "createdAt": "2025-10-06T10:03:33.844Z", "lineItems": [{"id": "db036950-a07f-11f0-9a42-bb8e9ffafe52"}]}]	\N	0.00	\N	[]	f
97	2f557250-a067-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-03 14:45:57.784	Gotowe do realizacji	allegro-pl	101281265	Client:101281265	9boi2d22hu+718d767e7@allegromail.pl	\N	JADWIGA WOŹNY	+48 608 359 150	Pogwizdowska 170	35-212	RZESZÓW	PL	34d141fe-a067-11f0-96eb-67f4404dbe40	PAID	P24	t	793.10	PLN	Allegro Kurier DPD	0.00	PLN	793.10	PLN	Welur Grafitowy ( WE3)	t	\N	2025-10-03 14:45:57.784	\N	2025-10-09 19:52:32.634675	ONLINE	f	[{"id": "RFBEOjEwMjY4OTA3OTI0NjNV", "waybill": "1026890792463U", "carrierId": "DPD", "createdAt": "2025-10-06T09:24:21.489Z", "lineItems": [{"id": "2f4df840-a067-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY4OTA3OTI1MDZV", "waybill": "1026890792506U", "carrierId": "DPD", "createdAt": "2025-10-06T09:24:21.776Z", "lineItems": [{"id": "2f4df840-a067-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7624	877577c0-a3c6-11f0-9a42-bb8e9ffafe52	\N	\N	2025-10-07 21:42:54.697	Gotowe do realizacji	allegro-pl	4814806	mmax88	cqyhifo1t4+7f6ce6bd5@allegromail.pl	\N	Michał Wańczyk	+48 796 208 795	Buchowieckiego 30	32-300	Olkusz	PL	87b344c6-a3c6-11f0-bb32-51209e96d6bb	PAID	AF	t	99.00	PLN	Allegro Kurier DPD	0.00	PLN	99.00	PLN	\N	t	\N	2025-10-07 21:42:54.697	\N	2025-10-09 19:34:31.511017	ONLINE	f	[]	\N	0.00	\N	[]	f
63	0f4702d1-a16b-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-04 21:43:15.138	Gotowe do realizacji	allegro-pl	24395723	marcindab13	r9zahk4pdo+7a5ce3963@allegromail.pl	\N	Marcin Dąbrowski	+48 511 723 992	Dobropole Gryfińskie 10	74-106	Dobropole Gryfinskie gm. Stare Czarnowo	PL	0fb64015-a16b-11f0-ae11-e76c74c7cf77	PAID	P24	t	352.00	PLN	Allegro Kurier DPD	0.00	PLN	352.00	PLN	\N	t	\N	2025-10-04 21:43:15.138	\N	2025-10-09 19:40:57.767472	ONLINE	f	[{"id": "RFBEOjEwMjY5ODAzMjAwNDJV", "waybill": "1026980320042U", "carrierId": "DPD", "createdAt": "2025-10-07T08:20:59.860Z", "lineItems": [{"id": "0f3d3ed1-a16b-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
87	68bf4590-a0f6-11f0-8323-6df02f435f6c	\N	\N	2025-10-04 07:49:27.948	Gotowe do realizacji	allegro-pl	34512889	Client:34512889	c5kbmeetq1+3e00f0471@allegromail.pl	\N	Monika Hirsz	+48 731 915 193	Rumska 18	81-198	Dębogórze	PL	68e2facc-a0f6-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Dzień dobry, proszę o obicie w kolorze welur jasno szary (we2). Pozdrawiam Monika Hirsz	t	\N	2025-10-04 07:49:27.948	\N	2025-10-06 17:22:43.295573	ONLINE	f	\N	\N	0.00	\N	\N	f
88	e0e984b0-a0f4-11f0-8323-6df02f435f6c	\N	\N	2025-10-04 07:38:53.772	Gotowe do realizacji	allegro-pl	13508479	squeezee	8bag2081xt+71c1edfa5@allegromail.pl	\N	Klaudia Kamińska	+48 510 234 632	JÓZEFA KONRADA KORZENIOWSKIEGO 52	83-000	Pruszcz Gdański	PL	e1087ed4-a0f4-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	521.00	PLN	Allegro Kurier DPD	0.00	PLN	521.00	PLN	\N	t	\N	2025-10-04 07:38:53.772	\N	2025-10-06 17:22:43.502874	ONLINE	f	\N	\N	0.00	\N	\N	f
89	2fefe050-a0e5-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-04 05:45:23.525	Gotowe do realizacji	allegro-pl	33957378	Client:33957378	x6swvad8in+70620eaa4@allegromail.pl	\N	iwona komarnicka	+48 660 382 483	Podwale 14 / 2	47-400	Racibórz	PL	48a47e2b-a0e5-11f0-91d4-7961b40d7b05	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	447.99	PLN	TKANINA F04	t	\N	2025-10-04 05:45:23.525	\N	2025-10-06 17:22:43.709715	CASH_ON_DELIVERY	f	\N	\N	0.00	\N	\N	f
95	1161a220-a07e-11f0-a6cc-b3145592fdde	\N	\N	2025-10-03 17:27:48.186	Gotowe do realizacji	allegro-pl	4159023	juniorek50	m7s6lbrziw+14a6270f6@allegromail.pl	\N	Wojtek Klawitter	+48 661 950 674	Mozarta 3 / 418	02-736	Warszawa	PL	119cd74d-a07e-11f0-a417-fd831f6ae8ec	PAID	P24	t	405.20	PLN	Allegro Kurier DPD	0.00	PLN	405.20	PLN	Materiał f04	t	\N	2025-10-03 17:27:48.186	\N	2025-10-09 19:52:29.679006	ONLINE	f	[{"id": "RFBEOjEwMjY4OTc2NDk5NDhV", "waybill": "1026897649948U", "carrierId": "DPD", "createdAt": "2025-10-06T10:05:11.444Z", "lineItems": [{"id": "115a0100-a07e-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
99	49190450-a066-11f0-b871-03a75625f948	\N	\N	2025-10-03 14:37:12.503	Gotowe do realizacji	allegro-pl	17842068	malarz141	i254majzoh+39cc9c322@allegromail.pl	\N	Maciej Lewandowski	+48 695 469 309	14-200 Iława ul. Grunwaldzka 3a / 8	14-200	Iława	PL	4c26e118-a066-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	poproszę wykończenie welur  jasnoszary WE 2	t	\N	2025-10-03 14:37:12.503	\N	2025-10-09 19:52:35.935596	ONLINE	t	[{"id": "RFBEOjEwMjY4NDc1NDgxMTdV", "waybill": "1026847548117U", "carrierId": "DPD", "createdAt": "2025-10-06T05:24:22.124Z", "lineItems": [{"id": "49144960-a066-11f0-b871-03a75625f948"}]}]	grunwaldzka 3a	0.00	\N	[]	f
100	03bcd260-a066-11f0-aafc-c30e0e10a738	\N	\N	2025-10-04 11:48:41.835	Anulowane	allegro-pl	17842068	malarz141	i254majzoh+51a59e9f8@allegromail.pl	\N	Maciej Lewandowski	+48 695 469 309	\N	\N	\N	\N	080970df-a066-11f0-b9a1-9fd75769370f	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Dzień dobry jako wykończenie poproszę welur jasno szary WE2	t	\N	2025-10-04 11:48:41.835	\N	2025-10-11 08:52:51.907556	ONLINE	t	[]	grunwaldzka 3a	0.00	\N	[]	f
7605	8eddd0e0-a43c-11f0-96d3-f7121b08a32c	\N	\N	2025-10-08 11:47:39.158	Gotowe do realizacji	allegro-pl	47096767	Client:47096767	tqqn3cbzsd+6f4d18905@allegromail.pl	\N	Marcin Kleibert	+48 661 733 999	Ryżowa 66 / 32	02-495	Warszawa	PL	8efe519c-a43c-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-10-08 11:47:39.158	\N	2025-10-09 19:34:01.533573	ONLINE	f	[{"id": "RFBEOjEwMjcxMzExNjY4NTZV", "waybill": "1027131166856U", "carrierId": "DPD", "createdAt": "2025-10-09T05:05:54.663Z", "lineItems": [{"id": "8ed915f0-a43c-11f0-96d3-f7121b08a32c"}]}]	\N	0.00	\N	[]	f
938	b5ec64e0-a2c9-11f0-abd8-f5344f24907b	\N	\N	2025-10-06 15:37:33.084	Gotowe do realizacji	allegro-pl	55411729	Client:55411729	70kav6edsc+1a43852f4@allegromail.pl	\N	Michał Dubowski	+48 515 000 143	Włodarzewska 57D / 23	02-384	Warszawa	PL	b62c2d05-a2c9-11f0-a284-071dd65bf45d	PAID	P24	t	1705.00	PLN	Allegro Kurier DPD	0.00	PLN	1705.00	PLN	Zestaw x30x202, dąb wotan, hak H1 (czarny), kolor siedziska WE1 (welur czarny)	t	\N	2025-10-06 15:37:33.084	\N	2025-10-06 20:34:45.860476	ONLINE	f	\N	\N	0.00	\N	\N	f
7937	1d2e1650-a5a2-11f0-8c00-69a8c96cc639	\N	\N	2025-10-10 07:00:32.666	Gotowe do realizacji	allegro-pl	5980428	keczan_2006	usjo7ytp1n+3dd8b070@allegromail.pl	\N	Mariusz Koczanowski	+48 602 575 870	Kozłów 89	39-200	Dębica	PL	1d68d621-a5a2-11f0-96eb-67f4404dbe40	PAID	PAYU	t	605.00	PLN	Allegro Kurier DPD	0.00	PLN	605.00	PLN	\N	t	\N	2025-10-10 07:00:32.666	\N	2025-10-10 08:02:29.93418	ONLINE	f	[]	\N	0.00	\N	[]	f
7550	63e21820-a486-11f0-b989-75c7faccd1ca	\N	\N	2025-10-08 20:37:47.278	Gotowe do realizacji	allegro-pl	50460369	Client:50460369	b31vmrvifd+9d252b55@allegromail.pl	\N	Boena Lipka	+48 696 070 443	Bolesawice 55/6	58-140	Jaworzyna l	PL	640cab39-a486-11f0-a284-071dd65bf45d	PAID	P24	t	1750.10	PLN	Allegro Kurier DPD	0.00	PLN	1750.10	PLN	\N	t	\N	2025-10-08 20:37:47.278	\N	2025-10-09 19:33:39.841229	ONLINE	f	[{"id": "RFBEOjEwMjcxNzM4ODQ0OTlV", "waybill": "1027173884499U", "carrierId": "DPD", "createdAt": "2025-10-09T11:00:13Z", "lineItems": [{"id": "63dbd690-a486-11f0-b989-75c7faccd1ca"}]}, {"id": "RFBEOjEwMjcxNzM4ODQ1NzhV", "waybill": "1027173884578U", "carrierId": "DPD", "createdAt": "2025-10-09T11:00:13Z", "lineItems": [{"id": "63dbd690-a486-11f0-b989-75c7faccd1ca"}]}, {"id": "RFBEOjEwMjcxNzM4ODQ2OThV", "waybill": "1027173884698U", "carrierId": "DPD", "createdAt": "2025-10-09T11:00:13.195Z", "lineItems": [{"id": "63dbd690-a486-11f0-b989-75c7faccd1ca"}]}]	\N	0.00	\N	[]	f
7601	cad06af0-a454-11f0-a471-6bb0586de370	\N	\N	2025-10-08 14:41:41.045	Gotowe do realizacji	allegro-pl	7630309	elizaj3	wphnxh2fdn+dc2027f5@allegromail.pl	\N	Eliza Jaworska	+48 728 823 629	Kowali 73	43-430	Skoczów	PL	cb0620fb-a454-11f0-96eb-67f4404dbe40	PAID	AF	t	532.60	PLN	Allegro Kurier DPD	0.00	PLN	532.60	PLN	uchwyty U1 czarne poproszę 	t	\N	2025-10-08 14:41:41.045	\N	2025-10-09 19:33:55.297684	ONLINE	f	[]	\N	0.00	\N	[]	f
7602	71cfc9a0-a44f-11f0-a4f0-7ba876f09f6f	\N	\N	2025-10-08 14:03:12.954	Gotowe do realizacji	allegro-pl	4505799	smolki_	ys90wdkqs4+12c87bb55@allegromail.pl	Debal Development Smoła Paweł	Paweł Smoła	+48 792 801 756	29 Listopada 56j	32-500	Chrzanów	PL	71f182c6-a44f-11f0-b9a1-9fd75769370f	PAID	PAYU	t	312.20	PLN	Allegro Kurier DPD	0.00	PLN	312.20	PLN	Kolor siedziska WE3 - Welur Grafitowy	t	\N	2025-10-08 14:03:12.954	\N	2025-10-09 19:33:56.822981	ONLINE	f	[{"id": "RFBEOjEwMjcxMzEwODUyNDhV", "waybill": "1027131085248U", "carrierId": "DPD", "createdAt": "2025-10-09T05:04:33Z", "lineItems": [{"id": "71c4a610-a44f-11f0-a4f0-7ba876f09f6f"}]}]	\N	0.00	\N	[]	f
7603	3b69b380-a44f-11f0-88a6-1f93f938b7b3	\N	\N	2025-10-08 14:01:43.386	Gotowe do realizacji	allegro-pl	15508170	stenek30	qf6fuuxgn1+38b719256@allegromail.pl	\N	KRZYSZTOFA STENKA	+48 694 407 206	Miejscowość Nowotna 8m2	82-103	Stegna	PL	3ba499c8-a44f-11f0-ae11-e76c74c7cf77	PAID	P24	t	636.00	PLN	Allegro Kurier DPD	0.00	PLN	636.00	PLN	Uchwyty poproszę chrom	t	\N	2025-10-08 14:01:43.386	\N	2025-10-09 19:33:58.363732	ONLINE	f	[]	\N	0.00	\N	[]	f
638	2472fa10-a2c4-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-06 14:54:48.151	Gotowe do realizacji	allegro-pl	40906215	Wielki_Masta	qnldsuh9it+388a22bf5@allegromail.pl	\N	jacek szarach	+48 790 293 648	Witosa 1c / 10	67-100	Nowa Sól	PL	26ee8245-a2c4-11f0-ae11-e76c74c7cf77	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Poproszę o obicie w kolorze czarny welur. 	t	\N	2025-10-06 14:54:48.151	\N	2025-10-06 20:34:46.315283	ONLINE	f	\N	\N	0.00	\N	\N	f
639	e783f970-a2bd-11f0-b024-2112831760cb	\N	\N	2025-10-06 14:09:52.917	Gotowe do realizacji	allegro-pl	27213466	loginzuberek	hgy8wl4255+3750bfe38@allegromail.pl	\N	Katarzyna  Szymańska	+48 506 344 729	Ul. Wschodnia 80	21-302	Kąkolewnica	PL	f6aae9f1-a2bd-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	1283.00	PLN	Allegro Kurier DPD	0.00	PLN	1283.00	PLN	witam. poproszę welur grafitowy we3 oraz haki czarne 	t	\N	2025-10-06 14:09:52.917	\N	2025-10-06 20:34:46.71877	ONLINE	t	\N	\N	0.00	\N	\N	f
1	989a5e50-a2b1-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-06 12:42:07.787	Gotowe do realizacji	allegro-pl	11698857	rafol91_HKS	6uohpxirqu+5a619d205@allegromail.pl	\N	Rafał Flak	+48 607 970 259	Kędzierzyńska 17c/Budynek G2	41-902	Bytom	PL	98bd4fef-a2b1-11f0-baf9-a33944a1116d	PAID	PAYU	t	1343.00	PLN	Allegro Kurier DPD	0.00	PLN	1343.00	PLN	\N	t	\N	2025-10-06 12:42:07.787	\N	2025-10-06 20:34:47.538854	ONLINE	f	\N	\N	0.00	\N	\N	f
2	3f589880-a2b0-11f0-9468-2bd22967b382	\N	\N	2025-10-06 12:33:25.259	Gotowe do realizacji	allegro-pl	67724201	Client:67724201	eozfvqkpi4+2050d18f9@allegromail.pl	\N	Jan Panek	+48 669 421 089	Drzonków-świerkowa 4	66-004	Zielona Góra	PL	4ec9632f-a2b0-11f0-a417-fd831f6ae8ec	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	tapicerka welurowa WE4	t	\N	2025-10-06 12:33:25.259	\N	2025-10-06 20:34:47.944898	ONLINE	t	\N	\N	0.00	\N	\N	f
7604	25b7bdb0-a446-11f0-9322-81ad33e97c6b	\N	\N	2025-10-08 12:56:49.483	Gotowe do realizacji	allegro-pl	47342434	Client:47342434	nee8s98jgc+6887576e8@allegromail.pl	\N	Aleksandra Graca	+48 512 319 918	Pańków 3	22-604	Tarnawatka	PL	25d02822-a446-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	\N	t	\N	2025-10-08 12:56:49.483	\N	2025-10-09 19:33:59.964151	ONLINE	f	[{"id": "RFBEOjEwMjcxMzExMjY5NDBV", "waybill": "1027131126940U", "carrierId": "DPD", "createdAt": "2025-10-09T05:05:10.858Z", "lineItems": [{"id": "25b23f70-a446-11f0-9322-81ad33e97c6b"}]}]	\N	0.00	\N	[]	f
26	1ece4030-a21d-11f0-8c5e-eb0a288ebc91	\N	\N	2025-10-05 19:06:53.012	Gotowe do realizacji	allegro-pl	6011973	Kamil-gr	apfqwr32jc+37c66574@allegromail.pl	\N	Kamil Grygierzec	+48 667 089 713	Racula-St.Wyspiańskiego 3/2	66-004	Zielona Góra	PL	1ef8850c-a21d-11f0-baf9-a33944a1116d	PAID	P24	t	418.00	PLN	Allegro Kurier DPD	0.00	PLN	418.00	PLN	kolor: dąb sonoma	t	\N	2025-10-05 19:06:53.012	\N	2025-10-09 19:40:01.827597	ONLINE	f	[{"id": "RFBEOjEwMjY5Njg3MDMwNjZV", "waybill": "1026968703066U", "carrierId": "DPD", "createdAt": "2025-10-07T06:58:03.841Z", "lineItems": [{"id": "1ec95e30-a21d-11f0-8c5e-eb0a288ebc91"}]}]	\N	0.00	\N	[]	f
8023	c5208260-a5ae-11f0-8399-c1bb86b8e44b	\N	\N	2025-10-10 07:58:54.365	Gotowe do realizacji	allegro-pl	73598750	Client:73598750	w9xviz9m0n+7961cf030@allegromail.pl	\N	Agnieszka Wawrzyniak -Wróbel	+48 728 737 391	Ul. Klasztorna 13	52-234	Wrocław	PL	d8182976-a5ae-11f0-a284-071dd65bf45d	PAID	P24	t	546.00	PLN	Allegro Kurier DPD	0.00	PLN	546.00	PLN	\N	t	\N	2025-10-10 07:58:54.365	\N	2025-10-10 08:02:21.199439	ONLINE	t	[]	ul.Klasztorna 13	0.00	\N	[]	f
7630	7c71b580-a3aa-11f0-a15e-754093089519	\N	\N	2025-10-07 18:33:23.101	Gotowe do realizacji	allegro-pl	2918456	ewakry1	3fr96v7t9j+59e1b4545@allegromail.pl	\N	Grzegorz Krystkowicz	+48 507 117 876	Skryta 15	07-410	Ostrołęka	PL	ef6c1ba6-a3ab-11f0-b9a1-9fd75769370f	PAID	P24	t	75.00	PLN	Allegro Kurier DPD	0.00	PLN	75.00	PLN	zamawiam obicie -  Hugo Pik szary - THP2	t	\N	2025-10-07 18:33:23.101	\N	2025-10-09 19:34:41.063664	ONLINE	f	[{"id": "RFBEOjEwMjcwNDYzOTAzMjdV", "waybill": "1027046390327U", "carrierId": "DPD", "createdAt": "2025-10-08T05:22:57.575Z", "lineItems": [{"id": "7c6a6280-a3aa-11f0-a15e-754093089519"}]}]	\N	0.00	\N	[]	f
7631	b1c3ae70-a3a8-11f0-995e-7bc10d9eb16f	\N	\N	2025-10-07 18:22:28.958	Gotowe do realizacji	allegro-pl	7419905	bartek_1503	l0qza6qbzd+693deb888@allegromail.pl	\N	Bartosz Brojecki	+48 665 165 482	Ogińskiego 25/9	66-400	Gorzów Wielkopolski	PL	b1e986d5-a3a8-11f0-91d4-7961b40d7b05	PAID	PAYU	t	1263.50	PLN	Allegro Kurier DPD	0.00	PLN	1263.50	PLN	Proszę o obicia w kolorze TH1 - Tkanina Hugo Czarny	t	\N	2025-10-07 18:22:28.958	\N	2025-10-09 19:34:42.565499	ONLINE	f	[{"id": "RFBEOjEwMjcwNjA1NDQzMzdV", "waybill": "1027060544337U", "carrierId": "DPD", "createdAt": "2025-10-08T07:18:48.780Z", "lineItems": [{"id": "b1b83cc0-a3a8-11f0-995e-7bc10d9eb16f"}]}, {"id": "RFBEOjEwMjcwNjA1NDQ0MzZV", "waybill": "1027060544436U", "carrierId": "DPD", "createdAt": "2025-10-08T07:18:48.994Z", "lineItems": [{"id": "b1b83cc0-a3a8-11f0-995e-7bc10d9eb16f"}]}, {"id": "RFBEOjEwMjcwNjA1NDQ1OTdV", "waybill": "1027060544597U", "carrierId": "DPD", "createdAt": "2025-10-08T07:18:49.164Z", "lineItems": [{"id": "b1b83cc0-a3a8-11f0-995e-7bc10d9eb16f"}]}]	\N	0.00	\N	[]	f
7632	d30c2a10-a3a0-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-07 17:14:42.206	Gotowe do realizacji	allegro-pl	6267146	sasorki	xi99vdxqdg+4ae32d471@allegromail.pl	\N	SYLWIA SASORSKA	+48 573 480 443	Bałtycka 22/6	75-331	Koszalin	PL	d34c4132-a3a0-11f0-a284-071dd65bf45d	PAID	PAYU	t	1263.50	PLN	Allegro Kurier DPD	0.00	PLN	1263.50	PLN	Witam serdecznie, proszę kolor obicia welur czarny, haki w kolorze czarnym. Pozdrawiam 	t	\N	2025-10-07 17:14:42.206	\N	2025-10-09 19:34:44.063468	ONLINE	f	[{"id": "RFBEOjEwMjcxNjYzODgwNjhV", "waybill": "1027166388068U", "carrierId": "DPD", "createdAt": "2025-10-09T09:59:48.856Z", "lineItems": [{"id": "d303ecb0-a3a0-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjcxNjYzODgxMjFV", "waybill": "1027166388121U", "carrierId": "DPD", "createdAt": "2025-10-09T09:59:49.104Z", "lineItems": [{"id": "d303ecb0-a3a0-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjcxNjYzODgyMTNV", "waybill": "1027166388213U", "carrierId": "DPD", "createdAt": "2025-10-09T09:59:49.308Z", "lineItems": [{"id": "d303ecb0-a3a0-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7633	470fa2e0-a39f-11f0-9468-2bd22967b382	\N	\N	2025-10-07 17:07:13.505	Gotowe do realizacji	allegro-pl	1796966	latynistka	suwf90g6ts+3365b3a98@allegromail.pl	\N	Adriana Grzelak-Krzymianowska	+48 609 022 105	Piłsudskiego 30 m.44	95-050	Konstantynów Łódzki	PL	7883b464-a39f-11f0-a284-071dd65bf45d	PAID	P24	t	2120.40	PLN	Allegro Kurier DPD	0.00	PLN	2120.40	PLN	Kolor paneli: ES4 (ekoskóra brązowa)	t	\N	2025-10-07 17:07:13.505	\N	2025-10-09 19:34:45.591752	ONLINE	f	[{"id": "RFBEOjEwMjcwOTIzNzQ1ODhV", "waybill": "1027092374588U", "carrierId": "DPD", "createdAt": "2025-10-08T11:20:48.629Z", "lineItems": [{"id": "47073e71-a39f-11f0-9468-2bd22967b382"}, {"id": "47073e70-a39f-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjcwOTIzNzQ2OTZV", "waybill": "1027092374696U", "carrierId": "DPD", "createdAt": "2025-10-08T11:20:48.919Z", "lineItems": [{"id": "47073e71-a39f-11f0-9468-2bd22967b382"}, {"id": "47073e70-a39f-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjcwOTIzNzQ3ODlV", "waybill": "1027092374789U", "carrierId": "DPD", "createdAt": "2025-10-08T11:20:49.140Z", "lineItems": [{"id": "47073e71-a39f-11f0-9468-2bd22967b382"}, {"id": "47073e70-a39f-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjcwOTIzNzQ4NzdV", "waybill": "1027092374877U", "carrierId": "DPD", "createdAt": "2025-10-08T11:20:49.341Z", "lineItems": [{"id": "47073e71-a39f-11f0-9468-2bd22967b382"}, {"id": "47073e70-a39f-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjcwOTIzNzQ5NTZV", "waybill": "1027092374956U", "carrierId": "DPD", "createdAt": "2025-10-08T11:20:49.536Z", "lineItems": [{"id": "47073e71-a39f-11f0-9468-2bd22967b382"}, {"id": "47073e70-a39f-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7634	14e058a0-a39f-11f0-b56d-0ba559d87e46	\N	\N	2025-10-07 17:02:01.628	Gotowe do realizacji	allegro-pl	54314693	Client:54314693	plwzsdlteo+ebcc5e56@allegromail.pl	\N	Anita Dolecka	+48 782 795 346	Inwestorska 10	23-300	Borownica	PL	3eacba59-a39f-11f0-a284-071dd65bf45d	PAID	P24	t	666.00	PLN	Allegro Kurier DPD	0.00	PLN	666.00	PLN	Tkanina obicia TH1 tkanina Hugo czarny	t	\N	2025-10-07 17:02:01.628	\N	2025-10-09 19:34:47.220975	ONLINE	f	[]	\N	0.00	\N	[]	f
7635	5b9f1d40-a39e-11f0-9468-2bd22967b382	\N	\N	2025-10-07 16:55:34.498	Gotowe do realizacji	allegro-pl	114103324	Client:114103324	x9931rckoc+63912f744@allegromail.pl	\N	Marcin Ziomek	+48 533 677 800	Podgrzybkowa 13 13 / 11	66-446	Glinik	PL	5bdc74db-a39e-11f0-a284-071dd65bf45d	PAID	PAYU	t	292.99	PLN	Allegro Kurier DPD	14.99	PLN	292.99	PLN	\N	f	\N	2025-10-07 16:55:34.498	\N	2025-10-09 19:34:48.866238	ONLINE	f	[]	\N	0.00	\N	[]	f
7636	f1c974b0-a39d-11f0-8d43-e5c6c6646cd8	\N	\N	2025-10-07 16:54:54.013	Gotowe do realizacji	allegro-pl	51088242	Aga_Agness	3oufx0wqrp+463f63a62@allegromail.pl	\N	Agnieszka Adamczyk	+48 501 385 812	Laurowa 10 m. 25	20-153	Lublin	PL	f92faeb1-a39d-11f0-a417-fd831f6ae8ec	PAID	P24	t	1021.00	PLN	Allegro Kurier DPD	0.00	PLN	1021.00	PLN	THP2 Tkanina Hugo Pik Jasno Szary	t	\N	2025-10-07 16:54:54.013	\N	2025-10-09 19:34:50.349499	ONLINE	f	[]	\N	0.00	\N	[]	f
7637	1e0e9330-a39d-11f0-9a42-bb8e9ffafe52	\N	\N	2025-10-07 16:50:26.898	Anulowane	allegro-pl	51088242	Aga_Agness	3oufx0wqrp+60d0d77b5@allegromail.pl	\N	Agnieszka Adamczyk	+48 501 385 812	\N	\N	\N	\N	278a4008-a39d-11f0-a284-071dd65bf45d	UNPAID	P24	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1021.00	PLN	obicie THP2 Tkanina Hugo Pik Jasno Szary 	t	\N	\N	\N	2025-10-09 19:34:51.982135	ONLINE	f	[]	\N	0.00	\N	[]	f
7638	0a3ff4a0-a39a-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-07 16:24:36.882	Gotowe do realizacji	allegro-pl	22511619	monikascena	w1fxoslx38+22010a852@allegromail.pl	\N	Monika Pastuszka	+48 508 352 578	Ul. Kośna 20/2	26-600	Radom	PL	1b526148-a39a-11f0-baf9-a33944a1116d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	560.99	PLN	\N	t	\N	2025-10-07 16:24:36.882	\N	2025-10-09 19:34:53.415426	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjcwNDUzOTIzODZV", "waybill": "1027045392386U", "carrierId": "DPD", "createdAt": "2025-10-08T05:10:37.493Z", "lineItems": [{"id": "0a3bd5f0-a39a-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjcwNDUzOTI0NTlV", "waybill": "1027045392459U", "carrierId": "DPD", "createdAt": "2025-10-08T05:10:37.724Z", "lineItems": [{"id": "0a3bd5f0-a39a-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
7639	d274a930-a399-11f0-a3bc-ef5c37833579	\N	\N	2025-10-07 16:23:07.307	Gotowe do realizacji	allegro-pl	2388947	palladyn27	e5fy9qrd0m+548e53066@allegromail.pl	\N	sylwester wieloch	+48 791 428 301	Reja 2 / 55	32-300	Olkusz	PL	e183cc1a-a399-11f0-baf9-a33944a1116d	PAID	AF	t	1557.00	PLN	Allegro Kurier DPD	0.00	PLN	1557.00	PLN	\N	t	\N	2025-10-07 16:23:07.307	\N	2025-10-09 19:34:54.833203	ONLINE	f	[{"id": "RFBEOjEwMjcwNjA4NzM4MzZV", "waybill": "1027060873836U", "carrierId": "DPD", "createdAt": "2025-10-08T07:21:18.052Z", "lineItems": [{"id": "d2701550-a399-11f0-a3bc-ef5c37833579"}]}, {"id": "RFBEOjEwMjcwNjA4NzM5NDVV", "waybill": "1027060873945U", "carrierId": "DPD", "createdAt": "2025-10-08T07:21:18.283Z", "lineItems": [{"id": "d2701550-a399-11f0-a3bc-ef5c37833579"}]}, {"id": "RFBEOjEwMjcwNjA4NzQwMzFV", "waybill": "1027060874031U", "carrierId": "DPD", "createdAt": "2025-10-08T07:21:18.483Z", "lineItems": [{"id": "d2701550-a399-11f0-a3bc-ef5c37833579"}]}]	\N	0.00	\N	[]	f
7641	8173bb40-a397-11f0-9288-ef897151e2e1	\N	\N	2025-10-07 16:07:22.286	Gotowe do realizacji	allegro-pl	6728704	niuniaxxl	ebpf4r1q0j+e406cc62@allegromail.pl	\N	Katarzyna Łada	+48 663 773 903	Młodzieżowa 3/26	89-600	Chojnice	PL	95f49ab6-a397-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	462.00	PLN	Allegro Kurier DPD	0.00	PLN	462.00	PLN	\N	t	\N	2025-10-07 16:07:22.286	\N	2025-10-09 19:34:57.866778	ONLINE	f	[{"id": "RFBEOjEwMjcwOTYxNDk2NDBV", "waybill": "1027096149640U", "carrierId": "DPD", "createdAt": "2025-10-08T11:55:25.438Z", "lineItems": [{"id": "816e3d00-a397-11f0-9288-ef897151e2e1"}]}]	\N	0.00	\N	[]	f
7642	8a869080-a393-11f0-bc71-87ddccc94446	\N	\N	2025-10-07 15:43:40.281	Gotowe do realizacji	allegro-pl	1853612	Margos7	cd4556er8i+2d781ed8@allegromail.pl	TSC POLSKA MICHAŁ CEGLAREK 	Małgorzata Śliwa	+48 502 090 482	Znojów 3A	26-021	Daleszyce	PL	58259370-a394-11f0-a284-071dd65bf45d	PAID	PAYU	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-07 15:43:40.281	\N	2025-10-09 19:34:59.370898	ONLINE	f	[]	\N	0.00	\N	[]	f
7643	e7b9ffb0-a390-11f0-8d43-e5c6c6646cd8	\N	\N	2025-10-07 15:24:45.525	Gotowe do realizacji	allegro-pl	42112779	Client:42112779	eh8bivks34+536f5b453@allegromail.pl	\N	halina Lewandowska	+48 601 794 594	Partyzantów 16/8	07-401	Ostrołęka	PL	f8ce682a-a390-11f0-a284-071dd65bf45d	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	obicie siedziska ES4	t	\N	2025-10-07 15:24:45.525	\N	2025-10-09 19:35:00.89155	ONLINE	f	[{"id": "RFBEOjEwMjcwNDYxNDQyODRV", "waybill": "1027046144284U", "carrierId": "DPD", "createdAt": "2025-10-08T05:20:09Z", "lineItems": [{"id": "e7b2d3c0-a390-11f0-8d43-e5c6c6646cd8"}]}]	\N	0.00	\N	[]	f
7644	eec49e50-a38b-11f0-a6cc-b3145592fdde	\N	\N	2025-10-07 14:47:25.424	Gotowe do realizacji	allegro-pl	60606266	Client:60606266	memryxz7pu+75ac83e00@allegromail.pl	\N	Robert Piątek	+48 508 348 363	Leśna 16	47-113	Staniszcze Wielkie	PL	ef043f65-a38b-11f0-a284-071dd65bf45d	PAID	P24	t	674.30	PLN	Allegro Kurier DPD	0.00	PLN	674.30	PLN	Kolor  Dąb Estana :)	t	\N	2025-10-07 14:47:25.424	\N	2025-10-09 19:35:02.367047	ONLINE	f	[]	\N	0.00	\N	[]	f
7645	e173d570-a388-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-07 14:22:05.215	Gotowe do realizacji	allegro-pl	1046242	anielka.1	cocgw4f2bp+3546c5ea5@allegromail.pl	\N	Grażyna Michalska	+48 604 469 818	Zielonogórska 11	62-300	Września	PL	e1b39e04-a388-11f0-96eb-67f4404dbe40	PAID	P24	t	352.00	PLN	Allegro Kurier DPD	0.00	PLN	352.00	PLN	\N	t	\N	2025-10-07 14:22:05.215	\N	2025-10-09 19:35:03.842614	ONLINE	f	[{"id": "RFBEOjEwMjcxNjY4NDkwNzlV", "waybill": "1027166849079U", "carrierId": "DPD", "createdAt": "2025-10-09T10:03:31.468Z", "lineItems": [{"id": "e16d1eb0-a388-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7646	523a61d0-a37e-11f0-8d43-e5c6c6646cd8	\N	\N	2025-10-07 13:12:18.686	Gotowe do realizacji	allegro-pl	11434945	krawiec177	4710of7hgs+17f4a5b75@allegromail.pl	\N	Tadeusz Zawiejski	+48 604 939 670	Grunwaldzka 49 / 35	76-270	Ustka	PL	dac389ac-a37e-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Kurier DPD pobranie	22.00	PLN	421.00	PLN	\N	f	\N	2025-10-07 13:12:18.686	\N	2025-10-09 19:35:05.323924	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjcwNDY0NzEyNjNV", "waybill": "1027046471263U", "carrierId": "DPD", "createdAt": "2025-10-08T05:23:57.590Z", "lineItems": [{"id": "5233d220-a37e-11f0-8d43-e5c6c6646cd8"}]}]	\N	0.00	\N	[]	f
7647	8af73a30-a373-11f0-a6cc-b3145592fdde	\N	\N	2025-10-07 12:00:37.256	Gotowe do realizacji	allegro-pl	111875511	Client:111875511	m8tv8cezo9+69e5c5a52@allegromail.pl	\N	Krzysztof Czmoch	+48 602 252 693	Puławska 11 / 65	02-515	Warszawa	PL	41156407-a374-11f0-ae11-e76c74c7cf77	PAID	P24	t	364.99	PLN	Allegro Kurier DPD	14.99	PLN	364.99	PLN	\N	f	\N	2025-10-07 12:00:37.256	\N	2025-10-09 19:35:06.788188	ONLINE	f	[]	\N	364.99	2025-10-08 06:56:26.126	[{"id": "e86d5b7a-a413-11f0-9a6c-8548593624b4", "order": {"id": "8af73a30-a373-11f0-a6cc-b3145592fdde"}, "reason": "CANCELLED_BY_BUYER", "status": "SUCCESS", "payment": {"id": "41156407-a374-11f0-ae11-e76c74c7cf77"}, "delivery": {"value": {"amount": "14.99", "currency": "PLN"}}, "deposits": [], "createdAt": "2025-10-08T06:56:26.126Z", "lineItems": [{"id": "8aed7630-a373-11f0-a6cc-b3145592fdde", "type": "QUANTITY", "quantity": 1}], "surcharges": [], "totalValue": {"amount": "364.99", "currency": "PLN"}}]	t
7648	d16fb191-a373-11f0-9468-2bd22967b382	\N	\N	2025-10-07 11:51:09.415	Gotowe do realizacji	allegro-pl	118614023	Client:118614023	lb5asctpdu+1563d3492@allegromail.pl	\N	Karolina Paszczakowska	+48 725 330 793	Cicha 1	63-421	Dębnica	PL	d1afc833-a373-11f0-a417-fd831f6ae8ec	PAID	AF	t	592.00	PLN	Allegro Kurier DPD	0.00	PLN	592.00	PLN	\N	t	\N	2025-10-07 11:51:09.415	\N	2025-10-09 19:35:08.524972	ONLINE	f	[]	\N	0.00	\N	[]	f
7649	04b51c30-a373-11f0-9468-2bd22967b382	\N	\N	2025-10-07 11:49:27.491	Gotowe do realizacji	allegro-pl	2181731	peterkuska	cu1w5h6yzg+4730ba198@allegromail.pl	\N	Piotr Kuśka	+48 606 321 003	os. Orłowiec 55D/3	44-280	Rydułtowy	PL	04f225f5-a373-11f0-a417-fd831f6ae8ec	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Zamawiam kolor siedziska: TH4 - Tkanina Hugo Brązowy	t	\N	2025-10-07 11:49:27.491	\N	2025-10-09 19:35:10.006375	ONLINE	f	[{"id": "RFBEOjEwMjcwNDY4Mjk0NTFV", "waybill": "1027046829451U", "carrierId": "DPD", "createdAt": "2025-10-08T05:28:07.982Z", "lineItems": [{"id": "04ad5400-a373-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7650	79d896e0-a364-11f0-a3bc-ef5c37833579	\N	\N	2025-10-07 10:01:02.157	Gotowe do realizacji	allegro-pl	9950759	michalkiewicz86	3ao4zllb89+1bfa41a4@allegromail.pl	\N	Michał Michałkiewicz	+48 533 229 794	Łyskowskiego 4a / 35	87-300	Brodnica	PL	85826e12-a364-11f0-91d4-7961b40d7b05	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	675.99	PLN	\N	t	\N	2025-10-07 10:01:02.157	\N	2025-10-09 19:35:11.487078	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7651	88b45fd1-a357-11f0-bc71-87ddccc94446	\N	\N	2025-10-07 08:28:40.427	Gotowe do realizacji	allegro-pl	123671648	syn-mar	z8jngugyz2+524cc2458@allegromail.pl	\N	marek synowiec	+48 535 573 838	orzechowa 29 / 29	50-540	wrocław	PL	88d70327-a357-11f0-baf9-a33944a1116d	PAID	P24	t	1052.00	PLN	Allegro Kurier DPD	0.00	PLN	1052.00	PLN	\N	t	\N	2025-10-07 08:28:40.427	\N	2025-10-09 19:35:12.962774	ONLINE	f	[{"id": "RFBEOjEwMjcxNjY5NTg5MzhV", "waybill": "1027166958938U", "carrierId": "DPD", "createdAt": "2025-10-09T10:04:24.609Z", "lineItems": [{"id": "88af56c1-a357-11f0-bc71-87ddccc94446"}]}, {"id": "RFBEOjEwMjcxNjY5NTkwMTFV", "waybill": "1027166959011U", "carrierId": "DPD", "createdAt": "2025-10-09T10:04:24.781Z", "lineItems": [{"id": "88af56c1-a357-11f0-bc71-87ddccc94446"}]}, {"id": "RFBEOjEwMjcxNjY5NTkxNTRV", "waybill": "1027166959154U", "carrierId": "DPD", "createdAt": "2025-10-09T10:04:24.945Z", "lineItems": [{"id": "88af56c1-a357-11f0-bc71-87ddccc94446"}]}]	\N	0.00	\N	[]	f
7652	6b11b120-a353-11f0-a15e-754093089519	\N	\N	2025-10-07 08:04:42.843	Gotowe do realizacji	allegro-pl	19616942	annastefan20	puinwti7od+202c49563@allegromail.pl	\N	Anna Stefan	+48 600 910 291	ul. Ks. Kard. Wyszyńskiego 11/35	86-100	Świecie	PL	6b523d7e-a353-11f0-a284-071dd65bf45d	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-10-07 08:04:42.843	\N	2025-10-09 19:35:14.481877	ONLINE	f	[{"id": "RFBEOjEwMjY5OTc4Mzk0ODZV", "waybill": "1026997839486U", "carrierId": "DPD", "createdAt": "2025-10-07T10:29:46.540Z", "lineItems": [{"id": "6b0a8530-a353-11f0-a15e-754093089519"}]}, {"id": "RFBEOjEwMjcwODkzMDY1OTJV", "waybill": "1027089306592U", "carrierId": "DPD", "createdAt": "2025-10-08T10:54:18.129Z", "lineItems": [{"id": "6b0a8530-a353-11f0-a15e-754093089519"}]}]	\N	0.00	\N	[]	f
81	015ac010-a122-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-04 13:02:15.515	Gotowe do realizacji	allegro-pl	33192489	Client:33192489	d2zb9jl933+4e4234b37@allegromail.pl	\N	kamil cybulski	+48 508 975 603	Trzcinowa 22/27	87-100	Toruń	PL	2a3a508d-a122-11f0-ae11-e76c74c7cf77	PAID	AF	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	Hugo czarny TH1	t	\N	2025-10-04 13:02:15.515	\N	2025-10-09 19:41:24.543023	ONLINE	f	[{"id": "RFBEOjEwMjY5ODUxOTc0NDFV", "waybill": "1026985197441U", "carrierId": "DPD", "createdAt": "2025-10-07T08:56:22.320Z", "lineItems": [{"id": "01540950-a122-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
8323	388cd660-a5d0-11f0-8895-094b8cada9e7	\N	\N	2025-10-10 11:57:06.256	Gotowe do realizacji	allegro-pl	5888423	maciuretto	st4kk53dob+67a407c42@allegromail.pl	\N	marcel bednarski	+48 516 088 533	JANA PAWŁA II / 59	96-230	Biała Rawska	\N	38b2ae99-a5d0-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	366.99	\N	Allegro Kurier DPD	14.99	PLN	366.99	PLN	\N	f	\N	2025-10-10 11:57:11.54	\N	2025-10-10 22:01:23.875625	ONLINE	f	[]	\N	0.00	\N	[]	f
7653	628c6f80-a34f-11f0-b861-bd1e9af656a8	\N	\N	2025-10-07 07:33:53.346	Gotowe do realizacji	allegro-pl	10348784	adamrak77	b3mcamissn+285837b38@allegromail.pl	\N	Adam Rak	+48 606 629 466	Wojska Polskiego 16/3	78-460	Barwice	PL	69a01ceb-a34f-11f0-b9a1-9fd75769370f	PAID	P24	t	532.00	PLN	Allegro Kurier DPD	0.00	PLN	532.00	PLN	\N	t	\N	2025-10-07 07:33:53.346	\N	2025-10-09 19:35:15.94631	ONLINE	f	[{"id": "RFBEOjEwMjcwNjEzMDU2NjBV", "waybill": "1027061305660U", "carrierId": "DPD", "createdAt": "2025-10-08T07:24:22.582Z", "lineItems": [{"id": "6287b490-a34f-11f0-b861-bd1e9af656a8"}]}, {"id": "RFBEOjEwMjcwNjEzMDU3MDFV", "waybill": "1027061305701U", "carrierId": "DPD", "createdAt": "2025-10-08T07:24:22.804Z", "lineItems": [{"id": "6287b490-a34f-11f0-b861-bd1e9af656a8"}]}]	\N	0.00	\N	[]	f
7654	b4dad3c0-a34b-11f0-87ab-43c4d16d6a38	\N	\N	2025-10-07 07:05:08.702	Gotowe do realizacji	allegro-pl	90492441	Client:90492441	np29ltdy0p+15a87cad0@allegromail.pl	\N	Bogumiła Świrszcz	+48 601 904 095	Siennica Nadolna194A	22-302	Siennica Nadolna	PL	b51bfc41-a34b-11f0-ae11-e76c74c7cf77	PAID	AF	t	737.00	PLN	Allegro Kurier DPD	0.00	PLN	737.00	PLN	Siedzisko ES1	t	\N	2025-10-07 07:05:08.702	\N	2025-10-09 19:35:17.471156	ONLINE	f	[{"id": "RFBEOjEwMjY5OTY5NzQ0MTVV", "waybill": "1026996974415U", "carrierId": "DPD", "createdAt": "2025-10-07T10:23:49.202Z", "lineItems": [{"id": "b4d359b0-a34b-11f0-87ab-43c4d16d6a38"}]}, {"id": "RFBEOjEwMjY5OTY5NzQ1MDZV", "waybill": "1026996974506U", "carrierId": "DPD", "createdAt": "2025-10-07T10:23:49.371Z", "lineItems": [{"id": "b4d359b0-a34b-11f0-87ab-43c4d16d6a38"}]}]	\N	0.00	\N	[]	f
7655	a6aa15b2-a349-11f0-9d2c-bd0fd501dc68	\N	\N	2025-10-07 12:04:58.09	Gotowe do realizacji	allegro-pl	96105871	mk_termoinstal	diipxwoujq+5535528e8@allegromail.pl	MK TERMO-INSTAL KRZYSZTOF GRĘZAK	Krzysztof Gręzak	+48 517 517 770	Lekarska 4-6	51-147	Wrocław	PL	a9bdbf05-a349-11f0-baf9-a33944a1116d	PAID	PAYU	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	\N	t	\N	2025-10-07 12:04:58.09	\N	2025-10-09 19:35:18.983524	ONLINE	t	[{"id": "RFBEOjEwMjcwNDY3NDkyMzJV", "waybill": "1027046749232U", "carrierId": "DPD", "createdAt": "2025-10-08T05:27:13.178Z", "lineItems": [{"id": "a6a3fb32-a349-11f0-9d2c-bd0fd501dc68"}]}]	Michała Bałuckiego 14	0.00	\N	[]	f
7656	865e98b0-a346-11f0-9fcc-bf32f2dae555	\N	\N	2025-10-07 06:28:32.483	Gotowe do realizacji	allegro-pl	102694434	Client:102694434	zvv864av6z+71cf35c30@allegromail.pl	\N	Marzena Nagórka	+48 609 438 239	Adamów 17a, 	96-115	Nowy Kawęczyn	PL	8e677b5e-a346-11f0-a284-071dd65bf45d	PAID	AF	t	737.00	PLN	Allegro Kurier DPD	0.00	PLN	737.00	PLN	dzień dobry, poproszę kolor obicia: WE1 - welur czarny. Pozdrawiam	t	\N	2025-10-07 06:28:32.483	\N	2025-10-09 19:35:20.522399	ONLINE	f	[{"id": "RFBEOjEwMjY5OTY5NzExNzJV", "waybill": "1026996971172U", "carrierId": "DPD", "createdAt": "2025-10-07T10:23:47.636Z", "lineItems": [{"id": "865793d0-a346-11f0-9fcc-bf32f2dae555"}]}, {"id": "RFBEOjEwMjY5OTY5NzEyOTJV", "waybill": "1026996971292U", "carrierId": "DPD", "createdAt": "2025-10-07T10:23:47.837Z", "lineItems": [{"id": "865793d0-a346-11f0-9fcc-bf32f2dae555"}]}]	\N	0.00	\N	[]	f
7658	dcd790a2-a33e-11f0-b871-03a75625f948	\N	\N	2025-10-07 05:32:14.577	Gotowe do realizacji	allegro-pl	2571925	kustek_2004	1577z7ts6d+279e29594@allegromail.pl	\N	Jacek Kustosik	+48 605 125 260	Południowa 24	95-035	Ozorków	PL	dd0b4b87-a33e-11f0-baf9-a33944a1116d	PAID	P24	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-07 05:32:14.577	\N	2025-10-09 19:35:24.240742	ONLINE	f	[{"id": "RFBEOjEwMjY5ODkyODI5MThV", "waybill": "1026989282918U", "carrierId": "DPD", "createdAt": "2025-10-07T09:26:17.291Z", "lineItems": [{"id": "dcd26082-a33e-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjY5ODkyODMwOTlV", "waybill": "1026989283099U", "carrierId": "DPD", "createdAt": "2025-10-07T09:26:17.519Z", "lineItems": [{"id": "dcd26082-a33e-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7659	3a93dcb0-a32d-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-07 03:28:47.757	Gotowe do realizacji	allegro-pl	27345867	Nikosiaa5	zfd2p0s7o5+79a272f57@allegromail.pl	\N	Nikola Wicka	+48 796 430 704	Ignacego Matuszewskiego 11	80-288	GDAŃSK	PL	428abeae-a32d-11f0-a417-fd831f6ae8ec	PAID	AF	t	312.20	PLN	Allegro Kurier DPD	0.00	PLN	312.20	PLN	Materiał  F04	t	\N	2025-10-07 03:28:47.757	\N	2025-10-09 19:35:25.830315	ONLINE	f	[{"id": "RFBEOjEwMjY5NTQyMjgxOTNV", "waybill": "1026954228193U", "carrierId": "DPD", "createdAt": "2025-10-07T04:38:02.663Z", "lineItems": [{"id": "3a8cd7d0-a32d-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
47	394fc140-a1eb-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-05 13:02:00.102	Gotowe do realizacji	allegro-pl	44178885	krzyskonin	20hgxoh50t+73215da44@allegromail.pl	\N	Krzysztof Przybylski	+48 535 095 804	Ul.Wyzwolenia 5/81	62-510	Konin	\N	39712c73-a1eb-11f0-b9a1-9fd75769370f	PAID	PAYU	t	328.99	\N	Allegro Kurier DPD	14.99	PLN	328.99	PLN	Material na siedzisko z materiału o kodzie WE1. Pozdrawiam 	f	\N	2025-10-08 14:30:52.22	\N	2025-10-09 19:35:27.436274	ONLINE	f	[]	\N	0.00	\N	[]	f
7661	ef3fe2b0-9e02-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-08 01:11:39.258	Anulowane	allegro-pl	21868358	sylwia4258	aqxzyoslha+70e0acd15@allegromail.pl	\N	Sylwia Rejman	+48 607 676 799	\N	\N	\N	\N	ef63e633-9e02-11f0-b9a1-9fd75769370f	UNPAID	PAYU	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1887.00	PLN	kolor obicia welur jasnoszary WE2.  kolor wieszaków czarny 	t	\N	\N	\N	2025-10-09 19:35:28.936689	ONLINE	f	[]	\N	0.00	\N	[]	f
7662	30520490-9d63-11f0-a677-a5b8c1586284	\N	\N	2025-10-07 01:15:30.58	Anulowane	allegro-pl	5245834	GenCode	1cylqscdvc+71ceb6f85@allegromail.pl	M&H Hubert Lachtara	Hubert Lachtara	+48 533 425 222	\N	\N	\N	\N	3833d760-9d63-11f0-baf9-a33944a1116d	UNPAID	AF	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	\N	t	\N	\N	\N	2025-10-09 19:35:30.351716	ONLINE	t	[]	Osówka 33C	0.00	\N	[]	f
7663	0e64f410-9d35-11f0-8058-6bb39f24a57a	\N	\N	2025-10-07 01:09:41.924	Anulowane	allegro-pl	8960922	madziastr1992	k9cpc4s4ox+41bd02ef4@allegromail.pl	\N	Magdalena Strzelczyk	+48 530 584 172	\N	\N	\N	\N	725c9082-9d62-11f0-a417-fd831f6ae8ec	UNPAID	AF	t	\N	\N	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	Dzień dobry, \n\nProszę i przyslanie wieszaków w kolorze szczotkowanego złota, natomiast jeśli chodzi o kolor obic to proszę zeby był to czarny welur. Chciałabym u Państwa kupić równiez dwa dodatkowe wieszaki w kolorze szczotkowanego złota, proszę o kontakt jeśli to możliwe. 	t	\N	2025-09-29 18:43:11.488	\N	2025-10-09 19:35:31.762006	ONLINE	t	[]	Osówka 33c	0.00	\N	[]	f
16	969f5ca0-a238-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-05 22:18:38.395	Gotowe do realizacji	allegro-pl	22002746	Saakeee	rb61i0fh2x+406d83e04@allegromail.pl	\N	Artur Majdoszka	+48 601 929 294	Kijowska 3/55	85-703	Bydgoszcz	PL	96ce0e0c-a238-11f0-91d4-7961b40d7b05	PAID	P24	t	1140.00	PLN	Allegro Kurier DPD	0.00	PLN	1140.00	PLN	proszę o tkaninę ES1	t	\N	2025-10-05 22:18:38.395	\N	2025-10-09 19:39:45.567104	ONLINE	f	[{"id": "RFBEOjEwMjcxNDA0NzcwMDFV", "waybill": "1027140477001U", "carrierId": "DPD", "createdAt": "2025-10-09T06:38:04.819Z", "lineItems": [{"id": "963f6250-a238-11f0-b1e3-b7ce882fc700"}, {"id": "963f6251-a238-11f0-b1e3-b7ce882fc700"}]}, {"id": "RFBEOjEwMjcxNDA0NzcxNDBV", "waybill": "1027140477140U", "carrierId": "DPD", "createdAt": "2025-10-09T06:38:05.035Z", "lineItems": [{"id": "963f6250-a238-11f0-b1e3-b7ce882fc700"}, {"id": "963f6251-a238-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
76	cee26871-a12d-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-04 14:27:39.591	Gotowe do realizacji	allegro-pl	115589707	Client:115589707	ezz8chcixp+67e06ed89@allegromail.pl	\N	Agnieszka Sepioło	+48 792 012 447	A. Zgrzebnioka 16A/18	41-717	Ruda Śląska	PL	cf10565f-a12d-11f0-91d4-7961b40d7b05	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Poproszę kolor siedziska czarny welur WE1.	t	\N	2025-10-04 14:27:39.591	\N	2025-10-09 19:41:17.079634	ONLINE	f	[{"id": "RFBEOjEwMjY4NDY2ODk0NDFV", "waybill": "1026846689441U", "carrierId": "DPD", "createdAt": "2025-10-06T05:17:19Z", "lineItems": [{"id": "cedcea31-a12d-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
17	ed908310-a236-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-05 22:06:27.103	Gotowe do realizacji	allegro-pl	10162321	jola260173	apw1it6j05+1d9d9df57@allegromail.pl	\N	Jolanta Stasiorowska	+48 880 066 033	Oś.XXX-Lecia 11/41	47-303	Krapkowice	PL	edb39c39-a236-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	564.00	PLN	Allegro Kurier DPD	0.00	PLN	564.00	PLN	\N	t	\N	2025-10-05 22:06:27.103	\N	2025-10-09 19:39:47.255143	ONLINE	f	[{"id": "RFBEOjEwMjY5NjQxMjY3NDFV", "waybill": "1026964126741U", "carrierId": "DPD", "createdAt": "2025-10-07T06:24:29.011Z", "lineItems": [{"id": "ed8c3d50-a236-11f0-b1e3-b7ce882fc700"}]}, {"id": "RFBEOjEwMjY5NjQxMjY4MDFV", "waybill": "1026964126801U", "carrierId": "DPD", "createdAt": "2025-10-07T06:24:29.161Z", "lineItems": [{"id": "ed8c3d50-a236-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
20	293909b0-a22c-11f0-809f-f9f6de958f67	\N	\N	2025-10-05 20:47:22.417	Gotowe do realizacji	allegro-pl	49172203	Client:49172203	y5thla94kr+7df22af92@allegromail.pl	\N	Klara Ruta	+48 573 068 211	Wyzwolenia 72	84-120	Władysławowo	PL	2976af23-a22c-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	1426.00	PLN	Allegro Kurier DPD	0.00	PLN	1426.00	PLN	\N	t	\N	2025-10-05 20:47:22.417	\N	2025-10-09 19:39:51.969786	ONLINE	f	[{"id": "RFBEOjEwMjY5NjQ0Nzc0NDhV", "waybill": "1026964477448U", "carrierId": "DPD", "createdAt": "2025-10-07T06:26:50.596Z", "lineItems": [{"id": "2931ddc2-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc1-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc0-a22c-11f0-809f-f9f6de958f67"}]}, {"id": "RFBEOjEwMjY5NjQ0Nzc1MzdV", "waybill": "1026964477537U", "carrierId": "DPD", "createdAt": "2025-10-07T06:26:50.887Z", "lineItems": [{"id": "2931ddc2-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc1-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc0-a22c-11f0-809f-f9f6de958f67"}]}, {"id": "RFBEOjEwMjY5NjQ0Nzc2MjlV", "waybill": "1026964477629U", "carrierId": "DPD", "createdAt": "2025-10-07T06:26:51.157Z", "lineItems": [{"id": "2931ddc2-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc1-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc0-a22c-11f0-809f-f9f6de958f67"}]}, {"id": "RFBEOjEwMjY5NjQ0Nzc3NjhV", "waybill": "1026964477768U", "carrierId": "DPD", "createdAt": "2025-10-07T06:26:51.410Z", "lineItems": [{"id": "2931ddc2-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc1-a22c-11f0-809f-f9f6de958f67"}, {"id": "2931ddc0-a22c-11f0-809f-f9f6de958f67"}]}]	\N	0.00	\N	[]	f
22	56379be0-a225-11f0-a82d-fde841cbe8d5	\N	\N	2025-10-05 19:59:20.655	Gotowe do realizacji	allegro-pl	23392865	izabela806	lzdcljckn0+2fae5c5a9@allegromail.pl	DANMAR P.U.P.H. Mariusz Czerwiński	Izabela Czerwińska	+48 794 901 172	Juhasowa 9/1	92-008	Łódź	PL	565bed92-a225-11f0-91d4-7961b40d7b05	PAID	P24	t	1179.00	PLN	Allegro Kurier DPD	0.00	PLN	1179.00	PLN	Kod koloru siedziska TH3	t	\N	2025-10-05 19:59:20.655	\N	2025-10-09 19:39:55.275374	ONLINE	f	[{"id": "RFBEOjEwMjY5Njc3NzI3OTFV", "waybill": "1026967772791U", "carrierId": "DPD", "createdAt": "2025-10-07T06:51:08.625Z", "lineItems": [{"id": "56326bc1-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc2-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc0-a225-11f0-a82d-fde841cbe8d5"}]}, {"id": "RFBEOjEwMjY5Njc3NzI4NzlV", "waybill": "1026967772879U", "carrierId": "DPD", "createdAt": "2025-10-07T06:51:08.842Z", "lineItems": [{"id": "56326bc1-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc2-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc0-a225-11f0-a82d-fde841cbe8d5"}]}, {"id": "RFBEOjEwMjY5Njc3NzI5MzhV", "waybill": "1026967772938U", "carrierId": "DPD", "createdAt": "2025-10-07T06:51:09.073Z", "lineItems": [{"id": "56326bc1-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc2-a225-11f0-a82d-fde841cbe8d5"}, {"id": "56326bc0-a225-11f0-a82d-fde841cbe8d5"}]}]	\N	0.00	\N	[]	f
23	26221bd0-a223-11f0-bddc-ebae77b3e555	\N	\N	2025-10-05 19:40:58.174	Gotowe do realizacji	allegro-pl	2248500	konrad_ST	5f8rptto36+1d4d811d0@allegromail.pl	\N	Konrad Stefański	+48 503 353 570	Sikorskiego 1/13	05-500	Piaseczno	PL	265dc580-a223-11f0-96eb-67f4404dbe40	PAID	PAYU	t	737.00	PLN	Allegro Kurier DPD	0.00	PLN	737.00	PLN	\N	t	\N	2025-10-05 19:40:58.174	\N	2025-10-09 19:39:57.070851	ONLINE	f	[{"id": "RFBEOjEwMjY5NjgyMDEwNjNV", "waybill": "1026968201063U", "carrierId": "DPD", "createdAt": "2025-10-07T06:54:14.356Z", "lineItems": [{"id": "261aefe0-a223-11f0-bddc-ebae77b3e555"}, {"id": "261aefe1-a223-11f0-bddc-ebae77b3e555"}]}]	\N	0.00	\N	[]	f
24	568e1d20-a221-11f0-83df-53954cf6c551	\N	\N	2025-10-05 19:31:34.986	Gotowe do realizacji	allegro-pl	5042203	Sawek86	8btb1eum23+4b3e77da4@allegromail.pl	\N	Sławomir Bicz	+48 691 340 465	ul. Szmaragdowa  16/62	20-570	Lublin	PL	56ca8a54-a221-11f0-a417-fd831f6ae8ec	PAID	P24	t	2209.00	PLN	Allegro Kurier DPD	0.00	PLN	2209.00	PLN	H1 Haczyk czarny \nF04 Fjord Czarny\noraz zgodnie z rozmową telefoniczną proszę o 2 listewki w kolorze Wotan w rozmiarze 60 cm szerokości na 9 cm wysokości oklejone z 4 stron.	t	\N	2025-10-05 19:31:34.986	\N	2025-10-09 19:39:58.724698	ONLINE	f	[{"id": "RFBEOjEwMjY5MDY0NTkyMTZV", "waybill": "1026906459216U", "carrierId": "DPD", "createdAt": "2025-10-06T10:56:19.155Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDY0NTkzNzdV", "waybill": "1026906459377U", "carrierId": "DPD", "createdAt": "2025-10-06T10:56:19.376Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDY0NTk0MDBV", "waybill": "1026906459400U", "carrierId": "DPD", "createdAt": "2025-10-06T10:56:19.590Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDY0NTk1MTdV", "waybill": "1026906459517U", "carrierId": "DPD", "createdAt": "2025-10-06T10:56:19.804Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDkxMzk1MjFV", "waybill": "1026909139521U", "carrierId": "DPD", "createdAt": "2025-10-06T11:14:33.170Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDkxMzk2NDFV", "waybill": "1026909139641U", "carrierId": "DPD", "createdAt": "2025-10-06T11:14:34Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDkxMzk3NTZV", "waybill": "1026909139756U", "carrierId": "DPD", "createdAt": "2025-10-06T11:14:34Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY5MDkxMzk4OTZV", "waybill": "1026909139896U", "carrierId": "DPD", "createdAt": "2025-10-06T11:14:34Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjcxNjQ4OTg1ODJV", "waybill": "1027164898582U", "carrierId": "DPD", "createdAt": "2025-10-09T09:47:28.525Z", "lineItems": [{"id": "56867c00-a221-11f0-83df-53954cf6c551"}, {"id": "56867c01-a221-11f0-83df-53954cf6c551"}]}]	\N	0.00	\N	[]	f
25	c5ae0f50-a21f-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-05 19:18:13.705	Gotowe do realizacji	allegro-pl	40935541	Client:40935541	o0aga42jr3+6e1175916@allegromail.pl	\N	Krzysztof Gietz	+48 691 955 188	Żmichowskiej 9/3	51-680	Wrocław	PL	c5cf050d-a21f-11f0-b9a1-9fd75769370f	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	OBICIE TH4	t	\N	2025-10-05 19:18:13.705	\N	2025-10-09 19:40:00.385471	ONLINE	f	[{"id": "RFBEOjEwMjY4MzA1MTQ1MDVV", "waybill": "1026830514505U", "carrierId": "DPD", "createdAt": "2025-10-05T19:32:47Z", "lineItems": [{"id": "c5a90640-a21f-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY4NDQ3ODU4ODBV", "waybill": "1026844785880U", "carrierId": "DPD", "createdAt": "2025-10-06T05:01:03.942Z", "lineItems": [{"id": "c5a90640-a21f-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
27	ebc198d0-a21d-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 19:03:54.029	Gotowe do realizacji	allegro-pl	15338578	iwonab1991	oqirqn49b9+69c4a1767@allegromail.pl	\N	Iwona Wróbel	+48 607 580 233	Borowa 591	39-305	Borowa	PL	ec064307-a21d-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	1320.00	PLN	Allegro Kurier DPD	0.00	PLN	1320.00	PLN	\N	t	\N	2025-10-05 19:03:54.029	\N	2025-10-09 19:40:03.351154	ONLINE	f	[{"id": "RFBEOjEwMjY5Njg5MzM3MDVV", "waybill": "1026968933705U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.233Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Njg5MzM4OTNV", "waybill": "1026968933893U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.513Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Njg5MzM5MTZV", "waybill": "1026968933916U", "carrierId": "DPD", "createdAt": "2025-10-07T06:59:40.755Z", "lineItems": [{"id": "ebb87112-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87111-a21d-11f0-a6cc-b3145592fdde"}, {"id": "ebb87110-a21d-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
28	a997f0e0-a217-11f0-83df-53954cf6c551	\N	\N	2025-10-05 18:25:19.86	Gotowe do realizacji	allegro-pl	22584124	emileek79	nkpfs6hyog+51a248b57@allegromail.pl	\N	EMILIAN SZYMAŃSKI	+48 785 411 229	CISEW 149 C	62-700	TUREK	PL	5247d71d-a218-11f0-ae11-e76c74c7cf77	PAID	P24	t	1148.00	PLN	Allegro Kurier DPD	0.00	PLN	1148.00	PLN	TKANIA DO SIEDZISKA - HUGO CZARNY TH1 - PROSZĘ WYROBIĆ SIĘ Z DOSTAWĄ W TYM TYGODNIU BO MAM WOLNE	t	\N	2025-10-05 18:25:19.86	\N	2025-10-09 19:40:05.138351	ONLINE	f	[{"id": "RFBEOjEwMjY4OTI4NTAzMzdV", "waybill": "1026892850337U", "carrierId": "DPD", "createdAt": "2025-10-06T09:36:18.305Z", "lineItems": [{"id": "a9904fc0-a217-11f0-83df-53954cf6c551"}, {"id": "a9904fc1-a217-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY4OTI4NTA0NjhV", "waybill": "1026892850468U", "carrierId": "DPD", "createdAt": "2025-10-06T09:36:18.657Z", "lineItems": [{"id": "a9904fc0-a217-11f0-83df-53954cf6c551"}, {"id": "a9904fc1-a217-11f0-83df-53954cf6c551"}]}, {"id": "RFBEOjEwMjY4OTI4NTA1MjFV", "waybill": "1026892850521U", "carrierId": "DPD", "createdAt": "2025-10-06T09:36:18.915Z", "lineItems": [{"id": "a9904fc0-a217-11f0-83df-53954cf6c551"}, {"id": "a9904fc1-a217-11f0-83df-53954cf6c551"}]}]	\N	0.00	\N	[]	f
29	6fcc9b40-a20d-11f0-bdc8-e34a18959311	\N	\N	2025-10-05 17:08:43.416	Gotowe do realizacji	allegro-pl	26269530	witaminecka	c2lyu43dxu+339e9bde1@allegromail.pl	\N	Olga Dłubała	+48 721 019 476	Katowicka 39a	42-262	Kolonia Poczesna	PL	6fef8ce1-a20d-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	czarny, welur gladki czarny WE1	t	\N	2025-10-05 17:08:43.416	\N	2025-10-09 19:40:06.790098	ONLINE	f	[{"id": "RFBEOjEwMjY5NjU0NDI3NjJV", "waybill": "1026965442762U", "carrierId": "DPD", "createdAt": "2025-10-07T06:33:59.773Z", "lineItems": [{"id": "6fc7b940-a20d-11f0-bdc8-e34a18959311"}]}, {"id": "RFBEOjEwMjY5NjU0NDI4MDJV", "waybill": "1026965442802U", "carrierId": "DPD", "createdAt": "2025-10-07T06:33:59.991Z", "lineItems": [{"id": "6fc7b940-a20d-11f0-bdc8-e34a18959311"}]}, {"id": "RFBEOjEwMjY5NjU0NDI5ODNV", "waybill": "1026965442983U", "carrierId": "DPD", "createdAt": "2025-10-07T06:34:00.187Z", "lineItems": [{"id": "6fc7b940-a20d-11f0-bdc8-e34a18959311"}]}]	\N	0.00	\N	[]	f
34	2dddfd50-a203-11f0-bdc8-e34a18959311	\N	\N	2025-10-05 15:53:21.281	Gotowe do realizacji	allegro-pl	6026252	zoja73	kvrbunm4hs+49f8c2e54@allegromail.pl	\N	Waldemar Wiśniewski	+48 691 165 762	Mickiewicza 37/2	16-515	PUŃSK	PL	2dfe3076-a203-11f0-baf9-a33944a1116d	PAID	AF	t	963.00	PLN	Allegro Kurier DPD	0.00	PLN	963.00	PLN	\N	t	\N	2025-10-05 15:53:21.281	\N	2025-10-09 19:40:14.39478	ONLINE	f	[{"id": "RFBEOjEwMjY5Njk1NDU3NjFV", "waybill": "1026969545761U", "carrierId": "DPD", "createdAt": "2025-10-07T07:04:04.727Z", "lineItems": [{"id": "2dd9b790-a203-11f0-bdc8-e34a18959311"}]}, {"id": "RFBEOjEwMjY5Njk1NDU4NDlV", "waybill": "1026969545849U", "carrierId": "DPD", "createdAt": "2025-10-07T07:04:04.929Z", "lineItems": [{"id": "2dd9b790-a203-11f0-bdc8-e34a18959311"}]}, {"id": "RFBEOjEwMjY5Njk1NDU5OTZV", "waybill": "1026969545996U", "carrierId": "DPD", "createdAt": "2025-10-07T07:04:05.136Z", "lineItems": [{"id": "2dd9b790-a203-11f0-bdc8-e34a18959311"}]}]	\N	0.00	\N	[]	f
35	c68fea00-a202-11f0-9468-2bd22967b382	\N	\N	2025-10-05 15:52:51.361	Gotowe do realizacji	allegro-pl	9187840	kipriotis	ygjowkffz6+3e9b27f54@allegromail.pl	\N	Agnieszka Świetlikowska	+48 609 129 803	ul. K. Wyki 1/33	01-318	Warszawa	PL	ed0be826-a202-11f0-baf9-a33944a1116d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	9.98	PLN	884.98	PLN	uchwyty do obydwu szafek - U1 czarny\nsiedzisko WE5 welur niebieski	t	\N	2025-10-05 15:52:51.361	\N	2025-10-09 19:40:15.890965	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzEzOTU4MzJV", "waybill": "1026971395832U", "carrierId": "DPD", "createdAt": "2025-10-07T07:16:46.447Z", "lineItems": [{"id": "c688be10-a202-11f0-9468-2bd22967b382"}, {"id": "c688be11-a202-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NzEzOTU5NzdV", "waybill": "1026971395977U", "carrierId": "DPD", "createdAt": "2025-10-07T07:16:46.626Z", "lineItems": [{"id": "c688be10-a202-11f0-9468-2bd22967b382"}, {"id": "c688be11-a202-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
38	bce3c350-a1f8-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 14:43:54.253	Gotowe do realizacji	allegro-pl	50234473	Client:50234473	dqp6ih9abn+3c657dbc9@allegromail.pl	\N	Weronika Maksymowicz	+48 512 946 999	Klonownica Duża 52A	21-504	Rokitno	PL	bd2427ef-a1f8-11f0-ae11-e76c74c7cf77	PAID	P24	t	1032.00	PLN	Allegro Kurier DPD	0.00	PLN	1032.00	PLN	zestaw: ES1 - Eko skóra Czarny\npanel: ES1 - Eko skóra Czarny\nwieszak: H1 - Czarny (półmat)	t	\N	2025-10-05 14:43:54.253	\N	2025-10-09 19:40:20.304219	ONLINE	f	[{"id": "RFBEOjEwMjY5NzE5NDQ4MjdV", "waybill": "1026971944827U", "carrierId": "DPD", "createdAt": "2025-10-07T07:20:27.751Z", "lineItems": [{"id": "bcdce581-a1f8-11f0-a6cc-b3145592fdde"}, {"id": "bcdce580-a1f8-11f0-a6cc-b3145592fdde"}, {"id": "bcdce582-a1f8-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5NzE5NDQ5NzhV", "waybill": "1026971944978U", "carrierId": "DPD", "createdAt": "2025-10-07T07:20:28.033Z", "lineItems": [{"id": "bcdce581-a1f8-11f0-a6cc-b3145592fdde"}, {"id": "bcdce580-a1f8-11f0-a6cc-b3145592fdde"}, {"id": "bcdce582-a1f8-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
41	463f6510-a1f3-11f0-9468-2bd22967b382	\N	\N	2025-10-05 14:01:01.967	Gotowe do realizacji	allegro-pl	3967855	asik821	9ptc9d7sk3+7466bf774@allegromail.pl	\N	Joanna Barbara Niewiadomska	+48 530 111 223	Sacharowa 47 m 8, bl.344	92-519	Łódź	PL	5223fbee-a1f3-11f0-a417-fd831f6ae8ec	PAID	AF	t	1705.00	PLN	Allegro Kurier DPD	0.00	PLN	1705.00	PLN	\N	t	\N	2025-10-05 14:01:01.967	\N	2025-10-09 19:40:24.949312	ONLINE	f	[{"id": "RFBEOjEwMjY5NzM1NDY5MzdV", "waybill": "1026973546937U", "carrierId": "DPD", "createdAt": "2025-10-07T07:31:23.115Z", "lineItems": [{"id": "46381210-a1f3-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NzM1NDcwNDRV", "waybill": "1026973547044U", "carrierId": "DPD", "createdAt": "2025-10-07T07:31:23.414Z", "lineItems": [{"id": "46381210-a1f3-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NzM1NDcxMDVV", "waybill": "1026973547105U", "carrierId": "DPD", "createdAt": "2025-10-07T07:31:23.701Z", "lineItems": [{"id": "46381210-a1f3-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
42	3bdeafe0-a1f3-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 13:58:49.976	Gotowe do realizacji	allegro-pl	53808012	Client:53808012	3hwter5ktz+4316a877@allegromail.pl	\N	Małgorzata Miedzianko	+48 698 694 482	Moniuszki, 66 I /306	58-300	Wałbrzych	PL	3e24f6b3-a1f3-11f0-96eb-67f4404dbe40	PAID	AF	t	954.00	PLN	Allegro Kurier DPD	0.00	PLN	954.00	PLN	\N	t	\N	2025-10-05 13:58:49.976	\N	2025-10-09 19:40:26.431286	ONLINE	t	[{"id": "RFBEOjEwMjY5NzM4NDU5NDdV", "waybill": "1026973845947U", "carrierId": "DPD", "createdAt": "2025-10-07T07:33:23.998Z", "lineItems": [{"id": "3bd7f920-a1f3-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5NzM4NDYwMzVV", "waybill": "1026973846035U", "carrierId": "DPD", "createdAt": "2025-10-07T07:33:24.236Z", "lineItems": [{"id": "3bd7f920-a1f3-11f0-a6cc-b3145592fdde"}]}]	Moniuszki 66 I /306	0.00	\N	[]	f
79	4a9b1490-a123-11f0-a6cc-b3145592fdde	\N	\N	2025-10-04 13:09:56.199	Gotowe do realizacji	allegro-pl	106650919	Client:106650919	8dtg41s9t4+7fd99ce38@allegromail.pl	\N	Sebastian Konieczny	+48 535 397 690	Grudzińskiego 18e / 19	62-020	Swarzędz	PL	4c4b5cfa-a123-11f0-a417-fd831f6ae8ec	PAID	AF	t	340.99	PLN	Allegro Kurier DPD	14.99	PLN	340.99	PLN	\N	f	\N	2025-10-04 13:09:56.199	\N	2025-10-09 19:41:21.538709	ONLINE	f	[{"id": "RFBEOjEwMjY4NDc5Mjg0ODZV", "waybill": "1026847928486U", "carrierId": "DPD", "createdAt": "2025-10-06T05:27:40.017Z", "lineItems": [{"id": "4a945dd0-a123-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
44	698624e0-a1ef-11f0-84a0-0fb86e0c96e9	\N	\N	2025-10-05 13:30:35.732	Gotowe do realizacji	allegro-pl	15441956	magury23	tg5xgf7w28+6edf37422@allegromail.pl	\N	Małgorzata Guryn	+48 512 364 138	Wąwozowa 27 m 1	02-796	Warszawa	PL	69a7b6ed-a1ef-11f0-91d4-7961b40d7b05	PAID	P24	t	611.00	PLN	Allegro Kurier DPD	0.00	PLN	611.00	PLN	\N	t	\N	2025-10-05 13:30:35.732	\N	2025-10-09 19:40:29.418346	ONLINE	f	[{"id": "RFBEOjEwMjY5NzQzMDExNThV", "waybill": "1026974301158U", "carrierId": "DPD", "createdAt": "2025-10-07T07:36:27.685Z", "lineItems": [{"id": "6981df20-a1ef-11f0-84a0-0fb86e0c96e9"}]}, {"id": "RFBEOjEwMjY5NzQzMDEyMzhV", "waybill": "1026974301238U", "carrierId": "DPD", "createdAt": "2025-10-07T07:36:27.867Z", "lineItems": [{"id": "6981df20-a1ef-11f0-84a0-0fb86e0c96e9"}]}]	\N	0.00	\N	[]	f
45	6c211080-a1ee-11f0-ac86-5dc583ff1e95	\N	\N	2025-10-05 13:24:31.15	Gotowe do realizacji	allegro-pl	74273419	Client:74273419	t0yz0qrqr9+6d02bc742@allegromail.pl	\N	Sylwia Cygan	+48 691 567 494	30 stycznia 15	66-300	Międzyrzecz	PL	911d9a42-a1ee-11f0-baf9-a33944a1116d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1347.99	PLN	H1 haki,eko skóra ES2 jasno szary	t	\N	2025-10-05 13:24:31.15	\N	2025-10-09 19:40:30.915188	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzQ0ODg4MzZV", "waybill": "1026974488836U", "carrierId": "DPD", "createdAt": "2025-10-07T07:37:46.222Z", "lineItems": [{"id": "6c1a80d0-a1ee-11f0-ac86-5dc583ff1e95"}]}, {"id": "RFBEOjEwMjY5NzQ0ODg5MjVV", "waybill": "1026974488925U", "carrierId": "DPD", "createdAt": "2025-10-07T07:37:46.422Z", "lineItems": [{"id": "6c1a80d0-a1ee-11f0-ac86-5dc583ff1e95"}]}, {"id": "RFBEOjEwMjY5NzQ0ODkwMzZV", "waybill": "1026974489036U", "carrierId": "DPD", "createdAt": "2025-10-07T07:37:46.587Z", "lineItems": [{"id": "6c1a80d0-a1ee-11f0-ac86-5dc583ff1e95"}]}]	\N	0.00	\N	[]	f
46	9a2d1e40-a1eb-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-05 13:03:42.723	Gotowe do realizacji	allegro-pl	17267587	Justys-24	qmbkuix3ux+1ed5d5414@allegromail.pl	\N	Justyna Dopierała	+48 723 887 176	ul. Legionów Polskich 5/57	62-700	Turek	PL	9a6a00d6-a1eb-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	707.00	PLN	Allegro Kurier DPD	0.00	PLN	707.00	PLN	Kolor haków H1 (czarny)	t	\N	2025-10-05 13:03:42.723	\N	2025-10-09 19:40:32.414177	ONLINE	f	[{"id": "RFBEOjEwMjY4NDUyMjk4NDBV", "waybill": "1026845229840U", "carrierId": "DPD", "createdAt": "2025-10-06T05:05:24.491Z", "lineItems": [{"id": "9a25cb41-a1eb-11f0-9d66-3d00eb1ccfed"}, {"id": "9a25cb40-a1eb-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY4NDUyMjk5MjlV", "waybill": "1026845229929U", "carrierId": "DPD", "createdAt": "2025-10-06T05:05:24.755Z", "lineItems": [{"id": "9a25cb41-a1eb-11f0-9d66-3d00eb1ccfed"}, {"id": "9a25cb40-a1eb-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
48	c50f7971-a1df-11f0-ac86-5dc583ff1e95	\N	\N	2025-10-05 11:40:19.889	Gotowe do realizacji	allegro-pl	90712689	Client:90712689	ik7ovzupoh+46aef3f54@allegromail.pl	\N	Irmina Paciorkowska	+48 733 140 596	Gorzowska 114,	66-431	Santok	PL	03880fc0-a1e0-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	9.98	PLN	1000.98	PLN	\N	t	\N	2025-10-05 11:40:19.889	\N	2025-10-09 19:40:34.036455	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5NzUxMDY4MDRV", "waybill": "1026975106804U", "carrierId": "DPD", "createdAt": "2025-10-07T07:42:29.219Z", "lineItems": [{"id": "c507ff61-a1df-11f0-ac86-5dc583ff1e95"}, {"id": "c507ff62-a1df-11f0-ac86-5dc583ff1e95"}]}, {"id": "RFBEOjEwMjY5NzUxMDY5MTNV", "waybill": "1026975106913U", "carrierId": "DPD", "createdAt": "2025-10-07T07:42:29.393Z", "lineItems": [{"id": "c507ff61-a1df-11f0-ac86-5dc583ff1e95"}, {"id": "c507ff62-a1df-11f0-ac86-5dc583ff1e95"}]}, {"id": "RFBEOjEwMjY5NzUxMDcwODBV", "waybill": "1026975107080U", "carrierId": "DPD", "createdAt": "2025-10-07T07:42:29.572Z", "lineItems": [{"id": "c507ff61-a1df-11f0-ac86-5dc583ff1e95"}, {"id": "c507ff62-a1df-11f0-ac86-5dc583ff1e95"}]}]	\N	0.00	\N	[]	f
51	d47b0d00-a1d7-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-05 10:43:04.528	Gotowe do realizacji	allegro-pl	10982585	vento3000	q3kse6ip9x+16360a105@allegromail.pl	\N	Aleksandra Sienkiewicz-Otrębska	+48 788 392 686	Golisza 6C / 7	71-782	Szczecin	PL	d4bdbb9b-a1d7-11f0-96eb-67f4404dbe40	PAID	AF	t	977.00	PLN	Allegro Kurier DPD	0.00	PLN	977.00	PLN	Obicie Velvet niebieski, wieszaki czarne.	t	\N	2025-10-05 10:43:04.528	\N	2025-10-09 19:40:38.630984	ONLINE	f	[{"id": "RFBEOjEwMjY5NzU5MzQzMzBV", "waybill": "1026975934330U", "carrierId": "DPD", "createdAt": "2025-10-07T07:48:19.803Z", "lineItems": [{"id": "d4736be0-a1d7-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY5NzU5MzQ0NjdV", "waybill": "1026975934467U", "carrierId": "DPD", "createdAt": "2025-10-07T07:48:20.048Z", "lineItems": [{"id": "d4736be0-a1d7-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
52	e23a1a50-a1d5-11f0-8865-a987ea6c1e01	\N	\N	2025-10-05 10:31:53.166	Gotowe do realizacji	allegro-pl	23392865	izabela806	lzdcljckn0+3c630781@allegromail.pl	DANMAR P.U.P.H. Mariusz Czerwiński	Izabela Czerwińska	+48 794 901 172	Juhasowa 9/1	92-008	Łódź	PL	e27946a4-a1d5-11f0-a417-fd831f6ae8ec	PAID	P24	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	kod koloru TH3	t	\N	2025-10-05 10:31:53.166	\N	2025-10-09 19:40:40.095051	ONLINE	f	[]	\N	828.00	2025-10-06 20:03:53.864	[{"id": "95774407-a2ef-11f0-a0c8-b30e01c12685", "order": {"id": "e23a1a50-a1d5-11f0-8865-a987ea6c1e01"}, "reason": "CANCELLED_BY_BUYER", "status": "SUCCESS", "payment": {"id": "e27946a4-a1d5-11f0-a417-fd831f6ae8ec"}, "deposits": [], "createdAt": "2025-10-06T20:03:53.864Z", "lineItems": [{"id": "e2333c80-a1d5-11f0-8865-a987ea6c1e01", "type": "QUANTITY", "quantity": 1}], "surcharges": [], "totalValue": {"amount": "828.00", "currency": "PLN"}}]	t
53	da174e91-a1d2-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-05 10:05:53.322	Gotowe do realizacji	allegro-pl	37593094	Client:37593094	1togw0nbgl+2d7a1bee6@allegromail.pl	\N	Aurelia Anderson	+48 723 676 120	Słoneczna 29A	88-306	Dąbrowa	PL	da53bc3c-a1d2-11f0-a417-fd831f6ae8ec	PAID	AF	t	1319.00	PLN	Allegro Kurier DPD	0.00	PLN	1319.00	PLN	\N	t	\N	2025-10-05 10:05:53.322	\N	2025-10-09 19:40:41.82403	ONLINE	f	[{"id": "RFBEOjEwMjY4NzMzNDc2NTZV", "waybill": "1026873347656U", "carrierId": "DPD", "createdAt": "2025-10-06T07:48:41.776Z", "lineItems": [{"id": "da1070c0-a1d2-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY4NzMzNDc3MDVV", "waybill": "1026873347705U", "carrierId": "DPD", "createdAt": "2025-10-06T07:48:41.947Z", "lineItems": [{"id": "da1070c0-a1d2-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY4NzMzNDc4OTNV", "waybill": "1026873347893U", "carrierId": "DPD", "createdAt": "2025-10-06T07:48:42.180Z", "lineItems": [{"id": "da1070c0-a1d2-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
56	4289c930-a1c9-11f0-b871-03a75625f948	\N	\N	2025-10-05 08:59:46.466	Gotowe do realizacji	allegro-pl	6535160	oossii87	6cp8o5s9t5+61e56fd9@allegromail.pl	\N	Dawid Osiński	+48 691 885 616	Białobłocka 10	85-363	Bydgoszcz	PL	67b0492e-a1c9-11f0-b9a1-9fd75769370f	PAID	AF	t	628.00	PLN	Allegro Kurier DPD	0.00	PLN	628.00	PLN	Witam, wybieram ES 4 (brąz)	t	\N	2025-10-05 08:59:46.466	\N	2025-10-09 19:40:46.948068	ONLINE	f	[{"id": "RFBEOjEwMjY4NDU0NzQwMDVV", "waybill": "1026845474005U", "carrierId": "DPD", "createdAt": "2025-10-06T05:07:18Z", "lineItems": [{"id": "4284e730-a1c9-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjY4NDU0NzQxODhV", "waybill": "1026845474188U", "carrierId": "DPD", "createdAt": "2025-10-06T05:07:18Z", "lineItems": [{"id": "4284e730-a1c9-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
8025	0cdf9570-a5ad-11f0-833e-e3bb93fde64a	\N	\N	2025-10-10 07:46:13.389	Gotowe do realizacji	allegro-pl	12735898	Zbysze_k_	jn95upxvw6+4117e6c92@allegromail.pl	\N	Zbyszek Niewiarowski	+48 792 234 417	Bakałarzewska 19a	16-400	Suwałki	PL	0d19dfdd-a5ad-11f0-a284-071dd65bf45d	PAID	PAYU	t	243.99	PLN	Allegro Kurier DPD	14.99	PLN	243.99	PLN	uchwyty czarne	f	\N	2025-10-10 07:46:13.389	\N	2025-10-10 08:02:24.096152	ONLINE	f	[]	\N	0.00	\N	[]	f
58	ed350e50-a1c2-11f0-9468-2bd22967b382	\N	\N	2025-10-05 08:13:05.977	Gotowe do realizacji	allegro-pl	66943638	Client:66943638	pvzcqrma45+7574d74d1@allegromail.pl	\N	Bozena Glina	+48 605 092 067	Aleja Reymonta 8 m 1002	01-842	Warszawa	PL	ed739e10-a1c2-11f0-96eb-67f4404dbe40	PAID	P24	t	985.98	PLN	Allegro Kurier DPD	29.98	PLN	985.98	PLN	\N	f	\N	2025-10-05 08:13:05.977	\N	2025-10-09 19:40:49.965101	ONLINE	f	[{"id": "RFBEOjEwMjY5ODA0MzU0NDRV", "waybill": "1026980435444U", "carrierId": "DPD", "createdAt": "2025-10-07T08:21:51.906Z", "lineItems": [{"id": "ed2dbb50-a1c2-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5ODA0MzU1MjFV", "waybill": "1026980435521U", "carrierId": "DPD", "createdAt": "2025-10-07T08:21:52.070Z", "lineItems": [{"id": "ed2dbb50-a1c2-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
60	95595a70-a1bc-11f0-a6cc-b3145592fdde	\N	\N	2025-10-05 07:28:35.636	Gotowe do realizacji	allegro-pl	1102723	karios	x59ro6fnz9+2917eea86@allegromail.pl	\N	Adam Kruczyński	+48 885 362 434	Trzeszczany, 173	22-554	Trzeszczany	PL	9598116f-a1bc-11f0-96eb-67f4404dbe40	PAID	P24	t	1590.00	PLN	Allegro Kurier DPD	0.00	PLN	1590.00	PLN	\N	t	\N	2025-10-05 07:28:35.636	\N	2025-10-09 19:40:52.977557	ONLINE	f	[{"id": "RFBEOjEwMjY5Nzk5ODQ4MjJV", "waybill": "1026979984822U", "carrierId": "DPD", "createdAt": "2025-10-07T08:18:26.405Z", "lineItems": [{"id": "95525592-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525590-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525591-a1bc-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Nzk5ODQ5NDNV", "waybill": "1026979984943U", "carrierId": "DPD", "createdAt": "2025-10-07T08:18:26.709Z", "lineItems": [{"id": "95525592-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525590-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525591-a1bc-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Nzk5ODUwMDZV", "waybill": "1026979985006U", "carrierId": "DPD", "createdAt": "2025-10-07T08:18:27.004Z", "lineItems": [{"id": "95525592-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525590-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525591-a1bc-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Nzk5ODUxOTVV", "waybill": "1026979985195U", "carrierId": "DPD", "createdAt": "2025-10-07T08:18:27.252Z", "lineItems": [{"id": "95525592-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525590-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525591-a1bc-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY5Nzk5ODUyODdV", "waybill": "1026979985287U", "carrierId": "DPD", "createdAt": "2025-10-07T08:18:27.531Z", "lineItems": [{"id": "95525592-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525590-a1bc-11f0-a6cc-b3145592fdde"}, {"id": "95525591-a1bc-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
61	61bbd700-a1b8-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-05 06:57:09.24	Gotowe do realizacji	allegro-pl	3099544	diamel	uiq4reasf0+3ef401aa1@allegromail.pl	\N	Ireneusz Białoń	+48 728 916 799	Kowaniec 99	34-400	Nowy Targ	PL	6a7cbf99-a1b8-11f0-b9a1-9fd75769370f	PAID	P24	t	1332.40	PLN	Allegro Kurier DPD	0.00	PLN	1332.40	PLN	\N	t	\N	2025-10-05 06:57:09.24	\N	2025-10-09 19:40:54.766485	ONLINE	f	[{"id": "RFBEOjEwMjY4NDU2MjU5MjlV", "waybill": "1026845625929U", "carrierId": "DPD", "createdAt": "2025-10-06T05:08:40.532Z", "lineItems": [{"id": "61b176c0-a1b8-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY4NDU2MjYwNTdV", "waybill": "1026845626057U", "carrierId": "DPD", "createdAt": "2025-10-06T05:08:40.688Z", "lineItems": [{"id": "61b176c0-a1b8-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY4NDU2MjYxNDRV", "waybill": "1026845626144U", "carrierId": "DPD", "createdAt": "2025-10-06T05:08:40.827Z", "lineItems": [{"id": "61b176c0-a1b8-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
66	db63fdd0-a159-11f0-9468-2bd22967b382	\N	\N	2025-10-04 19:41:05.125	Gotowe do realizacji	allegro-pl	54910695	klaudyskax94	5b55ogok3w+46f351ae8@allegromail.pl	\N	Klaudia Wałczyk	+48 501 503 231	al.Żoł. I AWP 25/74	22-100	Chełm	PL	dba12e88-a159-11f0-a284-071dd65bf45d	PAID	P24	t	1009.00	PLN	Allegro Kurier DPD	0.00	PLN	1009.00	PLN	WE1 WELUR CZARNY kolor siedziska	t	\N	2025-10-04 19:41:05.125	\N	2025-10-09 19:41:02.125041	ONLINE	f	[{"id": "RFBEOjEwMjY5NjY1OTIwNzVV", "waybill": "1026966592075U", "carrierId": "DPD", "createdAt": "2025-10-07T06:42:22.494Z", "lineItems": [{"id": "db5d2000-a159-11f0-9468-2bd22967b382"}, {"id": "db5d2001-a159-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5NjY1OTIxOTRV", "waybill": "1026966592194U", "carrierId": "DPD", "createdAt": "2025-10-07T06:42:22.682Z", "lineItems": [{"id": "db5d2000-a159-11f0-9468-2bd22967b382"}, {"id": "db5d2001-a159-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
69	80593270-a145-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-04 17:15:29.011	Gotowe do realizacji	allegro-pl	22300676	jadwisia64	98p7ledlzb+38e0ad6f6@allegromail.pl	\N	jadwiga seklecka	+48 664 463 739	Toruńska 71 / 69	87-800	Włocławek	PL	807b8867-a145-11f0-baf9-a33944a1116d	PAID	P24	t	773.00	PLN	Allegro Kurier DPD	0.00	PLN	773.00	PLN	THP1hugo pik grafit	t	\N	2025-10-04 17:15:29.011	\N	2025-10-09 19:41:06.740201	ONLINE	f	[{"id": "RFBEOjEwMjY5ODE2MTYyOTdV", "waybill": "1026981616297U", "carrierId": "DPD", "createdAt": "2025-10-07T08:30:53.849Z", "lineItems": [{"id": "8054c5a0-a145-11f0-96ea-bf4f56b08af2"}]}, {"id": "RFBEOjEwMjY5ODE2MTYzNDBV", "waybill": "1026981616340U", "carrierId": "DPD", "createdAt": "2025-10-07T08:30:54.163Z", "lineItems": [{"id": "8054c5a0-a145-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
71	20dbfe80-a141-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-04 16:44:22.475	Gotowe do realizacji	allegro-pl	5530849	MrFreez_21	bzypb7e8g3+29e2b3707@allegromail.pl	\N	Paweł Grzywna	+48 501 790 801	ul. Częstochowska 38	42-310	Żarki	PL	2a567266-a141-11f0-a284-071dd65bf45d	PAID	PAYU	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	Wybieram kolor siedziska TH3 - Tkanina Hugo Grafitowy	t	\N	2025-10-04 16:44:22.475	\N	2025-10-09 19:41:09.706651	ONLINE	f	[{"id": "RFBEOjEwMjY5ODIxNjk3MDBV", "waybill": "1026982169700U", "carrierId": "DPD", "createdAt": "2025-10-07T08:34:47.289Z", "lineItems": [{"id": "20d547c0-a141-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjY5ODIxNjk4NDBV", "waybill": "1026982169840U", "carrierId": "DPD", "createdAt": "2025-10-07T08:34:47.535Z", "lineItems": [{"id": "20d547c0-a141-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
72	2413b570-a137-11f0-8323-6df02f435f6c	\N	\N	2025-10-04 15:36:09.293	Gotowe do realizacji	allegro-pl	10351791	1zyrafka	mmprme7av9+5c59ec8a6@allegromail.pl	\N	Jolanta Stępień	+48 781 298 635	Kozanowska 89 / 6	54-152	Wrocław	PL	8db110c6-a137-11f0-96eb-67f4404dbe40	PAID	P24	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	kolor tapicerki F03	f	\N	2025-10-04 15:36:09.293	\N	2025-10-09 19:41:11.166047	ONLINE	f	[{"id": "RFBEOjEwMjY4NDY1NzM3MzlV", "waybill": "1026846573739U", "carrierId": "DPD", "createdAt": "2025-10-06T05:16:22.272Z", "lineItems": [{"id": "240ed370-a137-11f0-8323-6df02f435f6c"}]}, {"id": "RFBEOjAwMDAwNDAwMzAyODlM", "waybill": "0000040030289L", "carrierId": "DPD", "createdAt": "2025-10-09T13:25:11Z", "lineItems": [{"id": "240ed370-a137-11f0-8323-6df02f435f6c"}]}]	\N	0.00	\N	[]	f
73	893ee8c2-a137-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-04 15:35:27.865	Gotowe do realizacji	allegro-pl	38521102	Client:38521102	4qpl8m68vx+7b40fd458@allegromail.pl	\N	Adam Barut	+48 692 633 038	Strażacka 12	34-325	Łodygowice	PL	898bd060-a137-11f0-96eb-67f4404dbe40	PAID	P24	t	671.00	PLN	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	2025-10-04 15:35:27.865	\N	2025-10-09 19:41:12.644539	ONLINE	f	[{"id": "RFBEOjEwMjY5ODQ3Mjg3NjRV", "waybill": "1026984728764U", "carrierId": "DPD", "createdAt": "2025-10-07T08:52:50.912Z", "lineItems": [{"id": "89365d47-a137-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY5ODQ3Mjg4NzZV", "waybill": "1026984728876U", "carrierId": "DPD", "createdAt": "2025-10-07T08:52:51.532Z", "lineItems": [{"id": "89365d47-a137-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
91	04ed7ed0-a095-11f0-9468-2bd22967b382	\N	\N	2025-10-03 20:17:42.6	Gotowe do realizacji	allegro-pl	2917271	Elnets	g0xal2lm3b+5aba6c4d2@allegromail.pl	\N	Henryk Rejek	+48 693 505 604	Wyzwolenia 119	44-321	Marklowice	PL	05288c7d-a095-11f0-a284-071dd65bf45d	PAID	PAYU	t	682.00	PLN	Allegro Kurier DPD	0.00	PLN	682.00	PLN	\N	t	\N	2025-10-03 20:17:42.6	\N	2025-10-09 19:52:23.59694	ONLINE	f	[{"id": "RFBEOjEwMjY4OTIxODY2MDRV", "waybill": "1026892186604U", "carrierId": "DPD", "createdAt": "2025-10-06T09:32:36.635Z", "lineItems": [{"id": "04e679f0-a095-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY4OTIxODY3NTdV", "waybill": "1026892186757U", "carrierId": "DPD", "createdAt": "2025-10-06T09:32:36.808Z", "lineItems": [{"id": "04e679f0-a095-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
92	ce2b1f40-a091-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-03 19:50:30.861	Gotowe do realizacji	allegro-pl	4808772	renegad82	memqlt6x3g+515277702@allegromail.pl	\N	Jacek Wywrót	+48 662 272 999	Żyznów 263	38-111	Żyznów	PL	ce50d048-a091-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	1057.00	PLN	Allegro Kurier DPD	0.00	PLN	1057.00	PLN	\N	t	\N	2025-10-03 19:50:30.861	\N	2025-10-09 19:52:25.112887	ONLINE	f	[{"id": "RFBEOjEwMjY4NjI0MDEwNzlV", "waybill": "1026862401079U", "carrierId": "DPD", "createdAt": "2025-10-06T06:52:41.153Z", "lineItems": [{"id": "ce26b270-a091-11f0-bfbd-d3aacc6a2e00"}, {"id": "ce26b271-a091-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY4NjI0MDExOThV", "waybill": "1026862401198U", "carrierId": "DPD", "createdAt": "2025-10-06T06:52:41.339Z", "lineItems": [{"id": "ce26b270-a091-11f0-bfbd-d3aacc6a2e00"}, {"id": "ce26b271-a091-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY4NjI3MDA1MjJV", "waybill": "1026862700522U", "carrierId": "DPD", "createdAt": "2025-10-06T06:54:17.210Z", "lineItems": [{"id": "ce26b270-a091-11f0-bfbd-d3aacc6a2e00"}, {"id": "ce26b271-a091-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY4NjI3MDA2MDJV", "waybill": "1026862700602U", "carrierId": "DPD", "createdAt": "2025-10-06T06:54:17.471Z", "lineItems": [{"id": "ce26b270-a091-11f0-bfbd-d3aacc6a2e00"}, {"id": "ce26b271-a091-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
93	931ad870-a085-11f0-ba82-ed153ccc4447	\N	\N	2025-10-03 18:20:32.809	Gotowe do realizacji	allegro-pl	45755505	Client:45755505	r99ufav7hh+2270da6b7@allegromail.pl	\N	Dawid Dannheisig	+48 535 812 942	P. Teatralny 8	50-051	Wrocław	PL	978f49ec-a085-11f0-baf9-a33944a1116d	PAID	AF	t	788.00	PLN	Allegro Kurier DPD	0.00	PLN	788.00	PLN	\N	t	\N	2025-10-03 18:20:32.809	\N	2025-10-09 19:52:26.741725	ONLINE	f	[{"id": "RFBEOjEwMjY4OTcxODMwNjdV", "waybill": "1026897183067U", "carrierId": "DPD", "createdAt": "2025-10-06T10:02:15.277Z", "lineItems": [{"id": "9315a850-a085-11f0-ba82-ed153ccc4447"}]}, {"id": "RFBEOjEwMjY4OTcxODMxMjJV", "waybill": "1026897183122U", "carrierId": "DPD", "createdAt": "2025-10-06T10:02:15.474Z", "lineItems": [{"id": "9315a850-a085-11f0-ba82-ed153ccc4447"}]}]	\N	0.00	\N	[]	f
98	b85b60b0-a066-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-03 14:42:16.277	Gotowe do realizacji	allegro-pl	5557325	emka88_2006	wr6wk7yk1j+be8ad560@allegromail.pl	\N	Magdalena Graszkiewicz	+48 783 758 905	Sokola 3a	57-401	Nowa Ruda	PL	187e20ca-a067-11f0-baf9-a33944a1116d	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	proszę o kolor hugo czarny (materiałowe siedzisko)	t	\N	2025-10-03 14:42:16.277	\N	2025-10-09 19:52:34.156421	ONLINE	f	[{"id": "RFBEOjEwMjY4NDcwOTYzMDFV", "waybill": "1026847096301U", "carrierId": "DPD", "createdAt": "2025-10-06T05:20:48.389Z", "lineItems": [{"id": "b856a5c0-a066-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7740	2ec843f0-a05b-11f0-819e-1344c439828f	\N	\N	2025-10-03 13:21:44.774	Gotowe do realizacji	allegro-pl	1658455	janek_krak	v0n7y11rmi+19113f3e7@allegromail.pl	\N	Jan Sienkowski	+48 500 375 612	Osiedle Piastów 77 / 21	31-625	Kraków	PL	3eabcdbf-a05b-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	4308.80	PLN	Allegro Kurier DPD	0.00	PLN	4308.80	PLN	\N	t	\N	2025-10-03 13:21:44.774	\N	2025-10-09 19:52:37.640577	ONLINE	t	[]	Osiedle Piastów 77/21	0.00	\N	[]	f
7741	89083cb0-a058-11f0-9468-2bd22967b382	\N	\N	2025-10-03 12:57:59.387	Gotowe do realizacji	allegro-pl	87515187	Client:87515187	idiv5bir5g+7382a7767@allegromail.pl	\N	Aleksandra  Nagrodzka	+48 514 638 270	Myszkowo 5/3a	82-100	Nowy Dwór Gdański	PL	90c4111f-a058-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1709.99	PLN	\N	t	\N	2025-10-03 12:57:59.387	\N	2025-10-09 19:52:39.753389	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY5MDUyNTA2NzVV", "waybill": "1026905250675U", "carrierId": "DPD", "createdAt": "2025-10-06T10:49:27.778Z", "lineItems": [{"id": "89015ee0-a058-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5MDUyNTA3NjJV", "waybill": "1026905250762U", "carrierId": "DPD", "createdAt": "2025-10-06T10:49:27.926Z", "lineItems": [{"id": "89015ee0-a058-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY5MDUyNTA4MjJV", "waybill": "1026905250822U", "carrierId": "DPD", "createdAt": "2025-10-06T10:49:28.078Z", "lineItems": [{"id": "89015ee0-a058-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7742	f6464f80-a056-11f0-bc87-8159fe565898	\N	\N	2025-10-03 12:47:53.849	Gotowe do realizacji	allegro-pl	102760190	Client:102760190	yvns2ywksc+58b229386@allegromail.pl	\N	Tomasz Wolan	+48 788 945 389	Jana Szczeszyńskiego, 20/1	45-570	Opole	PL	f6868d78-a056-11f0-ae11-e76c74c7cf77	PAID	P24	t	1841.99	PLN	Allegro Kurier DPD	14.99	PLN	1841.99	PLN	\N	f	\N	2025-10-03 12:47:53.849	\N	2025-10-09 19:52:41.570887	ONLINE	f	[{"id": "RFBEOjEwMjY4OTE1OTA1MjNV", "waybill": "1026891590523U", "carrierId": "DPD", "createdAt": "2025-10-06T09:29:07.411Z", "lineItems": [{"id": "f63e1220-a056-11f0-bc87-8159fe565898"}]}, {"id": "RFBEOjEwMjY4OTE1OTA2MTVV", "waybill": "1026891590615U", "carrierId": "DPD", "createdAt": "2025-10-06T09:29:07.638Z", "lineItems": [{"id": "f63e1220-a056-11f0-bc87-8159fe565898"}]}, {"id": "RFBEOjEwMjY4OTE1OTA3OThV", "waybill": "1026891590798U", "carrierId": "DPD", "createdAt": "2025-10-06T09:29:07.881Z", "lineItems": [{"id": "f63e1220-a056-11f0-bc87-8159fe565898"}]}]	\N	0.00	\N	[]	f
7743	a7a598b0-a054-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-03 12:31:46.342	Gotowe do realizacji	allegro-pl	25147213	irek2908	lbzf457bnc+6a83900d8@allegromail.pl	\N	Ireneusz Śniatkowski	+48 536 907 262	Łoźnica 55/5	72-110	Przybiernów	PL	a7e2a1c4-a054-11f0-a417-fd831f6ae8ec	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	tkanina obicia WE3 	t	\N	2025-10-03 12:31:46.342	\N	2025-10-09 19:52:43.152649	ONLINE	f	[{"id": "RFBEOjEwMjY4NDc2NzY0OTNV", "waybill": "1026847676493U", "carrierId": "DPD", "createdAt": "2025-10-06T05:25:32.355Z", "lineItems": [{"id": "a79e45b0-a054-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7753	839dfc50-9fc8-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-02 19:47:53.535	Gotowe do realizacji	allegro-pl	42306977	kaczmar-michal	kiuifgz4l4+3dab32400@allegromail.pl	\N	Michał Kaczmarek	+48 783 286 826	Wierzbowa 25	99-220	Wartkowice	PL	8dd3d104-9fc8-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1027.99	PLN	Proszę kolor we1 - czarny welur \nDziękuję 	t	\N	2025-10-02 19:47:53.535	\N	2025-10-09 19:52:59.035883	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3NTkxMDgxNTBV", "waybill": "1026759108150U", "carrierId": "DPD", "createdAt": "2025-10-03T11:29:05.764Z", "lineItems": [{"id": "8396a950-9fc8-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY3NTkxMDgyNzBV", "waybill": "1026759108270U", "carrierId": "DPD", "createdAt": "2025-10-03T11:29:05.961Z", "lineItems": [{"id": "8396a950-9fc8-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY3NTkxMDgzODNV", "waybill": "1026759108383U", "carrierId": "DPD", "createdAt": "2025-10-03T11:29:06.153Z", "lineItems": [{"id": "8396a950-9fc8-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7754	70857c70-9fc7-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-02 19:40:28.221	Gotowe do realizacji	allegro-pl	111315111	MSDOMEX	tgzxg5xleh+2108d93e2@allegromail.pl	DOMEX Małgorzata Sidorowicz	MAŁGORZATA SIDOROWICZ	+48 605 991 580	SZEROKA 14	69-108	Grzmiąca	PL	70c71a0f-9fc7-11f0-ae11-e76c74c7cf77	PAID	P24	t	587.00	PLN	Allegro Kurier DPD	0.00	PLN	587.00	PLN	\N	t	\N	2025-10-02 19:40:28.221	\N	2025-10-09 19:53:00.995018	ONLINE	t	[{"id": "RFBEOjEwMjY3NTkyOTQzMThV", "waybill": "1026759294318U", "carrierId": "DPD", "createdAt": "2025-10-03T11:31:27.045Z", "lineItems": [{"id": "707e9ea0-9fc7-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY3NTkyOTQ0MjdV", "waybill": "1026759294427U", "carrierId": "DPD", "createdAt": "2025-10-03T11:31:27.428Z", "lineItems": [{"id": "707e9ea0-9fc7-11f0-9d66-3d00eb1ccfed"}]}]	ul. Szeroka 14	0.00	\N	[]	f
7747	b3746960-a03f-11f0-8737-b36df7580750	\N	\N	2025-10-03 10:03:56.121	Gotowe do realizacji	allegro-pl	101747100	Client:101747100	ocsom0y1jm+f5e57783@allegromail.pl	\N	Piotr Przybyła	+48 603 753 513	Ligonia 21	43-254	Krzyżowice	PL	ba56f527-a03f-11f0-b9a1-9fd75769370f	PAID	P24	t	1138.59	PLN	Allegro Kurier DPD	14.99	PLN	1138.59	PLN	\N	f	\N	2025-10-03 10:03:56.121	\N	2025-10-09 19:52:49.691873	ONLINE	f	[{"id": "RFBEOjEwMjY5MDczODM2NDJV", "waybill": "1026907383642U", "carrierId": "DPD", "createdAt": "2025-10-06T11:02:09.896Z", "lineItems": [{"id": "b369bb00-a03f-11f0-8737-b36df7580750"}]}, {"id": "RFBEOjEwMjY5MDczODM3NTlV", "waybill": "1026907383759U", "carrierId": "DPD", "createdAt": "2025-10-06T11:02:10.230Z", "lineItems": [{"id": "b369bb00-a03f-11f0-8737-b36df7580750"}]}, {"id": "RFBEOjEwMjY5MDczODM4OTlV", "waybill": "1026907383899U", "carrierId": "DPD", "createdAt": "2025-10-06T11:02:10.548Z", "lineItems": [{"id": "b369bb00-a03f-11f0-8737-b36df7580750"}]}]	\N	0.00	\N	[]	f
7749	c96f6d90-a031-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-03 08:22:17.496	Gotowe do realizacji	allegro-pl	20160914	mikouaj1	1i5hwzbmhh+4a1c3a682@allegromail.pl	\N	Mikołaj Kazaniecki	+48 731 340 700	Grunwaldzka 228	85-438	Bydgoszcz	PL	c9a8cd1d-a031-11f0-ae11-e76c74c7cf77	PAID	AF	t	1343.00	PLN	Allegro Kurier DPD	0.00	PLN	1343.00	PLN	\N	t	\N	2025-10-03 08:22:17.496	\N	2025-10-09 19:52:52.87265	ONLINE	f	[{"id": "RFBEOjEwMjY4NDQyMDU2OTJV", "waybill": "1026844205692U", "carrierId": "DPD", "createdAt": "2025-10-06T04:53:46.751Z", "lineItems": [{"id": "c967f380-a031-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjY4NDQyMDU3NzdV", "waybill": "1026844205777U", "carrierId": "DPD", "createdAt": "2025-10-06T04:53:46.899Z", "lineItems": [{"id": "c967f380-a031-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjY4NDQyMDU4ODlV", "waybill": "1026844205889U", "carrierId": "DPD", "createdAt": "2025-10-06T04:53:47.040Z", "lineItems": [{"id": "c967f380-a031-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7750	0b578860-a027-11f0-93a2-8fc85806f760	\N	\N	2025-10-03 07:06:43.796	Gotowe do realizacji	allegro-pl	109302475	Client:109302475	yeihtzmkr9+a66bcd39@allegromail.pl	\N	Angelika Pietryka	+48 530 402 281	Lubasz 144	33-230	Szczucin	PL	0b90250e-a027-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	Welur gładki WE1 - welur czarny 	f	\N	2025-10-03 07:06:43.796	\N	2025-10-09 19:52:54.443322	ONLINE	f	[{"id": "RFBEOjEwMjY3NTc0MDIzOTZV", "waybill": "1026757402396U", "carrierId": "DPD", "createdAt": "2025-10-03T11:08:49.658Z", "lineItems": [{"id": "0b50d1a0-a027-11f0-93a2-8fc85806f760"}]}]	\N	0.00	\N	[]	f
7751	6a50f510-a025-11f0-bc5e-258a5e1e619a	\N	\N	2025-10-03 06:55:16.511	Gotowe do realizacji	allegro-pl	33582428	lukimag2012	j6abbixb7k+65be0f8f2@allegromail.pl	\N	Magdalena Pirzecka	+48 697 255 151	Przedszkolna 39	55-002	Gajków	PL	6d47ee0b-a025-11f0-ae11-e76c74c7cf77	PAID	P24	t	578.99	PLN	Allegro Kurier DPD	14.99	PLN	578.99	PLN	\N	f	\N	2025-10-03 06:55:16.511	\N	2025-10-09 19:52:56.006326	ONLINE	t	[{"id": "RFBEOjEwMjY3NTgxMDI0NzdV", "waybill": "1026758102477U", "carrierId": "DPD", "createdAt": "2025-10-03T11:17:08.447Z", "lineItems": [{"id": "6a4a1740-a025-11f0-bc5e-258a5e1e619a"}]}, {"id": "RFBEOjEwMjY3NTgxMDI1MDBV", "waybill": "1026758102500U", "carrierId": "DPD", "createdAt": "2025-10-03T11:17:08.640Z", "lineItems": [{"id": "6a4a1740-a025-11f0-bc5e-258a5e1e619a"}]}]	Poprzeczna 7	0.00	\N	[]	f
7752	a9ba08f0-9fd4-11f0-9468-2bd22967b382	\N	\N	2025-10-02 21:14:24.59	Gotowe do realizacji	allegro-pl	69284867	Client:69284867	enx0syvsy1+530b352d2@allegromail.pl	\N	Anna Dirska	+48 696 843 447	Grabów Wójtostwo, 66	63-520	Grabów nad Prosną	PL	a9f69cfa-9fd4-11f0-96eb-67f4404dbe40	PAID	AF	t	611.00	PLN	Allegro Kurier DPD	0.00	PLN	611.00	PLN	\N	t	\N	2025-10-02 21:14:24.59	\N	2025-10-09 19:52:57.528802	ONLINE	f	[{"id": "RFBEOjEwMjY3NTgyNTg5MDZV", "waybill": "1026758258906U", "carrierId": "DPD", "createdAt": "2025-10-03T11:18:54.181Z", "lineItems": [{"id": "a9b37940-9fd4-11f0-9468-2bd22967b382"}]}, {"id": "RFBEOjEwMjY3NTgyNTkwNDdV", "waybill": "1026758259047U", "carrierId": "DPD", "createdAt": "2025-10-03T11:18:54.341Z", "lineItems": [{"id": "a9b37940-9fd4-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7756	a248daf0-9fc6-11f0-8c53-b9e6d89e658e	\N	\N	2025-10-02 19:35:33.148	Gotowe do realizacji	allegro-pl	5408323	mariak7	1im4k5gxls+6c5ac8342@allegromail.pl	\N	janusz wojdak	+48 63 279 58 15	28 czerwca 1956 r 346 / 37	61-437	Poznań	PL	c2fc70b1-9fc6-11f0-91d4-7961b40d7b05	PAID	AF	t	346.99	PLN	Allegro Kurier DPD	14.99	PLN	346.99	PLN	\N	f	\N	2025-10-02 19:35:33.148	\N	2025-10-09 19:53:02.566909	ONLINE	f	[{"id": "RFBEOjEwMjY4NTk2NjA1OTBV", "waybill": "1026859660590U", "carrierId": "DPD", "createdAt": "2025-10-06T06:38:36.387Z", "lineItems": [{"id": "a241d610-9fc6-11f0-8c53-b9e6d89e658e"}]}]	\N	0.00	\N	[]	f
7757	91d17a80-9fbf-11f0-8234-ff8a51029ee2	\N	\N	2025-10-02 18:49:57.283	Gotowe do realizacji	allegro-pl	19429620	bittersweet88	v50nej3aci+4b660d785@allegromail.pl	PRACOWNIA MOWY I ROZWOJU Sylwia Apola-Piórkowska	Sylwia Apola-Piórkowska	+48 500 470 786	Os. Gen. Maczka 8 / 25	37-100	Łańcut	PL	730e9ce8-9fc0-11f0-b9a1-9fd75769370f	PAID	P24	t	1887.00	PLN	Allegro Kurier DPD	0.00	PLN	1887.00	PLN	\N	t	\N	2025-10-02 18:49:57.283	\N	2025-10-09 19:53:04.368113	ONLINE	f	[{"id": "RFBEOjEwMjY3NTk1MTM4NDFV", "waybill": "1026759513841U", "carrierId": "DPD", "createdAt": "2025-10-03T11:33:59Z", "lineItems": [{"id": "91cc9880-9fbf-11f0-8234-ff8a51029ee2"}]}, {"id": "RFBEOjEwMjY3NTk1MTM5MjhV", "waybill": "1026759513928U", "carrierId": "DPD", "createdAt": "2025-10-03T11:33:59Z", "lineItems": [{"id": "91cc9880-9fbf-11f0-8234-ff8a51029ee2"}]}, {"id": "RFBEOjEwMjY3NTk1MTQwNTRV", "waybill": "1026759514054U", "carrierId": "DPD", "createdAt": "2025-10-03T11:33:59Z", "lineItems": [{"id": "91cc9880-9fbf-11f0-8234-ff8a51029ee2"}]}, {"id": "RFBEOjEwMjY3NTk1MTQxMzlV", "waybill": "1026759514139U", "carrierId": "DPD", "createdAt": "2025-10-03T11:33:59.063Z", "lineItems": [{"id": "91cc9880-9fbf-11f0-8234-ff8a51029ee2"}]}]	\N	0.00	\N	[]	f
7758	42529150-9fc0-11f0-8509-57e61af36c1f	\N	\N	2025-10-02 18:48:12.216	Gotowe do realizacji	allegro-pl	42778352	Client:42778352	paojwvy2q1+3a39f6cd7@allegromail.pl	\N	Marlena Madetko	+48 784 768 389	Cyganerii 1/11	43-100	Tychy	PL	4af591e2-9fc0-11f0-a417-fd831f6ae8ec	PAID	AF	t	462.00	PLN	Allegro Kurier DPD	0.00	PLN	462.00	PLN	\N	t	\N	2025-10-02 18:48:12.216	\N	2025-10-09 19:53:05.921164	ONLINE	f	[{"id": "RFBEOjEwMjY3NTk4MTU4NjhV", "waybill": "1026759815868U", "carrierId": "DPD", "createdAt": "2025-10-03T11:37:34.766Z", "lineItems": [{"id": "424b1740-9fc0-11f0-8509-57e61af36c1f"}]}]	\N	0.00	\N	[]	f
8372	ff70ad70-a67e-11f0-b410-a9ff53c96dc9	\N	\N	2025-10-11 08:50:00.429	Gotowe do realizacji	allegro-pl	44484954	Client:44484954	tx80hvv1cp+a4ea39e6@allegromail.pl	\N	Mirosława Szablewska	+48 530 874 092	Bydgoska 15/46	91-036	Łódź	PL	ff912dc6-a67e-11f0-baf9-a33944a1116d	PAID	AF	t	628.00	PLN	Allegro Kurier DPD	0.00	PLN	628.00	PLN	WE3	t	\N	2025-10-11 08:50:00.429	\N	2025-10-11 08:52:43.159432	ONLINE	f	[]	\N	0.00	\N	[]	f
7759	4c292230-9fb0-11f0-b42c-9325c9d7bd4d	\N	\N	2025-10-02 16:55:22.842	Gotowe do realizacji	allegro-pl	28833092	Client:28833092	mt0tvhk1n2+203983da7@allegromail.pl	\N	Aneta Lisewska	+48 781 240 436	Motorowa 2 / 23	20-214	Lublin	PL	4c48e016-9fb0-11f0-91d4-7961b40d7b05	PAID	P24	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	Dzień dobry, \nkolor siedziska TH1 (Hugo czarny)	t	\N	2025-10-02 16:55:22.842	\N	2025-10-09 19:53:07.494846	ONLINE	f	[{"id": "RFBEOjEwMjY3NjAwNjQwNDdV", "waybill": "1026760064047U", "carrierId": "DPD", "createdAt": "2025-10-03T11:40:44.277Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}, {"id": "RFBEOjEwMjY3NjAwNjQxMDJV", "waybill": "1026760064102U", "carrierId": "DPD", "createdAt": "2025-10-03T11:40:44.568Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}, {"id": "RFBEOjEwMjY3NjAwNjQyMTBV", "waybill": "1026760064210U", "carrierId": "DPD", "createdAt": "2025-10-03T11:40:44.848Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}, {"id": "RFBEOjAwMDAwMzk5NjM4MjBM", "waybill": "0000039963820L", "carrierId": "DPD", "createdAt": "2025-10-07T01:06:10Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}, {"id": "RFBEOjAwMDAwMzk5NjM4MTlM", "waybill": "0000039963819L", "carrierId": "DPD", "createdAt": "2025-10-07T01:06:10Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}, {"id": "RFBEOjAwMDAwMzk5NjM4MjFM", "waybill": "0000039963821L", "carrierId": "DPD", "createdAt": "2025-10-07T01:06:10Z", "lineItems": [{"id": "4c24dc70-9fb0-11f0-b42c-9325c9d7bd4d"}]}]	\N	0.00	\N	[]	f
7760	7862c470-9fae-11f0-8d27-959e7a05a75b	\N	\N	2025-10-02 16:41:42.725	Gotowe do realizacji	allegro-pl	27710761	Liptoniasty2	aqph54wcwg+134c4d741@allegromail.pl	\N	Łukasz Kozłowski	+48 515 540 144	Polanka 4A/7	65-557	Zielona Góra	PL	9054af0d-9fae-11f0-b9a1-9fd75769370f	PAID	P24	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	obicie TH3	t	\N	2025-10-02 16:41:42.725	\N	2025-10-09 19:53:08.982673	ONLINE	f	[{"id": "RFBEOjEwMjY3NjAyMTQwNzFV", "waybill": "1026760214071U", "carrierId": "DPD", "createdAt": "2025-10-03T11:42:53.912Z", "lineItems": [{"id": "785dbb60-9fae-11f0-8d27-959e7a05a75b"}]}, {"id": "RFBEOjEwMjY3NjAyMTQxNTBV", "waybill": "1026760214150U", "carrierId": "DPD", "createdAt": "2025-10-03T11:42:54.079Z", "lineItems": [{"id": "785dbb60-9fae-11f0-8d27-959e7a05a75b"}]}, {"id": "RFBEOjEwMjY3NjAyMTQyNzBV", "waybill": "1026760214270U", "carrierId": "DPD", "createdAt": "2025-10-03T11:42:54.229Z", "lineItems": [{"id": "785dbb60-9fae-11f0-8d27-959e7a05a75b"}]}]	\N	0.00	\N	[]	f
7761	c8cc0a70-9fa9-11f0-9a42-bb8e9ffafe52	\N	\N	2025-10-02 16:08:09.378	Gotowe do realizacji	allegro-pl	635300	Daurel	kqvtg3o370+b134a927@allegromail.pl	\N	Dariusz Brzeziński	+48 739 114 959	Wyszyńskiego 8/25	72-010	Police	PL	ec459dd2-9fa9-11f0-b9a1-9fd75769370f	PAID	AF	t	1015.00	PLN	Allegro Kurier DPD	0.00	PLN	1015.00	PLN	\N	t	\N	2025-10-02 16:08:09.378	\N	2025-10-09 19:53:10.465002	ONLINE	f	[{"id": "RFBEOjEwMjY3NjA0NDg2MDZV", "waybill": "1026760448606U", "carrierId": "DPD", "createdAt": "2025-10-03T11:45:54.012Z", "lineItems": [{"id": "c8c357e0-9fa9-11f0-9a42-bb8e9ffafe52"}]}, {"id": "RFBEOjEwMjY3NjA0NDg3NjdV", "waybill": "1026760448767U", "carrierId": "DPD", "createdAt": "2025-10-03T11:45:54.252Z", "lineItems": [{"id": "c8c357e0-9fa9-11f0-9a42-bb8e9ffafe52"}]}]	\N	0.00	\N	[]	f
7762	035de560-9fa9-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-02 16:03:59.187	Gotowe do realizacji	allegro-pl	3345412	Radeon17	khljf2z29f+6062af054@allegromail.pl	\N	Radkowiak Piotr	+48 733 706 707	Krężnicka 132	20-518	Lublin	PL	3d0c975d-9fa9-11f0-ae11-e76c74c7cf77	PAID	P24	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	proszę o zamieszczenie informacji dla kuriera z prośbą o kontakt przed dostawą 	t	\N	2025-10-02 16:03:59.187	\N	2025-10-09 19:53:11.994259	ONLINE	f	[{"id": "RFBEOjEwMjY3MjMxNjk5NzFV", "waybill": "1026723169971U", "carrierId": "DPD", "createdAt": "2025-10-03T04:56:40.248Z", "lineItems": [{"id": "0356e080-9fa9-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY3MjMxNzAwMTZV", "waybill": "1026723170016U", "carrierId": "DPD", "createdAt": "2025-10-03T04:56:40.384Z", "lineItems": [{"id": "0356e080-9fa9-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7763	e451b440-9fa7-11f0-8e98-fdfd51e10ba4	\N	\N	2025-10-02 15:54:31.739	Gotowe do realizacji	allegro-pl	28499563	Client:28499563	thufsgebxx+254e94209@allegromail.pl	\N	Sławomir Szymański	+48 512 270 599	Dworcowa 19	66-010	Nowogród Bobrzański	PL	e48bd752-9fa7-11f0-a417-fd831f6ae8ec	PAID	PAYU	t	340.99	PLN	Allegro Kurier DPD	14.99	PLN	340.99	PLN	\N	f	\N	2025-10-02 15:54:31.739	\N	2025-10-09 19:53:13.524776	ONLINE	f	[{"id": "RFBEOjEwMjY3MjY4NzY0MDFV", "waybill": "1026726876401U", "carrierId": "DPD", "createdAt": "2025-10-03T05:56:32Z", "lineItems": [{"id": "e44aaf60-9fa7-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7764	e194c910-9fa5-11f0-ad8a-5d9c081a41b2	\N	\N	2025-10-02 15:39:27.043	Gotowe do realizacji	allegro-pl	38104675	Client:38104675	xw92u2cusv+55d4ad069@allegromail.pl	\N	Lucyna Paszkiewicz	+48 726 005 987	Krzemień Pierwszy 90	23-304	Krzemień	PL	f4e0aa8c-9fa5-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	686.99	PLN	\N	t	\N	2025-10-02 15:39:27.043	\N	2025-10-09 19:53:15.032791	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3NjA2NTA1ODlV", "waybill": "1026760650589U", "carrierId": "DPD", "createdAt": "2025-10-03T11:48:21.799Z", "lineItems": [{"id": "e18d9d21-9fa5-11f0-ad8a-5d9c081a41b2"}]}, {"id": "RFBEOjEwMjY3NjA2NTA2ODFV", "waybill": "1026760650681U", "carrierId": "DPD", "createdAt": "2025-10-03T11:48:21.995Z", "lineItems": [{"id": "e18d9d21-9fa5-11f0-ad8a-5d9c081a41b2"}]}]	\N	0.00	\N	[]	f
7765	87ed6070-9fa0-11f0-89e4-21adac12f2a9	\N	\N	2025-10-02 15:02:38.412	Gotowe do realizacji	allegro-pl	5293089	Metalsiwy	4xojs4byyg+412915c51@allegromail.pl	SWIM TEAM TOMASZ SIEWIOR	Tomasz Siewior	+48 502 181 354	Willowa, 5	32-620	Brzeszcze	PL	96db3f6a-9fa0-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-10-02 15:02:38.412	\N	2025-10-09 19:53:16.741965	ONLINE	t	[{"id": "RFBEOjEwMjY3MjY5Mjg5NDFV", "waybill": "1026726928941U", "carrierId": "DPD", "createdAt": "2025-10-03T05:57:13.735Z", "lineItems": [{"id": "87e8a580-9fa0-11f0-89e4-21adac12f2a9"}]}]	Willowa, 5	0.00	\N	[]	f
7766	65161d90-9f9f-11f0-8234-ff8a51029ee2	\N	\N	2025-10-02 14:54:36.104	Gotowe do realizacji	allegro-pl	43066770	Moderato12	l6kf8t4c08+1de21ac67@allegromail.pl	\N	Janina Borejko	+48 792 659 021	ul. Rolna 2	49-340	Lewin Brzeski	PL	6a25e461-9f9f-11f0-b9a1-9fd75769370f	PAID	P24	t	478.00	PLN	Allegro Kurier DPD	0.00	PLN	478.00	PLN	\N	t	\N	2025-10-02 14:54:36.104	\N	2025-10-09 19:53:18.25358	ONLINE	t	[{"id": "RFBEOjEwMjY3MjMwOTQwNjZV", "waybill": "1026723094066U", "carrierId": "DPD", "createdAt": "2025-10-03T04:54:33Z", "lineItems": [{"id": "651189b0-9f9f-11f0-8234-ff8a51029ee2"}]}]	ul. Rolna 2	0.00	\N	[]	f
7767	ed2acaf0-9f9a-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-02 14:23:38.566	Gotowe do realizacji	allegro-pl	107500864	Client:107500864	qmyeuzwelc+3458e5b4@allegromail.pl	\N	Renata Woźniak	+48 796 277 800	Bohaterów Studzienek 3/20	26-670	Pionki	PL	363363a4-9f9b-11f0-b9a1-9fd75769370f	PAID	P24	t	787.99	PLN	Allegro Kurier DPD	14.99	PLN	787.99	PLN	\N	f	\N	2025-10-02 14:23:38.566	\N	2025-10-09 19:53:19.823755	ONLINE	f	[{"id": "RFBEOjEwMjY3NTc5ODk5OTJV", "waybill": "1026757989992U", "carrierId": "DPD", "createdAt": "2025-10-03T11:15:45.481Z", "lineItems": [{"id": "ed23c610-9f9a-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY3NTc5OTAwNjNV", "waybill": "1026757990063U", "carrierId": "DPD", "createdAt": "2025-10-03T11:15:45.738Z", "lineItems": [{"id": "ed23c610-9f9a-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7768	c0eec9a0-9f9a-11f0-8509-57e61af36c1f	\N	\N	2025-10-02 14:20:44.648	Gotowe do realizacji	allegro-pl	40005232	Client:40005232	qa9kmztunx+7456f90a6@allegromail.pl	\N	Ewelina Kowalska	+48 572 944 921	Wysocice 120	32-075	Gołcza	PL	c1306683-9f9a-11f0-a284-071dd65bf45d	PAID	P24	t	2012.98	PLN	Allegro Kurier DPD	29.98	PLN	2012.98	PLN	Kolor uchwytów: U1 czarny \nObicie siedziska:F04 Fjord Czarny	f	\N	2025-10-02 14:20:44.648	\N	2025-10-09 19:53:21.391471	ONLINE	f	[{"id": "RFBEOjEwMjY3NTcwNzM4NDhV", "waybill": "1026757073848U", "carrierId": "DPD", "createdAt": "2025-10-03T11:04:44.950Z", "lineItems": [{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f"}, {"id": "c0e5a1e0-9f9a-11f0-8509-57e61af36c1f"}]}, {"id": "RFBEOjEwMjY3NTcwNzM5OTNV", "waybill": "1026757073993U", "carrierId": "DPD", "createdAt": "2025-10-03T11:04:45.127Z", "lineItems": [{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f"}, {"id": "c0e5a1e0-9f9a-11f0-8509-57e61af36c1f"}]}, {"id": "RFBEOjEwMjY3NTcwNzQwMTFV", "waybill": "1026757074011U", "carrierId": "DPD", "createdAt": "2025-10-03T11:04:45.295Z", "lineItems": [{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f"}, {"id": "c0e5a1e0-9f9a-11f0-8509-57e61af36c1f"}]}, {"id": "RFBEOjEwMjY3NTcwNzQxNTBV", "waybill": "1026757074150U", "carrierId": "DPD", "createdAt": "2025-10-03T11:04:45.459Z", "lineItems": [{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f"}, {"id": "c0e5a1e0-9f9a-11f0-8509-57e61af36c1f"}]}, {"id": "RFBEOjEwMjY3NTcwNzQyNDJV", "waybill": "1026757074242U", "carrierId": "DPD", "createdAt": "2025-10-03T11:04:45.630Z", "lineItems": [{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f"}, {"id": "c0e5a1e0-9f9a-11f0-8509-57e61af36c1f"}]}]	\N	0.00	\N	[]	f
7771	2204e780-9f67-11f0-a6ba-19e7472c74e3	\N	\N	2025-10-02 08:11:23.232	Gotowe do realizacji	allegro-pl	5109587	arturkrotka	wskj9r4jus+5d06526@allegromail.pl	\N	Artur Gawin	+48 602 589 003	Elizy Orzeszkowej 1	77-141	Borzytuchom	PL	5604aca1-9f67-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-10-02 08:11:23.232	\N	2025-10-09 19:53:26.173347	ONLINE	f	[{"id": "RFBEOjEwMjY3NjEzMjQ1MzVV", "waybill": "1026761324535U", "carrierId": "DPD", "createdAt": "2025-10-03T11:56:33.474Z", "lineItems": [{"id": "2200c8d0-9f67-11f0-a6ba-19e7472c74e3"}]}, {"id": "RFBEOjEwMjY3NjEzMjQ2MTVV", "waybill": "1026761324615U", "carrierId": "DPD", "createdAt": "2025-10-03T11:56:33.636Z", "lineItems": [{"id": "2200c8d0-9f67-11f0-a6ba-19e7472c74e3"}]}]	\N	0.00	\N	[]	f
7772	b004e730-9f65-11f0-8234-ff8a51029ee2	\N	\N	2025-10-02 08:01:05.199	Gotowe do realizacji	allegro-pl	11552489	aisaK-a89	v5hok3hu4u+47b75c675@allegromail.pl	\N	Katarzyna Taudul	+48 531 655 643	ul. Kawaleryjska 70/50 m.4	15-601	Białystok	PL	b2a3fc54-9f65-11f0-b9a1-9fd75769370f	PAID	AF	t	1016.00	PLN	Allegro Kurier DPD	0.00	PLN	1016.00	PLN	\N	t	\N	2025-10-02 08:01:05.199	\N	2025-10-09 19:53:27.696527	ONLINE	f	[{"id": "RFBEOjEwMjY4NDEwMDMwMTRV", "waybill": "1026841003014U", "carrierId": "DPD", "createdAt": "2025-10-06T04:04:02.826Z", "lineItems": [{"id": "affef3c0-9f65-11f0-8234-ff8a51029ee2"}]}, {"id": "RFBEOjEwMjY4NDEwMDMxNzFV", "waybill": "1026841003171U", "carrierId": "DPD", "createdAt": "2025-10-06T04:04:02.973Z", "lineItems": [{"id": "affef3c0-9f65-11f0-8234-ff8a51029ee2"}]}]	\N	0.00	\N	[]	f
7773	2bf328a0-9f63-11f0-8509-57e61af36c1f	\N	\N	2025-10-02 07:41:45.493	Gotowe do realizacji	allegro-pl	3283491	shadow_ss	dk25cwns07+1262475f1@allegromail.pl	\N	Piotr Karolewski	+48 661 367 643	Srebrna 9/6	26-800	Białobrzegi	PL	2c2f47c5-9f63-11f0-96eb-67f4404dbe40	PAID	PAYU	t	523.00	PLN	Allegro Kurier DPD	0.00	PLN	523.00	PLN	THP1 - Tkanina Hugo Pik Grafitowy	t	\N	2025-10-02 07:41:45.493	\N	2025-10-09 19:53:29.220197	ONLINE	f	[{"id": "RFBEOjEwMjY4NDExMTY2ODFV", "waybill": "1026841116681U", "carrierId": "DPD", "createdAt": "2025-10-06T04:06:17.054Z", "lineItems": [{"id": "2beb8780-9f63-11f0-8509-57e61af36c1f"}]}]	\N	0.00	\N	[]	f
7774	8a61c600-9f57-11f0-8509-57e61af36c1f	\N	\N	2025-10-02 06:54:16.539	Gotowe do realizacji	allegro-pl	138276228	Client:138276228	iom6rn67ws+3696c7f8@allegromail.pl	\N	Violetta Jarosz	+48 730 800 004	Daszyńskiego 2 / 11	59-220	Legnica	PL	7725a9e9-9f5c-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	792.99	PLN	EP2 PIK Czarny	f	\N	2025-10-02 06:54:16.539	\N	2025-10-09 19:53:30.70906	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3NTc2MTk5NzFV", "waybill": "1026757619971U", "carrierId": "DPD", "createdAt": "2025-10-03T11:11:31.471Z", "lineItems": [{"id": "8a5ac120-9f57-11f0-8509-57e61af36c1f"}]}, {"id": "RFBEOjEwMjY3NTc2MjAwNDVV", "waybill": "1026757620045U", "carrierId": "DPD", "createdAt": "2025-10-03T11:11:31.684Z", "lineItems": [{"id": "8a5ac120-9f57-11f0-8509-57e61af36c1f"}]}]	\N	0.00	\N	[]	f
7782	506a6d11-9efa-11f0-a6cc-b3145592fdde	\N	\N	2025-10-01 19:14:35.051	Gotowe do realizacji	allegro-pl	50385363	Client:50385363	ufp90cv84u+676d54f17@allegromail.pl	\N	Szymon Grześkowiak	+48 697 597 277	Wiśniowa 67	62-300	Września	PL	50ab6e2a-9efa-11f0-96eb-67f4404dbe40	PAID	AF	t	689.00	PLN	Allegro Kurier DPD	0.00	PLN	689.00	PLN	Czarny welur 	t	\N	2025-10-01 19:14:35.051	\N	2025-10-09 19:56:40.880156	ONLINE	f	[{"id": "RFBEOjEwMjY2ODA2MTA2MDVV", "waybill": "1026680610605U", "carrierId": "DPD", "createdAt": "2025-10-02T10:23:54.200Z", "lineItems": [{"id": "5062f301-9efa-11f0-a6cc-b3145592fdde"}, {"id": "5062f300-9efa-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY2ODA2MTA3MjhV", "waybill": "1026680610728U", "carrierId": "DPD", "createdAt": "2025-10-02T10:23:54.379Z", "lineItems": [{"id": "5062f301-9efa-11f0-a6cc-b3145592fdde"}, {"id": "5062f300-9efa-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY2ODA3NDE2NDFV", "waybill": "1026680741641U", "carrierId": "DPD", "createdAt": "2025-10-02T10:24:55.871Z", "lineItems": [{"id": "5062f301-9efa-11f0-a6cc-b3145592fdde"}, {"id": "5062f300-9efa-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY2ODA3NDE3OTZV", "waybill": "1026680741796U", "carrierId": "DPD", "createdAt": "2025-10-02T10:24:56.086Z", "lineItems": [{"id": "5062f301-9efa-11f0-a6cc-b3145592fdde"}, {"id": "5062f300-9efa-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7784	a6a4ce00-9ef5-11f0-817a-fb3753e68c2d	\N	\N	2025-10-01 18:38:22.736	Gotowe do realizacji	allegro-pl	46790604	Client:46790604	htzlyqf5at+474ba4059@allegromail.pl	\N	Rita KNIEJA	+48 881 961 187	Lubieszów 68 / 2	67-100	Lubieszów	PL	a6e3373d-9ef5-11f0-ae11-e76c74c7cf77	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	kolor WE 3 WELUR GRAFITOWY 	t	\N	2025-10-01 18:38:22.736	\N	2025-10-09 19:56:43.629286	ONLINE	f	[{"id": "RFBEOjEwMjY2NDUwMjA4ODBV", "waybill": "1026645020880U", "carrierId": "DPD", "createdAt": "2025-10-02T05:41:51.531Z", "lineItems": [{"id": "a69df030-9ef5-11f0-817a-fb3753e68c2d"}]}]	\N	0.00	\N	[]	f
7786	9eabe350-9ef0-11f0-88a7-41bf7e4bf551	\N	\N	2025-10-01 18:04:12.547	Gotowe do realizacji	allegro-pl	65926053	Client:65926053	ob09t2bsie+5c88df214@allegromail.pl	\N	Grzegorz Górski	+48 663 840 949	Braci Gładyszów 15	32-830	Wojnicz	PL	9eed330c-9ef0-11f0-ae11-e76c74c7cf77	PAID	P24	t	773.00	PLN	Allegro Kurier DPD	0.00	PLN	773.00	PLN	siedzisko będzie w kolorze eko skóra pikowana czarna (EP2)	t	\N	2025-10-01 18:04:12.547	\N	2025-10-09 19:56:46.384312	ONLINE	f	[{"id": "RFBEOjEwMjY2ODg5MjkxMDRV", "waybill": "1026688929104U", "carrierId": "DPD", "createdAt": "2025-10-02T11:33:01.446Z", "lineItems": [{"id": "9ea46940-9ef0-11f0-88a7-41bf7e4bf551"}]}, {"id": "RFBEOjEwMjY2ODg5MjkyMTJV", "waybill": "1026688929212U", "carrierId": "DPD", "createdAt": "2025-10-02T11:33:01.657Z", "lineItems": [{"id": "9ea46940-9ef0-11f0-88a7-41bf7e4bf551"}]}]	\N	0.00	\N	[]	f
7788	302ccc60-9eef-11f0-9dc3-f9a3debc1314	\N	\N	2025-10-01 17:54:46.635	Gotowe do realizacji	allegro-pl	107302999	czarnula1209	v916ka0frn+3198b7d99@allegromail.pl	\N	Klaudia Piotrowska	+48 795 625 932	Gustawa Morcinka 9 / 33	41-303	Dąbrowa Górnicza	PL	a13431a4-9eef-11f0-ae11-e76c74c7cf77	PAID	P24	t	1136.00	PLN	Allegro Kurier DPD	0.00	PLN	1136.00	PLN	\N	t	\N	2025-10-01 17:54:46.635	\N	2025-10-09 19:56:49.168469	ONLINE	f	[{"id": "RFBEOjEwMjY2ODc2OTM4ODBV", "waybill": "1026687693880U", "carrierId": "DPD", "createdAt": "2025-10-02T11:23:07.708Z", "lineItems": [{"id": "30285f90-9eef-11f0-9dc3-f9a3debc1314"}]}, {"id": "RFBEOjEwMjY2ODc2OTM5NjFV", "waybill": "1026687693961U", "carrierId": "DPD", "createdAt": "2025-10-02T11:23:07.928Z", "lineItems": [{"id": "30285f90-9eef-11f0-9dc3-f9a3debc1314"}]}, {"id": "RFBEOjEwMjY2ODc2OTQwNzVV", "waybill": "1026687694075U", "carrierId": "DPD", "createdAt": "2025-10-02T11:23:08.139Z", "lineItems": [{"id": "30285f90-9eef-11f0-9dc3-f9a3debc1314"}]}]	\N	0.00	\N	[]	f
7790	d9e76130-9eee-11f0-b465-492415e4339b	\N	\N	2025-10-01 18:00:04.378	Gotowe do realizacji	allegro-pl	35269963	dzikaroza3	4jqbinao0j+28f8a2ae5@allegromail.pl	F.H.KWIACIARNIA 'DZIKA RÓŻA'	Izabela Stalka	+48 514 356 225	Ul.Woźnicka 200	42-350	Koziegłowy	PL	0cef8a0e-9ef0-11f0-baf9-a33944a1116d	PAID	AF	t	75.00	PLN	Allegro Kurier DPD	0.00	PLN	75.00	PLN	WE1 - Welur Czarny	t	\N	2025-10-01 18:00:04.378	\N	2025-10-09 19:56:51.957313	ONLINE	f	[{"id": "RFBEOjEwMjY3MjMzOTE0NDRV", "waybill": "1026723391444U", "carrierId": "DPD", "createdAt": "2025-10-03T05:01:31.763Z", "lineItems": [{"id": "d9e03540-9eee-11f0-b465-492415e4339b"}]}]	\N	0.00	\N	[]	f
7792	304bca40-9ee8-11f0-a30a-89acbba18695	\N	\N	2025-10-01 17:02:46.929	Gotowe do realizacji	allegro-pl	71921502	Client:71921502	n3fe5g711b+4a2157fd9@allegromail.pl	\N	Diana Kolomiichuk	+48 509 832 529	Dębicka 303 / F/1	35-213	Rzeszów	PL	307599dd-9ee8-11f0-91d4-7961b40d7b05	PAID	AF	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-01 17:02:46.929	\N	2025-10-09 19:56:54.685248	ONLINE	f	[{"id": "RFBEOjEwMjY3MjM3NzgwNTlV", "waybill": "1026723778059U", "carrierId": "DPD", "createdAt": "2025-10-03T05:09:06.868Z", "lineItems": [{"id": "3046e840-9ee8-11f0-a30a-89acbba18695"}]}, {"id": "RFBEOjEwMjY3MjM3NzgxMTRV", "waybill": "1026723778114U", "carrierId": "DPD", "createdAt": "2025-10-03T05:09:07.069Z", "lineItems": [{"id": "3046e840-9ee8-11f0-a30a-89acbba18695"}]}, {"id": "RFBEOjEwMjY3NDI0Njg0MTRV", "waybill": "1026742468414U", "carrierId": "DPD", "createdAt": "2025-10-03T08:34:29.341Z", "lineItems": [{"id": "3046e840-9ee8-11f0-a30a-89acbba18695"}]}]	\N	0.00	\N	[]	f
7793	1c67b9d0-9ee3-11f0-9dc3-f9a3debc1314	\N	\N	2025-10-01 16:25:13.526	Gotowe do realizacji	allegro-pl	6623235	wujekadam	bqey5g7z77+4b0623c62@allegromail.pl	\N	Adam Parus	+48 502 258 712	Ofiar Katynia 21 / 2	55-120	Oborniki Śląskie	PL	1c8b966b-9ee3-11f0-b9a1-9fd75769370f	PAID	P24	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	\N	t	\N	2025-10-01 16:25:13.526	\N	2025-10-09 19:56:56.000052	ONLINE	f	[{"id": "RFBEOjEwMjY2NDYxNDAyMTdV", "waybill": "1026646140217U", "carrierId": "DPD", "createdAt": "2025-10-02T05:53:13.338Z", "lineItems": [{"id": "1c637410-9ee3-11f0-9dc3-f9a3debc1314"}]}]	\N	0.00	\N	[]	f
7803	3099f270-9eb5-11f0-8bdf-5dc6c72e14d7	\N	\N	2025-10-01 10:59:25.107	Gotowe do realizacji	allegro-pl	116353712	Client:116353712	ozyn5gq59j+79d4f49d4@allegromail.pl	\N	Martyna Pasionek	+48 609 158 519	Witkow 46	59-225	Witków	PL	30dd3d3b-9eb5-11f0-96eb-67f4404dbe40	PAID	P24	t	704.00	PLN	Allegro Kurier DPD	0.00	PLN	704.00	PLN	\N	t	\N	2025-10-01 10:59:25.107	\N	2025-10-09 19:57:09.349826	ONLINE	f	[{"id": "RFBEOjEwMjY3MjI1MjkxODdV", "waybill": "1026722529187U", "carrierId": "DPD", "createdAt": "2025-10-03T04:39:16.091Z", "lineItems": [{"id": "30933bb0-9eb5-11f0-8bdf-5dc6c72e14d7"}]}, {"id": "RFBEOjEwMjY3MjI1MjkyMDdV", "waybill": "1026722529207U", "carrierId": "DPD", "createdAt": "2025-10-03T04:39:16.300Z", "lineItems": [{"id": "30933bb0-9eb5-11f0-8bdf-5dc6c72e14d7"}]}]	\N	0.00	\N	[]	f
7804	40166730-9eb3-11f0-908e-ff3baa2fe7b0	\N	\N	2025-10-01 10:44:31.351	Gotowe do realizacji	allegro-pl	103485438	Client:103485438	1do8y5rubi+32e3b9525@allegromail.pl	\N	Elżbieta Józiak	+48 600 023 695	Polnej Róży 1 / 1201	02-798	Warszawa	PL	405963b5-9eb3-11f0-ae11-e76c74c7cf77	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Tapicerka WE2	t	\N	2025-10-01 10:44:31.351	\N	2025-10-09 19:57:10.639494	ONLINE	f	[{"id": "RFBEOjEwMjY2NTY2MjkyMDdV", "waybill": "1026656629207U", "carrierId": "DPD", "createdAt": "2025-10-02T07:15:29.805Z", "lineItems": [{"id": "400f1430-9eb3-11f0-908e-ff3baa2fe7b0"}]}]	\N	0.00	\N	[]	f
7795	a8520470-9ed7-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-01 15:03:16.27	Gotowe do realizacji	allegro-pl	137085688	Client:137085688	ct3fpa5e6b+8159e667@allegromail.pl	\N	Aleksandra Piotrowska	+48 795 659 810	Skałka 54	26-065	Piekoszów	PL	b98e3feb-9ed7-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	756.99	PLN	\N	f	\N	2025-10-01 15:03:16.27	\N	2025-10-09 19:56:58.835539	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY2NzU1MDAzODhV", "waybill": "1026675500388U", "carrierId": "DPD", "createdAt": "2025-10-02T09:41:56.790Z", "lineItems": [{"id": "a84cd450-9ed7-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY2NzU1MDA0ODlV", "waybill": "1026675500489U", "carrierId": "DPD", "createdAt": "2025-10-02T09:41:56.956Z", "lineItems": [{"id": "a84cd450-9ed7-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
7796	38ccaba0-9ed7-11f0-a7f2-a59be15353c3	\N	\N	2025-10-01 15:00:04.549	Gotowe do realizacji	allegro-pl	119183446	Client:119183446	c2fb0535yk+45758d0a6@allegromail.pl	\N	Iwona Toczko	+48 667 864 617	Ogrodowa 8	21-200	Parczew	PL	390918f4-9ed7-11f0-ae11-e76c74c7cf77	PAID	P24	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-10-01 15:00:04.549	\N	2025-10-09 19:57:00.131947	ONLINE	f	[{"id": "RFBEOjEwMjY2NTA3Nzk0NThV", "waybill": "1026650779458U", "carrierId": "DPD", "createdAt": "2025-10-02T06:31:48.747Z", "lineItems": [{"id": "38c53190-9ed7-11f0-a7f2-a59be15353c3"}]}, {"id": "RFBEOjEwMjY2NTA3Nzk1NDNV", "waybill": "1026650779543U", "carrierId": "DPD", "createdAt": "2025-10-02T06:31:48.970Z", "lineItems": [{"id": "38c53190-9ed7-11f0-a7f2-a59be15353c3"}]}]	\N	0.00	\N	[]	f
7798	d60883b0-9eca-11f0-b1e3-b7ce882fc700	\N	\N	2025-10-01 13:31:32.411	Gotowe do realizacji	allegro-pl	5119788	m-a-x-	44jwdnwe0h+417221383@allegromail.pl	\N	Adam Turek	+48 507 306 509	Kęsy Pańki 4a	06-126	Gzy	PL	ee30e77f-9eca-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	475.99	PLN	\N	t	\N	2025-10-01 13:31:32.411	\N	2025-10-09 19:57:02.766441	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3MjM4NzYzMjhV", "waybill": "1026723876328U", "carrierId": "DPD", "createdAt": "2025-10-03T05:11:03Z", "lineItems": [{"id": "d603c8c0-9eca-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
7799	e55fb2a0-9ec7-11f0-a30a-89acbba18695	\N	\N	2025-10-01 13:12:02.448	Gotowe do realizacji	allegro-pl	5847359	aniagorkaa	m3oqntbmdu+1d8e3ac94@allegromail.pl	\N	Anna Górczyńska	+48 609 450 375	Uczniowska 1	81-647	Gdynia	PL	e581e136-9ec7-11f0-b9a1-9fd75769370f	PAID	AF	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	TH3 - Tkanina Hugo Grafitowy	t	\N	2025-10-01 13:12:02.448	\N	2025-10-09 19:57:04.087597	ONLINE	f	[{"id": "RFBEOjEwMjY3MjM5MTg0NDBV", "waybill": "1026723918440U", "carrierId": "DPD", "createdAt": "2025-10-03T05:11:54Z", "lineItems": [{"id": "e55ad0a0-9ec7-11f0-a30a-89acbba18695"}]}]	\N	0.00	\N	[]	f
8373	cac5a710-a679-11f0-84af-1520c30fa31d	\N	\N	2025-10-11 08:13:04.745	Gotowe do realizacji	allegro-pl	21247335	Rafaell00	t5y3341ept+6f22f2398@allegromail.pl	\N	Rafał Starzec	+48 665 765 571	Byczki 22	96-126	Godzianów	PL	d171e01a-a679-11f0-a417-fd831f6ae8ec	PAID	P24	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	Dzień dobry,\nProszę o obicie w kolorze WE1 (welur czarny).\n\nPozdrawiam \nMonika Starzec 	t	\N	2025-10-11 08:13:04.745	\N	2025-10-11 08:52:44.582275	ONLINE	f	[]	\N	0.00	\N	[]	f
7800	cf3fa2a0-9ec7-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-01 13:10:57.884	Gotowe do realizacji	allegro-pl	135752837	Client:135752837	oefimlg8do+3d1860066@allegromail.pl	\N	Olga Kłos-Drozdowicz	+48 664 585 684	Bukowskiego 7 / 71	03-982	Warszawa	PL	e99ce780-9ec7-11f0-96eb-67f4404dbe40	PAID	AF	t	340.99	PLN	Allegro Kurier DPD	14.99	PLN	340.99	PLN	Kolor tkaniny:  TH4	f	\N	2025-10-01 13:10:57.884	\N	2025-10-09 19:57:05.397666	ONLINE	f	[{"id": "RFBEOjEwMjY2NTA3Mjg3NjdV", "waybill": "1026650728767U", "carrierId": "DPD", "createdAt": "2025-10-02T06:31:21.744Z", "lineItems": [{"id": "cf384fa0-9ec7-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7801	4dc92860-9ec5-11f0-9e10-59ae2eaec9de	\N	\N	2025-10-01 12:51:19.449	Gotowe do realizacji	allegro-pl	125907554	Client:125907554	a9lhcbetoa+2738a9c01@allegromail.pl	\N	Anna Rak	+48 531 804 432	Wieniawskiego 55 / zd	35-330	Rzeszów	PL	4df5b714-9ec5-11f0-a284-071dd65bf45d	PAID	PAYU	t	1333.99	PLN	Allegro Kurier DPD	14.99	PLN	1333.99	PLN	\N	f	\N	2025-10-01 12:51:19.449	\N	2025-10-09 19:57:06.705213	ONLINE	f	[{"id": "RFBEOjEwMjY2NzU2NTg1NTFV", "waybill": "1026675658551U", "carrierId": "DPD", "createdAt": "2025-10-02T09:43:17.424Z", "lineItems": [{"id": "4dc1d560-9ec5-11f0-9e10-59ae2eaec9de"}]}, {"id": "RFBEOjEwMjY2NzU2NTg2NTlV", "waybill": "1026675658659U", "carrierId": "DPD", "createdAt": "2025-10-02T09:43:17.649Z", "lineItems": [{"id": "4dc1d560-9ec5-11f0-9e10-59ae2eaec9de"}]}, {"id": "RFBEOjEwMjY2NzU2NTg3MDZV", "waybill": "1026675658706U", "carrierId": "DPD", "createdAt": "2025-10-02T09:43:17.876Z", "lineItems": [{"id": "4dc1d560-9ec5-11f0-9e10-59ae2eaec9de"}]}]	\N	0.00	\N	[]	f
7802	ab770670-9ebc-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-01 11:49:53.186	Gotowe do realizacji	allegro-pl	24885194	bartuskziom4	43flp6aw6i+5979f67f9@allegromail.pl	\N	Justyna Grabowska	+48 513 999 029	Ogrodowa 9A	08-124	Niwiski	PL	ab8e38ad-9ebc-11f0-b9a1-9fd75769370f	PAID	AF	t	418.00	PLN	Allegro Kurier DPD	0.00	PLN	418.00	PLN	\N	t	\N	2025-10-01 11:49:53.186	\N	2025-10-09 19:57:08.02041	ONLINE	f	[{"id": "RFBEOjEwMjY3MjM5NTkyMDBV", "waybill": "1026723959200U", "carrierId": "DPD", "createdAt": "2025-10-03T05:12:44Z", "lineItems": [{"id": "ab724b80-9ebc-11f0-96ea-bf4f56b08af2"}]}]	\N	0.00	\N	[]	f
7972	7dd21a30-a5aa-11f0-86f8-1b20137f27b1	\N	\N	2025-10-10 07:30:10.715	Gotowe do realizacji	allegro-pl	37795708	marzena10182	zmy0qpbneg+5c36803b7@allegromail.pl	\N	Marzena Kuśnierczyk	+48 730 348 541	Blizne 11A	36-221	Blizne	PL	7e0908d7-a5aa-11f0-96eb-67f4404dbe40	PAID	AF	t	1557.00	PLN	Allegro Kurier DPD	0.00	PLN	1557.00	PLN	kolor Eco skóra gładka czarna ES1\nwieszaki czarne H1	t	\N	2025-10-10 07:30:10.715	\N	2025-10-10 08:02:27.085638	ONLINE	f	[]	\N	0.00	\N	[]	f
8261	b68be680-a5b9-11f0-b947-e52733e9ad15	\N	\N	2025-10-10 09:17:17.658	Gotowe do realizacji	allegro-pl	2206588	ElManiako	bjns6933cd+55daf9010@allegromail.pl	\N	Marcin Mańka	+48 513 736 553	Kard. S. Wyszyńskiego 36	42-700	Lubliniec	\N	b6c4aa79-a5b9-11f0-baf9-a33944a1116d	PAID	AF	t	350.00	\N	Allegro Kurier DPD	0.00	PLN	350.00	PLN	Witam\ntkanina: THP1 -> Hugo Pik Grafitowy\nDziękuję i pozdrawiam	t	\N	2025-10-10 09:18:10.334	\N	2025-10-10 10:15:33.711674	ONLINE	f	[]	\N	0.00	\N	[]	f
8304	42b1ea80-a5c2-11f0-805b-5b33cfcb1907	\N	\N	2025-10-10 10:19:14.126	Gotowe do realizacji	allegro-pl	94374362	Client:94374362	7yasrn21o3+12104f649@allegromail.pl	\N	Magdalena Pianka	+48 518 989 581	Dębniki 65	18-416	Zbójna	PL	7ddd0375-a5c2-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	624.99	PLN	\N	f	\N	2025-10-10 10:19:14.126	\N	2025-10-10 11:12:02.521501	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
8308	cf84c5c0-a5c9-11f0-861f-cb3d7d4327c9	\N	\N	2025-10-10 11:12:50.891	Gotowe do realizacji	allegro-pl	50255703	Client:50255703	70oivwdfu6+1533a11b6@allegromail.pl	\N	Ewelina Brzuszek	+48 790 707 160	Budziwojska 288A	35-317	Rzeszów	PL	e257f4f7-a5c9-11f0-a284-071dd65bf45d	PAID	PAYU	t	1023.00	PLN	Allegro Kurier DPD	0.00	PLN	1023.00	PLN	\N	t	\N	2025-10-10 11:12:50.891	\N	2025-10-10 11:13:45.38649	ONLINE	t	[]	Budziwojska 288A	0.00	\N	[]	f
7807	81c7cfb0-9eaa-11f0-bc92-992b6815467a	\N	\N	2025-10-01 09:40:52.449	Gotowe do realizacji	allegro-pl	21295001	minoka9	74n823nhr7+5ab5a4991@allegromail.pl	\N	Monika Kucharczak	+48 608 832 227	Grzybów 29D	39-308	Grzybów	PL	81eb5d69-9eaa-11f0-baf9-a33944a1116d	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Tkanina TH3 	t	\N	2025-10-01 09:40:52.449	\N	2025-10-09 19:57:14.883124	ONLINE	f	[{"id": "RFBEOjEwMjY2NjA0MjcyNzBV", "waybill": "1026660427270U", "carrierId": "DPD", "createdAt": "2025-10-02T07:43:41.936Z", "lineItems": [{"id": "81c1b530-9eaa-11f0-bc92-992b6815467a"}]}]	\N	0.00	\N	[]	f
7808	5f2c19c0-9eaa-11f0-817a-fb3753e68c2d	\N	\N	2025-10-01 09:41:13.891	Anulowane	allegro-pl	50174885	Client:50174885	ppr8di1rde+7626b35f0@allegromail.pl	\N	Natalia Longier	+48 530 400 390	\N	\N	\N	\N	5f69e702-9eaa-11f0-96eb-67f4404dbe40	UNPAID	PAYU	t	\N	\N	Allegro Kurier DPD	0.00	PLN	793.10	PLN	\N	t	\N	\N	\N	2025-10-09 19:57:16.230465	ONLINE	f	[]	\N	0.00	\N	[]	f
7809	f1a501f0-9ea9-11f0-908e-ff3baa2fe7b0	\N	\N	2025-10-01 09:50:32.092	Anulowane	allegro-pl	38470041	Client:38470041	tfvthfpx0x+2680e20e6@allegromail.pl	\N	Iza Jóźwiak	+48 506 153 501	Chodzieska 23	60-418	Poznań	PL	f910bb0f-9ea9-11f0-a284-071dd65bf45d	PAID	AF	t	505.50	PLN	Kurier DPD	17.00	PLN	505.50	PLN	wzór F04 kolor czarny 	f	\N	2025-10-01 09:36:23.48	\N	2025-10-09 19:57:17.494417	ONLINE	f	[]	\N	505.50	2025-10-01 09:52:11.178	[{"id": "4ce69a52-9eac-11f0-a0c8-1dbe9f7e626d", "order": {"id": "f1a501f0-9ea9-11f0-908e-ff3baa2fe7b0"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "f910bb0f-9ea9-11f0-a284-071dd65bf45d"}, "delivery": {"value": {"amount": "17.00", "currency": "PLN"}}, "deposits": [], "createdAt": "2025-10-01T09:52:11.178Z", "lineItems": [{"id": "f19d39c0-9ea9-11f0-908e-ff3baa2fe7b0", "type": "AMOUNT", "value": {"amount": "488.50", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "505.50", "currency": "PLN"}}]	f
7810	779405a0-9ea4-11f0-8996-07b46275101a	\N	\N	2025-10-01 08:58:09.974	Gotowe do realizacji	allegro-pl	11980132	Ewa2197	jemlxwo0zg+5105ff5f9@allegromail.pl	\N	Ewa Osipa	+48 792 592 983	Słoneczna 7	55-093	Brzezia Łaka	PL	7ff14a39-9ea4-11f0-b9a1-9fd75769370f	PAID	AF	t	780.00	PLN	Allegro Kurier DPD	0.00	PLN	780.00	PLN	ES1 - Eko skóra Czarny	t	\N	2025-10-01 08:58:09.974	\N	2025-10-09 19:57:18.846639	ONLINE	f	[{"id": "RFBEOjEwMjY2NjA1Mzg2NzBV", "waybill": "1026660538670U", "carrierId": "DPD", "createdAt": "2025-10-02T07:44:34.631Z", "lineItems": [{"id": "778e3940-9ea4-11f0-8996-07b46275101a"}]}, {"id": "RFBEOjEwMjY2NjA1Mzg3ODNV", "waybill": "1026660538783U", "carrierId": "DPD", "createdAt": "2025-10-02T07:44:34.830Z", "lineItems": [{"id": "778e3940-9ea4-11f0-8996-07b46275101a"}]}]	\N	0.00	\N	[]	f
7811	2a06f6d0-9ea4-11f0-9dc3-f9a3debc1314	\N	\N	2025-10-01 08:54:55.157	Gotowe do realizacji	allegro-pl	41247325	mirabelka97	3e6vypb5e1+6635ac709@allegromail.pl	PAULA DECO Paulina Brajerek	Paulina Brajerek	+48 663 036 390	Lipowa 4a	67-321	Leszno Górne	PL	2a294c5e-9ea4-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	793.10	PLN	Allegro Kurier DPD	0.00	PLN	793.10	PLN	Poproszę o siedzisko z eko skóry w odcieniu brązu. 	t	\N	2025-10-01 08:54:55.157	\N	2025-10-09 19:57:20.184865	ONLINE	f	[{"id": "RFBEOjEwMjY3MjQyODM5ODlV", "waybill": "1026724283989U", "carrierId": "DPD", "createdAt": "2025-10-03T05:18:09.096Z", "lineItems": [{"id": "29fbd340-9ea4-11f0-9dc3-f9a3debc1314"}]}, {"id": "RFBEOjEwMjY3MjQyODQwODdV", "waybill": "1026724284087U", "carrierId": "DPD", "createdAt": "2025-10-03T05:18:09.248Z", "lineItems": [{"id": "29fbd340-9ea4-11f0-9dc3-f9a3debc1314"}]}]	\N	0.00	\N	[]	f
8374	c3e39250-a66e-11f0-86f8-1b20137f27b1	\N	\N	2025-10-11 06:53:47.331	Gotowe do realizacji	allegro-pl	25031073	adamw2106	n34fa4xzjq+53af78814@allegromail.pl	\N	Adam Wołodźko	+48 608 015 702	Knopin 1	11-040	Knopin	PL	c41a8183-a66e-11f0-a417-fd831f6ae8ec	PAID	AF	t	510.00	PLN	Allegro Kurier DPD	0.00	PLN	510.00	PLN	\N	t	\N	2025-10-11 06:53:47.331	\N	2025-10-11 08:52:45.808528	ONLINE	f	[]	\N	0.00	\N	[]	f
7812	52261250-9ea3-11f0-bc92-992b6815467a	\N	\N	2025-10-01 08:50:53.473	Gotowe do realizacji	allegro-pl	2991758	berdonka	a7bu6e6pap+287927141@allegromail.pl	\N	Henryk Tomecki	+48 795 616 058	Centaura 27 / 26	44-117	Gliwice	PL	559fd001-9ea3-11f0-baf9-a33944a1116d	PAID	AF	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	szafka kolor biały ,siedzisko WE3 - Welur Grafitowy	t	\N	2025-10-01 08:50:53.473	\N	2025-10-09 19:57:21.523599	ONLINE	t	[{"id": "RFBEOjEwMjY2NTY0MDY0NzRV", "waybill": "1026656406474U", "carrierId": "DPD", "createdAt": "2025-10-02T07:13:54.758Z", "lineItems": [{"id": "52209410-9ea3-11f0-bc92-992b6815467a"}]}]	Centaura 27 / 26	0.00	\N	[]	f
7814	f6358130-9e96-11f0-817a-fb3753e68c2d	\N	\N	2025-10-01 09:27:11.642	Anulowane	allegro-pl	38470041	Client:38470041	tfvthfpx0x+646751359@allegromail.pl	\N	Iza Jóźwiak	+48 506 153 501	Chodzieska 23	60-418	Poznań	PL	25bd04bc-9e97-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	505.50	PLN	Kurier DPD	17.00	PLN	505.50	PLN	wzór F04 kolor czarny	f	\N	2025-10-01 07:21:48.029	\N	2025-10-09 19:57:24.177602	ONLINE	f	[]	\N	505.50	2025-10-01 09:27:44.262	[{"id": "e29b7ae6-9ea8-11f0-bb0d-430e2488e63a", "order": {"id": "f6358130-9e96-11f0-817a-fb3753e68c2d"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "25bd04bc-9e97-11f0-bdd7-1b3dfdcd18cd"}, "delivery": {"value": {"amount": "17.00", "currency": "PLN"}}, "deposits": [], "createdAt": "2025-10-01T09:27:44.262Z", "lineItems": [{"id": "f62ea360-9e96-11f0-817a-fb3753e68c2d", "type": "AMOUNT", "value": {"amount": "488.50", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "505.50", "currency": "PLN"}}]	f
7815	62229f70-9e94-11f0-8fc5-3736e68905c7	\N	\N	2025-10-01 07:03:22.378	Gotowe do realizacji	allegro-pl	11938293	dorota22235	fl82g2koxq+6dd1f7062@allegromail.pl	\N	Dorota BOGDAŃSKA	+48 515 163 243	Kolejowa 2a / 11	22-100	Chełm	PL	9f0e7ac5-9e94-11f0-baf9-a33944a1116d	PAID	AF	t	405.20	PLN	Allegro Kurier DPD	0.00	PLN	405.20	PLN	\N	t	\N	2025-10-01 07:03:22.378	\N	2025-10-09 19:57:25.539499	ONLINE	t	[]	PIASTOWSKA 7	0.00	\N	[]	f
7933	83e31360-a5a1-11f0-acf3-212576f15d8a	\N	\N	2025-10-10 06:23:08.528	Gotowe do realizacji	allegro-pl	34216233	aburchacka87	fmqdjr2hhw+69ceb67d9@allegromail.pl	\N	Anna Burchacka	+48 530 775 645	Ulica Grabowa 33/4	59-300	Lubin	PL	841e9601-a5a1-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	327.19	PLN	Allegro Kurier DPD	14.99	PLN	327.19	PLN	Welur JASNO SZARY 	f	\N	2025-10-10 06:23:08.528	\N	2025-10-10 08:02:31.395937	ONLINE	f	[]	\N	0.00	\N	[]	f
7921	c3a14f50-a554-11f0-a588-b391296a673a	\N	\N	2025-10-09 21:13:56.12	Gotowe do realizacji	allegro-pl	21718150	annan_87	24a5p6izjr+2b4b90037@allegromail.pl	\N	anna nowak	+48 785 609 943	ul. Główna 5 m.8	41-500	Chorzów	PL	c3bdd839-a554-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	550.00	PLN	Allegro Kurier DPD	0.00	PLN	550.00	PLN	\N	t	\N	2025-10-09 21:13:56.12	\N	2025-10-10 06:52:47.535333	ONLINE	f	[]	\N	0.00	\N	[]	f
7999	ac66e320-a5ab-11f0-b9bf-2795de008363	\N	\N	2025-10-10 07:38:52.989	Gotowe do realizacji	allegro-pl	50158165	Client:50158165	o7fo73a7rh+72ad63851@allegromail.pl	\N	Paulina Sozańska	+48 690 902 176	KRASZEWSKIEGO 35	87-800	WŁOCŁAWEK	\N	2390425e-a5ac-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	405.20	\N	Allegro Kurier DPD	0.00	PLN	405.20	PLN	\N	t	\N	2025-10-10 07:40:15.704	\N	2025-10-10 08:02:25.693513	ONLINE	f	[]	\N	0.00	\N	[]	f
8099	4d2dd130-997f-11f0-9d91-310fed739d04	\N	\N	2025-09-24 19:48:54.683	Gotowe do realizacji	allegro-pl	675979	Sebastian_ok	ax8d2mc0af+286eab257@allegromail.pl	\N	Sebastian Okseniuk	+48 500 119 772	Siedlecka 47/2	85-412	Bydgoszcz	PL	51d5fd52-997f-11f0-936b-33fea42d2f10	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Kolor: WE1 - Welur Czarny	t	\N	2025-09-24 19:48:54.683	\N	2025-10-10 09:05:53.211564	ONLINE	f	[{"id": "RFBEOjEwMjYxOTI1ODYzNDRV", "waybill": "1026192586344U", "carrierId": "DPD", "createdAt": "2025-09-25T05:03:52.076Z", "lineItems": [{"id": "4d260900-997f-11f0-9d91-310fed739d04"}]}]	\N	0.00	\N	[]	f
8305	8a77e1c0-a5c8-11f0-8895-094b8cada9e7	\N	\N	2025-10-10 11:11:40.757	Gotowe do realizacji	allegro-pl	94374362	Client:94374362	7yasrn21o3+113793f94@allegromail.pl	\N	Magdalena Pianka	+48 518 989 581	Dębniki 65	18-416	Zbójna	PL	d37f736a-a5c9-11f0-ae11-e76c74c7cf77	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	333.99	PLN	\N	f	\N	2025-10-10 11:11:40.757	\N	2025-10-10 11:13:47.267817	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
7775	1b962310-9f11-11f0-9d66-3d00eb1ccfed	\N	\N	2025-10-01 21:54:53.625	Gotowe do realizacji	allegro-pl	126192032	Client:126192032	55id3acc24+52d7a8657@allegromail.pl	\N	Paweł Czerwiński	+48 577 479 555	Żołnierzy 2 AWP 25 / 13	59-220	Legnica	PL	36fa2943-9f11-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-10-01 21:54:53.625	\N	2025-10-09 19:56:30.606999	ONLINE	f	[{"id": "RFBEOjEwMjY3MjIyNjQwOTBV", "waybill": "1026722264090U", "carrierId": "DPD", "createdAt": "2025-10-03T04:31:31Z", "lineItems": [{"id": "1b8f9360-9f11-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
7776	e8756a60-9f04-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-10-01 20:30:29.635	Gotowe do realizacji	allegro-pl	43150009	43150009	a4k717aij4+94f33475@allegromail.pl	\N	Swietłana Łarkowa	+48 666 942 227	Krasińskiego 11	46-220	Byczyna	PL	e897e6d1-9f04-11f0-b9a1-9fd75769370f	PAID	AF	t	1343.00	PLN	Allegro Kurier DPD	0.00	PLN	1343.00	PLN	\N	t	\N	2025-10-01 20:30:29.635	\N	2025-10-09 19:56:32.292077	ONLINE	f	[{"id": "RFBEOjEwMjY3MjIzMjM4ODlV", "waybill": "1026722323889U", "carrierId": "DPD", "createdAt": "2025-10-03T04:32:59Z", "lineItems": [{"id": "e870d680-9f04-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY3MjIzMjM5NDRV", "waybill": "1026722323944U", "carrierId": "DPD", "createdAt": "2025-10-03T04:32:59Z", "lineItems": [{"id": "e870d680-9f04-11f0-bfbd-d3aacc6a2e00"}]}, {"id": "RFBEOjEwMjY3MjIzMjQwNzhV", "waybill": "1026722324078U", "carrierId": "DPD", "createdAt": "2025-10-03T04:32:59Z", "lineItems": [{"id": "e870d680-9f04-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
7777	a1e0a350-9f02-11f0-b871-03a75625f948	\N	\N	2025-10-01 20:12:01.111	Gotowe do realizacji	allegro-pl	46536149	Client:46536149	3jqlqk6rlk+713ffc0a4@allegromail.pl	\N	Wiktor Graczyk	+48 791 487 497	Podgórna 60 / 13	87-100	Toruń	PL	ab3dcc22-9f02-11f0-baf9-a33944a1116d	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	TH1	t	\N	2025-10-01 20:12:01.111	\N	2025-10-09 19:56:33.686565	ONLINE	f	[{"id": "RFBEOjEwMjY2NDQ4ODMzNjZV", "waybill": "1026644883366U", "carrierId": "DPD", "createdAt": "2025-10-02T05:40:31.619Z", "lineItems": [{"id": "a1dbe860-9f02-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7778	c68f7410-9efd-11f0-88a7-41bf7e4bf551	\N	\N	2025-10-01 19:36:57.145	Gotowe do realizacji	allegro-pl	39909528	Client:39909528	4jdjvvy3oi+4201a8ae8@allegromail.pl	\N	Katarzyna Rolak	+48 730 261 216	Sikorskiego 4/13	05-480	Karczew	PL	ec438db1-9efd-11f0-a284-071dd65bf45d	PAID	PAYU	t	802.99	PLN	Allegro Kurier DPD	14.99	PLN	802.99	PLN	\N	f	\N	2025-10-01 19:36:57.145	\N	2025-10-09 19:56:35.082567	ONLINE	f	[{"id": "RFBEOjEwMjY2ODY3OTAyNTJV", "waybill": "1026686790252U", "carrierId": "DPD", "createdAt": "2025-10-02T11:15:48.596Z", "lineItems": [{"id": "c686e890-9efd-11f0-88a7-41bf7e4bf551"}]}, {"id": "RFBEOjEwMjY2ODY3OTAzNDVV", "waybill": "1026686790345U", "carrierId": "DPD", "createdAt": "2025-10-02T11:15:48.807Z", "lineItems": [{"id": "c686e890-9efd-11f0-88a7-41bf7e4bf551"}]}, {"id": "RFBEOjEwMjcxNjMzNjIwMjdV", "waybill": "1027163362027U", "carrierId": "DPD", "createdAt": "2025-10-09T09:35:31.499Z", "lineItems": [{"id": "c686e890-9efd-11f0-88a7-41bf7e4bf551"}]}]	\N	0.00	\N	[]	f
8046	9f604910-9b28-11f0-b1e3-b7ce882fc700	\N	\N	2025-09-26 22:33:28.828	Gotowe do realizacji	allegro-pl	35071405	krystynasurowiec	w2fqomjh65+6e680f4b6@allegromail.pl	\N	Krystyna Gruca	+48 662 323 834	Dworska 55	43-426	Kostkowice	PL	9f919313-9b28-11f0-89e8-3f9d4e258057	PAID	P24	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-09-26 22:33:28.828	\N	2025-10-10 09:04:52.078521	ONLINE	f	[{"id": "RFBEOjEwMjY0NzYyNTY2MjVV", "waybill": "1026476256625U", "carrierId": "DPD", "createdAt": "2025-09-30T05:15:21.412Z", "lineItems": [{"id": "9f5b8e20-9b28-11f0-b1e3-b7ce882fc700"}]}]	\N	0.00	\N	[]	f
7780	53444b90-9efb-11f0-9e10-59ae2eaec9de	\N	\N	2025-10-01 19:21:54.968	Gotowe do realizacji	allegro-pl	22091132	andygut	vs638z6rka+22f0a1336@allegromail.pl	\N	Adrian Chyła	+48 691 323 822	os. 700 - lecia 4C/14	86-170	NOWE	PL	56935044-9efb-11f0-a417-fd831f6ae8ec	PAID	P24	t	1319.00	PLN	Allegro Kurier DPD	0.00	PLN	1319.00	PLN	Uchwyty H1\nTkanina F04 Fjord Czarny 	t	\N	2025-10-01 19:21:54.968	\N	2025-10-09 19:56:37.890424	ONLINE	f	[{"id": "RFBEOjEwMjY2NDY0NDI2NjlV", "waybill": "1026646442669U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:00.934Z", "lineItems": [{"id": "533d46b0-9efb-11f0-9e10-59ae2eaec9de"}]}, {"id": "RFBEOjEwMjY2NDY0NDI3NDhV", "waybill": "1026646442748U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:01.058Z", "lineItems": [{"id": "533d46b0-9efb-11f0-9e10-59ae2eaec9de"}]}, {"id": "RFBEOjEwMjY2NDY0NDI4ODhV", "waybill": "1026646442888U", "carrierId": "DPD", "createdAt": "2025-10-02T05:56:03Z", "lineItems": [{"id": "533d46b0-9efb-11f0-9e10-59ae2eaec9de"}]}]	\N	0.00	\N	[]	f
7787	ebf4b2a0-9eef-11f0-9efe-27a29450b6fd	\N	\N	2025-10-01 17:58:05.395	Gotowe do realizacji	allegro-pl	11064817	red_witch1	orc2xt5c0e+1dad73032@allegromail.pl	\N	Karolina Sośnicka	+48 577 881 286	Pocztowa5/1	37-700	Przemyśl	PL	ec1dbe73-9eef-11f0-b9a1-9fd75769370f	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	proszę o wykonanie siedziska z tkaniny Hugo w czarnym kolorze	t	\N	2025-10-01 17:58:05.395	\N	2025-10-09 19:56:47.728981	ONLINE	f	[{"id": "RFBEOjEwMjY2NDYwNDI3NTNV", "waybill": "1026646042753U", "carrierId": "DPD", "createdAt": "2025-10-02T05:52:17.604Z", "lineItems": [{"id": "ebefa990-9eef-11f0-9efe-27a29450b6fd"}]}, {"id": "RFBEOjAwMDAwMzk5MDE5MzJM", "waybill": "0000039901932L", "carrierId": "DPD", "createdAt": "2025-10-04T06:45:47Z", "lineItems": [{"id": "ebefa990-9eef-11f0-9efe-27a29450b6fd"}]}]	\N	0.00	\N	[]	f
7791	1fad91d0-9eea-11f0-96ea-bf4f56b08af2	\N	\N	2025-10-01 17:20:16.663	Gotowe do realizacji	allegro-pl	101170108	Client:101170108	46sx39nne1+25c3ed829@allegromail.pl	\N	Anita Będziechowska	+48 603 624 265	Głogowska 154A / 18	60-205	Poznań	PL	cbec6bfe-9eea-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	382.20	PLN	Allegro Kurier DPD	0.00	PLN	382.20	PLN	THP1 - Tkanina Hugo Pik Grafitowy	t	\N	2025-10-01 17:20:16.663	\N	2025-10-09 19:56:53.308922	ONLINE	f	[{"id": "RFBEOjEwMjY2NzM2MjY5NzRV", "waybill": "1026673626974U", "carrierId": "DPD", "createdAt": "2025-10-02T09:26:34.835Z", "lineItems": [{"id": "1fa29550-9eea-11f0-96ea-bf4f56b08af2"}]}]	\N	80.00	2025-10-08 18:05:01.942	[{"id": "4f5845da-a471-11f0-9a6c-fd39df90ab15", "order": {"id": "1fad91d0-9eea-11f0-96ea-bf4f56b08af2"}, "reason": "COMPLAINT", "status": "SUCCESS", "payment": {"id": "cbec6bfe-9eea-11f0-bdd7-1b3dfdcd18cd"}, "deposits": [], "createdAt": "2025-10-08T18:05:01.942Z", "lineItems": [{"id": "1fa29550-9eea-11f0-96ea-bf4f56b08af2", "type": "AMOUNT", "value": {"amount": "80.00", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "80.00", "currency": "PLN"}, "sellerComment": "zwrot z tytułu uszkodzenia w transporcie "}]	f
7934	8dd7d240-a59f-11f0-8399-c1bb86b8e44b	\N	\N	2025-10-10 06:11:02.82	Gotowe do realizacji	allegro-pl	116192668	Client:116192668	xrcsjsxj45+33e81da70@allegromail.pl	\N	Juliana Zalewska 	+48 692 055 720	Ziemowita 27/ 14	92-413	Łódź	PL	8df71a1b-a59f-11f0-baf9-a33944a1116d	PAID	PAYU	t	773.00	PLN	Allegro Kurier DPD	0.00	PLN	773.00	PLN	DO KURIERA: domofon nie działa, proszę dzwonić lub pisać SMS (692-055-720)	t	\N	2025-10-10 06:11:02.82	\N	2025-10-10 08:02:32.946685	ONLINE	f	[]	\N	0.00	\N	[]	f
8024	4eb511a0-a5ad-11f0-a2ef-21d979b3b861	\N	\N	2025-10-10 07:48:32.448	Gotowe do realizacji	allegro-pl	25817129	biedronkaaa8	1k7eu1e4xz+4088702f0@allegromail.pl	\N	Ewelina Roszkowska	+48 517 567 194	Waszyngtońska 4	15-523	Grabówka	PL	4ed85171-a5ad-11f0-91d4-7961b40d7b05	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	kolor i materiał F03 	t	\N	2025-10-10 07:48:32.448	\N	2025-10-10 08:02:22.700453	ONLINE	f	[]	\N	0.00	\N	[]	f
7794	7421cf30-9ed9-11f0-b465-492415e4339b	\N	\N	2025-10-01 15:18:54.4	Gotowe do realizacji	allegro-pl	48879549	Client:48879549	5r09on9gvb+92205fa6@allegromail.pl	\N	Lucas Farris	+48 534 663 276	Ulica Podwale 74/19	50-449	Wroclaw	PL	745f74d5-9ed9-11f0-96eb-67f4404dbe40	PAID	AF	t	2259.98	PLN	Allegro Kurier DPD	29.98	PLN	2259.98	PLN	Chcielibyśmy, aby drzwi szafki SUPRA otwierały się na prawą stronę (odwrotnie niż na rysunku).\nKolory haków: H1 - Czarny\nKolor panel: ES1 - Eko skóra Czarny	f	\N	2025-10-01 15:18:54.4	\N	2025-10-09 19:56:57.338125	ONLINE	f	[{"id": "RFBEOjEwMjY2ODIwODMxMTdV", "waybill": "1026682083117U", "carrierId": "DPD", "createdAt": "2025-10-02T10:36:31Z", "lineItems": [{"id": "741a7c31-9ed9-11f0-b465-492415e4339b"}, {"id": "741a7c30-9ed9-11f0-b465-492415e4339b"}]}, {"id": "RFBEOjEwMjY2ODIwODMyMzdV", "waybill": "1026682083237U", "carrierId": "DPD", "createdAt": "2025-10-02T10:36:31Z", "lineItems": [{"id": "741a7c31-9ed9-11f0-b465-492415e4339b"}, {"id": "741a7c30-9ed9-11f0-b465-492415e4339b"}]}, {"id": "RFBEOjEwMjY2ODIwODMzNDhV", "waybill": "1026682083348U", "carrierId": "DPD", "createdAt": "2025-10-02T10:36:31.101Z", "lineItems": [{"id": "741a7c31-9ed9-11f0-b465-492415e4339b"}, {"id": "741a7c30-9ed9-11f0-b465-492415e4339b"}]}, {"id": "RFBEOjEwMjY2ODIwODM0NTNV", "waybill": "1026682083453U", "carrierId": "DPD", "createdAt": "2025-10-02T10:36:31.367Z", "lineItems": [{"id": "741a7c31-9ed9-11f0-b465-492415e4339b"}, {"id": "741a7c30-9ed9-11f0-b465-492415e4339b"}]}, {"id": "RFBEOjEwMjY2ODIwODM1MDhV", "waybill": "1026682083508U", "carrierId": "DPD", "createdAt": "2025-10-02T10:36:31.604Z", "lineItems": [{"id": "741a7c31-9ed9-11f0-b465-492415e4339b"}, {"id": "741a7c30-9ed9-11f0-b465-492415e4339b"}]}]	\N	0.00	\N	[]	f
7805	2e56f660-9eac-11f0-9468-2bd22967b382	\N	\N	2025-10-01 09:53:24.961	Gotowe do realizacji	allegro-pl	38470041	Client:38470041	tfvthfpx0x+3a4da5d17@allegromail.pl	\N	Iza Jóźwiak	+48 506 153 501	Chodzieska 23	60-418	Poznań	PL	5d7b4b86-9eac-11f0-b9a1-9fd75769370f	PAID	AF	t	505.50	PLN	Kurier DPD	17.00	PLN	505.50	PLN	wzór Hugo czarny ( TH 1)	f	\N	2025-10-01 09:53:24.961	\N	2025-10-09 19:57:12.194263	ONLINE	f	[{"id": "RFBEOjEwMjY3MjQwNTUxMzVV", "waybill": "1026724055135U", "carrierId": "DPD", "createdAt": "2025-10-03T05:14:15.846Z", "lineItems": [{"id": "2e4f7c50-9eac-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
7806	dc70e320-9eaa-11f0-8ace-e54796c9c1e2	\N	\N	2025-10-01 09:42:26.192	Gotowe do realizacji	allegro-pl	50174885	Client:50174885	ppr8di1rde+767d131b4@allegromail.pl	\N	Natalia Longier	+48 530 400 390	Studzian 223a	37-200	Przeworsk	PL	e8bd3c20-9eaa-11f0-91d4-7961b40d7b05	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	798.09	PLN	\N	t	\N	2025-10-01 09:42:26.192	\N	2025-10-09 19:57:13.518163	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3MjQxMTMzMDlV", "waybill": "1026724113309U", "carrierId": "DPD", "createdAt": "2025-10-03T05:15:16.136Z", "lineItems": [{"id": "dc660db0-9eaa-11f0-8ace-e54796c9c1e2"}]}, {"id": "RFBEOjEwMjY3MjQxMTM0NDhV", "waybill": "1026724113448U", "carrierId": "DPD", "createdAt": "2025-10-03T05:15:16.360Z", "lineItems": [{"id": "dc660db0-9eaa-11f0-8ace-e54796c9c1e2"}]}]	\N	0.00	\N	[]	f
8047	d88190f0-9b0f-11f0-b871-03a75625f948	\N	\N	2025-09-26 19:38:18.027	Gotowe do realizacji	allegro-pl	104339754	Client:104339754	6ecd2pos4r+41d668e02@allegromail.pl	\N	Krystian  Fajdek 	+48 660 369 201	Krześniaków 21A	05-660	Warka	PL	e48c74b0-9b0f-11f0-89e8-3f9d4e258057	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	427.99	PLN	Szafka na buty biała kolor poszycia siedziska brązowy materiał WE4	t	\N	2025-09-26 19:38:18.027	\N	2025-10-10 09:04:53.35606	CASH_ON_DELIVERY	t	[{"id": "RFBEOjEwMjY0NzY0Mjk2MzNV", "waybill": "1026476429633U", "carrierId": "DPD", "createdAt": "2025-09-30T05:17:22.072Z", "lineItems": [{"id": "d87d4b30-9b0f-11f0-b871-03a75625f948"}]}]	Krześniaków 21A 	0.00	\N	[]	f
7813	d41ce880-9e97-11f0-8996-07b46275101a	\N	\N	2025-10-01 07:30:51.252	Gotowe do realizacji	allegro-pl	11634406	nosek29	wkpd0v7hx7+319b6e745@allegromail.pl	\N	Mateusz Mosak	+48 661 406 560	Wola Gardzienicka 28	21-050	Piaski	PL	e4d09381-9e97-11f0-baf9-a33944a1116d	PAID	AF	t	1045.00	PLN	Allegro Kurier DPD	0.00	PLN	1045.00	PLN	kolor paneli ściennych oraz siedziska ES4 - Eko skóra Brąz \nkolor wieszaków  H3 - Złoto szczotkowane	t	\N	2025-10-01 07:30:51.252	\N	2025-10-09 19:57:22.849985	ONLINE	f	[{"id": "RFBEOjEwMjY3MjQ0NjA4MDFV", "waybill": "1026724460801U", "carrierId": "DPD", "createdAt": "2025-10-03T05:21:09.776Z", "lineItems": [{"id": "d41854a0-9e97-11f0-8996-07b46275101a"}]}, {"id": "RFBEOjEwMjY3MjQ0NjA5MDhV", "waybill": "1026724460908U", "carrierId": "DPD", "createdAt": "2025-10-03T05:21:09.922Z", "lineItems": [{"id": "d41854a0-9e97-11f0-8996-07b46275101a"}]}]	\N	0.00	\N	[]	f
7859	dfc2f4f0-9e55-11f0-b871-03a75625f948	\N	\N	2025-09-30 23:33:52.798	Gotowe do realizacji	allegro-pl	136644980	Client:136644980	jkc0oyvond+7fd345921@allegromail.pl	\N	Natalia Wójtowicz	+48 739 173 325	Cmentarna 1b / Natalia W3ójtowicz	59-220	Legnica	PL	e9747e9a-9e55-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	318.99	PLN	\N	t	\N	2025-09-30 23:33:52.798	\N	2025-10-09 19:57:26.879438	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY2MDA5NzI2MjJV", "waybill": "1026600972622U", "carrierId": "DPD", "createdAt": "2025-10-01T10:56:18.246Z", "lineItems": [{"id": "dfbeaf30-9e55-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7860	93cb0710-9e3f-11f0-9325-2757f66ce3c4	\N	\N	2025-09-30 20:54:23.644	Gotowe do realizacji	allegro-pl	14840110	kapi_55	52vikrz5nc+85ed9b37@allegromail.pl	\N	Renata Ciupa	+48 797 629 233	Zubowice 70A	22-435	Komarów	PL	a1422426-9e3f-11f0-baf9-a33944a1116d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	330.99	PLN	F02 Fjord jasny szary	t	\N	2025-09-30 20:54:23.644	\N	2025-10-09 19:57:28.363695	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY2NDUwNjA0OTNV", "waybill": "1026645060493U", "carrierId": "DPD", "createdAt": "2025-10-02T05:42:17.859Z", "lineItems": [{"id": "93c67330-9e3f-11f0-9325-2757f66ce3c4"}]}]	\N	0.00	\N	[]	f
7861	0dc8aad0-9e37-11f0-8fb0-7b363fae20c7	\N	\N	2025-09-30 20:01:14.876	Gotowe do realizacji	allegro-pl	17719320	13kasia101991	2ajt4ud09a+334d1a8d6@allegromail.pl	\N	Katarzyna Kociemba	+48 669 274 794	ul. Łąkowa 46	63-421	Janków Przygodzki	PL	0dee0dfc-9e37-11f0-b9a1-9fd75769370f	PAID	P24	t	1540.00	PLN	Allegro Kurier DPD	0.00	PLN	1540.00	PLN	Witam. Kolor haków oraz uchwytów: złoto szczotkowane; Kolor siedziska: WELUR GRAFITOWY WE3. Także mam prośbę czy byłaby możliwość dosłania dwóch uchwytów do szafy w kolorze złota szczotkowanego?! Jeśli tak to poproszę o wiadomość telefoniczną i dokonam zapłate, aby wysłać w komplecie. W jakichkolwiek pytań proszę o kontakt telefoniczny 669274794. Pozdrawiam Katarzyna Serafin	t	\N	2025-09-30 20:01:14.876	\N	2025-10-09 19:57:29.728304	ONLINE	f	[{"id": "RFBEOjEwMjY2NTM5NzI0MTVV", "waybill": "1026653972415U", "carrierId": "DPD", "createdAt": "2025-10-02T06:55:08.958Z", "lineItems": [{"id": "0dc416f0-9e37-11f0-8fb0-7b363fae20c7"}]}, {"id": "RFBEOjEwMjY2NTM5NzI1NzRV", "waybill": "1026653972574U", "carrierId": "DPD", "createdAt": "2025-10-02T06:55:09.125Z", "lineItems": [{"id": "0dc416f0-9e37-11f0-8fb0-7b363fae20c7"}]}, {"id": "RFBEOjEwMjY2NTM5NzI2ODJV", "waybill": "1026653972682U", "carrierId": "DPD", "createdAt": "2025-10-02T06:55:09.234Z", "lineItems": [{"id": "0dc416f0-9e37-11f0-8fb0-7b363fae20c7"}]}]	\N	0.00	\N	[]	f
7862	8f544d00-9e34-11f0-8cf9-590a844f62e8	\N	\N	2025-09-30 19:41:00.365	Gotowe do realizacji	allegro-pl	10611294	casablancamg	mdxvzlu66a+6cf13d4f8@allegromail.pl	\N	Monika Reroń	+48 795 395 035	Daszyńskiego 25 / 9	25-408	Kielce	PL	8f77b454-9e34-11f0-b9a1-9fd75769370f	PAID	AF	t	1332.40	PLN	Allegro Kurier DPD	0.00	PLN	1332.40	PLN	Obicie eko skóra gładka czarna ES1, wieszak czarny H1	t	\N	2025-09-30 19:41:00.365	\N	2025-10-09 19:57:31.206095	ONLINE	f	[{"id": "RFBEOjEwMjY1NzY3MTI2OTBV", "waybill": "1026576712690U", "carrierId": "DPD", "createdAt": "2025-10-01T07:43:56.995Z", "lineItems": [{"id": "8f495080-9e34-11f0-8cf9-590a844f62e8"}]}, {"id": "RFBEOjEwMjY1NzY3MTI3MDNV", "waybill": "1026576712703U", "carrierId": "DPD", "createdAt": "2025-10-01T07:43:57.223Z", "lineItems": [{"id": "8f495080-9e34-11f0-8cf9-590a844f62e8"}]}, {"id": "RFBEOjEwMjY1NzY3MTI4OTFV", "waybill": "1026576712891U", "carrierId": "DPD", "createdAt": "2025-10-01T07:43:57.419Z", "lineItems": [{"id": "8f495080-9e34-11f0-8cf9-590a844f62e8"}]}]	\N	0.00	\N	[]	f
7816	40649dc0-9e30-11f0-b286-41f712537da1	\N	\N	2025-10-01 08:30:44.771	Gotowe do realizacji	allegro-pl	6778332	harnas_nr9	dgk645wq8b+74d7114e8@allegromail.pl	\N	Grzesiek Burak	+48 799 309 974	Skrzyszów 113	33-156	Skrzyszów	PL	40a0e468-9e30-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	Kolor tapicerki \nWelur czarny (WE1)	t	\N	2025-10-01 08:30:44.771	\N	2025-10-09 19:57:32.670068	ONLINE	f	[{"id": "RFBEOjEwMjY3MjQzODI3MzZV", "waybill": "1026724382736U", "carrierId": "DPD", "createdAt": "2025-10-03T05:19:50.450Z", "lineItems": [{"id": "405d98e0-9e30-11f0-b286-41f712537da1"}]}, {"id": "RFBEOjEwMjcwOTMzMzMzOTBV", "waybill": "1027093333390U", "carrierId": "DPD", "createdAt": "2025-10-08T11:29:25.902Z", "lineItems": [{"id": "405d98e0-9e30-11f0-b286-41f712537da1"}]}]	\N	0.00	\N	[]	f
7864	6bba81a0-9e2c-11f0-a459-a9c1a10b0527	\N	\N	2025-09-30 18:39:11.105	Gotowe do realizacji	allegro-pl	107044076	Client:107044076	vcs2cndx9q+2b5c33627@allegromail.pl	\N	Dominik  Goj	+48 721 936 087	Chorzowska 57 ( zakład fryzjerski Anna)	41-902	Bytom	PL	aae79a69-9e2c-11f0-91d4-7961b40d7b05	PAID	P24	t	1360.00	PLN	Kurier DPD	17.00	PLN	1360.00	PLN	\N	f	\N	2025-09-30 18:39:11.105	\N	2025-10-09 19:57:34.124208	ONLINE	f	[{"id": "RFBEOjEwMjY2NDUyODIxMDRV", "waybill": "1026645282104U", "carrierId": "DPD", "createdAt": "2025-10-02T05:44:48.438Z", "lineItems": [{"id": "6bb1a800-9e2c-11f0-a459-a9c1a10b0527"}]}, {"id": "RFBEOjEwMjY2NDUyODIyMjRV", "waybill": "1026645282224U", "carrierId": "DPD", "createdAt": "2025-10-02T05:44:48.642Z", "lineItems": [{"id": "6bb1a800-9e2c-11f0-a459-a9c1a10b0527"}]}, {"id": "RFBEOjEwMjY2NDUyODIzODFV", "waybill": "1026645282381U", "carrierId": "DPD", "createdAt": "2025-10-02T05:44:48.894Z", "lineItems": [{"id": "6bb1a800-9e2c-11f0-a459-a9c1a10b0527"}]}]	\N	0.00	\N	[]	f
7865	9687df20-9e29-11f0-a07b-27f19dcfd61a	\N	\N	2025-09-30 18:17:10.134	Gotowe do realizacji	allegro-pl	39054990	MalWeres	c5yjr5ee8n+6b67fe644@allegromail.pl	\N	Małgorzata Adryan	+48 514 981 197	Sulimów 31/44	08-110	Siedlce	PL	9fe75142-9e29-11f0-b9a1-9fd75769370f	PAID	P24	t	385.00	PLN	Allegro Kurier DPD	0.00	PLN	385.00	PLN	\N	t	\N	2025-09-30 18:17:10.134	\N	2025-10-09 19:57:35.69216	ONLINE	f	[{"id": "RFBEOjEwMjY2NDU0NDY5NTlV", "waybill": "1026645446959U", "carrierId": "DPD", "createdAt": "2025-10-02T05:46:31.937Z", "lineItems": [{"id": "9682fd20-9e29-11f0-a07b-27f19dcfd61a"}]}]	\N	0.00	\N	[]	f
7866	d2623fa0-9e28-11f0-a6cc-b3145592fdde	\N	\N	2025-09-30 18:11:20.264	Gotowe do realizacji	allegro-pl	103634964	Client:103634964	4oxhnwf379+534a2ebe4@allegromail.pl	\N	Justyna Walczak	+48 500 769 406	Bartąska 162/20	10-687	Bartąg	PL	d944a443-9e28-11f0-a417-fd831f6ae8ec	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	336.99	PLN	\N	t	\N	2025-09-30 18:11:20.264	\N	2025-10-09 19:57:37.239716	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY3MzYwODk2NzhV", "waybill": "1026736089678U", "carrierId": "DPD", "createdAt": "2025-10-03T07:31:48.314Z", "lineItems": [{"id": "d25ac590-9e28-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
7867	f42c0090-9e1d-11f0-820b-7b684c0899aa	\N	\N	2025-09-30 16:55:13.832	Gotowe do realizacji	allegro-pl	127922122	Client:127922122	3l8tn0dpnh+170e6042@allegromail.pl	\N	Mariusz R Rogowski	+48 503 786 097	pionierów lubuskich 74	66-002	Zielona góra Stary Kisielin	PL	24ceb810-9e1e-11f0-bb32-51209e96d6bb	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	847.99	PLN	Witam, zamawiam zestaw Dab wotan, eko skóra ES4 ciemny brąz, Pozdrawiam	f	\N	2025-09-30 16:55:13.832	\N	2025-10-09 19:57:38.745835	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY1NzE0NjE2ODJV", "waybill": "1026571461682U", "carrierId": "DPD", "createdAt": "2025-10-01T07:04:14.198Z", "lineItems": [{"id": "f42522c0-9e1d-11f0-820b-7b684c0899aa"}]}, {"id": "RFBEOjEwMjY1NzE0NjE3MzFV", "waybill": "1026571461731U", "carrierId": "DPD", "createdAt": "2025-10-01T07:04:14.401Z", "lineItems": [{"id": "f42522c0-9e1d-11f0-820b-7b684c0899aa"}]}]	\N	0.00	\N	[]	f
7868	221d3350-9e1b-11f0-8e98-fdfd51e10ba4	\N	\N	2025-09-30 16:34:58.998	Gotowe do realizacji	allegro-pl	9193108	Golden-Tiger	ry4a0p50dx+6d1e2ffb1@allegromail.pl	\N	Sebastian Idzikowski	+48 508 800 271	Roweckiego 71/2	72-009	Police	PL	225dbee6-9e1b-11f0-96eb-67f4404dbe40	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	TH1 - Tkanina Hugo Czarny	t	\N	2025-09-30 16:34:58.998	\N	2025-10-09 19:57:40.882458	ONLINE	f	[{"id": "RFBEOjEwMjY1NzE2MTM0MjZV", "waybill": "1026571613426U", "carrierId": "DPD", "createdAt": "2025-10-01T07:05:13.244Z", "lineItems": [{"id": "22156b20-9e1b-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjY1NzE2MTM1MDdV", "waybill": "1026571613507U", "carrierId": "DPD", "createdAt": "2025-10-01T07:05:13.453Z", "lineItems": [{"id": "22156b20-9e1b-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjY1NzE3NzY1NjlV", "waybill": "1026571776569U", "carrierId": "DPD", "createdAt": "2025-10-01T07:06:31Z", "lineItems": [{"id": "22156b20-9e1b-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
7869	881920f1-9e17-11f0-b871-03a75625f948	\N	\N	2025-09-30 16:13:12.628	Gotowe do realizacji	allegro-pl	102157276	Client:102157276	slmxglvatp+2aea6ed04@allegromail.pl	\N	Izabela Bułka	+48 501 121 251	Bolesławicka 26 / 72	03-352	Warszawa	PL	41bb41bf-9e18-11f0-a284-071dd65bf45d	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	1338.99	PLN	HAKI       H1-CZARNY \nOBICIE    ES1-CZARNY\n	f	\N	2025-09-30 16:13:12.628	\N	2025-10-09 19:57:42.387318	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY1NzUxMzc1NDBV", "waybill": "1026575137540U", "carrierId": "DPD", "createdAt": "2025-10-01T07:31:49.505Z", "lineItems": [{"id": "880cc4e1-9e17-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjY1NzUxMzc2MzJV", "waybill": "1026575137632U", "carrierId": "DPD", "createdAt": "2025-10-01T07:31:49.655Z", "lineItems": [{"id": "880cc4e1-9e17-11f0-b871-03a75625f948"}]}, {"id": "RFBEOjEwMjY1NzUxMzc3MTdV", "waybill": "1026575137717U", "carrierId": "DPD", "createdAt": "2025-10-01T07:31:49.814Z", "lineItems": [{"id": "880cc4e1-9e17-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7870	0305dfa0-9e0f-11f0-9fa0-ab34abe0805b	\N	\N	2025-09-30 15:09:36.307	Gotowe do realizacji	allegro-pl	3155920	kasik1989	44e8e31hyk+23e8d255@allegromail.pl	\N	Katarzyna Pankiewicz	+48 604 978 784	Pułaskiego 4 / 16	05-400	Otwock	PL	3fed75c5-9e0f-11f0-baf9-a33944a1116d	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Thp2 Hugo pik  jasny szary	t	\N	2025-09-30 15:09:36.307	\N	2025-10-09 19:57:43.912526	ONLINE	f	[{"id": "RFBEOjEwMjY1NzE3MTE5ODdV", "waybill": "1026571711987U", "carrierId": "DPD", "createdAt": "2025-10-01T07:06:00.774Z", "lineItems": [{"id": "02fe8ca0-9e0f-11f0-9fa0-ab34abe0805b"}]}]	\N	0.00	\N	[]	f
7871	dc71b140-9e0c-11f0-a758-8bcc0e9ae972	\N	\N	2025-09-30 14:51:52.964	Gotowe do realizacji	allegro-pl	1252658	44han44	ict5en0k0c+1638bbd11@allegromail.pl	\N	JACEK PASADYN	+48 502 891 486	Grodzka 9 D/ 5	73-110	Stargard	PL	f56cce43-9e0c-11f0-bdd7-1b3dfdcd18cd	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	466.99	PLN	\N	t	\N	2025-09-30 14:51:52.964	\N	2025-10-09 19:57:45.32572	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY2NDU2NDc0MzBV", "waybill": "1026645647430U", "carrierId": "DPD", "createdAt": "2025-10-02T05:48:44.123Z", "lineItems": [{"id": "dc6afa80-9e0c-11f0-a758-8bcc0e9ae972"}]}]	\N	0.00	\N	[]	f
8110	6d4f1340-9969-11f0-b55d-c5913dafd975	\N	\N	2025-09-24 17:11:38.339	Gotowe do realizacji	allegro-pl	25614457	muzmulek	tvnn2p90t1+62c7e8276@allegromail.pl	\N	przemysław piotrowski	+48 506 170 972	elbląg rodziny nalazków 5/3	82-300	elbląg	PL	6d70a5a7-9969-11f0-89e8-3f9d4e258057	PAID	PAYU	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	TH2	t	\N	2025-09-24 17:11:38.339	\N	2025-10-10 09:06:06.424956	ONLINE	f	[{"id": "RFBEOjEwMjYxOTI2NDYwNjRV", "waybill": "1026192646064U", "carrierId": "DPD", "createdAt": "2025-09-25T05:04:52.146Z", "lineItems": [{"id": "6d4a3140-9969-11f0-b55d-c5913dafd975"}]}]	\N	0.00	\N	[]	f
7872	b291b770-9e03-11f0-9a42-bb8e9ffafe52	\N	\N	2025-09-30 13:49:06.533	Gotowe do realizacji	allegro-pl	103974972	Sitodrukarnia2	m9q2xq33a6+617f4c7f3@allegromail.pl	Sitodrukarnia Sp zoo 	Sitodrukarnia2	+48 603 677 814	Dębowa 22	11-034	Stawiguda	PL	c3d39853-9e03-11f0-91d4-7961b40d7b05	PAID	P24	t	846.00	PLN	Allegro Kurier DPD	0.00	PLN	846.00	PLN	\N	t	\N	2025-09-30 13:49:06.533	\N	2025-10-09 19:57:46.731225	ONLINE	f	[{"id": "RFBEOjEwMjY2NDU3NTcwNTVV", "waybill": "1026645757055U", "carrierId": "DPD", "createdAt": "2025-10-02T05:49:47.521Z", "lineItems": [{"id": "b2861eb0-9e03-11f0-9a42-bb8e9ffafe52"}]}, {"id": "RFBEOjEwMjY2NDU3NTcxNDZV", "waybill": "1026645757146U", "carrierId": "DPD", "createdAt": "2025-10-02T05:49:47.687Z", "lineItems": [{"id": "b2861eb0-9e03-11f0-9a42-bb8e9ffafe52"}]}]	\N	0.00	\N	[]	f
7873	a5d6df40-9dfb-11f0-b871-03a75625f948	\N	\N	2025-09-30 12:49:55.968	Gotowe do realizacji	allegro-pl	98599178	Client:98599178	ljiwmlgkk7+7beadf523@allegromail.pl	\N	weronika saczuk	+48 887 807 113	sowinskiego 16/109	05-120	legionowo	PL	b2a90a1f-9dfb-11f0-bdd7-1b3dfdcd18cd	PAID	P24	t	340.99	PLN	Allegro Kurier DPD	14.99	PLN	340.99	PLN	\N	f	\N	2025-09-30 12:49:55.968	\N	2025-10-09 19:57:48.157165	ONLINE	f	[{"id": "RFBEOjEwMjY1NzQ5ODQ2NTBV", "waybill": "1026574984650U", "carrierId": "DPD", "createdAt": "2025-10-01T07:30:34Z", "lineItems": [{"id": "a5d22450-9dfb-11f0-b871-03a75625f948"}]}]	\N	0.00	\N	[]	f
7874	7d54c060-9df5-11f0-8cf9-590a844f62e8	\N	\N	2025-09-30 12:06:06.401	Gotowe do realizacji	allegro-pl	11450458	renata_mr1	sxm0wop0gz+60bf71fa2@allegromail.pl	\N	Renata Mikulska	+48 662 059 761	Struga 5	76-200	Słupsk	PL	7d76a0f8-9df5-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	dzień dobry,\npoproszę siedzisko i panele materiał welur czarny WE1	t	\N	2025-09-30 12:06:06.401	\N	2025-10-09 19:57:49.555196	ONLINE	f	[{"id": "RFBEOjEwMjY2NDU5NzA2ODZV", "waybill": "1026645970686U", "carrierId": "DPD", "createdAt": "2025-10-02T05:51:35.216Z", "lineItems": [{"id": "7d4fde60-9df5-11f0-8cf9-590a844f62e8"}]}, {"id": "RFBEOjEwMjY2NDU5NzA3NzlV", "waybill": "1026645970779U", "carrierId": "DPD", "createdAt": "2025-10-02T05:51:35.427Z", "lineItems": [{"id": "7d4fde60-9df5-11f0-8cf9-590a844f62e8"}]}, {"id": "RFBEOjEwMjY2NDU5NzA4NjdV", "waybill": "1026645970867U", "carrierId": "DPD", "createdAt": "2025-10-02T05:51:35.635Z", "lineItems": [{"id": "7d4fde60-9df5-11f0-8cf9-590a844f62e8"}]}]	\N	0.00	\N	[]	f
7875	42171941-9def-11f0-8498-f546d68c9b4c	\N	\N	2025-09-30 11:19:58.707	Gotowe do realizacji	allegro-pl	120709116	Client:120709116	cj7bqfjfpj+10f45c750@allegromail.pl	\N	Paulina Derewecka	+48 575 005 347	Chłaniów 72	22-335	Żółkiewka	PL	4262c8b5-9def-11f0-96eb-67f4404dbe40	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-09-30 11:19:58.707	\N	2025-10-09 19:57:50.952607	ONLINE	f	[{"id": "RFBEOjEwMjY1Nzc4OTA4NDlV", "waybill": "1026577890849U", "carrierId": "DPD", "createdAt": "2025-10-01T07:52:46.282Z", "lineItems": [{"id": "420f5111-9def-11f0-8498-f546d68c9b4c"}]}]	\N	0.00	\N	[]	f
7876	d24b4190-9dee-11f0-8dfb-8df075740e6d	\N	\N	2025-09-30 11:17:32.71	Gotowe do realizacji	allegro-pl	21888986	thepolishkiller	99xdbddrkb+216cbb027@allegromail.pl	\N	Dawid Zimny	+48 509 503 333	Kiepury 38/5	58-506	Jelenia Góra	PL	d287fd54-9dee-11f0-a284-071dd65bf45d	PAID	AF	t	1102.00	PLN	Allegro Kurier DPD	0.00	PLN	1102.00	PLN	Kolor siedziska - WELUR GRAFIT  WE3	t	\N	2025-09-30 11:17:32.71	\N	2025-10-09 19:57:52.411291	ONLINE	f	[{"id": "RFBEOjEwMjY2NDQ2Nzg1NDNV", "waybill": "1026644678543U", "carrierId": "DPD", "createdAt": "2025-10-02T05:38:15.204Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}, {"id": "RFBEOjEwMjY2NDQ2Nzg2NjNV", "waybill": "1026644678663U", "carrierId": "DPD", "createdAt": "2025-10-02T05:38:15.427Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}, {"id": "RFBEOjEwMjY2NDQ2Nzg3NTRV", "waybill": "1026644678754U", "carrierId": "DPD", "createdAt": "2025-10-02T05:38:15.633Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}, {"id": "RFBEOjEwMjY2NDQ4NzUzODVV", "waybill": "1026644875385U", "carrierId": "DPD", "createdAt": "2025-10-02T05:40:26.806Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}, {"id": "RFBEOjEwMjY2NDQ4NzU0MTJV", "waybill": "1026644875412U", "carrierId": "DPD", "createdAt": "2025-10-02T05:40:27Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}, {"id": "RFBEOjEwMjY2NDQ4NzU1MjVV", "waybill": "1026644875525U", "carrierId": "DPD", "createdAt": "2025-10-02T05:40:27.176Z", "lineItems": [{"id": "d243ee91-9dee-11f0-8dfb-8df075740e6d"}, {"id": "d243ee90-9dee-11f0-8dfb-8df075740e6d"}]}]	\N	0.00	\N	[]	f
7877	ae763330-9dec-11f0-b286-41f712537da1	\N	\N	2025-09-30 11:01:55.693	Gotowe do realizacji	allegro-pl	94125153	Client:94125153	383c4v2pmp+7467c9008@allegromail.pl	\N	Emilia Karwacka	+48 505 118 319	Łączna 26	19-500	Gołdap	PL	b712f207-9dec-11f0-a417-fd831f6ae8ec	PAID	P24	t	385.00	PLN	Allegro Kurier DPD	0.00	PLN	385.00	PLN	\N	t	\N	2025-09-30 11:01:55.693	\N	2025-10-09 19:57:53.994553	ONLINE	f	[{"id": "RFBEOjEwMjY1NzE5NDc1NDJV", "waybill": "1026571947542U", "carrierId": "DPD", "createdAt": "2025-10-01T07:07:46.677Z", "lineItems": [{"id": "ae6eb920-9dec-11f0-b286-41f712537da1"}]}]	\N	0.00	\N	[]	f
7878	0cb72551-9deb-11f0-8cf9-590a844f62e8	\N	\N	2025-09-30 10:49:14.346	Gotowe do realizacji	allegro-pl	24794229	anka94719	o30crhoeks+4fc64bc05@allegromail.pl	\N	Anna Świątoniowska	+48 504 413 902	świerkowa 22	05-077	Zakręt	PL	0cdde7e7-9deb-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	532.00	PLN	Allegro Kurier DPD	0.00	PLN	532.00	PLN	\N	t	\N	2025-09-30 10:49:14.346	\N	2025-10-09 19:57:55.455939	ONLINE	f	[{"id": "RFBEOjEwMjY1NzIwMDQ3ODVV", "waybill": "1026572004785U", "carrierId": "DPD", "createdAt": "2025-10-01T07:08:15.592Z", "lineItems": [{"id": "0cb131e1-9deb-11f0-8cf9-590a844f62e8"}]}, {"id": "RFBEOjEwMjY1NzIwMDQ4MjVV", "waybill": "1026572004825U", "carrierId": "DPD", "createdAt": "2025-10-01T07:08:15.769Z", "lineItems": [{"id": "0cb131e1-9deb-11f0-8cf9-590a844f62e8"}]}]	\N	0.00	\N	[]	f
7879	7379e230-9de3-11f0-9fa0-ab34abe0805b	\N	\N	2025-09-30 09:55:50.334	Gotowe do realizacji	allegro-pl	20176486	tomas_271	ao27mocu4z+336f40131@allegromail.pl	\N	Tomasz Sprycha	+48 603 787 005	ul. Ks. Brzóski  15B/64	21-400	Łuków	PL	8383432f-9de3-11f0-ae11-e76c74c7cf77	PAID	P24	t	611.00	PLN	Allegro Kurier DPD	0.00	PLN	611.00	PLN	proszę o pilną wysyłkę	t	\N	2025-09-30 09:55:50.334	\N	2025-10-09 19:57:56.94902	ONLINE	f	[{"id": "RFBEOjEwMjY2NDYyOTY4OTVV", "waybill": "1026646296895U", "carrierId": "DPD", "createdAt": "2025-10-02T05:54:46.455Z", "lineItems": [{"id": "7372dd50-9de3-11f0-9fa0-ab34abe0805b"}]}, {"id": "RFBEOjEwMjY2NDYyOTY5MDZV", "waybill": "1026646296906U", "carrierId": "DPD", "createdAt": "2025-10-02T05:54:46.617Z", "lineItems": [{"id": "7372dd50-9de3-11f0-9fa0-ab34abe0805b"}]}]	\N	0.00	\N	[]	f
7880	0c5badf0-9de2-11f0-a07b-27f19dcfd61a	\N	\N	2025-09-30 09:44:31.776	Gotowe do realizacji	allegro-pl	28940504	kozik696	d01gto408n+150287d80@allegromail.pl	\N	Urszula Koziatek	+48 502 917 134	Osiedleńcza 32	12-100	Szczytno	PL	0c7e9f7d-9de2-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-09-30 09:44:31.776	\N	2025-10-09 19:57:58.390649	ONLINE	f	[{"id": "RFBEOjEwMjY1MjIxMTgxNjhV", "waybill": "1026522118168U", "carrierId": "DPD", "createdAt": "2025-09-30T11:26:57.455Z", "lineItems": [{"id": "0c56a4e0-9de2-11f0-a07b-27f19dcfd61a"}]}]	\N	0.00	\N	[]	f
7884	093fd080-a54c-11f0-b989-75c7faccd1ca	\N	\N	2025-10-09 20:12:24.416	Gotowe do realizacji	allegro-pl	125422347	Client:125422347	c4220u7mnc+2252f96a2@allegromail.pl	\N	Monika Zasada	+48 512 098 086	Szeligi 13	09-472	Słupno	\N	09951d47-a54c-11f0-96eb-67f4404dbe40	PAID	P24	t	1319.00	\N	Allegro Kurier DPD	0.00	PLN	1319.00	PLN	H1.  ES1	t	\N	2025-10-09 20:17:28.59	\N	2025-10-10 06:52:49.35719	ONLINE	f	[{"id": "RFBEOjEwMjcyMTMyNDY0NTRV", "waybill": "1027213246454U", "carrierId": "DPD", "createdAt": "2025-10-10T05:09:23.700Z", "lineItems": [{"id": "0938cba0-a54c-11f0-b989-75c7faccd1ca"}]}, {"id": "RFBEOjEwMjcyMTMyNDY1NzVV", "waybill": "1027213246575U", "carrierId": "DPD", "createdAt": "2025-10-10T05:09:24.222Z", "lineItems": [{"id": "0938cba0-a54c-11f0-b989-75c7faccd1ca"}]}, {"id": "RFBEOjEwMjcyMTMyNDY2NTVV", "waybill": "1027213246655U", "carrierId": "DPD", "createdAt": "2025-10-10T05:09:24.507Z", "lineItems": [{"id": "0938cba0-a54c-11f0-b989-75c7faccd1ca"}]}]	\N	0.00	\N	[]	f
8051	7d9f0380-9afa-11f0-9468-2bd22967b382	\N	\N	2025-09-26 17:03:05.657	Gotowe do realizacji	allegro-pl	114642761	Client:114642761	ddh6goi62x+30a834530@allegromail.pl	\N	Anna Wanielewska	+48 511 007 334	Podmiejska 11	19-300	Ełk	PL	7e04a347-9afa-11f0-936b-33fea42d2f10	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	\N	t	\N	2025-09-26 17:03:05.657	\N	2025-10-10 09:04:57.792072	ONLINE	f	[{"id": "RFBEOjEwMjYzNzg1Njc1MDZV", "waybill": "1026378567506U", "carrierId": "DPD", "createdAt": "2025-09-29T05:50:18.913Z", "lineItems": [{"id": "7d9825b0-9afa-11f0-9468-2bd22967b382"}]}]	\N	0.00	\N	[]	f
8052	143ea770-9af9-11f0-993e-ed3f3ef1a290	\N	\N	2025-09-26 16:58:41.764	Gotowe do realizacji	allegro-pl	89820358	Client:89820358	irac9drruk+367f3b854@allegromail.pl	\N	Magdalena Rayska	+48 664 117 275	Witosa 3 / lok. 2	34-600	Limanowa	PL	bf58b095-9af9-11f0-a227-735d10b96dc7	PAID	P24	t	229.00	PLN	Allegro Kurier DPD	0.00	PLN	229.00	PLN	\N	t	\N	2025-09-26 16:58:41.764	\N	2025-10-10 09:04:59.177795	ONLINE	t	[{"id": "RFBEOjEwMjYzNzM3MzE2OTNV", "waybill": "1026373731693U", "carrierId": "DPD", "createdAt": "2025-09-29T05:10:37.481Z", "lineItems": [{"id": "143aafd0-9af9-11f0-993e-ed3f3ef1a290"}]}]	Orawska 14/56	0.00	\N	[]	f
7962	3c44a380-a5aa-11f0-833e-e3bb93fde64a	\N	\N	2025-10-10 07:25:18.088	Anulowane	allegro-pl	37795708	marzena10182	zmy0qpbneg+149b5cea3@allegromail.pl	\N	Marzena Kuśnierczyk	+48 730 348 541	Blizne 11A	36-221	Blizne	PL	3c78d30e-a5aa-11f0-96eb-67f4404dbe40	PAID	AF	t	1557.00	PLN	Allegro Kurier DPD	0.00	PLN	1557.00	PLN	\N	t	\N	2025-10-10 07:25:18.088	\N	2025-10-10 08:02:28.460366	ONLINE	f	[]	\N	1557.00	2025-10-10 07:26:30.293	[{"id": "70a6acfe-a5aa-11f0-80fb-e1c4317e119c", "order": {"id": "3c44a380-a5aa-11f0-833e-e3bb93fde64a"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "3c78d30e-a5aa-11f0-96eb-67f4404dbe40"}, "deposits": [], "createdAt": "2025-10-10T07:26:30.293Z", "lineItems": [{"id": "3c3decc0-a5aa-11f0-833e-e3bb93fde64a", "type": "AMOUNT", "value": {"amount": "1557.00", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "1557.00", "currency": "PLN"}}]	f
8053	b970f1d0-9af4-11f0-993e-ed3f3ef1a290	\N	\N	2025-09-26 16:35:06.876	Gotowe do realizacji	allegro-pl	128472237	Client:128472237	ibkm5cvxbz+788216230@allegromail.pl	\N	Anna Szczurowska	+48 781 296 795	Majewo 14b/2 14b / 2	83-132	Morzeszczyn	PL	bd93fd34-9af6-11f0-a5d4-c7bfe9b01a9a	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	387.19	PLN	\N	t	\N	2025-09-26 16:35:06.876	\N	2025-10-10 09:05:00.358808	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjY0NzcxODExMTRV", "waybill": "1026477181114U", "carrierId": "DPD", "createdAt": "2025-09-30T05:26:15.143Z", "lineItems": [{"id": "b965ce40-9af4-11f0-993e-ed3f3ef1a290"}]}]	\N	0.00	\N	[]	f
8048	e89dc4f0-9b09-11f0-b76a-5bd8a4bc482c	\N	\N	2025-09-26 18:53:34.842	Gotowe do realizacji	allegro-pl	1541786	Brzozette	amcmqhb8qc+4c12b37e2@allegromail.pl	\N	Kamil Brzozowski	+48 507 449 372	Łąkowa 12B m 42	95-100	Zgierz	PL	e8d5770d-9b09-11f0-89e8-3f9d4e258057	PAID	P24	t	229.00	PLN	Allegro Kurier DPD	0.00	PLN	229.00	PLN	\N	t	\N	2025-09-26 18:53:34.842	\N	2025-10-10 09:04:54.445973	ONLINE	f	[{"id": "RFBEOjEwMjY0NzY1MDcyMjBV", "waybill": "1026476507220U", "carrierId": "DPD", "createdAt": "2025-09-30T05:18:12.372Z", "lineItems": [{"id": "e8997f30-9b09-11f0-b76a-5bd8a4bc482c"}]}]	\N	0.00	\N	[]	f
8049	54495840-9b05-11f0-a6cc-b3145592fdde	\N	\N	2025-09-26 18:20:25.512	Gotowe do realizacji	allegro-pl	1211890	romulus77	jjrx0fxsvt+263d36f94@allegromail.pl	\N	Roman Szubert	+48 604 627 700	Główna 96	43-100	Tychy	PL	54aa3d1c-9b05-11f0-936b-33fea42d2f10	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	obicie - czarna eko skóra	t	\N	2025-09-26 18:20:25.512	\N	2025-10-10 09:04:55.583902	ONLINE	f	[{"id": "RFBEOjEwMjYzNzg2ODgyMzlV", "waybill": "1026378688239U", "carrierId": "DPD", "createdAt": "2025-09-29T05:51:18.570Z", "lineItems": [{"id": "54427a70-9b05-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
8050	304aa1d0-9b03-11f0-8e98-fdfd51e10ba4	\N	\N	2025-09-26 18:06:20.982	Gotowe do realizacji	allegro-pl	39448384	Client:39448384	njwkciiqfa+6d8ba5647@allegromail.pl	\N	Anna Rój	+48 603 823 110	ul.Pszenna 60b	22-100	Chełm	PL	308ab898-9b03-11f0-b639-55f338bcddbf	PAID	P24	t	857.00	PLN	Allegro Kurier DPD	0.00	PLN	857.00	PLN	kolor haków H1\nkolor poduszek TH1	t	\N	2025-09-26 18:06:20.982	\N	2025-10-10 09:04:56.676577	ONLINE	f	[{"id": "RFBEOjEwMjY0NzY3NDE2MzBV", "waybill": "1026476741630U", "carrierId": "DPD", "createdAt": "2025-09-30T05:20:58.066Z", "lineItems": [{"id": "30434ed0-9b03-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjY0NzY3NDE3NDNV", "waybill": "1026476741743U", "carrierId": "DPD", "createdAt": "2025-09-30T05:20:58.227Z", "lineItems": [{"id": "30434ed0-9b03-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
8054	9f9f3660-9af2-11f0-9d66-3d00eb1ccfed	\N	\N	2025-09-26 16:07:32.2	Gotowe do realizacji	allegro-pl	21806707	pandora98	yc5hf48q69+7fd4ad474@allegromail.pl	\N	Katarzyna Milankiewicz	+48 603 707 753	UL. FIELDORFA 14/18	05-200	WOŁOMIN	PL	af53e7ad-9af2-11f0-b639-55f338bcddbf	PAID	P24	t	611.00	PLN	Allegro Kurier DPD	0.00	PLN	611.00	PLN	\N	t	\N	2025-09-26 16:07:32.2	\N	2025-10-10 09:05:01.522419	ONLINE	f	[{"id": "RFBEOjEwMjY0NzcyNjU5MjhV", "waybill": "1026477265928U", "carrierId": "DPD", "createdAt": "2025-09-30T05:27:13.356Z", "lineItems": [{"id": "9f985890-9af2-11f0-9d66-3d00eb1ccfed"}]}, {"id": "RFBEOjEwMjY0NzcyNjYwNTJV", "waybill": "1026477266052U", "carrierId": "DPD", "createdAt": "2025-09-30T05:27:13.552Z", "lineItems": [{"id": "9f985890-9af2-11f0-9d66-3d00eb1ccfed"}]}]	\N	0.00	\N	[]	f
8055	f6873c70-9aed-11f0-a6cc-b3145592fdde	\N	\N	2025-09-26 15:33:30.117	Gotowe do realizacji	allegro-pl	28850230	paati214	1rlabykg5x+7713b9359@allegromail.pl	\N	Patrycja Ledwoń	+48 691 425 232	Wallacha 69	44-348	Skrzyszów	PL	f6c7a181-9aed-11f0-b639-55f338bcddbf	PAID	P24	t	931.00	PLN	Allegro Kurier DPD	0.00	PLN	931.00	PLN	kolor siedziska oraz paneli tapicerowanych WELUR JASNY SZARY (WE2)\nkolor wieszakow czarny mat 	t	\N	2025-09-26 15:33:30.117	\N	2025-10-10 09:05:02.716351	ONLINE	f	[{"id": "RFBEOjEwMjY0Nzc3NTY1MjRV", "waybill": "1026477756524U", "carrierId": "DPD", "createdAt": "2025-09-30T05:32:34.658Z", "lineItems": [{"id": "f67ed800-9aed-11f0-a6cc-b3145592fdde"}, {"id": "f67ed803-9aed-11f0-a6cc-b3145592fdde"}, {"id": "f67ed801-9aed-11f0-a6cc-b3145592fdde"}, {"id": "f67ed802-9aed-11f0-a6cc-b3145592fdde"}]}, {"id": "RFBEOjEwMjY0Nzc3NTY2MDRV", "waybill": "1026477756604U", "carrierId": "DPD", "createdAt": "2025-09-30T05:32:34.830Z", "lineItems": [{"id": "f67ed800-9aed-11f0-a6cc-b3145592fdde"}, {"id": "f67ed803-9aed-11f0-a6cc-b3145592fdde"}, {"id": "f67ed801-9aed-11f0-a6cc-b3145592fdde"}, {"id": "f67ed802-9aed-11f0-a6cc-b3145592fdde"}]}]	\N	0.00	\N	[]	f
8056	c34e2ee0-9ae3-11f0-993e-ed3f3ef1a290	\N	\N	2025-09-26 14:22:27.074	Gotowe do realizacji	allegro-pl	10214594	jolachlebisz	b8zlh208qe+3b9402851@allegromail.pl	\N	Jolanta Chlebisz	+48 503 168 802	Mikołowska 54 m 4	40-065	Katowice	PL	c388ee07-9ae3-11f0-89e8-3f9d4e258057	PAID	P24	t	1163.00	PLN	Allegro Kurier DPD	0.00	PLN	1163.00	PLN	\N	t	\N	2025-09-26 14:22:27.074	\N	2025-10-10 09:05:04.121767	ONLINE	f	[{"id": "RFBEOjEwMjY1MTIwMTgwNDhV", "waybill": "1026512018048U", "carrierId": "DPD", "createdAt": "2025-09-30T10:04:04.023Z", "lineItems": [{"id": "c3499b00-9ae3-11f0-993e-ed3f3ef1a290"}]}, {"id": "RFBEOjEwMjY1MTIwMTgxNTdV", "waybill": "1026512018157U", "carrierId": "DPD", "createdAt": "2025-09-30T10:04:04.188Z", "lineItems": [{"id": "c3499b00-9ae3-11f0-993e-ed3f3ef1a290"}]}]	\N	0.00	\N	[]	f
8057	56a1e050-9adb-11f0-98a2-f73d3272aefa	\N	\N	2025-09-26 13:21:25.095	Gotowe do realizacji	allegro-pl	46859620	karolinaprzywala	bhtfsl19wf+d698e778@allegromail.pl	\N	Karolina Przywała	+48 663 995 983	Osiedle Oświecenia 44/93	31-636	Kraków	PL	56c59540-9adb-11f0-ab95-f7c208471a67	PAID	P24	t	1163.00	PLN	Allegro Kurier DPD	0.00	PLN	1163.00	PLN	\N	t	\N	2025-09-26 13:21:25.095	\N	2025-10-10 09:05:05.295165	ONLINE	f	[{"id": "RFBEOjEwMjY1ODkxMTM4MzhV", "waybill": "1026589113838U", "carrierId": "DPD", "createdAt": "2025-10-01T09:21:52.561Z", "lineItems": [{"id": "569d4c70-9adb-11f0-98a2-f73d3272aefa"}]}, {"id": "RFBEOjEwMjY1ODkxMTM5MjNV", "waybill": "1026589113923U", "carrierId": "DPD", "createdAt": "2025-10-01T09:21:52.872Z", "lineItems": [{"id": "569d4c70-9adb-11f0-98a2-f73d3272aefa"}]}]	\N	0.00	\N	[]	f
8058	d6cb8180-9ad8-11f0-905c-9777b176b77e	\N	\N	2025-09-26 13:02:43.648	Gotowe do realizacji	allegro-pl	7469248	zz-zdzich	wxrmpd51da+b6fbea34@allegromail.pl	\N	Zdzisław Chromniak	+48 696 415 131	prawda 54	32-091	Raciborowice	PL	dbaa264a-9ad8-11f0-84ba-8f13ba8ab30b	PAID	P24	t	526.00	PLN	Allegro Kurier DPD	0.00	PLN	526.00	PLN	Dąb sonoma \nmateriał Welur WE3 grafitowy	t	\N	2025-09-26 13:02:43.648	\N	2025-10-10 09:05:06.540663	ONLINE	f	[{"id": "RFBEOjEwMjY0Nzk2NTE0NzlV", "waybill": "1026479651479U", "carrierId": "DPD", "createdAt": "2025-09-30T05:52:40.404Z", "lineItems": [{"id": "d6c6eda0-9ad8-11f0-905c-9777b176b77e"}]}]	\N	0.00	\N	[]	f
8059	9bbaaf60-9ad5-11f0-8e98-fdfd51e10ba4	\N	\N	2025-09-26 12:44:10.607	Gotowe do realizacji	allegro-pl	97728095	SlaveQ_92	hwoepd23wq+4409c6682@allegromail.pl	\N	Sławomir Andrzejczuk	+48 790 739 250	Ciechanowska 1c/4m	80-180	Gdańsk	PL	aa51bbf3-9ad5-11f0-84ba-8f13ba8ab30b	PAID	AF	t	1347.39	PLN	Allegro Kurier DPD	14.99	PLN	1347.39	PLN	\N	f	\N	2025-09-26 12:44:10.607	\N	2025-10-10 09:05:07.745165	ONLINE	f	[{"id": "RFBEOjEwMjYzOTYxMjczMThV", "waybill": "1026396127318U", "carrierId": "DPD", "createdAt": "2025-09-29T07:32:56.272Z", "lineItems": [{"id": "9badb710-9ad5-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjYzOTYxMjc0NDdV", "waybill": "1026396127447U", "carrierId": "DPD", "createdAt": "2025-09-29T07:32:56.500Z", "lineItems": [{"id": "9badb710-9ad5-11f0-8e98-fdfd51e10ba4"}]}, {"id": "RFBEOjEwMjYzOTYxMjc1NThV", "waybill": "1026396127558U", "carrierId": "DPD", "createdAt": "2025-09-29T07:32:56.713Z", "lineItems": [{"id": "9badb710-9ad5-11f0-8e98-fdfd51e10ba4"}]}]	\N	0.00	\N	[]	f
8060	0f0a7db0-9ad6-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-09-26 12:41:50.537	Gotowe do realizacji	allegro-pl	116430225	Client:116430225	f9jwr99px0+14b459649@allegromail.pl	\N	Viorika Skorochenko	+48 786 336 533	Drabika 71 / 12	52-131	Wroclaw	PL	0f4823bc-9ad6-11f0-89e8-3f9d4e258057	PAID	PAYU	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	Eko skóra Czarny (ES1)	t	\N	2025-09-26 12:41:50.537	\N	2025-10-10 09:05:08.889367	ONLINE	f	[{"id": "RFBEOjEwMjY0Nzk4MzkxNzBV", "waybill": "1026479839170U", "carrierId": "DPD", "createdAt": "2025-09-30T05:54:25.631Z", "lineItems": [{"id": "0f052680-9ad6-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
8061	31f4d460-9acc-11f0-b76a-5bd8a4bc482c	\N	\N	2025-09-26 11:32:05.259	Gotowe do realizacji	allegro-pl	2296015	sticzek	3vp220tk10+62e304e59@allegromail.pl	\N	Lilianna Szymańska	+48 792 290 386	Al. Zdob. Wału Pom. 85/12	78-600	Wałcz	PL	32168dfc-9acc-11f0-83b2-ff1b510348d5	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	WE1	t	\N	2025-09-26 11:32:05.259	\N	2025-10-10 09:05:10.085984	ONLINE	f	[{"id": "RFBEOjEwMjYzNzgzODUwMDZV", "waybill": "1026378385006U", "carrierId": "DPD", "createdAt": "2025-09-29T05:48:56.268Z", "lineItems": [{"id": "31f04080-9acc-11f0-b76a-5bd8a4bc482c"}]}]	\N	0.00	\N	[]	f
8062	0c6fa500-9aca-11f0-9afa-2b3a9799076f	\N	\N	2025-09-26 11:23:26.428	Gotowe do realizacji	allegro-pl	16210674	czarnyps	xylcy5vzf5+54f5730e2@allegromail.pl	\N	Piotr Smolnik	+48 600 857 041	Kilińskiego 11A	98-300	Wieluń	PL	0c9507fa-9aca-11f0-84ba-8f13ba8ab30b	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	\N	t	\N	2025-09-26 11:23:26.428	\N	2025-10-10 09:05:11.223239	ONLINE	f	[{"id": "RFBEOjEwMjYzNzc2NDcxNTBV", "waybill": "1026377647150U", "carrierId": "DPD", "createdAt": "2025-09-29T05:42:49Z", "lineItems": [{"id": "0c6348f0-9aca-11f0-9afa-2b3a9799076f"}]}]	\N	0.00	\N	[]	f
8063	ec999b90-9ac5-11f0-bfbd-d3aacc6a2e00	\N	\N	2025-09-26 10:55:47.865	Gotowe do realizacji	allegro-pl	102777871	Client:102777871	ihhvfd0tig+4e750fd82@allegromail.pl	\N	Eugeniusz Żamojda	+48 503 146 345	Arkadowa 3/8	43-100	Tychy	PL	2e27aec4-9ac6-11f0-bd05-f72007c302ee	PAID	P24	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	\N	t	\N	2025-09-26 10:55:47.865	\N	2025-10-10 09:05:12.340337	ONLINE	f	[{"id": "RFBEOjEwMjY0Nzk5MzkxNTlV", "waybill": "1026479939159U", "carrierId": "DPD", "createdAt": "2025-09-30T05:55:27.901Z", "lineItems": [{"id": "ec9507b0-9ac5-11f0-bfbd-d3aacc6a2e00"}]}]	\N	0.00	\N	[]	f
8064	bada71e0-9abd-11f0-b38f-9b7d2fc63178	\N	\N	2025-09-26 09:50:52.391	Gotowe do realizacji	allegro-pl	34227008	Client:34227008	63krkc4c5m+61f1d49f0@allegromail.pl	\N	Ewelina Szuba	+48 728 758 500	Władysława Kunickiego 84 / 10	20-432	Lublin	PL	422c7958-9abe-11f0-ab95-f7c208471a67	PAID	AF	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	\N	f	\N	2025-09-26 09:50:52.391	\N	2025-10-10 09:05:13.464656	ONLINE	f	[{"id": "RFBEOjEwMjYzNzgxNjY3MjdV", "waybill": "1026378166727U", "carrierId": "DPD", "createdAt": "2025-09-29T05:47:02.855Z", "lineItems": [{"id": "bad2f7d0-9abd-11f0-b38f-9b7d2fc63178"}]}, {"id": "RFBEOjAwMDAwMzk4NTAxODVM", "waybill": "0000039850185L", "carrierId": "DPD", "createdAt": "2025-10-01T05:56:18Z", "lineItems": [{"id": "bad2f7d0-9abd-11f0-b38f-9b7d2fc63178"}]}]	\N	0.00	\N	[]	f
8065	bafbf5e0-9ab8-11f0-ac8c-e9906e3d05fd	\N	\N	2025-09-26 09:12:49.868	Gotowe do realizacji	allegro-pl	38111450	Client:38111450	g4fufv360p+1b7d90fb6@allegromail.pl	\N	Adrian Rugieł	+48 796 405 178	J.Narodowej 91 U1	50-301	Wrocław	PL	cb33e17d-9ab8-11f0-84ba-8f13ba8ab30b	PAID	P24	t	868.00	PLN	Allegro Kurier DPD	0.00	PLN	868.00	PLN	\N	t	\N	2025-09-26 09:12:49.868	\N	2025-10-10 09:05:14.603879	ONLINE	t	[{"id": "RFBEOjEwMjY0ODAzMDE1MDZV", "waybill": "1026480301506U", "carrierId": "DPD", "createdAt": "2025-09-30T05:59:20.378Z", "lineItems": [{"id": "baf1e3c0-9ab8-11f0-ac8c-e9906e3d05fd"}]}, {"id": "RFBEOjEwMjY0ODAzMDE2ODZV", "waybill": "1026480301686U", "carrierId": "DPD", "createdAt": "2025-09-30T05:59:20.530Z", "lineItems": [{"id": "baf1e3c0-9ab8-11f0-ac8c-e9906e3d05fd"}]}]	Ul. Jedności Narodowej 91/ U1	0.00	\N	[]	f
8066	4e823af0-9aae-11f0-98a2-f73d3272aefa	\N	\N	2025-09-26 07:58:21.059	Gotowe do realizacji	allegro-pl	4558526	kris395	qn6twocwi9+7947eef15@allegromail.pl	\N	Krzysztof Kancerek	+48 508 221 318	Wyszyńskiego 79 / 5	44-300	Wodzisław śląski	PL	81573b38-9aae-11f0-936b-33fea42d2f10	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	710.89	PLN	\N	t	\N	2025-09-26 07:58:21.059	\N	2025-10-10 09:05:15.750705	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYzODYzNzEzMzNV", "waybill": "1026386371333U", "carrierId": "DPD", "createdAt": "2025-09-29T06:38:03Z", "lineItems": [{"id": "4e7590c0-9aae-11f0-98a2-f73d3272aefa"}]}, {"id": "RFBEOjEwMjYzODYzNzE0NTZV", "waybill": "1026386371456U", "carrierId": "DPD", "createdAt": "2025-09-29T06:38:03Z", "lineItems": [{"id": "4e7590c0-9aae-11f0-98a2-f73d3272aefa"}]}]	\N	0.00	\N	[]	f
8067	7ac7aef1-9aaa-11f0-b76a-5bd8a4bc482c	\N	\N	2025-09-26 07:31:24.542	Gotowe do realizacji	allegro-pl	97702245	Client:97702245	5xdw3khx2g+a02a0249@allegromail.pl	\N	Aleksandra Trawka	+48 697 723 825	Wrocławska 29a / 8	59-400	Jawor	PL	7b177d7b-9aaa-11f0-83b2-ff1b510348d5	PAID	P24	t	205.00	PLN	Allegro Kurier DPD	0.00	PLN	205.00	PLN	\N	t	\N	2025-09-26 07:31:24.542	\N	2025-10-10 09:05:16.887598	ONLINE	f	[{"id": "RFBEOjEwMjYyOTE3ODI3NDlV", "waybill": "1026291782749U", "carrierId": "DPD", "createdAt": "2025-09-26T10:06:17.601Z", "lineItems": [{"id": "7abed552-9aaa-11f0-b76a-5bd8a4bc482c"}]}]	\N	0.00	\N	[]	f
8068	47e6db80-9a48-11f0-acef-296b8620eb98	\N	\N	2025-09-26 05:12:03.243	Gotowe do realizacji	allegro-pl	22564756	kaczka-30	1cyc6iyy9u+2b6d4b337@allegromail.pl	\N	Karolina Kukulska	+48 502 289 221	Nowe Zagórze 3/3	61-111	Poznań	PL	482a26d6-9a48-11f0-b639-55f338bcddbf	PAID	PAYU	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	\N	t	\N	2025-09-26 05:12:03.243	\N	2025-10-10 09:05:18.010102	ONLINE	f	[{"id": "RFBEOjEwMjYzODY1OTU3OTlV", "waybill": "1026386595799U", "carrierId": "DPD", "createdAt": "2025-09-29T06:39:12.671Z", "lineItems": [{"id": "47df3a60-9a48-11f0-acef-296b8620eb98"}]}, {"id": "RFBEOjEwMjYzODY1OTU4MTFV", "waybill": "1026386595811U", "carrierId": "DPD", "createdAt": "2025-09-29T06:39:12.873Z", "lineItems": [{"id": "47df3a60-9a48-11f0-acef-296b8620eb98"}]}, {"id": "RFBEOjEwMjYzODY1OTU5MThV", "waybill": "1026386595918U", "carrierId": "DPD", "createdAt": "2025-09-29T06:39:13.079Z", "lineItems": [{"id": "47df3a60-9a48-11f0-acef-296b8620eb98"}]}]	\N	0.00	\N	[]	f
8069	ce46e0c0-9a53-11f0-aa4b-670b18f2acf3	\N	\N	2025-09-25 21:09:11.453	Gotowe do realizacji	allegro-pl	104663400	Client:104663400	ecmvqix1k7+17794d68@allegromail.pl	\N	Małgorzata Jaworska	+48 571 412 886	Batorego 31 m7	92-308	Łódź	PL	ce734805-9a53-11f0-89e8-3f9d4e258057	PAID	AF	t	555.00	PLN	Allegro Kurier DPD	0.00	PLN	555.00	PLN	\N	t	\N	2025-09-25 21:09:11.453	\N	2025-10-10 09:05:19.145064	ONLINE	f	[{"id": "RFBEOjEwMjYyNjQ3NTc5MzRV", "waybill": "1026264757934U", "carrierId": "DPD", "createdAt": "2025-09-26T04:55:33.489Z", "lineItems": [{"id": "ce41d7b1-9a53-11f0-aa4b-670b18f2acf3"}, {"id": "ce41d7b0-9a53-11f0-aa4b-670b18f2acf3"}]}]	\N	0.00	\N	[]	f
8082	95ad4ca0-9a02-11f0-bbaa-c715bb9c3bb4	\N	\N	2025-09-25 11:28:13.717	Gotowe do realizacji	allegro-pl	8815897	_lufer	uf9idi0xr8+7e1f37fd9@allegromail.pl	\N	Małgorzata Postójska	+48 663 842 434	Hallera 4	86-300	Grudziadz	PL	9d80a0ac-9a02-11f0-936b-33fea42d2f10	PAID	AF	t	341.00	PLN	Allegro Kurier DPD	0.00	PLN	341.00	PLN	\N	t	\N	2025-09-25 11:28:13.717	\N	2025-10-10 09:05:33.905502	ONLINE	f	[{"id": "RFBEOjEwMjYzNzEyMzU5OThV", "waybill": "1026371235998U", "carrierId": "DPD", "createdAt": "2025-09-29T04:39:17Z", "lineItems": [{"id": "95a49a10-9a02-11f0-bbaa-c715bb9c3bb4"}]}]	\N	0.00	\N	[]	f
8070	8b781170-9a48-11f0-9d91-310fed739d04	\N	\N	2025-09-25 19:49:16.232	Gotowe do realizacji	allegro-pl	58121939	Darth_Fantom	7l1nz5i7c4+4e8572607@allegromail.pl	\N	Mikołaj Suliga	+48 506 672 009	ul.Górczewska 200c m 147	01-460	Warszawa	PL	8be0225e-9a48-11f0-a5d4-c7bfe9b01a9a	PAID	P24	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	EP2 ekoskóra pikowana czarna	t	\N	2025-09-25 19:49:16.232	\N	2025-10-10 09:05:20.341392	ONLINE	f	[{"id": "RFBEOjEwMjYzMDAyNzc4NDdV", "waybill": "1026300277847U", "carrierId": "DPD", "createdAt": "2025-09-26T11:43:08.324Z", "lineItems": [{"id": "8b70be70-9a48-11f0-9d91-310fed739d04"}]}, {"id": "RFBEOjAwMDAwMzk4NTYzMjNM", "waybill": "0000039856323L", "carrierId": "DPD", "createdAt": "2025-10-01T07:13:59Z", "lineItems": [{"id": "8b70be70-9a48-11f0-9d91-310fed739d04"}]}, {"id": "RFBEOjAwMDAwMzk4ODQwNjlM", "waybill": "0000039884069L", "carrierId": "DPD", "createdAt": "2025-10-02T05:38:32Z", "lineItems": [{"id": "8b70be70-9a48-11f0-9d91-310fed739d04"}]}]	\N	0.00	\N	[]	f
8071	704d7230-9a45-11f0-b2e0-e7b4c74cb84b	\N	\N	2025-09-25 19:26:53.461	Gotowe do realizacji	allegro-pl	16813893	Ewka_Zakopane	lxugcnjjya+367e52759@allegromail.pl	\N	Ewa Pajda	+48 784 409 874	Stachonie 39	34-500	Zakopane	PL	70b2c420-9a45-11f0-b639-55f338bcddbf	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-09-25 19:26:53.461	\N	2025-10-10 09:05:21.488846	ONLINE	f	[{"id": "RFBEOjEwMjYyNjQ4MTMyNjdV", "waybill": "1026264813267U", "carrierId": "DPD", "createdAt": "2025-09-26T04:57:01.777Z", "lineItems": [{"id": "70461f30-9a45-11f0-b2e0-e7b4c74cb84b"}]}]	\N	0.00	\N	[]	f
8072	54a3fea0-9a45-11f0-b2e0-e7b4c74cb84b	\N	\N	2025-09-25 19:25:44.255	Gotowe do realizacji	allegro-pl	103787682	Client:103787682	i9rglx0n6o+45938bf30@allegromail.pl	\N	EMILIA MORAWIEC	+48 519 113 998	Jeziorna 145/22	42-470	SIEWIERZ	PL	57e2d612-9a45-11f0-b639-55f338bcddbf	PAID	P24	t	510.00	PLN	Allegro Kurier DPD	0.00	PLN	510.00	PLN	\N	t	\N	2025-09-25 19:25:44.255	\N	2025-10-10 09:05:22.60755	ONLINE	t	[{"id": "RFBEOjEwMjYzMDAzNjk0NTVV", "waybill": "1026300369455U", "carrierId": "DPD", "createdAt": "2025-09-26T11:44:29.613Z", "lineItems": [{"id": "549a1390-9a45-11f0-b2e0-e7b4c74cb84b"}]}]	Jeziorna 145/22	0.00	\N	[]	f
8073	b90a77d0-9a44-11f0-a0cf-655d3976444d	\N	\N	2025-09-25 19:22:06.048	Gotowe do realizacji	allegro-pl	7623149	kudlaczek3	dcuali1ly2+70e4afd63@allegromail.pl	\N	Agnieszka Rybicka	+48 696 426 711	B.Głowackiego 16/61	85-614	Bydgoszcz	PL	b9442578-9a44-11f0-89e8-3f9d4e258057	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	EP2 EKOSKORA CZARNA PIKOWANA	t	\N	2025-09-25 19:22:06.048	\N	2025-10-10 09:05:23.761014	ONLINE	f	[{"id": "RFBEOjEwMjYzMDA0OTM1NDlV", "waybill": "1026300493549U", "carrierId": "DPD", "createdAt": "2025-09-26T11:46:07.906Z", "lineItems": [{"id": "b9063210-9a44-11f0-a0cf-655d3976444d"}]}]	\N	0.00	\N	[]	f
8074	3d6c3280-9a44-11f0-b55d-c5913dafd975	\N	\N	2025-09-25 19:17:25.956	Gotowe do realizacji	allegro-pl	47321190	Client:47321190	phmibd0n23+6f25a4eb4@allegromail.pl	\N	Daria Styś	+48 721 529 325	Bończyka 3	48-250	Głogówek	PL	3d822c4c-9a44-11f0-89e8-3f9d4e258057	PAID	PAYU	t	793.10	PLN	Allegro Kurier DPD	0.00	PLN	793.10	PLN	\N	t	\N	2025-09-25 19:17:25.956	\N	2025-10-10 09:05:24.871428	ONLINE	f	[{"id": "RFBEOjEwMjYzMDA2Nzg3MTVV", "waybill": "1026300678715U", "carrierId": "DPD", "createdAt": "2025-09-26T11:48:25.007Z", "lineItems": [{"id": "3d650690-9a44-11f0-b55d-c5913dafd975"}]}, {"id": "RFBEOjEwMjYzMDA2Nzg4MDNV", "waybill": "1026300678803U", "carrierId": "DPD", "createdAt": "2025-09-26T11:48:25.216Z", "lineItems": [{"id": "3d650690-9a44-11f0-b55d-c5913dafd975"}]}]	\N	0.00	\N	[]	f
8077	2f630d90-9a2a-11f0-8a8f-819744f4cb4b	\N	\N	2025-09-25 16:11:26.426	Gotowe do realizacji	allegro-pl	17611849	AsiulkaStalowaa	jrjhrghk7w+603d96934@allegromail.pl	\N	Joanna Wyka 	+48 531 393 220	Sienkiewicza 22	37-450	Stalowa Wola	PL	36ad8282-9a2a-11f0-a5d4-c7bfe9b01a9a	UNPAID	\N	f	\N	\N	Kurier DPD pobranie	22.00	PLN	1195.00	PLN	\N	f	\N	2025-09-25 16:11:26.426	\N	2025-10-10 09:05:28.262313	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYzMDEwMzczNzFV", "waybill": "1026301037371U", "carrierId": "DPD", "createdAt": "2025-09-26T11:53:00.027Z", "lineItems": [{"id": "2f5be1a0-9a2a-11f0-8a8f-819744f4cb4b"}]}, {"id": "RFBEOjEwMjYzMDEwMzc0MDJV", "waybill": "1026301037402U", "carrierId": "DPD", "createdAt": "2025-09-26T11:53:00.259Z", "lineItems": [{"id": "2f5be1a0-9a2a-11f0-8a8f-819744f4cb4b"}]}, {"id": "RFBEOjEwMjYzMDEwMzc1NTVV", "waybill": "1026301037555U", "carrierId": "DPD", "createdAt": "2025-09-26T11:53:00.475Z", "lineItems": [{"id": "2f5be1a0-9a2a-11f0-8a8f-819744f4cb4b"}]}]	\N	0.00	\N	[]	f
8078	e3ed6d10-9a29-11f0-9c1c-634c8fb78ee1	\N	\N	2025-09-25 16:09:56.111	Gotowe do realizacji	allegro-pl	11151889	Iwcia6612	99yc5cxlnb+78b285dc9@allegromail.pl	\N	Iwona Kiarszys	+48 604 416 605	Żukowo 6	73-132	Suchań	PL	e42e46b8-9a29-11f0-bd05-f72007c302ee	PAID	AF	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	Siedzisko z materiału WE-1 welur czarny	t	\N	2025-09-25 16:09:56.111	\N	2025-10-10 09:05:29.399928	ONLINE	f	[{"id": "RFBEOjEwMjYzMDExMTA4MzJV", "waybill": "1026301110832U", "carrierId": "DPD", "createdAt": "2025-09-26T11:54:07.590Z", "lineItems": [{"id": "e3e64120-9a29-11f0-9c1c-634c8fb78ee1"}]}]	\N	0.00	\N	[]	f
8079	8c5ac160-9a29-11f0-8dbe-7ff68d0cb850	\N	\N	2025-09-25 16:10:27.352	Gotowe do realizacji	allegro-pl	39253884	Client:39253884	i897m0fo77+3f96de9d5@allegromail.pl	\N	Alina Kaminska	+48 608 161 672	Czorsztyńska 2 m 25	01-410	Warszawa	PL	8c992ade-9a29-11f0-bd05-f72007c302ee	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-09-25 16:10:27.352	\N	2025-10-10 09:05:30.52403	ONLINE	f	[{"id": "RFBEOjEwMjYyNjQ4NDY1ODFV", "waybill": "1026264846581U", "carrierId": "DPD", "createdAt": "2025-09-26T04:57:51.958Z", "lineItems": [{"id": "8c534750-9a29-11f0-8dbe-7ff68d0cb850"}]}]	\N	0.00	\N	[]	f
8080	4c2be490-9a0e-11f0-8dbe-7ff68d0cb850	\N	\N	2025-09-25 12:56:52.295	Gotowe do realizacji	allegro-pl	105243708	Client:105243708	c7n8q34gml+2f7726750@allegromail.pl	\N	Elżbieta Dobrowolska	+48 501 279 999	Obrońców 32	03-927	Warszawa	PL	ea215d69-9a0e-11f0-bd05-f72007c302ee	PAID	P24	t	432.99	PLN	Allegro Kurier DPD	14.99	PLN	432.99	PLN	\N	f	\N	2025-09-25 12:56:52.295	\N	2025-10-10 09:05:31.633859	ONLINE	f	[{"id": "RFBEOjEwMjYzMDEyOTA0MzdV", "waybill": "1026301290437U", "carrierId": "DPD", "createdAt": "2025-09-26T11:56:40Z", "lineItems": [{"id": "4c24b8a0-9a0e-11f0-8dbe-7ff68d0cb850"}]}]	\N	0.00	\N	[]	f
8081	597901c0-9a02-11f0-a494-c34ff42b5735	\N	\N	2025-09-25 11:29:15.224	Gotowe do realizacji	allegro-pl	26025600	grzesiu3333	w0jnfcpmug+17ae00cd2@allegromail.pl	\N	Łukasz Grzeszyk	+48 798 896 289	Mełgiewska 7/9	20-209	Lublin	PL	66bb7a9c-9a02-11f0-b639-55f338bcddbf	PAID	PAYU	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	Proszę o informację na liscie przewowozym o dostawie do firmy Bitstream. Ułatwi to kurierowi dotarcie pod właściwy adres	t	\N	2025-09-25 11:29:15.224	\N	2025-10-10 09:05:32.744761	ONLINE	f	[{"id": "RFBEOjEwMjYzNzA2ODUxMThV", "waybill": "1026370685118U", "carrierId": "DPD", "createdAt": "2025-09-29T04:29:24.274Z", "lineItems": [{"id": "597160a0-9a02-11f0-a494-c34ff42b5735"}]}, {"id": "RFBEOjEwMjYzNzA2ODUyMjZV", "waybill": "1026370685226U", "carrierId": "DPD", "createdAt": "2025-09-29T04:29:24.481Z", "lineItems": [{"id": "597160a0-9a02-11f0-a494-c34ff42b5735"}]}, {"id": "RFBEOjEwMjYzNzA2ODUzMzlV", "waybill": "1026370685339U", "carrierId": "DPD", "createdAt": "2025-09-29T04:29:24.685Z", "lineItems": [{"id": "597160a0-9a02-11f0-a494-c34ff42b5735"}]}]	\N	0.00	\N	[]	f
8376	ace79380-a669-11f0-8895-094b8cada9e7	\N	\N	2025-10-11 06:17:32.273	Gotowe do realizacji	allegro-pl	16194704	szpilor5	l4s6phs1rb+2ba7e24e5@allegromail.pl	\N	Jarosław Grochowalski	+48 603 952 612	Os. Pawlikowskiego 4f / 10	44-240	Żory	PL	c357e714-a669-11f0-96eb-67f4404dbe40	PAID	AF	t	611.00	PLN	Allegro Kurier DPD	0.00	PLN	611.00	PLN	\N	t	\N	2025-10-11 06:17:32.273	\N	2025-10-11 08:52:48.250918	ONLINE	f	[]	\N	0.00	\N	[]	f
8083	6aa904d0-99fe-11f0-8f9b-4b841337a082	\N	\N	2025-09-25 10:58:26.509	Gotowe do realizacji	allegro-pl	111365713	nanette_86	szhdh99ks1+7559b7838@allegromail.pl	\N	Anna Wójcik	+48 666 306 455	Słowackiego 39/15	05-120	Legionowo	PL	6ac89b37-99fe-11f0-83b2-ff1b510348d5	PAID	P24	t	422.00	PLN	Allegro Kurier DPD	0.00	PLN	422.00	PLN	\N	t	\N	2025-09-25 10:58:26.509	\N	2025-10-10 09:05:35.022959	ONLINE	f	[{"id": "RFBEOjEwMjYzNzEzOTI1MjVV", "waybill": "1026371392525U", "carrierId": "DPD", "createdAt": "2025-09-29T04:41:40.346Z", "lineItems": [{"id": "6aa3fbc0-99fe-11f0-8f9b-4b841337a082"}, {"id": "6aa3fbc1-99fe-11f0-8f9b-4b841337a082"}]}]	\N	0.00	\N	[]	f
8084	3a7894a0-99fa-11f0-9c1c-634c8fb78ee1	\N	\N	2025-09-25 10:30:28.088	Gotowe do realizacji	allegro-pl	87530246	Client:87530246	rh7sduuoht+727111376@allegromail.pl	\N	Agnieszka Lubczyńska	+48 570 608 991	Mniów ul Kielecka 126	26-080	Mniów	PL	3add4adf-99fa-11f0-a5d4-c7bfe9b01a9a	PAID	P24	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	\N	f	\N	2025-09-25 10:30:28.088	\N	2025-10-10 09:05:36.243704	ONLINE	f	[{"id": "RFBEOjEwMjYzNzE4MzAyNTFV", "waybill": "1026371830251U", "carrierId": "DPD", "createdAt": "2025-09-29T04:48:20.206Z", "lineItems": [{"id": "3a70f380-99fa-11f0-9c1c-634c8fb78ee1"}]}]	\N	0.00	\N	[]	f
8085	3f441be0-99f9-11f0-8a8f-819744f4cb4b	\N	\N	2025-09-25 10:20:57.395	Gotowe do realizacji	allegro-pl	1075588	Michal_Taylor	wv764xudst+1cfc20fc4@allegromail.pl	\N	CNT Michał Łebkowski	+48 502 646 263	Myśliwska 66c / 32	30-718	Kraków	PL	43c1b552-99f9-11f0-b639-55f338bcddbf	PAID	PAYU	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Siedzisko WE1	t	\N	2025-09-25 10:20:57.395	\N	2025-10-10 09:05:37.364369	ONLINE	t	[{"id": "RFBEOjEwMjYyNzE1NTQyODNV", "waybill": "1026271554283U", "carrierId": "DPD", "createdAt": "2025-09-26T06:34:57.638Z", "lineItems": [{"id": "3f3c2ca0-99f9-11f0-8a8f-819744f4cb4b"}]}]	ul. Królowej Jadwigi 77/13	0.00	\N	[]	f
8086	3e46b7d0-99f3-11f0-acef-296b8620eb98	\N	\N	2025-09-25 09:39:05.081	Gotowe do realizacji	allegro-pl	56668528	Client:56668528	mdhx33b45f+64e542bd0@allegromail.pl	\N	Patrycja kowalczyk	+48 668 214 345	Studzieniec 98	06-500	Mława	PL	4a2b003b-99f3-11f0-a5d4-c7bfe9b01a9a	PAID	AF	t	1099.00	PLN	Allegro Kurier DPD	0.00	PLN	1099.00	PLN	Welur czarny	t	\N	2025-09-25 09:39:05.081	\N	2025-10-10 09:05:38.439759	ONLINE	f	[{"id": "RFBEOjEwMjYzNzIxMTYxMTBV", "waybill": "1026372116110U", "carrierId": "DPD", "createdAt": "2025-09-29T04:52:18.694Z", "lineItems": [{"id": "3e3f3dc0-99f3-11f0-acef-296b8620eb98"}, {"id": "3e3f3dc1-99f3-11f0-acef-296b8620eb98"}]}, {"id": "RFBEOjEwMjYzNzIxMTYyMThV", "waybill": "1026372116218U", "carrierId": "DPD", "createdAt": "2025-09-29T04:52:18.903Z", "lineItems": [{"id": "3e3f3dc0-99f3-11f0-acef-296b8620eb98"}, {"id": "3e3f3dc1-99f3-11f0-acef-296b8620eb98"}]}, {"id": "RFBEOjEwMjYzNzIxMTYzNDNV", "waybill": "1026372116343U", "carrierId": "DPD", "createdAt": "2025-09-29T04:52:19.116Z", "lineItems": [{"id": "3e3f3dc0-99f3-11f0-acef-296b8620eb98"}, {"id": "3e3f3dc1-99f3-11f0-acef-296b8620eb98"}]}, {"id": "RFBEOjEwMjYzNzIzOTc3NzFV", "waybill": "1026372397771U", "carrierId": "DPD", "createdAt": "2025-09-29T04:56:23.586Z", "lineItems": [{"id": "3e3f3dc0-99f3-11f0-acef-296b8620eb98"}, {"id": "3e3f3dc1-99f3-11f0-acef-296b8620eb98"}]}, {"id": "RFBEOjEwMjYzNzIzOTc4NTlV", "waybill": "1026372397859U", "carrierId": "DPD", "createdAt": "2025-09-29T04:56:23.735Z", "lineItems": [{"id": "3e3f3dc0-99f3-11f0-acef-296b8620eb98"}, {"id": "3e3f3dc1-99f3-11f0-acef-296b8620eb98"}]}, {"id": "RFBEOjEwMjYzNzIzOTc5NTBV", "waybill": "1026372397950U", "carrierId": "DPD", "createdAt": "2025-09-29T04:56:23.905Z", "lineItems": [{"id": "3e3f3dc0-99f3-11f0-acef-296b8620eb98"}, {"id": "3e3f3dc1-99f3-11f0-acef-296b8620eb98"}]}]	\N	0.00	\N	[]	f
8087	9824a880-99f2-11f0-a5bd-1108a8254a2c	\N	\N	2025-09-25 09:34:15.277	Gotowe do realizacji	allegro-pl	103030057	Client:103030057	s4rj8gk0cl+5cd85b3b6@allegromail.pl	\N	Stanisław Kozłowski	+48 530 374 316	Migdałowa 5	05-140	Dosin	PL	98629bec-99f2-11f0-b639-55f338bcddbf	PAID	P24	t	1023.00	PLN	Allegro Kurier DPD	0.00	PLN	1023.00	PLN	P2 - dąb artisan \nES2 - eko skóra jasna szara 	t	\N	2025-09-25 09:34:15.277	\N	2025-10-10 09:05:39.657085	ONLINE	f	[{"id": "RFBEOjEwMjYzNzM1Njc0OThV", "waybill": "1026373567498U", "carrierId": "DPD", "createdAt": "2025-09-29T05:08:59.371Z", "lineItems": [{"id": "981da3a0-99f2-11f0-a5bd-1108a8254a2c"}]}, {"id": "RFBEOjEwMjYzNzM1Njc1NTlV", "waybill": "1026373567559U", "carrierId": "DPD", "createdAt": "2025-09-29T05:08:59.519Z", "lineItems": [{"id": "981da3a0-99f2-11f0-a5bd-1108a8254a2c"}]}, {"id": "RFBEOjEwMjYzNzM1Njc2NjdV", "waybill": "1026373567667U", "carrierId": "DPD", "createdAt": "2025-09-29T05:08:59.663Z", "lineItems": [{"id": "981da3a0-99f2-11f0-a5bd-1108a8254a2c"}]}]	\N	0.00	\N	[]	f
8088	ed8bf770-99ec-11f0-acef-296b8620eb98	\N	\N	2025-09-25 08:53:13.565	Gotowe do realizacji	allegro-pl	34007084	Wandelopa	57zp5aaana+aefc7b69@allegromail.pl	\N	Wioletta Fjałkowska	+48 606 530 222	Międzyleska 3f/36	50-514	Wrocław	PL	eddcd69f-99ec-11f0-936b-33fea42d2f10	PAID	PAYU	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	\N	t	\N	2025-09-25 08:53:13.565	\N	2025-10-10 09:05:40.760982	ONLINE	f	[{"id": "RFBEOjEwMjYyNjk5OTczNTdV", "waybill": "1026269997357U", "carrierId": "DPD", "createdAt": "2025-09-26T06:17:40Z", "lineItems": [{"id": "ed83e120-99ec-11f0-acef-296b8620eb98"}]}]	\N	0.00	\N	[]	f
8109	fc7180a0-996c-11f0-bdcf-f5e6598d901c	\N	\N	2025-09-24 17:37:42.741	Gotowe do realizacji	allegro-pl	89560765	Client:89560765	qdc1zao07w+2ec75c129@allegromail.pl	\N	Dorota Olek	+48 511 691 433	Swaty 11A	08-500	Ryki	PL	fc877a6f-996c-11f0-83b2-ff1b510348d5	PAID	PAYU	t	546.99	PLN	Allegro Kurier DPD	14.99	PLN	546.99	PLN	\N	f	\N	2025-09-24 17:37:42.741	\N	2025-10-10 09:06:05.282158	ONLINE	f	[{"id": "RFBEOjEwMjYxOTE3NjIzMzBV", "waybill": "1026191762330U", "carrierId": "DPD", "createdAt": "2025-09-25T04:47:07Z", "lineItems": [{"id": "fc6cc5b0-996c-11f0-bdcf-f5e6598d901c"}]}, {"id": "RFBEOjEwMjYxOTE3NjI0MzFV", "waybill": "1026191762431U", "carrierId": "DPD", "createdAt": "2025-09-25T04:47:07Z", "lineItems": [{"id": "fc6cc5b0-996c-11f0-bdcf-f5e6598d901c"}]}]	\N	0.00	\N	[]	f
8089	70874450-99ec-11f0-8f9b-4b841337a082	\N	\N	2025-09-25 09:05:36.64	Gotowe do realizacji	allegro-pl	93773221	Client:93773221	bl0xqzmf84+5e5af1447@allegromail.pl	\N	Alicja Kowalska	+48 609 419 347	Wola Krasienińska, 17	21-025	Niemce	PL	af309c01-99ee-11f0-a5d4-c7bfe9b01a9a	PAID	AF	t	1259.20	PLN	Allegro Kurier DPD	0.00	PLN	1259.20	PLN	\N	t	\N	2025-09-25 09:05:36.64	\N	2025-10-10 09:05:41.87223	ONLINE	f	[{"id": "RFBEOjEwMjYyNjk3NDM2ODBV", "waybill": "1026269743680U", "carrierId": "DPD", "createdAt": "2025-09-26T06:14:57.340Z", "lineItems": [{"id": "707eb8d1-99ec-11f0-8f9b-4b841337a082"}, {"id": "707eb8d0-99ec-11f0-8f9b-4b841337a082"}]}, {"id": "RFBEOjEwMjYyNjk3NDM3MjlV", "waybill": "1026269743729U", "carrierId": "DPD", "createdAt": "2025-09-26T06:14:57.554Z", "lineItems": [{"id": "707eb8d1-99ec-11f0-8f9b-4b841337a082"}, {"id": "707eb8d0-99ec-11f0-8f9b-4b841337a082"}]}, {"id": "RFBEOjEwMjYyNjk3NDM4MTdV", "waybill": "1026269743817U", "carrierId": "DPD", "createdAt": "2025-09-26T06:14:57.794Z", "lineItems": [{"id": "707eb8d1-99ec-11f0-8f9b-4b841337a082"}, {"id": "707eb8d0-99ec-11f0-8f9b-4b841337a082"}]}]	\N	0.00	\N	[]	f
8377	0f8d5bd0-a667-11f0-a685-3b2ebe8a80a1	\N	\N	2025-10-11 05:57:06.217	Gotowe do realizacji	allegro-pl	100262842	Client:100262842	noszpjhrr1+48384fb68@allegromail.pl	\N	Katarzyna Tarnowska	+48 519 865 522	Jordanowska 4 m 11	26-670	Pionki	PL	0faccba4-a667-11f0-b9a1-9fd75769370f	PAID	AF	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-10-11 05:57:06.217	\N	2025-10-11 08:52:49.46183	ONLINE	f	[]	\N	0.00	\N	[]	f
8090	31d3b380-99ea-11f0-b1bc-794ec0214095	\N	\N	2025-09-25 08:33:06.238	Gotowe do realizacji	allegro-pl	121668254	Client:121668254	n9n7uwn0ju+128cddce3@allegromail.pl	\N	krzysztof zaczyk	+48 501 005 278	Piłsudskiego 35/23	33-380	Krynica Zdrój	PL	3670465f-99ea-11f0-83b2-ff1b510348d5	PAID	PAYU	t	385.00	PLN	Allegro Kurier DPD	0.00	PLN	385.00	PLN	\N	t	\N	2025-09-25 08:33:06.238	\N	2025-10-10 09:05:43.080348	ONLINE	f	[{"id": "RFBEOjEwMjYyMjY5MzcyMDlV", "waybill": "1026226937209U", "carrierId": "DPD", "createdAt": "2025-09-25T10:14:45.196Z", "lineItems": [{"id": "31cf46b0-99ea-11f0-b1bc-794ec0214095"}]}]	\N	0.00	\N	[]	f
8091	e61f4730-99e7-11f0-80ff-cf273d5b30c9	\N	\N	2025-09-25 08:17:23.028	Gotowe do realizacji	allegro-pl	20488055	very_cherry6	q2006chbkv+35ab963e1@allegromail.pl	\N	Karolina Staręga	+48 500 386 869	ul. Sciegiennego 51a	40-111	katowice	PL	e6467e55-99e7-11f0-83b2-ff1b510348d5	PAID	P24	t	671.00	PLN	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	2025-09-25 08:17:23.028	\N	2025-10-10 09:05:44.16789	ONLINE	f	[{"id": "RFBEOjEwMjYyNzAxMDA1MjBV", "waybill": "1026270100520U", "carrierId": "DPD", "createdAt": "2025-09-26T06:18:40.082Z", "lineItems": [{"id": "e61a3e20-99e7-11f0-80ff-cf273d5b30c9"}]}, {"id": "RFBEOjEwMjYyNzAxMDA2NDBV", "waybill": "1026270100640U", "carrierId": "DPD", "createdAt": "2025-09-26T06:18:40.302Z", "lineItems": [{"id": "e61a3e20-99e7-11f0-80ff-cf273d5b30c9"}]}]	\N	0.00	\N	[]	f
8092	9c5666f0-99d4-11f0-9d91-310fed739d04	\N	\N	2025-09-25 06:18:21.954	Gotowe do realizacji	allegro-pl	7302973	adriana_2011	9fuy82c7jp+2f1af8ed2@allegromail.pl	\N	Adriana Gajewska	+48 504 571 638	CHEŁMOŃSKIEGO 67	99-400	ŁOWICZ	PL	9cb7251d-99d4-11f0-bd05-f72007c302ee	PAID	PAYU	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	\N	t	\N	2025-09-25 06:18:21.954	\N	2025-10-10 09:05:45.303072	ONLINE	f	[{"id": "RFBEOjEwMjYyNzAxOTg5OTFV", "waybill": "1026270198991U", "carrierId": "DPD", "createdAt": "2025-09-26T06:19:52.130Z", "lineItems": [{"id": "9c4fb030-99d4-11f0-9d91-310fed739d04"}]}, {"id": "RFBEOjEwMjYyNzAxOTkwNTRV", "waybill": "1026270199054U", "carrierId": "DPD", "createdAt": "2025-09-26T06:19:52.352Z", "lineItems": [{"id": "9c4fb030-99d4-11f0-9d91-310fed739d04"}]}, {"id": "RFBEOjEwMjYyNzAxOTkxNzVV", "waybill": "1026270199175U", "carrierId": "DPD", "createdAt": "2025-09-26T06:19:52.543Z", "lineItems": [{"id": "9c4fb030-99d4-11f0-9d91-310fed739d04"}]}]	\N	0.00	\N	[]	f
8093	3b766751-99d3-11f0-af8d-a355c40aec5a	\N	\N	2025-09-25 05:52:29.228	Gotowe do realizacji	allegro-pl	7267981	Aniam0404	rknlsgjjh4+1fbfa70a3@allegromail.pl	\N	Ania Szyk	+48 601 376 471	Szlachecka 12	52-200	Suchy Dwór	PL	3b98e462-99d3-11f0-84ba-8f13ba8ab30b	PAID	AF	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	Zamawiam szafkę z obiciem ES1 - Eko skóra Czarny.	t	\N	2025-09-25 05:52:29.228	\N	2025-10-10 09:05:46.420007	ONLINE	f	[{"id": "RFBEOjEwMjYyNzAzNTE4NzdV", "waybill": "1026270351877U", "carrierId": "DPD", "createdAt": "2025-09-26T06:21:38Z", "lineItems": [{"id": "3b71ac61-99d3-11f0-af8d-a355c40aec5a"}]}]	\N	0.00	\N	[]	f
8094	6fa24c40-99d0-11f0-bbaa-c715bb9c3bb4	\N	\N	2025-09-25 05:31:28.121	Gotowe do realizacji	allegro-pl	104099520	Client:104099520	oyjsb7yi59+1a535a109@allegromail.pl	\N	Małgorzata Krzemińska	+48 694 477 475	Ul.Zarzewska 53/61 m.55	93-129	Łódź	PL	6fe65aae-99d0-11f0-936b-33fea42d2f10	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	siedzisko ES 4	t	\N	2025-09-25 05:31:28.121	\N	2025-10-10 09:05:47.534579	ONLINE	f	[{"id": "RFBEOjEwMjYyMjYwNDI5ODFV", "waybill": "1026226042981U", "carrierId": "DPD", "createdAt": "2025-09-25T10:06:41.437Z", "lineItems": [{"id": "6f9af940-99d0-11f0-bbaa-c715bb9c3bb4"}]}]	\N	0.00	\N	[]	f
8095	3899f820-99cf-11f0-b55d-c5913dafd975	\N	\N	2025-09-25 05:20:30.181	Gotowe do realizacji	allegro-pl	44233901	Mewa990	dfrazcl5mk+43985e300@allegromail.pl	\N	Mateusz Zarach	+48 510 511 695	Bolesława Krzywoustego 6 / 1	81-035	Gdynia	PL	4ceb3c71-99cf-11f0-bd05-f72007c302ee	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	\N	t	\N	2025-09-25 05:20:30.181	\N	2025-10-10 09:05:48.634355	ONLINE	f	[{"id": "RFBEOjEwMjYyNzA0MjMwNjFV", "waybill": "1026270423061U", "carrierId": "DPD", "createdAt": "2025-09-26T06:22:21.894Z", "lineItems": [{"id": "38956440-99cf-11f0-b55d-c5913dafd975"}]}, {"id": "RFBEOjEwMjY5NTQ1NzYxOTZV", "waybill": "1026954576196U", "carrierId": "DPD", "createdAt": "2025-10-07T04:44:32.420Z", "lineItems": [{"id": "38956440-99cf-11f0-b55d-c5913dafd975"}]}]	\N	0.00	\N	[]	f
8096	1cad9a10-99cd-11f0-851b-d74ab869f4ab	\N	\N	2025-09-25 05:06:43.477	Gotowe do realizacji	allegro-pl	103263809	Client:103263809	l608fi1kaa+a7cb47e0@allegromail.pl	\N	Ewa Motycka	+48 518 372 244	Koszteli 3 / 19	05-110	Jabłonna	PL	68aa93b5-99cd-11f0-bd05-f72007c302ee	UNPAID	\N	f	\N	\N	Kurier DPD pobranie	44.00	PLN	2491.00	PLN	\N	f	\N	2025-09-25 05:06:43.477	\N	2025-10-10 09:05:49.773175	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYyNzA2ODQ0MDNV", "waybill": "1026270684403U", "carrierId": "DPD", "createdAt": "2025-09-26T06:25:09.769Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}, {"id": "1ca8df20-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjEwMjYyNzA2ODQ1MjZV", "waybill": "1026270684526U", "carrierId": "DPD", "createdAt": "2025-09-26T06:25:09.936Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}, {"id": "1ca8df20-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjEwMjYyNzA2ODQ2NDZV", "waybill": "1026270684646U", "carrierId": "DPD", "createdAt": "2025-09-26T06:25:10.098Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}, {"id": "1ca8df20-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjEwMjYyNzA2ODQ3OTVV", "waybill": "1026270684795U", "carrierId": "DPD", "createdAt": "2025-09-26T06:25:10.268Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}, {"id": "1ca8df20-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjEwMjYyNzA2ODQ4MzVV", "waybill": "1026270684835U", "carrierId": "DPD", "createdAt": "2025-09-26T06:25:10.427Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}, {"id": "1ca8df20-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjEwMjYyNzExMDIzMjhV", "waybill": "1026271102328U", "carrierId": "DPD", "createdAt": "2025-09-26T06:30:07Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}, {"id": "1ca8df20-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjEwMjYyNzExMDI0OTdV", "waybill": "1026271102497U", "carrierId": "DPD", "createdAt": "2025-09-26T06:30:07Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}, {"id": "1ca8df20-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjEwMjYyNzExMDI1NDRV", "waybill": "1026271102544U", "carrierId": "DPD", "createdAt": "2025-09-26T06:30:07Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}, {"id": "1ca8df20-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjEwMjYyNzExMDI2NjRV", "waybill": "1026271102664U", "carrierId": "DPD", "createdAt": "2025-09-26T06:30:07Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}, {"id": "1ca8df20-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjEwMjYyNzExMDI3ODlV", "waybill": "1026271102789U", "carrierId": "DPD", "createdAt": "2025-09-26T06:30:07Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}, {"id": "1ca8df20-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjAwMDAwMzk4MTI3MDJM", "waybill": "0000039812702L", "carrierId": "DPD", "createdAt": "2025-09-29T07:50:26Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjAwMDAwMzk4MTI3MDNM", "waybill": "0000039812703L", "carrierId": "DPD", "createdAt": "2025-09-29T07:50:26Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjAwMDAwMzk4MTI2OTlM", "waybill": "0000039812699L", "carrierId": "DPD", "createdAt": "2025-09-29T07:50:26Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjAwMDAwMzk4MTI3MDBM", "waybill": "0000039812700L", "carrierId": "DPD", "createdAt": "2025-09-29T07:50:26Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjAwMDAwMzk4MTI3MDFM", "waybill": "0000039812701L", "carrierId": "DPD", "createdAt": "2025-09-29T07:50:26Z", "lineItems": [{"id": "1ca8df21-99cd-11f0-851b-d74ab869f4ab"}]}]	\N	0.00	\N	[]	f
8097	29e39880-998f-11f0-851b-d74ab869f4ab	\N	\N	2025-09-24 21:44:49.105	Gotowe do realizacji	allegro-pl	4762350	ankryl	xjtqrylp9v+33a6db451@allegromail.pl	\N	Anna Kryzel	+48 606 590 896	Wąska 6	83-425	Dziemiany	PL	3f712d28-998f-11f0-84ba-8f13ba8ab30b	PAID	PAYU	t	611.00	PLN	Allegro Kurier DPD	0.00	PLN	611.00	PLN	\N	t	\N	2025-09-24 21:44:49.105	\N	2025-10-10 09:05:51.019538	ONLINE	f	[{"id": "RFBEOjEwMjYyNjU3NjA5MDVV", "waybill": "1026265760905U", "carrierId": "DPD", "createdAt": "2025-09-26T05:15:45.542Z", "lineItems": [{"id": "29de6860-998f-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjEwMjYyNjU3NjEwOTJV", "waybill": "1026265761092U", "carrierId": "DPD", "createdAt": "2025-09-26T05:15:45.693Z", "lineItems": [{"id": "29de6860-998f-11f0-851b-d74ab869f4ab"}]}]	\N	0.00	\N	[]	f
8098	1ec31e20-9981-11f0-93c9-41e212fc306a	\N	\N	2025-09-24 20:02:27.302	Gotowe do realizacji	allegro-pl	94976084	Client:94976084	helgkxiupm+65ce83567@allegromail.pl	\N	Adrian Kujawa	+48 536 507 821	Jana Olbrachta 62 / 80	01-111	Warszawa	PL	373ada4d-9981-11f0-ab95-f7c208471a67	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Kod koloru siedziska WE3	t	\N	2025-09-24 20:02:27.302	\N	2025-10-10 09:05:52.112951	ONLINE	f	[{"id": "RFBEOjEwMjYxOTI1MTc1OTNV", "waybill": "1026192517593U", "carrierId": "DPD", "createdAt": "2025-09-25T05:02:42.887Z", "lineItems": [{"id": "1ebba410-9981-11f0-93c9-41e212fc306a"}]}]	\N	0.00	\N	[]	f
8100	d9e3e130-997c-11f0-b930-877dd2cd2141	\N	\N	2025-09-24 19:35:51.761	Gotowe do realizacji	allegro-pl	34257770	Client:34257770	z5j7zw9sdu+7ebfb08@allegromail.pl	\N	Dorota Życińska	+48 607 989 771	Sierakowskiego 52/27	91-321	Łódź	PL	da16ff2c-997c-11f0-83b2-ff1b510348d5	PAID	P24	t	1704.10	PLN	Allegro Kurier DPD	0.00	PLN	1704.10	PLN	Poproszę siedzisko WE3 welur grafitowy.\nZależy mi na wymiarach 100x36x202. Garderoba w kolorze białym.	t	\N	2025-09-24 19:35:51.761	\N	2025-10-10 09:05:54.322254	ONLINE	f	[{"id": "RFBEOjEwMjYyNjU5NjIyNjdV", "waybill": "1026265962267U", "carrierId": "DPD", "createdAt": "2025-09-26T05:19:06.990Z", "lineItems": [{"id": "d9d7fa50-997c-11f0-b930-877dd2cd2141"}]}, {"id": "RFBEOjEwMjYyNjU5NjIzMjZV", "waybill": "1026265962326U", "carrierId": "DPD", "createdAt": "2025-09-26T05:19:07.166Z", "lineItems": [{"id": "d9d7fa50-997c-11f0-b930-877dd2cd2141"}]}, {"id": "RFBEOjEwMjYyNjU5NjI0MjdV", "waybill": "1026265962427U", "carrierId": "DPD", "createdAt": "2025-09-26T05:19:07.362Z", "lineItems": [{"id": "d9d7fa50-997c-11f0-b930-877dd2cd2141"}]}]	\N	0.00	\N	[]	f
8101	8ae3db10-9974-11f0-b7ad-bf8cbe88f0cf	\N	\N	2025-09-24 18:41:00.359	Anulowane	allegro-pl	13202807	JustRaven	sdkp09ss6y+4c194f4b5@allegromail.pl	\N	Justyna Czarnecka	+48 784 323 101	Samborska 38A	45-316	Opole	PL	8b091690-9974-11f0-89e8-3f9d4e258057	PAID	AF	t	335.20	PLN	Allegro Kurier DPD	0.00	PLN	335.20	PLN	Kolor siedziska WE3 - Welur Grafitowy	t	\N	2025-09-24 18:33:59.069	\N	2025-10-10 09:05:55.431766	ONLINE	f	[]	\N	335.20	2025-09-24 18:42:20.45	[{"id": "33dc2050-9976-11f0-9058-97906ff99a14", "order": {"id": "8ae3db10-9974-11f0-b7ad-bf8cbe88f0cf"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "8b091690-9974-11f0-89e8-3f9d4e258057"}, "deposits": [], "createdAt": "2025-09-24T18:42:20.450Z", "lineItems": [{"id": "8ad6bbb0-9974-11f0-b7ad-bf8cbe88f0cf", "type": "AMOUNT", "value": {"amount": "335.20", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "335.20", "currency": "PLN"}}]	f
8102	fa06e510-9973-11f0-b55d-c5913dafd975	\N	\N	2025-09-24 18:29:39.568	Gotowe do realizacji	allegro-pl	9986601	aneta-krz	2s08eacg8g+7c172dce6@allegromail.pl	\N	Aneta Krzyzińska	5o9846615	Mierosławskiego 10/5	78-400	Szczecinek	PL	fa5bbcae-9973-11f0-89e8-3f9d4e258057	PAID	PAYU	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	Witam.  Proszę o wykończenie siedziska : WE1 welur czarny.\nPozdrawiam \nAneta K.	t	\N	2025-09-24 18:29:39.568	\N	2025-10-10 09:05:56.557582	ONLINE	f	[{"id": "RFBEOjEwMjYyNjY1ODY3ODNV", "waybill": "1026266586783U", "carrierId": "DPD", "createdAt": "2025-09-26T05:29:07.796Z", "lineItems": [{"id": "fa027840-9973-11f0-b55d-c5913dafd975"}]}]	\N	0.00	\N	[]	f
8103	b585d0e0-9973-11f0-b398-bbf43c290c18	\N	\N	2025-09-24 18:26:03.791	Gotowe do realizacji	allegro-pl	41089759	Bulgos	5l69g2teoo+60a142190@allegromail.pl	\N	Łukasz Juśkiewicz	+48 570 661 683	ul. Kosynierów 82A / 11	84-230	Rumia	PL	b857dcb3-9973-11f0-89e8-3f9d4e258057	PAID	P24	t	217.00	PLN	Allegro Kurier DPD	0.00	PLN	217.00	PLN	\N	t	\N	2025-09-24 18:26:03.791	\N	2025-10-10 09:05:57.681164	ONLINE	f	[{"id": "RFBEOjEwMjYyNjY2NDY1MjZV", "waybill": "1026266646526U", "carrierId": "DPD", "createdAt": "2025-09-26T05:30:08.390Z", "lineItems": [{"id": "b58115f0-9973-11f0-b398-bbf43c290c18"}]}]	\N	0.00	\N	[]	f
8104	84f394d0-9973-11f0-af8d-a355c40aec5a	\N	\N	2025-09-24 18:25:06.878	Gotowe do realizacji	allegro-pl	105186467	Client:105186467	281rm5lafh+7851992e0@allegromail.pl	\N	Volodymyr Bratiszko	+48 734 688 410	Aleksandry bielerzewskiej 2 a / 70	61-249	Poznan	PL	851d1614-9973-11f0-84ba-8f13ba8ab30b	PAID	P24	t	335.20	PLN	Allegro Kurier DPD	0.00	PLN	335.20	PLN	WE-5 	t	\N	2025-09-24 18:25:06.878	\N	2025-10-10 09:05:59.499997	ONLINE	f	[{"id": "RFBEOjEwMjYyNjY3NDgyMjZV", "waybill": "1026266748226U", "carrierId": "DPD", "createdAt": "2025-09-26T05:31:51.889Z", "lineItems": [{"id": "84e75fd0-9973-11f0-af8d-a355c40aec5a"}]}]	\N	0.00	\N	[]	f
8105	81d0bbe0-9971-11f0-8725-2db00e826402	\N	\N	2025-09-24 18:09:22.896	Gotowe do realizacji	allegro-pl	35269963	dzikaroza3	4jqbinao0j+44621c301@allegromail.pl	F.H.KWIACIARNIA 'DZIKA RÓŻA'	Izabela Stalka	+48 514 356 225	Ul.Woźnicka 200	42-350	Koziegłowy	PL	93db4407-9971-11f0-89e8-3f9d4e258057	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	496.29	PLN	\N	t	\N	2025-09-24 18:09:22.896	\N	2025-10-10 09:06:00.658867	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYyNjY4MjQ2MDVV", "waybill": "1026266824605U", "carrierId": "DPD", "createdAt": "2025-09-26T05:33:03.827Z", "lineItems": [{"id": "81c7e240-9971-11f0-8725-2db00e826402"}, {"id": "81c7e241-9971-11f0-8725-2db00e826402"}]}]	\N	0.00	\N	[]	f
8106	f847f3d0-996f-11f0-a0cf-655d3976444d	\N	\N	2025-09-24 18:00:32.437	Gotowe do realizacji	allegro-pl	4948429	tompo33	jqfi93hdyq+620ca35c3@allegromail.pl	\N	TOMASZ STEFAŃSKI	+48 792 240 925	Grabówko 17 / 1	82-500	Grabówko	PL	f86c6c74-996f-11f0-ab95-f7c208471a67	PAID	P24	t	1342.00	PLN	Allegro Kurier DPD	0.00	PLN	1342.00	PLN	\N	t	\N	2025-09-24 18:00:32.437	\N	2025-10-10 09:06:01.861061	ONLINE	f	[{"id": "RFBEOjEwMjYyNjY5MzE4MjNV", "waybill": "1026266931823U", "carrierId": "DPD", "createdAt": "2025-09-26T05:34:50.879Z", "lineItems": [{"id": "f8438700-996f-11f0-a0cf-655d3976444d"}]}, {"id": "RFBEOjEwMjYyNjY5MzE5NjJV", "waybill": "1026266931962U", "carrierId": "DPD", "createdAt": "2025-09-26T05:34:51.077Z", "lineItems": [{"id": "f8438700-996f-11f0-a0cf-655d3976444d"}]}, {"id": "RFBEOjEwMjYyNjY5MzIwMDZV", "waybill": "1026266932006U", "carrierId": "DPD", "createdAt": "2025-09-26T05:34:51.260Z", "lineItems": [{"id": "f8438700-996f-11f0-a0cf-655d3976444d"}]}, {"id": "RFBEOjEwMjYyNjY5MzIxNDdV", "waybill": "1026266932147U", "carrierId": "DPD", "createdAt": "2025-09-26T05:34:51.446Z", "lineItems": [{"id": "f8438700-996f-11f0-a0cf-655d3976444d"}]}]	\N	0.00	\N	[]	f
8107	7f322e20-996f-11f0-bdcf-f5e6598d901c	\N	\N	2025-09-24 17:55:38.15	Gotowe do realizacji	allegro-pl	117766811	Client:117766811	ces4ifaosp+3af479706@allegromail.pl	\N	Sławomir  Kulig	+48 726 930 453	Kawęczyn 61	39-308	Wadowice Górne	PL	9b7dfcbc-996f-11f0-84ba-8f13ba8ab30b	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1891.99	PLN	\N	t	\N	2025-09-24 17:55:38.15	\N	2025-10-10 09:06:02.973804	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYxOTI3MzYzNDBV", "waybill": "1026192736340U", "carrierId": "DPD", "createdAt": "2025-09-25T05:06:12.742Z", "lineItems": [{"id": "7f2d9a40-996f-11f0-bdcf-f5e6598d901c"}]}, {"id": "RFBEOjEwMjYxOTI3MzY0NjVV", "waybill": "1026192736465U", "carrierId": "DPD", "createdAt": "2025-09-25T05:06:12.953Z", "lineItems": [{"id": "7f2d9a40-996f-11f0-bdcf-f5e6598d901c"}]}, {"id": "RFBEOjEwMjYxOTI3MzY1MjRV", "waybill": "1026192736524U", "carrierId": "DPD", "createdAt": "2025-09-25T05:06:13.245Z", "lineItems": [{"id": "7f2d9a40-996f-11f0-bdcf-f5e6598d901c"}]}, {"id": "RFBEOjEwMjYxOTI3MzY2NDRV", "waybill": "1026192736644U", "carrierId": "DPD", "createdAt": "2025-09-25T05:06:13.440Z", "lineItems": [{"id": "7f2d9a40-996f-11f0-bdcf-f5e6598d901c"}]}]	\N	0.00	\N	[]	f
8108	89828510-996e-11f0-9c1c-634c8fb78ee1	\N	\N	2025-09-24 17:48:19.594	Gotowe do realizacji	allegro-pl	7318048	ewa_mini	unx4aafqnz+51ddf4619@allegromail.pl	\N	Ewa Gliniecka	+48 695 705 001	Główna 12	86-141	Błądzim	PL	a11addb6-996e-11f0-a5d4-c7bfe9b01a9a	PAID	AF	t	98.00	PLN	Allegro Kurier DPD	0.00	PLN	98.00	PLN	\N	t	\N	2025-09-24 17:48:19.594	\N	2025-10-10 09:06:04.106554	ONLINE	f	[{"id": "RFBEOjEwMjYyNjcyNjYzNDdV", "waybill": "1026267266347U", "carrierId": "DPD", "createdAt": "2025-09-26T05:40:18.832Z", "lineItems": [{"id": "897a20a0-996e-11f0-9c1c-634c8fb78ee1"}]}]	\N	0.00	\N	[]	f
8112	3ce47280-9960-11f0-814f-31557d7cb244	\N	\N	2025-09-24 16:05:25.49	Gotowe do realizacji	allegro-pl	28806948	Client:28806948	s4rcw77g56+777d4de16@allegromail.pl	\N	Marek Marcinkowski	+48 695 934 179	Ościsłowo, 80	06-452	Ościsłowo	PL	3d160aba-9960-11f0-b639-55f338bcddbf	PAID	PAYU	t	532.00	PLN	Allegro Kurier DPD	0.00	PLN	532.00	PLN	\N	t	\N	2025-09-24 16:05:25.49	\N	2025-10-10 09:06:08.662077	ONLINE	f	[{"id": "RFBEOjEwMjYyNjg3ODI0ODlV", "waybill": "1026268782489U", "carrierId": "DPD", "createdAt": "2025-09-26T06:02:43.189Z", "lineItems": [{"id": "3cdcf870-9960-11f0-814f-31557d7cb244"}]}, {"id": "RFBEOjEwMjYyNjg3ODI1MjhV", "waybill": "1026268782528U", "carrierId": "DPD", "createdAt": "2025-09-26T06:02:43.388Z", "lineItems": [{"id": "3cdcf870-9960-11f0-814f-31557d7cb244"}]}]	\N	0.00	\N	[]	f
8148	532bb610-984e-11f0-84dc-a77b677a2f6a	\N	\N	2025-09-23 07:25:06.86	Gotowe do realizacji	allegro-pl	9620557	olcia0305	9p5ympx5h8+2dd7a4322@allegromail.pl	\N	Aleksandra Pakuła	+48 725 186 769	ul. Klonowa 2/4	76-200	Jezierzyce	PL	554dd370-984e-11f0-ab95-f7c208471a67	PAID	P24	t	83.00	PLN	Allegro Kurier DPD	0.00	PLN	83.00	PLN	Ekoskóra brąz 	t	\N	2025-09-23 07:25:06.86	\N	2025-10-10 09:06:49.72532	ONLINE	f	[{"id": "RFBEOjEwMjYxOTExMDY1ODhV", "waybill": "1026191106588U", "carrierId": "DPD", "createdAt": "2025-09-25T04:29:45.303Z", "lineItems": [{"id": "53232a90-984e-11f0-84dc-a77b677a2f6a"}]}]	\N	0.00	\N	[]	f
8113	1d2fbea0-995a-11f0-9a0d-210301f9954d	\N	\N	2025-09-24 15:26:39.897	Gotowe do realizacji	allegro-pl	24934409	Pensjonat_EL-TAN	u1sfetaqhi+55cb5b807@allegromail.pl	EL-TAN s.c. Katarzyna i Peter Lorenz	Pensjonat_EL-TAN	+48 604 149 972	Kolejowa 7b / 6	45-339	Opole	PL	81400cc8-995a-11f0-936b-33fea42d2f10	PAID	AF	t	1705.00	PLN	Allegro Kurier DPD	0.00	PLN	1705.00	PLN	Wieszak: Chrom \nSiedzisko: THP1 - Tkanina Hugo Pik Grafitowy\nJeżeli to tylko możliwe, to bardzo proszę o wysyłkę w piątek, żeby paczka doszła w poniedziałek, bo we wtorek możemy mieć problem z odbiorem. Dziekuję!	t	\N	2025-09-24 15:26:39.897	\N	2025-10-10 09:06:09.834505	ONLINE	t	[{"id": "RFBEOjEwMjYyMTc3NDAyODlV", "waybill": "1026217740289U", "carrierId": "DPD", "createdAt": "2025-09-25T08:54:05.067Z", "lineItems": [{"id": "1d2b51d0-995a-11f0-9a0d-210301f9954d"}]}, {"id": "RFBEOjEwMjYyMTc3NDAzMzJV", "waybill": "1026217740332U", "carrierId": "DPD", "createdAt": "2025-09-25T08:54:05.215Z", "lineItems": [{"id": "1d2b51d0-995a-11f0-9a0d-210301f9954d"}]}, {"id": "RFBEOjEwMjYyMTc3NDA0MjlV", "waybill": "1026217740429U", "carrierId": "DPD", "createdAt": "2025-09-25T08:54:05.367Z", "lineItems": [{"id": "1d2b51d0-995a-11f0-9a0d-210301f9954d"}]}, {"id": "RFBEOjEwMjYyMjIyNTI0NDlV", "waybill": "1026222252449U", "carrierId": "DPD", "createdAt": "2025-09-25T09:32:42.900Z", "lineItems": [{"id": "1d2b51d0-995a-11f0-9a0d-210301f9954d"}]}, {"id": "RFBEOjEwMjYyMjIyNTI1MjRV", "waybill": "1026222252524U", "carrierId": "DPD", "createdAt": "2025-09-25T09:32:43.101Z", "lineItems": [{"id": "1d2b51d0-995a-11f0-9a0d-210301f9954d"}]}, {"id": "RFBEOjEwMjYyMjIyNTI2MTZV", "waybill": "1026222252616U", "carrierId": "DPD", "createdAt": "2025-09-25T09:32:43.305Z", "lineItems": [{"id": "1d2b51d0-995a-11f0-9a0d-210301f9954d"}]}]	Laski 15	0.00	\N	[]	f
8114	91f1b000-9959-11f0-acef-296b8620eb98	\N	\N	2025-09-24 15:19:23.842	Gotowe do realizacji	allegro-pl	26576447	dabimili	qykl4xq3v8+58bbdc829@allegromail.pl	\N	Dąbrówka Milińska	+48 791 033 695	Żwakowska 21/2	43-100	Tychy	PL	9230dc8e-9959-11f0-936b-33fea42d2f10	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	TH1 (czarny)	t	\N	2025-09-24 15:19:23.842	\N	2025-10-10 09:06:10.948964	ONLINE	f	[{"id": "RFBEOjEwMjYxOTMzODI0NjZV", "waybill": "1026193382466U", "carrierId": "DPD", "createdAt": "2025-09-25T05:15:57.305Z", "lineItems": [{"id": "91ea35f0-9959-11f0-acef-296b8620eb98"}]}]	\N	0.00	\N	[]	f
8115	84a633c0-9955-11f0-9c1c-634c8fb78ee1	\N	\N	2025-09-24 14:53:32.455	Gotowe do realizacji	allegro-pl	4902666	annalak	kikz12hrmj+3275f774@allegromail.pl	\N	Anna Łakomy	+48 538 384 414	Św.M.kolbe 22	41-218	Sosnowiec	PL	8ec1f184-9955-11f0-bd05-f72007c302ee	PAID	AF	t	437.99	PLN	Allegro Kurier DPD	14.99	PLN	437.99	PLN	Proszę o eko skóre jasno szary\nAnna Łakomy	f	\N	2025-09-24 14:53:32.455	\N	2025-10-10 09:06:12.062696	ONLINE	f	[{"id": "RFBEOjEwMjYyNjg4NjUyMzNV", "waybill": "1026268865233U", "carrierId": "DPD", "createdAt": "2025-09-26T06:03:52.417Z", "lineItems": [{"id": "849e6b90-9955-11f0-9c1c-634c8fb78ee1"}]}]	\N	0.00	\N	[]	f
8116	629a4a70-9944-11f0-9c1c-634c8fb78ee1	\N	\N	2025-09-24 12:53:18.766	Gotowe do realizacji	allegro-pl	45348037	pracownia_bma	xuzi3pre44+6c2813e37@allegromail.pl	BMA Home  ESTEMBERG JOANNA	Joanna Estemberg	+48 695 819 765	Mikulice 25A	62-730	Dobra	PL	62e229d1-9944-11f0-a5d4-c7bfe9b01a9a	PAID	P24	t	780.00	PLN	Allegro Kurier DPD	0.00	PLN	780.00	PLN	meble kolor: Dąb Sonoma\nobicie siedziska : WE1 - Welur Czarny	t	\N	2025-09-24 12:53:18.766	\N	2025-10-10 09:06:13.17692	ONLINE	f	[{"id": "RFBEOjEwMjYyNjg5NDU2ODRV", "waybill": "1026268945684U", "carrierId": "DPD", "createdAt": "2025-09-26T06:05:00.387Z", "lineItems": [{"id": "62936ca0-9944-11f0-9c1c-634c8fb78ee1"}]}, {"id": "RFBEOjEwMjYyNjg5NDU3OTdV", "waybill": "1026268945797U", "carrierId": "DPD", "createdAt": "2025-09-26T06:05:00.529Z", "lineItems": [{"id": "62936ca0-9944-11f0-9c1c-634c8fb78ee1"}]}]	\N	0.00	\N	[]	f
8117	780bdde0-9937-11f0-86e6-9981712fa0ed	\N	\N	2025-09-24 11:15:18.355	Gotowe do realizacji	allegro-pl	86489765	Client:86489765	5pqwsiynhy+48658aed2@allegromail.pl	\N	Paweł Potycz	+48 507 335 320	3 Maja 148 / 6	41-500	Chorzów	PL	7ddd47d8-9937-11f0-bd05-f72007c302ee	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	9.98	PLN	927.98	PLN	Kolor siedziska: THP2	t	\N	2025-09-24 11:15:18.355	\N	2025-10-10 09:06:14.306109	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYyNjk1ODMzOTNV", "waybill": "1026269583393U", "carrierId": "DPD", "createdAt": "2025-09-26T06:12:56.154Z", "lineItems": [{"id": "77ffa8e1-9937-11f0-86e6-9981712fa0ed"}, {"id": "77ffa8e0-9937-11f0-86e6-9981712fa0ed"}]}, {"id": "RFBEOjEwMjYyNjk1ODM0ODhV", "waybill": "1026269583488U", "carrierId": "DPD", "createdAt": "2025-09-26T06:12:56.372Z", "lineItems": [{"id": "77ffa8e1-9937-11f0-86e6-9981712fa0ed"}, {"id": "77ffa8e0-9937-11f0-86e6-9981712fa0ed"}]}]	\N	0.00	\N	[]	f
8118	760e8740-9937-11f0-93c9-41e212fc306a	\N	\N	2025-09-24 11:15:17.484	Gotowe do realizacji	allegro-pl	5733529	retro-13	szy86ajm8h+400c3fd86@allegromail.pl	\N	RENATA Kaliszewska	+48 606 207 934	Pogodna 50a/66	20-337	Lublin	PL	7f5911f7-9937-11f0-bd05-f72007c302ee	PAID	AF	t	1190.00	PLN	Allegro Kurier DPD	0.00	PLN	1190.00	PLN	uchwyty czarne, obicie tkanina hugo czarny	t	\N	2025-09-24 11:15:17.484	\N	2025-10-10 09:06:15.542125	ONLINE	f	[{"id": "RFBEOjEwMjYyNjkzMjU0MDdV", "waybill": "1026269325407U", "carrierId": "DPD", "createdAt": "2025-09-26T06:09:57.272Z", "lineItems": [{"id": "7603d8e1-9937-11f0-93c9-41e212fc306a"}, {"id": "7603d8e0-9937-11f0-93c9-41e212fc306a"}]}, {"id": "RFBEOjEwMjYyNjkzMjU1NTBV", "waybill": "1026269325550U", "carrierId": "DPD", "createdAt": "2025-09-26T06:09:57.430Z", "lineItems": [{"id": "7603d8e1-9937-11f0-93c9-41e212fc306a"}, {"id": "7603d8e0-9937-11f0-93c9-41e212fc306a"}]}, {"id": "RFBEOjEwMjY4NDE3NTM1MzFV", "waybill": "1026841753531U", "carrierId": "DPD", "createdAt": "2025-10-06T04:18:34.701Z", "lineItems": [{"id": "7603d8e1-9937-11f0-93c9-41e212fc306a"}, {"id": "7603d8e0-9937-11f0-93c9-41e212fc306a"}]}]	\N	0.00	\N	[]	f
8119	a8913e20-9936-11f0-86e6-9981712fa0ed	\N	\N	2025-09-24 11:09:53.417	Gotowe do realizacji	allegro-pl	9017890	rhkasia	i2qtly4r8e+4dfca9ef6@allegromail.pl	\N	Katarzyna Froń	+48 502 592 791	Wolfkego 14/16	01-494	Warszawa	PL	a8de25fb-9936-11f0-b639-55f338bcddbf	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	THP1 - Tkanina Hugo Pik Grafitowy	t	\N	2025-09-24 11:09:53.417	\N	2025-10-10 09:06:16.774116	ONLINE	f	[{"id": "RFBEOjEwMjYxOTM0NjQwODBV", "waybill": "1026193464080U", "carrierId": "DPD", "createdAt": "2025-09-25T05:16:58.283Z", "lineItems": [{"id": "a8861a90-9936-11f0-86e6-9981712fa0ed"}]}]	\N	0.00	\N	[]	f
8269	d747fb70-a5c3-11f0-a588-b391296a673a	\N	\N	2025-10-10 10:29:00.384	Gotowe do realizacji	allegro-pl	5920015	wojtek10010	270c9usg8g+2d7482361@allegromail.pl	\N	krzysztof gawłowski	+48 666 667 296	Kosmonautów Polskich 107 / 7	67-200	GŁOGÓW	PL	d76a2a3b-a5c3-11f0-b9a1-9fd75769370f	PAID	P24	t	761.00	PLN	Allegro Kurier DPD	0.00	PLN	761.00	PLN	\N	t	\N	2025-10-10 10:29:00.384	\N	2025-10-10 10:51:36.162705	ONLINE	f	[]	\N	0.00	\N	[]	f
8120	16cc4e90-9935-11f0-96d9-9329354dd65b	\N	\N	2025-09-24 10:56:43.349	Gotowe do realizacji	allegro-pl	16338565	Iwona11032	89arb0ds7t+ca4b3087@allegromail.pl	I Lashes Stylizacja rzęs Iwona Korta	Iwona Korta	+48 507 137 440	Ul.Brzeźnicka 55F/ 20	32-700	Bochnia	PL	24bf2c18-9935-11f0-84ba-8f13ba8ab30b	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	330.99	PLN	\N	t	\N	2025-09-24 10:56:43.349	\N	2025-10-10 09:06:17.891805	CASH_ON_DELIVERY	t	[{"id": "RFBEOjEwMjYxOTM1NTU3ODVV", "waybill": "1026193555785U", "carrierId": "DPD", "createdAt": "2025-09-25T05:17:58Z", "lineItems": [{"id": "16c6f760-9935-11f0-96d9-9329354dd65b"}]}]	Ul Brzeźnicka 55f/20	0.00	\N	[]	f
8121	7fcd3ed0-9931-11f0-9844-05ab8e749ed0	\N	\N	2025-09-24 10:32:11.296	Gotowe do realizacji	allegro-pl	36784469	19931joanna	1zwof7e22m+4adf331a7@allegromail.pl	\N	Joanna Starowicz	+48 787 231 869	Ul. Krakowska 135	32-071	Rusocice	PL	a737bb76-9931-11f0-84ba-8f13ba8ab30b	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	755.99	PLN	dąb artisan , h -1 haki czarny, tapicerka siedziska i paneli, we1 - welur czarny 	t	\N	2025-09-24 10:32:11.296	\N	2025-10-10 09:06:19.006753	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYyNjk0NzYzNjNV", "waybill": "1026269476363U", "carrierId": "DPD", "createdAt": "2025-09-26T06:11:43.909Z", "lineItems": [{"id": "7fc2de90-9931-11f0-9844-05ab8e749ed0"}]}]	\N	0.00	\N	[]	f
8122	753462a0-9931-11f0-87a5-21e3a348a117	\N	\N	2025-09-25 19:18:16.491	Anulowane	allegro-pl	47321190	Client:47321190	phmibd0n23+41aa955f7@allegromail.pl	\N	Daria Styś	+48 721 529 325	Bończyka 3	48-250	Głogówek	PL	757b3074-9931-11f0-bd05-f72007c302ee	PAID	P24	t	705.90	PLN	Allegro Kurier DPD	0.00	PLN	705.90	PLN	TH3	t	\N	2025-09-24 10:31:43.773	\N	2025-10-10 09:06:20.141308	ONLINE	f	[]	\N	705.90	2025-09-25 19:18:53.866	[{"id": "799a6300-9a44-11f0-9fef-3b01516b263c", "order": {"id": "753462a0-9931-11f0-87a5-21e3a348a117"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "757b3074-9931-11f0-bd05-f72007c302ee"}, "deposits": [], "createdAt": "2025-09-25T19:18:53.866Z", "lineItems": [{"id": "752372b0-9931-11f0-87a5-21e3a348a117", "type": "AMOUNT", "value": {"amount": "705.90", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "705.90", "currency": "PLN"}}]	f
8123	8e3e7fc0-991c-11f0-af8d-a355c40aec5a	\N	\N	2025-09-24 08:02:10.937	Gotowe do realizacji	allegro-pl	45809743	Client:45809743	dnsxa62lin+444590fd5@allegromail.pl	\N	Paulina Gałkiewicz	+48 505 570 366	Szpitalna 4/32	95-080	Tuszyn	PL	8e6987f8-991c-11f0-83b2-ff1b510348d5	PAID	AF	t	773.00	PLN	Allegro Kurier DPD	0.00	PLN	773.00	PLN	białe \nTH1	t	\N	2025-09-24 08:02:10.937	\N	2025-10-10 09:06:21.269184	ONLINE	f	[{"id": "RFBEOjEwMjYxOTEzMjM4OTRV", "waybill": "1026191323894U", "carrierId": "DPD", "createdAt": "2025-09-25T04:35:48.062Z", "lineItems": [{"id": "8e392890-991c-11f0-af8d-a355c40aec5a"}]}, {"id": "RFBEOjEwMjYxOTEzMjM5MTlV", "waybill": "1026191323919U", "carrierId": "DPD", "createdAt": "2025-09-25T04:35:48.276Z", "lineItems": [{"id": "8e392890-991c-11f0-af8d-a355c40aec5a"}]}, {"id": "RFBEOjEwMjY1NTg2Mjg4MDhV", "waybill": "1026558628808U", "carrierId": "DPD", "createdAt": "2025-10-01T04:59:06.738Z", "lineItems": [{"id": "8e392890-991c-11f0-af8d-a355c40aec5a"}]}]	\N	0.00	\N	[]	f
8124	e9e08410-991a-11f0-8f7a-e9e1ea6a5c03	\N	\N	2025-09-24 07:50:16.772	Gotowe do realizacji	allegro-pl	7297193	murinho9	llfbvyl75n+58511f975@allegromail.pl	\N	Mateusz Iwaniec	+48 725 428 880	ul.Sosnowa 38	32-823	Sterkowiec	PL	ea07bb76-991a-11f0-83b2-ff1b510348d5	PAID	P24	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	Dzień dobry, poproszę o kolor siedziska WE1 - welur czarny.\nPozdrawiam.	t	\N	2025-09-24 07:50:16.772	\N	2025-10-10 09:06:22.382075	ONLINE	f	[{"id": "RFBEOjEwMjYxOTM2NTc5MzdV", "waybill": "1026193657937U", "carrierId": "DPD", "createdAt": "2025-09-25T05:19:11Z", "lineItems": [{"id": "e9dba210-991a-11f0-8f7a-e9e1ea6a5c03"}]}, {"id": "RFBEOjEwMjYxOTM2NTgwODRV", "waybill": "1026193658084U", "carrierId": "DPD", "createdAt": "2025-09-25T05:19:11Z", "lineItems": [{"id": "e9dba210-991a-11f0-8f7a-e9e1ea6a5c03"}]}]	\N	0.00	\N	[]	f
8125	f6860f40-9911-11f0-b930-877dd2cd2141	\N	\N	2025-09-24 06:47:26.026	Gotowe do realizacji	allegro-pl	119341257	Client:119341257	mjmynwyrsl+787839f02@allegromail.pl	\N	Marietta  Kierkiewicz 	+48 721 019 272	Kolejowa 15 C	57-360	Ołdrzychowice Kłodzkie	PL	0156ec32-9912-11f0-84ba-8f13ba8ab30b	PAID	AF	t	328.99	PLN	Allegro Kurier DPD	14.99	PLN	328.99	PLN	werul czarny kolor siedziska 	f	\N	2025-09-24 06:47:26.026	\N	2025-10-10 09:06:23.499748	ONLINE	t	[{"id": "RFBEOjEwMjYxOTIzNTA2MjJV", "waybill": "1026192350622U", "carrierId": "DPD", "createdAt": "2025-09-25T04:59:55.040Z", "lineItems": [{"id": "f6810630-9911-11f0-b930-877dd2cd2141"}]}]	Kolejowa 15 C	0.00	\N	[]	f
8126	84612d60-9906-11f0-a62b-45d36ea56312	\N	\N	2025-09-24 05:23:30.076	Gotowe do realizacji	allegro-pl	103183706	Client:103183706	wmdyou5dfd+6abb386a7@allegromail.pl	\N	Filip Nowakowski	+48 739 983 047	Magnoliowa 25J / 2	32-020	Wieliczka	PL	84bf2cd8-9906-11f0-bd05-f72007c302ee	PAID	PAYU	t	594.00	PLN	Allegro Kurier DPD	0.00	PLN	594.00	PLN	\N	t	\N	2025-09-24 05:23:30.076	\N	2025-10-10 09:06:24.618966	ONLINE	f	[{"id": "RFBEOjEwMjYxOTI0MTE3MThV", "waybill": "1026192411718U", "carrierId": "DPD", "createdAt": "2025-09-25T05:00:52.814Z", "lineItems": [{"id": "8457b780-9906-11f0-a62b-45d36ea56312"}]}, {"id": "RFBEOjEwMjYxOTI0MTE4MDZV", "waybill": "1026192411806U", "carrierId": "DPD", "createdAt": "2025-09-25T05:00:53.078Z", "lineItems": [{"id": "8457b780-9906-11f0-a62b-45d36ea56312"}]}]	\N	0.00	\N	[]	f
8127	30977ac0-98bd-11f0-b4ff-d384dc24cd83	\N	\N	2025-09-23 20:39:17.884	Gotowe do realizacji	allegro-pl	17144525	Beata_TK	li3ka9uzrm+15a592945@allegromail.pl	\N	Beata Gryczka	+48 697 484 847	Słowiańska 7	67-106	Otyń	PL	30d82d70-98bd-11f0-a8d5-39d7fba26715	PAID	PAYU	t	652.00	PLN	Allegro Kurier DPD	0.00	PLN	652.00	PLN	Dzień dobry, \nchciałabym wybrać materiał na siedzisko welur jasno szary. \nZ poważaniem \nKatarzyna Gryczka 	t	\N	2025-09-23 20:39:17.884	\N	2025-10-10 09:06:25.750688	ONLINE	f	[{"id": "RFBEOjEwMjYxNjA1NDY5ODVV", "waybill": "1026160546985U", "carrierId": "DPD", "createdAt": "2025-09-24T11:28:27Z", "lineItems": [{"id": "309075e0-98bd-11f0-b4ff-d384dc24cd83"}]}, {"id": "RFBEOjEwMjYxNjA1NDcwMTZV", "waybill": "1026160547016U", "carrierId": "DPD", "createdAt": "2025-09-24T11:28:27Z", "lineItems": [{"id": "309075e0-98bd-11f0-b4ff-d384dc24cd83"}]}, {"id": "RFBEOjEwMjYxNjA5MDkxOTlV", "waybill": "1026160909199U", "carrierId": "DPD", "createdAt": "2025-09-24T11:30:48.595Z", "lineItems": [{"id": "309075e0-98bd-11f0-b4ff-d384dc24cd83"}]}, {"id": "RFBEOjEwMjYxNjA5MDkyMTlV", "waybill": "1026160909219U", "carrierId": "DPD", "createdAt": "2025-09-24T11:30:48.933Z", "lineItems": [{"id": "309075e0-98bd-11f0-b4ff-d384dc24cd83"}]}]	\N	0.00	\N	[]	f
8128	cd030651-98b7-11f0-851b-d74ab869f4ab	\N	\N	2025-09-23 20:00:24.015	Gotowe do realizacji	allegro-pl	35380567	Client:35380567	xkz24ti2li+754f2e273@allegromail.pl	\N	Ewelina Potyrak	+48 665 106 195	Osiedle Pawlikowskiego 16A / 28	44-240	Żory	PL	cd270973-98b7-11f0-83b2-ff1b510348d5	PAID	AF	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-09-23 20:00:24.015	\N	2025-10-10 09:06:26.865947	ONLINE	f	[{"id": "RFBEOjEwMjYxNjExNDk5MjRV", "waybill": "1026161149924U", "carrierId": "DPD", "createdAt": "2025-09-24T11:33:10.339Z", "lineItems": [{"id": "ccfe4b61-98b7-11f0-851b-d74ab869f4ab"}]}, {"id": "RFBEOjEwMjYxNjExNTAwMTFV", "waybill": "1026161150011U", "carrierId": "DPD", "createdAt": "2025-09-24T11:33:10.546Z", "lineItems": [{"id": "ccfe4b61-98b7-11f0-851b-d74ab869f4ab"}]}]	\N	0.00	\N	[]	f
8129	417d5cd0-98b6-11f0-851b-d74ab869f4ab	\N	\N	2025-09-23 19:49:28.571	Gotowe do realizacji	allegro-pl	5749045	Strazak-69	nrpszeibr7+260d54289@allegromail.pl	\N	Grzegorz Kowalik	+48 785 180 607	Stary Kobylnik 9	26-806	Stara Błotnica	PL	41a5cc64-98b6-11f0-83b2-ff1b510348d5	PAID	P24	t	701.00	PLN	Allegro Kurier DPD	0.00	PLN	701.00	PLN	\N	t	\N	2025-09-23 19:49:28.571	\N	2025-10-10 09:06:27.999834	ONLINE	f	[{"id": "RFBEOjEwMjYxNjEyNjg2MDRV", "waybill": "1026161268604U", "carrierId": "DPD", "createdAt": "2025-09-24T11:34:29.982Z", "lineItems": [{"id": "41782cb0-98b6-11f0-851b-d74ab869f4ab"}]}]	\N	0.00	\N	[]	f
8130	63505670-98b4-11f0-97af-5f765086be88	\N	\N	2025-09-23 19:37:25.113	Gotowe do realizacji	allegro-pl	107550402	Client:107550402	ule2oxpirp+1df845c98@allegromail.pl	\N	Mariola Niwińska	+48 518 464 756	Gajowa, 16	05-119	Wola Aleksandra	PL	6393a164-98b4-11f0-9b3c-6d378382b973	PAID	P24	t	592.00	PLN	Allegro Kurier DPD	0.00	PLN	592.00	PLN	Proszę uchwyty U1	t	\N	2025-09-23 19:37:25.113	\N	2025-10-10 09:06:29.126341	ONLINE	f	[{"id": "RFBEOjEwMjYxNjEzOTk5ODRV", "waybill": "1026161399984U", "carrierId": "DPD", "createdAt": "2025-09-24T11:36:22Z", "lineItems": [{"id": "6347f200-98b4-11f0-97af-5f765086be88"}]}, {"id": "RFBEOjEwMjYxNjE0MDAwOTlV", "waybill": "1026161400099U", "carrierId": "DPD", "createdAt": "2025-09-24T11:36:22Z", "lineItems": [{"id": "6347f200-98b4-11f0-97af-5f765086be88"}]}]	\N	0.00	\N	[]	f
8131	4a438390-98b0-11f0-90d3-c79ca01bf92f	\N	\N	2025-09-23 19:06:20.91	Gotowe do realizacji	allegro-pl	3487146	agata_gp	i2365n6kp5+669482e34@allegromail.pl	\N	Agata Porożyńska	+48 607 038 832	Staropolska 2	42-600	Tarnowskie Góry	PL	4a7a2454-98b0-11f0-ab95-f7c208471a67	PAID	PAYU	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	DH1	t	\N	2025-09-23 19:06:20.91	\N	2025-10-10 09:06:30.254947	ONLINE	f	[{"id": "RFBEOjEwMjYxMTY2OTI0MzRV", "waybill": "1026116692434U", "carrierId": "DPD", "createdAt": "2025-09-24T04:31:30Z", "lineItems": [{"id": "4a3ea190-98b0-11f0-90d3-c79ca01bf92f"}]}]	\N	0.00	\N	[]	f
8132	da538210-98af-11f0-a1f1-f7dbf5017472	\N	\N	2025-09-23 19:02:58.105	Gotowe do realizacji	allegro-pl	3487146	agata_gp	i2365n6kp5+546472078@allegromail.pl	\N	Agata Porożyńska	+48 607 038 832	Staropolska 2	42-600	Tarnowskie Góry	PL	da91c432-98af-11f0-ab95-f7c208471a67	PAID	PAYU	t	169.00	PLN	Allegro Kurier DPD	0.00	PLN	169.00	PLN	\N	t	\N	2025-09-23 19:02:58.105	\N	2025-10-10 09:06:31.365566	ONLINE	f	[{"id": "RFBEOjEwMjYxNjE0OTgxNjVV", "waybill": "1026161498165U", "carrierId": "DPD", "createdAt": "2025-09-24T11:36:51.279Z", "lineItems": [{"id": "da4eee30-98af-11f0-a1f1-f7dbf5017472"}]}]	\N	0.00	\N	[]	f
8133	c215b7a0-98ae-11f0-96af-ed10c88f4a77	\N	\N	2025-09-23 18:57:16.346	Gotowe do realizacji	allegro-pl	26522707	smq12	1qz7rhgl8o+104c72d8@allegromail.pl	\N	Radosław Różnicki	+48 723 310 341	Stara Góra 48	56-200	Góra	PL	c25d6ffa-98ae-11f0-a8d5-39d7fba26715	PAID	AF	t	2008.96	PLN	Allegro Kurier DPD	59.96	PLN	2008.96	PLN	Szafka na buty VB60x30D S1 - HUGO GRAFITOWY (TH3) PIKOWANY\nSzafka komoda na buty 50x30 D2N1 - UCHWYT CZARNY U1	f	\N	2025-09-23 18:57:16.346	\N	2025-10-10 09:06:32.502392	ONLINE	f	[{"id": "RFBEOjEwMjYxNjIxOTQ0MzJV", "waybill": "1026162194432U", "carrierId": "DPD", "createdAt": "2025-09-24T11:43:56.505Z", "lineItems": [{"id": "c20cde03-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde00-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde02-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde01-98ae-11f0-96af-ed10c88f4a77"}]}, {"id": "RFBEOjEwMjYxNjIxOTQ1OTNV", "waybill": "1026162194593U", "carrierId": "DPD", "createdAt": "2025-09-24T11:43:57.064Z", "lineItems": [{"id": "c20cde03-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde00-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde02-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde01-98ae-11f0-96af-ed10c88f4a77"}]}, {"id": "RFBEOjEwMjYxNjIxOTQ2MDFV", "waybill": "1026162194601U", "carrierId": "DPD", "createdAt": "2025-09-24T11:43:57.600Z", "lineItems": [{"id": "c20cde03-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde00-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde02-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde01-98ae-11f0-96af-ed10c88f4a77"}]}, {"id": "RFBEOjEwMjYxNjIxOTQ3MTJV", "waybill": "1026162194712U", "carrierId": "DPD", "createdAt": "2025-09-24T11:43:57.868Z", "lineItems": [{"id": "c20cde03-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde00-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde02-98ae-11f0-96af-ed10c88f4a77"}, {"id": "c20cde01-98ae-11f0-96af-ed10c88f4a77"}]}]	\N	0.00	\N	[]	f
8134	43100460-98ae-11f0-a0cf-655d3976444d	\N	\N	2025-09-23 18:53:42.95	Gotowe do realizacji	allegro-pl	17672937	kaszakov	6pcnkzi3tq+609ba3493@allegromail.pl	\N	Michał Kaszak	+48 601 384 355	Aleja Okrężna 79	88-100	Inowrocław	PL	4be90906-98ae-11f0-84ba-8f13ba8ab30b	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Witam podaje kolor siedziska WE2 pozdrawiam.	t	\N	2025-09-23 18:53:42.95	\N	2025-10-10 09:06:33.846141	ONLINE	f	[{"id": "RFBEOjEwMjYxMTY2MjI2MTBV", "waybill": "1026116622610U", "carrierId": "DPD", "createdAt": "2025-09-24T04:29:52Z", "lineItems": [{"id": "430b2260-98ae-11f0-a0cf-655d3976444d"}]}]	\N	0.00	\N	[]	f
8135	1c5d66a0-98ae-11f0-90d3-c79ca01bf92f	\N	\N	2025-09-23 18:52:22.006	Gotowe do realizacji	allegro-pl	28538476	goga17121991	yuikh67fse+2ffe05d94@allegromail.pl	\N	Małgorzata Paplewska	+48 723 816 750	Szczecińska 5/48	64-965	Okonek	PL	1c805820-98ae-11f0-84ba-8f13ba8ab30b	PAID	P24	t	857.00	PLN	Allegro Kurier DPD	0.00	PLN	857.00	PLN	Poproszę wieszaki czarne i tkaninę F02 fjord szary	t	\N	2025-09-23 18:52:22.006	\N	2025-10-10 09:06:34.958014	ONLINE	f	[{"id": "RFBEOjEwMjYxOTE1NDcwNzNV", "waybill": "1026191547073U", "carrierId": "DPD", "createdAt": "2025-09-25T04:41:43.980Z", "lineItems": [{"id": "1c5884a0-98ae-11f0-90d3-c79ca01bf92f"}]}, {"id": "RFBEOjEwMjYxOTE1NDcxMTZV", "waybill": "1026191547116U", "carrierId": "DPD", "createdAt": "2025-09-25T04:41:44.180Z", "lineItems": [{"id": "1c5884a0-98ae-11f0-90d3-c79ca01bf92f"}]}]	\N	0.00	\N	[]	f
8136	78980c00-98ad-11f0-9f34-dd75279ca6e9	\N	\N	2025-09-23 18:46:23.773	Gotowe do realizacji	allegro-pl	7605925	11082007domek	zj9l7xa9ig+71867fe66@allegromail.pl	\N	KATARZYNA DOMEK	+48 502 723 300	Al.Parkowa 2/13	89-120	POTULICE	PL	78c55dc1-98ad-11f0-9b3c-6d378382b973	PAID	P24	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-09-23 18:46:23.773	\N	2025-10-10 09:06:36.078469	ONLINE	f	[{"id": "RFBEOjEwMjYxMTY0NzY3NDhV", "waybill": "1026116476748U", "carrierId": "DPD", "createdAt": "2025-09-24T04:25:28.895Z", "lineItems": [{"id": "7890e010-98ad-11f0-9f34-dd75279ca6e9"}]}, {"id": "RFBEOjEwMjYxMTY0NzY4MzZV", "waybill": "1026116476836U", "carrierId": "DPD", "createdAt": "2025-09-24T04:25:29.058Z", "lineItems": [{"id": "7890e010-98ad-11f0-9f34-dd75279ca6e9"}]}]	\N	0.00	\N	[]	f
8147	c0d28380-9851-11f0-90d3-c79ca01bf92f	\N	\N	2025-09-23 07:52:18.529	Gotowe do realizacji	allegro-pl	40762603	Client:40762603	mjm1ca6zve+7fe1b5ff6@allegromail.pl	\N	Jakub Michalik	+48 604 638 909	Ceglana 21	05-502	Gołków	PL	08416998-9852-11f0-84ba-8f13ba8ab30b	PAID	PAYU	t	3096.00	PLN	Allegro Kurier DPD	0.00	PLN	3096.00	PLN	Poproszę o wieszaki w kolorze czarnym\nNatomiast panele poproszę w kolorze TH1 - tkanina hugo czarny	t	\N	2025-09-23 07:52:18.529	\N	2025-10-10 09:06:48.465439	ONLINE	f	[{"id": "RFBEOjEwMjYxOTA5Njk4MzFV", "waybill": "1026190969831U", "carrierId": "DPD", "createdAt": "2025-09-25T04:26:22.650Z", "lineItems": [{"id": "c0cc1ae1-9851-11f0-90d3-c79ca01bf92f"}, {"id": "c0cc1ae0-9851-11f0-90d3-c79ca01bf92f"}]}, {"id": "RFBEOjEwMjYxOTA5Njk5MTRV", "waybill": "1026190969914U", "carrierId": "DPD", "createdAt": "2025-09-25T04:26:22.824Z", "lineItems": [{"id": "c0cc1ae1-9851-11f0-90d3-c79ca01bf92f"}, {"id": "c0cc1ae0-9851-11f0-90d3-c79ca01bf92f"}]}, {"id": "RFBEOjEwMjYxOTA5NzAwMjlV", "waybill": "1026190970029U", "carrierId": "DPD", "createdAt": "2025-09-25T04:26:22.981Z", "lineItems": [{"id": "c0cc1ae1-9851-11f0-90d3-c79ca01bf92f"}, {"id": "c0cc1ae0-9851-11f0-90d3-c79ca01bf92f"}]}, {"id": "RFBEOjEwMjYxOTA5NzAxNTJV", "waybill": "1026190970152U", "carrierId": "DPD", "createdAt": "2025-09-25T04:26:23.135Z", "lineItems": [{"id": "c0cc1ae1-9851-11f0-90d3-c79ca01bf92f"}, {"id": "c0cc1ae0-9851-11f0-90d3-c79ca01bf92f"}]}, {"id": "RFBEOjEwMjYxOTA5NzAyNzJV", "waybill": "1026190970272U", "carrierId": "DPD", "createdAt": "2025-09-25T04:26:23.297Z", "lineItems": [{"id": "c0cc1ae1-9851-11f0-90d3-c79ca01bf92f"}, {"id": "c0cc1ae0-9851-11f0-90d3-c79ca01bf92f"}]}, {"id": "RFBEOjEwMjYxOTA5NzAzMjFV", "waybill": "1026190970321U", "carrierId": "DPD", "createdAt": "2025-09-25T04:26:23.464Z", "lineItems": [{"id": "c0cc1ae1-9851-11f0-90d3-c79ca01bf92f"}, {"id": "c0cc1ae0-9851-11f0-90d3-c79ca01bf92f"}]}]	\N	0.00	\N	[]	f
8166	abbb2e00-97ae-11f0-9076-59c352007ac5	\N	\N	2025-09-22 12:21:52.44	Gotowe do realizacji	allegro-pl	62034330	Client:62034330	9cx8zwng4e+58bd51969@allegromail.pl	\N	Teresa Gajewska	+48 501 357 510	Andersa 1 1 / 9	95-040	Koluszki	PL	b39fe6d7-97ae-11f0-9afc-5b2f7b7d5e6f	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	784.99	PLN	\N	t	\N	2025-09-22 12:21:52.44	\N	2025-10-10 09:07:11.067172	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYxMjYxNjM1NjNV", "waybill": "1026126163563U", "carrierId": "DPD", "createdAt": "2025-09-24T06:32:15Z", "lineItems": [{"id": "abb365d0-97ae-11f0-9076-59c352007ac5"}]}, {"id": "RFBEOjEwMjYxMjYxNjM2NTVV", "waybill": "1026126163655U", "carrierId": "DPD", "createdAt": "2025-09-24T06:32:15Z", "lineItems": [{"id": "abb365d0-97ae-11f0-9076-59c352007ac5"}]}]	\N	0.00	\N	[]	f
8137	1178ef60-9896-11f0-b570-01c8ce4005c1	\N	\N	2025-09-23 16:01:01.469	Gotowe do realizacji	allegro-pl	6676591	Malgorzata-Zdeb	yu551sallo+5c2a9f86@allegromail.pl	\N	malgorzata zdeb	+48 513 026 136	Zygmuntowska  42/7	44-113	Gliwice	PL	119b1dc0-9896-11f0-ab95-f7c208471a67	PAID	P24	t	1329.00	PLN	Allegro Kurier DPD	0.00	PLN	1329.00	PLN	Witam, \nProszę o kolor do małej szafki z siedziskiem w kolorze F02.\nZ poważaniem Małgorzata Zdeb	t	\N	2025-09-23 16:01:01.469	\N	2025-10-10 09:06:37.180642	ONLINE	f	[{"id": "RFBEOjEwMjYxOTIyMjYyMDRV", "waybill": "1026192226204U", "carrierId": "DPD", "createdAt": "2025-09-25T04:57:45Z", "lineItems": [{"id": "1174a9a1-9896-11f0-b570-01c8ce4005c1"}, {"id": "1174a9a0-9896-11f0-b570-01c8ce4005c1"}]}, {"id": "RFBEOjEwMjYxOTIyMjYzNDlV", "waybill": "1026192226349U", "carrierId": "DPD", "createdAt": "2025-09-25T04:57:45Z", "lineItems": [{"id": "1174a9a1-9896-11f0-b570-01c8ce4005c1"}, {"id": "1174a9a0-9896-11f0-b570-01c8ce4005c1"}]}, {"id": "RFBEOjEwMjYxOTIyMjY0NDRV", "waybill": "1026192226444U", "carrierId": "DPD", "createdAt": "2025-09-25T04:57:45Z", "lineItems": [{"id": "1174a9a1-9896-11f0-b570-01c8ce4005c1"}, {"id": "1174a9a0-9896-11f0-b570-01c8ce4005c1"}]}]	\N	0.00	\N	[]	f
8138	53194ea0-9892-11f0-9f34-dd75279ca6e9	\N	\N	2025-09-23 15:39:20.673	Gotowe do realizacji	allegro-pl	62175361	Client:62175361	lgn70r3uef+3e38f61d3@allegromail.pl	\N	Krzysztof Wachowski	+48 506 833 245	17stycznnia 5/5	64-360	Zbąszyń	PL	6f68a9d2-9893-11f0-9b3c-6d378382b973	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	39.98	PLN	740.98	PLN	EP-2	f	\N	2025-09-23 15:39:20.673	\N	2025-10-10 09:06:38.383538	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYxNjI2NTYwMTNV", "waybill": "1026162656013U", "carrierId": "DPD", "createdAt": "2025-09-24T11:49:00Z", "lineItems": [{"id": "53104df1-9892-11f0-9f34-dd75279ca6e9"}, {"id": "53104df0-9892-11f0-9f34-dd75279ca6e9"}]}]	\N	0.00	\N	[]	f
8139	b9cebdb0-988d-11f0-99e3-d7e982300479	\N	\N	2025-09-23 15:01:15.655	Gotowe do realizacji	allegro-pl	5113224	rafiko1112	ik485jzfw1+7fe099a17@allegromail.pl	\N	Paweł Jabłoński	+48 791 588 822	Sudecka 8 / 17	15-552	Białystok	PL	d6401597-988d-11f0-ab95-f7c208471a67	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	TH2 - Tkanina Hugo Jasno szary	t	\N	2025-09-23 15:01:15.655	\N	2025-10-10 09:06:39.560889	ONLINE	f	[{"id": "RFBEOjEwMjYxMjMxMTY2OTNV", "waybill": "1026123116693U", "carrierId": "DPD", "createdAt": "2025-09-24T06:05:31.671Z", "lineItems": [{"id": "b9ca02c0-988d-11f0-99e3-d7e982300479"}]}]	\N	0.00	\N	[]	f
8140	21fccb60-987b-11f0-b3d5-5da76e44d274	\N	\N	2025-09-23 12:47:17.716	Gotowe do realizacji	allegro-pl	42117192	DaSzIx	hqljniv17r+86c2a0b4@allegromail.pl	\N	Hubert Dussa	+48 728 733 559	Kwiatowa 6	87-700	Rożno-Parcele	PL	223c9399-987b-11f0-83b2-ff1b510348d5	PAID	AF	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	Hugo grafitowy TH3 	t	\N	2025-09-23 12:47:17.716	\N	2025-10-10 09:06:40.662435	ONLINE	f	[{"id": "RFBEOjEwMjYxNjI3NzE4OThV", "waybill": "1026162771898U", "carrierId": "DPD", "createdAt": "2025-09-24T11:50:05.230Z", "lineItems": [{"id": "21f74d20-987b-11f0-b3d5-5da76e44d274"}]}]	\N	0.00	\N	[]	f
8141	ec5f4eb2-9875-11f0-b570-01c8ce4005c1	\N	\N	2025-09-23 12:18:39.344	Gotowe do realizacji	allegro-pl	5400175	nikita212	uclzk154l6+14f549bb0@allegromail.pl	\N	Iwona Gruszczyńska-Budzik	+48 571 328 627	Młynska 2 A	62-230	Witkowo	PL	681d786f-9876-11f0-a8d5-39d7fba26715	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Kolor Hugo Pik grafit	t	\N	2025-09-23 12:18:39.344	\N	2025-10-10 09:06:41.775277	ONLINE	f	[{"id": "RFBEOjEwMjYxMjMzNDI4OTFV", "waybill": "1026123342891U", "carrierId": "DPD", "createdAt": "2025-09-24T06:07:36Z", "lineItems": [{"id": "ec545232-9875-11f0-b570-01c8ce4005c1"}]}]	\N	0.00	\N	[]	f
8142	cbcf7380-9863-11f0-90d3-c79ca01bf92f	\N	\N	2025-09-23 10:01:59.225	Gotowe do realizacji	allegro-pl	20618980	kasia96391	ahc73b7owe+39ab4d1a1@allegromail.pl	\N	Katarzyna Danowska	+48 512 808 571	Ul. Piaskowa 18	19-222	Wąsosz	PL	cc063b59-9863-11f0-ab95-f7c208471a67	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Kolor obicia eko skóra brązowy chyba że macie velur brązowy albo beżowy. Jeśli nie niech będzie brazowy	t	\N	2025-09-23 10:01:59.225	\N	2025-10-10 09:06:42.875146	ONLINE	f	[{"id": "RFBEOjEwMjYxNjI4NTkzODJV", "waybill": "1026162859382U", "carrierId": "DPD", "createdAt": "2025-09-24T11:51:04.408Z", "lineItems": [{"id": "cbc98010-9863-11f0-90d3-c79ca01bf92f"}]}]	\N	0.00	\N	[]	f
8143	1fa28de0-985e-11f0-8d2c-07b2a010202c	\N	\N	2025-09-23 09:19:17.538	Gotowe do realizacji	allegro-pl	14036067	beatah88	18mdmp0g38+65c29eb25@allegromail.pl	\N	Beata Kosińska	+48 794 788 621	Strzeszyn 183 A	38-340	Biecz	PL	56d1c0a6-985e-11f0-ab95-f7c208471a67	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	741.99	PLN	Kolor siedziska : Hugo Brązowy (TH4)	t	\N	2025-09-23 09:19:17.538	\N	2025-10-10 09:06:43.987168	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYxMjM0NjQ2NDFV", "waybill": "1026123464641U", "carrierId": "DPD", "createdAt": "2025-09-24T06:08:57Z", "lineItems": [{"id": "1f9a9ea0-985e-11f0-8d2c-07b2a010202c"}]}, {"id": "RFBEOjEwMjYxMjM0NjQ3ODhV", "waybill": "1026123464788U", "carrierId": "DPD", "createdAt": "2025-09-24T06:08:57Z", "lineItems": [{"id": "1f9a9ea0-985e-11f0-8d2c-07b2a010202c"}]}]	\N	0.00	\N	[]	f
8144	cb102381-9855-11f0-84dc-a77b677a2f6a	\N	\N	2025-09-23 08:20:14.727	Gotowe do realizacji	allegro-pl	87799536	Client:87799536	drz5rxjbyk+1f8bb1766@allegromail.pl	\N	Monika Łuba	+48 731 648 898	Bohaterów Warszawy 33/36	07-410	Ostroleka	PL	cb656fb8-9855-11f0-a227-735d10b96dc7	PAID	AF	t	780.00	PLN	Allegro Kurier DPD	0.00	PLN	780.00	PLN	\N	t	\N	2025-09-23 08:20:14.727	\N	2025-10-10 09:06:45.08619	ONLINE	f	[{"id": "RFBEOjEwMjYwNzI4NDU3OThV", "waybill": "1026072845798U", "carrierId": "DPD", "createdAt": "2025-09-23T09:39:47.116Z", "lineItems": [{"id": "cb02dd11-9855-11f0-84dc-a77b677a2f6a"}]}, {"id": "RFBEOjEwMjYwNzI4NDU4MzhV", "waybill": "1026072845838U", "carrierId": "DPD", "createdAt": "2025-09-23T09:39:47.316Z", "lineItems": [{"id": "cb02dd11-9855-11f0-84dc-a77b677a2f6a"}]}]	\N	0.00	\N	[]	f
8145	ca8f45a0-9853-11f0-a2fa-3f11a044b83d	\N	\N	2025-09-23 08:05:04.147	Gotowe do realizacji	allegro-pl	2519180	Emii1	wg7g40bfku+56477b771@allegromail.pl	\N	Emilia Romanowska	+48 602 491 340	Ełcka 1	19-500	Gołdap	PL	df67bb21-9853-11f0-84ba-8f13ba8ab30b	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	427.99	PLN	TH1 - Tkanina Hugo Czarny	t	\N	2025-09-23 08:05:04.147	\N	2025-10-10 09:06:46.188299	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYxNjMzOTcxODhV", "waybill": "1026163397188U", "carrierId": "DPD", "createdAt": "2025-09-24T11:56:58.255Z", "lineItems": [{"id": "ca89ee70-9853-11f0-a2fa-3f11a044b83d"}]}]	\N	0.00	\N	[]	f
8146	31aee0d0-9852-11f0-b55d-c5913dafd975	\N	\N	2025-09-23 08:00:37.621	Gotowe do realizacji	allegro-pl	15862937	sobota2222	j8tpsfey1m+260579a54@allegromail.pl	\N	Martyna Wiśniewska	+48 514 865 436	Rówce 54	08-106	Rówce	PL	59aceb10-9852-11f0-9b3c-6d378382b973	PAID	PAYU	t	555.00	PLN	Allegro Kurier DPD	0.00	PLN	555.00	PLN	witam prosze siedzisko w kolorze WE3 - Welur Grafitowy	t	\N	2025-09-23 08:00:37.621	\N	2025-10-10 09:06:47.281936	ONLINE	f	[{"id": "RFBEOjEwMjYwNzMwNTI3NjJV", "waybill": "1026073052762U", "carrierId": "DPD", "createdAt": "2025-09-23T09:41:23.035Z", "lineItems": [{"id": "31a9b0b1-9852-11f0-b55d-c5913dafd975"}, {"id": "31a9b0b0-9852-11f0-b55d-c5913dafd975"}]}]	\N	0.00	\N	[]	f
8199	65cb6780-a5b8-11f0-b9cd-8fc0f1f312f6	\N	\N	2025-10-10 09:08:24.312	Gotowe do realizacji	allegro-pl	45031064	patros1211992	auxx40hxzx+323f29ba6@allegromail.pl	\N	patryk obuchowski	+48 505 386 460	Przemysłowa 10/18b m.3	09-300	Żuromin	PL	65f0f125-a5b8-11f0-91d4-7961b40d7b05	PAID	P24	t	324.20	PLN	Allegro Kurier DPD	0.00	PLN	324.20	PLN	tkanina thp1 hugo pik grafit 	t	\N	2025-10-10 09:08:24.312	\N	2025-10-10 09:08:45.056978	ONLINE	f	[]	\N	0.00	\N	[]	f
8149	35e22e10-9801-11f0-8d2c-07b2a010202c	\N	\N	2025-09-22 22:21:38.702	Gotowe do realizacji	allegro-pl	10036281	wojaugust	f54gx5uz4t+1cd731a53@allegromail.pl	\N	Wojciech Augustyniak	+48 607 566 811	Białostocka 24/17	03-741	Warszawa	PL	36400610-9801-11f0-9e7d-57cd1a851063	PAID	P24	t	1947.00	PLN	Allegro Kurier DPD	0.00	PLN	1947.00	PLN	Eko skóra jasno szary ES2,\nwieszaki w kolorze H1 czarny.\nDziękuję :)	t	\N	2025-09-22 22:21:38.702	\N	2025-10-10 09:06:50.872419	ONLINE	f	[{"id": "RFBEOjEwMjYwNzkwNjY3OTJV", "waybill": "1026079066792U", "carrierId": "DPD", "createdAt": "2025-09-23T10:31:54Z", "lineItems": [{"id": "35dab400-9801-11f0-8d2c-07b2a010202c"}]}, {"id": "RFBEOjEwMjYwNzkwNjY4MzJV", "waybill": "1026079066832U", "carrierId": "DPD", "createdAt": "2025-09-23T10:31:56Z", "lineItems": [{"id": "35dab400-9801-11f0-8d2c-07b2a010202c"}]}, {"id": "RFBEOjEwMjYwNzkwNjY5ODFV", "waybill": "1026079066981U", "carrierId": "DPD", "createdAt": "2025-09-23T10:31:56Z", "lineItems": [{"id": "35dab400-9801-11f0-8d2c-07b2a010202c"}]}, {"id": "RFBEOjEwMjYwNzkwNjcwODBV", "waybill": "1026079067080U", "carrierId": "DPD", "createdAt": "2025-09-23T10:31:56Z", "lineItems": [{"id": "35dab400-9801-11f0-8d2c-07b2a010202c"}]}]	\N	0.00	\N	[]	f
8150	288f4de0-97f4-11f0-b6af-bb22abd5a541	\N	\N	2025-09-22 20:41:38.694	Gotowe do realizacji	allegro-pl	38257086	TheFlamelin	dk9twg7cay+26b63c466@allegromail.pl	\N	Karolina Adamska	+48 601 962 473	Półłanki 18 / klatka B	30-740	Kraków	PL	6339503f-97f4-11f0-ab95-f7c208471a67	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1347.99	PLN	Kolor obicia: WE3 - Welur Grafitowy\nKolor haków: H1 - Czarny	t	\N	2025-09-22 20:41:38.694	\N	2025-10-10 09:06:52.039093	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjYwNzk3NzMxODNV", "waybill": "1026079773183U", "carrierId": "DPD", "createdAt": "2025-09-23T10:38:23.594Z", "lineItems": [{"id": "288821f0-97f4-11f0-b6af-bb22abd5a541"}]}, {"id": "RFBEOjEwMjYwNzk3NzMyNjNV", "waybill": "1026079773263U", "carrierId": "DPD", "createdAt": "2025-09-23T10:38:23.784Z", "lineItems": [{"id": "288821f0-97f4-11f0-b6af-bb22abd5a541"}]}, {"id": "RFBEOjEwMjYwNzk3NzMzMTRV", "waybill": "1026079773314U", "carrierId": "DPD", "createdAt": "2025-09-23T10:38:23.953Z", "lineItems": [{"id": "288821f0-97f4-11f0-b6af-bb22abd5a541"}]}]	\N	0.00	\N	[]	f
8151	947e7280-97f2-11f0-a86f-afea5d07ba6b	\N	\N	2025-09-22 20:29:56.767	Gotowe do realizacji	allegro-pl	124687483	Client:124687483	km807e6iih+128110e60@allegromail.pl	\N	Aniela Wypych	+48 661 672 808	Wierzbica Górna 69b	46-250	Wierzbica Górna	PL	c6c6c3f0-97f2-11f0-89e8-3f9d4e258057	PAID	P24	t	369.00	PLN	Kurier DPD	17.00	PLN	369.00	PLN	kolor dąb Sonoma 	f	\N	2025-09-22 20:29:56.767	\N	2025-10-10 09:06:53.142032	ONLINE	f	[{"id": "RFBEOjEwMjYwNzk5Mjc3MTFV", "waybill": "1026079927711U", "carrierId": "DPD", "createdAt": "2025-09-23T10:39:47.164Z", "lineItems": [{"id": "94765c30-97f2-11f0-a86f-afea5d07ba6b"}]}]	\N	0.00	\N	[]	f
8152	10c69e50-97f1-11f0-b6af-bb22abd5a541	\N	\N	2025-09-22 20:18:25.55	Gotowe do realizacji	allegro-pl	4978888	godzik7	x30c4piwlc+3991ac470@allegromail.pl	\N	Małgorzata Władczyk	+48 693 876 775	Os. Polan 2/1	61-253	Poznań	PL	13d95d27-97f1-11f0-9e7d-57cd1a851063	PAID	P24	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	\N	t	\N	2025-09-22 20:18:25.55	\N	2025-10-10 09:06:54.278609	ONLINE	f	[{"id": "RFBEOjEwMjYwODAwNjY4ODhV", "waybill": "1026080066888U", "carrierId": "DPD", "createdAt": "2025-09-23T10:40:57.879Z", "lineItems": [{"id": "10bf7260-97f1-11f0-b6af-bb22abd5a541"}]}]	\N	0.00	\N	[]	f
8153	ddecb5d0-97e8-11f0-9f02-6d91e0050fd1	\N	\N	2025-09-22 19:19:06.511	Gotowe do realizacji	allegro-pl	72609242	Anna820202	eiju7khyof+63d54ea38@allegromail.pl	\N	Anna  Muszarska 	+48 506 531 117	Krzemieniewo 3A	13-306	Kurzętnik	PL	e136d7d1-97e8-11f0-ab95-f7c208471a67	PAID	PAYU	t	476.99	PLN	Allegro Kurier DPD	14.99	PLN	476.99	PLN	\N	f	\N	2025-09-22 19:19:06.511	\N	2025-10-10 09:06:55.42166	ONLINE	f	[{"id": "RFBEOjEwMjYwODE4NDYyNTRV", "waybill": "1026081846254U", "carrierId": "DPD", "createdAt": "2025-09-23T10:56:53.521Z", "lineItems": [{"id": "dde7d3d0-97e8-11f0-9f02-6d91e0050fd1"}]}]	\N	0.00	\N	[]	f
8154	6a382f10-97e4-11f0-aede-817e60f99fcc	\N	\N	2025-09-22 18:46:56.291	Gotowe do realizacji	allegro-pl	3638816	gesia-g1	wgqgvv4s8z+3ae127ff6@allegromail.pl	\N	grzegorz dragan	+48 502 376 894	Stary Wiśnicz 214 / 214	32-720	Nowy Wiśnicz	PL	6a68677f-97e4-11f0-a8d5-39d7fba26715	PAID	P24	t	860.00	PLN	Allegro Kurier DPD	0.00	PLN	860.00	PLN	\N	t	\N	2025-09-22 18:46:56.291	\N	2025-10-10 09:06:56.557342	ONLINE	f	[{"id": "RFBEOjEwMjYwODUyOTg4NzNV", "waybill": "1026085298873U", "carrierId": "DPD", "createdAt": "2025-09-23T11:29:15.993Z", "lineItems": [{"id": "6a30dc10-97e4-11f0-aede-817e60f99fcc"}]}, {"id": "RFBEOjEwMjYwODUyOTg5MjBV", "waybill": "1026085298920U", "carrierId": "DPD", "createdAt": "2025-09-23T11:29:16.192Z", "lineItems": [{"id": "6a30dc10-97e4-11f0-aede-817e60f99fcc"}]}]	\N	0.00	\N	[]	f
8155	c40f1ae0-97e3-11f0-8e9a-934b2f282e95	\N	\N	2025-09-22 18:43:04.122	Gotowe do realizacji	allegro-pl	49894000	Client:49894000	wttm3lzn0b+9ad92611@allegromail.pl	\N	Krzysztof Brzeziński	+48 609 180 294	Cypryjska 2/14	75-430	Koszalin	PL	c447b7af-97e3-11f0-84ba-8f13ba8ab30b	PAID	AF	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Poproszę tkaninę THP1 Hugo Pik Grafit	t	\N	2025-09-22 18:43:04.122	\N	2025-10-10 09:06:57.697894	ONLINE	f	[{"id": "RFBEOjEwMjYwNDEzMDM4MDZV", "waybill": "1026041303806U", "carrierId": "DPD", "createdAt": "2025-09-23T05:13:06Z", "lineItems": [{"id": "c40a5ff0-97e3-11f0-8e9a-934b2f282e95"}]}]	\N	0.00	\N	[]	f
8156	c7303860-97e0-11f0-8e9a-934b2f282e95	\N	\N	2025-09-22 18:37:25.91	Gotowe do realizacji	allegro-pl	2389679	figura224	fu1wgpsdqy+2899d7507@allegromail.pl	\N	Dorota Figurska	+48 517 547 991	Bankowa 11 A / 12	72-010	Police	PL	20fd0b3a-97e3-11f0-89e8-3f9d4e258057	PAID	AF	t	1497.00	PLN	Allegro Kurier DPD	0.00	PLN	1497.00	PLN	Uchwyt U1\nHaki  H1\nPanel  ES1\nDrzwi otwierane na prawą stronę 	t	\N	2025-09-22 18:37:25.91	\N	2025-10-10 09:06:59.491131	ONLINE	f	[{"id": "RFBEOjEwMjYwODU1MDA3OTFV", "waybill": "1026085500791U", "carrierId": "DPD", "createdAt": "2025-09-23T11:31:05.251Z", "lineItems": [{"id": "c72b7d70-97e0-11f0-8e9a-934b2f282e95"}]}, {"id": "RFBEOjEwMjYwODU1MDA4MDNV", "waybill": "1026085500803U", "carrierId": "DPD", "createdAt": "2025-09-23T11:31:05.590Z", "lineItems": [{"id": "c72b7d70-97e0-11f0-8e9a-934b2f282e95"}]}, {"id": "RFBEOjEwMjYwODU1MDA5ODZV", "waybill": "1026085500986U", "carrierId": "DPD", "createdAt": "2025-09-23T11:31:05.981Z", "lineItems": [{"id": "c72b7d70-97e0-11f0-8e9a-934b2f282e95"}]}]	\N	0.00	\N	[]	f
8223	38769ce0-8c82-11f0-a374-2b3f33c8293d	\N	\N	2025-09-08 07:06:40.926	Gotowe do realizacji	allegro-pl	21530353	ANET_ET4	6enrli1l8v+6bc214427@allegromail.pl	\N	Aneta Kuśmierzak	+48 660 673 088	Norwida 6 / 25	21-040	Świdnik	PL	3da47384-8c82-11f0-ae14-79075022611d	PAID	AF	t	418.00	PLN	Allegro Kurier DPD	0.00	PLN	418.00	PLN	\N	t	\N	2025-09-08 07:06:40.926	\N	2025-10-10 09:09:13.790623	ONLINE	f	[{"id": "RFBEOjEwMjUyNTg3MTYyMjdV", "waybill": "1025258716227U", "carrierId": "DPD", "createdAt": "2025-09-10T10:16:05.350Z", "lineItems": [{"id": "3870a970-8c82-11f0-a374-2b3f33c8293d"}]}]	\N	0.00	\N	[]	f
8212	bf3852e0-8cc9-11f0-99cf-ab03232da32c	\N	\N	2025-09-08 15:38:58.438	Gotowe do realizacji	allegro-pl	107414445	Client:107414445	mzr5lbl7be+1e2b61946@allegromail.pl	\N	Karolina Brewczyńska	+48 508 618 268	Karolina,ul zdrojowa, 17	05-300	Mińsk Mazowiecki	PL	c9c59701-8cc9-11f0-a511-b3d4cdf381f7	PAID	P24	t	366.99	PLN	Allegro Kurier DPD	14.99	PLN	366.99	PLN	\N	f	\N	2025-09-08 15:38:58.438	\N	2025-10-10 09:09:00.687175	ONLINE	f	[{"id": "RFBEOjEwMjUyNTU4NjY0MjBV", "waybill": "1025255866420U", "carrierId": "DPD", "createdAt": "2025-09-10T09:53:57.284Z", "lineItems": [{"id": "bf3322c0-8cc9-11f0-99cf-ab03232da32c"}]}]	\N	0.00	\N	[]	f
8157	313264a0-97e0-11f0-8d2c-07b2a010202c	\N	\N	2025-09-22 18:22:59.649	Gotowe do realizacji	allegro-pl	15917310	agapluta73	xxskdvy8dc+6c3d0ca57@allegromail.pl	\N	Agnieszka Pluta	+48 692 839 661	ul. Grunwaldzka 7c/10	73-200	Choszczno	PL	992d8199-97e0-11f0-9e7d-57cd1a851063	PAID	P24	t	1405.99	PLN	Allegro Kurier DPD	14.99	PLN	1405.99	PLN	Siedzisko i panele  proszę obić materiałem WE2 -Welur jasno szary	f	\N	2025-09-22 18:22:59.649	\N	2025-10-10 09:07:00.673569	ONLINE	f	[{"id": "RFBEOjEwMjYwNDEzODA3MjNV", "waybill": "1026041380723U", "carrierId": "DPD", "createdAt": "2025-09-23T05:14:06.087Z", "lineItems": [{"id": "312aea90-97e0-11f0-8d2c-07b2a010202c"}]}, {"id": "RFBEOjEwMjYwNDEzODA4MTFV", "waybill": "1026041380811U", "carrierId": "DPD", "createdAt": "2025-09-23T05:14:06.278Z", "lineItems": [{"id": "312aea90-97e0-11f0-8d2c-07b2a010202c"}]}, {"id": "RFBEOjEwMjYwNDEzODA5MzRV", "waybill": "1026041380934U", "carrierId": "DPD", "createdAt": "2025-09-23T05:14:06.457Z", "lineItems": [{"id": "312aea90-97e0-11f0-8d2c-07b2a010202c"}]}]	\N	0.00	\N	[]	f
8158	9ac75020-97df-11f0-af8d-a355c40aec5a	\N	\N	2025-09-22 18:12:35.502	Gotowe do realizacji	allegro-pl	15380985	ddaww	6gqtpaj0z9+68974e515@allegromail.pl	\N	Dawid Ciesiński	+48 533 822 161	Legnicka 21A	41-811	Zabrze	PL	ae47885c-97df-11f0-89e8-3f9d4e258057	PAID	PAYU	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-09-22 18:12:35.502	\N	2025-10-10 09:07:01.798412	ONLINE	t	[{"id": "RFBEOjEwMjYwODc0NDkzNDVV", "waybill": "1026087449345U", "carrierId": "DPD", "createdAt": "2025-09-23T11:51:03.736Z", "lineItems": [{"id": "9ac2e350-97df-11f0-af8d-a355c40aec5a"}]}]	Legnicka 21A	0.00	\N	[]	f
8159	746a06b0-97d1-11f0-8e9a-934b2f282e95	\N	\N	2025-09-22 16:31:56.636	Gotowe do realizacji	allegro-pl	7615949	sz_magdalena	rogxmt573j+4291b9265@allegromail.pl	\N	Magdalena Kwiatek	+48 500 457 084	Nadrzeczna 56	24-120	Kazimierz Dolny	PL	74aa1d99-97d1-11f0-ab95-f7c208471a67	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	WE1	t	\N	2025-09-22 16:31:56.636	\N	2025-10-10 09:07:02.93287	ONLINE	f	[{"id": "RFBEOjEwMjYxMjg5MTU0ODdV", "waybill": "1026128915487U", "carrierId": "DPD", "createdAt": "2025-09-24T06:55:36.075Z", "lineItems": [{"id": "74646160-97d1-11f0-8e9a-934b2f282e95"}]}]	\N	0.00	\N	[]	f
8160	89f657a0-97d0-11f0-9447-998c918710a1	\N	\N	2025-09-22 16:24:49.012	Gotowe do realizacji	allegro-pl	3988932	darek2412	xpxrdpele6+40cd83981@allegromail.pl	\N	darek wardzala	+48 791 600 637	Bitw o Wał Pomorski 2 / 30	33-100	TARNÓW	PL	8a36bcbd-97d0-11f0-b342-951817195fc2	PAID	P24	t	1015.00	PLN	Allegro Kurier DPD	0.00	PLN	1015.00	PLN	\N	t	\N	2025-09-22 16:24:49.012	\N	2025-10-10 09:07:04.20065	ONLINE	f	[{"id": "RFBEOjEwMjYxMjg2Njg3MDlV", "waybill": "1026128668709U", "carrierId": "DPD", "createdAt": "2025-09-24T06:53:33Z", "lineItems": [{"id": "89ee8f70-97d0-11f0-9447-998c918710a1"}]}, {"id": "RFBEOjEwMjYxMjg2Njg4OTdV", "waybill": "1026128668897U", "carrierId": "DPD", "createdAt": "2025-09-24T06:53:33Z", "lineItems": [{"id": "89ee8f70-97d0-11f0-9447-998c918710a1"}]}]	\N	0.00	\N	[]	f
8161	9ebd12d0-97c8-11f0-9481-5f95c6e804a5	\N	\N	2025-09-23 14:56:35.92	Gotowe do realizacji	allegro-pl	43336364	Kins_o	ratvbm25yz+39f530747@allegromail.pl	\N	Kinga Kasjan	+48 698 152 634	Piłsudskiego 44A	10-450	Olsztyn	PL	7425a4fb-988d-11f0-89e8-3f9d4e258057	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Obicie siedziska THP1 - tkanina hugo pikowana grafit	t	\N	2025-09-23 14:56:35.92	\N	2025-10-10 09:07:05.33329	ONLINE	f	[{"id": "RFBEOjEwMjYxMjMyMTc1MDhV", "waybill": "1026123217508U", "carrierId": "DPD", "createdAt": "2025-09-24T06:06:31.341Z", "lineItems": [{"id": "9eb830d0-97c8-11f0-9481-5f95c6e804a5"}]}]	\N	0.00	\N	[]	f
8162	eabdfd00-97c0-11f0-a361-4580bffe9bea	\N	\N	2025-09-22 14:33:37.626	Gotowe do realizacji	allegro-pl	49522219	Client:49522219	mmb9x9vuy4+68d9126e9@allegromail.pl	\N	Karolina Jagielska	+48 797 355 102	Podgórna 31A / 24	65-213	Zielona gora	PL	eae3ae40-97c0-11f0-83b2-ff1b510348d5	PAID	AF	t	1404.98	PLN	Allegro Kurier DPD	29.98	PLN	1404.98	PLN	Dzień dobry, proszę o obicie siedziska: WE1 - Welur Czarny\nOraz zapytanie kuriera czy mógłby paczkę przynieść pod drzwi mieszkania? Z góry bardzo dziękuję 	f	\N	2025-09-22 14:33:37.626	\N	2025-10-10 09:07:06.455095	ONLINE	f	[{"id": "RFBEOjEwMjYxMjA3MjIyNjZV", "waybill": "1026120722266U", "carrierId": "DPD", "createdAt": "2025-09-24T05:38:21.396Z", "lineItems": [{"id": "eab8f3f1-97c0-11f0-a361-4580bffe9bea"}, {"id": "eab8f3f0-97c0-11f0-a361-4580bffe9bea"}]}, {"id": "RFBEOjEwMjYxMjA3MjIzNDdV", "waybill": "1026120722347U", "carrierId": "DPD", "createdAt": "2025-09-24T05:38:21.573Z", "lineItems": [{"id": "eab8f3f1-97c0-11f0-a361-4580bffe9bea"}, {"id": "eab8f3f0-97c0-11f0-a361-4580bffe9bea"}]}, {"id": "RFBEOjEwMjYxMjA3MjI0ODJV", "waybill": "1026120722482U", "carrierId": "DPD", "createdAt": "2025-09-24T05:38:21.737Z", "lineItems": [{"id": "eab8f3f1-97c0-11f0-a361-4580bffe9bea"}, {"id": "eab8f3f0-97c0-11f0-a361-4580bffe9bea"}]}, {"id": "RFBEOjEwMjYxMjA3MjI1MDdV", "waybill": "1026120722507U", "carrierId": "DPD", "createdAt": "2025-09-24T05:38:21.902Z", "lineItems": [{"id": "eab8f3f1-97c0-11f0-a361-4580bffe9bea"}, {"id": "eab8f3f0-97c0-11f0-a361-4580bffe9bea"}]}]	\N	0.00	\N	[]	f
8163	e85e5ef0-97bc-11f0-8e9a-934b2f282e95	\N	\N	2025-09-22 14:06:13.01	Gotowe do realizacji	allegro-pl	1947068	krzychu1964	tvjo8fpkhd+6d4f2e76@allegromail.pl	\N	KRZYSZTOF ZAŁĘGA	+48 601 299 691	UL.SŁOWACKIEGO 5A/13	59-500	ZŁOTORYJA	PL	e88855d8-97bc-11f0-b696-83e986182cb3	PAID	AF	t	352.00	PLN	Allegro Kurier DPD	0.00	PLN	352.00	PLN	proszę o kolor dąb Sonoma	t	\N	2025-09-22 14:06:13.01	\N	2025-10-10 09:07:07.711963	ONLINE	f	[{"id": "RFBEOjEwMjYxMjU4MDk0NjNV", "waybill": "1026125809463U", "carrierId": "DPD", "createdAt": "2025-09-24T06:29:14Z", "lineItems": [{"id": "e8597cf0-97bc-11f0-8e9a-934b2f282e95"}]}]	\N	0.00	\N	[]	f
8164	bead6790-97b7-11f0-a0cf-655d3976444d	\N	\N	2025-09-22 13:28:00.374	Gotowe do realizacji	allegro-pl	34475115	Client:34475115	ergha791h9+172efba90@allegromail.pl	\N	Marzena Wlaźnik	+48 788 110 750	Uleniec 56a	05-600	Grójec	PL	c46e7d12-97b7-11f0-b86e-1b5b7eacb18d	PAID	AF	t	665.00	PLN	Allegro Kurier DPD	0.00	PLN	665.00	PLN	\N	t	\N	2025-09-22 13:28:00.374	\N	2025-10-10 09:07:08.807329	ONLINE	f	[{"id": "RFBEOjEwMjYxMjcwNjIzOTRV", "waybill": "1026127062394U", "carrierId": "DPD", "createdAt": "2025-09-24T06:39:50Z", "lineItems": [{"id": "bea8d3b0-97b7-11f0-a0cf-655d3976444d"}]}, {"id": "RFBEOjEwMjYxMjcwNjI0NzFV", "waybill": "1026127062471U", "carrierId": "DPD", "createdAt": "2025-09-24T06:39:50Z", "lineItems": [{"id": "bea8d3b0-97b7-11f0-a0cf-655d3976444d"}]}, {"id": "RFBEOjEwMjY0MDcyMDUwOTdV", "waybill": "1026407205097U", "carrierId": "DPD", "createdAt": "2025-09-29T08:35:15.246Z", "lineItems": [{"id": "bea8d3b0-97b7-11f0-a0cf-655d3976444d"}]}]	\N	0.00	\N	[]	f
8165	728a1760-97b6-11f0-9f34-dd75279ca6e9	\N	\N	2025-09-22 13:18:43.09	Gotowe do realizacji	allegro-pl	81760332	Client:81760332	crfe724ysp+3f50ea997@allegromail.pl	\N	Julia Zielińska	+48 603 040 277	Gębarzewska 19	62-200	Gniezno	PL	72f18c36-97b6-11f0-9d49-ab93028d0197	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	WE1 siedzisko czarne welur	t	\N	2025-09-22 13:18:43.09	\N	2025-10-10 09:07:09.942368	ONLINE	f	[{"id": "RFBEOjEwMjYwNDE0NzU0MTNV", "waybill": "1026041475413U", "carrierId": "DPD", "createdAt": "2025-09-23T05:15:18.344Z", "lineItems": [{"id": "72829d50-97b6-11f0-9f34-dd75279ca6e9"}]}]	\N	0.00	\N	[]	f
8378	432c9eb0-a644-11f0-a685-3b2ebe8a80a1	\N	\N	2025-10-11 01:47:54.692	Gotowe do realizacji	allegro-pl	101017919	Client:101017919	3kx0spma98+57c8c89a4@allegromail.pl	\N	Iwona Sabiniarz	+48 577 888 056	Gackowskiego, 1C/31	85-137	Bydgoszcz	PL	4343f77f-a644-11f0-bdd7-1b3dfdcd18cd	PAID	AF	t	671.00	PLN	Allegro Kurier DPD	0.00	PLN	671.00	PLN	\N	t	\N	2025-10-11 01:47:54.692	\N	2025-10-11 08:52:50.680393	ONLINE	f	[]	\N	0.00	\N	[]	f
8167	e60f8130-97a1-11f0-b4ff-d384dc24cd83	\N	\N	2025-09-22 10:53:00.575	Gotowe do realizacji	allegro-pl	7180603	izunia_un	69nmnq0n3b+1383c56e4@allegromail.pl	\N	Izabela Kloskowska	+48 725 008 711	WIELKI PODLEŚ 126 B	83-423	WIELKI PODLEŚ	PL	e64d9c2c-97a1-11f0-a319-254cb819ea06	PAID	AF	t	788.00	PLN	Allegro Kurier DPD	0.00	PLN	788.00	PLN	\N	t	\N	2025-09-22 10:53:00.575	\N	2025-10-10 09:07:12.171352	ONLINE	f	[{"id": "RFBEOjEwMjYxMjk0NDI2ODdV", "waybill": "1026129442687U", "carrierId": "DPD", "createdAt": "2025-09-24T06:59:59.616Z", "lineItems": [{"id": "e60791f0-97a1-11f0-b4ff-d384dc24cd83"}]}, {"id": "RFBEOjEwMjYxMjk0NDI3MDJV", "waybill": "1026129442702U", "carrierId": "DPD", "createdAt": "2025-09-24T06:59:59.780Z", "lineItems": [{"id": "e60791f0-97a1-11f0-b4ff-d384dc24cd83"}]}]	\N	0.00	\N	[]	f
8168	be5ee420-9790-11f0-a86f-afea5d07ba6b	\N	\N	2025-09-22 08:51:56.397	Gotowe do realizacji	allegro-pl	21228892	nereczki	j5akr0vrgo+dabadb32@allegromail.pl	\N	Ewelina Dąbkowska	+48 516 121 873	Trakt Dębski 50B	05-311	Kobierne	PL	4f8e8edc-9791-11f0-ba02-7108b32bb1ab	PAID	AF	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	Kolor WE3	t	\N	2025-09-22 08:51:56.397	\N	2025-10-10 09:07:13.260801	ONLINE	f	[{"id": "RFBEOjEwMjYwNDk2ODYwOTJV", "waybill": "1026049686092U", "carrierId": "DPD", "createdAt": "2025-09-23T06:36:59.805Z", "lineItems": [{"id": "be56f4e0-9790-11f0-a86f-afea5d07ba6b"}]}]	\N	0.00	\N	[]	f
8169	3c6ba350-978f-11f0-bf40-d93b8aae3dee	\N	\N	2025-09-22 08:37:49.705	Gotowe do realizacji	allegro-pl	41845818	Client:41845818	5pkexntrzr+7d3a11141@allegromail.pl	\N	Ewelina Migała 	+48 735 742 541	Łąkta Górna 129	32-731	Żegocina	PL	3c930242-978f-11f0-ba02-7108b32bb1ab	PAID	AF	t	1493.00	PLN	Allegro Kurier DPD	0.00	PLN	1493.00	PLN	Dzień dobry poproszę obicie w kolorze czarny welur oraz czarne wieszaki 	t	\N	2025-09-22 08:37:49.705	\N	2025-10-10 09:07:14.363358	ONLINE	f	[{"id": "RFBEOjEwMjYwNDkzNDgwNjRV", "waybill": "1026049348064U", "carrierId": "DPD", "createdAt": "2025-09-23T06:34:09.339Z", "lineItems": [{"id": "3c675d90-978f-11f0-bf40-d93b8aae3dee"}]}, {"id": "RFBEOjEwMjYwNDkzNDgxNTdV", "waybill": "1026049348157U", "carrierId": "DPD", "createdAt": "2025-09-23T06:34:09.525Z", "lineItems": [{"id": "3c675d90-978f-11f0-bf40-d93b8aae3dee"}]}, {"id": "RFBEOjEwMjYwNDkzNDgyNzdV", "waybill": "1026049348277U", "carrierId": "DPD", "createdAt": "2025-09-23T06:34:09.700Z", "lineItems": [{"id": "3c675d90-978f-11f0-bf40-d93b8aae3dee"}]}]	\N	0.00	\N	[]	f
8170	30c3c1c0-9787-11f0-bf40-d93b8aae3dee	\N	\N	2025-09-22 07:49:09.424	Gotowe do realizacji	allegro-pl	2059814	agata-jaskola	i2121u3rn5+3a0237e65@allegromail.pl	\N	Agata JASKÓLSKA-GOZDEK	+48 797 138 445	Burdąg 178 / 5	12-122	Burdąg	PL	91beea96-9788-11f0-a319-254cb819ea06	PAID	PAYU	t	418.00	PLN	Allegro Kurier DPD	0.00	PLN	418.00	PLN	Dostawa do domku letniskowego, w pobliżu adresu Burdąg 85c	t	\N	2025-09-22 07:49:09.424	\N	2025-10-10 09:07:15.495914	ONLINE	f	[{"id": "RFBEOjEwMjYwNDg4Nzc2NTBV", "waybill": "1026048877650U", "carrierId": "DPD", "createdAt": "2025-09-23T06:30:21.268Z", "lineItems": [{"id": "30bf2de0-9787-11f0-bf40-d93b8aae3dee"}]}]	\N	0.00	\N	[]	f
8171	c00fd400-9786-11f0-9588-2bb9af9f5e5e	\N	\N	2025-09-22 07:38:14.172	Gotowe do realizacji	allegro-pl	12239106	baarteeq	lqixkfcn0o+551c5ea17@allegromail.pl	\N	Bartosz Babiak	+48 515 281 275	Nowowiejskiego 2 / 26	62-510	KONIN	PL	c0370bcd-9786-11f0-ba02-7108b32bb1ab	PAID	PAYU	t	229.00	PLN	Allegro Kurier DPD	0.00	PLN	229.00	PLN	Dzień dobry, w nawiązaniu do dzisiejszej rozmowy telefonicznej proszę o szybką realizację zamówienia oraz wysyłkę. Proszę również o dołączenie do paczki próbki WOTAN.\nZ góry serdecznie dziekuję.	t	\N	2025-09-22 07:38:14.172	\N	2025-10-10 09:07:16.617547	ONLINE	f	[{"id": "RFBEOjEwMjU5ODA2NzU4NDhV", "waybill": "1025980675848U", "carrierId": "DPD", "createdAt": "2025-09-22T08:46:30.501Z", "lineItems": [{"id": "c00bb550-9786-11f0-9588-2bb9af9f5e5e"}]}, {"id": "RFBEOjEwMjYwNDA1MjkyODhV", "waybill": "1026040529288U", "carrierId": "DPD", "createdAt": "2025-09-23T05:09:56Z", "lineItems": [{"id": "c00bb550-9786-11f0-9588-2bb9af9f5e5e"}]}]	\N	0.00	\N	[]	f
8172	057c0520-977f-11f0-84dc-a77b677a2f6a	\N	\N	2025-09-22 06:46:18.238	Gotowe do realizacji	allegro-pl	48645957	Client:48645957	wvx4q3ftfu+69f07edc6@allegromail.pl	\N	Urszula Biały	+48 880 510 630	Niechobrz 938	36-047	Niechobrz	PL	09c1c597-977f-11f0-a93f-67c1b7c59f83	PAID	P24	t	737.00	PLN	Allegro Kurier DPD	0.00	PLN	737.00	PLN	\N	t	\N	2025-09-22 06:46:18.238	\N	2025-10-10 09:07:17.733174	ONLINE	f	[{"id": "RFBEOjEwMjYwNDE5MDU3MzhV", "waybill": "1026041905738U", "carrierId": "DPD", "createdAt": "2025-09-23T05:20:36.967Z", "lineItems": [{"id": "0571f300-977f-11f0-84dc-a77b677a2f6a"}]}, {"id": "RFBEOjEwMjYwNDE5MDU4MjZV", "waybill": "1026041905826U", "carrierId": "DPD", "createdAt": "2025-09-23T05:20:37.235Z", "lineItems": [{"id": "0571f300-977f-11f0-84dc-a77b677a2f6a"}]}]	\N	0.00	\N	[]	f
8173	29d60250-977e-11f0-8de6-e172c4c355e0	\N	\N	2025-09-22 06:35:02.413	Gotowe do realizacji	allegro-pl	112016258	BuyBoxas	e743b2qu53+3a5c894d6@allegromail.pl	Buyboxas MB	BuyBoxas	+370 648 20196	Żytnia 86	05-850	Duchnice	PL	37a5ee41-977e-11f0-9d49-ab93028d0197	PAID	PAYU	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	please generate invoice.\n47353928	t	\N	2025-09-22 06:35:02.413	\N	2025-10-10 09:07:18.848739	ONLINE	t	[{"id": "RFBEOjEwMjYwNDIxMDU4ODBV", "waybill": "1026042105880U", "carrierId": "DPD", "createdAt": "2025-09-23T05:23:00Z", "lineItems": [{"id": "29ce8840-977e-11f0-8de6-e172c4c355e0"}]}]	Jazminų g. 2	0.00	\N	[]	f
8174	b94103b0-977c-11f0-af8d-a355c40aec5a	\N	\N	2025-09-22 06:24:37.589	Gotowe do realizacji	allegro-pl	112016258	BuyBoxas	e743b2qu53+12e350f58@allegromail.pl	Buyboxas MB	BuyBoxas	+370 648 20196	Żytnia 86	05-850	Duchnice	PL	c14ec884-977c-11f0-b696-83e986182cb3	PAID	PAYU	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	please generate invoice.\n\n47336363	t	\N	2025-09-22 06:24:37.589	\N	2025-10-10 09:07:19.975061	ONLINE	t	[{"id": "RFBEOjEwMjYwNDIyMzY0NDBV", "waybill": "1026042236440U", "carrierId": "DPD", "createdAt": "2025-09-23T05:24:39Z", "lineItems": [{"id": "b93b5e60-977c-11f0-af8d-a355c40aec5a"}]}]	Jazminų g. 2	0.00	\N	[]	f
8175	0b675310-9764-11f0-9447-998c918710a1	\N	\N	2025-09-22 03:28:21.883	Gotowe do realizacji	allegro-pl	17113083	dzasta8808	alf4plbey3+31810c345@allegromail.pl	\N	justyna kawecka	+48 669 421 479	Czasław 27	67-106	Czasław 27	PL	0d54f31b-9764-11f0-a319-254cb819ea06	PAID	AF	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	\N	t	\N	2025-09-22 03:28:21.883	\N	2025-10-10 09:07:21.078715	ONLINE	f	[{"id": "RFBEOjEwMjYwNDIzMjY4NjBV", "waybill": "1026042326860U", "carrierId": "DPD", "createdAt": "2025-09-23T05:25:37.354Z", "lineItems": [{"id": "0b609c50-9764-11f0-9447-998c918710a1"}]}]	\N	0.00	\N	[]	f
8176	72176e20-9763-11f0-9f34-dd75279ca6e9	\N	\N	2025-09-22 03:25:25.068	Gotowe do realizacji	allegro-pl	41204234	Client:41204234	xpirjhp8l7+7e7428186@allegromail.pl	\N	Magdalena Lasecka	+48 728 486 457	Jedności Narodowej 1-3/27	76-100	Sławno	PL	728599bd-9763-11f0-aacc-9fd26ccffebd	PAID	P24	t	532.00	PLN	Allegro Kurier DPD	0.00	PLN	532.00	PLN	\N	t	\N	2025-09-22 03:25:25.068	\N	2025-10-10 09:07:22.195712	ONLINE	f	[{"id": "RFBEOjEwMjYwNDIzOTY5NjhV", "waybill": "1026042396968U", "carrierId": "DPD", "createdAt": "2025-09-23T05:26:24.685Z", "lineItems": [{"id": "720e6d70-9763-11f0-9f34-dd75279ca6e9"}]}, {"id": "RFBEOjEwMjYwNDIzOTcwMjFV", "waybill": "1026042397021U", "carrierId": "DPD", "createdAt": "2025-09-23T05:26:24.873Z", "lineItems": [{"id": "720e6d70-9763-11f0-9f34-dd75279ca6e9"}]}]	\N	0.00	\N	[]	f
8380	7f958c50-a67f-11f0-a588-b391296a673a	\N	\N	2025-10-11 08:52:54.584	Gotowe do realizacji	allegro-pl	44484954	Client:44484954	tx80hvv1cp+4eafe7105@allegromail.pl	\N	Mirosława Szablewska	+48 530 874 092	Bydgoska 15/46	91-036	Łódź	PL	7fb45f4f-a67f-11f0-91d4-7961b40d7b05	PAID	P24	t	652.00	PLN	Allegro Kurier DPD	0.00	PLN	652.00	PLN	WE3	t	\N	2025-10-11 08:52:54.584	\N	2025-10-11 08:53:53.391493	ONLINE	f	[]	\N	0.00	\N	[]	f
8177	68c543e0-8e7d-11f0-a0cf-655d3976444d	\N	\N	2025-09-10 19:37:25.807	Gotowe do realizacji	allegro-pl	104017352	Client:104017352	q68tqsi9yw+4b4f245e9@allegromail.pl	\N	Damian Dziedzic	+48 690 987 472	Motyczno11	29-100	Wloszczowa	PL	68fb6f7f-8e7d-11f0-8e7f-55e86f66c26b	PAID	AF	t	788.00	PLN	Allegro Kurier DPD	0.00	PLN	788.00	PLN	\N	t	\N	2025-09-10 19:37:25.807	\N	2025-10-10 09:08:12.252069	ONLINE	f	[{"id": "RFBEOjEwMjU1Mjc2NjQ1OTZV", "waybill": "1025527664596U", "carrierId": "DPD", "createdAt": "2025-09-15T07:51:24.224Z", "lineItems": [{"id": "68beb430-8e7d-11f0-a0cf-655d3976444d"}]}, {"id": "RFBEOjEwMjU1Mjc2NjQ2NzZV", "waybill": "1025527664676U", "carrierId": "DPD", "createdAt": "2025-09-15T07:51:24.535Z", "lineItems": [{"id": "68beb430-8e7d-11f0-a0cf-655d3976444d"}]}]	\N	0.00	\N	[]	f
8178	60eda000-8e7c-11f0-af8d-a355c40aec5a	\N	\N	2025-09-10 19:30:15.919	Gotowe do realizacji	allegro-pl	89524740	Client:89524740	11qtomy494+21723ea99@allegromail.pl	\N	Roman Wielgus	+48 500 003 284	Mszadla Stara 41	26-704	Przyłęk	PL	61261572-8e7c-11f0-a95c-61bbd5a0d3a5	PAID	PAYU	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	Tkanina na siedzisko WE3	t	\N	2025-09-10 19:30:15.919	\N	2025-10-10 09:08:13.768633	ONLINE	f	[{"id": "RFBEOjEwMjU0MDkyNzA2MTRV", "waybill": "1025409270614U", "carrierId": "DPD", "createdAt": "2025-09-12T10:01:59Z", "lineItems": [{"id": "60e73760-8e7c-11f0-af8d-a355c40aec5a"}]}]	\N	0.00	\N	[]	f
8179	b2925390-8e74-11f0-aa1b-13ad1f244880	\N	\N	2025-09-10 18:36:34.358	Gotowe do realizacji	allegro-pl	34768244	Juliiia1991	7mkb9y6wok+494120e83@allegromail.pl	\N	Julia Czarnecka	+48 601 901 471	Dworska 10	64-030	Koszanowo	PL	bf745c93-8e74-11f0-a95c-61bbd5a0d3a5	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1196.99	PLN	Poproszę wszystkie panele ES1(czarna eco skórka), haki poproszę H1 (czarne). Płyta meblowa jak na zdjęciu (biała).	t	\N	2025-09-10 18:36:34.358	\N	2025-10-10 09:08:15.281997	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjU1Mjg1MDQ5NDhV", "waybill": "1025528504948U", "carrierId": "DPD", "createdAt": "2025-09-15T07:55:43.185Z", "lineItems": [{"id": "b28b0091-8e74-11f0-aa1b-13ad1f244880"}, {"id": "b28b0090-8e74-11f0-aa1b-13ad1f244880"}]}, {"id": "RFBEOjEwMjU1Mjg1MDUwMjlV", "waybill": "1025528505029U", "carrierId": "DPD", "createdAt": "2025-09-15T07:55:43.541Z", "lineItems": [{"id": "b28b0091-8e74-11f0-aa1b-13ad1f244880"}, {"id": "b28b0090-8e74-11f0-aa1b-13ad1f244880"}]}, {"id": "RFBEOjEwMjU1Mjg1MDUxMTZV", "waybill": "1025528505116U", "carrierId": "DPD", "createdAt": "2025-09-15T07:55:43.789Z", "lineItems": [{"id": "b28b0091-8e74-11f0-aa1b-13ad1f244880"}, {"id": "b28b0090-8e74-11f0-aa1b-13ad1f244880"}]}]	\N	0.00	\N	[]	f
8180	424b24a0-8e64-11f0-9661-81d63d825764	\N	\N	2025-09-10 16:41:34.408	Gotowe do realizacji	allegro-pl	34768244	Juliiia1991	7mkb9y6wok+50f9977d5@allegromail.pl	\N	Julia Czarnecka	+48 601 901 471	Dworska 10	64-030	Koszanowo	PL	42808d47-8e64-11f0-8938-6fc9c1096c5c	PAID	P24	t	169.00	PLN	Allegro Kurier DPD	0.00	PLN	169.00	PLN	Dzień dobry, poproszę wieszak dokładnie ten co na zdjęciu, czyli biały laminat i czarne wieszaki ( H1). Pozdrawiam	t	\N	2025-09-10 16:41:34.408	\N	2025-10-10 09:08:16.944249	ONLINE	f	[{"id": "RFBEOjEwMjU1MzM1MTQyOTZV", "waybill": "1025533514296U", "carrierId": "DPD", "createdAt": "2025-09-15T08:22:33.097Z", "lineItems": [{"id": "4244e310-8e64-11f0-9661-81d63d825764"}]}]	\N	0.00	\N	[]	f
8181	36b91b60-8e64-11f0-983b-35adfde55ba2	\N	\N	2025-09-10 16:36:24.803	Gotowe do realizacji	allegro-pl	16615407	bogusia_sg1	unsb2j1e80+759b8d4a8@allegromail.pl	\N	Bogusława Głuszyk	+48 668 451 471	Ignacego Krasickiego 3A	14-400	Pasłęk	PL	36d703a1-8e64-11f0-964d-83aea542bda6	PAID	P24	t	788.00	PLN	Allegro Kurier DPD	0.00	PLN	788.00	PLN	\N	t	\N	2025-09-10 16:36:24.803	\N	2025-10-10 09:08:18.401888	ONLINE	f	[{"id": "RFBEOjEwMjU1MzM2ODg5MzJV", "waybill": "1025533688932U", "carrierId": "DPD", "createdAt": "2025-09-15T08:23:23.072Z", "lineItems": [{"id": "36b23d90-8e64-11f0-983b-35adfde55ba2"}]}, {"id": "RFBEOjEwMjU1MzM2ODkwODFV", "waybill": "1025533689081U", "carrierId": "DPD", "createdAt": "2025-09-15T08:23:23.290Z", "lineItems": [{"id": "36b23d90-8e64-11f0-983b-35adfde55ba2"}]}]	\N	0.00	\N	[]	f
8182	d77dae90-8e63-11f0-93e3-59d3457a2277	\N	\N	2025-09-10 16:35:08.031	Gotowe do realizacji	allegro-pl	5341389	_mmd	eg747q8xar+7c10ca144@allegromail.pl	\N	Agnieszka Dutka	+48 509 789 030	Makowica 83	34-600	Limanowa	PL	d7afbb36-8e63-11f0-a95c-61bbd5a0d3a5	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Wersja siedziska: EP1 - Pik Szary , proszę o w miarę możliwości szybką wysyłkę.	t	\N	2025-09-10 16:35:08.031	\N	2025-10-10 09:08:19.848117	ONLINE	f	[{"id": "RFBEOjEwMjU0MDkzNjQ2MzZV", "waybill": "1025409364636U", "carrierId": "DPD", "createdAt": "2025-09-12T10:02:58.132Z", "lineItems": [{"id": "d7779410-8e63-11f0-93e3-59d3457a2277"}]}]	\N	0.00	\N	[]	f
8183	fb2f5440-8e56-11f0-983b-35adfde55ba2	\N	\N	2025-09-10 15:04:15.882	Gotowe do realizacji	allegro-pl	101281049	Client:101281049	nv8gxbswql+6c1b63b34@allegromail.pl	\N	Hanna Michalska	+48 791 990 180	Wilanowska 38	60-688	Poznań	PL	49ef3e8c-8e57-11f0-89b4-db2a3c3ca4b7	PAID	P24	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	ES2 - Eko skóra Jasno szary	t	\N	2025-09-10 15:04:15.882	\N	2025-10-10 09:08:21.318813	ONLINE	f	[{"id": "RFBEOjEwMjU1MzM5MDMzMjlV", "waybill": "1025533903329U", "carrierId": "DPD", "createdAt": "2025-09-15T08:24:29.632Z", "lineItems": [{"id": "fb289d80-8e56-11f0-983b-35adfde55ba2"}]}, {"id": "RFBEOjEwMjU1MzM5MDM0MDBV", "waybill": "1025533903400U", "carrierId": "DPD", "createdAt": "2025-09-15T08:24:29.859Z", "lineItems": [{"id": "fb289d80-8e56-11f0-983b-35adfde55ba2"}]}]	\N	0.00	\N	[]	f
8184	cdead5e0-8e51-11f0-9d9f-e176fe4b7fab	\N	\N	2025-09-10 14:25:23.64	Gotowe do realizacji	allegro-pl	89567832	Client:89567832	jo88wp00g5+10e6d72d9@allegromail.pl	\N	Maria Jędraszek	+48 535 215 186	Pl.Rydygiera 1	86-200	Chełmno	PL	e331280c-8e51-11f0-8938-6fc9c1096c5c	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	371.99	PLN	\N	f	\N	2025-09-10 14:25:23.64	\N	2025-10-10 09:08:22.772886	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjU1MzQzMjk1NDBV", "waybill": "1025534329540U", "carrierId": "DPD", "createdAt": "2025-09-15T08:26:42.263Z", "lineItems": [{"id": "cde1fc40-8e51-11f0-9d9f-e176fe4b7fab"}]}]	\N	0.00	\N	[]	f
8185	b9510b00-8e41-11f0-983b-35adfde55ba2	\N	\N	2025-09-10 12:31:31.472	Gotowe do realizacji	allegro-pl	24132822	furious20	lk3c62y8dw+26b840b1@allegromail.pl	\N	Bartek Ptaszyński	+48 607 753 796	Wojska polskiego Inowrocław / Inowrocław	88-100	Inowrocław	PL	fd88bacd-8e41-11f0-a95c-61bbd5a0d3a5	PAID	PAYU	t	643.00	PLN	Allegro Kurier DPD	0.00	PLN	643.00	PLN	\N	t	\N	2025-09-10 12:31:31.472	\N	2025-10-10 09:08:24.239043	ONLINE	f	[{"id": "RFBEOjEwMjU0MDk0MTcyMzdV", "waybill": "1025409417237U", "carrierId": "DPD", "createdAt": "2025-09-12T10:03:34.783Z", "lineItems": [{"id": "b94b3ea0-8e41-11f0-983b-35adfde55ba2"}]}]	\N	0.00	\N	[]	f
8186	13898ab0-8e34-11f0-9847-878997e4dbc8	\N	\N	2025-09-10 10:52:27.719	Gotowe do realizacji	allegro-pl	43015066	Client:43015066	x2jf0gdzg1+1ffcc5890@allegromail.pl	\N	Karolina Lis	+48 572 278 347	Paderewskiego 6 / 80	68-200	Żary	PL	1baf1da4-8e34-11f0-a511-b3d4cdf381f7	PAID	P24	t	600.00	PLN	Allegro Kurier DPD	0.00	PLN	600.00	PLN	\N	t	\N	2025-09-10 10:52:27.719	\N	2025-10-10 09:08:25.736352	ONLINE	f	[{"id": "RFBEOjEwMjU1MzQ1MTY5NTdV", "waybill": "1025534516957U", "carrierId": "DPD", "createdAt": "2025-09-15T08:27:47.934Z", "lineItems": [{"id": "1382fb00-8e34-11f0-9847-878997e4dbc8"}]}, {"id": "RFBEOjEwMjU1MzQ1MTcwNzJV", "waybill": "1025534517072U", "carrierId": "DPD", "createdAt": "2025-09-15T08:27:48.133Z", "lineItems": [{"id": "1382fb00-8e34-11f0-9847-878997e4dbc8"}]}]	\N	0.00	\N	[]	f
8187	fd58d5b0-8e2f-11f0-9d9f-e176fe4b7fab	\N	\N	2025-09-10 10:32:17.576	Gotowe do realizacji	allegro-pl	5636936	Wizard05	l02iayvymt+dc7a8dc9@allegromail.pl	\N	Jacek Komicz	+48 504 758 497	ul. Piaskowa 2A	62-710	Wyszyna	PL	fd951bfc-8e2f-11f0-8e7f-55e86f66c26b	PAID	P24	t	1343.00	PLN	Allegro Kurier DPD	0.00	PLN	1343.00	PLN	Dzień dobry. Zakupiłem  garderobę do przedpokoju biało-czarną I wymiarach  90x30. Dodatkowe informacje do zamówienia to:\nKolor haków : czarny\nPanel ścienny:czarny\nTkanina : welur czarny\nKolor siedziska : czarny welur	t	\N	2025-09-10 10:32:17.576	\N	2025-10-10 09:08:27.183737	ONLINE	f	[{"id": "RFBEOjEwMjU0MDk1NTQ4NDVV", "waybill": "1025409554845U", "carrierId": "DPD", "createdAt": "2025-09-12T10:05:06Z", "lineItems": [{"id": "fd52bb30-8e2f-11f0-9d9f-e176fe4b7fab"}]}, {"id": "RFBEOjEwMjU0MDk1NTQ5OTZV", "waybill": "1025409554996U", "carrierId": "DPD", "createdAt": "2025-09-12T10:05:06Z", "lineItems": [{"id": "fd52bb30-8e2f-11f0-9d9f-e176fe4b7fab"}]}, {"id": "RFBEOjEwMjU0MDk1NTUwODlV", "waybill": "1025409555089U", "carrierId": "DPD", "createdAt": "2025-09-12T10:05:06Z", "lineItems": [{"id": "fd52bb30-8e2f-11f0-9d9f-e176fe4b7fab"}]}]	\N	0.00	\N	[]	f
8188	e87bf410-8e2f-11f0-9847-878997e4dbc8	\N	\N	2025-09-10 10:22:14.883	Gotowe do realizacji	allegro-pl	2419951	janusz55T	glm22hv0en+5c8332b9@allegromail.pl	\N	Janusz Tomiło	+48 600 229 991	ul. Stefanika 10B/12	03-133	Warszawa	PL	e8b2bc2e-8e2f-11f0-a95c-61bbd5a0d3a5	PAID	AF	t	434.90	PLN	Allegro Kurier DPD	0.00	PLN	434.90	PLN	\N	t	\N	2025-09-10 10:22:14.883	\N	2025-10-10 09:08:28.671307	ONLINE	f	[{"id": "RFBEOjEwMjU1MzcxNTQzMDRV", "waybill": "1025537154304U", "carrierId": "DPD", "createdAt": "2025-09-15T08:42:15.923Z", "lineItems": [{"id": "e873b6b0-8e2f-11f0-9847-878997e4dbc8"}]}]	\N	0.00	\N	[]	f
8189	b4717e00-8e2b-11f0-a05c-253781009547	\N	\N	2025-09-10 09:53:52.38	Gotowe do realizacji	allegro-pl	94483290	Client:94483290	x7dljlwaem+4db4f6546@allegromail.pl	\N	Anna Gajek	+48 507 171 061	Blanowska 28 / 41	42-400	Zawiercie	PL	fe23759e-8e2b-11f0-8e7f-55e86f66c26b	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	354.99	PLN	THP1 - Tkanina Hugo Pik Grafitowy	t	\N	2025-09-10 09:53:52.38	\N	2025-10-10 09:08:30.173338	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjU1MzczMzY2OTJV", "waybill": "1025537336692U", "carrierId": "DPD", "createdAt": "2025-09-15T08:43:10.876Z", "lineItems": [{"id": "b46b6380-8e2b-11f0-a05c-253781009547"}]}]	\N	0.00	\N	[]	f
8190	39e74820-8e28-11f0-b55d-c5913dafd975	\N	\N	2025-09-10 09:27:55.795	Gotowe do realizacji	allegro-pl	2799468	Kornik2004	7gr331b4i3+5ec6c9b0@allegromail.pl	\N	Kornelia Połomska-Kuc	+48 668 292 275	Kościelna 59b	42-622	Świerklaniec	PL	567d6627-8e28-11f0-a511-b3d4cdf381f7	PAID	PAYU	t	1431.00	PLN	Allegro Kurier DPD	0.00	PLN	1431.00	PLN	Kolor we04 welur brązowy 	t	\N	2025-09-10 09:27:55.795	\N	2025-10-10 09:08:31.690864	ONLINE	t	[{"id": "RFBEOjEwMjU1MzU4OTY2MjdV", "waybill": "1025535896627U", "carrierId": "DPD", "createdAt": "2025-09-15T08:35:15Z", "lineItems": [{"id": "39e1a2d0-8e28-11f0-b55d-c5913dafd975"}]}, {"id": "RFBEOjEwMjU1MzU4OTY4NThV", "waybill": "1025535896858U", "carrierId": "DPD", "createdAt": "2025-09-15T08:35:15Z", "lineItems": [{"id": "39e1a2d0-8e28-11f0-b55d-c5913dafd975"}]}, {"id": "RFBEOjEwMjU1MzU4OTY5MzlV", "waybill": "1025535896939U", "carrierId": "DPD", "createdAt": "2025-09-15T08:35:15.198Z", "lineItems": [{"id": "39e1a2d0-8e28-11f0-b55d-c5913dafd975"}]}]	Główna 90	0.00	\N	[]	f
8191	36a743e0-8e1e-11f0-a1aa-7ff8f29e1c92	\N	\N	2025-09-10 08:15:22.113	Gotowe do realizacji	allegro-pl	15620912	margolcia_90	oigb9zrzam+3edb2f039@allegromail.pl	\N	Marta Kowalewska	+48 695 489 975	ul. Chrobrego 3/11	87-100	Toruń	PL	36db9ac1-8e1e-11f0-a9a3-2b5e8b7d16b8	PAID	P24	t	418.00	PLN	Allegro Kurier DPD	0.00	PLN	418.00	PLN	\N	t	\N	2025-09-10 08:15:22.113	\N	2025-10-10 09:08:33.20268	ONLINE	f	[{"id": "RFBEOjEwMjU1Mzc1MjU5MjVV", "waybill": "1025537525925U", "carrierId": "DPD", "createdAt": "2025-09-15T08:44:12Z", "lineItems": [{"id": "36a10250-8e1e-11f0-a1aa-7ff8f29e1c92"}]}]	\N	0.00	\N	[]	f
8192	a4c122a0-8e1a-11f0-b55d-c5913dafd975	\N	\N	2025-09-10 07:53:03.78	Gotowe do realizacji	allegro-pl	3926229	relewy	7wwjozdgtc+691cb0113@allegromail.pl	\N	remigiusz lewandowski	+48 667 306 121	Stara Górka 20	62-010	Pobiedziska	PL	a4f4dd13-8e1a-11f0-a511-b3d4cdf381f7	PAID	P24	t	834.00	PLN	Allegro Kurier DPD	0.00	PLN	834.00	PLN	Uwaga proszę nie nawiercać otworów na uchwyty w szafkach! Proszę nie montować stopek u dołu mebla tylko dołączyć luzem\nTkanina na siedzisko to F01 Fjord Brąz	t	\N	2025-09-10 07:53:03.78	\N	2025-10-10 09:08:34.702378	ONLINE	f	[{"id": "RFBEOjEwMjU1Mzc5ODQ0MzhV", "waybill": "1025537984438U", "carrierId": "DPD", "createdAt": "2025-09-15T08:46:21.506Z", "lineItems": [{"id": "a4bb7d51-8e1a-11f0-b55d-c5913dafd975"}, {"id": "a4bb7d50-8e1a-11f0-b55d-c5913dafd975"}]}, {"id": "RFBEOjEwMjU1Mzc5ODQ1NTVV", "waybill": "1025537984555U", "carrierId": "DPD", "createdAt": "2025-09-15T08:46:21.743Z", "lineItems": [{"id": "a4bb7d51-8e1a-11f0-b55d-c5913dafd975"}, {"id": "a4bb7d50-8e1a-11f0-b55d-c5913dafd975"}]}]	\N	0.00	\N	[]	f
8193	4423ffc0-8e16-11f0-a0cf-655d3976444d	\N	\N	2025-09-10 07:18:22.511	Gotowe do realizacji	allegro-pl	55896342	amigo12345	hi7azbohra+258406e65@allegromail.pl	\N	Rafał Przybyłoiwski	+48 519 699 770	Szklarnia9c	11-710	Piecki	PL	509211c2-8e16-11f0-a95c-61bbd5a0d3a5	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	481.99	PLN	\N	f	\N	2025-09-10 07:18:22.511	\N	2025-10-10 09:08:36.401865	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjU1MzkxMzg2OTJV", "waybill": "1025539138692U", "carrierId": "DPD", "createdAt": "2025-09-15T08:52:29.142Z", "lineItems": [{"id": "441e0c50-8e16-11f0-a0cf-655d3976444d"}]}]	\N	0.00	\N	[]	f
8194	54d06900-8e14-11f0-b896-03595c2585cc	\N	\N	2025-09-10 07:04:46.749	Gotowe do realizacji	allegro-pl	101115582	Client:101115582	94vvzhqmrg+4843976d7@allegromail.pl	\N	Sylwia Cepowska	+48 607 267 736	Szkolna 7	99-232	Zadzim	PL	67e4e729-8e14-11f0-964d-83aea542bda6	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	466.99	PLN	Dąb Sonoma 	t	\N	2025-09-10 07:04:46.749	\N	2025-10-10 09:08:37.870699	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjU1MzkyNzUwNzNV", "waybill": "1025539275073U", "carrierId": "DPD", "createdAt": "2025-09-15T08:53:16.562Z", "lineItems": [{"id": "54ca4e80-8e14-11f0-b896-03595c2585cc"}]}]	\N	0.00	\N	[]	f
8195	85659a00-8e0e-11f0-a5da-275c3afcdf47	\N	\N	2025-09-10 06:23:53.87	Gotowe do realizacji	allegro-pl	37825165	Client:37825165	t8kika4dmw+38c6a5c16@allegromail.pl	\N	Katarzyna Błaszkiewicz	+48 665 621 357	Elbląska 23	82-340	Tolkmicko	PL	89fc3a03-8e0e-11f0-8e7f-55e86f66c26b	PAID	AF	t	434.00	PLN	Allegro Kurier DPD	0.00	PLN	434.00	PLN	\N	t	\N	2025-09-10 06:23:53.87	\N	2025-10-10 09:08:39.351059	ONLINE	f	[{"id": "RFBEOjEwMjU1NDAxNTk4MzNV", "waybill": "1025540159833U", "carrierId": "DPD", "createdAt": "2025-09-15T08:58:06.101Z", "lineItems": [{"id": "855ac490-8e0e-11f0-a5da-275c3afcdf47"}]}]	\N	0.00	\N	[]	f
8201	593890b0-8cf9-11f0-aeeb-f5bb2ff9b6b9	\N	\N	2025-09-08 21:27:49.94	Gotowe do realizacji	allegro-pl	103427851	Client:103427851	ed7jtqo8f4+49465da38@allegromail.pl	\N	Justyna Szczygielska	+48 667 276 848	Radziechów 67	59-516	Zagrodno	PL	4d60d71e-8cfa-11f0-964d-83aea542bda6	PAID	P24	t	751.99	PLN	Allegro Kurier DPD	14.99	PLN	751.99	PLN	proszę o siedzisko w kolorze "welur brązowy" (WE4)	f	\N	2025-09-08 21:27:49.94	\N	2025-10-10 09:08:47.236708	ONLINE	f	[{"id": "RFBEOjEwMjUyNTI2NzQ3NTFV", "waybill": "1025252674751U", "carrierId": "DPD", "createdAt": "2025-09-10T09:28:45.578Z", "lineItems": [{"id": "59333980-8cf9-11f0-aeeb-f5bb2ff9b6b9"}]}, {"id": "RFBEOjEwMjUyNTI2NzQ4MzlV", "waybill": "1025252674839U", "carrierId": "DPD", "createdAt": "2025-09-10T09:28:45.806Z", "lineItems": [{"id": "59333980-8cf9-11f0-aeeb-f5bb2ff9b6b9"}]}]	\N	0.00	\N	[]	f
8204	85964570-8ce6-11f0-bd84-15a8b9b09182	\N	\N	2025-09-08 19:06:49.691	Gotowe do realizacji	allegro-pl	115014540	Client:115014540	ccjr1ewliq+4cce7ac70@allegromail.pl	\N	Aneta Ludwiczak	+48 531 396 349	Osada Fabryczna 9/5	06-400	Ciechanów	PL	85c767a4-8ce6-11f0-a9a3-2b5e8b7d16b8	PAID	P24	t	1319.00	PLN	Allegro Kurier DPD	0.00	PLN	1319.00	PLN	Zamawiam garderobę z panelami i siedziskiem WE1-welur czarny i haczyki H1-czarny 	t	\N	2025-09-08 19:06:49.691	\N	2025-10-10 09:08:50.844741	ONLINE	f	[{"id": "RFBEOjEwMjUxODQyODIwNTRV", "waybill": "1025184282054U", "carrierId": "DPD", "createdAt": "2025-09-09T11:24:50Z", "lineItems": [{"id": "858f8eb0-8ce6-11f0-bd84-15a8b9b09182"}]}, {"id": "RFBEOjEwMjUxODQyODIxNjdV", "waybill": "1025184282167U", "carrierId": "DPD", "createdAt": "2025-09-09T11:24:50Z", "lineItems": [{"id": "858f8eb0-8ce6-11f0-bd84-15a8b9b09182"}]}, {"id": "RFBEOjEwMjUxODQyODIyNzVV", "waybill": "1025184282275U", "carrierId": "DPD", "createdAt": "2025-09-09T11:24:50Z", "lineItems": [{"id": "858f8eb0-8ce6-11f0-bd84-15a8b9b09182"}]}]	\N	0.00	\N	[]	f
8205	6ce48ae0-8ce2-11f0-b999-71a0193671a8	\N	\N	2025-09-08 18:36:17.226	Gotowe do realizacji	allegro-pl	3847583	Rbrat	4k8xys3z5l+4f9a29cd9@allegromail.pl	\N	Radosław Chodkowski	+48 693 456 383	ul. Kameralna 2	05-140	Borowa Góra	PL	6d5c52fe-8ce2-11f0-a511-b3d4cdf381f7	PAID	AF	t	1612.00	PLN	Allegro Kurier DPD	0.00	PLN	1612.00	PLN	\N	t	\N	2025-09-08 18:36:17.226	\N	2025-10-10 09:08:51.984445	ONLINE	f	[{"id": "RFBEOjEwMjUyNTMzMDIxNjBV", "waybill": "1025253302160U", "carrierId": "DPD", "createdAt": "2025-09-10T09:33:48.285Z", "lineItems": [{"id": "6cd129f1-8ce2-11f0-b999-71a0193671a8"}, {"id": "6cd129f0-8ce2-11f0-b999-71a0193671a8"}, {"id": "6cd129f2-8ce2-11f0-b999-71a0193671a8"}]}, {"id": "RFBEOjEwMjUyNTMzMDIyODBV", "waybill": "1025253302280U", "carrierId": "DPD", "createdAt": "2025-09-10T09:33:48.523Z", "lineItems": [{"id": "6cd129f1-8ce2-11f0-b999-71a0193671a8"}, {"id": "6cd129f0-8ce2-11f0-b999-71a0193671a8"}, {"id": "6cd129f2-8ce2-11f0-b999-71a0193671a8"}]}, {"id": "RFBEOjEwMjUyNTMzMDIzMzdV", "waybill": "1025253302337U", "carrierId": "DPD", "createdAt": "2025-09-10T09:33:48.864Z", "lineItems": [{"id": "6cd129f1-8ce2-11f0-b999-71a0193671a8"}, {"id": "6cd129f0-8ce2-11f0-b999-71a0193671a8"}, {"id": "6cd129f2-8ce2-11f0-b999-71a0193671a8"}]}, {"id": "RFBEOjEwMjUyNTMzMDI0NjRV", "waybill": "1025253302464U", "carrierId": "DPD", "createdAt": "2025-09-10T09:33:49.086Z", "lineItems": [{"id": "6cd129f1-8ce2-11f0-b999-71a0193671a8"}, {"id": "6cd129f0-8ce2-11f0-b999-71a0193671a8"}, {"id": "6cd129f2-8ce2-11f0-b999-71a0193671a8"}]}, {"id": "RFBEOjEwMjUyNTMzMDI1NzdV", "waybill": "1025253302577U", "carrierId": "DPD", "createdAt": "2025-09-10T09:33:49.390Z", "lineItems": [{"id": "6cd129f1-8ce2-11f0-b999-71a0193671a8"}, {"id": "6cd129f0-8ce2-11f0-b999-71a0193671a8"}, {"id": "6cd129f2-8ce2-11f0-b999-71a0193671a8"}]}]	\N	0.00	\N	[]	f
8206	db6bb4f0-8cdf-11f0-a374-2b3f33c8293d	\N	\N	2025-09-08 18:17:51.845	Gotowe do realizacji	allegro-pl	4706119	AnnaBS1	njau63bhu4+f2499392@allegromail.pl	\N	Anna Benke - Szurmiej	+48 601 805 425	Kochanowskiego 47 m. 6	01-864	Warszawa	PL	e01910f4-8cdf-11f0-964d-83aea542bda6	PAID	P24	t	471.00	PLN	Allegro Kurier DPD	0.00	PLN	471.00	PLN	\N	t	\N	2025-09-08 18:17:51.845	\N	2025-10-10 09:08:53.327035	ONLINE	f	[{"id": "RFBEOjEwMjUyNTQ1NjU4MTlV", "waybill": "1025254565819U", "carrierId": "DPD", "createdAt": "2025-09-10T09:43:51.094Z", "lineItems": [{"id": "db657360-8cdf-11f0-a374-2b3f33c8293d"}]}]	\N	0.00	\N	[]	f
8207	3e61d540-8cdf-11f0-928c-89798a350f7d	\N	\N	2025-09-08 18:14:23.653	Gotowe do realizacji	allegro-pl	12146568	ww1964	7fsfbeles4+681d96072@allegromail.pl	\N	waldemar wysocki	+48 23 692 18 11	Pokorna 2 / 544	00-199	Warszawa	PL	90757e57-8cdf-11f0-a9a3-2b5e8b7d16b8	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	tapicerka ES4 - brąz ekoskóra	t	\N	2025-09-08 18:14:23.653	\N	2025-10-10 09:08:54.473445	ONLINE	f	[{"id": "RFBEOjEwMjUxMzk5MTU5NzhV", "waybill": "1025139915978U", "carrierId": "DPD", "createdAt": "2025-09-09T05:30:34.946Z", "lineItems": [{"id": "3e5bbac0-8cdf-11f0-928c-89798a350f7d"}]}]	\N	0.00	\N	[]	f
8208	73ffe071-8cdf-11f0-8eac-3373db8fdde9	\N	\N	2025-09-08 18:15:16.04	Gotowe do realizacji	allegro-pl	48799059	Andrzejk1986	83b552zw9a+7ca3c00e4@allegromail.pl	Ferma Drobiu Przemysław Kaczmarek	Andrzej Kaczmarek	+48 730 566 533	Karnin, Zagrodowa 1	66-446	Deszczno	PL	74563e1e-8cdf-11f0-a511-b3d4cdf381f7	PAID	AF	t	605.00	PLN	Allegro Kurier DPD	0.00	PLN	605.00	PLN	\N	t	\N	2025-09-08 18:15:16.04	\N	2025-10-10 09:08:55.597626	ONLINE	t	[{"id": "RFBEOjEwMjUyNTQ2NTY2NTRV", "waybill": "1025254656654U", "carrierId": "DPD", "createdAt": "2025-09-10T09:44:37.674Z", "lineItems": [{"id": "73f88d71-8cdf-11f0-8eac-3373db8fdde9"}]}, {"id": "RFBEOjEwMjUyNTQ2NTY3NjdV", "waybill": "1025254656767U", "carrierId": "DPD", "createdAt": "2025-09-10T09:44:37.850Z", "lineItems": [{"id": "73f88d71-8cdf-11f0-8eac-3373db8fdde9"}]}]	Zagrodowa 2, Karnin	0.00	\N	[]	f
8232	9d2265a0-8761-11f0-932c-f3e4227fda85	\N	\N	2025-09-01 20:31:22.479	Gotowe do realizacji	allegro-pl	13020828	Wupik	vkxo90b0ac+6cdfe69a7@allegromail.pl	\N	Tomasz Ciesielski	+48 600 276 427	Kierzliny 7	11-010	Barczewo, Kierzliny 7	PL	b7c7d71c-8761-11f0-96b8-85ef45c63d69	PAID	P24	t	413.99	PLN	Allegro Kurier DPD	14.99	PLN	413.99	PLN	kolor tapicerki THP 2 TKANINA HUGO PIKOWANA JASNY SZARY	f	\N	2025-09-01 20:31:22.479	\N	2025-10-10 09:15:03.849943	ONLINE	f	[{"id": "RFBEOjEwMjQ3MjU4NDY1MTNV", "waybill": "1024725846513U", "carrierId": "DPD", "createdAt": "2025-09-02T09:52:45.020Z", "lineItems": [{"id": "9d1c9940-8761-11f0-932c-f3e4227fda85"}]}]	\N	0.00	\N	[]	f
8209	712cdfc0-8cde-11f0-937d-89c40d48c215	\N	\N	2025-09-08 18:08:12.306	Gotowe do realizacji	allegro-pl	65864855	Client:65864855	em2102nt3b+7ebe71917@allegromail.pl	\N	Agnieszka Mazur	+48 782 846 551	Ul.R.Traugutta 13/3	59-600	Lwówek Śląski	PL	716cf66d-8cde-11f0-964d-83aea542bda6	PAID	P24	t	1827.00	PLN	Allegro Kurier DPD	0.00	PLN	1827.00	PLN	\N	t	\N	2025-09-08 18:08:12.306	\N	2025-10-10 09:08:56.761627	ONLINE	f	[{"id": "RFBEOjEwMjUyNTQ3ODcyNTBV", "waybill": "1025254787250U", "carrierId": "DPD", "createdAt": "2025-09-10T09:45:29.981Z", "lineItems": [{"id": "7122f4b0-8cde-11f0-937d-89c40d48c215"}]}, {"id": "RFBEOjEwMjUyNTQ3ODczNzVV", "waybill": "1025254787375U", "carrierId": "DPD", "createdAt": "2025-09-10T09:45:30.193Z", "lineItems": [{"id": "7122f4b0-8cde-11f0-937d-89c40d48c215"}]}, {"id": "RFBEOjEwMjUyNTQ3ODc0MTBV", "waybill": "1025254787410U", "carrierId": "DPD", "createdAt": "2025-09-10T09:45:30.422Z", "lineItems": [{"id": "7122f4b0-8cde-11f0-937d-89c40d48c215"}]}]	\N	0.00	\N	[]	f
8210	023ddae0-8cdb-11f0-973f-af339170d9a3	\N	\N	2025-09-08 17:41:36.051	Gotowe do realizacji	allegro-pl	16128134	staniec_an	9ap6kjwgr9+6076d9156@allegromail.pl	\N	Maria Mucha	+48 667 039 275	Krotka 1A / 10	78-500	Drawsko Pomorskie	PL	02569308-8cdb-11f0-89b4-db2a3c3ca4b7	PAID	AF	t	385.00	PLN	Allegro Kurier DPD	0.00	PLN	385.00	PLN	\N	t	\N	2025-09-08 17:41:36.051	\N	2025-10-10 09:08:58.104979	ONLINE	f	[{"id": "RFBEOjEwMjUyNTU3ODMyOTNV", "waybill": "1025255783293U", "carrierId": "DPD", "createdAt": "2025-09-10T09:53:16.350Z", "lineItems": [{"id": "023612b0-8cdb-11f0-973f-af339170d9a3"}]}]	\N	0.00	\N	[]	f
8211	d263de30-8ccd-11f0-bf15-816520a36310	\N	\N	2025-09-08 16:07:21.169	Gotowe do realizacji	allegro-pl	4130808	A_M_J	15v3wy2s3b+3e65d3865@allegromail.pl	\N	Adam Jędrzejczyk	+48 787 788 991	Al. Prugara Ketlinga 24/16	38-500	Sanok	PL	d2985c09-8ccd-11f0-a95c-61bbd5a0d3a5	PAID	PAYU	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	THP1 - Tkanina Hugo Pik Grafitowy	t	\N	2025-09-08 16:07:21.169	\N	2025-10-10 09:08:59.481909	ONLINE	f	[{"id": "RFBEOjEwMjUxNDAwMjY0NjVV", "waybill": "1025140026465U", "carrierId": "DPD", "createdAt": "2025-09-09T05:31:55Z", "lineItems": [{"id": "d25d7590-8ccd-11f0-bf15-816520a36310"}]}]	\N	0.00	\N	[]	f
8213	c1ffad10-8cc5-11f0-ad52-13dc957cc9dd	\N	\N	2025-09-08 15:10:13.647	Gotowe do realizacji	allegro-pl	2255205	Mikom1	elc23uan87+50dc0b3f3@allegromail.pl	\N	Michał Komorowski	+48 602 475 618	Chełmińska 24	64-550	Duszniki	PL	c22fbe7b-8cc5-11f0-964d-83aea542bda6	PAID	AF	t	1173.00	PLN	Allegro Kurier DPD	0.00	PLN	1173.00	PLN	\N	t	\N	2025-09-08 15:10:13.647	\N	2025-10-10 09:09:01.846009	ONLINE	f	[{"id": "RFBEOjEwMjUyNTYwNjk3NTFV", "waybill": "1025256069751U", "carrierId": "DPD", "createdAt": "2025-09-10T09:55:20.944Z", "lineItems": [{"id": "c1f9b9a0-8cc5-11f0-ad52-13dc957cc9dd"}]}, {"id": "RFBEOjEwMjUyNTYwNjk4MzlV", "waybill": "1025256069839U", "carrierId": "DPD", "createdAt": "2025-09-10T09:55:21.146Z", "lineItems": [{"id": "c1f9b9a0-8cc5-11f0-ad52-13dc957cc9dd"}]}, {"id": "RFBEOjEwMjUyNTYwNjk5MThV", "waybill": "1025256069918U", "carrierId": "DPD", "createdAt": "2025-09-10T09:55:21.367Z", "lineItems": [{"id": "c1f9b9a0-8cc5-11f0-ad52-13dc957cc9dd"}]}]	\N	0.00	\N	[]	f
8214	7c3db470-8cc5-11f0-ad52-13dc957cc9dd	\N	\N	2025-09-08 15:08:06.039	Gotowe do realizacji	allegro-pl	3593035	marzannaj	5yldvol3rl+4cf4b7d75@allegromail.pl	\N	marzena jakubczyk	+48 793 374 174	romualda 2/47	25-322	kielce	PL	86092f3a-8cc5-11f0-a9a3-2b5e8b7d16b8	PAID	AF	t	413.99	PLN	Allegro Kurier DPD	14.99	PLN	413.99	PLN	TH2 - Tkanina Hugo Jasno szary	f	\N	2025-09-08 15:08:06.039	\N	2025-10-10 09:09:03.011152	ONLINE	f	[{"id": "RFBEOjEwMjUyNTYyNDAxMjFV", "waybill": "1025256240121U", "carrierId": "DPD", "createdAt": "2025-09-10T09:56:32.576Z", "lineItems": [{"id": "7c374bd0-8cc5-11f0-ad52-13dc957cc9dd"}]}]	\N	0.00	\N	[]	f
8222	ea436631-8c85-11f0-bc28-c1ece5985fa4	\N	\N	2025-09-08 07:33:58.836	Gotowe do realizacji	allegro-pl	12593207	Basik_vip	dk6snq87gl+7b3582167@allegromail.pl	\N	Barbara Wiatr	+48 882 145 667	Stare Żukowice 101 B	33-151	Nowa Jastrząbka	PL	ea90c372-8c85-11f0-a9a3-2b5e8b7d16b8	PAID	AF	t	828.00	PLN	Allegro Kurier DPD	0.00	PLN	828.00	PLN	F04 Fjord czarny 	t	\N	2025-09-08 07:33:58.836	\N	2025-10-10 09:14:36.027057	ONLINE	f	[{"id": "RFBEOjEwMjUyNTg1NTg1OTRV", "waybill": "1025258558594U", "carrierId": "DPD", "createdAt": "2025-09-10T10:14:55Z", "lineItems": [{"id": "ea3bc513-8c85-11f0-bc28-c1ece5985fa4"}]}, {"id": "RFBEOjEwMjUyNTg1NTg2MDJV", "waybill": "1025258558602U", "carrierId": "DPD", "createdAt": "2025-09-10T10:14:55Z", "lineItems": [{"id": "ea3bc513-8c85-11f0-bc28-c1ece5985fa4"}]}]	\N	0.00	\N	[]	f
8228	48d87520-8789-11f0-9663-29033773bab5	\N	\N	2025-09-01 23:14:04.608	Gotowe do realizacji	allegro-pl	130021242	Client:130021242	n5za05n9yh+4190f2436@allegromail.pl	\N	Mariola Baranowska	+48 795 858 699	Mila 6 / 3	95-015	Glowno	PL	560f551c-8789-11f0-919c-bfc54d4f7bb1	UNPAID	\N	f	\N	\N	Kurier DPD pobranie	22.00	PLN	120.00	PLN	\N	f	\N	2025-09-01 23:14:04.608	\N	2025-10-10 09:14:58.880964	CASH_ON_DELIVERY	f	[]	\N	0.00	\N	[]	f
8229	e57e3140-8788-11f0-a374-2b3f33c8293d	\N	\N	2025-09-01 23:11:45.334	Gotowe do realizacji	allegro-pl	130021242	Client:130021242	n5za05n9yh+583a76f90@allegromail.pl	\N	Mariola Baranowska	+48 795 858 699	Mila 6 / 3	95-015	Glowno	PL	fd40324e-8788-11f0-919c-bfc54d4f7bb1	UNPAID	\N	f	\N	\N	Kurier DPD pobranie	22.00	PLN	120.00	PLN	\N	f	\N	2025-09-01 23:11:45.334	\N	2025-10-10 09:15:00.15466	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjQ3NzE2NDQxNzRV", "waybill": "1024771644174U", "carrierId": "DPD", "createdAt": "2025-09-03T04:19:20.442Z", "lineItems": [{"id": "e5783dd0-8788-11f0-a374-2b3f33c8293d"}]}]	\N	0.00	\N	[]	f
8230	f00e7530-8778-11f0-9663-29033773bab5	\N	\N	2025-09-01 21:18:30.122	Gotowe do realizacji	allegro-pl	101916545	Client:101916545	fxowzgnhka+6abd0ae97@allegromail.pl	\N	Katarzyna Niedzialek	+48 690 043 482	Lipowa 8	34-122	Wieprz	PL	0d57b695-8779-11f0-96b8-85ef45c63d69	PAID	AF	t	606.99	PLN	Allegro Kurier DPD	14.99	PLN	606.99	PLN	\N	f	\N	2025-09-01 21:18:30.122	\N	2025-10-10 09:15:01.381321	ONLINE	f	[{"id": "RFBEOjEwMjQ3MjU1NzA1ODBV", "waybill": "1024725570580U", "carrierId": "DPD", "createdAt": "2025-09-02T09:50:33.137Z", "lineItems": [{"id": "f0091e00-8778-11f0-9663-29033773bab5"}]}, {"id": "RFBEOjEwMjQ3MjU1NzA2ODhV", "waybill": "1024725570688U", "carrierId": "DPD", "createdAt": "2025-09-02T09:50:33.413Z", "lineItems": [{"id": "f0091e00-8778-11f0-9663-29033773bab5"}]}]	\N	0.00	\N	[]	f
8231	2db02500-8774-11f0-9bbd-0ba2c344c673	\N	\N	2025-09-01 20:45:04.523	Gotowe do realizacji	allegro-pl	7966295	blue_coracao	lklfh2fvl7+2448f6554@allegromail.pl	\N	Ewa Leśniewska	+48 724 503 500	Zientarskiego 6 / 14	75-852	Koszalin	PL	2ddcda87-8774-11f0-919c-bfc54d4f7bb1	PAID	AF	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-09-01 20:45:04.523	\N	2025-10-10 09:15:02.638995	ONLINE	f	[{"id": "RFBEOjEwMjQ3MjU3MTIxNjFV", "waybill": "1024725712161U", "carrierId": "DPD", "createdAt": "2025-09-02T09:51:38.149Z", "lineItems": [{"id": "2daa58a0-8774-11f0-9bbd-0ba2c344c673"}]}, {"id": "RFBEOjEwMjQ3MjU3MTIyNDFV", "waybill": "1024725712241U", "carrierId": "DPD", "createdAt": "2025-09-02T09:51:38.414Z", "lineItems": [{"id": "2daa58a0-8774-11f0-9bbd-0ba2c344c673"}]}]	\N	0.00	\N	[]	f
8215	cc567a30-8ca4-11f0-bca6-415db17c0a9a	\N	\N	2025-09-08 11:14:13.535	Gotowe do realizacji	allegro-pl	1375084	nikkka	yijllz5q8d+6bbba53f3@allegromail.pl	\N	Iga Jolanta Budna	+48 696 848 819	Zachodnia 6B / 1	05-552	Wola Mrokowska	PL	d8fe878e-8ca4-11f0-8e7f-55e86f66c26b	PAID	AF	t	1887.00	PLN	Allegro Kurier DPD	0.00	PLN	1887.00	PLN	wieszaki H1, tkanina WE3	t	\N	2025-09-08 11:14:13.535	\N	2025-10-10 09:09:04.175326	ONLINE	f	[{"id": "RFBEOjEwMjUyNTY3NDE3MTZV", "waybill": "1025256741716U", "carrierId": "DPD", "createdAt": "2025-09-10T10:00:22.773Z", "lineItems": [{"id": "cc5038a0-8ca4-11f0-bca6-415db17c0a9a"}]}, {"id": "RFBEOjEwMjUyNTY3NDE4NTZV", "waybill": "1025256741856U", "carrierId": "DPD", "createdAt": "2025-09-10T10:00:23.041Z", "lineItems": [{"id": "cc5038a0-8ca4-11f0-bca6-415db17c0a9a"}]}, {"id": "RFBEOjEwMjUyNTY3NDE5MTNV", "waybill": "1025256741913U", "carrierId": "DPD", "createdAt": "2025-09-10T10:00:23.330Z", "lineItems": [{"id": "cc5038a0-8ca4-11f0-bca6-415db17c0a9a"}]}, {"id": "RFBEOjEwMjUyNTY3NDIwNjVV", "waybill": "1025256742065U", "carrierId": "DPD", "createdAt": "2025-09-10T10:00:23.623Z", "lineItems": [{"id": "cc5038a0-8ca4-11f0-bca6-415db17c0a9a"}]}]	\N	0.00	\N	[]	f
8216	9b8dfaa0-8c9e-11f0-99cf-ab03232da32c	\N	\N	2025-09-08 10:30:12.105	Gotowe do realizacji	allegro-pl	36520288	CSI-Polska	anux5t2zkz+3d355a948@allegromail.pl	CSI Polska sp. z o.o.	CSI-Polska	+48 781 222 630	Łopatki 85	24-160	wąwolnica	PL	9bc8ba7b-8c9e-11f0-a95c-61bbd5a0d3a5	PAID	PAYU	t	1779.00	PLN	Allegro Kurier DPD	0.00	PLN	1779.00	PLN	Haki w kolorze czarnym\nTkanina Hugo jasno szary 	t	\N	2025-09-08 10:30:12.105	\N	2025-10-10 09:09:05.458149	ONLINE	t	[{"id": "RFBEOjEwMjUyNTcxOTMyNDlV", "waybill": "1025257193249U", "carrierId": "DPD", "createdAt": "2025-09-10T10:03:49.995Z", "lineItems": [{"id": "9b87e020-8c9e-11f0-99cf-ab03232da32c"}]}, {"id": "RFBEOjEwMjUyNTcxOTMzMDhV", "waybill": "1025257193308U", "carrierId": "DPD", "createdAt": "2025-09-10T10:03:50.209Z", "lineItems": [{"id": "9b87e020-8c9e-11f0-99cf-ab03232da32c"}]}, {"id": "RFBEOjEwMjUyNTcxOTM0MDlV", "waybill": "1025257193409U", "carrierId": "DPD", "createdAt": "2025-09-10T10:03:50.491Z", "lineItems": [{"id": "9b87e020-8c9e-11f0-99cf-ab03232da32c"}]}]	KRYSZTAŁOWA 26/64	0.00	\N	[]	f
8249	49be9000-8734-11f0-b0fa-efded7e9e698	\N	\N	2025-09-01 13:05:55.529	Gotowe do realizacji	allegro-pl	122882270	Client:122882270	28f1q0toru+77d9c9645@allegromail.pl	\N	Agnieszka Koza	+48 666 482 979	Młodzieżowa 25 / 25	99-400	Łowicz	PL	5f3604e8-8734-11f0-9cd7-7d59adfd1e47	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	333.99	PLN	\N	f	\N	2025-09-01 13:05:55.529	\N	2025-10-10 09:15:25.679899	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjQ3MzIyMjU2MThV", "waybill": "1024732225618U", "carrierId": "DPD", "createdAt": "2025-09-02T10:45:22.793Z", "lineItems": [{"id": "49b73d00-8734-11f0-b0fa-efded7e9e698"}]}]	\N	0.00	\N	[]	f
8217	1dde9a80-8c9c-11f0-b999-71a0193671a8	\N	\N	2025-09-08 10:11:32.985	Gotowe do realizacji	allegro-pl	103792517	Client:103792517	t9yigf287s+1a0358268@allegromail.pl	\N	Michalina Kordowska	+48 696 218 512	Kargoszyńska, 50	06-400	Ciechanów	PL	1e1e14fd-8c9c-11f0-a511-b3d4cdf381f7	PAID	AF	t	1127.00	PLN	Allegro Kurier DPD	0.00	PLN	1127.00	PLN	\N	t	\N	2025-09-08 10:11:32.985	\N	2025-10-10 09:09:06.607262	ONLINE	f	[{"id": "RFBEOjEwMjUyNTc0NjY4NjJV", "waybill": "1025257466862U", "carrierId": "DPD", "createdAt": "2025-09-10T10:05:52.606Z", "lineItems": [{"id": "1dd76e91-8c9c-11f0-b999-71a0193671a8"}, {"id": "1dd76e90-8c9c-11f0-b999-71a0193671a8"}]}, {"id": "RFBEOjEwMjUyNTc0NjY5NDNV", "waybill": "1025257466943U", "carrierId": "DPD", "createdAt": "2025-09-10T10:05:52.863Z", "lineItems": [{"id": "1dd76e91-8c9c-11f0-b999-71a0193671a8"}, {"id": "1dd76e90-8c9c-11f0-b999-71a0193671a8"}]}, {"id": "RFBEOjEwMjUyNTc0NjcwMDZV", "waybill": "1025257467006U", "carrierId": "DPD", "createdAt": "2025-09-10T10:05:53.139Z", "lineItems": [{"id": "1dd76e91-8c9c-11f0-b999-71a0193671a8"}, {"id": "1dd76e90-8c9c-11f0-b999-71a0193671a8"}]}]	\N	0.00	\N	[]	f
8219	cdde1020-8c9a-11f0-9360-61e2679a32df	\N	\N	2025-09-08 10:02:44.872	Gotowe do realizacji	allegro-pl	103963473	Client:103963473	vh634v19j9+690916494@allegromail.pl	\N	Michał Gaik	+48 732 666 910	Kobylińska 50	05-600	Kobylin	PL	d283a38c-8c9a-11f0-ae14-79075022611d	PAID	AF	t	74.00	PLN	Allegro Kurier DPD	0.00	PLN	74.00	PLN	ES1 - Eko skóra Czarny	t	\N	2025-09-08 10:02:44.872	\N	2025-10-10 09:09:09.02703	ONLINE	t	[{"id": "RFBEOjEwMjU1MjU1MzIwNzRV", "waybill": "1025525532074U", "carrierId": "DPD", "createdAt": "2025-09-15T07:40:35.288Z", "lineItems": [{"id": "cdd78070-8c9a-11f0-9360-61e2679a32df"}]}]	ul. Wojska Polskiego 1A	0.00	\N	[]	f
8220	b1d44660-8c95-11f0-ac29-997ddd4f1eae	\N	\N	2025-09-08 09:25:57.738	Gotowe do realizacji	allegro-pl	61996082	Client:61996082	asxao6qakn+7ed89f716@allegromail.pl	\N	Luiza Dziuk	+48 605 853 076	Powstańców Chocieszyńskich 77/10	62-065	Grodzisk Wielkopolski	PL	b1f255f3-8c95-11f0-964d-83aea542bda6	PAID	PAYU	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	\N	t	\N	2025-09-08 09:25:57.738	\N	2025-10-10 09:09:10.114258	ONLINE	f	[{"id": "RFBEOjEwMjUxMzk4ODU1NDdV", "waybill": "1025139885547U", "carrierId": "DPD", "createdAt": "2025-09-09T05:30:11.346Z", "lineItems": [{"id": "b1cd8fa0-8c95-11f0-ac29-997ddd4f1eae"}]}]	\N	0.00	\N	[]	f
8221	6f1beba0-8c92-11f0-a42a-27f0acb7ed38	\N	\N	2025-09-08 09:04:16.9	Gotowe do realizacji	allegro-pl	2441593	optykus	5ntfmts8xh+7e827b7e2@allegromail.pl	\N	Krzysztof Bednarski	+48 509 227 079	Osiedle Kombatantów 2 / 3	37-500	Jarosław	PL	bf32da46-8c92-11f0-a95c-61bbd5a0d3a5	PAID	AF	t	1787.00	PLN	Allegro Kurier DPD	0.00	PLN	1787.00	PLN	\N	t	\N	2025-09-08 09:04:16.9	\N	2025-10-10 09:09:11.265188	ONLINE	f	[{"id": "RFBEOjEwMjUyNTc5ODMxNTRV", "waybill": "1025257983154U", "carrierId": "DPD", "createdAt": "2025-09-10T10:10:00.260Z", "lineItems": [{"id": "6f1534e1-8c92-11f0-a42a-27f0acb7ed38"}, {"id": "6f1534e0-8c92-11f0-a42a-27f0acb7ed38"}, {"id": "6f1534e2-8c92-11f0-a42a-27f0acb7ed38"}]}, {"id": "RFBEOjEwMjUyNTc5ODMyNDZV", "waybill": "1025257983246U", "carrierId": "DPD", "createdAt": "2025-09-10T10:10:00.493Z", "lineItems": [{"id": "6f1534e1-8c92-11f0-a42a-27f0acb7ed38"}, {"id": "6f1534e0-8c92-11f0-a42a-27f0acb7ed38"}, {"id": "6f1534e2-8c92-11f0-a42a-27f0acb7ed38"}]}, {"id": "RFBEOjEwMjUyNTc5ODMzOTlV", "waybill": "1025257983399U", "carrierId": "DPD", "createdAt": "2025-09-10T10:10:00.744Z", "lineItems": [{"id": "6f1534e1-8c92-11f0-a42a-27f0acb7ed38"}, {"id": "6f1534e0-8c92-11f0-a42a-27f0acb7ed38"}, {"id": "6f1534e2-8c92-11f0-a42a-27f0acb7ed38"}]}, {"id": "RFBEOjEwMjUyNTc5ODM0MDZV", "waybill": "1025257983406U", "carrierId": "DPD", "createdAt": "2025-09-10T10:10:01.013Z", "lineItems": [{"id": "6f1534e1-8c92-11f0-a42a-27f0acb7ed38"}, {"id": "6f1534e0-8c92-11f0-a42a-27f0acb7ed38"}, {"id": "6f1534e2-8c92-11f0-a42a-27f0acb7ed38"}]}]	\N	0.00	\N	[]	f
8233	4d41d6a0-8771-11f0-bdda-f5fe64ec56c4	\N	\N	2025-09-01 20:22:41.48	Gotowe do realizacji	allegro-pl	10209597	kostucha6	xw1sn47jj5+7947efa13@allegromail.pl	\N	andrzej pawelec	+48 507 212 500	Krasne 831U/15	36-007	Krasne	PL	53954158-8771-11f0-96b8-85ef45c63d69	PAID	P24	t	1391.00	PLN	Allegro Kurier DPD	0.00	PLN	1391.00	PLN	\N	t	\N	2025-09-01 20:22:41.48	\N	2025-10-10 09:15:05.072119	ONLINE	f	[{"id": "RFBEOjEwMjQ3MjU5MzY2NjlV", "waybill": "1024725936669U", "carrierId": "DPD", "createdAt": "2025-09-02T09:53:31.434Z", "lineItems": [{"id": "4d3be330-8771-11f0-bdda-f5fe64ec56c4"}]}, {"id": "RFBEOjEwMjQ3MjU5MzY3NDRV", "waybill": "1024725936744U", "carrierId": "DPD", "createdAt": "2025-09-02T09:53:31.664Z", "lineItems": [{"id": "4d3be330-8771-11f0-bdda-f5fe64ec56c4"}]}, {"id": "RFBEOjEwMjQ3MjU5MzY4NTZV", "waybill": "1024725936856U", "carrierId": "DPD", "createdAt": "2025-09-02T09:53:31.867Z", "lineItems": [{"id": "4d3be330-8771-11f0-bdda-f5fe64ec56c4"}]}]	\N	0.00	\N	[]	f
8234	2959d1f0-876e-11f0-a374-2b3f33c8293d	\N	\N	2025-09-01 20:00:47.356	Gotowe do realizacji	allegro-pl	6764697	marek4703	i949fbf5yt+2a42bbe29@allegromail.pl	\N	Marek Respondek	+48 512 332 079	Ul. Leśnego Potoku 12/2	40-406	Katowice	PL	3006a747-876e-11f0-be54-070037581807	PAID	P24	t	326.00	PLN	Allegro Kurier DPD	0.00	PLN	326.00	PLN	Kolor: welur czarny	t	\N	2025-09-01 20:00:47.356	\N	2025-10-10 09:15:06.263963	ONLINE	f	[{"id": "RFBEOjEwMjQ3MjYyMjg3MzlV", "waybill": "1024726228739U", "carrierId": "DPD", "createdAt": "2025-09-02T09:55:46.829Z", "lineItems": [{"id": "2953b770-876e-11f0-a374-2b3f33c8293d"}]}]	\N	0.00	\N	[]	f
8235	9775a520-876d-11f0-8d99-95e42f81ac3a	\N	\N	2025-09-01 19:55:40.402	Gotowe do realizacji	allegro-pl	109676456	Client:109676456	hgggmqqivn+ab84df60@allegromail.pl	\N	Magdalena Piotrowicz	+48 603 436 383	Smutna 26 m 7	91-729	Łódź	PL	a1c7dbb9-876d-11f0-96b8-85ef45c63d69	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	371.99	PLN	\N	f	\N	2025-09-01 19:55:40.402	\N	2025-10-10 09:15:07.862582	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjQ3MjYzMjQyNDNV", "waybill": "1024726324243U", "carrierId": "DPD", "createdAt": "2025-09-02T09:56:32.780Z", "lineItems": [{"id": "97704df0-876d-11f0-8d99-95e42f81ac3a"}]}]	\N	0.00	\N	[]	f
8236	ef0e87d0-876c-11f0-92f7-a7a918a71206	\N	\N	2025-09-01 19:53:23.619	Gotowe do realizacji	allegro-pl	36592877	Client:36592877	juartluelt+1819e2b64@allegromail.pl	\N	Peter  Ozimek 	+48 515 641 527	Zielona 6	46-040	Ozimek	PL	2ece43b5-876d-11f0-9c7c-01f7f38854f4	PAID	AF	t	399.00	PLN	Allegro Kurier DPD	0.00	PLN	399.00	PLN	\N	t	\N	2025-09-01 19:53:23.619	\N	2025-10-10 09:15:09.271602	ONLINE	f	[{"id": "RFBEOjEwMjQ3MjY0MDUwNDdV", "waybill": "1024726405047U", "carrierId": "DPD", "createdAt": "2025-09-02T09:57:09.935Z", "lineItems": [{"id": "ef086d50-876c-11f0-92f7-a7a918a71206"}]}]	\N	0.00	\N	[]	f
8237	6e858ff0-876c-11f0-ab95-618100a958cf	\N	\N	2025-09-01 19:48:25.756	Gotowe do realizacji	allegro-pl	17443756	lesozo	73c3vbmdro+7ed71a67@allegromail.pl	\N	Leszek Ozog	+48 508 479 234	Warszawska 74 / 1	96-500	Sochaczew	PL	7ae71e36-876c-11f0-919c-bfc54d4f7bb1	PAID	AF	t	437.99	PLN	Allegro Kurier DPD	14.99	PLN	437.99	PLN	\N	f	\N	2025-09-01 19:48:25.756	\N	2025-10-10 09:15:10.480049	ONLINE	f	[{"id": "RFBEOjEwMjQ3MjY0OTA5NjRV", "waybill": "1024726490964U", "carrierId": "DPD", "createdAt": "2025-09-02T09:57:57.126Z", "lineItems": [{"id": "6e7fc390-876c-11f0-ab95-618100a958cf"}]}]	\N	0.00	\N	[]	f
8333	9d176340-a5d8-11f0-a45a-cf4899467cb9	\N	\N	2025-10-10 12:57:26.775	Gotowe do realizacji	allegro-pl	2917271	Elnets	g0xal2lm3b+663398fc6@allegromail.pl	\N	Henryk Rejek	+48 693 505 604	Wyzwolenia 119	44-321	Marklowice	\N	9d3720d4-a5d8-11f0-baf9-a33944a1116d	PAID	P24	t	682.00	\N	Allegro Kurier DPD	0.00	PLN	682.00	PLN	\N	t	\N	2025-10-10 12:57:34.08	\N	2025-10-10 21:58:54.161418	ONLINE	f	[]	\N	0.00	\N	[]	f
8238	d5703210-8762-11f0-852b-c3120c8c37fe	\N	\N	2025-09-01 18:41:16.257	Gotowe do realizacji	allegro-pl	23457737	asia_dob	juxpvor5yh+75ee555f7@allegromail.pl	\N	Joanna Dobiecka	+48 691 946 091	Kaniewska 4	87-853	Kruszyn	PL	02e7253f-8763-11f0-8ace-d9e9fdebaadd	PAID	P24	t	400.00	PLN	Allegro Kurier DPD	0.00	PLN	400.00	PLN	WE2 - Welur Jasno Szary	t	\N	2025-09-01 18:41:16.257	\N	2025-10-10 09:15:11.667186	ONLINE	f	[{"id": "RFBEOjEwMjQ4NDkxNDQ5NTJV", "waybill": "1024849144952U", "carrierId": "DPD", "createdAt": "2025-09-04T04:21:56Z", "lineItems": [{"id": "d56a8cc0-8762-11f0-852b-c3120c8c37fe"}]}, {"id": "RFBEOjEwMjUwNjAxODk2MjlV", "waybill": "1025060189629U", "carrierId": "DPD", "createdAt": "2025-09-08T07:47:17.616Z", "lineItems": [{"id": "d56a8cc0-8762-11f0-852b-c3120c8c37fe"}]}]	\N	400.00	2025-10-03 10:12:23.99	[{"id": "749eae69-a041-11f0-a0c8-4d35a83ebd5d", "order": {"id": "d5703210-8762-11f0-852b-c3120c8c37fe"}, "reason": "REFUND", "status": "SUCCESS", "payment": {"id": "02e7253f-8763-11f0-8ace-d9e9fdebaadd"}, "deposits": [], "createdAt": "2025-10-03T10:12:23.990Z", "lineItems": [{"id": "d56a8cc0-8762-11f0-852b-c3120c8c37fe", "type": "QUANTITY", "quantity": 1}], "surcharges": [], "totalValue": {"amount": "400.00", "currency": "PLN"}}]	t
8245	30d95140-874f-11f0-9bbd-0ba2c344c673	\N	\N	2025-09-01 16:18:20.817	Gotowe do realizacji	allegro-pl	48596367	Client:48596367	7g6qh98e87+5650443d7@allegromail.pl	\N	Katarzyna Woźniak	+48 730 230 479	Bolesława Chrobrego, 75/1	59-550	Wojcieszów	PL	3f93c441-874f-11f0-96b8-25d8e1466fe5	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	9.98	PLN	1285.98	PLN	\N	t	\N	2025-09-01 16:18:20.817	\N	2025-10-10 09:15:20.638285	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjQ3MzA0MzQ1MzlV", "waybill": "1024730434539U", "carrierId": "DPD", "createdAt": "2025-09-02T10:29:52Z", "lineItems": [{"id": "30d35dd0-874f-11f0-9bbd-0ba2c344c673"}]}, {"id": "RFBEOjEwMjQ3MzA0MzQ2NDdV", "waybill": "1024730434647U", "carrierId": "DPD", "createdAt": "2025-09-02T10:29:52.196Z", "lineItems": [{"id": "30d35dd0-874f-11f0-9bbd-0ba2c344c673"}]}, {"id": "RFBEOjEwMjQ3MzA0MzQ3MzhV", "waybill": "1024730434738U", "carrierId": "DPD", "createdAt": "2025-09-02T10:29:52.476Z", "lineItems": [{"id": "30d35dd0-874f-11f0-9bbd-0ba2c344c673"}]}, {"id": "RFBEOjEwMjQ3MzA0MzQ4MjZV", "waybill": "1024730434826U", "carrierId": "DPD", "createdAt": "2025-09-02T10:29:52.688Z", "lineItems": [{"id": "30d35dd0-874f-11f0-9bbd-0ba2c344c673"}]}]	\N	0.00	\N	[]	f
8246	cea8e430-874a-11f0-b3ea-7b7b17505e79	\N	\N	2025-09-01 15:47:55.797	Gotowe do realizacji	allegro-pl	40497104	Client:40497104	7aquhkndbc+20b286428@allegromail.pl	\N	Kinga Tomaszewska	+48 721 383 682	Stachlew 76H	99-418	Bełchów	PL	ced72077-874a-11f0-9cd7-7d59adfd1e47	PAID	AF	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	Kolor obicia - Hugo Pik Grafit 	t	\N	2025-09-01 15:47:55.797	\N	2025-10-10 09:15:21.837018	ONLINE	f	[{"id": "RFBEOjEwMjQ3MzA3MDk5MTFV", "waybill": "1024730709911U", "carrierId": "DPD", "createdAt": "2025-09-02T10:32:09.398Z", "lineItems": [{"id": "cea317d0-874a-11f0-b3ea-7b7b17505e79"}]}]	\N	0.00	\N	[]	f
8247	8ecea0f0-8738-11f0-b3ea-7b7b17505e79	\N	\N	2025-09-01 13:37:16.124	Gotowe do realizacji	allegro-pl	102126266	Client:102126266	eypiuq8zub+7509b56d0@allegromail.pl	\N	Olga Biskup	+48 577 479 745	Ul. Spokojna 44	32-590	Libiąż 	PL	b083ef54-8738-11f0-96b8-25d8e1466fe5	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	19.99	PLN	942.99	PLN	\N	f	\N	2025-09-01 13:37:16.124	\N	2025-10-10 09:15:23.254274	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjQ3MzA4OTA0MzFV", "waybill": "1024730890431U", "carrierId": "DPD", "createdAt": "2025-09-02T10:33:48.521Z", "lineItems": [{"id": "8ec8d490-8738-11f0-b3ea-7b7b17505e79"}]}, {"id": "RFBEOjEwMjQ3MzA4OTA1NDZV", "waybill": "1024730890546U", "carrierId": "DPD", "createdAt": "2025-09-02T10:33:48.776Z", "lineItems": [{"id": "8ec8d490-8738-11f0-b3ea-7b7b17505e79"}]}]	\N	0.00	\N	[]	f
8248	65b36470-8734-11f0-aae5-1913e565e695	\N	\N	2025-09-01 13:06:20.895	Gotowe do realizacji	allegro-pl	27175430	radek12094	ibpap6h3zy+165a600a6@allegromail.pl	\N	Patrycja Karwowska	+48 514 514 708	Żebry 17	19-222	Wąsosz	PL	68e320ef-8734-11f0-9cd7-7d59adfd1e47	PAID	AF	t	556.00	PLN	Allegro Kurier DPD	0.00	PLN	556.00	PLN	\N	t	\N	2025-09-01 13:06:20.895	\N	2025-10-10 09:15:24.464693	ONLINE	f	[{"id": "RFBEOjEwMjQ3MzIwNDY5MDNV", "waybill": "1024732046903U", "carrierId": "DPD", "createdAt": "2025-09-02T10:43:52.380Z", "lineItems": [{"id": "65ad22e0-8734-11f0-aae5-1913e565e695"}]}]	\N	0.00	\N	[]	f
8241	301bf080-8756-11f0-b999-71a0193671a8	\N	\N	2025-09-01 17:09:49.866	Gotowe do realizacji	allegro-pl	6173638	shady1211	e28evpmtkv+594dca2b4@allegromail.pl	\N	Łukasz Kurek	+48 886 232 004	Węglów, 38a	27-215	Wąchock	PL	304d617a-8756-11f0-83db-015123316174	PAID	P24	t	931.00	PLN	Allegro Kurier DPD	0.00	PLN	931.00	PLN	ES4 - Eko skóra Brąz	t	\N	2025-09-01 17:09:49.866	\N	2025-10-10 09:15:15.658562	ONLINE	f	[{"id": "RFBEOjEwMjQ3Mjk1OTA5NzdV", "waybill": "1024729590977U", "carrierId": "DPD", "createdAt": "2025-09-02T10:23:25.816Z", "lineItems": [{"id": "301587e0-8756-11f0-b999-71a0193671a8"}, {"id": "301587e1-8756-11f0-b999-71a0193671a8"}]}, {"id": "RFBEOjEwMjQ3Mjk1OTEwODBV", "waybill": "1024729591080U", "carrierId": "DPD", "createdAt": "2025-09-02T10:23:26.105Z", "lineItems": [{"id": "301587e0-8756-11f0-b999-71a0193671a8"}, {"id": "301587e1-8756-11f0-b999-71a0193671a8"}]}]	\N	0.00	\N	[]	f
8242	f532a390-8752-11f0-b999-71a0193671a8	\N	\N	2025-09-01 16:45:54.974	Gotowe do realizacji	allegro-pl	104505695	Client:104505695	xpzzis713z+7868114a1@allegromail.pl	\N	Klaudia Piłka	+48 507 301 923	Żeromskiego 5	08-441	Parysów	PL	fa5a38d4-8752-11f0-96b8-85ef45c63d69	UNPAID	\N	f	\N	\N	Allegro Kurier DPD pobranie	4.99	PLN	1561.99	PLN	obicie siedziska jak również te panele z oparcia poproszę w kolorze grafit poniżej podaję kod\n\nTHP1	t	\N	2025-09-01 16:45:54.974	\N	2025-10-10 09:15:16.97062	CASH_ON_DELIVERY	f	[{"id": "RFBEOjEwMjQ3Mjk3OTE1OTdV", "waybill": "1024729791597U", "carrierId": "DPD", "createdAt": "2025-09-02T10:25:02.764Z", "lineItems": [{"id": "f52cfe40-8752-11f0-b999-71a0193671a8"}]}, {"id": "RFBEOjEwMjQ3Mjk3OTE2NzdV", "waybill": "1024729791677U", "carrierId": "DPD", "createdAt": "2025-09-02T10:25:03.013Z", "lineItems": [{"id": "f52cfe40-8752-11f0-b999-71a0193671a8"}]}, {"id": "RFBEOjEwMjQ3Mjk3OTE3ODRV", "waybill": "1024729791784U", "carrierId": "DPD", "createdAt": "2025-09-02T10:25:03.205Z", "lineItems": [{"id": "f52cfe40-8752-11f0-b999-71a0193671a8"}]}]	\N	0.00	\N	[]	f
8243	6ff57270-8752-11f0-b999-71a0193671a8	\N	\N	2025-09-01 16:41:43.07	Gotowe do realizacji	allegro-pl	11298499	kielunia1989	onfxnruzc3+2d11e20e4@allegromail.pl	\N	Małgorzata Gąsłowska	+48 535 320 831	Portowa 21d	32-005	Niepołomice	PL	702164ab-8752-11f0-96b8-85ef45c63d69	PAID	AF	t	616.00	PLN	Allegro Kurier DPD	0.00	PLN	616.00	PLN	\N	t	\N	2025-09-01 16:41:43.07	\N	2025-10-10 09:15:18.168459	ONLINE	f	[{"id": "RFBEOjEwMjQ3MzAxMjY0NDZV", "waybill": "1024730126446U", "carrierId": "DPD", "createdAt": "2025-09-02T10:27:17.819Z", "lineItems": [{"id": "6fefcd21-8752-11f0-b999-71a0193671a8"}]}, {"id": "RFBEOjEwMjQ3MzAxMjY1ODdV", "waybill": "1024730126587U", "carrierId": "DPD", "createdAt": "2025-09-02T10:27:17.988Z", "lineItems": [{"id": "6fefcd21-8752-11f0-b999-71a0193671a8"}]}]	\N	0.00	\N	[]	f
8244	e1aa8e70-8750-11f0-b999-71a0193671a8	\N	\N	2025-09-01 16:31:26.722	Gotowe do realizacji	allegro-pl	16872970	kris14021	t71ja2gqbx+52c682d30@allegromail.pl	\N	Krzysztof Sztemberg	+48 606 356 568	Radomska 27	26-900	Kozienice	PL	e1db14ea-8750-11f0-96b8-85ef45c63d69	PAID	P24	t	350.00	PLN	Allegro Kurier DPD	0.00	PLN	350.00	PLN	\N	t	\N	2025-09-01 16:31:26.722	\N	2025-10-10 09:15:19.393478	ONLINE	f	[{"id": "RFBEOjEwMjQ3MzAzMjkxNTRV", "waybill": "1024730329154U", "carrierId": "DPD", "createdAt": "2025-09-02T10:28:53.719Z", "lineItems": [{"id": "e1a425d0-8750-11f0-b999-71a0193671a8"}]}]	\N	0.00	\N	[]	f
8250	acbae750-8732-11f0-aae5-1913e565e695	\N	\N	2025-09-01 12:55:37.808	Gotowe do realizacji	allegro-pl	102294291	Client:102294291	gcs9msm4m6+109e34534@allegromail.pl	\N	Magdalena Mielnik	+48 506 998 044	Kamińskiego 22 / 11	05-850	Ożarów Mazowiecki	PL	b4002bc2-8732-11f0-919c-bfc54d4f7bb1	PAID	P24	t	523.00	PLN	Allegro Kurier DPD	0.00	PLN	523.00	PLN	WE2	t	\N	2025-09-01 12:55:37.808	\N	2025-10-10 09:15:26.886604	ONLINE	f	[{"id": "RFBEOjEwMjQ3MzIzMzEwODhV", "waybill": "1024732331088U", "carrierId": "DPD", "createdAt": "2025-09-02T10:46:15.594Z", "lineItems": [{"id": "acaa6c90-8732-11f0-aae5-1913e565e695"}]}]	\N	0.00	\N	[]	f
8251	4d469ef0-872c-11f0-baaf-1b3feb3b2100	\N	\N	2025-09-01 12:08:47.864	Gotowe do realizacji	allegro-pl	26723888	aneta931004	61xwg5nzki+61c9bef00@allegromail.pl	\N	Aneta Szylar	+48 535 000 627	Markowa 1319	37-120	Markowa	PL	4d7ec68c-872c-11f0-8a60-916b0c111bf4	PAID	P24	t	478.00	PLN	Allegro Kurier DPD	0.00	PLN	478.00	PLN	\N	t	\N	2025-09-01 12:08:47.864	\N	2025-10-10 09:15:28.123644	ONLINE	f	[{"id": "RFBEOjEwMjQ4NTEyMjg4OTZV", "waybill": "1024851228896U", "carrierId": "DPD", "createdAt": "2025-09-04T05:07:00.092Z", "lineItems": [{"id": "4d3c3eb0-872c-11f0-baaf-1b3feb3b2100"}]}]	\N	0.00	\N	[]	f
8252	be44e7b0-8722-11f0-84e1-03ec8438f346	\N	\N	2025-09-01 11:01:17.31	Gotowe do realizacji	allegro-pl	41160460	pherka	ft2kxtc4ve+3a30411a5@allegromail.pl	\N	Karolina Krzykalak	+48 668 648 873	żeligowskiego, 43B/19	90-644	łódź	PL	be74aa83-8722-11f0-96b8-25d8e1466fe5	PAID	P24	t	1343.00	PLN	Allegro Kurier DPD	0.00	PLN	1343.00	PLN	\N	t	\N	2025-09-01 11:01:17.31	\N	2025-10-10 09:15:29.31533	ONLINE	f	[{"id": "RFBEOjEwMjQ3MzI0MzM2NzZV", "waybill": "1024732433676U", "carrierId": "DPD", "createdAt": "2025-09-02T10:47:14.137Z", "lineItems": [{"id": "be3ecd30-8722-11f0-84e1-03ec8438f346"}]}, {"id": "RFBEOjEwMjQ3MzI0MzM3MjlV", "waybill": "1024732433729U", "carrierId": "DPD", "createdAt": "2025-09-02T10:47:14.320Z", "lineItems": [{"id": "be3ecd30-8722-11f0-84e1-03ec8438f346"}]}, {"id": "RFBEOjEwMjQ3MzI0MzM4ODlV", "waybill": "1024732433889U", "carrierId": "DPD", "createdAt": "2025-09-02T10:47:14.524Z", "lineItems": [{"id": "be3ecd30-8722-11f0-84e1-03ec8438f346"}]}]	\N	0.00	\N	[]	f
8253	09fd5e90-8718-11f0-baaf-1b3feb3b2100	\N	\N	2025-09-01 09:47:56.037	Gotowe do realizacji	allegro-pl	3757007	irs21	m5qgnrv3zw+72c592800@allegromail.pl	\N	Iwonka Rajza-Spryszyńska	+48 510 079 501	Koniczyny 10/11	05-850	Kręczki	PL	0a4e3def-8718-11f0-8a60-916b0c111bf4	PAID	P24	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	\N	t	\N	2025-09-01 09:47:56.037	\N	2025-10-10 09:15:30.50539	ONLINE	f	[{"id": "RFBEOjEwMjQ3MzMwNjMwMDBV", "waybill": "1024733063000U", "carrierId": "DPD", "createdAt": "2025-09-02T10:52:36.842Z", "lineItems": [{"id": "09f2d740-8718-11f0-baaf-1b3feb3b2100"}]}]	\N	0.00	\N	[]	f
8254	ae946540-8711-11f0-90bb-a54d0876967b	\N	\N	2025-09-01 08:58:05.632	Gotowe do realizacji	allegro-pl	27864338	Client:27864338	c4bw3npofu+7b18d7c3@allegromail.pl	\N	Anna Błaut	+48 726 193 454	Olszany 15a	05-604	Jasieniec	PL	aeb73018-8711-11f0-96b8-85ef45c63d69	PAID	P24	t	510.00	PLN	Allegro Kurier DPD	0.00	PLN	510.00	PLN	\N	t	\N	2025-09-01 08:58:05.632	\N	2025-10-10 09:15:31.699995	ONLINE	f	[{"id": "RFBEOjEwMjQ3MzM1MDI3MzJV", "waybill": "1024733502732U", "carrierId": "DPD", "createdAt": "2025-09-02T10:56:24.168Z", "lineItems": [{"id": "ae8ebff0-8711-11f0-90bb-a54d0876967b"}]}]	\N	0.00	\N	[]	f
8255	d52dd280-870d-11f0-90bb-a54d0876967b	\N	\N	2025-09-01 08:31:19.554	Gotowe do realizacji	allegro-pl	120699901	Client:120699901	jqtdx07lzh+4fa1913f1@allegromail.pl	\N	Adrian Stemborowski	+48 881 665 217	Dzielna 14 / 57	97-300	Piotrków Trybunalski	PL	d55a1323-870d-11f0-96b8-85ef45c63d69	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	rodzaj obicia siedziska - F04 	t	\N	2025-09-01 08:31:19.554	\N	2025-10-10 09:15:32.905688	ONLINE	f	[{"id": "RFBEOjEwMjQ3NzEyNzMwMDRV", "waybill": "1024771273004U", "carrierId": "DPD", "createdAt": "2025-09-03T04:08:30.560Z", "lineItems": [{"id": "d527df10-870d-11f0-90bb-a54d0876967b"}]}]	\N	0.00	\N	[]	f
8256	61e490b0-8709-11f0-8f72-9176775e3e0f	\N	\N	2025-09-01 07:58:43.791	Gotowe do realizacji	allegro-pl	58084473	Client:58084473	jhbmtkt13q+479b715a5@allegromail.pl	\N	Marta Nieznańska	+48 795 833 881	Obarzym, 17	36-204	Dydnia	PL	62169de5-8709-11f0-919c-bfc54d4f7bb1	PAID	PAYU	t	366.99	PLN	Allegro Kurier DPD	14.99	PLN	366.99	PLN	\N	f	\N	2025-09-01 07:58:43.791	\N	2025-10-10 09:15:34.124347	ONLINE	f	[{"id": "RFBEOjEwMjQ3NzEzMDM2NDBV", "waybill": "1024771303640U", "carrierId": "DPD", "createdAt": "2025-09-03T04:09:23.372Z", "lineItems": [{"id": "61de2810-8709-11f0-8f72-9176775e3e0f"}]}]	\N	0.00	\N	[]	f
8257	d4759520-8704-11f0-84e1-03ec8438f346	\N	\N	2025-09-01 07:28:57.614	Gotowe do realizacji	allegro-pl	9861408	anita463	iwaamy9bay+77d43ae55@allegromail.pl	\N	anita okarma	+48 506 784 349	Kościuszki 62	38-300	Gorlice	PL	db15c045-8704-11f0-9cd7-7d59adfd1e47	PAID	PAYU	t	1947.00	PLN	Allegro Kurier DPD	0.00	PLN	1947.00	PLN	Witam SC4 poproszę.	t	\N	2025-09-01 07:28:57.614	\N	2025-10-10 09:15:35.323801	ONLINE	f	[{"id": "RFBEOjEwMjQ3NzE0ODI2MTNV", "waybill": "1024771482613U", "carrierId": "DPD", "createdAt": "2025-09-03T04:15:06.627Z", "lineItems": [{"id": "d46fa1b0-8704-11f0-84e1-03ec8438f346"}]}, {"id": "RFBEOjEwMjQ3NzE0ODI3MzJV", "waybill": "1024771482732U", "carrierId": "DPD", "createdAt": "2025-09-03T04:15:06.803Z", "lineItems": [{"id": "d46fa1b0-8704-11f0-84e1-03ec8438f346"}]}, {"id": "RFBEOjEwMjQ3NzE0ODI4NDRV", "waybill": "1024771482844U", "carrierId": "DPD", "createdAt": "2025-09-03T04:15:07.005Z", "lineItems": [{"id": "d46fa1b0-8704-11f0-84e1-03ec8438f346"}]}, {"id": "RFBEOjEwMjQ3NzE0ODI5NTNV", "waybill": "1024771482953U", "carrierId": "DPD", "createdAt": "2025-09-03T04:15:07.224Z", "lineItems": [{"id": "d46fa1b0-8704-11f0-84e1-03ec8438f346"}]}]	\N	0.00	\N	[]	f
8258	f94b15d0-8701-11f0-aae5-1913e565e695	\N	\N	2025-09-01 07:08:50.429	Gotowe do realizacji	allegro-pl	41685623	jadwigablacha	log224sbg9+2e1b15340@allegromail.pl	\N	Jadwiga Blacha	+48 694 533 015	Mon iuszki40	38-400	Krosno	PL	f9683b30-8701-11f0-919c-bfc54d4f7bb1	PAID	AF	t	423.00	PLN	Allegro Kurier DPD	0.00	PLN	423.00	PLN	\N	t	\N	2025-09-01 07:08:50.429	\N	2025-10-10 09:15:36.550505	ONLINE	f	[{"id": "RFBEOjEwMjQ3NzE1NjI1NDlV", "waybill": "1024771562549U", "carrierId": "DPD", "createdAt": "2025-09-03T04:17:05Z", "lineItems": [{"id": "f945bea0-8701-11f0-aae5-1913e565e695"}]}]	\N	0.00	\N	[]	f
8259	b66e2ad0-86f8-11f0-80ea-6fda5b3014ee	\N	\N	2025-09-01 05:59:52.155	Gotowe do realizacji	allegro-pl	83727361	Client:83727361	j1dd0uoc4d+1a612f414@allegromail.pl	\N	Beata Kowalska	+48 508 326 460	Kłaj 324	32-015	Kłaj	PL	b69959cd-86f8-11f0-83db-015123316174	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	\N	t	\N	2025-09-01 05:59:52.155	\N	2025-10-10 09:15:37.771363	ONLINE	f	[{"id": "RFBEOjEwMjQ3NzE3MjIyNDRV", "waybill": "1024771722244U", "carrierId": "DPD", "createdAt": "2025-09-03T04:21:22.205Z", "lineItems": [{"id": "b668fab0-86f8-11f0-80ea-6fda5b3014ee"}]}]	\N	0.00	\N	[]	f
8339	567ba210-a5fc-11f0-b989-75c7faccd1ca	\N	\N	2025-10-10 17:13:18.083	Anulowane	allegro-pl	87199662	Client:87199662	rph6a1n34f+3f99dd480@allegromail.pl	\N	Emilia  Pomińska	+48 537 503 175	Grunwaldzka 25 / 9	06-330	Chorzele	\N	56b306bd-a5fc-11f0-ae11-e76c74c7cf77	PAID	AF	t	405.20	\N	Allegro Kurier DPD	0.00	PLN	405.20	PLN	Eko skóra pikowana czarna 	t	\N	2025-10-10 17:13:35.742	\N	2025-10-10 20:52:42.827959	ONLINE	f	[]	\N	405.20	2025-10-10 20:44:09.844	[{"id": "df3830b6-a619-11f0-9e95-ebf32a67e13b", "order": {"id": "567ba210-a5fc-11f0-b989-75c7faccd1ca"}, "reason": "REFUND", "status": "IN_PROGRESS", "payment": {"id": "56b306bd-a5fc-11f0-ae11-e76c74c7cf77"}, "deposits": [], "createdAt": "2025-10-10T20:44:09.844Z", "lineItems": [{"id": "5674c440-a5fc-11f0-b989-75c7faccd1ca", "type": "AMOUNT", "value": {"amount": "405.20", "currency": "PLN"}}], "surcharges": [], "totalValue": {"amount": "405.20", "currency": "PLN"}}]	f
8402	bfbfb8f0-a6c0-11f0-a588-b391296a673a	\N	\N	2025-10-11 16:39:24.181	Gotowe do realizacji	allegro-pl	103710981	Client:103710981	k2iuq5ojxz+3ce5b1f72@allegromail.pl	\N	Katarzyna Chrzanowska	+48 510 229 952	Stajkowo 9,	78-200	Białogard	PL	bfd9d12f-a6c0-11f0-baf9-a33944a1116d	PAID	AF	t	413.99	PLN	Allegro Kurier DPD	14.99	PLN	413.99	PLN	\N	f	\N	2025-10-11 16:39:24.181	\N	2025-10-11 16:41:23.429421	ONLINE	f	[]	\N	0.00	\N	[]	f
8383	d9ee23e0-a681-11f0-bff7-bf511d875719	\N	\N	2025-10-11 09:09:29.829	Gotowe do realizacji	allegro-pl	102554306	Client:102554306	5xnrzx5b9z+785df7c74@allegromail.pl	\N	Żaneta Potorska	+48 724 661 150	Pątki 26	09-304	Lubowidz	PL	da0a379f-a681-11f0-baf9-a33944a1116d	PAID	P24	t	638.00	PLN	Allegro Kurier DPD	0.00	PLN	638.00	PLN	\N	t	\N	2025-10-11 09:09:29.829	\N	2025-10-11 09:10:04.257892	ONLINE	f	[]	\N	0.00	\N	[]	f
8387	6b3f9450-a687-11f0-bff7-bf511d875719	\N	\N	2025-10-11 09:51:06.466	Gotowe do realizacji	allegro-pl	105356445	Client:105356445	fihrehg2wn+7fa881d50@allegromail.pl	\N	Arek Felberg	+48 601 275 021	Spółdzielców 13/1	72-006	Mierzyn	PL	6b5dcae7-a687-11f0-91d4-7961b40d7b05	PAID	P24	t	737.00	PLN	Allegro Kurier DPD	0.00	PLN	737.00	PLN	dzień dobry. siedzisko chcę z skai gładkiej ES3 grafit 	t	\N	2025-10-11 09:51:06.466	\N	2025-10-11 09:53:38.665231	ONLINE	f	[]	\N	0.00	\N	[]	f
8381	c3c27b20-a681-11f0-9d9f-ab7e5bc5b8f5	\N	\N	2025-10-11 09:08:49.737	Gotowe do realizacji	allegro-pl	12762368	paankaap	dy4jk80an8+26f3713e6@allegromail.pl	\N	Anna Piekuś	+48 510 308 258	Szelonka 14d	43-600	Jaworzno	\N	c3fdd6cb-a681-11f0-96eb-67f4404dbe40	PAID	P24	t	594.00	PLN	Allegro Kurier DPD	0.00	PLN	594.00	PLN	\N	t	\N	2025-10-11 09:08:49.737	\N	2025-10-11 09:10:06.256971	ONLINE	f	[]	\N	0.00	\N	[]	f
8398	0a671880-a6b7-11f0-86f8-1b20137f27b1	\N	\N	2025-10-11 15:29:39.07	Gotowe do realizacji	allegro-pl	21530835	merida2008	o013gf5bqv+3c4df2d86@allegromail.pl	\N	Dorota Kaszuba	+48 505 846 811	ul. Leśna 49/2	32-085	Modlnica	PL	0a8ffd6e-a6b7-11f0-ae11-e76c74c7cf77	PAID	PAYU	t	352.00	PLN	Allegro Kurier DPD	0.00	PLN	352.00	PLN	\N	t	\N	2025-10-11 15:29:39.07	\N	2025-10-11 16:01:46.155843	ONLINE	f	[]	\N	0.00	\N	[]	f
8375	b27a9730-a66d-11f0-84af-1520c30fa31d	\N	\N	2025-10-11 06:46:30.594	Anulowane	allegro-pl	25031073	adamw2106	n34fa4xzjq+20485e551@allegromail.pl	\N	Adam Wołodźko	+48 608 015 702	\N	\N	\N	\N	b2a61407-a66d-11f0-bb32-51209e96d6bb	UNPAID	AF	t	\N	\N	Allegro Kurier DPD	0.00	PLN	510.00	PLN	\N	t	\N	2025-10-11 06:46:30.594	\N	2025-10-11 11:22:14.537581	ONLINE	f	[]	\N	0.00	\N	[]	f
8413	de8bf6b0-a6c8-11f0-8895-094b8cada9e7	\N	\N	2025-10-11 17:48:39.894	Gotowe do realizacji	allegro-pl	39907762	Client:39907762	s8jey9en7c+10578d413@allegromail.pl	\N	Przemysław Chaczko	+48 669 231 024	Jana Pawla 2 12a / 3	59-610	Wlen	\N	e0758213-a6c9-11f0-bdd7-1b3dfdcd18cd	PAID	PAYU	t	1333.99	\N	Allegro Kurier DPD	14.99	PLN	1333.99	PLN	\N	f	\N	2025-10-11 17:51:53.795	\N	2025-10-11 17:54:17.739795	ONLINE	f	[]	\N	0.00	\N	[]	f
8406	53f44c21-a6c6-11f0-a685-3b2ebe8a80a1	\N	\N	2025-10-11 17:28:02.98	Gotowe do realizacji	allegro-pl	107341369	Client:107341369	cbnhowy0m9+5346b19d0@allegromail.pl	\N	krzysztof parzuchowski	+48 725 364 719	setna1a\\1	74-400	debno	PL	449b0d37-a6c7-11f0-a284-071dd65bf45d	PAID	P24	t	314.00	PLN	Allegro Kurier DPD	0.00	PLN	314.00	PLN	\N	t	\N	2025-10-11 17:28:02.98	\N	2025-10-11 17:32:47.282074	ONLINE	f	[]	\N	0.00	\N	[]	f
8397	176e1b10-a6a2-11f0-bbf9-7f3870292d20	\N	\N	2025-10-11 12:59:40.981	Gotowe do realizacji	allegro-pl	113327660	Client:113327660	kw239wj4up+50ade8bd3@allegromail.pl	\N	Ewelina Szymczak	+48 665 750 981	Wrocławska 235	63-200	Jarocin	\N	21c7cbb2-a6a2-11f0-96eb-67f4404dbe40	PAID	P24	t	314.00	\N	Allegro Kurier DPD	0.00	PLN	314.00	PLN	\N	t	\N	2025-10-11 12:59:50.048	\N	2025-10-11 21:43:50.233371	ONLINE	f	[]	\N	0.00	\N	[]	f
\.


--
-- Data for Name: products; Type: TABLE DATA; Schema: allegro; Owner: neondb_owner
--

COPY allegro.products (id, product_id, external_id, name, description, image_url, category, created_at, updated_at) FROM stdin;
27	10862951244	5905806209020	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:00.268817	2025-10-10 09:08:53.327035
34	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	\N	\N	\N	2025-10-06 17:16:01.360803	2025-10-10 09:06:40.662435
41	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	\N	\N	\N	2025-10-06 17:16:02.302127	2025-10-10 18:58:47.63957
37	15155236665	5905806209099	Szafka na buty z szufladą Tres 60x30D2N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:01.723085	2025-10-09 19:39:57.070851
5	16724404597	5905806237191	Szafka na buty VB60x30D1N1 Dąb Estana	\N	\N	\N	2025-10-06 17:15:55.367397	2025-10-06 20:34:45.449282
57	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	\N	\N	\N	2025-10-06 17:16:05.11784	2025-10-12 07:54:28.114931
33	15221503220	5905806214192	Szafka na buty z szufladą Tres 80x30 Dąb Wotan	\N	\N	\N	2025-10-06 17:16:01.144793	2025-10-09 19:52:56.006326
23	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	\N	\N	\N	2025-10-06 17:15:59.543827	2025-10-09 19:56:56.000052
17	15919529373	5905806228229	Komoda Bones 60x36D4N1 SONOMA	\N	\N	\N	2025-10-06 17:15:58.24065	2025-10-06 20:34:50.851745
35	11873260685	5905806214246	Szafka na buty z szufladą Tres 80x82x36 SONOMA	\N	\N	\N	2025-10-06 17:16:01.360803	2025-10-10 09:08:25.736352
15	10983158854	5905806203691	Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów BIAŁY	\N	\N	\N	2025-10-06 17:15:57.801176	2025-10-10 09:04:59.177795
62	15176152026	5905806212952	Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan	\N	\N	\N	2025-10-06 17:16:06.095193	2025-10-09 19:56:54.685248
30	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	\N	\N	\N	2025-10-06 17:16:00.779237	2025-10-09 19:41:00.64849
26	15155170458	5905806208788	Szafka na buty z szufladą Tres 80x30D1N1 CZARNY BIAŁY	\N	\N	\N	2025-10-06 17:16:00.051972	2025-10-09 19:39:47.255143
29	14387673937	5905806202366	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Czarny BIAŁY	\N	\N	\N	2025-10-06 17:16:00.561855	2025-10-09 19:39:50.461152
18	15179529808	5905806213034	Szafka komoda na buty 50x30 D2N1 Altus Czarny	\N	\N	\N	2025-10-06 17:15:58.457404	2025-10-06 20:34:51.264554
54	15440331779	5905806218077	Zestaw VB80x30 Tres80x30 D1N1 szafka na buty siedzisko ARTISAN	\N	\N	\N	2025-10-06 17:16:04.599818	2025-10-09 19:40:14.39478
24	17496557717	5905806238860	Szafka na buty VB100x30 D3N3 CZARNY	\N	\N	\N	2025-10-06 17:15:59.76086	2025-10-09 19:39:45.567104
51	11957206330	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:03.948398	2025-10-10 09:07:11.067172
49	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	\N	\N	\N	2025-10-06 17:16:03.65876	2025-10-10 09:15:37.771363
55	16415950409	5905806231922	Szafka na buty VB50x36 D2N1 DĄB ARTISAN	\N	\N	\N	2025-10-06 17:16:04.818144	2025-10-09 19:40:15.890965
59	11769358337	5905806222357	Panel ścienny tapicerowany pan1x50x35	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-09 19:40:20.304219
11	17380187713	5905806202045	Szafka na buty VB60x30D1N1 Dąb Olejowany	\N	\N	\N	2025-10-06 17:15:56.714736	2025-10-06 20:34:47.944898
8	12487594818	5905806204988	Garderoba 80x30cm V50 Supra30 4 Panele D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:15:56.019495	2025-10-06 20:34:46.71877
21	16319665889	5905806234268	Komoda szafka NEX 80x30x124 sypialnia salon przedpokój D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:15:59.112099	2025-10-06 20:34:52.478694
19	12266463730	5905806203899	Szafka na buty z szufladą Tres 30x30x82 Biały	\N	\N	\N	2025-10-06 17:15:58.673348	2025-10-06 20:34:51.668214
16	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	\N	\N	\N	2025-10-06 17:15:58.019796	2025-10-11 09:10:04.257892
43	16602433072	5905806234473	Komoda Bini 50x30x82 D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:16:02.750302	2025-10-12 08:49:13.866852
42	16276323396	5905806233933	Komoda Bini 60x30D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:02.528744	2025-10-10 09:09:13.790623
48	15251020703	5905806218220	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 CZARNY	\N	\N	\N	2025-10-06 17:16:03.441281	2025-10-09 19:40:06.790098
63	15225570547	5905806213379	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:16:06.312678	2025-10-10 09:06:09.834505
6	15225572646	5905806213423	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 WOTAN	\N	\N	\N	2025-10-06 17:15:55.584	2025-10-06 20:34:45.860476
31	16602437468	5905806234688	Komoda Bini 80x36 D1N1 CZARNY	\N	\N	\N	2025-10-06 17:16:00.779237	2025-10-09 19:39:51.969786
9	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	\N	\N	\N	2025-10-06 17:15:56.281456	2025-10-12 10:57:57.475181
14	12258666208	5905806216974	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	\N	\N	\N	2025-10-06 17:15:57.584293	2025-10-10 09:09:04.175326
3	15410022839	5905806218855	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Dąb Wotan	\N	\N	\N	2025-10-06 17:15:54.931668	2025-10-10 14:27:45.459277
2	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:15:54.712851	2025-10-10 09:07:00.673569
65	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	\N	\N	\N	2025-10-06 17:16:06.745646	2025-10-11 08:53:53.391493
12	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	\N	\N	\N	2025-10-06 17:15:57.290996	2025-10-10 09:15:13.068956
7	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	\N	\N	\N	2025-10-06 17:15:55.802962	2025-10-11 21:51:37.251859
39	16723583463	5905806237160	Szafka na buty z lustrem Supra 60x36 Szafa z szufladą D1N1 DĄB WOTAN	\N	\N	\N	2025-10-06 17:16:02.012334	2025-10-09 19:39:58.724698
64	12476639410	5905204699454	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:06.528834	2025-10-12 10:53:35.288788
1	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	\N	\N	\N	2025-10-06 17:15:54.48828	2025-10-10 09:15:28.123644
25	15685809460	5905806222005	Szafka na buty z szufladą Tres 60x36D1N3 CZARNY	\N	\N	\N	2025-10-06 17:15:59.76086	2025-10-09 19:39:45.567104
28	14705411728	5905806203790	Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:00.268817	2025-10-09 19:39:48.761018
36	11711299117	5905806203677	Wieszak ścienny WP60 na ubrania 60cm Sonoma	\N	\N	\N	2025-10-06 17:16:01.360803	2025-10-10 15:05:19.598918
40	16458885091	5905806221473	Zestaw Tres60x36D1N1 3PAN WP60 WOTAN	\N	\N	\N	2025-10-06 17:16:02.012334	2025-10-09 19:39:58.724698
53	14563825336	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	\N	\N	\N	2025-10-06 17:16:04.383082	2025-10-10 20:17:50.309765
44	16276316851	5905806233896	Komoda Bini 60x30D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:16:02.750302	2025-10-09 19:40:03.351154
50	15258808621	5905806210873	Wieszak ścienny W50 na ubrania 50cm WOTAN	\N	\N	\N	2025-10-06 17:16:03.65876	2025-10-09 19:40:08.266022
47	11906888620	5905806203578	Szafka na buty VB100x30D S1 siedzisko schowek 100cm DĄB SONOMA	\N	\N	\N	2025-10-06 17:16:03.113694	2025-10-09 19:40:05.138351
38	12196322651	5905806203714	Wieszak ścienny WP60 na ubrania 60cm Lancelot	\N	\N	\N	2025-10-06 17:16:01.723085	2025-10-09 19:39:57.070851
56	15155237434	5905806209129	Szafka na buty z szufladą Tres 60x36D2N1 ARTISAN	\N	\N	\N	2025-10-06 17:16:04.818144	2025-10-09 19:40:15.890965
60	13463849818	5905806203813	Wieszak ścienny WP50 ubrania 50cm 4 haki Lancelot	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-09 19:40:20.304219
45	16602435582	5905806234596	Komoda Bini 80x30x82 D1N1 BIAŁY	\N	\N	\N	2025-10-06 17:16:02.750302	2025-10-09 19:40:03.351154
106	15225857105	5905806206678	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	\N	\N	\N	2025-10-06 17:16:15.595209	2025-10-10 09:15:26.886604
2465	15463830012	5905806220605	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Czarny Dąb Artisan	\N	\N	\N	2025-10-06 19:06:28.487973	2025-10-06 20:34:39.878245
80	16271360906	5905806233643	Szafka na buty Supra-Nex 30x30D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:09.916884	2025-10-09 19:40:48.482457
87	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:11.149895	2025-10-10 09:08:28.671307
75	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	\N	\N	\N	2025-10-06 17:16:08.824264	2025-10-10 09:08:21.318813
94	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	\N	\N	\N	2025-10-06 17:16:12.929991	2025-10-10 20:52:42.827959
99	12487659714	5905204699591	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 Lancelot	\N	\N	\N	2025-10-06 17:16:14.021211	2025-10-09 19:41:15.60664
74	15109022782	5905806207569	Garderoba 80x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-06 17:16:08.608804	2025-10-09 19:40:38.630984
97	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:13.585282	2025-10-09 19:41:12.644539
78	15977138561	5905806229035	Komoda Bones 50x36D4N1 CZARNY	\N	\N	\N	2025-10-06 17:16:09.483689	2025-10-09 19:40:45.426522
348	16859417789	5905806210613	Półka ścienna 80x18x20cm CZARNY	\N	\N	\N	2025-10-06 17:47:48.935022	2025-10-06 20:34:42.462722
921	16901470101	5905806211528	Wieszak ścienny WP100 na ubrania 100cm WOTAN	\N	\N	\N	2025-10-06 18:33:52.316864	2025-10-10 09:05:48.634355
77	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	\N	\N	\N	2025-10-06 17:16:09.262461	2025-10-10 09:06:38.383538
115	16602440992	5905806234763	Komoda Bini 100x36 D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:17.582405	2025-10-10 21:58:54.161418
4261	13855292522	5905806200010	Szafka na buty VB50x30 D1N1 siedzisko, schowek DĄB LANCELOT	\N	\N	\N	2025-10-09 19:30:10.421346	2025-10-09 19:32:59.478629
2071	14384920401	5905806201840	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm DĄB ARTISAN	\N	\N	\N	2025-10-06 18:54:54.271088	2025-10-06 20:34:40.421628
84	11750203551	5905806208344	Szafka na buty z szufladą Tres 60x36 Biały	\N	\N	\N	2025-10-06 17:16:10.568092	2025-10-10 09:08:39.351059
105	14387674513	5905806202397	Szafka na buty VB80x36D S1 siedzisko schowek 80cm SO	\N	\N	\N	2025-10-06 17:16:15.373135	2025-10-09 19:41:24.543023
104	16625973548	5905806222531	Siedzisko tapicerowane 50x29cm do szafki 50x30	\N	\N	\N	2025-10-06 17:16:15.120059	2025-10-09 19:41:22.997025
81	15221043005	5905806208320	Szafka na buty z szufladą Tres 60x36 Dąb Artisan	\N	\N	\N	2025-10-06 17:16:10.134542	2025-10-09 19:40:49.965101
91	11769334649	5905806208429	Panel ścienny tapicerowany pan1x60x30	\N	\N	\N	2025-10-06 17:16:12.241757	2025-10-10 09:08:15.281997
112	15685820231	5905806221923	Szafka na buty z szufladą Tres 60x30D1N3 CZARNY	\N	\N	\N	2025-10-06 17:16:16.919578	2025-10-06 17:22:43.502874
113	16645309565	5905806216813	Szafka na buty VB80x30D1N2 LANCELOT	\N	\N	\N	2025-10-06 17:16:17.140211	2025-10-06 17:22:43.709715
88	16602433840	5905806234503	Komoda Bini 50x30x82 D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:11.372612	2025-10-09 19:40:57.767472
90	15112615224	5905806208528	Zestaw szafka na buty siedzisko VB60x30D1N1 Tres60 z szufladą Czarny Sonoma	\N	\N	\N	2025-10-06 17:16:11.988705	2025-10-09 19:41:02.125041
61	15440328552	5905806216875	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko LANCELOT	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-09 19:40:20.304219
98	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	\N	\N	\N	2025-10-06 17:16:13.804885	2025-10-10 09:05:56.557582
70	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	\N	\N	\N	2025-10-06 17:16:07.872784	2025-10-10 18:24:08.717366
4274	12266508963	5905204699102	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	\N	\N	\N	2025-10-09 19:31:29.906789	2025-10-10 20:52:33.228359
347	15919784886	5905806228991	Komoda Bones 50x36D1N1 WOTAN	\N	\N	\N	2025-10-06 17:47:48.719607	2025-10-10 09:15:20.638285
109	11769094598	5905806204087	Szafka na buty VB100x30D S1 siedzisko schowek 100cm BIAŁY	\N	\N	\N	2025-10-06 17:16:16.253145	2025-10-06 18:44:05.727554
72	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	\N	\N	\N	2025-10-06 17:16:08.165996	2025-10-10 09:15:31.699995
83	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	\N	\N	\N	2025-10-06 17:16:10.568092	2025-10-10 09:15:02.638995
66	15315950401	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:06.963906	2025-10-09 19:57:56.94902
4269	16859415981	5905806210293	Półka ścienna 50x18x20cm WOTAN	\N	\N	\N	2025-10-09 19:31:22.023459	2025-10-09 19:33:05.168128
349	12487594410	5905204699560	Garderoba 80x30cm V50 Supra30 4 Panele D1 BIAŁY	\N	\N	\N	2025-10-06 17:47:49.145144	2025-10-06 20:34:42.937473
13	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	\N	\N	\N	2025-10-06 17:15:57.290996	2025-10-10 09:06:47.281936
32	15221331957	5905806214109	Szafka na buty z szufladą Tres 50x36 Czarny	\N	\N	\N	2025-10-06 17:16:00.779237	2025-10-09 19:39:51.969786
4270	15155167503	5905806208443	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	\N	\N	\N	2025-10-09 19:31:23.649783	2025-10-09 19:57:49.555196
101	15176150939	5905806209549	Szafka komoda na buty 80x30 D2N1 Altus CZARNY	\N	\N	\N	2025-10-06 17:16:14.4606	2025-10-09 19:41:18.581203
2464	15250482464	5905806215212	Garderoba 110x36D1N1 SUPRA60 TRES50 3PAN-WP50 CZARNY ARTISAN	\N	\N	\N	2025-10-06 19:06:28.487973	2025-10-06 20:34:39.878245
4281	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	\N	\N	\N	2025-10-09 19:31:40.905893	2025-10-11 16:01:46.155843
102	15176150526	5905806209525	Szafka komoda na buty 80x30 D2N1 Altus WOTAN	\N	\N	\N	2025-10-06 17:16:14.681236	2025-10-10 09:15:24.464693
73	15919782083	5905806228946	Komoda Bones 50x36D1N1 ARTISAN	\N	\N	\N	2025-10-06 17:16:08.392572	2025-10-09 19:40:37.130684
92	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:12.494462	2025-10-10 15:05:19.598918
76	15121615649	5905806205138	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1D1Wotan	\N	\N	\N	2025-10-06 17:16:09.045078	2025-10-09 19:40:41.82403
4273	16271341145	5905806233391	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 WOTAN	\N	\N	\N	2025-10-09 19:31:28.322666	2025-10-09 19:33:10.435375
350	17395006524	5905806238310	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	\N	\N	\N	2025-10-06 17:47:49.356668	2025-10-10 09:08:12.252069
4	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	\N	\N	\N	2025-10-06 17:15:55.148372	2025-10-10 09:06:52.039093
4278	16698543601	5905806237023	Garderoba z lustrem 90x30cm V60 Supra30 4 Panele D1N1 Dąb Wotan	\N	\N	\N	2025-10-09 19:31:36.142585	2025-10-10 09:07:14.363358
114	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	\N	\N	\N	2025-10-06 17:16:17.357182	2025-10-10 11:57:15.495963
4275	16602435285	5905806234589	Komoda Bini 50x36 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:31:31.443342	2025-10-09 19:33:13.158206
93	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	\N	\N	\N	2025-10-06 17:16:12.713229	2025-10-10 09:06:21.269184
4279	14387672711	5905806202335	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Cza Wotan	\N	\N	\N	2025-10-09 19:31:37.693463	2025-10-09 19:33:18.40805
82	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	\N	\N	\N	2025-10-06 17:16:10.351011	2025-10-10 09:08:59.481909
4392	16415944014	5905806231885	Szafka na buty VB100x30D2N1 ARTISAN	\N	\N	\N	2025-10-09 19:34:59.370898	2025-10-09 19:34:59.370898
4280	16901480273	5905806234022	Wieszak ścienny WP60 na ubrania 60cm CZARNY WOTAN	\N	\N	\N	2025-10-09 19:31:37.693463	2025-10-09 19:33:18.40805
4361	16319658329	5905806234398	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 SONOMA	\N	\N	\N	2025-10-09 19:34:18.70771	2025-10-09 19:35:02.367047
4287	12224099030	5905204699249	Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:31:51.486236	2025-10-10 09:15:23.254274
4353	15408455867	5905806218688	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 WOTAN BIAŁY	\N	\N	\N	2025-10-09 19:34:06.275499	2025-10-10 09:06:37.180642
4401	12263585961	5905204699218	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:35:12.962774	2025-10-09 19:35:12.962774
4289	15876902214	5905806215175	Szafka nocna 40x36 Nox dwie szuflady schowek CZARNY	\N	\N	\N	2025-10-09 19:31:54.529971	2025-10-09 19:33:34.232752
4291	15225620833	5905806213386	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY	\N	\N	\N	2025-10-09 19:31:57.659294	2025-10-09 19:33:37.044975
4292	14388158414	5905806202694	Garderoba 50x36P2WPB szafka na buty wieszak Sonoma	\N	\N	\N	2025-10-09 19:31:59.239898	2025-10-09 19:33:38.4484
4518	16644957145	5905806204179	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele WOTAN	\N	\N	\N	2025-10-09 19:52:52.87265	2025-10-09 19:52:52.87265
4294	17358967427	5905806237825	Garderoba 60x36D1N1-4PAN WP szafka na buty wieszak panele Kaszmir	\N	\N	\N	2025-10-09 19:32:02.509518	2025-10-09 19:33:41.242995
4525	10945431249	5905806208191	Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały	\N	\N	\N	2025-10-09 19:53:02.566909	2025-10-09 19:57:37.239716
4345	10862932479	5905806209532	Szafka komoda na buty 80x30 D2N1 Altus BIAŁY	\N	\N	\N	2025-10-09 19:33:55.297684	2025-10-09 19:33:55.297684
4347	15178440255	5905806210118	Szafka komoda na buty 80x36 D2N2 Altus ARTISAN	\N	\N	\N	2025-10-09 19:33:58.363732	2025-10-09 19:33:58.363732
4351	15919730348	5905806228830	Komoda Bones 60x30D1N1 SONOMA	\N	\N	\N	2025-10-09 19:34:04.745058	2025-10-09 19:34:04.745058
4352	16521833793	5905806227130	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1N1 WOTAN BIAŁY	\N	\N	\N	2025-10-09 19:34:06.275499	2025-10-09 19:34:06.275499
4508	15446678390	5905806219623	Szafka na buty 60x30D2N1Supra SONOMA	\N	\N	\N	2025-10-09 19:52:37.640577	2025-10-09 19:52:37.640577
4366	14910130346	5905806204049	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-09 19:34:27.019116	2025-10-09 19:34:27.019116
4367	14910130495	5905806204056	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele BIAŁY	\N	\N	\N	2025-10-09 19:34:28.488246	2025-10-09 19:34:28.488246
4369	16859419202	5905806210439	Półka ścienna 60x18x20cm WOTAN	\N	\N	\N	2025-10-09 19:34:31.511017	2025-10-09 19:34:33.083616
4403	14024671782	5905806201307	Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Lancelot	\N	\N	\N	2025-10-09 19:35:15.94631	2025-10-09 19:35:15.94631
4375	15319542575	5905806213973	Garderoba 110x36D1N2 Supra30 VB80 4 Panele WP80 WOTAN	\N	\N	\N	2025-10-09 19:34:39.487081	2025-10-09 19:34:39.487081
4376	16625971969	5905806222524	Siedzisko tapicerowane 80x29cm do szafki 80x30	\N	\N	\N	2025-10-09 19:34:41.063664	2025-10-09 19:34:41.063664
4372	14383316918	5905806201758	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały	\N	\N	\N	2025-10-09 19:34:35.013449	2025-10-09 19:34:42.565499
4378	17636751422	5905806205121	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 SONOMA	\N	\N	\N	2025-10-09 19:34:44.063468	2025-10-09 19:34:44.063468
4383	12196226645	5905806203615	Wieszak ścienny WP80 na ubrania 80cm Lancelot	\N	\N	\N	2025-10-09 19:34:48.866238	2025-10-09 19:34:48.866238
4384	15919728876	5905806228793	Komoda Bones 60x36D1N1 ARTISAN	\N	\N	\N	2025-10-09 19:34:50.349499	2025-10-09 19:34:51.982135
4304	16271340785	5905806233292	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA	\N	\N	\N	2025-10-09 19:32:16.817152	2025-10-09 19:57:35.69216
4390	15221332021	5905806214130	Szafka na buty z szufladą Tres 50x36 Dąb Wotan	\N	\N	\N	2025-10-09 19:34:56.309954	2025-10-09 19:34:56.309954
4391	16276325492	5905806233957	Komoda Bini 60x36D1N1 BIAŁY	\N	\N	\N	2025-10-09 19:34:57.866778	2025-10-09 19:34:57.866778
4530	12476571893	5905204699492	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Biały	\N	\N	\N	2025-10-09 19:53:10.465002	2025-10-09 19:53:10.465002
4359	15321911032	5905806216912	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Artisan	\N	\N	\N	2025-10-09 19:34:15.671607	2025-10-10 09:15:14.295526
4509	15221504597	5905806214253	Szafka na buty z szufladą Tres 80x36 Dąb Wotan	\N	\N	\N	2025-10-09 19:52:37.640577	2025-10-09 19:56:39.284741
85	11750247503	5905806214208	Szafka na buty z szufladą Tres 80x36D1N1 Biały	\N	\N	\N	2025-10-06 17:16:10.568092	2025-10-09 19:40:52.977557
4380	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	\N	\N	\N	2025-10-09 19:34:45.591752	2025-10-10 09:08:18.401888
4503	15112696167	5905806208566	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Biały	\N	\N	\N	2025-10-09 19:52:32.634675	2025-10-09 19:52:32.634675
4527	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	\N	\N	\N	2025-10-09 19:53:05.921164	2025-10-10 09:08:37.870699
4506	12258788829	5905806216936	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:52:37.640577	2025-10-09 19:52:37.640577
4507	11742813479	5905806204025	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele SONOMA	\N	\N	\N	2025-10-09 19:52:37.640577	2025-10-09 19:52:37.640577
4510	15225574066	5905806213461	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 CZARNY BIAŁY	\N	\N	\N	2025-10-09 19:52:39.753389	2025-10-09 19:52:39.753389
4293	15321913673	5905806216943	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan	\N	\N	\N	2025-10-09 19:32:00.94504	2025-10-09 19:52:41.570887
4513	16383693560	5905806234046	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój BIAŁY	\N	\N	\N	2025-10-09 19:52:44.773914	2025-10-09 19:52:44.773914
4523	15315961595	5905806214673	Szafka na buty z szufladą Tres 100x30D1N1 BIAŁY	\N	\N	\N	2025-10-09 19:53:00.995018	2025-10-09 19:53:00.995018
4362	12258723368	5905806216981	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Sonoma	\N	\N	\N	2025-10-09 19:34:20.228418	2025-10-09 19:53:04.368113
4516	15410023447	5905806218879	Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan	\N	\N	\N	2025-10-09 19:52:49.691873	2025-10-11 21:16:53.127281
4381	16602434536	5905806234527	Komoda Bini 50x30x82 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:34:47.220975	2025-10-10 09:09:00.687175
4411	17358940752	5905806237801	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	\N	\N	\N	2025-10-09 19:35:30.351716	2025-10-10 09:05:45.303072
4405	13854397976	5905204699997	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN	\N	\N	\N	2025-10-09 19:35:18.983524	2025-10-11 08:52:43.159432
4350	14655550516	5905806205015	Garderoba 80x30cm SU30 VB-4PAN-WP50 D1N1 Wotan	\N	\N	\N	2025-10-09 19:34:03.124553	2025-10-10 09:05:25.990796
4282	15919776759	5905806228861	Komoda Bones 60x36D1N1 SONOMA	\N	\N	\N	2025-10-09 19:31:42.479409	2025-10-10 15:05:19.598918
4522	15440332407	5905806218176	Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko ARTISAN	\N	\N	\N	2025-10-09 19:52:59.035883	2025-10-10 09:05:39.657085
4407	16271344068	5905806233490	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN	\N	\N	\N	2025-10-09 19:35:22.641558	2025-10-10 09:08:33.20268
4368	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	\N	\N	\N	2025-10-09 19:34:29.944915	2025-10-10 10:15:33.711674
4515	15229738794	5905806214574	Szafka na buty z szufladą Tres 100x36D1N1 WOTAN	\N	\N	\N	2025-10-09 19:52:48.104858	2025-10-11 08:52:48.250918
71	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	\N	\N	\N	2025-10-06 17:16:07.872784	2025-10-11 16:41:23.429421
4389	15319529269	5905806213812	Garderoba 110x36D1N1 Supra30 VB80 4 Panele WP80 CZARNY WOTAN	\N	\N	\N	2025-10-09 19:34:54.833203	2025-10-10 09:15:16.97062
4533	16602441323	5905806234770	Komoda Bini 100x36 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:53:15.032791	2025-10-09 19:53:15.032791
4537	15251019919	5905806204162	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 WOTAN	\N	\N	\N	2025-10-09 19:53:21.391471	2025-10-09 19:53:21.391471
4542	16383698094	5905806234084	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój CZARNY	\N	\N	\N	2025-10-09 19:53:26.173347	2025-10-09 19:53:26.173347
4543	15134391509	5905806209372	Szafka 60x30D1N2 komoda wysoka Supra T2 BIAŁY CZARNY	\N	\N	\N	2025-10-09 19:53:27.696527	2025-10-09 19:53:27.696527
4828	11587466207	5905806204223	Szafka na buty z wieszakiem 60x36WP60 N1D1 Dąb Sonoma	\N	\N	\N	2025-10-10 09:05:06.540663	2025-10-10 09:05:06.540663
4547	12266500239	5905204699126	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele SONOMA	\N	\N	\N	2025-10-09 19:53:33.737674	2025-10-09 19:56:32.292077
4830	17681537577	5905806202373	Szafka na buty VB80x30D1N1 CZARNY	\N	\N	\N	2025-10-10 09:05:08.889367	2025-10-10 09:05:08.889367
4553	17358870548	5905806237849	Szafka na buty z szufladą Tres 30x36D1N1 Kaszmir	\N	\N	\N	2025-10-09 19:53:42.878691	2025-10-09 19:56:40.880156
4558	12405971238	5905204699140	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Biały	\N	\N	\N	2025-10-09 19:53:51.995858	2025-10-09 19:56:49.168469
4560	15258837181	5905806211023	Wieszak ścienny W60 na ubrania 60cm LANCELOT	\N	\N	\N	2025-10-09 19:53:53.565148	2025-10-09 19:56:50.506069
4589	15193798429	5905806213133	Garderoba 100x36cm Supra50 VB50 4 Panele WP50 D1N1 Biały	\N	\N	\N	2025-10-09 19:54:36.654006	2025-10-10 09:05:54.322254
4565	17477972814	5905806238716 	Garderoba 80x36D1N1 Supra30Tres50 3PAN WP50 KASZMIR	\N	\N	\N	2025-10-09 19:54:01.464395	2025-10-12 10:06:24.359614
4349	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	\N	\N	\N	2025-10-09 19:34:01.533573	2025-10-11 08:52:51.907556
4650	16602435161	5905806234572	Komoda Bini 50x36 D1N1 SONOMA	\N	\N	\N	2025-10-09 19:57:53.994553	2025-10-10 09:08:58.104979
4843	14933823645	5905806204124	Szafka na buty VB100x30D siedzisko schowek WOTAN	\N	\N	\N	2025-10-10 09:05:22.60755	2025-10-11 11:22:14.537581
4574	16271343737	5905806233476	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 LANCELOT	\N	\N	\N	2025-10-09 19:54:13.839513	2025-10-09 19:57:08.02041
4585	16760747405	5905806236156	Garderoba 80x36D1N2 4PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-09 19:54:30.407398	2025-10-09 19:57:22.849985
4633	15919629053	5905806228588	Garderoba Bones 120x36D4N1 VB60 3PWP60 SONOMA	\N	\N	\N	2025-10-09 19:57:29.728304	2025-10-09 19:57:29.728304
4636	12266500390	5905204699133	Garderoba 90x30cm VB60 Supra30 4 Panele D1N1 LANCELOT	\N	\N	\N	2025-10-09 19:57:34.124208	2025-10-09 19:57:34.124208
4837	14705402999	5905806203769	Wieszak ścienny WP50 na ubrania 50cm Dąb Wotan	\N	\N	\N	2025-10-10 09:05:16.887598	2025-10-10 09:05:16.887598
4841	15026476159	5905806204742	Szafka na buty VB60x36D S1 siedzisko schowek 60cm CZARNY	\N	\N	\N	2025-10-10 09:05:20.341392	2025-10-10 09:05:20.341392
4847	15121482732	5905806201710	Garderoba 80x30cm SU30 VB-4PAN-WP50 N1 Cza D1 Wotan	\N	\N	\N	2025-10-10 09:05:27.116693	2025-10-10 09:05:27.116693
4848	12405971611	5905204699171	Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Biały	\N	\N	\N	2025-10-10 09:05:28.262313	2025-10-10 09:05:28.262313
4849	14387675064	5905806202434	Szafka na buty VB80x36D S1 siedzisko schowek 80cm LANCELOT	\N	\N	\N	2025-10-10 09:05:29.399928	2025-10-10 09:05:29.399928
4853	15179691397	5905806203912	Szafka na buty z szufladą Tres 30x30x82 Dąb Wotan	\N	\N	\N	2025-10-10 09:05:33.905502	2025-10-10 09:05:33.905502
4655	15258837630	5905806211030	Wieszak ścienny W60 na ubrania 60cm ARISTAN	\N	\N	\N	2025-10-09 19:58:01.535305	2025-10-10 09:05:35.022959
4856	17441796662	5905806238471	Szafka na buty z siedziskiem, schowek Vb50x30 D1N1 Dąb Estana	\N	\N	\N	2025-10-10 09:05:36.243704	2025-10-10 09:05:36.243704
4790	15048053986	5905806205466	Szafka na buty VB100x36D S1 siedzisko schowek 100cm Wotan	\N	\N	\N	2025-10-10 08:00:16.25573	2025-10-10 08:02:21.199439
4855	14604283135	5905806203684	Wieszak ścienny WP60 na ubrania 60cm Dąb Artisan	\N	\N	\N	2025-10-10 09:05:35.022959	2025-10-10 09:07:16.617547
4704	15919781224	5905806228939	Komoda Bones 50x30D1N1 WOTAN	\N	\N	\N	2025-10-10 07:00:43.397096	2025-10-10 08:02:29.93418
4815	16901480801	5905806236439	Wieszak ścienny WP60 na ubrania 60cm ARTISAN CZARNY	\N	\N	\N	2025-10-10 09:04:54.445973	2025-10-10 09:04:54.445973
4817	16458883972	5905806221466	Zestaw Tres60x36D1N1 3PAN WP60 SONOMA	\N	\N	\N	2025-10-10 09:04:56.676577	2025-10-10 09:04:56.676577
4864	16383705242	5905806234183	Komoda szafka NEX 60x36x124 D1N1 sypialnia salon przedpokój WOTAN	\N	\N	\N	2025-10-10 09:05:44.16789	2025-10-10 09:05:44.16789
4820	10862742707	5905806202267	Szafka na buty VB80x30D1N1 SONOMA	\N	\N	\N	2025-10-10 09:05:00.358808	2025-10-10 09:05:00.358808
4883	16859417616	5905806210590	Półka ścienna 80x18x20cm ARTISAN	\N	\N	\N	2025-10-10 09:06:04.106554	2025-10-10 09:06:04.106554
4823	11769354306	5905806222432	Panel ścienny tapicerowany pan1x80x35	\N	\N	\N	2025-10-10 09:05:02.716351	2025-10-10 09:05:02.716351
4825	11711339631	5905806211184	Wieszak ścienny W80 na ubrania 80cm BIAŁY	\N	\N	\N	2025-10-10 09:05:02.716351	2025-10-10 09:05:02.716351
4688	16602436084	5905806234619	Komoda Bini 80x30x82 D1N1 CZARNY	\N	\N	\N	2025-10-09 21:14:47.270115	2025-10-10 06:52:47.535333
4569	11873257937	5905806208351	Szafka na buty z szufladą Tres 60x36 Dąb Sonoma	\N	\N	\N	2025-10-09 19:54:06.148716	2025-10-10 09:09:11.265188
4826	12619279717	5905806229974	Szafka szafa wysoka supra VINI 50x36x202D1-BIA	\N	\N	\N	2025-10-10 09:05:04.121767	2025-10-10 09:05:04.121767
4827	12619326684	5905806230390	Szafka szafa wysoka supra VINI 50x36x202D1-LAN	\N	\N	\N	2025-10-10 09:05:05.295165	2025-10-10 09:05:05.295165
4536	15440329487	5905806217995	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko SONOMA	\N	\N	\N	2025-10-09 19:53:19.823755	2025-10-10 09:05:38.439759
4551	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	\N	\N	\N	2025-10-09 19:53:39.800122	2025-10-10 09:08:50.844741
4869	15250476488	5905806215076	Garderoba 110x30D1N1 SUPRA60 TRES50 3PAN-WP50 WOTAN	\N	\N	\N	2025-10-10 09:05:49.773175	2025-10-10 09:05:49.773175
4877	15258856313	5905806211177	Wieszak ścienny W80 na ubrania 80cm ARTISAN	\N	\N	\N	2025-10-10 09:05:57.681164	2025-10-10 09:05:57.681164
4561	11769341228	5905806208412	Panel ścienny tapicerowany pan1x80x30	\N	\N	\N	2025-10-09 19:53:55.230226	2025-10-10 09:06:00.658867
4882	15321915196	5905806216998	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Dąb Wotan	\N	\N	\N	2025-10-10 09:06:02.973804	2025-10-10 09:06:02.973804
4870	15919776102	5905806228847	Komoda Bones 60x30D1N1 WOTAN	\N	\N	\N	2025-10-10 09:05:49.773175	2025-10-10 12:30:02.663054
4887	14209649341	5905806201628	Szafka na buty Supra 30 słupek 30x30 D1N1 Artisan	\N	\N	\N	2025-10-10 09:06:08.662077	2025-10-10 09:06:08.662077
4892	12266464744	72144892264	Szafka na buty z szufladą Tres 30x36D1N1 LANCELOT	\N	\N	\N	2025-10-10 09:06:14.306109	2025-10-10 09:06:14.306109
4893	15019336887	10945550283	Szafka na buty z wieszakiem 60x36WP60 N1D1 Dąb Lancelot	\N	\N	\N	2025-10-10 09:06:14.306109	2025-10-10 09:06:14.306109
4894	11711322472	5905806211207	Wieszak ścienny W80 na ubrania 80cm Sonoma	\N	\N	\N	2025-10-10 09:06:15.542125	2025-10-10 09:06:15.542125
4566	17478159653	5905806238679	Zestaw Tres60x36D1N1 3PAN WP60 KASZMIR	\N	\N	\N	2025-10-09 19:54:01.464395	2025-10-10 09:06:34.958014
4582	15112614579	5905806208504	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Wotan	\N	\N	\N	2025-10-09 19:54:25.797748	2025-10-10 09:06:45.08619
4640	10862725041	5905204699966	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm Dąb Sonoma	\N	\N	\N	2025-10-09 19:57:40.882458	2025-10-10 11:13:47.267817
4651	14209799601	5905806201659	Szafka na buty Supra 30x30 D1N1 słupek Wotan	\N	\N	\N	2025-10-09 19:57:55.455939	2025-10-10 09:09:17.256463
4844	14384919344	5905806201826	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm WOTAN	\N	\N	\N	2025-10-10 09:05:23.761014	2025-10-10 18:24:08.717366
4852	12266508806	5905204699096	Garderoba 90x36cm V60 Supra30 4 Panele D1 SO	\N	\N	\N	2025-10-10 09:05:32.744761	2025-10-12 11:43:02.233555
4895	16416064559	5905806231496	Zestaw 160x30 D2N1 Altus80 i VB80 szafka na buty z siedziskiem SONOMA	\N	\N	\N	2025-10-10 09:06:15.542125	2025-10-10 09:06:15.542125
4898	15252962557	5905806215441	Garderoba 50x30D1N1 VB50 4Panele WP50 Dąb Artisan	\N	\N	\N	2025-10-10 09:06:19.006753	2025-10-10 09:06:19.006753
4903	12170501979	5905806217056	Komoda z szufladami Vini 60x30 D1N1 BIAŁY	\N	\N	\N	2025-10-10 09:06:24.618966	2025-10-10 09:06:24.618966
4905	15121910649	5905806208993	Szafka na buty Supra 30 słupek 30x36 D1N1 Artisan	\N	\N	\N	2025-10-10 09:06:26.865947	2025-10-10 09:06:26.865947
4906	11769266590	5905806218329	Szafka na buty z wieszakiem VB80x36WP80 N1D1 Sonoma	\N	\N	\N	2025-10-10 09:06:27.999834	2025-10-10 09:06:27.999834
4918	16941975822	5905806224856	Szafka na buty VB50x30 D1N1 BIAŁY WOTAN	\N	\N	\N	2025-10-10 09:06:37.180642	2025-10-10 09:06:37.180642
4930	15462816021	5905806203783	Garderoba 140x30cm V60 Supra80 4 Panele D1N1 Dąb Wotan	\N	\N	\N	2025-10-10 09:06:48.465439	2025-10-10 09:06:48.465439
4931	15376846701	5905806218336	Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Wotan	\N	\N	\N	2025-10-10 09:06:48.465439	2025-10-10 09:06:48.465439
4932	16624573640	5905806222517	Siedzisko tapicerowane 80x34cm do szafki 80x36	\N	\N	\N	2025-10-10 09:06:49.72532	2025-10-10 09:06:49.72532
4933	12473744209	5905204699270	Garderoba 140x30cm V60 Supra80 4 Panele D1N1 Biały	\N	\N	\N	2025-10-10 09:06:50.872419	2025-10-10 09:06:50.872419
4936	11750292362	5905806214024	Szafka na buty z szufladą Tres 50x30 Biały	\N	\N	\N	2025-10-10 09:06:54.278609	2025-10-10 09:06:54.278609
4836	15372387033	5905806217919	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko ARTISAN	\N	\N	\N	2025-10-10 09:05:15.750705	2025-10-10 09:07:17.733174
4909	11939053008	5905806210903	Wieszak ścienny W50 na ubrania 50cm BIAŁY	\N	\N	\N	2025-10-10 09:06:31.365566	2025-10-10 09:08:16.944249
4938	16678160899	5905806236781	Szafka na buty z wieszakiem VB100x36WP100 N1D1 Biały	\N	\N	\N	2025-10-10 09:06:56.557342	2025-10-10 09:06:56.557342
4940	12487594670	5905204699522	Garderoba 90x30cm Altus60 Supra2 3PanD2N1 Lancelot	\N	\N	\N	2025-10-10 09:06:59.491131	2025-10-10 09:06:59.491131
4944	15197586675	5905806213270	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Czarny	\N	\N	\N	2025-10-10 09:07:04.20065	2025-10-10 09:07:04.20065
4949	15315951498	5905806214703	Szafka na buty z szufladą Tres 100x36D2N1 SONOMA	\N	\N	\N	2025-10-10 09:07:08.807329	2025-10-10 09:07:08.807329
4955	16276324879	5905806233940	Komoda Bini 60x30D1N1 WOTAN	\N	\N	\N	2025-10-10 09:07:15.495914	2025-10-10 09:07:15.495914
4961	14024673763	5905806201345	Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Wotan	\N	\N	\N	2025-10-10 09:07:22.195712	2025-10-10 09:07:22.195712
4965	11750299498	5905806229042	Szafka na buty z szufladą i siedziskiem 60x36DP3B	\N	\N	\N	2025-10-10 09:08:15.281997	2025-10-10 09:08:15.281997
4971	11743135331	5905806202663	Garderoba 50x36P2WPB szafka na buty wieszak panele	\N	\N	\N	2025-10-10 09:08:24.239043	2025-10-10 09:08:24.239043
4976	16772019498	5905806227147	Garderoba 90x30D1N2 SUPRA30 VB-4PAN-WP60 ARTISAN	\N	\N	\N	2025-10-10 09:08:31.690864	2025-10-10 09:08:31.690864
4978	15179532455	5905806212990	Szafka komoda na buty 50x36 D2N1 Altus Czarny	\N	\N	\N	2025-10-10 09:08:34.702378	2025-10-10 09:08:34.702378
4979	14384926044	5905806201970	Szafka na buty VB50x36 D1N1 siedzisko 50cm Czarny	\N	\N	\N	2025-10-10 09:08:34.702378	2025-10-10 09:08:34.702378
4984	12258787126	5905806216929	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Biały	\N	\N	\N	2025-10-10 09:08:42.263184	2025-10-10 09:08:42.263184
4988	11711331990	5905806211047	Wieszak ścienny W60 na ubrania 60cm BIAŁY	\N	\N	\N	2025-10-10 09:08:48.547713	2025-10-10 09:08:48.547713
4993	12266416456	5905806208979	Szafka na buty Supra 30 słupek 30x36 D1N1 Sonoma	\N	\N	\N	2025-10-10 09:08:51.984445	2025-10-10 09:08:51.984445
4996	15919778228	5905806228885	Komoda Bones 50x30D1N1 BIAŁY	\N	\N	\N	2025-10-10 09:08:55.597626	2025-10-10 09:08:55.597626
4997	15321914537	5905806216950	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Czarny	\N	\N	\N	2025-10-10 09:08:56.761627	2025-10-10 09:08:56.761627
5004	15194005392	5905806213164	Garderoba 100x36cm Supra50 VB50 4 Panele WP50 D1N1 Dąb Wotan	\N	\N	\N	2025-10-10 09:09:05.458149	2025-10-10 09:09:05.458149
5005	16319656327	5905806234367	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 ARTISAN	\N	\N	\N	2025-10-10 09:09:06.607262	2025-10-10 09:09:06.607262
5009	16271296713	5905806233322	Komoda szafka NEX 50x30 sypialnia salon przedpokój D1N1 SONOMA	\N	\N	\N	2025-10-10 09:09:11.265188	2025-10-10 09:09:11.265188
5016	16319659755	5905806234411	Komoda szafka NEX 80x36x124 sypialnia salon przedpokój D1N1 CZARNY ARTISAN	\N	\N	\N	2025-10-10 09:09:16.113565	2025-10-10 09:09:16.113565
5019	16859418115	5905806210620	Półka ścienna 80x18x20cm SONOMA	\N	\N	\N	2025-10-10 09:14:58.880964	2025-10-10 09:15:00.15466
5029	17495949501	5905806238723	Szafka na buty VB50x30 D3N3 BIAŁY	\N	\N	\N	2025-10-10 09:15:11.667186	2025-10-10 09:15:11.667186
5033	16631278773	5905806236668	Szafka na buty z szufladą Tres 80x30D2N1 SONOMA	\N	\N	\N	2025-10-10 09:15:15.658562	2025-10-10 09:15:15.658562
5035	16602441568	5905806234794	Komoda Bini 100x30x82 D1N1 BIAŁY	\N	\N	\N	2025-10-10 09:15:18.168459	2025-10-10 09:15:18.168459
5036	16724405338	5905806237207	Szafka na buty VB60x36D1N1 Dąb Estana	\N	\N	\N	2025-10-10 09:15:19.393478	2025-10-10 09:15:19.393478
4973	12266488350	5905204699119	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele BIAŁY	\N	\N	\N	2025-10-10 09:08:27.183737	2025-10-10 09:15:29.31533
4986	11873232153	5905806214062	Szafka na buty z szufladą Tres 50x30 Dąb Sonoma	\N	\N	\N	2025-10-10 09:08:45.492832	2025-10-10 09:15:30.50539
5047	16632260455	5905806225464	Szafka na buty VB50x30 D1N1 ARTISAN CZARNY	\N	\N	\N	2025-10-10 09:15:32.905688	2025-10-10 09:15:32.905688
5049	15463007408	5905806220391	Garderoba 140x30cm V60 Supra80 4 Panele D1N1 Dąb Artisan	\N	\N	\N	2025-10-10 09:15:35.323801	2025-10-10 09:15:35.323801
5050	14387676426	5905806202502	Szafka na buty VB80x36D S1 siedzisko schowek 80cm Czarny BIAŁY	\N	\N	\N	2025-10-10 09:15:36.550505	2025-10-10 09:15:36.550505
5052	15451878639	5905806208658	Zestaw VB60x36 Tres60x36 D1N1 szafka na buty siedzisko SONOMA	\N	\N	\N	2025-10-10 09:15:38.988943	2025-10-10 09:15:38.988943
4404	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	\N	\N	\N	2025-10-09 19:35:17.471156	2025-10-12 11:16:49.24788
5212	12170497350	5905806217063	Komoda z szufladami Vini 60x30 D1N1 LANCELOT	\N	\N	\N	2025-10-11 09:08:57.056759	2025-10-11 09:10:06.256971
5254	15408459144	5905806218732	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Czarny Wotan	\N	\N	\N	2025-10-11 19:06:11.495985	2025-10-12 00:12:09.456918
5266	16383696059	5905806234060	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój SONOMA	\N	\N	\N	2025-10-12 07:57:25.315005	2025-10-12 07:57:25.315005
5270	15125437469	5905806204407	Szafka na buty z wieszakiem VB50x30WP50 N1D1 Biały Czarny	\N	\N	\N	2025-10-12 10:13:23.112617	2025-10-12 10:13:29.958813
5011	11711309800	5905806205480	Wieszak ścienny WP100 na ubrania 100cm Sonoma	\N	\N	\N	2025-10-10 09:09:11.265188	2025-10-11 17:32:47.282074
5279	12600923141	5905806210347	Półka ścienna 50x18x20cm solidna Dąb Sonoma	\N	\N	\N	2025-10-12 11:05:35.276406	2025-10-12 11:07:35.68496
5062	11750242493	5905806214086	Szafka na buty z szufladą Tres 50x36 Biały	\N	\N	\N	2025-10-10 10:29:15.536072	2025-10-10 10:51:36.162705
5131	15919780554	5905806228922	Komoda Bones 50x30D1N1 SONOMA	\N	\N	\N	2025-10-10 11:12:02.521501	2025-10-10 11:12:02.521501
5135	15440332896	5905806218190	Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko WOTAN	\N	\N	\N	2025-10-10 11:13:28.141876	2025-10-10 11:13:45.38649
5161	12158414735	5905806217124	Komoda z szufladami Vini 80x30 D1N1 BIAŁY	\N	\N	\N	2025-10-10 14:27:28.459355	2025-10-10 14:27:28.459355
5177	11225775551	5905806215434	Garderoba 50x30D1N1 VB50 4Panele WP50 Biały	\N	\N	\N	2025-10-10 18:14:14.617168	2025-10-10 18:14:14.617168
5209	16319667125	5905806234299	Komoda szafka NEX 80x30x124 sypialnia salon przedpokój D1N1 WOTAN	\N	\N	\N	2025-10-11 08:52:50.680393	2025-10-11 08:52:50.680393
5244	15121493570	5905806205091	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 Artisan	\N	\N	\N	2025-10-11 17:49:17.793219	2025-10-11 17:54:17.739795
5294	17496406633	5905806238846	Szafka na buty VB80x30 D3N3 CZARNY	\N	\N	\N	2025-10-12 11:19:35.556208	2025-10-12 11:21:39.247935
5305	15178440763	5905806210156	Szafka komoda na buty 80x36 D2N2 Altus WOTAN	\N	\N	\N	2025-10-12 11:34:44.709766	2025-10-12 11:43:12.087935
\.


--
-- Data for Name: sync_logs; Type: TABLE DATA; Schema: allegro; Owner: neondb_owner
--

COPY allegro.sync_logs (id, sync_started_at, sync_completed_at, status, orders_fetched, orders_new, orders_updated, error_message, sync_duration_ms) FROM stdin;
1	2025-10-06 15:09:30.474	2025-10-06 15:09:50.029	SUCCESS	100	2	98	\N	19555
2	2025-10-06 15:12:50.103	2025-10-06 15:13:10.006	SUCCESS	100	0	100	\N	19903
3	2025-10-06 15:15:50.103	2025-10-06 15:16:09.415	SUCCESS	100	0	100	\N	19312
4	2025-10-06 15:17:53.012	2025-10-06 15:17:53.05	ERROR	0	0	0	No active connection	38
5	2025-10-06 15:21:07.453	2025-10-06 15:21:09.745	ERROR	0	0	0	No active connection	2292
6	2025-10-06 15:22:24.415	2025-10-06 15:22:24.692	ERROR	0	0	0	No active connection	277
7	2025-10-06 15:29:11.574	2025-10-06 15:29:11.625	ERROR	0	0	0	No active connection	51
8	2025-10-06 15:29:12.15	2025-10-06 15:29:12.437	ERROR	0	0	0	No active connection	287
9	2025-10-06 15:40:54.62	2025-10-06 15:41:14.559	SUCCESS	100	1	99	\N	19939
10	2025-10-06 15:44:46.596	2025-10-06 15:45:06.706	SUCCESS	100	0	100	\N	20110
11	2025-10-06 15:48:06.782	\N	RUNNING	0	0	0	\N	\N
12	2025-10-06 15:51:30.818	2025-10-06 15:51:50.922	SUCCESS	100	1	99	\N	20104
13	2025-10-06 15:56:25.687	2025-10-06 15:56:46.051	SUCCESS	100	0	100	\N	20364
14	2025-10-06 16:01:05.942	2025-10-06 16:01:25.678	SUCCESS	100	0	100	\N	19736
15	2025-10-06 16:03:38.978	2025-10-06 16:03:57.923	SUCCESS	100	0	100	\N	18945
16	2025-10-06 16:04:25.752	2025-10-06 16:04:45.923	SUCCESS	100	0	100	\N	20171
17	2025-10-06 16:07:25.752	2025-10-06 16:07:45.077	SUCCESS	100	0	100	\N	19325
18	2025-10-06 16:10:25.752	2025-10-06 16:10:47.373	SUCCESS	100	0	100	\N	21621
19	2025-10-06 16:13:59.027	2025-10-06 16:14:21.421	SUCCESS	100	0	100	\N	22394
20	2025-10-06 16:17:21.511	2025-10-06 16:17:43.942	SUCCESS	100	0	100	\N	22431
21	2025-10-06 16:20:21.511	2025-10-06 16:20:41.131	SUCCESS	100	0	100	\N	19620
22	2025-10-06 16:23:21.511	2025-10-06 16:23:41.731	SUCCESS	100	1	99	\N	20220
23	2025-10-06 16:26:21.512	2025-10-06 16:26:40.902	SUCCESS	100	0	100	\N	19390
24	2025-10-06 16:29:21.513	2025-10-06 16:29:41.814	SUCCESS	100	0	100	\N	20301
25	2025-10-06 16:32:21.516	2025-10-06 16:32:42.029	SUCCESS	100	0	100	\N	20513
26	2025-10-06 16:35:21.516	2025-10-06 16:35:41.663	SUCCESS	100	0	100	\N	20147
27	2025-10-06 16:37:00.95	2025-10-06 16:37:20.764	SUCCESS	100	0	100	\N	19814
28	2025-10-06 16:40:20.837	2025-10-06 16:40:42.877	SUCCESS	100	0	100	\N	22040
29	2025-10-06 16:43:20.837	2025-10-06 16:43:41.121	SUCCESS	100	1	99	\N	20284
30	2025-10-06 16:45:11.851	2025-10-06 16:45:31.267	SUCCESS	100	1	99	\N	19416
31	2025-10-06 16:48:31.336	2025-10-06 16:48:53.366	SUCCESS	100	0	100	\N	22030
32	2025-10-06 16:49:38.341	2025-10-06 16:49:57.684	SUCCESS	100	0	100	\N	19343
33	2025-10-06 16:52:57.753	2025-10-06 16:53:20.124	SUCCESS	100	0	100	\N	22371
34	2025-10-06 16:55:57.754	2025-10-06 16:56:17.405	SUCCESS	100	0	100	\N	19651
35	2025-10-06 16:58:57.755	2025-10-06 16:59:17.615	SUCCESS	100	0	100	\N	19860
36	2025-10-06 17:01:57.755	2025-10-06 17:02:17.964	SUCCESS	100	1	99	\N	20209
37	2025-10-06 17:10:39.111	2025-10-06 17:10:58.808	SUCCESS	100	0	100	\N	19697
38	2025-10-06 17:15:53.189	2025-10-06 17:16:17.783	SUCCESS	100	0	100	\N	24594
39	2025-10-06 17:19:17.856	2025-10-06 17:19:44.515	SUCCESS	100	0	100	\N	26659
40	2025-10-06 17:22:17.857	2025-10-06 17:22:44.314	SUCCESS	100	0	100	\N	26457
41	2025-10-06 17:47:47.375	2025-10-06 17:48:11.223	SUCCESS	100	5	95	\N	23848
42	2025-10-06 17:51:11.298	2025-10-06 17:51:37.765	SUCCESS	100	0	100	\N	26467
43	2025-10-06 18:09:49.784	2025-10-06 18:10:14.362	SUCCESS	100	0	100	\N	24578
44	2025-10-06 18:13:14.44	2025-10-06 18:13:40.761	SUCCESS	100	0	100	\N	26321
45	2025-10-06 18:16:14.441	2025-10-06 18:16:40.661	SUCCESS	100	0	100	\N	26220
46	2025-10-06 18:33:51.029	2025-10-06 18:34:15.269	SUCCESS	100	1	99	\N	24240
47	2025-10-06 18:37:15.347	2025-10-06 18:37:38.89	SUCCESS	100	0	100	\N	23543
48	2025-10-06 18:40:15.348	2025-10-06 18:40:38.473	SUCCESS	100	0	100	\N	23125
49	2025-10-06 18:41:42.458	2025-10-06 18:42:05.524	SUCCESS	100	0	100	\N	23066
50	2025-10-06 18:42:42.459	2025-10-06 18:43:06.02	SUCCESS	100	0	100	\N	23561
51	2025-10-06 18:43:09.267	2025-10-06 18:43:33.018	SUCCESS	100	0	100	\N	23751
52	2025-10-06 18:43:42.459	2025-10-06 18:44:05.926	SUCCESS	100	0	100	\N	23467
53	2025-10-06 18:46:16.258	2025-10-06 18:46:40.189	SUCCESS	100	1	99	\N	23931
54	2025-10-06 18:51:28.672	2025-10-06 18:51:55.116	SUCCESS	100	0	100	\N	26444
55	2025-10-06 18:52:31.548	2025-10-06 18:52:55.13	SUCCESS	100	0	100	\N	23582
56	2025-10-06 18:54:52.979	2025-10-06 18:55:16.66	SUCCESS	100	1	99	\N	23681
57	2025-10-06 18:57:28.262	2025-10-06 18:57:51.655	SUCCESS	100	0	100	\N	23393
58	2025-10-06 19:00:32.241	2025-10-06 19:00:55.318	SUCCESS	100	0	100	\N	23077
59	2025-10-06 19:01:32.242	\N	RUNNING	0	0	0	\N	\N
60	2025-10-06 19:06:27.231	2025-10-06 19:06:50.902	SUCCESS	100	1	99	\N	23671
61	2025-10-06 19:08:09.451	2025-10-06 19:08:33.216	SUCCESS	100	0	100	\N	23765
62	2025-10-06 19:09:50.973	2025-10-06 19:10:14.693	SUCCESS	100	0	100	\N	23720
63	2025-10-06 19:16:28.842	2025-10-06 19:16:53.529	SUCCESS	100	0	100	\N	24687
64	2025-10-06 19:19:00.109	\N	RUNNING	0	0	0	\N	\N
65	2025-10-06 19:25:31.047	2025-10-06 19:25:56.919	SUCCESS	100	0	0	\N	25872
66	2025-10-06 19:28:35.67	2025-10-06 19:28:58.632	SUCCESS	100	0	0	\N	22962
67	2025-10-06 19:32:55.188	2025-10-06 19:32:55.536	ERROR	0	0	0	No active connection	348
68	2025-10-06 19:33:21.773	2025-10-06 19:34:08.194	SUCCESS	100	10	90	\N	46421
69	2025-10-06 19:38:16.756	2025-10-06 19:38:17.03	ERROR	0	0	0	No active connection	274
70	2025-10-06 19:38:21.403	\N	RUNNING	0	0	0	\N	\N
71	2025-10-06 19:44:43.47	2025-10-06 19:45:29.711	SUCCESS	100	0	100	\N	46241
72	2025-10-06 20:11:48.021	2025-10-06 20:12:35.36	SUCCESS	100	0	100	\N	47339
73	2025-10-06 20:15:35.436	2025-10-06 20:16:22.475	SUCCESS	100	0	100	\N	47039
74	2025-10-06 20:18:32.553	2025-10-06 20:19:20.821	SUCCESS	100	0	100	\N	48268
75	2025-10-06 20:19:32.553	2025-10-06 20:20:20.113	SUCCESS	100	0	100	\N	47560
76	2025-10-06 20:20:32.553	\N	RUNNING	0	0	0	\N	\N
77	2025-10-06 20:27:49.842	2025-10-06 20:28:36.692	SUCCESS	100	0	100	\N	46850
78	2025-10-06 20:31:36.765	2025-10-06 20:32:24.972	SUCCESS	100	0	100	\N	48207
79	2025-10-06 20:34:36.765	2025-10-06 20:35:22.54	SUCCESS	100	0	100	\N	45775
81	2025-10-09 18:39:35.712	2025-10-09 18:40:40.699	ERROR	100	0	0	column "order_code" can only be updated to DEFAULT	64987
82	2025-10-09 18:41:08.455	2025-10-09 18:41:09.174	ERROR	0	0	0	column "order_code" can only be updated to DEFAULT	719
83	2025-10-09 18:48:14.64	2025-10-09 18:48:15.093	ERROR	0	0	0	relation "commerce.orders_order_number_seq" does not exist	453
84	2025-10-09 18:49:14.64	2025-10-09 18:49:15.451	ERROR	0	0	0	relation "commerce.orders_order_number_seq" does not exist	811
85	2025-10-09 18:52:57.479	2025-10-09 18:52:58.277	SUCCESS	0	0	0	\N	798
86	2025-10-09 18:53:58.392	2025-10-09 18:53:59.449	SUCCESS	0	0	0	\N	1057
87	2025-10-09 18:54:58.393	2025-10-09 18:54:59.165	SUCCESS	0	0	0	\N	772
88	2025-10-09 18:55:54.277	2025-10-09 18:55:55.066	SUCCESS	0	0	0	\N	789
89	2025-10-09 18:55:58.394	2025-10-09 18:55:58.837	SUCCESS	0	0	0	\N	443
90	2025-10-09 18:57:21.506	2025-10-09 18:57:22.318	SUCCESS	0	0	0	\N	812
91	2025-10-09 18:58:22.428	2025-10-09 18:58:23.483	SUCCESS	0	0	0	\N	1055
92	2025-10-09 18:59:22.428	2025-10-09 18:59:23.216	SUCCESS	0	0	0	\N	788
93	2025-10-09 19:16:50.406	2025-10-09 19:16:52.086	SUCCESS	1	0	0	\N	1680
94	2025-10-09 19:17:52.194	2025-10-09 19:17:52.977	SUCCESS	0	0	0	\N	783
95	2025-10-09 19:18:52.195	2025-10-09 19:18:52.993	SUCCESS	0	0	0	\N	798
96	2025-10-09 19:19:52.195	2025-10-09 19:19:53.222	SUCCESS	0	0	0	\N	1027
97	2025-10-09 19:20:41.597	2025-10-09 19:20:42.403	SUCCESS	0	0	0	\N	806
98	2025-10-09 19:21:42.516	2025-10-09 19:21:43.283	SUCCESS	0	0	0	\N	767
99	2025-10-09 19:23:03.119	2025-10-09 19:23:03.901	SUCCESS	0	0	0	\N	782
100	2025-10-09 19:24:03.119	2025-10-09 19:24:03.917	SUCCESS	0	0	0	\N	798
101	2025-10-09 19:25:03.119	2025-10-09 19:25:04.122	SUCCESS	0	0	0	\N	1003
102	2025-10-09 19:26:03.544	2025-10-09 19:26:04.335	SUCCESS	0	0	0	\N	791
103	2025-10-09 19:27:04.446	2025-10-09 19:27:05.521	SUCCESS	0	0	0	\N	1075
104	2025-10-09 19:27:07.387	2025-10-09 19:27:07.855	SUCCESS	0	0	0	\N	468
105	2025-10-09 19:28:07.972	2025-10-09 19:28:08.762	SUCCESS	0	0	0	\N	790
106	2025-10-09 19:29:07.973	2025-10-09 19:29:08.779	SUCCESS	0	0	0	\N	806
107	2025-10-09 19:29:27.248	2025-10-09 19:29:27.934	SUCCESS	0	0	0	\N	686
108	2025-10-09 19:31:17.138	2025-10-09 19:31:18.191	SUCCESS	0	0	0	\N	1053
109	2025-10-09 19:32:17.137	2025-10-09 19:32:17.601	SUCCESS	0	0	0	\N	464
110	2025-10-09 19:33:21.223	2025-10-09 19:33:22.406	SUCCESS	0	0	0	\N	1183
111	2025-10-09 19:34:21.222	2025-10-09 19:34:21.673	SUCCESS	0	0	0	\N	451
112	2025-10-09 19:35:21.223	2025-10-09 19:35:21.881	SUCCESS	0	0	0	\N	658
113	2025-10-09 19:37:10.916	2025-10-09 19:37:12.139	SUCCESS	0	0	0	\N	1223
114	2025-10-09 19:38:42.807	2025-10-09 19:38:43.623	SUCCESS	0	0	0	\N	816
115	2025-10-09 19:39:42.807	2025-10-09 19:39:43.617	SUCCESS	0	0	0	\N	810
116	2025-10-09 19:40:42.806	2025-10-09 19:40:43.243	SUCCESS	0	0	0	\N	437
117	2025-10-09 19:42:28.559	2025-10-09 19:42:29.838	SUCCESS	0	0	0	\N	1279
118	2025-10-09 19:43:28.558	2025-10-09 19:43:29.583	SUCCESS	0	0	0	\N	1025
119	2025-10-09 19:44:28.558	2025-10-09 19:44:29.566	SUCCESS	0	0	0	\N	1008
120	2025-10-09 19:45:28.558	2025-10-09 19:45:29.791	SUCCESS	0	0	0	\N	1233
121	2025-10-09 19:46:57.671	2025-10-09 19:46:58.987	SUCCESS	0	0	0	\N	1316
122	2025-10-09 19:47:57.672	2025-10-09 19:47:58.911	SUCCESS	0	0	0	\N	1239
123	2025-10-09 19:48:57.673	2025-10-09 19:48:58.933	SUCCESS	0	0	0	\N	1260
124	2025-10-09 19:49:57.673	2025-10-09 19:49:58.752	SUCCESS	0	0	0	\N	1079
125	2025-10-09 19:51:39.818	2025-10-09 19:51:40.66	SUCCESS	0	0	0	\N	842
126	2025-10-09 19:52:39.817	2025-10-09 19:52:41.034	SUCCESS	0	0	0	\N	1217
127	2025-10-09 19:53:39.817	2025-10-09 19:53:41.074	SUCCESS	0	0	0	\N	1257
128	2025-10-09 19:54:39.817	2025-10-09 19:54:40.33	SUCCESS	0	0	0	\N	513
129	2025-10-09 19:55:39.817	2025-10-09 19:55:41.081	SUCCESS	0	0	0	\N	1264
130	2025-10-09 19:56:39.817	2025-10-09 19:56:40.627	SUCCESS	0	0	0	\N	810
131	2025-10-09 19:57:39.817	2025-10-09 19:57:40.273	SUCCESS	0	0	0	\N	456
132	2025-10-09 19:59:05.966	2025-10-09 19:59:06.991	SUCCESS	0	0	0	\N	1025
133	2025-10-09 20:00:05.967	2025-10-09 20:00:07.218	SUCCESS	0	0	0	\N	1251
134	2025-10-09 20:01:05.967	2025-10-09 20:01:07.007	SUCCESS	0	0	0	\N	1040
135	2025-10-09 20:02:05.968	2025-10-09 20:02:07.22	SUCCESS	0	0	0	\N	1252
136	2025-10-09 20:03:05.968	2025-10-09 20:03:06.785	SUCCESS	0	0	0	\N	817
137	2025-10-09 20:04:16.197	2025-10-09 20:04:17.529	SUCCESS	0	0	0	\N	1332
138	2025-10-09 20:05:16.196	2025-10-09 20:05:17.206	SUCCESS	0	0	0	\N	1010
139	2025-10-09 20:06:16.197	2025-10-09 20:06:17.478	SUCCESS	0	0	0	\N	1281
140	2025-10-09 20:07:16.196	2025-10-09 20:07:16.979	SUCCESS	0	0	0	\N	783
141	2025-10-09 20:08:16.196	2025-10-09 20:08:16.97	SUCCESS	0	0	0	\N	774
142	2025-10-09 20:09:57.682	2025-10-09 20:09:58.529	SUCCESS	0	0	0	\N	847
143	2025-10-09 20:10:57.682	2025-10-09 20:10:58.713	SUCCESS	0	0	0	\N	1031
144	2025-10-09 20:11:57.683	2025-10-09 20:11:58.488	SUCCESS	0	0	0	\N	805
145	2025-10-09 20:12:57.684	2025-10-09 20:13:00.482	SUCCESS	1	0	1	\N	2798
146	2025-10-09 20:13:57.685	2025-10-09 20:14:00.853	SUCCESS	1	0	1	\N	3168
147	2025-10-09 20:15:27.224	2025-10-09 20:15:30.528	SUCCESS	1	0	1	\N	3304
148	2025-10-09 20:16:27.224	2025-10-09 20:16:30.048	SUCCESS	1	0	1	\N	2824
149	2025-10-09 20:17:27.226	2025-10-09 20:17:29.754	SUCCESS	1	0	1	\N	2528
150	2025-10-09 20:18:43.12	2025-10-09 20:18:46.154	SUCCESS	1	0	1	\N	3034
151	2025-10-09 20:19:43.121	2025-10-09 20:19:45.925	SUCCESS	1	0	1	\N	2804
152	2025-10-09 20:20:43.122	2025-10-09 20:20:45.903	SUCCESS	1	0	1	\N	2781
153	2025-10-09 20:22:35.734	2025-10-09 20:22:37.828	SUCCESS	1	0	0	\N	2094
154	2025-10-09 20:23:35.763	2025-10-09 20:23:37.577	SUCCESS	1	0	0	\N	1814
155	2025-10-09 20:24:35.793	2025-10-09 20:24:37.662	SUCCESS	1	0	0	\N	1869
156	2025-10-09 20:25:35.794	2025-10-09 20:25:37.577	SUCCESS	1	0	0	\N	1783
157	2025-10-09 20:26:35.795	2025-10-09 20:26:37.308	SUCCESS	1	0	0	\N	1513
158	2025-10-09 20:27:35.796	2025-10-09 20:27:37.594	SUCCESS	1	0	0	\N	1798
159	2025-10-09 20:29:06.494	2025-10-09 20:29:09.503	SUCCESS	1	0	1	\N	3009
160	2025-10-09 20:30:06.493	2025-10-09 20:30:09.208	SUCCESS	1	0	1	\N	2715
161	2025-10-09 20:31:06.494	2025-10-09 20:31:09.437	SUCCESS	1	0	1	\N	2943
162	2025-10-09 20:32:06.495	2025-10-09 20:32:09.613	SUCCESS	1	0	1	\N	3118
163	2025-10-09 20:53:56.367	2025-10-09 20:53:59.292	SUCCESS	1	0	1	\N	2925
164	2025-10-09 20:54:56.367	2025-10-09 20:54:59.05	SUCCESS	1	0	1	\N	2683
165	2025-10-09 20:55:56.367	2025-10-09 20:55:58.834	SUCCESS	1	0	1	\N	2467
166	2025-10-09 20:56:56.367	2025-10-09 20:56:58.827	SUCCESS	1	0	1	\N	2460
167	2025-10-09 20:57:56.368	2025-10-09 20:57:59.088	SUCCESS	1	0	1	\N	2720
168	2025-10-09 20:58:56.369	2025-10-09 20:58:59.578	SUCCESS	1	0	1	\N	3209
169	2025-10-09 20:59:56.37	2025-10-09 20:59:59.464	SUCCESS	1	0	1	\N	3094
170	2025-10-09 21:00:56.371	2025-10-09 21:00:59.146	SUCCESS	1	0	1	\N	2775
171	2025-10-09 21:01:56.372	2025-10-09 21:01:59.108	SUCCESS	1	0	1	\N	2736
172	2025-10-09 21:02:56.373	2025-10-09 21:02:59.467	SUCCESS	1	0	1	\N	3094
173	2025-10-09 21:03:56.374	2025-10-09 21:03:59.078	SUCCESS	1	0	1	\N	2704
174	2025-10-09 21:04:56.375	2025-10-09 21:04:59.547	SUCCESS	1	0	1	\N	3172
175	2025-10-09 21:05:56.376	2025-10-09 21:05:59.399	SUCCESS	1	0	1	\N	3023
176	2025-10-09 21:06:56.375	2025-10-09 21:06:59.184	SUCCESS	1	0	1	\N	2809
177	2025-10-09 21:12:45.819	2025-10-09 21:12:49.109	SUCCESS	1	0	1	\N	3290
178	2025-10-09 21:13:45.848	2025-10-09 21:13:48.715	SUCCESS	1	0	1	\N	2867
179	2025-10-09 21:14:45.877	2025-10-09 21:14:50.633	SUCCESS	2	0	2	\N	4756
180	2025-10-09 21:15:45.906	2025-10-09 21:15:50.289	SUCCESS	2	0	2	\N	4383
181	2025-10-09 21:16:45.935	2025-10-09 21:16:50.316	SUCCESS	2	0	2	\N	4381
182	2025-10-09 21:17:45.964	2025-10-09 21:17:50.311	SUCCESS	2	0	2	\N	4347
183	2025-10-09 21:18:45.993	2025-10-09 21:18:50.537	SUCCESS	2	0	2	\N	4544
184	2025-10-09 21:19:46.022	2025-10-09 21:19:50.576	SUCCESS	2	0	2	\N	4554
185	2025-10-10 06:52:41.935	2025-10-10 06:52:50.893	SUCCESS	4	0	4	\N	8958
186	2025-10-10 06:53:41.941	2025-10-10 06:53:43.202	SUCCESS	0	0	0	\N	1261
187	2025-10-10 06:54:41.943	2025-10-10 06:54:42.635	SUCCESS	0	0	0	\N	692
188	2025-10-10 06:55:41.942	2025-10-10 06:55:43.113	SUCCESS	0	0	0	\N	1171
189	2025-10-10 06:56:41.943	2025-10-10 06:56:42.825	SUCCESS	0	0	0	\N	882
190	2025-10-10 06:57:41.944	2025-10-10 06:57:42.882	SUCCESS	0	0	0	\N	938
191	2025-10-10 06:58:41.945	2025-10-10 06:58:42.855	SUCCESS	0	0	0	\N	910
192	2025-10-10 06:59:41.945	2025-10-10 06:59:42.831	SUCCESS	0	0	0	\N	886
193	2025-10-10 07:00:41.946	2025-10-10 07:00:45.178	SUCCESS	1	0	1	\N	3232
194	2025-10-10 07:01:41.949	2025-10-10 07:01:45.082	SUCCESS	1	0	1	\N	3133
195	2025-10-10 07:02:41.95	2025-10-10 07:02:44.95	SUCCESS	1	0	1	\N	3000
196	2025-10-10 07:03:41.95	2025-10-10 07:03:45.074	SUCCESS	1	0	1	\N	3124
197	2025-10-10 07:04:41.95	2025-10-10 07:04:44.778	SUCCESS	1	0	1	\N	2828
198	2025-10-10 07:05:41.95	2025-10-10 07:05:44.754	SUCCESS	1	0	1	\N	2804
199	2025-10-10 07:06:41.95	2025-10-10 07:06:44.972	SUCCESS	1	0	1	\N	3022
200	2025-10-10 07:07:41.95	2025-10-10 07:07:45.095	SUCCESS	1	0	1	\N	3145
201	2025-10-10 07:08:41.952	2025-10-10 07:08:44.755	SUCCESS	1	0	1	\N	2803
202	2025-10-10 07:09:41.952	2025-10-10 07:09:45.085	SUCCESS	1	0	1	\N	3133
203	2025-10-10 07:10:41.954	2025-10-10 07:10:44.744	SUCCESS	1	0	1	\N	2790
204	2025-10-10 07:11:41.954	2025-10-10 07:11:45.128	SUCCESS	1	0	1	\N	3174
205	2025-10-10 07:12:41.955	2025-10-10 07:12:45.076	SUCCESS	1	0	1	\N	3121
206	2025-10-10 07:13:41.955	2025-10-10 07:13:45.053	SUCCESS	1	0	1	\N	3098
207	2025-10-10 07:14:41.958	2025-10-10 07:14:44.914	SUCCESS	1	0	1	\N	2956
208	2025-10-10 07:15:41.959	2025-10-10 07:15:45.028	SUCCESS	1	0	1	\N	3069
209	2025-10-10 07:16:41.959	2025-10-10 07:16:44.735	SUCCESS	1	0	1	\N	2776
210	2025-10-10 07:17:41.96	2025-10-10 07:17:45.149	SUCCESS	1	0	1	\N	3189
211	2025-10-10 07:18:41.96	2025-10-10 07:18:44.503	SUCCESS	1	0	1	\N	2543
212	2025-10-10 07:19:41.959	2025-10-10 07:19:44.575	SUCCESS	1	0	1	\N	2616
213	2025-10-10 07:20:41.959	2025-10-10 07:20:44.535	SUCCESS	1	0	1	\N	2576
214	2025-10-10 07:21:41.959	2025-10-10 07:21:44.5	SUCCESS	1	0	1	\N	2541
215	2025-10-10 07:22:41.96	2025-10-10 07:22:44.517	SUCCESS	1	0	1	\N	2557
216	2025-10-10 07:23:41.96	2025-10-10 07:23:44.768	SUCCESS	1	0	1	\N	2808
217	2025-10-10 07:24:41.961	2025-10-10 07:24:44.857	SUCCESS	1	0	1	\N	2896
218	2025-10-10 07:25:41.962	2025-10-10 07:25:46.235	SUCCESS	2	0	2	\N	4273
219	2025-10-10 07:26:41.963	2025-10-10 07:26:46.389	SUCCESS	2	0	2	\N	4426
220	2025-10-10 07:27:41.964	2025-10-10 07:27:45.952	SUCCESS	2	0	2	\N	3988
221	2025-10-10 07:28:41.965	2025-10-10 07:28:46.396	SUCCESS	2	0	2	\N	4431
222	2025-10-10 07:29:41.965	2025-10-10 07:29:47.207	SUCCESS	2	0	2	\N	5242
223	2025-10-10 07:30:41.965	2025-10-10 07:30:48.218	SUCCESS	3	0	3	\N	6253
224	2025-10-10 07:31:41.965	2025-10-10 07:31:47.902	SUCCESS	3	0	3	\N	5937
225	2025-10-10 07:32:41.966	2025-10-10 07:32:47.929	SUCCESS	3	0	3	\N	5963
226	2025-10-10 07:33:41.966	2025-10-10 07:33:47.803	SUCCESS	3	0	3	\N	5837
227	2025-10-10 07:34:41.966	2025-10-10 07:34:48.192	SUCCESS	3	0	3	\N	6226
228	2025-10-10 07:35:41.965	2025-10-10 07:35:47.938	SUCCESS	3	0	3	\N	5973
229	2025-10-10 07:36:41.965	2025-10-10 07:36:47.779	SUCCESS	3	0	3	\N	5814
230	2025-10-10 07:37:41.966	2025-10-10 07:37:48.126	SUCCESS	3	0	3	\N	6160
231	2025-10-10 07:38:41.973	2025-10-10 07:38:48.443	SUCCESS	3	0	3	\N	6470
232	2025-10-10 07:39:41.972	2025-10-10 07:39:49.437	SUCCESS	4	0	4	\N	7465
233	2025-10-10 07:40:11.562	2025-10-10 07:40:14.6	ERROR	0	0	0	No active connection	3038
234	2025-10-10 07:40:41.972	2025-10-10 07:40:49.754	SUCCESS	4	0	4	\N	7782
235	2025-10-10 07:41:41.973	2025-10-10 07:41:49.678	SUCCESS	4	0	4	\N	7705
236	2025-10-10 07:42:11.587	2025-10-10 07:42:13.2	ERROR	0	0	0	No active connection	1613
237	2025-10-10 07:42:41.972	2025-10-10 07:42:49.699	SUCCESS	4	0	4	\N	7727
238	2025-10-10 07:43:11.59	2025-10-10 07:43:14.3	ERROR	0	0	0	No active connection	2710
239	2025-10-10 07:43:41.972	2025-10-10 07:43:49.911	SUCCESS	4	0	4	\N	7939
240	2025-10-10 07:44:11.596	2025-10-10 07:44:13.2	ERROR	0	0	0	No active connection	1604
241	2025-10-10 07:44:41.972	\N	RUNNING	0	0	0	\N	\N
242	2025-10-10 07:45:11.606	2025-10-10 07:45:14.701	ERROR	0	0	0	No active connection	3095
243	2025-10-10 07:45:51.702	2025-10-10 07:45:52.053	ERROR	0	0	0	No active connection	351
244	2025-10-10 07:46:11.609	2025-10-10 07:46:13.6	ERROR	0	0	0	No active connection	1991
245	2025-10-10 07:46:51.702	2025-10-10 07:46:51.739	ERROR	0	0	0	No active connection	37
246	2025-10-10 07:47:12	2025-10-10 07:47:15.8	ERROR	0	0	0	No active connection	3800
247	2025-10-10 07:48:05.901	2025-10-10 07:48:05.939	ERROR	0	0	0	No active connection	38
248	2025-10-10 07:48:12.003	2025-10-10 07:48:12.027	ERROR	0	0	0	No active connection	24
249	2025-10-10 07:49:05.901	2025-10-10 07:49:06.176	ERROR	0	0	0	No active connection	275
250	2025-10-10 07:49:12.007	2025-10-10 07:49:12.028	ERROR	0	0	0	No active connection	21
251	2025-10-10 07:50:05.902	2025-10-10 07:50:06.162	ERROR	0	0	0	No active connection	260
252	2025-10-10 07:50:12.007	2025-10-10 07:50:13.422	ERROR	0	0	0	No active connection	1415
253	2025-10-10 07:51:05.901	2025-10-10 07:51:06.169	ERROR	0	0	0	No active connection	268
254	2025-10-10 07:51:12.011	2025-10-10 07:51:14.3	ERROR	0	0	0	No active connection	2289
255	2025-10-10 07:52:05.902	2025-10-10 07:52:06.183	ERROR	0	0	0	No active connection	281
256	2025-10-10 07:52:12.036	2025-10-10 07:52:13.2	ERROR	0	0	0	No active connection	1164
257	2025-10-10 07:53:05.901	2025-10-10 07:53:06.152	ERROR	0	0	0	No active connection	251
258	2025-10-10 07:53:12.063	2025-10-10 07:53:14.3	ERROR	0	0	0	No active connection	2237
259	2025-10-10 07:54:12.072	2025-10-10 07:54:13.4	ERROR	0	0	0	No active connection	1328
260	2025-10-10 07:55:09.83	2025-10-10 07:55:09.872	ERROR	0	0	0	No active connection	42
261	2025-10-10 07:55:12.088	2025-10-10 07:55:14.101	ERROR	0	0	0	No active connection	2013
262	2025-10-10 07:56:09.83	2025-10-10 07:56:10.116	ERROR	0	0	0	No active connection	286
263	2025-10-10 07:56:12.105	2025-10-10 07:56:13.4	ERROR	0	0	0	No active connection	1295
264	2025-10-10 07:57:09.831	2025-10-10 07:57:09.868	ERROR	0	0	0	No active connection	37
265	2025-10-10 07:57:12.113	2025-10-10 07:57:13.2	ERROR	0	0	0	No active connection	1087
266	2025-10-10 07:58:12.134	2025-10-10 07:58:13.8	ERROR	0	0	0	No active connection	1666
267	2025-10-10 07:58:21.76	2025-10-10 07:58:21.796	ERROR	0	0	0	No active connection	36
268	2025-10-10 07:59:12.16	2025-10-10 07:59:13.421	ERROR	0	0	0	No active connection	1261
269	2025-10-10 07:59:21.759	2025-10-10 07:59:21.8	ERROR	0	0	0	No active connection	41
1342	2025-10-11 03:14:19.255	2025-10-11 03:14:24.141	ERROR	0	0	0	No active connection	4886
1343	2025-10-11 03:15:19.257	2025-10-11 03:15:22.641	ERROR	0	0	0	No active connection	3384
1344	2025-10-11 03:18:19.296	2025-10-11 03:18:20.44	ERROR	0	0	0	No active connection	1144
1345	2025-10-11 03:19:19.32	2025-10-11 03:19:20.362	ERROR	0	0	0	No active connection	1042
1346	2025-10-11 03:20:19.344	2025-10-11 03:20:20.462	ERROR	0	0	0	No active connection	1118
1347	2025-10-11 03:21:19.361	2025-10-11 03:21:20.661	ERROR	0	0	0	No active connection	1300
1348	2025-10-11 03:22:19.385	2025-10-11 03:22:20.64	ERROR	0	0	0	No active connection	1255
1349	2025-10-11 03:23:19.41	2025-10-11 03:23:22.04	ERROR	0	0	0	No active connection	2630
1350	2025-10-11 03:24:19.434	2025-10-11 03:24:20.44	ERROR	0	0	0	No active connection	1006
1351	2025-10-11 03:25:19.457	2025-10-11 03:25:20.54	ERROR	0	0	0	No active connection	1083
1352	2025-10-11 03:26:19.481	2025-10-11 03:26:21.643	ERROR	0	0	0	No active connection	2162
1353	2025-10-11 03:27:19.504	2025-10-11 03:27:20.641	ERROR	0	0	0	No active connection	1137
1354	2025-10-11 03:28:19.528	2025-10-11 03:28:21.04	ERROR	0	0	0	No active connection	1512
1355	2025-10-11 03:43:05.88	2025-10-11 03:43:11.014	ERROR	0	0	0	No active connection	5134
1376	2025-10-11 04:05:06.438	2025-10-11 04:05:10.015	ERROR	0	0	0	No active connection	3577
1377	2025-10-11 04:06:06.463	2025-10-11 04:06:08.514	ERROR	0	0	0	No active connection	2051
1378	2025-10-11 04:07:06.488	2025-10-11 04:07:10.414	ERROR	0	0	0	No active connection	3926
1379	2025-10-11 04:08:06.512	2025-10-11 04:08:08.736	ERROR	0	0	0	No active connection	2224
1380	2025-10-11 04:09:06.532	2025-10-11 04:09:08.614	ERROR	0	0	0	No active connection	2082
1381	2025-10-11 04:10:06.557	2025-10-11 04:10:08.313	ERROR	0	0	0	No active connection	1756
1382	2025-10-11 04:11:06.58	2025-10-11 04:11:08.514	ERROR	0	0	0	No active connection	1934
1383	2025-10-11 04:12:06.585	2025-10-11 04:12:08.514	ERROR	0	0	0	No active connection	1929
1411	2025-10-11 09:09:02.818	2025-10-11 09:09:05.938	SUCCESS	1	0	1	\N	3120
1440	2025-10-11 09:40:28.573	2025-10-11 09:40:46.655	SUCCESS	0	0	0	\N	18082
1441	2025-10-11 09:41:28.599	2025-10-11 09:41:33.254	SUCCESS	0	0	0	\N	4655
1442	2025-10-11 09:42:28.624	2025-10-11 09:42:32.154	SUCCESS	0	0	0	\N	3530
1445	2025-10-11 09:45:28.681	2025-10-11 09:45:37.954	SUCCESS	0	0	0	\N	9273
1457	2025-10-11 09:52:28.841	2025-10-11 09:52:41.654	SUCCESS	1	0	0	\N	12813
1458	2025-10-11 09:53:28.865	2025-10-11 09:53:42.154	SUCCESS	1	0	0	\N	13289
1460	2025-10-11 09:54:28.869	2025-10-11 09:54:32.454	SUCCESS	0	0	0	\N	3585
1462	2025-10-11 09:55:28.88	2025-10-11 09:55:32.955	SUCCESS	0	0	0	\N	4075
1464	2025-10-11 09:56:28.903	2025-10-11 09:56:29.718	SUCCESS	0	0	0	\N	815
1466	2025-10-11 09:57:43.576	2025-10-11 09:57:44.522	SUCCESS	0	0	0	\N	946
1477	2025-10-11 10:09:26.58	2025-10-11 10:09:27.486	SUCCESS	0	0	0	\N	906
1492	2025-10-11 10:19:15.85	2025-10-11 10:19:16.873	SUCCESS	0	0	0	\N	1023
1510	2025-10-11 10:28:19.727	2025-10-11 10:28:20.718	SUCCESS	0	0	0	\N	991
1564	2025-10-11 12:39:14.684	2025-10-11 12:39:15.58	SUCCESS	0	0	0	\N	896
1595	2025-10-11 12:59:42.114	2025-10-11 13:00:00.857	SUCCESS	1	0	1	\N	18743
1596	2025-10-11 13:00:42.139	2025-10-11 13:00:45.058	SUCCESS	0	0	0	\N	2919
1597	2025-10-11 13:01:42.163	2025-10-11 13:01:45.587	SUCCESS	0	0	0	\N	3424
1598	2025-10-11 13:02:42.184	2025-10-11 13:02:46.058	SUCCESS	0	0	0	\N	3874
1599	2025-10-11 13:03:42.207	2025-10-11 13:03:46.257	SUCCESS	0	0	0	\N	4050
1600	2025-10-11 13:04:42.208	2025-10-11 13:04:46.857	SUCCESS	0	0	0	\N	4649
1604	2025-10-11 13:09:42.296	2025-10-11 13:09:45.258	SUCCESS	0	0	0	\N	2962
1605	2025-10-11 13:10:42.318	2025-10-11 13:10:46.557	SUCCESS	0	0	0	\N	4239
1612	2025-10-11 13:17:42.46	2025-10-11 13:17:47.057	SUCCESS	0	0	0	\N	4597
1681	2025-10-11 15:06:34.787	2025-10-11 15:06:35.446	SUCCESS	0	0	0	\N	659
1697	2025-10-11 15:18:34.796	2025-10-11 15:18:35.702	SUCCESS	0	0	0	\N	906
1735	2025-10-11 16:21:29.196	2025-10-11 16:21:30.121	SUCCESS	0	0	0	\N	925
1754	2025-10-11 16:31:42.704	2025-10-11 16:31:43.426	SUCCESS	0	0	0	\N	722
1775	2025-10-11 16:40:42.708	2025-10-11 16:40:45.808	SUCCESS	1	0	1	\N	3100
1799	2025-10-11 16:53:15.775	2025-10-11 16:53:16.134	SUCCESS	0	0	0	\N	359
1814	2025-10-11 17:01:01.319	2025-10-11 17:01:09.718	SUCCESS	0	0	0	\N	8399
1815	2025-10-11 17:01:14.566	2025-10-11 17:01:19.097	SUCCESS	0	0	0	\N	4531
1817	2025-10-11 17:02:01.321	2025-10-11 17:02:06.019	SUCCESS	0	0	0	\N	4698
1819	2025-10-11 17:03:01.329	2025-10-11 17:03:11.018	SUCCESS	0	0	0	\N	9689
1821	2025-10-11 17:04:01.332	2025-10-11 17:04:06.218	SUCCESS	0	0	0	\N	4886
1823	2025-10-11 17:05:01.361	2025-10-11 17:05:07.019	SUCCESS	0	0	0	\N	5658
1829	2025-10-11 17:08:02.918	2025-10-11 17:08:10.318	SUCCESS	0	0	0	\N	7400
1836	2025-10-11 17:11:15.779	2025-10-11 17:11:16.659	SUCCESS	0	0	0	\N	880
1841	2025-10-11 17:14:02.948	2025-10-11 17:14:09.118	SUCCESS	0	0	0	\N	6170
1843	2025-10-11 17:15:02.97	2025-10-11 17:15:11.219	SUCCESS	0	0	0	\N	8249
1845	2025-10-11 17:15:32.674	2025-10-11 17:15:43.19	SUCCESS	0	0	0	\N	10516
1846	2025-10-11 17:16:02.991	2025-10-11 17:16:09.818	SUCCESS	0	0	0	\N	6827
1847	2025-10-11 17:16:32.7	2025-10-11 17:16:42.989	SUCCESS	0	0	0	\N	10289
1848	2025-10-11 17:17:03.014	2025-10-11 17:17:11.318	SUCCESS	0	0	0	\N	8304
1849	2025-10-11 17:17:32.726	2025-10-11 17:17:41.69	SUCCESS	0	0	0	\N	8964
1850	2025-10-11 17:18:32.752	2025-10-11 17:18:43.089	SUCCESS	0	0	0	\N	10337
1852	2025-10-11 17:19:32.777	2025-10-11 17:19:42.089	SUCCESS	0	0	0	\N	9312
1854	2025-10-11 17:20:32.796	2025-10-11 17:20:42.789	SUCCESS	0	0	0	\N	9993
1856	2025-10-11 17:21:32.821	2025-10-11 17:21:43.789	SUCCESS	0	0	0	\N	10968
1859	2025-10-11 17:22:56.434	2025-10-11 17:22:57.581	SUCCESS	0	0	0	\N	1147
1874	2025-10-11 17:32:16.592	2025-10-11 17:32:19.179	SUCCESS	1	0	1	\N	2587
1896	2025-10-11 17:43:16.598	2025-10-11 17:43:17.285	SUCCESS	0	0	0	\N	687
1911	2025-10-11 17:55:16.605	2025-10-11 17:55:17.499	SUCCESS	0	0	0	\N	894
1927	2025-10-11 18:03:16.607	2025-10-11 18:03:17.291	SUCCESS	0	0	0	\N	684
1931	2025-10-11 18:05:16.606	2025-10-11 18:05:17.263	SUCCESS	0	0	0	\N	657
1949	2025-10-11 18:14:16.629	2025-10-11 18:14:17.311	SUCCESS	0	0	0	\N	682
1967	2025-10-11 18:23:16.631	2025-10-11 18:23:17.533	SUCCESS	0	0	0	\N	902
1982	2025-10-11 18:29:16.635	2025-10-11 18:29:17.804	SUCCESS	0	0	0	\N	1169
1998	2025-10-11 18:37:16.639	2025-10-11 18:37:17.33	SUCCESS	0	0	0	\N	691
2011	2025-10-11 18:44:16.645	2025-10-11 18:44:17.537	SUCCESS	0	0	0	\N	892
2033	2025-10-11 18:53:30.595	2025-10-11 18:53:31.493	SUCCESS	0	0	0	\N	898
2045	2025-10-11 19:00:30.598	2025-10-11 19:00:31.256	SUCCESS	0	0	0	\N	658
2048	2025-10-11 19:01:30.599	2025-10-11 19:01:31.313	SUCCESS	0	0	0	\N	714
2065	2025-10-11 19:07:52.555	2025-10-11 19:07:53.465	SUCCESS	0	0	0	\N	910
2894	2025-10-12 09:21:44.171	2025-10-12 09:21:49.107	SUCCESS	0	0	0	\N	4936
270	2025-10-10 08:00:12.184	2025-10-10 08:00:13.001	ERROR	0	0	0	No active connection	817
271	2025-10-10 08:00:15.126	2025-10-10 08:00:27.949	SUCCESS	7	0	7	\N	12823
272	2025-10-10 08:00:40.665	2025-10-10 08:00:50.471	SUCCESS	7	0	7	\N	9806
273	2025-10-10 08:01:28.057	2025-10-10 08:01:28.724	SUCCESS	0	0	0	\N	667
274	2025-10-10 08:01:50.536	2025-10-10 08:01:53.1	SUCCESS	0	0	0	\N	2564
275	2025-10-10 08:02:28.057	2025-10-10 08:02:28.737	SUCCESS	0	0	0	\N	680
280	2025-10-10 08:04:47.66	2025-10-10 08:04:48.315	SUCCESS	0	0	0	\N	655
1356	2025-10-11 03:44:05.885	2025-10-11 03:44:11.515	ERROR	0	0	0	No active connection	5630
1357	2025-10-11 03:45:05.915	2025-10-11 03:45:10.714	ERROR	0	0	0	No active connection	4799
1358	2025-10-11 03:47:05.972	2025-10-11 03:47:09.714	ERROR	0	0	0	No active connection	3742
1359	2025-10-11 03:48:06.001	2025-10-11 03:48:11.515	ERROR	0	0	0	No active connection	5514
1360	2025-10-11 03:49:06.028	2025-10-11 03:49:10.515	ERROR	0	0	0	No active connection	4487
1361	2025-10-11 03:50:06.052	2025-10-11 03:50:08.114	ERROR	0	0	0	No active connection	2062
1362	2025-10-11 03:51:06.079	2025-10-11 03:51:09.214	ERROR	0	0	0	No active connection	3135
1363	2025-10-11 03:52:06.106	2025-10-11 03:52:08.815	ERROR	0	0	0	No active connection	2709
1364	2025-10-11 03:53:06.128	2025-10-11 03:53:08.714	ERROR	0	0	0	No active connection	2586
1365	2025-10-11 03:54:06.155	2025-10-11 03:54:09.115	ERROR	0	0	0	No active connection	2960
1366	2025-10-11 03:55:06.182	2025-10-11 03:55:08.814	ERROR	0	0	0	No active connection	2632
1367	2025-10-11 03:56:06.209	2025-10-11 03:56:08.414	ERROR	0	0	0	No active connection	2205
1368	2025-10-11 03:57:06.236	2025-10-11 03:57:09.515	ERROR	0	0	0	No active connection	3279
1369	2025-10-11 03:58:06.262	2025-10-11 03:58:08.314	ERROR	0	0	0	No active connection	2052
1370	2025-10-11 03:59:06.288	2025-10-11 03:59:09.814	ERROR	0	0	0	No active connection	3526
1371	2025-10-11 04:00:06.314	2025-10-11 04:00:09.114	ERROR	0	0	0	No active connection	2800
1372	2025-10-11 04:01:06.339	2025-10-11 04:01:09.015	ERROR	0	0	0	No active connection	2676
1373	2025-10-11 04:02:06.364	2025-10-11 04:02:09.315	ERROR	0	0	0	No active connection	2951
1374	2025-10-11 04:03:06.389	2025-10-11 04:03:09.114	ERROR	0	0	0	No active connection	2725
1375	2025-10-11 04:04:06.413	2025-10-11 04:04:09.314	ERROR	0	0	0	No active connection	2901
1413	2025-10-11 09:10:02.845	2025-10-11 09:10:08.78	SUCCESS	2	0	2	\N	5935
1443	2025-10-11 09:43:28.65	2025-10-11 09:43:34.155	SUCCESS	0	0	0	\N	5505
1444	2025-10-11 09:44:28.676	2025-10-11 09:44:33.354	SUCCESS	0	0	0	\N	4678
1446	2025-10-11 09:46:28.706	2025-10-11 09:46:33.854	SUCCESS	0	0	0	\N	5148
1448	2025-10-11 09:47:28.731	2025-10-11 09:47:34.054	SUCCESS	0	0	0	\N	5323
1450	2025-10-11 09:48:28.756	2025-10-11 09:48:33.254	SUCCESS	0	0	0	\N	4498
1452	2025-10-11 09:49:28.781	2025-10-11 09:49:33.175	SUCCESS	0	0	0	\N	4394
1454	2025-10-11 09:50:28.805	2025-10-11 09:50:33.654	SUCCESS	0	0	0	\N	4849
1455	2025-10-11 09:51:28.816	2025-10-11 09:51:42.154	SUCCESS	1	0	0	\N	13338
1467	2025-10-11 09:58:43.606	2025-10-11 09:58:44.554	SUCCESS	0	0	0	\N	948
1478	2025-10-11 10:10:26.58	2025-10-11 10:10:27.489	SUCCESS	0	0	0	\N	909
1494	2025-10-11 10:20:19.717	2025-10-11 10:20:20.905	SUCCESS	0	0	0	\N	1188
1512	2025-10-11 10:29:19.727	2025-10-11 10:29:20.879	SUCCESS	0	0	0	\N	1152
1526	2025-10-11 11:17:07.369	2025-10-11 11:17:18.226	SUCCESS	1	0	0	\N	10857
1527	2025-10-11 11:18:07.393	2025-10-11 11:18:18.926	SUCCESS	1	0	0	\N	11533
1528	2025-10-11 11:19:07.394	2025-10-11 11:19:17.327	SUCCESS	1	0	0	\N	9933
1529	2025-10-11 11:20:07.416	2025-10-11 11:20:20.646	SUCCESS	1	0	0	\N	13230
1530	2025-10-11 11:21:07.44	2025-10-11 11:21:18.826	SUCCESS	1	0	0	\N	11386
1539	2025-10-11 12:20:30.365	2025-10-11 12:20:31.075	SUCCESS	0	0	0	\N	710
1540	2025-10-11 12:21:30.364	2025-10-11 12:21:31.321	SUCCESS	0	0	0	\N	957
1566	2025-10-11 12:40:14.685	2025-10-11 12:40:15.585	SUCCESS	0	0	0	\N	900
1601	2025-10-11 13:06:42.263	2025-10-11 13:06:44.857	SUCCESS	0	0	0	\N	2594
1602	2025-10-11 13:07:42.275	2025-10-11 13:07:46.658	SUCCESS	0	0	0	\N	4383
1603	2025-10-11 13:08:42.289	2025-10-11 13:08:45.977	SUCCESS	0	0	0	\N	3688
1606	2025-10-11 13:11:42.339	2025-10-11 13:11:44.578	SUCCESS	0	0	0	\N	2239
1607	2025-10-11 13:12:42.356	2025-10-11 13:12:44.578	SUCCESS	0	0	0	\N	2222
1608	2025-10-11 13:13:42.377	2025-10-11 13:13:44.757	SUCCESS	0	0	0	\N	2380
1609	2025-10-11 13:14:42.398	2025-10-11 13:14:44.68	SUCCESS	0	0	0	\N	2282
1610	2025-10-11 13:15:42.419	2025-10-11 13:15:44.857	SUCCESS	0	0	0	\N	2438
1611	2025-10-11 13:16:42.44	2025-10-11 13:16:44.457	SUCCESS	0	0	0	\N	2017
1613	2025-10-11 13:26:26.757	2025-10-11 13:26:31.369	SUCCESS	0	0	0	\N	4612
1614	2025-10-11 13:27:26.783	2025-10-11 13:27:35.569	SUCCESS	0	0	0	\N	8786
1615	2025-10-11 13:28:26.808	2025-10-11 13:28:35.869	SUCCESS	0	0	0	\N	9061
1619	2025-10-11 13:32:26.894	2025-10-11 13:32:32.069	SUCCESS	0	0	0	\N	5175
1620	2025-10-11 13:33:26.919	2025-10-11 13:33:30.269	SUCCESS	0	0	0	\N	3350
1621	2025-10-11 13:34:26.944	2025-10-11 13:34:31.669	SUCCESS	0	0	0	\N	4725
1622	2025-10-11 13:35:26.968	2025-10-11 13:35:30.669	SUCCESS	0	0	0	\N	3701
1623	2025-10-11 13:36:26.993	2025-10-11 13:36:32.569	SUCCESS	0	0	0	\N	5576
1624	2025-10-11 13:37:27.017	2025-10-11 13:37:31.969	SUCCESS	0	0	0	\N	4952
1625	2025-10-11 13:38:27.04	2025-10-11 13:38:30.969	SUCCESS	0	0	0	\N	3929
1626	2025-10-11 13:59:03.099	2025-10-11 13:59:03.658	SUCCESS	0	0	0	\N	559
1646	2025-10-11 14:21:49.988	2025-10-11 14:22:06.148	SUCCESS	0	0	0	\N	16160
1647	2025-10-11 14:22:50.013	2025-10-11 14:22:55.748	SUCCESS	0	0	0	\N	5735
1648	2025-10-11 14:23:50.021	2025-10-11 14:23:54.947	SUCCESS	0	0	0	\N	4926
1649	2025-10-11 14:24:50.025	2025-10-11 14:24:56.448	SUCCESS	0	0	0	\N	6423
1650	2025-10-11 14:25:50.05	2025-10-11 14:25:54.047	SUCCESS	0	0	0	\N	3997
1651	2025-10-11 14:26:50.074	2025-10-11 14:26:56.747	SUCCESS	0	0	0	\N	6673
1652	2025-10-11 14:27:50.099	2025-10-11 14:27:54.347	SUCCESS	0	0	0	\N	4248
1653	2025-10-11 14:28:50.122	2025-10-11 14:28:55.247	SUCCESS	0	0	0	\N	5125
1654	2025-10-11 14:29:50.147	2025-10-11 14:29:53.547	SUCCESS	0	0	0	\N	3400
1655	2025-10-11 14:30:50.153	2025-10-11 14:30:55.047	SUCCESS	0	0	0	\N	4894
1656	2025-10-11 14:31:50.177	2025-10-11 14:31:54.547	SUCCESS	0	0	0	\N	4370
1657	2025-10-11 14:32:50.201	2025-10-11 14:32:54.647	SUCCESS	0	0	0	\N	4446
1658	2025-10-11 14:33:50.225	2025-10-11 14:33:54.848	SUCCESS	0	0	0	\N	4623
1659	2025-10-11 14:34:50.248	2025-10-11 14:34:52.671	SUCCESS	0	0	0	\N	2423
1660	2025-10-11 14:50:07.019	2025-10-11 14:50:22.5	SUCCESS	0	0	0	\N	15481
1661	2025-10-11 14:51:07.047	2025-10-11 14:51:13.5	SUCCESS	0	0	0	\N	6453
1663	2025-10-11 14:53:07.102	2025-10-11 14:53:13.1	SUCCESS	0	0	0	\N	5998
1682	2025-10-11 15:07:34.787	2025-10-11 15:07:35.884	SUCCESS	0	0	0	\N	1097
1700	2025-10-11 15:20:49.462	2025-10-11 15:20:54.008	SUCCESS	0	0	0	\N	4546
1701	2025-10-11 15:21:49.487	2025-10-11 15:21:53.008	SUCCESS	0	0	0	\N	3521
276	2025-10-10 08:02:46.962	2025-10-10 08:02:47.592	SUCCESS	0	0	0	\N	630
277	2025-10-10 08:03:28.056	2025-10-10 08:03:28.933	SUCCESS	0	0	0	\N	877
278	2025-10-10 08:03:47.66	2025-10-10 08:03:50.6	SUCCESS	0	0	0	\N	2940
279	2025-10-10 08:04:28.056	2025-10-10 08:04:28.369	SUCCESS	0	0	0	\N	313
281	2025-10-10 08:05:28.057	2025-10-10 08:05:28.372	SUCCESS	0	0	0	\N	315
282	2025-10-10 08:05:47.66	2025-10-10 08:05:48.312	SUCCESS	0	0	0	\N	652
283	2025-10-10 08:06:34.181	2025-10-10 08:06:34.867	SUCCESS	0	0	0	\N	686
284	2025-10-10 08:06:47.66	2025-10-10 08:06:47.934	SUCCESS	0	0	0	\N	274
285	2025-10-10 08:07:34.181	2025-10-10 08:07:35.079	SUCCESS	0	0	0	\N	898
286	2025-10-10 08:07:47.66	2025-10-10 08:07:48.063	SUCCESS	0	0	0	\N	403
287	2025-10-10 08:08:47.661	2025-10-10 08:08:48.292	SUCCESS	0	0	0	\N	631
288	2025-10-10 08:09:28.595	2025-10-10 08:09:29.798	SUCCESS	0	0	0	\N	1203
289	2025-10-10 08:09:47.663	2025-10-10 08:09:51.124	SUCCESS	0	0	0	\N	3461
290	2025-10-10 08:10:28.596	2025-10-10 08:10:29.703	SUCCESS	0	0	0	\N	1107
291	2025-10-10 08:10:47.667	2025-10-10 08:10:49.52	SUCCESS	0	0	0	\N	1853
292	2025-10-10 08:11:28.597	2025-10-10 08:11:29.705	SUCCESS	0	0	0	\N	1108
293	2025-10-10 08:11:47.675	2025-10-10 08:11:50	SUCCESS	0	0	0	\N	2325
294	2025-10-10 08:12:28.596	2025-10-10 08:12:29.68	SUCCESS	0	0	0	\N	1084
295	2025-10-10 08:12:47.676	2025-10-10 08:12:48.42	SUCCESS	0	0	0	\N	744
296	2025-10-10 08:13:28.597	2025-10-10 08:13:29.497	SUCCESS	0	0	0	\N	900
297	2025-10-10 08:13:47.678	2025-10-10 08:13:50.6	SUCCESS	0	0	0	\N	2922
298	2025-10-10 08:14:47.683	2025-10-10 08:14:49.562	SUCCESS	0	0	0	\N	1879
299	2025-10-10 08:15:20.428	2025-10-10 08:15:21.156	SUCCESS	0	0	0	\N	728
300	2025-10-10 08:16:20.427	2025-10-10 08:16:21.534	SUCCESS	0	0	0	\N	1107
301	2025-10-10 08:16:59.272	2025-10-10 08:17:11.5	SUCCESS	0	0	0	\N	12228
302	2025-10-10 08:17:20.428	2025-10-10 08:17:21.528	SUCCESS	0	0	0	\N	1100
303	2025-10-10 08:17:59.284	2025-10-10 08:18:07.799	SUCCESS	0	0	0	\N	8515
304	2025-10-10 08:18:20.428	2025-10-10 08:18:21.58	SUCCESS	0	0	0	\N	1152
305	2025-10-10 08:18:59.299	2025-10-10 08:19:09	SUCCESS	0	0	0	\N	9701
306	2025-10-10 08:19:50.199	2025-10-10 08:19:51.09	SUCCESS	0	0	0	\N	891
307	2025-10-10 08:19:59.324	2025-10-10 08:20:05.3	SUCCESS	0	0	0	\N	5976
308	2025-10-10 08:20:50.199	2025-10-10 08:20:51.393	SUCCESS	0	0	0	\N	1194
309	2025-10-10 08:20:59.326	2025-10-10 08:21:01.701	SUCCESS	0	0	0	\N	2375
310	2025-10-10 08:21:50.199	2025-10-10 08:21:51.364	SUCCESS	0	0	0	\N	1165
311	2025-10-10 08:21:55.37	2025-10-10 08:21:56.065	SUCCESS	0	0	0	\N	695
312	2025-10-10 08:22:56.149	2025-10-10 08:22:59.699	SUCCESS	0	0	0	\N	3550
313	2025-10-10 08:23:23.243	2025-10-10 08:23:24.195	SUCCESS	0	0	0	\N	952
314	2025-10-10 08:23:56.167	2025-10-10 08:23:58.999	SUCCESS	0	0	0	\N	2832
315	2025-10-10 08:24:23.244	2025-10-10 08:24:23.91	SUCCESS	0	0	0	\N	666
316	2025-10-10 08:24:56.168	2025-10-10 08:24:58.209	SUCCESS	0	0	0	\N	2041
317	2025-10-10 08:25:23.244	2025-10-10 08:25:24.4	SUCCESS	0	0	0	\N	1156
318	2025-10-10 08:25:56.173	2025-10-10 08:25:58.699	SUCCESS	0	0	0	\N	2526
319	2025-10-10 08:26:23.244	2025-10-10 08:26:24.4	SUCCESS	0	0	0	\N	1156
320	2025-10-10 08:26:56.175	2025-10-10 08:27:01.501	SUCCESS	0	0	0	\N	5326
321	2025-10-10 08:27:31.851	2025-10-10 08:27:33.003	SUCCESS	0	0	0	\N	1152
322	2025-10-10 08:27:57.499	2025-10-10 08:28:01.9	SUCCESS	0	0	0	\N	4401
323	2025-10-10 08:28:42.844	2025-10-10 08:28:43.527	SUCCESS	0	0	0	\N	683
324	2025-10-10 08:28:57.514	2025-10-10 08:28:59.921	SUCCESS	0	0	0	\N	2407
325	2025-10-10 08:29:42.845	2025-10-10 08:29:43.536	SUCCESS	0	0	0	\N	691
326	2025-10-10 08:29:57.52	2025-10-10 08:29:59.799	SUCCESS	0	0	0	\N	2279
327	2025-10-10 08:30:42.846	2025-10-10 08:30:43.764	SUCCESS	0	0	0	\N	918
328	2025-10-10 08:30:57.526	2025-10-10 08:31:00.099	SUCCESS	0	0	0	\N	2573
329	2025-10-10 08:31:42.846	2025-10-10 08:31:43.754	SUCCESS	0	0	0	\N	908
330	2025-10-10 08:31:57.53	2025-10-10 08:31:59.799	SUCCESS	0	0	0	\N	2269
331	2025-10-10 08:32:42.846	2025-10-10 08:32:43.744	SUCCESS	0	0	0	\N	898
332	2025-10-10 08:32:57.547	2025-10-10 08:33:00.499	SUCCESS	0	0	0	\N	2952
333	2025-10-10 08:33:42.846	2025-10-10 08:33:43.824	SUCCESS	0	0	0	\N	978
334	2025-10-10 08:33:57.555	2025-10-10 08:34:00.1	SUCCESS	0	0	0	\N	2545
335	2025-10-10 08:34:42.845	2025-10-10 08:34:43.524	SUCCESS	0	0	0	\N	679
336	2025-10-10 08:34:57.572	2025-10-10 08:35:00.299	SUCCESS	0	0	0	\N	2727
337	2025-10-10 08:35:42.845	2025-10-10 08:35:43.513	SUCCESS	0	0	0	\N	668
338	2025-10-10 08:35:57.589	2025-10-10 08:35:59.699	SUCCESS	0	0	0	\N	2110
339	2025-10-10 08:36:42.848	2025-10-10 08:36:43.529	SUCCESS	0	0	0	\N	681
340	2025-10-10 08:36:57.606	2025-10-10 08:36:59.799	SUCCESS	0	0	0	\N	2193
341	2025-10-10 08:37:42.847	2025-10-10 08:37:43.795	SUCCESS	0	0	0	\N	948
342	2025-10-10 08:37:57.622	2025-10-10 08:37:59.821	SUCCESS	0	0	0	\N	2199
343	2025-10-10 08:38:42.848	2025-10-10 08:38:43.78	SUCCESS	0	0	0	\N	932
344	2025-10-10 08:38:57.638	2025-10-10 08:38:59.899	SUCCESS	0	0	0	\N	2261
345	2025-10-10 08:39:42.849	2025-10-10 08:39:43.511	SUCCESS	0	0	0	\N	662
346	2025-10-10 08:39:57.655	2025-10-10 08:40:00.199	SUCCESS	0	0	0	\N	2544
347	2025-10-10 08:40:57.672	2025-10-10 08:40:59.699	SUCCESS	0	0	0	\N	2027
348	2025-10-10 08:41:12.28	2025-10-10 08:41:13.183	SUCCESS	0	0	0	\N	903
349	2025-10-10 08:41:57.677	2025-10-10 08:42:00.099	SUCCESS	0	0	0	\N	2422
350	2025-10-10 08:42:12.28	2025-10-10 08:42:13.433	SUCCESS	0	0	0	\N	1153
351	2025-10-10 08:42:57.682	2025-10-10 08:42:59.799	SUCCESS	0	0	0	\N	2117
352	2025-10-10 08:43:12.28	2025-10-10 08:43:13.416	SUCCESS	0	0	0	\N	1136
353	2025-10-10 08:43:57.695	2025-10-10 08:43:59.999	SUCCESS	0	0	0	\N	2304
354	2025-10-10 08:44:12.281	2025-10-10 08:44:13.182	SUCCESS	0	0	0	\N	901
355	2025-10-10 08:44:57.711	2025-10-10 08:44:59.799	SUCCESS	0	0	0	\N	2088
356	2025-10-10 08:45:12.282	2025-10-10 08:45:13.428	SUCCESS	0	0	0	\N	1146
357	2025-10-10 08:45:57.716	2025-10-10 08:46:00.699	SUCCESS	0	0	0	\N	2983
358	2025-10-10 08:46:12.284	2025-10-10 08:46:13.4	SUCCESS	0	0	0	\N	1116
359	2025-10-10 08:46:57.72	2025-10-10 08:47:00.32	SUCCESS	0	0	0	\N	2600
360	2025-10-10 08:47:12.284	2025-10-10 08:47:13.458	SUCCESS	0	0	0	\N	1174
361	2025-10-10 08:47:57.726	2025-10-10 08:48:00.199	SUCCESS	0	0	0	\N	2473
362	2025-10-10 08:48:36.624	2025-10-10 08:48:37.282	SUCCESS	0	0	0	\N	658
363	2025-10-10 08:48:57.728	2025-10-10 08:49:02.1	SUCCESS	0	0	0	\N	4372
364	2025-10-10 08:49:36.624	2025-10-10 08:49:37.289	SUCCESS	0	0	0	\N	665
365	2025-10-10 08:49:57.729	2025-10-10 08:49:58.032	SUCCESS	0	0	0	\N	303
366	2025-10-10 08:50:36.623	2025-10-10 08:50:37.749	SUCCESS	0	0	0	\N	1126
367	2025-10-10 08:50:57.73	2025-10-10 08:50:58.405	SUCCESS	0	0	0	\N	675
368	2025-10-10 08:51:42.96	2025-10-10 08:51:43.645	SUCCESS	0	0	0	\N	685
369	2025-10-10 08:51:57.731	2025-10-10 08:51:58.032	SUCCESS	0	0	0	\N	301
370	2025-10-10 08:52:57.732	2025-10-10 08:52:58.013	SUCCESS	0	0	0	\N	281
371	2025-10-10 08:53:16.43	2025-10-10 08:53:17.902	SUCCESS	0	0	0	\N	1472
390	2025-10-10 09:03:57.866	2025-10-10 09:04:00.3	SUCCESS	0	0	0	\N	2434
1384	2025-10-11 08:49:19.318	2025-10-11 08:49:19.524	ERROR	0	0	0	No active connection	206
1385	2025-10-11 08:50:19.346	2025-10-11 08:50:23.347	ERROR	0	0	0	No active connection	4001
1386	2025-10-11 08:52:19.446	2025-10-11 08:52:21.959	ERROR	0	0	0	No active connection	2513
1387	2025-10-11 08:52:22.156	2025-10-11 08:52:22.176	ERROR	0	0	0	No active connection	20
1388	2025-10-11 08:52:41.832	2025-10-11 08:52:52.765	SUCCESS	8	0	8	\N	10933
1390	2025-10-11 08:54:52.825	2025-10-11 08:54:53.514	SUCCESS	0	0	0	\N	689
1394	2025-10-11 08:58:52.946	2025-10-11 08:58:55.445	SUCCESS	0	0	0	\N	2499
1395	2025-10-11 08:59:52.949	2025-10-11 08:59:55.467	SUCCESS	0	0	0	\N	2518
1398	2025-10-11 09:02:52.958	2025-10-11 09:02:57.746	SUCCESS	0	0	0	\N	4788
1415	2025-10-11 09:11:02.874	2025-10-11 09:11:03.691	SUCCESS	0	0	0	\N	817
1447	2025-10-11 09:46:44.412	2025-10-11 09:46:45.597	SUCCESS	0	0	0	\N	1185
1468	2025-10-11 09:59:43.636	2025-10-11 09:59:44.594	SUCCESS	0	0	0	\N	958
1479	2025-10-11 10:11:26.58	2025-10-11 10:11:27.494	SUCCESS	0	0	0	\N	914
1495	2025-10-11 10:21:12.652	2025-10-11 10:21:17.009	SUCCESS	0	0	0	\N	4357
1503	2025-10-11 10:25:12.747	2025-10-11 10:25:17.008	SUCCESS	0	0	0	\N	4261
1505	2025-10-11 10:26:12.77	2025-10-11 10:26:17.308	SUCCESS	0	0	0	\N	4538
1507	2025-10-11 10:27:12.793	2025-10-11 10:27:17.608	SUCCESS	0	0	0	\N	4815
1509	2025-10-11 10:28:12.815	2025-10-11 10:28:17.609	SUCCESS	0	0	0	\N	4794
1511	2025-10-11 10:29:12.838	2025-10-11 10:29:17.31	SUCCESS	0	0	0	\N	4472
1513	2025-10-11 10:30:12.861	2025-10-11 10:30:16.809	SUCCESS	0	0	0	\N	3948
1514	2025-10-11 10:30:19.727	2025-10-11 10:30:20.624	SUCCESS	0	0	0	\N	897
1515	2025-10-11 10:31:12.884	2025-10-11 10:31:18.508	SUCCESS	0	0	0	\N	5624
1516	2025-10-11 10:32:12.906	2025-10-11 10:32:16.808	SUCCESS	0	0	0	\N	3902
1517	2025-10-11 10:33:12.928	2025-10-11 10:33:17.608	SUCCESS	0	0	0	\N	4680
1518	2025-10-11 10:34:12.951	2025-10-11 10:34:16.808	SUCCESS	0	0	0	\N	3857
1519	2025-10-11 10:35:12.972	2025-10-11 10:35:17.409	SUCCESS	0	0	0	\N	4437
1531	2025-10-11 11:22:07.463	2025-10-11 11:22:19.926	SUCCESS	1	0	0	\N	12463
1532	2025-10-11 11:23:07.486	2025-10-11 11:23:13.026	SUCCESS	0	0	0	\N	5540
1533	2025-10-11 11:24:07.508	2025-10-11 11:24:12.926	SUCCESS	0	0	0	\N	5418
1534	2025-10-11 11:25:07.53	2025-10-11 11:25:12.426	SUCCESS	0	0	0	\N	4896
1535	2025-10-11 11:26:07.542	2025-10-11 11:26:12.926	SUCCESS	0	0	0	\N	5384
1536	2025-10-11 11:27:07.565	2025-10-11 11:27:11.826	SUCCESS	0	0	0	\N	4261
1537	2025-10-11 11:28:07.586	2025-10-11 11:28:12.826	SUCCESS	0	0	0	\N	5240
1538	2025-10-11 11:29:07.604	2025-10-11 11:29:11.743	SUCCESS	0	0	0	\N	4139
1541	2025-10-11 12:22:30.365	2025-10-11 12:22:31.071	SUCCESS	0	0	0	\N	706
1542	2025-10-11 12:23:30.364	2025-10-11 12:23:31.041	SUCCESS	0	0	0	\N	677
1568	2025-10-11 12:41:14.686	2025-10-11 12:41:15.623	SUCCESS	0	0	0	\N	937
1616	2025-10-11 13:29:26.833	2025-10-11 13:29:35.07	SUCCESS	0	0	0	\N	8237
1617	2025-10-11 13:30:26.844	2025-10-11 13:30:31.069	SUCCESS	0	0	0	\N	4225
1618	2025-10-11 13:31:26.869	2025-10-11 13:31:35.67	SUCCESS	0	0	0	\N	8801
1627	2025-10-11 14:00:03.731	2025-10-11 14:00:06.417	SUCCESS	0	0	0	\N	2686
1628	2025-10-11 14:01:03.733	2025-10-11 14:01:04.638	SUCCESS	0	0	0	\N	905
1629	2025-10-11 14:02:28.427	2025-10-11 14:02:29.062	SUCCESS	0	0	0	\N	635
1630	2025-10-11 14:03:35.365	2025-10-11 14:03:36.14	SUCCESS	0	0	0	\N	775
1631	2025-10-11 14:04:35.372	2025-10-11 14:04:38.017	SUCCESS	0	0	0	\N	2645
1632	2025-10-11 14:05:35.377	2025-10-11 14:05:41.517	SUCCESS	0	0	0	\N	6140
1633	2025-10-11 14:06:35.384	2025-10-11 14:06:38.417	SUCCESS	0	0	0	\N	3033
1634	2025-10-11 14:07:35.406	2025-10-11 14:07:38.017	SUCCESS	0	0	0	\N	2611
1635	2025-10-11 14:08:35.428	2025-10-11 14:08:38.417	SUCCESS	0	0	0	\N	2989
1636	2025-10-11 14:09:35.451	2025-10-11 14:09:38.317	SUCCESS	0	0	0	\N	2866
1637	2025-10-11 14:10:35.473	2025-10-11 14:10:38.74	SUCCESS	0	0	0	\N	3267
1638	2025-10-11 14:11:35.495	2025-10-11 14:11:37.917	SUCCESS	0	0	0	\N	2422
1639	2025-10-11 14:12:35.514	2025-10-11 14:12:38.017	SUCCESS	0	0	0	\N	2503
1640	2025-10-11 14:13:35.538	2025-10-11 14:13:38.738	SUCCESS	0	0	0	\N	3200
1641	2025-10-11 14:14:35.56	2025-10-11 14:14:38.817	SUCCESS	0	0	0	\N	3257
1642	2025-10-11 14:15:35.581	2025-10-11 14:15:37.817	SUCCESS	0	0	0	\N	2236
1643	2025-10-11 14:16:35.596	2025-10-11 14:16:38.617	SUCCESS	0	0	0	\N	3021
1644	2025-10-11 14:17:35.616	2025-10-11 14:17:38.317	SUCCESS	0	0	0	\N	2701
1645	2025-10-11 14:18:35.639	2025-10-11 14:18:38.517	SUCCESS	0	0	0	\N	2878
1662	2025-10-11 14:52:07.075	2025-10-11 14:52:14.1	SUCCESS	0	0	0	\N	7025
1664	2025-10-11 14:54:07.123	2025-10-11 14:54:13.901	SUCCESS	0	0	0	\N	6778
1668	2025-10-11 14:58:07.203	2025-10-11 14:58:14.199	SUCCESS	0	0	0	\N	6996
1669	2025-10-11 14:59:07.226	2025-10-11 14:59:15.7	SUCCESS	0	0	0	\N	8474
1671	2025-10-11 15:00:07.25	2025-10-11 15:00:15.9	SUCCESS	0	0	0	\N	8650
1673	2025-10-11 15:01:07.275	2025-10-11 15:01:19.899	ERROR	0	0	0	Connection terminated due to connection timeout	12624
1675	2025-10-11 15:02:07.299	2025-10-11 15:02:16.099	SUCCESS	0	0	0	\N	8800
1677	2025-10-11 15:03:07.323	2025-10-11 15:03:11.599	SUCCESS	0	0	0	\N	4276
1683	2025-10-11 15:08:34.788	2025-10-11 15:08:35.689	SUCCESS	0	0	0	\N	901
1690	2025-10-11 15:14:49.328	2025-10-11 15:14:59.308	SUCCESS	0	0	0	\N	9980
1692	2025-10-11 15:15:49.352	2025-10-11 15:15:57.507	SUCCESS	0	0	0	\N	8155
1702	2025-10-11 15:22:49.512	2025-10-11 15:23:01.608	SUCCESS	0	0	0	\N	12096
1737	2025-10-11 16:22:29.228	2025-10-11 16:22:30.119	SUCCESS	0	0	0	\N	891
1756	2025-10-11 16:32:42.704	2025-10-11 16:32:43.644	SUCCESS	0	0	0	\N	940
1777	2025-10-11 16:41:42.707	2025-10-11 16:41:43.603	SUCCESS	0	0	0	\N	896
1801	2025-10-11 16:54:15.774	2025-10-11 16:54:16.1	SUCCESS	0	0	0	\N	326
1816	2025-10-11 17:01:15.775	2025-10-11 17:01:16.728	SUCCESS	0	0	0	\N	953
1838	2025-10-11 17:12:15.779	2025-10-11 17:12:16.46	SUCCESS	0	0	0	\N	681
1861	2025-10-11 17:23:56.435	2025-10-11 17:23:57.356	SUCCESS	0	0	0	\N	921
1876	2025-10-11 17:33:16.593	2025-10-11 17:33:17.29	SUCCESS	0	0	0	\N	697
1898	2025-10-11 17:44:16.597	2025-10-11 17:44:17.501	SUCCESS	0	0	0	\N	904
1912	2025-10-11 17:56:01.843	2025-10-11 17:56:11.329	SUCCESS	0	0	0	\N	9486
1914	2025-10-11 17:57:01.855	2025-10-11 17:57:14.73	SUCCESS	0	0	0	\N	12875
1916	2025-10-11 17:58:01.88	2025-10-11 17:58:07.23	SUCCESS	0	0	0	\N	5350
1918	2025-10-11 17:59:01.883	2025-10-11 17:59:12.429	SUCCESS	0	0	0	\N	10546
1920	2025-10-11 18:00:01.908	2025-10-11 18:00:08.03	SUCCESS	0	0	0	\N	6122
1922	2025-10-11 18:01:01.91	2025-10-11 18:01:06.43	SUCCESS	0	0	0	\N	4520
372	2025-10-10 08:53:57.736	2025-10-10 08:53:58.799	SUCCESS	0	0	0	\N	1063
373	2025-10-10 08:54:16.429	2025-10-10 08:54:17.34	SUCCESS	0	0	0	\N	911
374	2025-10-10 08:54:57.75	2025-10-10 08:54:59.699	SUCCESS	0	0	0	\N	1949
375	2025-10-10 08:55:16.43	2025-10-10 08:55:17.589	SUCCESS	0	0	0	\N	1159
376	2025-10-10 08:55:57.764	2025-10-10 08:55:59.999	SUCCESS	0	0	0	\N	2235
377	2025-10-10 08:56:57.777	2025-10-10 08:56:59.799	SUCCESS	0	0	0	\N	2022
378	2025-10-10 08:57:07.923	2025-10-10 08:57:08.605	SUCCESS	0	0	0	\N	682
379	2025-10-10 08:57:57.791	2025-10-10 08:58:00.499	SUCCESS	0	0	0	\N	2708
380	2025-10-10 08:58:07.923	2025-10-10 08:58:08.821	SUCCESS	0	0	0	\N	898
381	2025-10-10 08:58:57.804	2025-10-10 08:59:00.299	SUCCESS	0	0	0	\N	2495
382	2025-10-10 08:59:07.924	2025-10-10 08:59:08.807	SUCCESS	0	0	0	\N	883
383	2025-10-10 08:59:57.818	2025-10-10 09:00:00.021	SUCCESS	0	0	0	\N	2203
384	2025-10-10 09:00:07.925	2025-10-10 09:00:09.073	SUCCESS	0	0	0	\N	1148
385	2025-10-10 09:00:57.831	2025-10-10 09:01:00.099	SUCCESS	0	0	0	\N	2268
386	2025-10-10 09:01:57.845	2025-10-10 09:02:00.099	SUCCESS	0	0	0	\N	2254
387	2025-10-10 09:02:10.328	2025-10-10 09:02:10.996	SUCCESS	0	0	0	\N	668
388	2025-10-10 09:02:57.863	2025-10-10 09:03:00.199	SUCCESS	0	0	0	\N	2336
389	2025-10-10 09:03:10.327	2025-10-10 09:03:11.466	SUCCESS	0	0	0	\N	1139
391	2025-10-10 09:04:10.327	2025-10-10 09:04:11.5	SUCCESS	0	0	0	\N	1173
392	2025-10-10 09:04:57.866	2025-10-10 09:04:58.503	SUCCESS	0	0	0	\N	637
393	2025-10-10 09:05:43.865	2025-10-10 09:05:44.778	SUCCESS	0	0	0	\N	913
394	2025-10-10 09:05:57.866	2025-10-10 09:05:58.12	SUCCESS	0	0	0	\N	254
395	2025-10-10 09:06:43.865	2025-10-10 09:06:44.557	SUCCESS	0	0	0	\N	692
396	2025-10-10 09:06:57.866	2025-10-10 09:06:58.126	SUCCESS	0	0	0	\N	260
397	2025-10-10 09:07:43.865	2025-10-10 09:07:44.55	SUCCESS	0	0	0	\N	685
398	2025-10-10 09:07:57.866	2025-10-10 09:07:59.1	SUCCESS	0	0	0	\N	1234
399	2025-10-10 09:08:43.866	2025-10-10 09:08:46.697	SUCCESS	1	0	1	\N	2831
400	2025-10-10 09:08:57.866	2025-10-10 09:08:58.375	SUCCESS	0	0	0	\N	509
401	2025-10-10 09:09:49.642	2025-10-10 09:09:50.334	SUCCESS	0	0	0	\N	692
402	2025-10-10 09:10:49.642	2025-10-10 09:10:50.533	SUCCESS	0	0	0	\N	891
403	2025-10-10 09:10:57.901	2025-10-10 09:11:04.703	SUCCESS	0	0	0	\N	6802
404	2025-10-10 09:11:56.33	2025-10-10 09:11:57.146	SUCCESS	0	0	0	\N	816
405	2025-10-10 09:11:58	2025-10-10 09:12:02.999	SUCCESS	0	0	0	\N	4999
406	2025-10-10 09:12:56.33	2025-10-10 09:12:57.019	SUCCESS	0	0	0	\N	689
407	2025-10-10 09:12:58.099	2025-10-10 09:13:07.601	SUCCESS	0	0	0	\N	9502
408	2025-10-10 09:13:56.329	2025-10-10 09:13:57.233	SUCCESS	0	0	0	\N	904
409	2025-10-10 09:14:05.963	2025-10-10 09:14:06.629	SUCCESS	0	0	0	\N	666
410	2025-10-10 09:14:56.33	2025-10-10 09:14:56.998	SUCCESS	0	0	0	\N	668
411	2025-10-10 09:15:05.964	2025-10-10 09:15:06.516	SUCCESS	0	0	0	\N	552
412	2025-10-10 09:15:56.333	2025-10-10 09:15:57.213	SUCCESS	0	0	0	\N	880
413	2025-10-10 09:16:05.97	2025-10-10 09:16:12.499	SUCCESS	0	0	0	\N	6529
414	2025-10-10 09:16:56.334	2025-10-10 09:16:57.24	SUCCESS	0	0	0	\N	906
415	2025-10-10 09:17:05.973	2025-10-10 09:17:17.7	SUCCESS	0	0	0	\N	11727
416	2025-10-10 09:17:56.335	2025-10-10 09:17:59.461	SUCCESS	1	0	1	\N	3126
417	2025-10-10 09:18:05.979	2025-10-10 09:18:27.1	SUCCESS	1	0	1	\N	21121
418	2025-10-10 09:18:56.336	2025-10-10 09:18:59.418	SUCCESS	1	0	1	\N	3082
419	2025-10-10 09:19:05.985	2025-10-10 09:19:28.999	SUCCESS	1	0	1	\N	23014
421	2025-10-10 09:20:09.597	2025-10-10 09:20:12.165	SUCCESS	1	0	1	\N	2568
420	2025-10-10 09:20:05.988	2025-10-10 09:20:21.699	SUCCESS	1	0	0	\N	15711
422	2025-10-10 09:20:55.107	2025-10-10 09:21:04.382	SUCCESS	0	0	0	\N	9275
424	2025-10-10 09:21:09.597	2025-10-10 09:21:10.527	SUCCESS	0	0	0	\N	930
423	2025-10-10 09:21:05.994	2025-10-10 09:21:13.101	SUCCESS	0	0	0	\N	7107
425	2025-10-10 09:21:55.135	2025-10-10 09:21:58.681	SUCCESS	0	0	0	\N	3546
426	2025-10-10 09:22:09.602	2025-10-10 09:22:10.502	SUCCESS	0	0	0	\N	900
427	2025-10-10 09:22:55.162	2025-10-10 09:22:58.681	SUCCESS	0	0	0	\N	3519
428	2025-10-10 09:23:09.6	2025-10-10 09:23:10.504	SUCCESS	0	0	0	\N	904
429	2025-10-10 09:23:55.165	2025-10-10 09:23:58.58	SUCCESS	0	0	0	\N	3415
430	2025-10-10 09:24:09.601	2025-10-10 09:24:10.504	SUCCESS	0	0	0	\N	903
431	2025-10-10 09:24:55.175	2025-10-10 09:24:57.584	SUCCESS	0	0	0	\N	2409
432	2025-10-10 09:25:09.601	2025-10-10 09:25:10.529	SUCCESS	0	0	0	\N	928
433	2025-10-10 09:25:55.192	2025-10-10 09:25:59.082	SUCCESS	0	0	0	\N	3890
434	2025-10-10 09:26:09.602	2025-10-10 09:26:10.538	SUCCESS	0	0	0	\N	936
435	2025-10-10 09:26:55.22	2025-10-10 09:26:58.38	SUCCESS	0	0	0	\N	3160
436	2025-10-10 09:27:09.603	2025-10-10 09:27:10.518	SUCCESS	0	0	0	\N	915
437	2025-10-10 09:27:55.246	2025-10-10 09:27:58.48	SUCCESS	0	0	0	\N	3234
438	2025-10-10 09:28:09.604	2025-10-10 09:28:10.517	SUCCESS	0	0	0	\N	913
439	2025-10-10 09:28:55.272	2025-10-10 09:28:58.18	SUCCESS	0	0	0	\N	2908
440	2025-10-10 09:29:09.604	2025-10-10 09:29:10.532	SUCCESS	0	0	0	\N	928
441	2025-10-10 09:29:55.297	2025-10-10 09:29:57.803	SUCCESS	0	0	0	\N	2506
442	2025-10-10 09:30:09.604	2025-10-10 09:30:10.498	SUCCESS	0	0	0	\N	894
443	2025-10-10 09:30:55.316	2025-10-10 09:30:58.981	SUCCESS	0	0	0	\N	3665
444	2025-10-10 09:31:09.604	2025-10-10 09:31:10.502	SUCCESS	0	0	0	\N	898
445	2025-10-10 09:31:55.332	2025-10-10 09:31:57.88	SUCCESS	0	0	0	\N	2548
446	2025-10-10 09:32:09.603	2025-10-10 09:32:10.496	SUCCESS	0	0	0	\N	893
447	2025-10-10 09:32:55.355	2025-10-10 09:32:56.296	SUCCESS	0	0	0	\N	941
448	2025-10-10 09:33:09.604	2025-10-10 09:33:10.508	SUCCESS	0	0	0	\N	904
449	2025-10-10 09:34:09.616	2025-10-10 09:34:10.319	SUCCESS	0	0	0	\N	703
450	2025-10-10 09:35:09.61	2025-10-10 09:35:10.29	SUCCESS	0	0	0	\N	680
451	2025-10-10 09:35:22.591	2025-10-10 09:35:29.449	SUCCESS	0	0	0	\N	6858
452	2025-10-10 09:35:23.822	2025-10-10 09:35:36.295	SUCCESS	0	0	0	\N	12473
453	2025-10-10 09:36:09.615	2025-10-10 09:36:10.511	SUCCESS	0	0	0	\N	896
454	2025-10-10 09:36:22.619	2025-10-10 09:36:28.248	SUCCESS	0	0	0	\N	5629
455	2025-10-10 09:36:23.83	2025-10-10 09:36:28.996	SUCCESS	0	0	0	\N	5166
456	2025-10-10 09:37:09.616	2025-10-10 09:37:10.538	SUCCESS	0	0	0	\N	922
457	2025-10-10 09:37:22.647	2025-10-10 09:37:28.549	SUCCESS	0	0	0	\N	5902
458	2025-10-10 09:37:24.095	2025-10-10 09:37:33.895	SUCCESS	0	0	0	\N	9800
459	2025-10-10 09:38:09.617	2025-10-10 09:38:10.529	SUCCESS	0	0	0	\N	912
461	2025-10-10 09:38:24.122	2025-10-10 09:38:28.595	SUCCESS	0	0	0	\N	4473
460	2025-10-10 09:38:22.674	2025-10-10 09:38:31.748	SUCCESS	0	0	0	\N	9074
462	2025-10-10 09:39:09.618	2025-10-10 09:39:10.307	SUCCESS	0	0	0	\N	689
463	2025-10-10 09:39:22.702	2025-10-10 09:39:28.448	SUCCESS	0	0	0	\N	5746
464	2025-10-10 09:39:24.149	2025-10-10 09:39:29.995	SUCCESS	0	0	0	\N	5846
465	2025-10-10 09:40:09.619	2025-10-10 09:40:10.496	SUCCESS	0	0	0	\N	877
1389	2025-10-11 08:53:52.824	2025-10-11 08:53:54.364	SUCCESS	1	0	1	\N	1540
1417	2025-10-11 09:12:02.902	2025-10-11 09:12:04.038	SUCCESS	0	0	0	\N	1136
1449	2025-10-11 09:47:44.412	2025-10-11 09:47:45.369	SUCCESS	0	0	0	\N	957
1469	2025-10-11 10:00:43.666	2025-10-11 10:00:44.56	SUCCESS	0	0	0	\N	894
1480	2025-10-11 10:12:26.58	2025-10-11 10:12:27.476	SUCCESS	0	0	0	\N	896
1496	2025-10-11 10:21:19.717	2025-10-11 10:21:20.616	SUCCESS	0	0	0	\N	899
1543	2025-10-11 12:24:04.031	2025-10-11 12:24:22.647	SUCCESS	0	0	0	\N	18616
1545	2025-10-11 12:25:04.057	2025-10-11 12:25:13.447	SUCCESS	0	0	0	\N	9390
1567	2025-10-11 12:40:41.723	2025-10-11 12:41:01.257	ERROR	0	0	0	Connection terminated due to connection timeout	19534
1569	2025-10-11 12:41:41.749	2025-10-11 12:41:48.457	SUCCESS	0	0	0	\N	6708
1570	2025-10-11 12:42:14.686	2025-10-11 12:42:15.597	SUCCESS	0	0	0	\N	911
1577	2025-10-11 12:45:41.851	2025-10-11 12:45:51.257	SUCCESS	0	0	0	\N	9406
1579	2025-10-11 12:46:41.877	2025-10-11 12:46:51.157	SUCCESS	0	0	0	\N	9280
1581	2025-10-11 12:47:41.881	2025-10-11 12:47:44.758	SUCCESS	0	0	0	\N	2877
1590	2025-10-11 12:54:41.993	2025-10-11 12:54:45.257	SUCCESS	0	0	0	\N	3264
1591	2025-10-11 12:55:42.018	2025-10-11 12:55:52.223	SUCCESS	0	0	0	\N	10205
1592	2025-10-11 12:56:42.043	2025-10-11 12:56:45.958	SUCCESS	0	0	0	\N	3915
1665	2025-10-11 14:55:07.15	2025-10-11 14:55:17.199	SUCCESS	0	0	0	\N	10049
1666	2025-10-11 14:56:07.151	2025-10-11 14:56:17.3	SUCCESS	0	0	0	\N	10149
1667	2025-10-11 14:57:07.177	2025-10-11 14:57:16.8	SUCCESS	0	0	0	\N	9623
1684	2025-10-11 15:09:34.788	2025-10-11 15:09:35.448	SUCCESS	0	0	0	\N	660
1686	2025-10-11 15:11:34.789	2025-10-11 15:11:35.478	SUCCESS	0	0	0	\N	689
1694	2025-10-11 15:16:49.374	2025-10-11 15:16:59.007	SUCCESS	0	0	0	\N	9633
1696	2025-10-11 15:17:49.394	2025-10-11 15:17:53.509	SUCCESS	0	0	0	\N	4115
1698	2025-10-11 15:18:49.419	2025-10-11 15:18:52.908	SUCCESS	0	0	0	\N	3489
1699	2025-10-11 15:19:49.444	2025-10-11 15:19:57.407	SUCCESS	0	0	0	\N	7963
1703	2025-10-11 15:23:49.535	2025-10-11 15:23:53.708	SUCCESS	0	0	0	\N	4173
1704	2025-10-11 15:24:49.558	2025-10-11 15:24:53.207	SUCCESS	0	0	0	\N	3649
1705	2025-10-11 15:25:49.581	2025-10-11 15:25:59.208	SUCCESS	0	0	0	\N	9627
1706	2025-10-11 15:26:49.603	2025-10-11 15:26:52.09	SUCCESS	0	0	0	\N	2487
1707	2025-10-11 15:58:33.971	2025-10-11 15:58:59.244	SUCCESS	1	0	1	\N	25273
1709	2025-10-11 16:00:33.977	2025-10-11 16:00:55.344	SUCCESS	1	0	1	\N	21367
1716	2025-10-11 16:08:34.109	2025-10-11 16:08:34.915	SUCCESS	0	0	0	\N	806
1739	2025-10-11 16:23:29.229	2025-10-11 16:23:32.203	SUCCESS	0	0	0	\N	2974
1758	2025-10-11 16:33:40.659	2025-10-11 16:33:44.844	SUCCESS	0	0	0	\N	4185
1760	2025-10-11 16:34:40.686	2025-10-11 16:34:44.844	SUCCESS	0	0	0	\N	4158
1762	2025-10-11 16:35:14.241	2025-10-11 16:35:20.698	SUCCESS	0	0	0	\N	6457
1763	2025-10-11 16:35:40.708	2025-10-11 16:35:45.144	SUCCESS	0	0	0	\N	4436
1765	2025-10-11 16:36:14.271	2025-10-11 16:36:22.219	SUCCESS	0	0	0	\N	7948
1766	2025-10-11 16:36:40.735	2025-10-11 16:36:44.644	SUCCESS	0	0	0	\N	3909
1772	2025-10-11 16:39:14.358	2025-10-11 16:39:25.897	SUCCESS	1	0	0	\N	11539
1776	2025-10-11 16:41:14.392	2025-10-11 16:41:30.197	SUCCESS	1	0	1	\N	15805
1778	2025-10-11 16:42:14.421	2025-10-11 16:42:21.198	SUCCESS	0	0	0	\N	6777
1779	2025-10-11 16:42:42.71	2025-10-11 16:42:43.366	SUCCESS	0	0	0	\N	656
1784	2025-10-11 16:45:14.507	2025-10-11 16:45:20.398	SUCCESS	0	0	0	\N	5891
1786	2025-10-11 16:46:14.533	2025-10-11 16:46:20.597	SUCCESS	0	0	0	\N	6064
1788	2025-10-11 16:47:14.536	2025-10-11 16:47:15.442	SUCCESS	0	0	0	\N	906
1790	2025-10-11 16:48:14.537	2025-10-11 16:48:21.697	SUCCESS	0	0	0	\N	7160
1792	2025-10-11 16:49:14.696	2025-10-11 16:49:19.999	SUCCESS	0	0	0	\N	5303
1794	2025-10-11 16:50:14.541	2025-10-11 16:50:22.797	SUCCESS	0	0	0	\N	8256
1798	2025-10-11 16:52:14.546	2025-10-11 16:52:18.297	SUCCESS	0	0	0	\N	3751
1800	2025-10-11 16:53:14.549	2025-10-11 16:53:18.796	SUCCESS	0	0	0	\N	4247
1802	2025-10-11 16:54:14.551	2025-10-11 16:54:18.418	SUCCESS	0	0	0	\N	3867
1803	2025-10-11 16:55:15.774	2025-10-11 16:55:16.44	SUCCESS	0	0	0	\N	666
1804	2025-10-11 16:55:14.553	2025-10-11 16:55:19.697	SUCCESS	0	0	0	\N	5144
1806	2025-10-11 16:56:14.555	2025-10-11 16:56:17.898	SUCCESS	0	0	0	\N	3343
1808	2025-10-11 16:57:14.557	2025-10-11 16:57:18.697	SUCCESS	0	0	0	\N	4140
1818	2025-10-11 17:02:15.776	2025-10-11 17:02:16.702	SUCCESS	0	0	0	\N	926
1840	2025-10-11 17:13:15.779	2025-10-11 17:13:16.452	SUCCESS	0	0	0	\N	673
1863	2025-10-11 17:24:56.436	2025-10-11 17:24:57.322	SUCCESS	0	0	0	\N	886
1878	2025-10-11 17:34:16.592	2025-10-11 17:34:17.276	SUCCESS	0	0	0	\N	684
1880	2025-10-11 17:35:16.593	2025-10-11 17:35:17.272	SUCCESS	0	0	0	\N	679
1899	2025-10-11 17:45:16.598	2025-10-11 17:45:17.522	SUCCESS	0	0	0	\N	924
1915	2025-10-11 17:57:16.605	2025-10-11 17:57:17.287	SUCCESS	0	0	0	\N	682
1928	2025-10-11 18:04:01.952	2025-10-11 18:04:06.829	SUCCESS	0	0	0	\N	4877
1930	2025-10-11 18:05:01.975	2025-10-11 18:05:05.429	SUCCESS	0	0	0	\N	3454
1932	2025-10-11 18:06:01.997	2025-10-11 18:06:10.93	SUCCESS	0	0	0	\N	8933
1934	2025-10-11 18:07:02.019	2025-10-11 18:07:05.829	SUCCESS	0	0	0	\N	3810
1936	2025-10-11 18:08:02.04	2025-10-11 18:08:06.129	SUCCESS	0	0	0	\N	4089
1938	2025-10-11 18:09:02.061	2025-10-11 18:09:06.751	SUCCESS	0	0	0	\N	4690
1940	2025-10-11 18:10:02.082	2025-10-11 18:10:06.629	SUCCESS	0	0	0	\N	4547
1942	2025-10-11 18:11:02.102	2025-10-11 18:11:05.83	SUCCESS	0	0	0	\N	3728
1944	2025-10-11 18:12:02.124	2025-10-11 18:12:07.568	SUCCESS	0	0	0	\N	5444
1946	2025-10-11 18:13:02.144	2025-10-11 18:13:05.929	SUCCESS	0	0	0	\N	3785
1948	2025-10-11 18:14:02.165	2025-10-11 18:14:05.73	SUCCESS	0	0	0	\N	3565
1951	2025-10-11 18:15:16.629	2025-10-11 18:15:17.309	SUCCESS	0	0	0	\N	680
1969	2025-10-11 18:24:16.632	2025-10-11 18:24:17.546	SUCCESS	0	0	0	\N	914
1970	2025-10-11 18:25:02.37	2025-10-11 18:25:06.429	SUCCESS	0	0	0	\N	4059
1971	2025-10-11 18:25:08.434	2025-10-11 18:25:17.933	SUCCESS	0	0	0	\N	9499
1984	2025-10-11 18:30:16.634	2025-10-11 18:30:17.549	SUCCESS	0	0	0	\N	915
2000	2025-10-11 18:38:16.643	2025-10-11 18:38:17.552	SUCCESS	0	0	0	\N	909
2014	2025-10-11 18:45:16.645	2025-10-11 18:45:17.542	SUCCESS	0	0	0	\N	897
2034	2025-10-11 18:54:30.595	2025-10-11 18:54:31.495	SUCCESS	0	0	0	\N	900
2049	2025-10-11 19:02:00.914	2025-10-11 19:02:11.885	SUCCESS	0	0	0	\N	10971
2050	2025-10-11 19:02:14.304	2025-10-11 19:02:18.597	SUCCESS	0	0	0	\N	4293
2061	2025-10-11 19:06:01.013	2025-10-11 19:06:36.485	SUCCESS	2	0	2	\N	35472
2068	2025-10-11 19:08:52.555	2025-10-11 19:08:53.24	SUCCESS	0	0	0	\N	685
2072	2025-10-11 19:10:01.098	2025-10-11 19:10:08.185	SUCCESS	0	0	0	\N	7087
2073	2025-10-11 19:10:14.401	2025-10-11 19:10:19.796	SUCCESS	0	0	0	\N	5395
2081	2025-10-11 19:13:14.436	2025-10-11 19:13:17.617	SUCCESS	0	0	0	\N	3181
2895	2025-10-12 09:22:44.188	2025-10-12 09:22:49.507	SUCCESS	0	0	0	\N	5319
466	2025-10-10 09:40:22.715	2025-10-10 09:40:28.348	SUCCESS	0	0	0	\N	5633
467	2025-10-10 09:40:24.161	2025-10-10 09:40:29.295	SUCCESS	0	0	0	\N	5134
468	2025-10-10 09:41:09.62	2025-10-10 09:41:10.726	SUCCESS	0	0	0	\N	1106
474	2025-10-10 09:43:22.766	2025-10-10 09:43:28.348	SUCCESS	0	0	0	\N	5582
475	2025-10-10 09:43:24.242	2025-10-10 09:43:31.395	SUCCESS	0	0	0	\N	7153
477	2025-10-10 09:44:22.793	2025-10-10 09:44:29.748	SUCCESS	0	0	0	\N	6955
478	2025-10-10 09:44:24.268	2025-10-10 09:44:33.095	SUCCESS	0	0	0	\N	8827
486	2025-10-10 09:47:22.852	2025-10-10 09:47:27.948	SUCCESS	0	0	0	\N	5096
487	2025-10-10 09:47:24.331	2025-10-10 09:47:33.095	SUCCESS	0	0	0	\N	8764
493	2025-10-10 09:49:53.048	2025-10-10 09:49:59.748	SUCCESS	0	0	0	\N	6700
1391	2025-10-11 08:55:52.825	2025-10-11 08:55:53.362	SUCCESS	0	0	0	\N	537
1392	2025-10-11 08:56:52.825	2025-10-11 08:56:53.487	SUCCESS	0	0	0	\N	662
1393	2025-10-11 08:57:52.826	2025-10-11 08:57:53.481	SUCCESS	0	0	0	\N	655
1396	2025-10-11 09:00:52.951	2025-10-11 09:00:54.645	SUCCESS	0	0	0	\N	1694
1397	2025-10-11 09:01:52.955	2025-10-11 09:01:55.166	SUCCESS	0	0	0	\N	2211
1451	2025-10-11 09:48:44.413	2025-10-11 09:48:45.304	SUCCESS	0	0	0	\N	891
1470	2025-10-11 10:01:43.696	2025-10-11 10:01:44.59	SUCCESS	0	0	0	\N	894
1481	2025-10-11 10:13:26.58	2025-10-11 10:13:27.538	SUCCESS	0	0	0	\N	958
1497	2025-10-11 10:22:12.676	2025-10-11 10:22:17.808	SUCCESS	0	0	0	\N	5132
1499	2025-10-11 10:23:12.7	2025-10-11 10:23:18.209	SUCCESS	0	0	0	\N	5509
1501	2025-10-11 10:24:12.724	2025-10-11 10:24:17.108	SUCCESS	0	0	0	\N	4384
1520	2025-10-11 10:36:12.993	2025-10-11 10:36:17.209	SUCCESS	0	0	0	\N	4216
1521	2025-10-11 10:37:13.014	2025-10-11 10:37:18.108	SUCCESS	0	0	0	\N	5094
1522	2025-10-11 10:38:13.036	2025-10-11 10:38:19.008	SUCCESS	0	0	0	\N	5972
1523	2025-10-11 10:39:13.056	2025-10-11 10:39:17.91	SUCCESS	0	0	0	\N	4854
1524	2025-10-11 10:40:13.079	2025-10-11 10:40:18.21	SUCCESS	0	0	0	\N	5131
1525	2025-10-11 10:41:13.098	2025-10-11 10:41:16.908	SUCCESS	0	0	0	\N	3810
1544	2025-10-11 12:24:30.365	2025-10-11 12:24:31.299	SUCCESS	0	0	0	\N	934
1572	2025-10-11 12:43:14.686	2025-10-11 12:43:15.569	SUCCESS	0	0	0	\N	883
1670	2025-10-11 14:59:34.784	2025-10-11 14:59:35.533	SUCCESS	0	0	0	\N	749
1685	2025-10-11 15:10:34.789	2025-10-11 15:10:35.683	SUCCESS	0	0	0	\N	894
1708	2025-10-11 15:59:33.973	2025-10-11 15:59:57.544	SUCCESS	1	0	1	\N	23571
1724	2025-10-11 16:15:40.717	2025-10-11 16:15:45.644	SUCCESS	0	0	0	\N	4927
1726	2025-10-11 16:16:40.744	2025-10-11 16:16:46.144	SUCCESS	0	0	0	\N	5400
1728	2025-10-11 16:17:40.771	2025-10-11 16:17:46.844	SUCCESS	0	0	0	\N	6073
1730	2025-10-11 16:18:40.797	2025-10-11 16:18:45.644	SUCCESS	0	0	0	\N	4847
1734	2025-10-11 16:20:40.85	2025-10-11 16:20:46.244	SUCCESS	0	0	0	\N	5394
1738	2025-10-11 16:22:40.904	2025-10-11 16:22:48.044	SUCCESS	0	0	0	\N	7140
1742	2025-10-11 16:24:29.229	2025-10-11 16:24:30.159	SUCCESS	0	0	0	\N	930
1747	2025-10-11 16:26:40.96	2025-10-11 16:26:43.544	SUCCESS	0	0	0	\N	2584
1750	2025-10-11 16:28:40.986	2025-10-11 16:28:46.744	SUCCESS	0	0	0	\N	5758
1755	2025-10-11 16:31:40.044	2025-10-11 16:31:47.445	SUCCESS	0	0	0	\N	7401
1757	2025-10-11 16:33:14.211	2025-10-11 16:33:24.298	SUCCESS	0	0	0	\N	10087
1759	2025-10-11 16:33:42.705	2025-10-11 16:33:43.606	SUCCESS	0	0	0	\N	901
1781	2025-10-11 16:43:42.711	2025-10-11 16:43:43.391	SUCCESS	0	0	0	\N	680
1783	2025-10-11 16:44:42.712	2025-10-11 16:44:43.404	SUCCESS	0	0	0	\N	692
1805	2025-10-11 16:56:15.774	2025-10-11 16:56:16.441	SUCCESS	0	0	0	\N	667
1820	2025-10-11 17:03:15.777	2025-10-11 17:03:16.435	SUCCESS	0	0	0	\N	658
1842	2025-10-11 17:14:15.78	2025-10-11 17:14:16.433	SUCCESS	0	0	0	\N	653
1865	2025-10-11 17:26:16.588	2025-10-11 17:26:17.247	SUCCESS	0	0	0	\N	659
1882	2025-10-11 17:36:16.592	2025-10-11 17:36:17.278	SUCCESS	0	0	0	\N	686
1900	2025-10-11 17:46:16.6	2025-10-11 17:46:17.481	SUCCESS	0	0	0	\N	881
1917	2025-10-11 17:58:16.606	2025-10-11 17:58:17.264	SUCCESS	0	0	0	\N	658
1929	2025-10-11 18:04:16.606	2025-10-11 18:04:17.287	SUCCESS	0	0	0	\N	681
1953	2025-10-11 18:16:16.629	2025-10-11 18:16:17.319	SUCCESS	0	0	0	\N	690
1972	2025-10-11 18:25:16.633	2025-10-11 18:25:17.772	SUCCESS	0	0	0	\N	1139
1986	2025-10-11 18:31:16.635	2025-10-11 18:31:17.545	SUCCESS	0	0	0	\N	910
2001	2025-10-11 18:39:13.747	2025-10-11 18:39:22.133	SUCCESS	0	0	0	\N	8386
2003	2025-10-11 18:40:13.769	2025-10-11 18:40:22.433	SUCCESS	0	0	0	\N	8664
2005	2025-10-11 18:41:13.797	2025-10-11 18:41:21.633	SUCCESS	0	0	0	\N	7836
2007	2025-10-11 18:42:13.825	2025-10-11 18:42:20.134	SUCCESS	0	0	0	\N	6309
2009	2025-10-11 18:43:13.854	2025-10-11 18:43:18.133	SUCCESS	0	0	0	\N	4279
2012	2025-10-11 18:44:14.534	2025-10-11 18:44:23.133	SUCCESS	0	0	0	\N	8599
2017	2025-10-11 18:46:48.824	2025-10-11 18:46:49.803	SUCCESS	0	0	0	\N	979
2035	2025-10-11 18:55:30.596	2025-10-11 18:55:31.254	SUCCESS	0	0	0	\N	658
2036	2025-10-11 18:55:36.404	2025-10-11 18:55:39.298	SUCCESS	0	0	0	\N	2894
2038	2025-10-11 18:56:36.405	2025-10-11 18:56:41.498	SUCCESS	0	0	0	\N	5093
2042	2025-10-11 18:58:36.429	2025-10-11 18:58:44.599	SUCCESS	0	0	0	\N	8170
2047	2025-10-11 19:01:14.304	2025-10-11 19:01:18.996	SUCCESS	0	0	0	\N	4692
2051	2025-10-11 19:02:30.6	2025-10-11 19:02:31.28	SUCCESS	0	0	0	\N	680
2054	2025-10-11 19:03:30.602	2025-10-11 19:03:31.283	SUCCESS	0	0	0	\N	681
2071	2025-10-11 19:09:52.556	2025-10-11 19:09:53.498	SUCCESS	0	0	0	\N	942
2088	2025-10-11 19:15:58.83	2025-10-11 19:16:06.946	SUCCESS	0	0	0	\N	8116
2092	2025-10-11 19:17:58.855	2025-10-11 19:18:09.028	ERROR	0	0	0	duplicate key value violates unique constraint "odoo_sync_queue_order_number_key"	10173
2094	2025-10-11 19:18:58.882	2025-10-11 19:19:08.227	SUCCESS	0	0	0	\N	9345
2098	2025-10-11 19:21:10.079	2025-10-11 19:21:11.344	SUCCESS	0	0	0	\N	1265
2107	2025-10-11 19:25:58.903	2025-10-11 19:26:03.387	SUCCESS	0	0	0	\N	4484
2109	2025-10-11 19:26:58.911	2025-10-11 19:27:09.949	SUCCESS	0	0	0	\N	11038
2115	2025-10-11 19:29:58.939	2025-10-11 19:30:04.527	SUCCESS	0	0	0	\N	5588
2117	2025-10-11 19:30:58.949	2025-10-11 19:31:06.527	SUCCESS	0	0	0	\N	7578
2118	2025-10-11 19:31:10.084	2025-10-11 19:31:11.407	SUCCESS	0	0	0	\N	1323
2126	2025-10-11 19:35:10.084	2025-10-11 19:35:11.08	SUCCESS	0	0	0	\N	996
2132	2025-10-11 19:37:36.98	2025-10-11 19:37:43.605	SUCCESS	0	0	0	\N	6625
2133	2025-10-11 19:38:10.085	2025-10-11 19:38:11.594	SUCCESS	0	0	0	\N	1509
2134	2025-10-11 19:38:55.335	2025-10-11 19:39:05.506	SUCCESS	0	0	0	\N	10171
2136	2025-10-11 19:39:55.361	2025-10-11 19:40:02.785	SUCCESS	0	0	0	\N	7424
2138	2025-10-11 19:40:55.387	2025-10-11 19:41:00.585	SUCCESS	0	0	0	\N	5198
2139	2025-10-11 19:41:03.811	2025-10-11 19:41:07.867	SUCCESS	0	0	0	\N	4056
2141	2025-10-11 19:42:45.453	2025-10-11 19:42:46.474	SUCCESS	0	0	0	\N	1021
2144	2025-10-11 19:44:03.823	2025-10-11 19:44:10.754	SUCCESS	0	0	0	\N	6931
2145	2025-10-11 19:45:03.831	2025-10-11 19:45:13.954	SUCCESS	0	0	0	\N	10123
469	2025-10-10 09:41:22.727	2025-10-10 09:41:28.748	SUCCESS	0	0	0	\N	6021
470	2025-10-10 09:41:24.188	2025-10-10 09:41:30.796	SUCCESS	0	0	0	\N	6608
481	2025-10-10 09:45:24.277	2025-10-10 09:45:30.296	SUCCESS	0	0	0	\N	6019
480	2025-10-10 09:45:22.819	2025-10-10 09:45:34.873	ERROR	0	0	0	Connection terminated due to connection timeout	12054
489	2025-10-10 09:48:24.356	2025-10-10 09:48:25.305	SUCCESS	0	0	0	\N	949
490	2025-10-10 09:48:22.857	2025-10-10 09:48:28.048	SUCCESS	0	0	0	\N	5191
495	2025-10-10 09:50:55.249	2025-10-10 09:51:05.548	SUCCESS	0	0	0	\N	10299
497	2025-10-10 09:51:55.278	2025-10-10 09:52:03.748	SUCCESS	0	0	0	\N	8470
1399	2025-10-11 09:03:02.648	2025-10-11 09:03:03.818	SUCCESS	0	0	0	\N	1170
1453	2025-10-11 09:49:44.416	2025-10-11 09:49:45.34	SUCCESS	0	0	0	\N	924
1471	2025-10-11 10:02:43.726	2025-10-11 10:02:44.631	SUCCESS	0	0	0	\N	905
1482	2025-10-11 10:14:12.49	2025-10-11 10:14:17.909	SUCCESS	0	0	0	\N	5419
1484	2025-10-11 10:15:12.516	2025-10-11 10:15:17.71	SUCCESS	0	0	0	\N	5194
1498	2025-10-11 10:22:19.719	2025-10-11 10:22:20.683	SUCCESS	0	0	0	\N	964
1546	2025-10-11 12:26:04.061	2025-10-11 12:26:13.447	SUCCESS	0	0	0	\N	9386
1548	2025-10-11 12:27:04.086	2025-10-11 12:27:08.748	SUCCESS	0	0	0	\N	4662
1550	2025-10-11 12:28:04.11	2025-10-11 12:28:08.547	SUCCESS	0	0	0	\N	4437
1551	2025-10-11 12:29:04.134	2025-10-11 12:29:07.847	SUCCESS	0	0	0	\N	3713
1552	2025-10-11 12:30:04.158	2025-10-11 12:30:08.748	SUCCESS	0	0	0	\N	4590
1553	2025-10-11 12:31:04.181	2025-10-11 12:31:08.047	SUCCESS	0	0	0	\N	3866
1554	2025-10-11 12:32:04.205	2025-10-11 12:32:14.147	SUCCESS	0	0	0	\N	9942
1555	2025-10-11 12:33:04.227	2025-10-11 12:33:12.148	SUCCESS	0	0	0	\N	7921
1556	2025-10-11 12:34:04.241	2025-10-11 12:34:08.347	SUCCESS	0	0	0	\N	4106
1557	2025-10-11 12:35:04.264	2025-10-11 12:35:07.648	SUCCESS	0	0	0	\N	3384
1559	2025-10-11 12:36:04.287	2025-10-11 12:36:14.948	SUCCESS	0	0	0	\N	10661
1561	2025-10-11 12:37:04.31	2025-10-11 12:37:06.95	SUCCESS	0	0	0	\N	2640
1565	2025-10-11 12:39:41.72	2025-10-11 12:39:49.357	SUCCESS	0	0	0	\N	7637
1571	2025-10-11 12:42:41.772	2025-10-11 12:42:52.057	SUCCESS	0	0	0	\N	10285
1573	2025-10-11 12:43:41.799	2025-10-11 12:43:51.957	SUCCESS	0	0	0	\N	10158
1574	2025-10-11 12:44:14.687	2025-10-11 12:44:15.337	SUCCESS	0	0	0	\N	650
1575	2025-10-11 12:44:41.826	2025-10-11 12:44:52.658	SUCCESS	0	0	0	\N	10832
1583	2025-10-11 12:48:41.883	2025-10-11 12:48:44.357	SUCCESS	0	0	0	\N	2474
1585	2025-10-11 12:49:41.893	2025-10-11 12:49:52.257	SUCCESS	0	0	0	\N	10364
1586	2025-10-11 12:50:41.907	2025-10-11 12:50:49.557	SUCCESS	0	0	0	\N	7650
1587	2025-10-11 12:51:41.939	2025-10-11 12:51:52.358	SUCCESS	0	0	0	\N	10419
1588	2025-10-11 12:52:41.964	2025-10-11 12:52:46.057	SUCCESS	0	0	0	\N	4093
1589	2025-10-11 12:53:41.968	2025-10-11 12:53:45.557	SUCCESS	0	0	0	\N	3589
1593	2025-10-11 12:57:42.068	2025-10-11 12:57:50.158	SUCCESS	0	0	0	\N	8090
1594	2025-10-11 12:58:42.09	2025-10-11 12:58:45.558	SUCCESS	0	0	0	\N	3468
1672	2025-10-11 15:00:34.784	2025-10-11 15:00:35.683	SUCCESS	0	0	0	\N	899
1687	2025-10-11 15:12:34.79	2025-10-11 15:12:35.707	SUCCESS	0	0	0	\N	917
1710	2025-10-11 16:01:33.983	2025-10-11 16:01:50.744	SUCCESS	1	0	1	\N	16761
1711	2025-10-11 16:02:34.005	2025-10-11 16:02:44.545	SUCCESS	0	0	0	\N	10540
1712	2025-10-11 16:03:34.027	2025-10-11 16:03:47.044	SUCCESS	0	0	0	\N	13017
1713	2025-10-11 16:04:34.049	2025-10-11 16:04:47.644	ERROR	0	0	0	Connection terminated due to connection timeout	13595
1714	2025-10-11 16:05:34.071	2025-10-11 16:05:50.046	ERROR	0	0	0	Connection terminated due to connection timeout	15975
1715	2025-10-11 16:06:34.092	2025-10-11 16:06:38.244	SUCCESS	0	0	0	\N	4152
1717	2025-10-11 16:09:40.646	2025-10-11 16:09:46.144	SUCCESS	0	0	0	\N	5498
1718	2025-10-11 16:10:40.65	2025-10-11 16:10:49.744	SUCCESS	0	0	0	\N	9094
1719	2025-10-11 16:11:40.656	2025-10-11 16:11:45.645	SUCCESS	0	0	0	\N	4989
1720	2025-10-11 16:12:40.664	2025-10-11 16:12:47.045	SUCCESS	0	0	0	\N	6381
1721	2025-10-11 16:13:40.666	2025-10-11 16:13:45.444	SUCCESS	0	0	0	\N	4778
1722	2025-10-11 16:14:40.69	2025-10-11 16:14:47.445	SUCCESS	0	0	0	\N	6755
1732	2025-10-11 16:19:40.824	2025-10-11 16:19:46.045	SUCCESS	0	0	0	\N	5221
1736	2025-10-11 16:21:40.877	2025-10-11 16:21:46.044	SUCCESS	0	0	0	\N	5167
1740	2025-10-11 16:23:40.907	2025-10-11 16:23:42.477	SUCCESS	0	0	0	\N	1570
1741	2025-10-11 16:23:42.52	2025-10-11 16:23:42.787	SUCCESS	0	0	0	\N	267
1743	2025-10-11 16:24:40.909	2025-10-11 16:24:42.944	SUCCESS	0	0	0	\N	2035
1744	2025-10-11 16:25:29.229	2025-10-11 16:25:30.137	SUCCESS	0	0	0	\N	908
1745	2025-10-11 16:25:40.934	2025-10-11 16:25:46.144	SUCCESS	0	0	0	\N	5210
1749	2025-10-11 16:27:40.961	2025-10-11 16:27:43.044	SUCCESS	0	0	0	\N	2083
1761	2025-10-11 16:34:42.705	2025-10-11 16:34:43.655	SUCCESS	0	0	0	\N	950
1768	2025-10-11 16:37:14.3	2025-10-11 16:37:19.397	SUCCESS	0	0	0	\N	5097
1770	2025-10-11 16:38:14.329	2025-10-11 16:38:20.097	SUCCESS	0	0	0	\N	5768
1774	2025-10-11 16:40:14.386	2025-10-11 16:40:31.797	SUCCESS	1	0	1	\N	17411
1780	2025-10-11 16:43:14.45	2025-10-11 16:43:19.697	SUCCESS	0	0	0	\N	5247
1782	2025-10-11 16:44:14.479	2025-10-11 16:44:18.897	SUCCESS	0	0	0	\N	4418
1785	2025-10-11 16:45:42.713	2025-10-11 16:45:43.38	SUCCESS	0	0	0	\N	667
1787	2025-10-11 16:46:42.712	2025-10-11 16:46:43.616	SUCCESS	0	0	0	\N	904
1796	2025-10-11 16:51:14.544	2025-10-11 16:51:23.897	SUCCESS	0	0	0	\N	9353
1807	2025-10-11 16:57:15.774	2025-10-11 16:57:16.088	SUCCESS	0	0	0	\N	314
1822	2025-10-11 17:04:15.778	2025-10-11 17:04:16.68	SUCCESS	0	0	0	\N	902
1824	2025-10-11 17:05:15.779	2025-10-11 17:05:16.452	SUCCESS	0	0	0	\N	673
1844	2025-10-11 17:15:15.779	2025-10-11 17:15:16.461	SUCCESS	0	0	0	\N	682
1866	2025-10-11 17:26:32.939	2025-10-11 17:26:39.788	SUCCESS	0	0	0	\N	6849
1868	2025-10-11 17:27:32.961	2025-10-11 17:27:38.289	SUCCESS	0	0	0	\N	5328
1873	2025-10-11 17:31:35.085	2025-10-11 17:31:57.971	SUCCESS	1	0	1	\N	22886
1877	2025-10-11 17:33:35.127	2025-10-11 17:33:40.871	SUCCESS	0	0	0	\N	5744
1879	2025-10-11 17:34:35.146	2025-10-11 17:34:40.671	SUCCESS	0	0	0	\N	5525
1881	2025-10-11 17:35:35.165	2025-10-11 17:35:40.771	SUCCESS	0	0	0	\N	5606
1883	2025-10-11 17:36:35.185	2025-10-11 17:36:40.57	SUCCESS	0	0	0	\N	5385
1884	2025-10-11 17:37:16.593	2025-10-11 17:37:17.253	SUCCESS	0	0	0	\N	660
1885	2025-10-11 17:37:35.205	2025-10-11 17:37:40.071	SUCCESS	0	0	0	\N	4866
1897	2025-10-11 17:43:35.307	2025-10-11 17:43:39.77	SUCCESS	0	0	0	\N	4463
1901	2025-10-11 17:47:16.599	2025-10-11 17:47:17.258	SUCCESS	0	0	0	\N	659
1902	2025-10-11 17:48:16.599	2025-10-11 17:48:17.297	SUCCESS	0	0	0	\N	698
1903	2025-10-11 17:49:16.599	2025-10-11 17:49:19.312	SUCCESS	1	0	1	\N	2713
1919	2025-10-11 17:59:16.606	2025-10-11 17:59:17.273	SUCCESS	0	0	0	\N	667
1933	2025-10-11 18:06:16.607	2025-10-11 18:06:17.484	SUCCESS	0	0	0	\N	877
1955	2025-10-11 18:17:16.629	2025-10-11 18:17:17.576	SUCCESS	0	0	0	\N	947
472	2025-10-10 09:42:24.216	2025-10-10 09:42:31.195	SUCCESS	0	0	0	\N	6979
471	2025-10-10 09:42:22.739	2025-10-10 09:42:31.848	SUCCESS	0	0	0	\N	9109
473	2025-10-10 09:42:33.869	2025-10-10 09:42:34.563	SUCCESS	0	0	0	\N	694
476	2025-10-10 09:43:33.87	2025-10-10 09:43:35.06	SUCCESS	0	0	0	\N	1190
479	2025-10-10 09:44:33.87	2025-10-10 09:44:35.012	SUCCESS	0	0	0	\N	1142
482	2025-10-10 09:45:33.871	2025-10-10 09:45:35.048	SUCCESS	0	0	0	\N	1177
483	2025-10-10 09:46:22.827	2025-10-10 09:46:31.248	SUCCESS	0	0	0	\N	8421
484	2025-10-10 09:46:24.304	2025-10-10 09:46:31.594	SUCCESS	0	0	0	\N	7290
485	2025-10-10 09:46:33.872	2025-10-10 09:46:35.027	SUCCESS	0	0	0	\N	1155
488	2025-10-10 09:47:39.171	2025-10-10 09:47:39.877	SUCCESS	0	0	0	\N	706
491	2025-10-10 09:48:39.172	2025-10-10 09:48:40.318	SUCCESS	0	0	0	\N	1146
492	2025-10-10 09:49:39.174	2025-10-10 09:49:39.855	SUCCESS	0	0	0	\N	681
494	2025-10-10 09:50:39.175	2025-10-10 09:50:39.86	SUCCESS	0	0	0	\N	685
496	2025-10-10 09:51:39.175	2025-10-10 09:51:40.283	SUCCESS	0	0	0	\N	1108
498	2025-10-10 09:52:39.176	2025-10-10 09:52:40.334	SUCCESS	0	0	0	\N	1158
499	2025-10-10 09:52:55.292	2025-10-10 09:53:01.149	SUCCESS	0	0	0	\N	5857
500	2025-10-10 09:53:39.175	2025-10-10 09:53:40.129	SUCCESS	0	0	0	\N	954
501	2025-10-10 09:53:55.304	2025-10-10 09:53:59.948	SUCCESS	0	0	0	\N	4644
502	2025-10-10 09:54:39.175	2025-10-10 09:54:39.84	SUCCESS	0	0	0	\N	665
503	2025-10-10 09:54:55.332	2025-10-10 09:55:01.97	SUCCESS	0	0	0	\N	6638
504	2025-10-10 09:55:39.176	2025-10-10 09:55:39.891	SUCCESS	0	0	0	\N	715
505	2025-10-10 09:55:55.359	2025-10-10 09:56:03.948	SUCCESS	0	0	0	\N	8589
506	2025-10-10 09:56:39.176	2025-10-10 09:56:40.337	SUCCESS	0	0	0	\N	1161
507	2025-10-10 09:56:55.386	2025-10-10 09:57:01.248	SUCCESS	0	0	0	\N	5862
508	2025-10-10 09:57:55.413	2025-10-10 09:58:02.969	SUCCESS	0	0	0	\N	7556
509	2025-10-10 09:58:12.228	2025-10-10 09:58:12.938	SUCCESS	0	0	0	\N	710
510	2025-10-10 09:58:55.436	2025-10-10 09:59:00.848	SUCCESS	0	0	0	\N	5412
511	2025-10-10 09:59:12.229	2025-10-10 09:59:12.913	SUCCESS	0	0	0	\N	684
512	2025-10-10 09:59:55.463	2025-10-10 10:00:02.35	SUCCESS	0	0	0	\N	6887
513	2025-10-10 10:00:12.229	2025-10-10 10:00:13.129	SUCCESS	0	0	0	\N	900
514	2025-10-10 10:00:39.719	2025-10-10 10:00:40.379	SUCCESS	0	0	0	\N	660
515	2025-10-10 10:00:55.488	2025-10-10 10:01:01.748	SUCCESS	0	0	0	\N	6260
516	2025-10-10 10:01:12.229	2025-10-10 10:01:13.128	SUCCESS	0	0	0	\N	899
517	2025-10-10 10:01:24.519	2025-10-10 10:01:31.468	SUCCESS	0	0	0	\N	6949
518	2025-10-10 10:02:12.23	2025-10-10 10:02:13.162	SUCCESS	0	0	0	\N	932
519	2025-10-10 10:03:12.231	2025-10-10 10:03:13.116	SUCCESS	0	0	0	\N	885
520	2025-10-10 10:03:24.59	2025-10-10 10:03:28.568	SUCCESS	0	0	0	\N	3978
521	2025-10-10 10:04:12.232	2025-10-10 10:04:13.239	SUCCESS	0	0	0	\N	1007
522	2025-10-10 10:04:24.616	2025-10-10 10:04:27.568	SUCCESS	0	0	0	\N	2952
523	2025-10-10 10:05:24.642	2025-10-10 10:05:27.168	SUCCESS	0	0	0	\N	2526
524	2025-10-10 10:05:51.258	2025-10-10 10:05:51.939	SUCCESS	0	0	0	\N	681
525	2025-10-10 10:06:24.669	2025-10-10 10:06:27.168	SUCCESS	0	0	0	\N	2499
526	2025-10-10 10:06:51.257	2025-10-10 10:06:51.948	SUCCESS	0	0	0	\N	691
527	2025-10-10 10:07:24.694	2025-10-10 10:07:27.968	SUCCESS	0	0	0	\N	3274
528	2025-10-10 10:07:51.258	2025-10-10 10:07:52.191	SUCCESS	0	0	0	\N	933
529	2025-10-10 10:08:32.568	2025-10-10 10:08:37.569	SUCCESS	0	0	0	\N	5001
530	2025-10-10 10:08:55.696	2025-10-10 10:08:56.624	SUCCESS	0	0	0	\N	928
531	2025-10-10 10:09:32.571	2025-10-10 10:09:35.468	SUCCESS	0	0	0	\N	2897
532	2025-10-10 10:09:55.695	2025-10-10 10:09:56.588	SUCCESS	0	0	0	\N	893
533	2025-10-10 10:10:32.573	2025-10-10 10:10:39.368	SUCCESS	0	0	0	\N	6795
534	2025-10-10 10:10:47.585	2025-10-10 10:10:48.255	SUCCESS	0	0	0	\N	670
535	2025-10-10 10:11:32.579	2025-10-10 10:11:37.668	SUCCESS	0	0	0	\N	5089
536	2025-10-10 10:11:48.363	2025-10-10 10:11:49.3	SUCCESS	0	0	0	\N	937
537	2025-10-10 10:12:32.606	2025-10-10 10:12:38.288	SUCCESS	0	0	0	\N	5682
538	2025-10-10 10:12:48.364	2025-10-10 10:12:49.308	SUCCESS	0	0	0	\N	944
539	2025-10-10 10:13:32.625	2025-10-10 10:13:36.668	SUCCESS	0	0	0	\N	4043
540	2025-10-10 10:13:48.365	2025-10-10 10:13:49.242	SUCCESS	0	0	0	\N	877
541	2025-10-10 10:14:32.636	2025-10-10 10:14:36.468	SUCCESS	0	0	0	\N	3832
542	2025-10-10 10:14:48.366	2025-10-10 10:14:49.335	SUCCESS	0	0	0	\N	969
543	2025-10-10 10:15:48.366	2025-10-10 10:15:49.059	SUCCESS	0	0	0	\N	693
544	2025-10-10 10:16:48.367	2025-10-10 10:16:49.295	SUCCESS	0	0	0	\N	928
545	2025-10-10 10:17:00.708	2025-10-10 10:17:08.583	SUCCESS	0	0	0	\N	7875
546	2025-10-10 10:17:11.225	2025-10-10 10:17:20.197	SUCCESS	0	0	0	\N	8972
547	2025-10-10 10:17:48.368	2025-10-10 10:17:49.028	SUCCESS	0	0	0	\N	660
548	2025-10-10 10:18:00.733	2025-10-10 10:18:10.782	SUCCESS	0	0	0	\N	10049
549	2025-10-10 10:18:11.245	2025-10-10 10:18:18.497	SUCCESS	0	0	0	\N	7252
550	2025-10-10 10:18:48.368	2025-10-10 10:18:49.025	SUCCESS	0	0	0	\N	657
551	2025-10-10 10:19:00.749	2025-10-10 10:19:08.082	SUCCESS	0	0	0	\N	7333
552	2025-10-10 10:19:11.273	2025-10-10 10:19:14.598	SUCCESS	0	0	0	\N	3325
553	2025-10-10 10:20:00.762	2025-10-10 10:20:05.483	SUCCESS	0	0	0	\N	4721
554	2025-10-10 10:20:11.3	2025-10-10 10:20:19.397	SUCCESS	0	0	0	\N	8097
555	2025-10-10 10:20:39.792	2025-10-10 10:20:40.501	SUCCESS	0	0	0	\N	709
556	2025-10-10 10:21:00.786	2025-10-10 10:21:09.082	SUCCESS	0	0	0	\N	8296
557	2025-10-10 10:21:11.397	2025-10-10 10:21:19.698	SUCCESS	0	0	0	\N	8301
558	2025-10-10 10:22:00.799	2025-10-10 10:22:10.882	SUCCESS	0	0	0	\N	10083
559	2025-10-10 10:22:11.423	2025-10-10 10:22:18.497	SUCCESS	0	0	0	\N	7074
560	2025-10-10 10:22:41.159	2025-10-10 10:22:42.074	SUCCESS	0	0	0	\N	915
561	2025-10-10 10:23:00.812	2025-10-10 10:23:09.582	SUCCESS	0	0	0	\N	8770
562	2025-10-10 10:23:11.45	2025-10-10 10:23:19.099	SUCCESS	0	0	0	\N	7649
563	2025-10-10 10:23:41.159	2025-10-10 10:23:42.115	SUCCESS	0	0	0	\N	956
564	2025-10-10 10:24:00.836	2025-10-10 10:24:06.382	SUCCESS	0	0	0	\N	5546
565	2025-10-10 10:24:11.476	2025-10-10 10:24:16.097	SUCCESS	0	0	0	\N	4621
566	2025-10-10 10:25:00.859	2025-10-10 10:25:05.782	SUCCESS	0	0	0	\N	4923
568	2025-10-10 10:25:14.093	2025-10-10 10:25:14.82	SUCCESS	0	0	0	\N	727
567	2025-10-10 10:25:11.502	2025-10-10 10:25:20.197	SUCCESS	0	0	0	\N	8695
570	2025-10-10 10:26:14.093	2025-10-10 10:26:15.015	SUCCESS	0	0	0	\N	922
569	2025-10-10 10:26:11.527	2025-10-10 10:26:15.297	SUCCESS	0	0	0	\N	3770
572	2025-10-10 10:27:14.094	2025-10-10 10:27:14.991	SUCCESS	0	0	0	\N	897
571	2025-10-10 10:27:11.551	2025-10-10 10:27:16.897	SUCCESS	0	0	0	\N	5346
573	2025-10-10 10:28:11.576	2025-10-10 10:28:14.097	SUCCESS	0	0	0	\N	2521
574	2025-10-10 10:28:14.094	2025-10-10 10:28:15.028	SUCCESS	0	0	0	\N	934
575	2025-10-10 10:29:11.601	2025-10-10 10:29:21.019	SUCCESS	1	0	1	\N	9418
576	2025-10-10 10:29:14.094	2025-10-10 10:29:17.517	SUCCESS	1	0	1	\N	3423
577	2025-10-10 10:30:14.095	2025-10-10 10:30:17.124	SUCCESS	1	0	1	\N	3029
578	2025-10-10 10:31:14.096	2025-10-10 10:31:16.987	SUCCESS	1	0	1	\N	2891
579	2025-10-10 10:32:14.096	2025-10-10 10:32:17.085	SUCCESS	1	0	1	\N	2989
580	2025-10-10 10:33:14.096	2025-10-10 10:33:17.067	SUCCESS	1	0	1	\N	2971
581	2025-10-10 10:34:14.097	2025-10-10 10:34:17.073	SUCCESS	1	0	1	\N	2976
582	2025-10-10 10:35:14.097	2025-10-10 10:35:17.172	SUCCESS	1	0	1	\N	3075
583	2025-10-10 10:36:14.098	2025-10-10 10:36:16.974	SUCCESS	1	0	1	\N	2876
584	2025-10-10 10:37:14.103	2025-10-10 10:37:17.047	SUCCESS	1	0	1	\N	2944
585	2025-10-10 10:38:14.104	2025-10-10 10:38:16.985	SUCCESS	1	0	1	\N	2881
586	2025-10-10 10:39:14.105	2025-10-10 10:39:16.96	SUCCESS	1	0	1	\N	2855
587	2025-10-10 10:40:14.106	2025-10-10 10:40:16.986	SUCCESS	1	0	1	\N	2880
588	2025-10-10 10:41:14.106	2025-10-10 10:41:16.845	SUCCESS	1	0	1	\N	2739
589	2025-10-10 10:42:14.106	2025-10-10 10:42:16.77	SUCCESS	1	0	1	\N	2664
590	2025-10-10 10:43:14.106	2025-10-10 10:43:16.845	SUCCESS	1	0	1	\N	2739
591	2025-10-10 10:44:14.107	2025-10-10 10:44:17.309	SUCCESS	1	0	1	\N	3202
592	2025-10-10 10:45:14.108	2025-10-10 10:45:17.052	SUCCESS	1	0	1	\N	2944
593	2025-10-10 10:46:14.108	2025-10-10 10:46:16.72	SUCCESS	1	0	1	\N	2612
594	2025-10-10 10:46:23.356	2025-10-10 10:46:41.011	SUCCESS	1	0	1	\N	17655
595	2025-10-10 10:47:23.931	2025-10-10 10:47:33.831	SUCCESS	1	0	1	\N	9900
596	2025-10-10 10:48:10.114	2025-10-10 10:48:12.857	SUCCESS	1	0	1	\N	2743
598	2025-10-10 10:48:23.514	2025-10-10 10:48:35.789	SUCCESS	1	0	0	\N	12275
599	2025-10-10 10:48:23.934	2025-10-10 10:48:35.731	SUCCESS	1	0	0	\N	11797
597	2025-10-10 10:48:22.276	2025-10-10 10:48:39.4	SUCCESS	1	0	1	\N	17124
600	2025-10-10 10:49:10.114	2025-10-10 10:49:13.107	SUCCESS	1	0	1	\N	2993
602	2025-10-10 10:49:23.54	2025-10-10 10:49:36.189	SUCCESS	1	0	0	\N	12649
601	2025-10-10 10:49:22.277	2025-10-10 10:49:38.699	SUCCESS	1	0	0	\N	16422
603	2025-10-10 10:49:23.941	2025-10-10 10:49:39.631	SUCCESS	1	0	1	\N	15690
605	2025-10-10 10:50:10.116	2025-10-10 10:50:13.296	SUCCESS	1	0	1	\N	3180
606	2025-10-10 10:50:22.302	2025-10-10 10:50:24.614	SUCCESS	1	0	1	\N	2312
607	2025-10-10 10:50:23.565	2025-10-10 10:50:26.12	SUCCESS	0	0	0	\N	2555
608	2025-10-10 10:50:23.945	2025-10-10 10:50:33.531	SUCCESS	0	0	0	\N	9586
604	2025-10-10 10:50:06.149	2025-10-10 10:50:40.937	SUCCESS	1	0	1	\N	34788
610	2025-10-10 10:51:10.116	2025-10-10 10:51:13.359	SUCCESS	1	0	1	\N	3243
609	2025-10-10 10:51:06.163	2025-10-10 10:51:25.637	SUCCESS	1	0	1	\N	19474
611	2025-10-10 10:51:23.972	2025-10-10 10:51:39.731	SUCCESS	1	0	1	\N	15759
613	2025-10-10 10:52:10.117	2025-10-10 10:52:10.773	SUCCESS	0	0	0	\N	656
612	2025-10-10 10:52:06.191	2025-10-10 10:52:16.937	SUCCESS	0	0	0	\N	10746
614	2025-10-10 10:52:24	2025-10-10 10:52:34.732	SUCCESS	0	0	0	\N	10732
616	2025-10-10 10:53:10.118	2025-10-10 10:53:10.775	SUCCESS	0	0	0	\N	657
615	2025-10-10 10:53:06.217	2025-10-10 10:53:16.837	SUCCESS	0	0	0	\N	10620
618	2025-10-10 10:54:10.118	2025-10-10 10:54:10.792	SUCCESS	0	0	0	\N	674
617	2025-10-10 10:54:06.245	2025-10-10 10:54:12.637	SUCCESS	0	0	0	\N	6392
620	2025-10-10 10:55:10.117	2025-10-10 10:55:10.797	SUCCESS	0	0	0	\N	680
619	2025-10-10 10:55:06.271	2025-10-10 10:55:15.936	SUCCESS	0	0	0	\N	9665
621	2025-10-10 10:56:06.272	2025-10-10 10:56:07.737	SUCCESS	0	0	0	\N	1465
622	2025-10-10 10:56:10.118	2025-10-10 10:56:11.062	SUCCESS	0	0	0	\N	944
623	2025-10-10 10:57:06.299	2025-10-10 10:57:16.038	SUCCESS	0	0	0	\N	9739
625	2025-10-10 10:58:09.269	2025-10-10 10:58:09.833	SUCCESS	0	0	0	\N	564
624	2025-10-10 10:58:06.325	2025-10-10 10:58:15.936	ERROR	0	0	0	Connection terminated due to connection timeout	9611
626	2025-10-10 10:59:06.351	2025-10-10 10:59:16.037	ERROR	0	0	0	Connection terminated due to connection timeout	9686
627	2025-10-10 10:59:37.559	2025-10-10 10:59:38.254	SUCCESS	0	0	0	\N	695
628	2025-10-10 11:00:06.361	2025-10-10 11:00:11.136	SUCCESS	0	0	0	\N	4775
629	2025-10-10 11:00:37.581	2025-10-10 11:00:38.891	SUCCESS	0	0	0	\N	1310
630	2025-10-10 11:01:06.387	2025-10-10 11:01:10.337	SUCCESS	0	0	0	\N	3950
631	2025-10-10 11:01:37.581	2025-10-10 11:01:38.495	SUCCESS	0	0	0	\N	914
632	2025-10-10 11:02:06.412	2025-10-10 11:02:12.436	SUCCESS	0	0	0	\N	6024
633	2025-10-10 11:02:37.582	2025-10-10 11:02:39.504	SUCCESS	0	0	0	\N	1922
634	2025-10-10 11:03:06.437	2025-10-10 11:03:11.737	SUCCESS	0	0	0	\N	5300
635	2025-10-10 11:03:37.582	2025-10-10 11:03:38.49	SUCCESS	0	0	0	\N	908
636	2025-10-10 11:04:06.461	2025-10-10 11:04:19.436	SUCCESS	0	0	0	\N	12975
637	2025-10-10 11:04:37.583	2025-10-10 11:04:38.349	SUCCESS	0	0	0	\N	766
638	2025-10-10 11:05:06.485	2025-10-10 11:05:07.28	SUCCESS	0	0	0	\N	795
639	2025-10-10 11:05:37.584	2025-10-10 11:05:38.252	SUCCESS	0	0	0	\N	668
640	2025-10-10 11:05:53.914	2025-10-10 11:06:08.041	ERROR	0	0	0	Connection terminated due to connection timeout	14127
641	2025-10-10 11:06:53.941	2025-10-10 11:07:00.641	SUCCESS	0	0	0	\N	6700
642	2025-10-10 11:07:00.408	2025-10-10 11:07:01.084	SUCCESS	0	0	0	\N	676
643	2025-10-10 11:07:53.969	2025-10-10 11:08:03.342	SUCCESS	0	0	0	\N	9373
644	2025-10-10 11:08:47.512	2025-10-10 11:08:48.213	SUCCESS	0	0	0	\N	701
645	2025-10-10 11:08:53.986	2025-10-10 11:09:01.541	SUCCESS	0	0	0	\N	7555
646	2025-10-10 11:09:47.511	2025-10-10 11:09:48.682	SUCCESS	0	0	0	\N	1171
647	2025-10-10 11:09:54.012	2025-10-10 11:10:02.442	SUCCESS	0	0	0	\N	8430
648	2025-10-10 11:10:47.512	2025-10-10 11:10:48.157	SUCCESS	0	0	0	\N	645
649	2025-10-10 11:10:54.038	2025-10-10 11:11:02.342	SUCCESS	0	0	0	\N	8304
650	2025-10-10 11:11:54.065	2025-10-10 11:12:16.541	SUCCESS	1	0	1	\N	22476
651	2025-10-10 11:12:44.029	2025-10-10 11:12:46.907	SUCCESS	1	0	1	\N	2878
652	2025-10-10 11:12:54.091	2025-10-10 11:13:15.742	SUCCESS	2	0	1	\N	21651
653	2025-10-10 11:13:44.028	2025-10-10 11:13:48.507	SUCCESS	2	0	2	\N	4479
654	2025-10-10 11:13:54.116	2025-10-10 11:14:02.142	SUCCESS	0	0	0	\N	8026
655	2025-10-10 11:14:44.028	2025-10-10 11:14:45.192	SUCCESS	0	0	0	\N	1164
656	2025-10-10 11:14:54.141	2025-10-10 11:15:01.342	SUCCESS	0	0	0	\N	7201
657	2025-10-10 11:15:44.028	2025-10-10 11:15:45.131	SUCCESS	0	0	0	\N	1103
658	2025-10-10 11:15:54.166	2025-10-10 11:16:04.041	SUCCESS	0	0	0	\N	9875
659	2025-10-10 11:16:44.029	2025-10-10 11:16:44.93	SUCCESS	0	0	0	\N	901
660	2025-10-10 11:16:54.19	2025-10-10 11:17:03.641	SUCCESS	0	0	0	\N	9451
661	2025-10-10 11:17:44.032	2025-10-10 11:17:44.937	SUCCESS	0	0	0	\N	905
662	2025-10-10 11:17:54.214	2025-10-10 11:18:01.141	SUCCESS	0	0	0	\N	6927
663	2025-10-10 11:18:54.218	2025-10-10 11:18:56.841	SUCCESS	0	0	0	\N	2623
664	2025-10-10 11:19:54.242	2025-10-10 11:20:03.441	SUCCESS	0	0	0	\N	9199
665	2025-10-10 11:20:12.039	2025-10-10 11:20:12.986	SUCCESS	0	0	0	\N	947
2896	2025-10-12 09:23:44.205	2025-10-12 09:23:49.407	SUCCESS	0	0	0	\N	5202
666	2025-10-10 11:20:54.266	2025-10-10 11:21:01.841	SUCCESS	0	0	0	\N	7575
667	2025-10-10 11:21:12.04	2025-10-10 11:21:12.957	SUCCESS	0	0	0	\N	917
670	2025-10-10 11:22:54.312	2025-10-10 11:23:01.841	SUCCESS	0	0	0	\N	7529
672	2025-10-10 11:23:54.334	2025-10-10 11:24:02.341	SUCCESS	0	0	0	\N	8007
674	2025-10-10 11:24:54.357	2025-10-10 11:24:58.141	SUCCESS	0	0	0	\N	3784
676	2025-10-10 11:25:54.38	2025-10-10 11:26:03.341	SUCCESS	0	0	0	\N	8961
678	2025-10-10 11:26:54.402	2025-10-10 11:26:58.041	SUCCESS	0	0	0	\N	3639
680	2025-10-10 11:27:54.41	2025-10-10 11:28:02.441	SUCCESS	0	0	0	\N	8031
682	2025-10-10 11:28:54.432	2025-10-10 11:28:58.941	SUCCESS	0	0	0	\N	4509
684	2025-10-10 11:29:54.454	2025-10-10 11:29:58.063	SUCCESS	0	0	0	\N	3609
686	2025-10-10 11:30:54.477	2025-10-10 11:30:57.941	SUCCESS	0	0	0	\N	3464
688	2025-10-10 11:31:54.498	2025-10-10 11:31:58.264	SUCCESS	0	0	0	\N	3766
690	2025-10-10 11:32:54.522	2025-10-10 11:32:58.042	SUCCESS	0	0	0	\N	3520
692	2025-10-10 11:33:54.544	2025-10-10 11:34:03.942	SUCCESS	0	0	0	\N	9398
1400	2025-10-11 09:03:52.96	2025-10-11 09:03:55.067	SUCCESS	0	0	0	\N	2107
1402	2025-10-11 09:04:52.963	2025-10-11 09:04:55.745	SUCCESS	0	0	0	\N	2782
1416	2025-10-11 09:11:52.982	2025-10-11 09:11:55.345	SUCCESS	0	0	0	\N	2363
1418	2025-10-11 09:12:52.984	2025-10-11 09:12:56.146	SUCCESS	0	0	0	\N	3162
1419	2025-10-11 09:13:52.988	2025-10-11 09:13:55.445	SUCCESS	0	0	0	\N	2457
1420	2025-10-11 09:14:52.991	2025-10-11 09:14:55.045	SUCCESS	0	0	0	\N	2054
1421	2025-10-11 09:15:52.995	2025-10-11 09:15:56.446	SUCCESS	0	0	0	\N	3451
1422	2025-10-11 09:16:52.998	2025-10-11 09:16:55.545	SUCCESS	0	0	0	\N	2547
1423	2025-10-11 09:17:53.001	2025-10-11 09:17:55.446	SUCCESS	0	0	0	\N	2445
1424	2025-10-11 09:18:53.003	2025-10-11 09:18:56.045	SUCCESS	0	0	0	\N	3042
1425	2025-10-11 09:19:53.016	2025-10-11 09:19:55.245	SUCCESS	0	0	0	\N	2229
1427	2025-10-11 09:21:53.023	2025-10-11 09:21:55.274	SUCCESS	0	0	0	\N	2251
1428	2025-10-11 09:22:53.027	2025-10-11 09:22:55.145	SUCCESS	0	0	0	\N	2118
1429	2025-10-11 09:23:53.03	2025-10-11 09:23:55.545	SUCCESS	0	0	0	\N	2515
1430	2025-10-11 09:24:53.032	2025-10-11 09:24:55.645	SUCCESS	0	0	0	\N	2613
1431	2025-10-11 09:25:53.036	2025-10-11 09:25:55.845	SUCCESS	0	0	0	\N	2809
1432	2025-10-11 09:26:53.039	2025-10-11 09:26:55.275	SUCCESS	0	0	0	\N	2236
1433	2025-10-11 09:27:53.042	2025-10-11 09:27:56.446	SUCCESS	0	0	0	\N	3404
1434	2025-10-11 09:28:53.044	2025-10-11 09:28:57.145	SUCCESS	0	0	0	\N	4101
1456	2025-10-11 09:51:44.889	2025-10-11 09:51:47.296	SUCCESS	1	0	0	\N	2407
1472	2025-10-11 10:03:43.756	2025-10-11 10:03:44.679	SUCCESS	0	0	0	\N	923
1483	2025-10-11 10:14:26.581	2025-10-11 10:14:27.48	SUCCESS	0	0	0	\N	899
1500	2025-10-11 10:23:19.72	2025-10-11 10:23:20.863	SUCCESS	0	0	0	\N	1143
1547	2025-10-11 12:26:45.154	2025-10-11 12:26:46.39	SUCCESS	0	0	0	\N	1236
1576	2025-10-11 12:45:14.688	2025-10-11 12:45:15.368	SUCCESS	0	0	0	\N	680
1674	2025-10-11 15:01:34.785	2025-10-11 15:01:35.748	SUCCESS	0	0	0	\N	963
1688	2025-10-11 15:13:34.791	2025-10-11 15:13:35.708	SUCCESS	0	0	0	\N	917
1723	2025-10-11 16:15:21.337	2025-10-11 16:15:22.292	SUCCESS	0	0	0	\N	955
1725	2025-10-11 16:16:21.338	2025-10-11 16:16:22.005	SUCCESS	0	0	0	\N	667
1746	2025-10-11 16:26:29.23	2025-10-11 16:26:30.328	SUCCESS	0	0	0	\N	1098
1764	2025-10-11 16:35:42.706	2025-10-11 16:35:43.649	SUCCESS	0	0	0	\N	943
1789	2025-10-11 16:47:42.713	2025-10-11 16:47:43.589	SUCCESS	0	0	0	\N	876
1809	2025-10-11 16:58:15.775	2025-10-11 16:58:16.434	SUCCESS	0	0	0	\N	659
1826	2025-10-11 17:06:15.778	2025-10-11 17:06:16.476	SUCCESS	0	0	0	\N	698
1851	2025-10-11 17:18:56.429	2025-10-11 17:18:57.355	SUCCESS	0	0	0	\N	926
1867	2025-10-11 17:27:16.587	2025-10-11 17:27:17.526	SUCCESS	0	0	0	\N	939
1886	2025-10-11 17:38:16.594	2025-10-11 17:38:17.245	SUCCESS	0	0	0	\N	651
1904	2025-10-11 17:50:16.6	2025-10-11 17:50:19.424	SUCCESS	1	0	1	\N	2824
1921	2025-10-11 18:00:16.606	2025-10-11 18:00:17.492	SUCCESS	0	0	0	\N	886
1935	2025-10-11 18:07:16.608	2025-10-11 18:07:17.267	SUCCESS	0	0	0	\N	659
1956	2025-10-11 18:18:02.247	2025-10-11 18:18:06.057	SUCCESS	0	0	0	\N	3810
1958	2025-10-11 18:19:02.266	2025-10-11 18:19:06.43	SUCCESS	0	0	0	\N	4164
1960	2025-10-11 18:20:02.286	2025-10-11 18:20:08.729	SUCCESS	0	0	0	\N	6443
1962	2025-10-11 18:21:02.293	2025-10-11 18:21:05.429	SUCCESS	0	0	0	\N	3136
1964	2025-10-11 18:22:02.312	2025-10-11 18:22:14.23	SUCCESS	0	0	0	\N	11918
1966	2025-10-11 18:23:02.332	2025-10-11 18:23:08.529	SUCCESS	0	0	0	\N	6197
1968	2025-10-11 18:24:02.351	2025-10-11 18:24:05.129	SUCCESS	0	0	0	\N	2778
1973	2025-10-11 18:26:02.383	2025-10-11 18:26:06.629	SUCCESS	0	0	0	\N	4246
1974	2025-10-11 18:26:08.435	2025-10-11 18:26:14.433	SUCCESS	0	0	0	\N	5998
1988	2025-10-11 18:32:16.634	2025-10-11 18:32:17.756	SUCCESS	0	0	0	\N	1122
2002	2025-10-11 18:39:16.644	2025-10-11 18:39:17.539	SUCCESS	0	0	0	\N	895
2019	2025-10-11 18:47:48.824	2025-10-11 18:47:49.736	SUCCESS	0	0	0	\N	912
2037	2025-10-11 18:56:30.595	2025-10-11 18:56:31.549	SUCCESS	0	0	0	\N	954
2052	2025-10-11 19:03:00.94	2025-10-11 19:03:10.085	SUCCESS	0	0	0	\N	9145
2053	2025-10-11 19:03:14.327	2025-10-11 19:03:18.797	SUCCESS	0	0	0	\N	4470
2055	2025-10-11 19:04:00.964	2025-10-11 19:04:05.285	SUCCESS	0	0	0	\N	4321
2056	2025-10-11 19:04:14.35	2025-10-11 19:04:18.097	SUCCESS	0	0	0	\N	3747
2064	2025-10-11 19:07:14.358	2025-10-11 19:07:18.697	SUCCESS	0	0	0	\N	4339
2066	2025-10-11 19:08:01.052	2025-10-11 19:08:05.185	SUCCESS	0	0	0	\N	4133
2067	2025-10-11 19:08:14.359	2025-10-11 19:08:22.479	SUCCESS	0	0	0	\N	8120
2069	2025-10-11 19:09:01.074	2025-10-11 19:09:10.685	SUCCESS	0	0	0	\N	9611
2070	2025-10-11 19:09:14.38	2025-10-11 19:09:20.296	SUCCESS	0	0	0	\N	5916
2074	2025-10-11 19:10:52.557	2025-10-11 19:10:53.226	SUCCESS	0	0	0	\N	669
2075	2025-10-11 19:11:01.122	2025-10-11 19:11:05.485	SUCCESS	0	0	0	\N	4363
2076	2025-10-11 19:11:14.414	2025-10-11 19:11:18.396	SUCCESS	0	0	0	\N	3982
2077	2025-10-11 19:12:01.146	2025-10-11 19:12:06.184	SUCCESS	0	0	0	\N	5038
2078	2025-10-11 19:12:14.432	2025-10-11 19:12:18.198	SUCCESS	0	0	0	\N	3766
2080	2025-10-11 19:13:01.168	2025-10-11 19:13:04.851	SUCCESS	0	0	0	\N	3683
2083	2025-10-11 19:13:49.302	2025-10-11 19:13:58.528	SUCCESS	0	0	0	\N	9226
2084	2025-10-11 19:14:14.457	2025-10-11 19:14:18.397	SUCCESS	0	0	0	\N	3940
2086	2025-10-11 19:14:58.827	2025-10-11 19:15:06.727	SUCCESS	0	0	0	\N	7900
2089	2025-10-11 19:16:45.193	2025-10-11 19:16:48.038	ERROR	1	0	1	duplicate key value violates unique constraint "odoo_sync_queue_order_number_key"	2845
2090	2025-10-11 19:16:58.832	2025-10-11 19:17:25.951	SUCCESS	1	0	1	\N	27119
2100	2025-10-11 19:22:10.078	2025-10-11 19:22:11.335	SUCCESS	0	0	0	\N	1257
2101	2025-10-11 19:22:58.898	2025-10-11 19:23:08.027	SUCCESS	0	0	0	\N	9129
2103	2025-10-11 19:23:58.901	2025-10-11 19:24:01.237	SUCCESS	0	0	0	\N	2336
2105	2025-10-11 19:24:58.902	2025-10-11 19:25:01.532	SUCCESS	0	0	0	\N	2630
668	2025-10-10 11:21:54.288	2025-10-10 11:22:00.741	SUCCESS	0	0	0	\N	6453
669	2025-10-10 11:22:12.041	2025-10-10 11:22:12.938	SUCCESS	0	0	0	\N	897
671	2025-10-10 11:23:12.042	2025-10-10 11:23:12.977	SUCCESS	0	0	0	\N	935
673	2025-10-10 11:24:12.043	2025-10-10 11:24:12.944	SUCCESS	0	0	0	\N	901
675	2025-10-10 11:25:12.043	2025-10-10 11:25:12.991	SUCCESS	0	0	0	\N	948
677	2025-10-10 11:26:12.044	2025-10-10 11:26:12.932	SUCCESS	0	0	0	\N	888
679	2025-10-10 11:27:12.045	2025-10-10 11:27:12.972	SUCCESS	0	0	0	\N	927
681	2025-10-10 11:28:12.046	2025-10-10 11:28:12.964	SUCCESS	0	0	0	\N	918
683	2025-10-10 11:29:12.045	2025-10-10 11:29:13	SUCCESS	0	0	0	\N	955
685	2025-10-10 11:30:12.046	2025-10-10 11:30:12.956	SUCCESS	0	0	0	\N	910
687	2025-10-10 11:31:12.046	2025-10-10 11:31:13.005	SUCCESS	0	0	0	\N	959
689	2025-10-10 11:32:12.047	2025-10-10 11:32:12.961	SUCCESS	0	0	0	\N	914
691	2025-10-10 11:33:12.047	2025-10-10 11:33:12.98	SUCCESS	0	0	0	\N	933
693	2025-10-10 11:34:12.048	2025-10-10 11:34:12.949	SUCCESS	0	0	0	\N	901
694	2025-10-10 11:35:12.048	2025-10-10 11:35:12.992	SUCCESS	0	0	0	\N	944
695	2025-10-10 11:36:12.049	2025-10-10 11:36:12.966	SUCCESS	0	0	0	\N	917
696	2025-10-10 11:37:12.05	2025-10-10 11:37:13.02	SUCCESS	0	0	0	\N	970
697	2025-10-10 11:38:12.051	2025-10-10 11:38:12.991	SUCCESS	0	0	0	\N	940
698	2025-10-10 11:39:12.051	2025-10-10 11:39:12.983	SUCCESS	0	0	0	\N	932
699	2025-10-10 11:40:12.051	2025-10-10 11:40:13	SUCCESS	0	0	0	\N	949
700	2025-10-10 11:41:12.051	2025-10-10 11:41:12.946	SUCCESS	0	0	0	\N	895
701	2025-10-10 11:42:12.051	2025-10-10 11:42:12.942	SUCCESS	0	0	0	\N	891
702	2025-10-10 11:43:12.052	2025-10-10 11:43:12.961	SUCCESS	0	0	0	\N	909
703	2025-10-10 11:44:12.051	2025-10-10 11:44:12.982	SUCCESS	0	0	0	\N	931
704	2025-10-10 11:45:12.052	2025-10-10 11:45:15.548	SUCCESS	1	0	1	\N	3496
705	2025-10-10 11:46:12.052	2025-10-10 11:46:14.836	SUCCESS	1	0	1	\N	2784
706	2025-10-10 11:47:12.055	2025-10-10 11:47:14.85	SUCCESS	1	0	1	\N	2795
707	2025-10-10 11:48:12.056	2025-10-10 11:48:15.26	SUCCESS	1	0	1	\N	3204
708	2025-10-10 11:49:12.057	2025-10-10 11:49:14.815	SUCCESS	1	0	1	\N	2758
709	2025-10-10 11:50:12.058	2025-10-10 11:50:15.209	SUCCESS	1	0	1	\N	3151
710	2025-10-10 11:51:12.059	2025-10-10 11:51:14.913	SUCCESS	1	0	1	\N	2854
711	2025-10-10 11:52:12.059	2025-10-10 11:52:15.188	SUCCESS	1	0	1	\N	3129
712	2025-10-10 11:53:12.06	2025-10-10 11:53:15.141	SUCCESS	1	0	1	\N	3081
713	2025-10-10 11:54:12.06	2025-10-10 11:54:15.145	SUCCESS	1	0	1	\N	3085
714	2025-10-10 11:55:12.059	2025-10-10 11:55:14.74	SUCCESS	1	0	1	\N	2681
715	2025-10-10 11:56:12.06	2025-10-10 11:56:14.086	SUCCESS	1	0	1	\N	2026
716	2025-10-10 11:57:12.06	2025-10-10 11:57:16.975	SUCCESS	2	0	2	\N	4915
717	2025-10-10 11:58:12.06	2025-10-10 11:58:12.962	SUCCESS	0	0	0	\N	902
718	2025-10-10 11:59:23.397	2025-10-10 11:59:24.11	SUCCESS	0	0	0	\N	713
719	2025-10-10 12:00:23.395	2025-10-10 12:00:23.723	SUCCESS	0	0	0	\N	328
720	2025-10-10 12:01:23.396	2025-10-10 12:01:24.509	SUCCESS	0	0	0	\N	1113
721	2025-10-10 12:02:33.317	2025-10-10 12:02:33.979	SUCCESS	0	0	0	\N	662
722	2025-10-10 12:03:33.318	2025-10-10 12:03:34.029	SUCCESS	0	0	0	\N	711
723	2025-10-10 12:04:01.236	2025-10-10 12:04:10.066	SUCCESS	0	0	0	\N	8830
724	2025-10-10 12:04:33.319	2025-10-10 12:04:34.213	SUCCESS	0	0	0	\N	894
725	2025-10-10 12:05:01.263	2025-10-10 12:05:06.566	SUCCESS	0	0	0	\N	5303
726	2025-10-10 12:05:48.626	2025-10-10 12:05:49.338	SUCCESS	0	0	0	\N	712
727	2025-10-10 12:06:01.289	2025-10-10 12:06:10.465	SUCCESS	0	0	0	\N	9176
728	2025-10-10 12:06:48.627	2025-10-10 12:06:49.729	SUCCESS	0	0	0	\N	1102
729	2025-10-10 12:07:01.317	2025-10-10 12:07:06.565	SUCCESS	0	0	0	\N	5248
730	2025-10-10 12:07:48.628	2025-10-10 12:07:49.313	SUCCESS	0	0	0	\N	685
731	2025-10-10 12:08:01.344	2025-10-10 12:08:11.565	SUCCESS	0	0	0	\N	10221
732	2025-10-10 12:08:48.627	2025-10-10 12:08:49.183	SUCCESS	0	0	0	\N	556
733	2025-10-10 12:09:01.37	2025-10-10 12:09:05.965	SUCCESS	0	0	0	\N	4595
734	2025-10-10 12:10:01.397	2025-10-10 12:10:09.365	SUCCESS	0	0	0	\N	7968
735	2025-10-10 12:10:27.28	2025-10-10 12:10:28.23	SUCCESS	0	0	0	\N	950
736	2025-10-10 12:11:01.422	2025-10-10 12:11:11.467	SUCCESS	0	0	0	\N	10045
737	2025-10-10 12:11:27.28	2025-10-10 12:11:28.401	SUCCESS	0	0	0	\N	1121
738	2025-10-10 12:12:01.447	2025-10-10 12:12:05.865	SUCCESS	0	0	0	\N	4418
739	2025-10-10 12:12:49.021	2025-10-10 12:12:49.706	SUCCESS	0	0	0	\N	685
740	2025-10-10 12:13:01.472	2025-10-10 12:13:10.965	SUCCESS	0	0	0	\N	9493
741	2025-10-10 12:14:01.157	2025-10-10 12:14:01.825	SUCCESS	0	0	0	\N	668
742	2025-10-10 12:14:01.496	2025-10-10 12:14:05.965	SUCCESS	0	0	0	\N	4469
743	2025-10-10 12:15:01.157	2025-10-10 12:15:02.32	SUCCESS	0	0	0	\N	1163
744	2025-10-10 12:15:01.521	2025-10-10 12:15:12.765	SUCCESS	0	0	0	\N	11244
745	2025-10-10 12:16:01.158	2025-10-10 12:16:02.099	SUCCESS	0	0	0	\N	941
746	2025-10-10 12:16:01.543	2025-10-10 12:16:05.365	SUCCESS	0	0	0	\N	3822
747	2025-10-10 12:17:01.159	2025-10-10 12:17:04.134	SUCCESS	1	0	1	\N	2975
748	2025-10-10 12:17:01.567	2025-10-10 12:17:18.965	SUCCESS	1	0	1	\N	17398
749	2025-10-10 12:18:01.16	2025-10-10 12:18:04.336	SUCCESS	1	0	1	\N	3176
750	2025-10-10 12:18:01.592	2025-10-10 12:18:16.965	SUCCESS	1	0	1	\N	15373
751	2025-10-10 12:19:01.161	2025-10-10 12:19:04.075	SUCCESS	1	0	1	\N	2914
752	2025-10-10 12:19:01.615	2025-10-10 12:19:15.765	SUCCESS	1	0	1	\N	14150
753	2025-10-10 12:20:01.162	2025-10-10 12:20:03.975	SUCCESS	1	0	1	\N	2813
754	2025-10-10 12:20:01.639	2025-10-10 12:20:06.265	SUCCESS	0	0	0	\N	4626
755	2025-10-10 12:21:01.163	2025-10-10 12:21:02.3	SUCCESS	0	0	0	\N	1137
756	2025-10-10 12:21:01.663	2025-10-10 12:21:06.065	SUCCESS	0	0	0	\N	4402
757	2025-10-10 12:22:01.164	2025-10-10 12:22:01.852	SUCCESS	0	0	0	\N	688
758	2025-10-10 12:22:01.683	2025-10-10 12:22:06.765	SUCCESS	0	0	0	\N	5082
759	2025-10-10 12:23:01.165	2025-10-10 12:23:02.071	SUCCESS	0	0	0	\N	906
760	2025-10-10 12:23:01.703	2025-10-10 12:23:05.465	SUCCESS	0	0	0	\N	3762
761	2025-10-10 12:24:01.165	2025-10-10 12:24:02.298	SUCCESS	0	0	0	\N	1133
762	2025-10-10 12:24:01.722	2025-10-10 12:24:06.165	SUCCESS	0	0	0	\N	4443
763	2025-10-10 12:25:01.165	2025-10-10 12:25:02.061	SUCCESS	0	0	0	\N	896
764	2025-10-10 12:25:01.743	2025-10-10 12:25:05.765	SUCCESS	0	0	0	\N	4022
765	2025-10-10 12:26:01.166	2025-10-10 12:26:02.088	SUCCESS	0	0	0	\N	922
766	2025-10-10 12:26:01.747	2025-10-10 12:26:06.565	SUCCESS	0	0	0	\N	4818
767	2025-10-10 12:27:01.165	2025-10-10 12:27:02.354	SUCCESS	0	0	0	\N	1189
768	2025-10-10 12:27:01.771	2025-10-10 12:27:06.365	SUCCESS	0	0	0	\N	4594
769	2025-10-10 12:28:01.166	2025-10-10 12:28:02.07	SUCCESS	0	0	0	\N	904
770	2025-10-10 12:28:01.793	2025-10-10 12:28:05.865	SUCCESS	0	0	0	\N	4072
771	2025-10-10 12:29:01.165	2025-10-10 12:29:02.051	SUCCESS	0	0	0	\N	886
772	2025-10-10 12:29:01.817	2025-10-10 12:29:05.765	SUCCESS	0	0	0	\N	3948
773	2025-10-10 12:30:01.166	2025-10-10 12:30:04.199	SUCCESS	1	0	1	\N	3033
774	2025-10-10 12:30:01.84	2025-10-10 12:30:11.165	SUCCESS	0	0	0	\N	9325
775	2025-10-10 12:31:01.167	2025-10-10 12:31:02.293	SUCCESS	0	0	0	\N	1126
776	2025-10-10 12:31:01.863	2025-10-10 12:31:05.665	SUCCESS	0	0	0	\N	3802
777	2025-10-10 12:32:01.167	2025-10-10 12:32:02.093	SUCCESS	0	0	0	\N	926
778	2025-10-10 12:32:01.868	2025-10-10 12:32:07.865	SUCCESS	0	0	0	\N	5997
779	2025-10-10 12:33:01.169	2025-10-10 12:33:02.089	SUCCESS	0	0	0	\N	920
780	2025-10-10 12:33:01.887	2025-10-10 12:33:06.565	SUCCESS	0	0	0	\N	4678
781	2025-10-10 12:34:01.17	2025-10-10 12:34:02.063	SUCCESS	0	0	0	\N	893
782	2025-10-10 12:34:01.909	2025-10-10 12:34:06.787	SUCCESS	0	0	0	\N	4878
783	2025-10-10 12:35:01.17	2025-10-10 12:35:02.054	SUCCESS	0	0	0	\N	884
784	2025-10-10 12:35:01.915	2025-10-10 12:35:07.584	SUCCESS	0	0	0	\N	5669
785	2025-10-10 12:36:01.171	2025-10-10 12:36:02.099	SUCCESS	0	0	0	\N	928
786	2025-10-10 12:36:01.938	2025-10-10 12:36:05.165	SUCCESS	0	0	0	\N	3227
787	2025-10-10 12:37:01.17	2025-10-10 12:37:02.126	SUCCESS	0	0	0	\N	956
788	2025-10-10 12:37:01.96	2025-10-10 12:37:05.966	SUCCESS	0	0	0	\N	4006
789	2025-10-10 12:38:01.172	2025-10-10 12:38:02.086	SUCCESS	0	0	0	\N	914
790	2025-10-10 12:38:01.982	2025-10-10 12:38:07.165	SUCCESS	0	0	0	\N	5183
791	2025-10-10 12:39:01.173	2025-10-10 12:39:02.055	SUCCESS	0	0	0	\N	882
792	2025-10-10 12:39:02.004	2025-10-10 12:39:06.665	SUCCESS	0	0	0	\N	4661
793	2025-10-10 12:40:01.173	2025-10-10 12:40:02.054	SUCCESS	0	0	0	\N	881
794	2025-10-10 12:41:01.173	2025-10-10 12:41:02.106	SUCCESS	0	0	0	\N	933
795	2025-10-10 12:42:01.174	2025-10-10 12:42:02.1	SUCCESS	0	0	0	\N	926
796	2025-10-10 12:43:01.173	2025-10-10 12:43:02.082	SUCCESS	0	0	0	\N	909
797	2025-10-10 12:44:01.173	2025-10-10 12:44:02.071	SUCCESS	0	0	0	\N	898
798	2025-10-10 12:45:01.174	2025-10-10 12:45:02.088	SUCCESS	0	0	0	\N	914
799	2025-10-10 12:46:01.175	2025-10-10 12:46:02.098	SUCCESS	0	0	0	\N	923
800	2025-10-10 12:47:01.176	2025-10-10 12:47:02.123	SUCCESS	0	0	0	\N	947
801	2025-10-10 12:48:01.177	2025-10-10 12:48:02.076	SUCCESS	0	0	0	\N	899
802	2025-10-10 12:49:01.178	2025-10-10 12:49:01.878	SUCCESS	0	0	0	\N	700
803	2025-10-10 12:50:01.179	2025-10-10 12:50:02.336	SUCCESS	0	0	0	\N	1157
804	2025-10-10 12:50:32.83	2025-10-10 12:50:40.477	SUCCESS	0	0	0	\N	7647
805	2025-10-10 12:51:01.18	2025-10-10 12:51:02.088	SUCCESS	0	0	0	\N	908
806	2025-10-10 12:51:32.855	2025-10-10 12:51:41.276	SUCCESS	0	0	0	\N	8421
807	2025-10-10 12:52:01.181	2025-10-10 12:52:02.108	SUCCESS	0	0	0	\N	927
808	2025-10-10 12:52:32.87	2025-10-10 12:52:36.7	SUCCESS	0	0	0	\N	3830
809	2025-10-10 12:53:01.182	2025-10-10 12:53:02.07	SUCCESS	0	0	0	\N	888
810	2025-10-10 12:53:32.894	2025-10-10 12:53:37.577	SUCCESS	0	0	0	\N	4683
811	2025-10-10 12:54:01.182	2025-10-10 12:54:02.108	SUCCESS	0	0	0	\N	926
812	2025-10-10 12:54:32.918	2025-10-10 12:54:39.876	SUCCESS	0	0	0	\N	6958
813	2025-10-10 12:55:32.932	2025-10-10 12:55:36.676	SUCCESS	0	0	0	\N	3744
814	2025-10-10 12:55:57.975	2025-10-10 12:55:59.143	SUCCESS	0	0	0	\N	1168
815	2025-10-10 12:56:32.956	2025-10-10 12:56:40.377	SUCCESS	0	0	0	\N	7421
816	2025-10-10 12:56:57.975	2025-10-10 12:56:58.881	SUCCESS	0	0	0	\N	906
817	2025-10-10 12:57:32.98	2025-10-10 12:57:49.576	SUCCESS	1	0	1	\N	16596
818	2025-10-10 12:58:11.998	2025-10-10 12:58:12.681	SUCCESS	0	0	0	\N	683
819	2025-10-10 12:58:33.003	2025-10-10 12:58:37.077	SUCCESS	0	0	0	\N	4074
820	2025-10-10 12:59:11.999	2025-10-10 12:59:12.914	SUCCESS	0	0	0	\N	915
821	2025-10-10 12:59:33.026	2025-10-10 12:59:37.376	SUCCESS	0	0	0	\N	4350
822	2025-10-10 13:00:11.999	2025-10-10 13:00:12.881	SUCCESS	0	0	0	\N	882
823	2025-10-10 13:01:12	2025-10-10 13:01:12.928	SUCCESS	0	0	0	\N	928
824	2025-10-10 13:01:32.241	2025-10-10 13:01:42.803	SUCCESS	0	0	0	\N	10562
825	2025-10-10 13:01:41.128	2025-10-10 13:01:45.946	SUCCESS	0	0	0	\N	4818
826	2025-10-10 13:02:12	2025-10-10 13:02:12.917	SUCCESS	0	0	0	\N	917
827	2025-10-10 13:02:32.255	2025-10-10 13:02:39.603	SUCCESS	0	0	0	\N	7348
828	2025-10-10 13:02:41.154	2025-10-10 13:02:46.347	SUCCESS	0	0	0	\N	5193
829	2025-10-10 13:03:12	2025-10-10 13:03:12.923	SUCCESS	0	0	0	\N	923
830	2025-10-10 13:03:32.282	2025-10-10 13:03:33.113	SUCCESS	0	0	0	\N	831
831	2025-10-10 13:03:41.179	2025-10-10 13:03:45.768	SUCCESS	0	0	0	\N	4589
832	2025-10-10 13:04:12.001	2025-10-10 13:04:12.9	SUCCESS	0	0	0	\N	899
833	2025-10-10 13:04:41.204	2025-10-10 13:04:48.345	SUCCESS	0	0	0	\N	7141
834	2025-10-10 13:05:12.001	2025-10-10 13:05:12.949	SUCCESS	0	0	0	\N	948
835	2025-10-10 13:05:41.227	2025-10-10 13:05:45.047	SUCCESS	0	0	0	\N	3820
836	2025-10-10 13:06:12.002	2025-10-10 13:06:12.922	SUCCESS	0	0	0	\N	920
837	2025-10-10 13:07:12.003	2025-10-10 13:07:12.921	SUCCESS	0	0	0	\N	918
838	2025-10-10 13:08:12.004	2025-10-10 13:08:12.918	SUCCESS	0	0	0	\N	914
839	2025-10-10 13:08:11.975	2025-10-10 13:08:18.468	SUCCESS	0	0	0	\N	6493
840	2025-10-10 13:09:12.004	2025-10-10 13:09:12.959	SUCCESS	0	0	0	\N	955
841	2025-10-10 13:09:12.002	2025-10-10 13:09:22.967	SUCCESS	0	0	0	\N	10965
842	2025-10-10 13:10:12.004	2025-10-10 13:10:12.893	SUCCESS	0	0	0	\N	889
843	2025-10-10 13:10:12.028	2025-10-10 13:10:20.067	SUCCESS	0	0	0	\N	8039
844	2025-10-10 13:11:12.004	2025-10-10 13:11:12.929	SUCCESS	0	0	0	\N	925
845	2025-10-10 13:11:12.055	2025-10-10 13:11:20.167	SUCCESS	0	0	0	\N	8112
846	2025-10-10 13:12:12.005	2025-10-10 13:12:12.903	SUCCESS	0	0	0	\N	898
847	2025-10-10 13:12:12.081	2025-10-10 13:12:20.467	SUCCESS	0	0	0	\N	8386
848	2025-10-10 13:13:12.007	2025-10-10 13:13:13.002	SUCCESS	0	0	0	\N	995
849	2025-10-10 13:13:12.107	2025-10-10 13:13:22.467	SUCCESS	0	0	0	\N	10360
850	2025-10-10 13:14:12.167	2025-10-10 13:14:17.067	SUCCESS	0	0	0	\N	4900
851	2025-10-10 13:15:12.193	2025-10-10 13:15:20.068	SUCCESS	0	0	0	\N	7875
852	2025-10-10 13:16:12.218	2025-10-10 13:16:21.167	SUCCESS	0	0	0	\N	8949
853	2025-10-10 13:17:12.243	2025-10-10 13:17:22.388	SUCCESS	0	0	0	\N	10145
854	2025-10-10 13:18:12.268	2025-10-10 13:18:22.767	SUCCESS	0	0	0	\N	10499
855	2025-10-10 13:19:12.271	2025-10-10 13:19:17.467	SUCCESS	0	0	0	\N	5196
856	2025-10-10 13:20:12.295	2025-10-10 13:20:17.067	SUCCESS	0	0	0	\N	4772
857	2025-10-10 13:31:00.61	2025-10-10 13:31:23.285	SUCCESS	0	0	0	\N	22675
858	2025-10-10 13:32:00.633	2025-10-10 13:32:14.487	SUCCESS	0	0	0	\N	13854
859	2025-10-10 13:33:00.657	2025-10-10 13:33:12.106	SUCCESS	0	0	0	\N	11449
860	2025-10-10 13:34:00.681	2025-10-10 13:34:05.085	SUCCESS	0	0	0	\N	4404
861	2025-10-10 13:35:00.705	2025-10-10 13:35:06.285	SUCCESS	0	0	0	\N	5580
862	2025-10-10 13:36:00.729	2025-10-10 13:36:05.886	SUCCESS	0	0	0	\N	5157
863	2025-10-10 13:37:00.754	2025-10-10 13:37:06.785	SUCCESS	0	0	0	\N	6031
864	2025-10-10 13:38:00.777	2025-10-10 13:38:07.084	SUCCESS	0	0	0	\N	6307
865	2025-10-10 13:39:00.984	2025-10-10 13:39:09.484	SUCCESS	0	0	0	\N	8500
866	2025-10-10 13:40:01.006	2025-10-10 13:40:09.285	SUCCESS	0	0	0	\N	8279
867	2025-10-10 13:41:01.029	2025-10-10 13:41:09.784	SUCCESS	0	0	0	\N	8755
870	2025-10-10 13:44:01.098	2025-10-10 13:44:08.885	SUCCESS	0	0	0	\N	7787
1401	2025-10-11 09:04:02.677	2025-10-11 09:04:03.571	SUCCESS	0	0	0	\N	894
1459	2025-10-11 09:53:43.457	2025-10-11 09:53:44.35	SUCCESS	0	0	0	\N	893
1473	2025-10-11 10:05:08.405	2025-10-11 10:05:09.332	SUCCESS	0	0	0	\N	927
1485	2025-10-11 10:16:12.542	2025-10-11 10:16:17.709	SUCCESS	0	0	0	\N	5167
1487	2025-10-11 10:17:12.567	2025-10-11 10:17:17.208	SUCCESS	0	0	0	\N	4641
1489	2025-10-11 10:18:12.592	2025-10-11 10:18:19.108	SUCCESS	0	0	0	\N	6516
1491	2025-10-11 10:19:12.604	2025-10-11 10:19:18.809	SUCCESS	0	0	0	\N	6205
1493	2025-10-11 10:20:12.628	2025-10-11 10:20:17.509	SUCCESS	0	0	0	\N	4881
1502	2025-10-11 10:24:19.722	2025-10-11 10:24:20.663	SUCCESS	0	0	0	\N	941
1549	2025-10-11 12:27:45.155	2025-10-11 12:27:46.059	SUCCESS	0	0	0	\N	904
1578	2025-10-11 12:46:14.689	2025-10-11 12:46:15.877	SUCCESS	0	0	0	\N	1188
1676	2025-10-11 15:02:34.786	2025-10-11 15:02:35.662	SUCCESS	0	0	0	\N	876
1689	2025-10-11 15:14:34.792	2025-10-11 15:14:35.701	SUCCESS	0	0	0	\N	909
1727	2025-10-11 16:17:21.341	2025-10-11 16:17:22.471	SUCCESS	0	0	0	\N	1130
1748	2025-10-11 16:27:29.231	2025-10-11 16:27:30.147	SUCCESS	0	0	0	\N	916
1767	2025-10-11 16:36:42.707	2025-10-11 16:36:43.367	SUCCESS	0	0	0	\N	660
1791	2025-10-11 16:48:42.714	2025-10-11 16:48:43.644	SUCCESS	0	0	0	\N	930
1810	2025-10-11 16:59:15.774	2025-10-11 16:59:16.433	SUCCESS	0	0	0	\N	659
1828	2025-10-11 17:07:15.778	2025-10-11 17:07:16.463	SUCCESS	0	0	0	\N	685
1853	2025-10-11 17:19:56.43	2025-10-11 17:19:57.567	SUCCESS	0	0	0	\N	1137
1869	2025-10-11 17:28:16.588	2025-10-11 17:28:19.517	SUCCESS	1	0	1	\N	2929
1887	2025-10-11 17:38:35.223	2025-10-11 17:38:39.371	SUCCESS	0	0	0	\N	4148
1889	2025-10-11 17:39:35.242	2025-10-11 17:39:44.471	SUCCESS	0	0	0	\N	9229
1891	2025-10-11 17:40:35.261	2025-10-11 17:40:40.97	SUCCESS	0	0	0	\N	5709
1893	2025-10-11 17:41:35.28	2025-10-11 17:41:39.371	SUCCESS	0	0	0	\N	4091
1895	2025-10-11 17:42:35.289	2025-10-11 17:42:40.572	SUCCESS	0	0	0	\N	5283
1905	2025-10-11 17:51:16.601	2025-10-11 17:51:19.29	SUCCESS	1	0	1	\N	2689
1908	2025-10-11 17:54:01.792	2025-10-11 17:54:26.83	SUCCESS	1	0	0	\N	25038
1910	2025-10-11 17:55:01.817	2025-10-11 17:55:09.33	SUCCESS	0	0	0	\N	7513
1923	2025-10-11 18:01:16.606	2025-10-11 18:01:17.298	SUCCESS	0	0	0	\N	692
1937	2025-10-11 18:08:16.609	2025-10-11 18:08:17.285	SUCCESS	0	0	0	\N	676
1957	2025-10-11 18:18:16.629	2025-10-11 18:18:17.285	SUCCESS	0	0	0	\N	656
1959	2025-10-11 18:19:16.63	2025-10-11 18:19:17.315	SUCCESS	0	0	0	\N	685
1975	2025-10-11 18:26:16.634	2025-10-11 18:26:17.752	SUCCESS	0	0	0	\N	1118
1990	2025-10-11 18:33:16.635	2025-10-11 18:33:17.551	SUCCESS	0	0	0	\N	916
2004	2025-10-11 18:40:16.643	2025-10-11 18:40:17.618	SUCCESS	0	0	0	\N	975
2022	2025-10-11 18:48:48.823	2025-10-11 18:48:49.741	SUCCESS	0	0	0	\N	918
2039	2025-10-11 18:57:30.595	2025-10-11 18:57:31.516	SUCCESS	0	0	0	\N	921
2057	2025-10-11 19:04:30.602	2025-10-11 19:04:33.835	SUCCESS	1	0	1	\N	3233
2079	2025-10-11 19:12:45.19	2025-10-11 19:12:46.231	SUCCESS	0	0	0	\N	1041
2091	2025-10-11 19:17:45.193	2025-10-11 19:17:46.163	SUCCESS	0	0	0	\N	970
2102	2025-10-11 19:23:10.078	2025-10-11 19:23:11.406	SUCCESS	0	0	0	\N	1328
2110	2025-10-11 19:27:10.082	2025-10-11 19:27:11.736	SUCCESS	0	0	0	\N	1654
2120	2025-10-11 19:32:10.084	2025-10-11 19:32:11.307	SUCCESS	0	0	0	\N	1223
2127	2025-10-11 19:35:36.926	2025-10-11 19:35:42.405	SUCCESS	0	0	0	\N	5479
2129	2025-10-11 19:36:36.953	2025-10-11 19:36:41.605	SUCCESS	0	0	0	\N	4652
2130	2025-10-11 19:36:55.285	2025-10-11 19:37:15.084	SUCCESS	0	0	0	\N	19799
2135	2025-10-11 19:39:10.086	2025-10-11 19:39:11.34	SUCCESS	0	0	0	\N	1254
2142	2025-10-11 19:43:03.818	2025-10-11 19:43:13.567	SUCCESS	0	0	0	\N	9749
2143	2025-10-11 19:43:45.454	2025-10-11 19:43:46.707	SUCCESS	0	0	0	\N	1253
2148	2025-10-11 19:46:41.419	2025-10-11 19:46:42.687	SUCCESS	0	0	0	\N	1268
2149	2025-10-11 19:47:03.883	2025-10-11 19:47:15.796	SUCCESS	0	0	0	\N	11913
2153	2025-10-11 19:49:03.927	2025-10-11 19:49:13.274	SUCCESS	0	0	0	\N	9347
2157	2025-10-11 19:51:12.003	2025-10-11 19:51:13.027	SUCCESS	0	0	0	\N	1024
2158	2025-10-11 19:51:32.294	2025-10-11 19:51:39.644	SUCCESS	0	0	0	\N	7350
2165	2025-10-11 19:55:12.004	2025-10-11 19:55:13.215	SUCCESS	0	0	0	\N	1211
2169	2025-10-11 19:57:12.007	2025-10-11 19:57:13.048	SUCCESS	0	0	0	\N	1041
2175	2025-10-11 20:00:12.008	2025-10-11 20:00:13.241	SUCCESS	0	0	0	\N	1233
2178	2025-10-11 20:01:32.558	2025-10-11 20:01:37.744	SUCCESS	0	0	0	\N	5186
2180	2025-10-11 20:02:32.582	2025-10-11 20:02:38.544	SUCCESS	0	0	0	\N	5962
2181	2025-10-11 20:03:12.009	2025-10-11 20:03:13.252	SUCCESS	0	0	0	\N	1243
2183	2025-10-11 20:04:12.009	2025-10-11 20:04:13.237	SUCCESS	0	0	0	\N	1228
2186	2025-10-11 20:05:32.636	2025-10-11 20:05:37.646	SUCCESS	0	0	0	\N	5010
2187	2025-10-11 20:06:12.011	2025-10-11 20:06:13.245	SUCCESS	0	0	0	\N	1234
2188	2025-10-11 20:06:32.661	2025-10-11 20:06:36.344	SUCCESS	0	0	0	\N	3683
2190	2025-10-11 20:07:32.684	2025-10-11 20:07:38.145	SUCCESS	0	0	0	\N	5461
2192	2025-10-11 20:08:32.686	2025-10-11 20:08:38.845	SUCCESS	0	0	0	\N	6159
2193	2025-10-11 20:09:12.015	2025-10-11 20:09:13.278	SUCCESS	0	0	0	\N	1263
2194	2025-10-11 20:09:32.711	2025-10-11 20:09:33.708	SUCCESS	0	0	0	\N	997
2195	2025-10-11 20:15:11.753	2025-10-11 20:15:20.224	SUCCESS	0	0	0	\N	8471
2197	2025-10-11 20:17:11.792	2025-10-11 20:17:19.326	SUCCESS	0	0	0	\N	7534
2199	2025-10-11 20:19:11.845	2025-10-11 20:19:17.103	SUCCESS	0	0	0	\N	5258
2200	2025-10-11 20:20:11.864	2025-10-11 20:20:20.503	SUCCESS	0	0	0	\N	8639
2201	2025-10-11 20:21:11.876	2025-10-11 20:21:20.903	SUCCESS	0	0	0	\N	9027
2202	2025-10-11 20:22:11.902	2025-10-11 20:22:18.203	SUCCESS	0	0	0	\N	6301
2205	2025-10-11 20:25:11.975	2025-10-11 20:25:17.603	SUCCESS	0	0	0	\N	5628
2207	2025-10-11 20:27:12.025	2025-10-11 20:27:17.003	SUCCESS	0	0	0	\N	4978
2208	2025-10-11 20:28:12.036	2025-10-11 20:28:21.103	SUCCESS	0	0	0	\N	9067
2213	2025-10-11 20:32:05.046	2025-10-11 20:32:06.266	SUCCESS	0	0	0	\N	1220
2214	2025-10-11 20:32:19.304	2025-10-11 20:32:30.203	SUCCESS	0	0	0	\N	10899
2215	2025-10-11 20:32:56.884	2025-10-11 20:33:09.785	SUCCESS	0	0	0	\N	12901
2217	2025-10-11 20:33:19.307	2025-10-11 20:33:24.503	SUCCESS	0	0	0	\N	5196
2218	2025-10-11 20:33:56.184	2025-10-11 20:34:00.484	SUCCESS	0	0	0	\N	4300
2219	2025-10-11 20:34:05.048	2025-10-11 20:34:06.273	SUCCESS	0	0	0	\N	1225
2220	2025-10-11 20:34:19.307	2025-10-11 20:34:29.903	SUCCESS	0	0	0	\N	10596
2221	2025-10-11 20:34:56.185	2025-10-11 20:35:00.205	SUCCESS	0	0	0	\N	4020
2223	2025-10-11 20:35:19.31	2025-10-11 20:35:27.826	SUCCESS	0	0	0	\N	8516
868	2025-10-10 13:42:01.052	2025-10-10 13:42:07.685	SUCCESS	0	0	0	\N	6633
869	2025-10-10 13:43:01.075	2025-10-10 13:43:07.887	SUCCESS	0	0	0	\N	6812
871	2025-10-10 14:00:23.61	2025-10-10 14:00:41.445	SUCCESS	0	0	0	\N	17835
872	2025-10-10 14:01:23.638	2025-10-10 14:01:33.545	SUCCESS	0	0	0	\N	9907
873	2025-10-10 14:02:23.656	2025-10-10 14:02:29.544	SUCCESS	0	0	0	\N	5888
874	2025-10-10 14:03:23.683	2025-10-10 14:03:31.644	SUCCESS	0	0	0	\N	7961
875	2025-10-10 14:04:23.71	2025-10-10 14:04:31.644	SUCCESS	0	0	0	\N	7934
876	2025-10-10 14:05:23.737	2025-10-10 14:05:32.644	SUCCESS	0	0	0	\N	8907
877	2025-10-10 14:06:23.764	2025-10-10 14:06:33.344	SUCCESS	0	0	0	\N	9580
878	2025-10-10 14:07:23.787	2025-10-10 14:07:31.444	SUCCESS	0	0	0	\N	7657
879	2025-10-10 14:08:23.812	2025-10-10 14:08:28.645	SUCCESS	0	0	0	\N	4833
880	2025-10-10 14:09:23.837	2025-10-10 14:09:28.745	SUCCESS	0	0	0	\N	4908
881	2025-10-10 14:10:23.848	2025-10-10 14:10:33.446	ERROR	0	0	0	Connection terminated due to connection timeout	9598
882	2025-10-10 14:11:23.874	2025-10-10 14:11:28.344	SUCCESS	0	0	0	\N	4470
883	2025-10-10 14:12:23.899	2025-10-10 14:12:34.244	SUCCESS	0	0	0	\N	10345
884	2025-10-10 14:13:23.924	2025-10-10 14:13:29.545	SUCCESS	0	0	0	\N	5621
885	2025-10-10 14:27:11.171	2025-10-10 14:27:51.448	SUCCESS	3	0	3	\N	40277
886	2025-10-10 14:28:11.181	2025-10-10 14:28:18.747	SUCCESS	0	0	0	\N	7566
887	2025-10-10 14:29:11.202	2025-10-10 14:29:21.948	SUCCESS	0	0	0	\N	10746
888	2025-10-10 14:30:11.228	2025-10-10 14:30:19.45	SUCCESS	0	0	0	\N	8222
889	2025-10-10 14:31:11.238	2025-10-10 14:31:16.448	SUCCESS	0	0	0	\N	5210
890	2025-10-10 14:32:11.264	2025-10-10 14:32:20.049	SUCCESS	0	0	0	\N	8785
891	2025-10-10 14:33:11.293	2025-10-10 14:33:16.447	SUCCESS	0	0	0	\N	5154
892	2025-10-10 14:34:11.319	2025-10-10 14:34:20.048	SUCCESS	0	0	0	\N	8729
893	2025-10-10 14:35:11.344	2025-10-10 14:35:15.448	SUCCESS	0	0	0	\N	4104
894	2025-10-10 14:36:11.369	2025-10-10 14:36:16.547	SUCCESS	0	0	0	\N	5178
895	2025-10-10 14:37:11.392	2025-10-10 14:37:14.748	SUCCESS	0	0	0	\N	3356
896	2025-10-10 14:38:11.416	2025-10-10 14:38:15.848	SUCCESS	0	0	0	\N	4432
897	2025-10-10 14:39:11.432	2025-10-10 14:39:15.047	SUCCESS	0	0	0	\N	3615
898	2025-10-10 14:40:11.455	2025-10-10 14:40:16.249	SUCCESS	0	0	0	\N	4794
899	2025-10-10 14:41:11.479	2025-10-10 14:41:15.148	SUCCESS	0	0	0	\N	3669
900	2025-10-10 14:42:11.501	2025-10-10 14:42:14.447	SUCCESS	0	0	0	\N	2946
901	2025-10-10 14:43:11.525	2025-10-10 14:43:19.447	SUCCESS	0	0	0	\N	7922
902	2025-10-10 14:44:11.546	2025-10-10 14:44:15.848	SUCCESS	0	0	0	\N	4302
903	2025-10-10 14:45:11.557	2025-10-10 14:45:15.047	SUCCESS	0	0	0	\N	3490
904	2025-10-10 14:46:11.579	2025-10-10 14:46:16.047	SUCCESS	0	0	0	\N	4468
905	2025-10-10 14:59:13.412	2025-10-10 14:59:19.288	SUCCESS	0	0	0	\N	5876
906	2025-10-10 15:00:13.442	2025-10-10 15:00:19.088	SUCCESS	0	0	0	\N	5646
907	2025-10-10 15:01:13.453	2025-10-10 15:01:19.088	SUCCESS	0	0	0	\N	5635
908	2025-10-10 15:02:13.464	2025-10-10 15:02:18.588	SUCCESS	0	0	0	\N	5124
909	2025-10-10 15:03:13.489	2025-10-10 15:03:32.79	SUCCESS	1	0	1	\N	19301
910	2025-10-10 15:04:13.512	2025-10-10 15:04:19.488	SUCCESS	0	0	0	\N	5976
911	2025-10-10 15:05:13.536	2025-10-10 15:05:29.988	SUCCESS	1	0	1	\N	16452
912	2025-10-10 15:06:13.558	2025-10-10 15:06:18.788	SUCCESS	0	0	0	\N	5230
913	2025-10-10 15:07:13.581	2025-10-10 15:07:19.388	SUCCESS	0	0	0	\N	5807
914	2025-10-10 15:08:13.605	2025-10-10 15:08:19.888	SUCCESS	0	0	0	\N	6283
915	2025-10-10 15:09:13.628	2025-10-10 15:09:18.51	SUCCESS	0	0	0	\N	4882
916	2025-10-10 15:10:13.651	2025-10-10 15:10:20.888	SUCCESS	0	0	0	\N	7237
917	2025-10-10 15:11:13.674	2025-10-10 15:11:17.188	SUCCESS	0	0	0	\N	3514
918	2025-10-10 15:35:06.293	2025-10-10 15:35:11.439	SUCCESS	0	0	0	\N	5146
919	2025-10-10 15:36:15.94	2025-10-10 15:36:28.839	ERROR	0	0	0	Connection terminated due to connection timeout	12899
920	2025-10-10 15:37:45.308	2025-10-10 15:37:46.277	SUCCESS	0	0	0	\N	969
921	2025-10-10 15:38:18.547	2025-10-10 15:38:22.338	SUCCESS	0	0	0	\N	3791
922	2025-10-10 15:38:45.309	2025-10-10 15:38:46.205	SUCCESS	0	0	0	\N	896
923	2025-10-10 15:39:18.557	2025-10-10 15:39:26.838	SUCCESS	0	0	0	\N	8281
924	2025-10-10 15:39:45.31	2025-10-10 15:39:46.211	SUCCESS	0	0	0	\N	901
925	2025-10-10 15:40:18.584	2025-10-10 15:40:21.838	SUCCESS	0	0	0	\N	3254
926	2025-10-10 15:40:45.311	2025-10-10 15:40:46.236	SUCCESS	0	0	0	\N	925
927	2025-10-10 15:41:18.611	2025-10-10 15:41:22.538	SUCCESS	0	0	0	\N	3927
928	2025-10-10 15:41:45.312	2025-10-10 15:41:46.21	SUCCESS	0	0	0	\N	898
929	2025-10-10 15:42:18.637	2025-10-10 15:42:21.438	SUCCESS	0	0	0	\N	2801
930	2025-10-10 15:42:45.313	2025-10-10 15:42:46.288	SUCCESS	0	0	0	\N	975
931	2025-10-10 15:43:18.643	2025-10-10 15:43:21.338	SUCCESS	0	0	0	\N	2695
932	2025-10-10 15:43:45.314	2025-10-10 15:43:46.45	SUCCESS	0	0	0	\N	1136
933	2025-10-10 15:44:18.669	2025-10-10 15:44:22.538	SUCCESS	0	0	0	\N	3869
934	2025-10-10 15:44:45.315	2025-10-10 15:44:46.227	SUCCESS	0	0	0	\N	912
935	2025-10-10 15:45:18.694	2025-10-10 15:45:22.038	SUCCESS	0	0	0	\N	3344
936	2025-10-10 15:45:45.315	2025-10-10 15:45:46.241	SUCCESS	0	0	0	\N	926
937	2025-10-10 15:46:18.72	2025-10-10 15:46:22.939	SUCCESS	0	0	0	\N	4219
938	2025-10-10 15:46:45.315	2025-10-10 15:46:46.342	SUCCESS	0	0	0	\N	1027
939	2025-10-10 15:47:18.745	2025-10-10 15:47:22.938	SUCCESS	0	0	0	\N	4193
940	2025-10-10 15:48:18.77	2025-10-10 15:48:21.638	SUCCESS	0	0	0	\N	2868
941	2025-10-10 15:48:27.436	2025-10-10 15:48:28.639	SUCCESS	0	0	0	\N	1203
942	2025-10-10 15:49:18.783	2025-10-10 15:49:21.638	SUCCESS	0	0	0	\N	2855
943	2025-10-10 15:49:27.436	2025-10-10 15:49:28.593	SUCCESS	0	0	0	\N	1157
944	2025-10-10 15:50:18.807	2025-10-10 15:50:21.438	SUCCESS	0	0	0	\N	2631
945	2025-10-10 15:50:27.435	2025-10-10 15:50:28.411	SUCCESS	0	0	0	\N	976
946	2025-10-10 15:51:18.813	2025-10-10 15:51:21.838	SUCCESS	0	0	0	\N	3025
947	2025-10-10 15:51:27.435	2025-10-10 15:51:28.399	SUCCESS	0	0	0	\N	964
948	2025-10-10 15:52:18.838	2025-10-10 15:52:22.44	SUCCESS	0	0	0	\N	3602
949	2025-10-10 15:52:27.435	2025-10-10 15:52:28.574	SUCCESS	0	0	0	\N	1139
950	2025-10-10 15:53:18.862	2025-10-10 15:53:21.138	SUCCESS	0	0	0	\N	2276
951	2025-10-10 15:53:27.435	2025-10-10 15:53:28.367	SUCCESS	0	0	0	\N	932
952	2025-10-10 15:54:18.885	2025-10-10 15:54:20.938	SUCCESS	0	0	0	\N	2053
953	2025-10-10 15:54:27.435	2025-10-10 15:54:28.602	SUCCESS	0	0	0	\N	1167
954	2025-10-10 15:55:19.039	2025-10-10 15:55:23.438	SUCCESS	0	0	0	\N	4399
955	2025-10-10 15:55:27.435	2025-10-10 15:55:28.555	SUCCESS	0	0	0	\N	1120
956	2025-10-10 15:56:19.061	2025-10-10 15:56:21.238	SUCCESS	0	0	0	\N	2177
957	2025-10-10 15:56:27.435	2025-10-10 15:56:28.426	SUCCESS	0	0	0	\N	991
958	2025-10-10 15:57:19.084	2025-10-10 15:57:22.838	SUCCESS	0	0	0	\N	3754
959	2025-10-10 15:57:27.436	2025-10-10 15:57:28.636	SUCCESS	0	0	0	\N	1200
960	2025-10-10 15:58:27.437	2025-10-10 15:58:28.575	SUCCESS	0	0	0	\N	1138
961	2025-10-10 16:04:52.518	2025-10-10 16:05:02.015	SUCCESS	0	0	0	\N	9497
962	2025-10-10 16:06:52.932	2025-10-10 16:06:59.514	SUCCESS	0	0	0	\N	6582
963	2025-10-10 16:07:52.938	2025-10-10 16:08:01.915	SUCCESS	0	0	0	\N	8977
964	2025-10-10 16:08:52.965	2025-10-10 16:09:01.615	SUCCESS	0	0	0	\N	8650
965	2025-10-10 16:09:52.977	2025-10-10 16:10:00.615	SUCCESS	0	0	0	\N	7638
966	2025-10-10 16:10:53.003	2025-10-10 16:11:09.514	ERROR	0	0	0	Connection terminated due to connection timeout	16511
967	2025-10-10 16:11:53.028	2025-10-10 16:12:02.015	SUCCESS	0	0	0	\N	8987
968	2025-10-10 16:12:53.053	2025-10-10 16:13:02.215	SUCCESS	0	0	0	\N	9162
969	2025-10-10 16:13:53.077	2025-10-10 16:13:58.114	SUCCESS	0	0	0	\N	5037
970	2025-10-10 16:14:53.101	2025-10-10 16:14:56.314	SUCCESS	0	0	0	\N	3213
971	2025-10-10 16:15:53.126	2025-10-10 16:15:56.714	SUCCESS	0	0	0	\N	3588
972	2025-10-10 16:16:53.137	2025-10-10 16:16:57.714	SUCCESS	0	0	0	\N	4577
973	2025-10-10 16:17:53.161	2025-10-10 16:18:00.915	SUCCESS	0	0	0	\N	7754
974	2025-10-10 16:18:53.173	2025-10-10 16:18:57.814	SUCCESS	0	0	0	\N	4641
975	2025-10-10 16:19:53.186	2025-10-10 16:19:57.715	SUCCESS	0	0	0	\N	4529
976	2025-10-10 16:20:53.193	2025-10-10 16:20:56.414	SUCCESS	0	0	0	\N	3221
977	2025-10-10 16:21:53.217	2025-10-10 16:22:00.215	SUCCESS	0	0	0	\N	6998
978	2025-10-10 16:22:53.241	2025-10-10 16:23:00.714	SUCCESS	0	0	0	\N	7473
979	2025-10-10 16:23:53.264	2025-10-10 16:23:56.114	SUCCESS	0	0	0	\N	2850
980	2025-10-10 16:28:29.619	2025-10-10 16:28:30.351	SUCCESS	0	0	0	\N	732
981	2025-10-10 16:29:29.619	2025-10-10 16:29:30.85	SUCCESS	0	0	0	\N	1231
982	2025-10-10 16:30:29.619	2025-10-10 16:30:30.545	SUCCESS	0	0	0	\N	926
983	2025-10-10 16:31:29.62	2025-10-10 16:31:30.534	SUCCESS	0	0	0	\N	914
984	2025-10-10 16:32:29.619	2025-10-10 16:32:30.816	SUCCESS	0	0	0	\N	1197
985	2025-10-10 16:33:29.619	2025-10-10 16:33:30.518	SUCCESS	0	0	0	\N	899
986	2025-10-10 16:34:29.62	2025-10-10 16:34:30.531	SUCCESS	0	0	0	\N	911
987	2025-10-10 16:35:29.62	2025-10-10 16:35:30.799	SUCCESS	0	0	0	\N	1179
988	2025-10-10 16:36:29.621	2025-10-10 16:36:30.531	SUCCESS	0	0	0	\N	910
989	2025-10-10 16:37:29.622	2025-10-10 16:37:30.534	SUCCESS	0	0	0	\N	912
990	2025-10-10 16:38:29.624	2025-10-10 16:38:30.815	SUCCESS	0	0	0	\N	1191
991	2025-10-10 16:39:29.624	2025-10-10 16:39:30.58	SUCCESS	0	0	0	\N	956
992	2025-10-10 16:45:49.927	2025-10-10 16:45:54.878	SUCCESS	0	0	0	\N	4951
993	2025-10-10 16:46:10.182	2025-10-10 16:46:10.839	SUCCESS	0	0	0	\N	657
994	2025-10-10 16:46:49.927	2025-10-10 16:47:01.061	SUCCESS	0	0	0	\N	11134
995	2025-10-10 16:47:10.182	2025-10-10 16:47:11.125	SUCCESS	0	0	0	\N	943
996	2025-10-10 16:47:48.71	2025-10-10 16:47:59.36	SUCCESS	0	0	0	\N	10650
997	2025-10-10 16:47:49.952	2025-10-10 16:48:01.361	SUCCESS	0	0	0	\N	11409
998	2025-10-10 16:48:10.182	2025-10-10 16:48:11.07	SUCCESS	0	0	0	\N	888
999	2025-10-10 16:48:48.726	2025-10-10 16:48:58.759	SUCCESS	0	0	0	\N	10033
1000	2025-10-10 16:48:49.976	2025-10-10 16:49:04.662	ERROR	0	0	0	Connection terminated due to connection timeout	14686
1001	2025-10-10 16:49:10.184	2025-10-10 16:49:11.285	SUCCESS	0	0	0	\N	1101
1002	2025-10-10 16:49:48.753	2025-10-10 16:49:58.959	SUCCESS	0	0	0	\N	10206
1003	2025-10-10 16:49:50	2025-10-10 16:50:03.561	ERROR	0	0	0	Connection terminated due to connection timeout	13561
1004	2025-10-10 16:50:10.185	2025-10-10 16:50:11.12	SUCCESS	0	0	0	\N	935
1005	2025-10-10 16:50:50.024	2025-10-10 16:50:55.162	SUCCESS	0	0	0	\N	5138
1006	2025-10-10 16:51:10.185	2025-10-10 16:51:11.07	SUCCESS	0	0	0	\N	885
1007	2025-10-10 16:51:50.048	2025-10-10 16:51:50.922	SUCCESS	0	0	0	\N	874
1008	2025-10-10 16:51:48.802	2025-10-10 16:51:57.159	SUCCESS	0	0	0	\N	8357
1009	2025-10-10 16:52:10.186	2025-10-10 16:52:11.094	SUCCESS	0	0	0	\N	908
1010	2025-10-10 16:52:48.827	2025-10-10 16:52:59.759	ERROR	0	0	0	Connection terminated due to connection timeout	10932
1011	2025-10-10 16:53:10.193	2025-10-10 16:53:11.089	SUCCESS	0	0	0	\N	896
1012	2025-10-10 16:53:48.851	2025-10-10 16:53:52.659	SUCCESS	0	0	0	\N	3808
1013	2025-10-10 16:54:10.193	2025-10-10 16:54:11.076	SUCCESS	0	0	0	\N	883
1014	2025-10-10 16:54:48.877	2025-10-10 16:54:55.359	SUCCESS	0	0	0	\N	6482
1015	2025-10-10 16:55:10.194	2025-10-10 16:55:11.096	SUCCESS	0	0	0	\N	902
1016	2025-10-10 16:55:48.901	2025-10-10 16:55:54.559	SUCCESS	0	0	0	\N	5658
1017	2025-10-10 16:56:48.925	2025-10-10 16:56:54.26	SUCCESS	0	0	0	\N	5335
1018	2025-10-10 16:57:48.949	2025-10-10 16:57:53.66	SUCCESS	0	0	0	\N	4711
1019	2025-10-10 16:58:48.972	2025-10-10 16:58:58.46	SUCCESS	0	0	0	\N	9488
1020	2025-10-10 16:59:48.995	\N	RUNNING	0	0	0	\N	\N
1021	2025-10-10 17:00:49.018	2025-10-10 17:01:00.159	SUCCESS	0	0	0	\N	11141
1022	2025-10-10 17:01:49.042	2025-10-10 17:01:56.66	SUCCESS	0	0	0	\N	7618
1023	2025-10-10 17:02:49.064	2025-10-10 17:02:51.687	SUCCESS	0	0	0	\N	2623
1024	2025-10-10 17:05:35.991	2025-10-10 17:05:46.851	SUCCESS	0	0	0	\N	10860
1025	2025-10-10 17:06:36.019	2025-10-10 17:06:42.05	SUCCESS	0	0	0	\N	6031
1026	2025-10-10 17:07:36.046	2025-10-10 17:07:41.85	SUCCESS	0	0	0	\N	5804
1027	2025-10-10 17:08:36.073	2025-10-10 17:08:43.75	SUCCESS	0	0	0	\N	7677
1028	2025-10-10 17:09:36.101	2025-10-10 17:09:43.649	SUCCESS	0	0	0	\N	7548
1029	2025-10-10 17:10:36.118	2025-10-10 17:10:45.45	SUCCESS	0	0	0	\N	9332
1030	2025-10-10 17:11:36.145	2025-10-10 17:11:45.449	SUCCESS	0	0	0	\N	9304
1031	2025-10-10 17:12:36.15	2025-10-10 17:12:45.849	SUCCESS	0	0	0	\N	9699
1032	2025-10-10 17:13:36.152	2025-10-10 17:14:05.849	SUCCESS	1	0	1	\N	29697
1033	2025-10-10 17:14:36.169	2025-10-10 17:14:57.249	SUCCESS	1	0	1	\N	21080
1034	2025-10-10 17:15:36.192	2025-10-10 17:15:56.249	SUCCESS	1	0	1	\N	20057
1035	2025-10-10 17:16:36.214	2025-10-10 17:16:54.049	SUCCESS	1	0	1	\N	17835
1036	2025-10-10 17:17:36.238	2025-10-10 17:17:49.649	SUCCESS	1	0	0	\N	13411
1037	2025-10-10 17:18:36.263	2025-10-10 17:18:52.549	SUCCESS	1	0	1	\N	16286
1038	2025-10-10 17:19:36.287	2025-10-10 17:20:00.449	SUCCESS	1	0	1	\N	24162
1039	2025-10-10 17:20:36.31	2025-10-10 17:20:42.599	SUCCESS	1	0	1	\N	6289
1040	2025-10-10 18:13:56.687	2025-10-10 18:14:27.506	SUCCESS	3	0	3	\N	30819
1041	2025-10-10 18:14:56.707	2025-10-10 18:15:03.706	SUCCESS	0	0	0	\N	6999
1042	2025-10-10 18:15:56.727	2025-10-10 18:16:06.407	SUCCESS	0	0	0	\N	9680
1043	2025-10-10 18:16:56.751	2025-10-10 18:17:02.505	SUCCESS	0	0	0	\N	5754
1044	2025-10-10 18:17:56.772	2025-10-10 18:18:00.906	SUCCESS	0	0	0	\N	4134
1045	2025-10-10 18:18:56.794	2025-10-10 18:19:01.606	SUCCESS	0	0	0	\N	4812
1046	2025-10-10 18:19:56.817	2025-10-10 18:20:04.906	SUCCESS	0	0	0	\N	8089
1047	2025-10-10 18:20:56.84	2025-10-10 18:21:02.008	SUCCESS	0	0	0	\N	5168
1048	2025-10-10 18:21:56.862	2025-10-10 18:22:16.906	SUCCESS	1	0	1	\N	20044
1049	2025-10-10 18:22:56.884	2025-10-10 18:23:03.309	SUCCESS	0	0	0	\N	6425
1050	2025-10-10 18:23:56.905	2025-10-10 18:24:27.728	SUCCESS	1	0	1	\N	30823
1051	2025-10-10 18:24:56.925	2025-10-10 18:25:01.405	SUCCESS	0	0	0	\N	4480
1052	2025-10-10 18:25:56.947	2025-10-10 18:26:01.105	SUCCESS	0	0	0	\N	4158
1053	2025-10-10 18:58:18.005	2025-10-10 18:58:53.029	SUCCESS	2	0	2	\N	35024
1054	2025-10-10 18:59:18.019	2025-10-10 18:59:23.927	SUCCESS	0	0	0	\N	5908
1055	2025-10-10 19:00:18.023	2025-10-10 19:00:23.527	SUCCESS	0	0	0	\N	5504
1056	2025-10-10 19:01:18.048	2025-10-10 19:01:23.028	SUCCESS	0	0	0	\N	4980
1057	2025-10-10 19:02:18.051	2025-10-10 19:02:28.328	SUCCESS	0	0	0	\N	10277
1058	2025-10-10 19:03:18.076	2025-10-10 19:03:24.227	SUCCESS	0	0	0	\N	6151
1059	2025-10-10 19:04:18.1	2025-10-10 19:04:22.328	SUCCESS	0	0	0	\N	4228
1060	2025-10-10 19:05:18.124	2025-10-10 19:05:22.827	SUCCESS	0	0	0	\N	4703
1061	2025-10-10 19:06:18.143	2025-10-10 19:06:23.827	SUCCESS	0	0	0	\N	5684
1062	2025-10-10 19:07:18.167	2025-10-10 19:07:23.128	SUCCESS	0	0	0	\N	4961
1063	2025-10-10 19:08:18.19	2025-10-10 19:08:23.228	SUCCESS	0	0	0	\N	5038
1064	2025-10-10 19:09:18.214	2025-10-10 19:09:23.927	SUCCESS	0	0	0	\N	5713
1065	2025-10-10 19:10:18.235	2025-10-10 19:10:23.627	SUCCESS	0	0	0	\N	5392
1066	2025-10-10 19:11:18.259	2025-10-10 19:11:29.028	SUCCESS	0	0	0	\N	10769
1067	2025-10-10 19:12:18.282	2025-10-10 19:12:23.328	SUCCESS	0	0	0	\N	5046
1068	2025-10-10 19:13:18.304	2025-10-10 19:13:21.269	SUCCESS	0	0	0	\N	2965
1069	2025-10-10 19:41:28.565	2025-10-10 19:41:35.2	SUCCESS	0	0	0	\N	6635
1070	2025-10-10 19:42:28.565	2025-10-10 19:42:32.014	SUCCESS	0	0	0	\N	3449
1071	2025-10-10 19:43:28.592	2025-10-10 19:43:34.799	SUCCESS	0	0	0	\N	6207
1072	2025-10-10 19:44:28.6	2025-10-10 19:44:37.698	SUCCESS	0	0	0	\N	9098
1073	2025-10-10 19:47:33.055	2025-10-10 19:47:40.598	SUCCESS	0	0	0	\N	7543
1074	2025-10-10 19:48:33.082	2025-10-10 19:48:40.898	SUCCESS	0	0	0	\N	7816
1075	2025-10-10 19:49:33.108	2025-10-10 19:49:39.699	SUCCESS	0	0	0	\N	6591
1076	2025-10-10 19:50:33.135	2025-10-10 19:50:40.798	SUCCESS	0	0	0	\N	7663
1077	2025-10-10 19:51:33.162	2025-10-10 19:51:37.899	SUCCESS	0	0	0	\N	4737
1078	2025-10-10 19:52:33.187	2025-10-10 19:52:45.198	SUCCESS	0	0	0	\N	12011
1079	2025-10-10 19:53:33.214	2025-10-10 19:53:38.199	SUCCESS	0	0	0	\N	4985
1080	2025-10-10 19:54:33.24	2025-10-10 19:54:39.498	SUCCESS	0	0	0	\N	6258
1081	2025-10-10 19:55:33.244	2025-10-10 19:55:39.598	SUCCESS	0	0	0	\N	6354
1082	2025-10-10 19:56:40.129	2025-10-10 19:56:41.26	SUCCESS	0	0	0	\N	1131
1083	2025-10-10 19:57:40.131	2025-10-10 19:57:42.013	SUCCESS	0	0	0	\N	1882
1084	2025-10-10 19:58:40.132	2025-10-10 19:58:43.62	SUCCESS	0	0	0	\N	3488
1085	2025-10-10 19:59:40.134	2025-10-10 19:59:42.173	SUCCESS	0	0	0	\N	2039
1086	2025-10-10 20:00:40.158	2025-10-10 20:00:51.598	SUCCESS	0	0	0	\N	11440
1087	2025-10-10 20:01:40.188	2025-10-10 20:01:44.798	SUCCESS	0	0	0	\N	4610
1088	2025-10-10 20:02:40.205	2025-10-10 20:02:48.198	SUCCESS	0	0	0	\N	7993
1089	2025-10-10 20:03:40.232	2025-10-10 20:03:41.898	SUCCESS	0	0	0	\N	1666
1090	2025-10-10 20:05:40.238	2025-10-10 20:05:46.617	SUCCESS	1	0	1	\N	6379
1091	2025-10-10 20:06:40.239	2025-10-10 20:06:42.584	SUCCESS	1	0	1	\N	2345
1092	2025-10-10 20:07:40.239	2025-10-10 20:07:42.633	SUCCESS	1	0	1	\N	2394
1093	2025-10-10 20:08:40.24	2025-10-10 20:08:42.287	SUCCESS	1	0	1	\N	2047
1094	2025-10-10 20:09:40.241	2025-10-10 20:09:42.559	SUCCESS	1	0	1	\N	2318
1095	2025-10-10 20:10:40.242	2025-10-10 20:10:42.568	SUCCESS	1	0	1	\N	2326
1096	2025-10-10 20:11:40.246	2025-10-10 20:11:58.599	SUCCESS	1	0	1	\N	18353
1097	2025-10-10 20:12:40.272	2025-10-10 20:13:04.898	SUCCESS	1	0	0	\N	24626
1098	2025-10-10 20:13:40.296	2025-10-10 20:13:57.598	SUCCESS	1	0	1	\N	17302
1099	2025-10-10 20:14:40.321	2025-10-10 20:14:52.198	SUCCESS	1	0	1	\N	11877
1100	2025-10-10 20:15:40.347	2025-10-10 20:15:54.898	SUCCESS	1	0	1	\N	14551
1101	2025-10-10 20:16:40.369	2025-10-10 20:16:53.998	SUCCESS	1	0	1	\N	13629
1102	2025-10-10 20:17:40.376	2025-10-10 20:17:55.098	SUCCESS	1	0	1	\N	14722
1103	2025-10-10 20:18:40.399	2025-10-10 20:18:46.798	SUCCESS	0	0	0	\N	6399
1104	2025-10-10 20:19:40.423	2025-10-10 20:19:45.699	SUCCESS	0	0	0	\N	5276
1105	2025-10-10 20:20:40.446	2025-10-10 20:20:46.498	SUCCESS	0	0	0	\N	6052
1106	2025-10-10 20:21:40.469	2025-10-10 20:21:47.498	SUCCESS	0	0	0	\N	7029
1107	2025-10-10 20:22:40.492	2025-10-10 20:22:45.298	SUCCESS	0	0	0	\N	4806
1108	2025-10-10 20:23:40.513	2025-10-10 20:23:46.298	SUCCESS	0	0	0	\N	5785
1109	2025-10-10 20:24:40.535	2025-10-10 20:24:48.398	SUCCESS	0	0	0	\N	7863
1110	2025-10-10 20:25:40.557	2025-10-10 20:25:48.798	SUCCESS	0	0	0	\N	8241
1111	2025-10-10 20:52:25.552	2025-10-10 20:52:48.816	SUCCESS	2	0	2	\N	23264
1112	2025-10-10 20:54:25.563	2025-10-10 20:54:37.315	ERROR	0	0	0	Connection terminated due to connection timeout	11752
1113	2025-10-10 20:56:26.643	2025-10-10 20:56:32.515	SUCCESS	0	0	0	\N	5872
1114	2025-10-10 20:57:26.664	2025-10-10 20:57:37.916	ERROR	0	0	0	Connection terminated due to connection timeout	11252
1115	2025-10-10 20:58:26.692	2025-10-10 20:58:32.216	SUCCESS	0	0	0	\N	5524
1116	2025-10-10 20:59:26.705	2025-10-10 20:59:32.815	SUCCESS	0	0	0	\N	6110
1117	2025-10-10 21:00:26.714	2025-10-10 21:00:32.415	SUCCESS	0	0	0	\N	5701
1118	2025-10-10 21:01:26.742	2025-10-10 21:01:33.315	SUCCESS	0	0	0	\N	6573
1119	2025-10-10 21:02:26.769	2025-10-10 21:02:35.315	SUCCESS	0	0	0	\N	8546
1120	2025-10-10 21:03:26.795	2025-10-10 21:03:36.416	ERROR	0	0	0	Connection terminated due to connection timeout	9621
1121	2025-10-10 21:04:26.822	2025-10-10 21:04:35.635	SUCCESS	0	0	0	\N	8813
1122	2025-10-10 21:05:26.847	2025-10-10 21:05:30.616	SUCCESS	0	0	0	\N	3769
1123	2025-10-10 21:06:26.873	2025-10-10 21:06:31.617	SUCCESS	0	0	0	\N	4744
1124	2025-10-10 21:07:26.898	2025-10-10 21:07:30.215	SUCCESS	0	0	0	\N	3317
1125	2025-10-10 21:08:26.923	2025-10-10 21:08:31.217	SUCCESS	0	0	0	\N	4294
1126	2025-10-10 21:09:26.93	2025-10-10 21:09:30.715	SUCCESS	0	0	0	\N	3785
1127	2025-10-10 21:10:26.937	2025-10-10 21:10:31.215	SUCCESS	0	0	0	\N	4278
1128	2025-10-10 21:11:26.961	2025-10-10 21:11:35.415	SUCCESS	0	0	0	\N	8454
1129	2025-10-10 21:12:26.984	2025-10-10 21:12:31.016	SUCCESS	0	0	0	\N	4032
1130	2025-10-10 21:13:27.009	2025-10-10 21:13:31.015	SUCCESS	0	0	0	\N	4006
1131	2025-10-10 21:14:27.026	2025-10-10 21:14:31.617	SUCCESS	0	0	0	\N	4591
1132	2025-10-10 21:15:27.048	2025-10-10 21:15:51.115	SUCCESS	1	0	1	\N	24067
1133	2025-10-10 21:16:27.071	2025-10-10 21:16:32.716	SUCCESS	0	0	0	\N	5645
1134	2025-10-10 21:17:27.094	2025-10-10 21:17:31.815	SUCCESS	0	0	0	\N	4721
1135	2025-10-10 21:18:27.098	2025-10-10 21:18:28.636	SUCCESS	0	0	0	\N	1538
1136	2025-10-10 21:19:27.121	2025-10-10 21:19:31.735	SUCCESS	0	0	0	\N	4614
1137	2025-10-10 21:20:27.144	2025-10-10 21:20:31.815	SUCCESS	0	0	0	\N	4671
1138	2025-10-10 21:21:27.167	2025-10-10 21:21:30.415	SUCCESS	0	0	0	\N	3248
1139	2025-10-10 21:22:27.19	2025-10-10 21:22:30.015	SUCCESS	0	0	0	\N	2825
1403	2025-10-11 09:05:02.705	2025-10-11 09:05:03.624	SUCCESS	0	0	0	\N	919
1140	2025-10-10 21:23:27.213	2025-10-10 21:23:32.135	SUCCESS	0	0	0	\N	4922
1141	2025-10-10 21:24:27.226	2025-10-10 21:24:27.991	SUCCESS	0	0	0	\N	765
1142	2025-10-10 21:43:55.75	2025-10-10 21:43:58.54	SUCCESS	0	0	0	\N	2790
1143	2025-10-10 21:44:55.751	2025-10-10 21:45:04.678	SUCCESS	0	0	0	\N	8927
1144	2025-10-10 21:45:55.781	2025-10-10 21:46:03.478	SUCCESS	0	0	0	\N	7697
1145	2025-10-10 21:46:55.81	2025-10-10 21:47:06.677	SUCCESS	0	0	0	\N	10867
1146	2025-10-10 21:47:55.839	2025-10-10 21:48:01.279	SUCCESS	0	0	0	\N	5440
1147	2025-10-10 21:48:55.868	2025-10-10 21:49:01.677	SUCCESS	0	0	0	\N	5809
1148	2025-10-10 21:49:55.896	2025-10-10 21:50:03.077	SUCCESS	0	0	0	\N	7181
1149	2025-10-10 21:50:55.925	2025-10-10 21:51:04.278	SUCCESS	0	0	0	\N	8353
1150	2025-10-10 21:51:55.953	2025-10-10 21:52:02.077	SUCCESS	0	0	0	\N	6124
1151	2025-10-10 21:52:55.98	2025-10-10 21:53:04.978	SUCCESS	0	0	0	\N	8998
1152	2025-10-10 21:53:56.007	2025-10-10 21:54:03.777	SUCCESS	0	0	0	\N	7770
1153	2025-10-10 21:54:56.033	2025-10-10 21:55:02.378	SUCCESS	0	0	0	\N	6345
1154	2025-10-10 21:55:56.037	2025-10-10 21:55:57.606	SUCCESS	0	0	0	\N	1569
1155	2025-10-10 21:56:56.041	2025-10-10 21:56:57.377	SUCCESS	0	0	0	\N	1336
1156	2025-10-10 21:58:07.33	2025-10-10 21:58:08.212	SUCCESS	0	0	0	\N	882
1157	2025-10-10 21:59:19.025	2025-10-10 21:59:19.992	SUCCESS	0	0	0	\N	967
1158	2025-10-10 22:00:45.221	2025-10-10 22:00:46.469	SUCCESS	0	0	0	\N	1248
1159	2025-10-10 22:01:53.709	2025-10-10 22:01:55.177	SUCCESS	0	0	0	\N	1468
1160	2025-10-10 22:02:53.711	2025-10-10 22:02:56.377	SUCCESS	0	0	0	\N	2666
1161	2025-10-10 22:03:53.714	2025-10-10 22:03:56.064	SUCCESS	0	0	0	\N	2350
1162	2025-10-10 22:04:53.718	2025-10-10 22:04:59.177	SUCCESS	0	0	0	\N	5459
1163	2025-10-10 22:05:53.747	2025-10-10 22:05:59.978	SUCCESS	0	0	0	\N	6231
1164	2025-10-10 22:06:53.751	2025-10-10 22:06:55.019	SUCCESS	0	0	0	\N	1268
1165	2025-10-10 22:07:53.752	2025-10-10 22:08:01.277	SUCCESS	0	0	0	\N	7525
1166	2025-10-10 22:08:53.78	2025-10-10 22:09:00.078	SUCCESS	0	0	0	\N	6298
1167	2025-10-10 22:09:53.808	2025-10-10 22:10:00.977	SUCCESS	0	0	0	\N	7169
1168	2025-10-10 22:10:53.835	2025-10-10 22:11:04.377	SUCCESS	0	0	0	\N	10542
1169	2025-10-10 22:11:53.863	2025-10-10 22:12:00.678	SUCCESS	0	0	0	\N	6815
1170	2025-10-10 22:12:53.888	2025-10-10 22:13:01.679	SUCCESS	0	0	0	\N	7791
1171	2025-10-10 22:13:53.913	2025-10-10 22:14:01.778	SUCCESS	0	0	0	\N	7865
1172	2025-10-10 22:14:53.938	2025-10-10 22:15:01.936	SUCCESS	0	0	0	\N	7998
1173	2025-10-10 22:15:53.94	2025-10-10 22:15:56.277	SUCCESS	0	0	0	\N	2337
1174	2025-10-10 22:16:56.377	2025-10-10 22:17:07.578	SUCCESS	0	0	0	\N	11201
1175	2025-10-10 22:17:56.38	2025-10-10 22:18:01.98	SUCCESS	0	0	0	\N	5600
1176	2025-10-10 22:19:56.385	2025-10-10 22:20:04.178	SUCCESS	0	0	0	\N	7793
1177	2025-10-10 22:20:56.388	2025-10-10 22:21:02.277	SUCCESS	0	0	0	\N	5889
1178	2025-10-10 22:21:56.397	2025-10-10 22:22:07.778	SUCCESS	0	0	0	\N	11381
1179	2025-10-10 22:22:56.421	2025-10-10 22:23:02.778	SUCCESS	0	0	0	\N	6357
1180	2025-10-10 22:23:56.434	2025-10-10 22:24:04.477	SUCCESS	0	0	0	\N	8043
1181	2025-10-10 22:24:56.453	2025-10-10 22:25:02.977	SUCCESS	0	0	0	\N	6524
1182	2025-10-10 22:25:56.459	2025-10-10 22:25:58.88	SUCCESS	0	0	0	\N	2421
1183	2025-10-10 22:26:56.488	2025-10-10 22:27:05.577	SUCCESS	0	0	0	\N	9089
1184	2025-10-10 22:27:56.516	2025-10-10 22:28:03.878	SUCCESS	0	0	0	\N	7362
1185	2025-10-10 22:28:56.544	2025-10-10 22:29:02.778	SUCCESS	0	0	0	\N	6234
1186	2025-10-10 22:29:56.572	2025-10-10 22:30:04.278	SUCCESS	0	0	0	\N	7706
1187	2025-10-10 22:30:56.6	2025-10-10 22:31:04.177	SUCCESS	0	0	0	\N	7577
1188	2025-10-10 22:43:44.046	2025-10-10 22:43:48.385	ERROR	0	0	0	No active connection	4339
1189	2025-10-10 22:44:44.045	2025-10-10 22:44:44.085	ERROR	0	0	0	No active connection	40
1190	2025-10-10 22:46:44.052	2025-10-10 22:46:49.587	ERROR	0	0	0	No active connection	5535
1191	2025-10-10 22:47:44.058	2025-10-10 22:47:48.286	ERROR	0	0	0	No active connection	4228
1192	2025-10-10 22:48:44.082	2025-10-10 22:48:48.086	ERROR	0	0	0	No active connection	4004
1193	2025-10-10 22:49:44.098	2025-10-10 22:49:48.386	ERROR	0	0	0	No active connection	4288
1194	2025-10-10 22:50:44.123	2025-10-10 22:50:48.386	ERROR	0	0	0	No active connection	4263
1195	2025-10-10 22:51:44.147	2025-10-10 22:51:46.385	ERROR	0	0	0	No active connection	2238
1196	2025-10-10 22:52:44.169	2025-10-10 22:52:46.987	ERROR	0	0	0	No active connection	2818
1197	2025-10-10 22:53:44.193	2025-10-10 22:53:46.385	ERROR	0	0	0	No active connection	2192
1198	2025-10-10 22:54:44.217	2025-10-10 22:54:46.185	ERROR	0	0	0	No active connection	1968
1199	2025-10-10 22:55:44.241	2025-10-10 22:55:47.985	ERROR	0	0	0	No active connection	3744
1200	2025-10-10 22:56:44.265	2025-10-10 22:56:46.485	ERROR	0	0	0	No active connection	2220
1201	2025-10-10 22:57:44.288	2025-10-10 22:57:46.307	ERROR	0	0	0	No active connection	2019
1202	2025-10-10 22:58:44.309	2025-10-10 22:58:45.985	ERROR	0	0	0	No active connection	1676
1203	2025-10-10 22:59:44.332	2025-10-10 22:59:47.787	ERROR	0	0	0	No active connection	3455
1204	2025-10-10 23:00:44.355	2025-10-10 23:00:47.686	ERROR	0	0	0	No active connection	3331
1205	2025-10-10 23:01:44.379	2025-10-10 23:01:45.485	ERROR	0	0	0	No active connection	1106
1206	2025-10-10 23:02:44.385	2025-10-10 23:02:47.485	ERROR	0	0	0	No active connection	3100
1207	2025-10-10 23:03:44.408	2025-10-10 23:03:45.785	ERROR	0	0	0	No active connection	1377
1208	2025-10-10 23:04:44.424	2025-10-10 23:04:45.785	ERROR	0	0	0	No active connection	1361
1209	2025-10-10 23:20:06.388	2025-10-10 23:20:12.852	ERROR	0	0	0	No active connection	6464
1210	2025-10-10 23:22:06.394	2025-10-10 23:22:09.954	ERROR	0	0	0	No active connection	3560
1211	2025-10-10 23:23:06.421	2025-10-10 23:23:11.054	ERROR	0	0	0	No active connection	4633
1212	2025-10-10 23:24:06.447	2025-10-10 23:24:08.252	ERROR	0	0	0	No active connection	1805
1213	2025-10-10 23:25:06.474	2025-10-10 23:25:08.175	ERROR	0	0	0	No active connection	1701
1214	2025-10-10 23:26:06.499	2025-10-10 23:26:08.252	ERROR	0	0	0	No active connection	1753
1215	2025-10-10 23:27:06.525	2025-10-10 23:27:09.054	ERROR	0	0	0	No active connection	2529
1216	2025-10-10 23:28:06.526	2025-10-10 23:28:08.354	ERROR	0	0	0	No active connection	1828
1217	2025-10-10 23:29:06.551	2025-10-10 23:29:09.052	ERROR	0	0	0	No active connection	2501
1218	2025-10-10 23:30:06.576	2025-10-10 23:30:08.774	ERROR	0	0	0	No active connection	2198
1219	2025-10-10 23:31:06.579	2025-10-10 23:31:09.852	ERROR	0	0	0	No active connection	3273
1220	2025-10-10 23:32:06.603	2025-10-10 23:32:08.452	ERROR	0	0	0	No active connection	1849
1221	2025-10-10 23:33:06.627	2025-10-10 23:33:08.352	ERROR	0	0	0	No active connection	1725
1222	2025-10-10 23:34:06.651	2025-10-10 23:34:10.052	ERROR	0	0	0	No active connection	3401
1223	2025-10-10 23:53:28.972	2025-10-10 23:53:34.327	ERROR	0	0	0	No active connection	5355
1224	2025-10-10 23:55:28.997	2025-10-10 23:55:32.428	ERROR	0	0	0	No active connection	3431
1225	2025-10-10 23:56:29.026	2025-10-10 23:56:34.728	ERROR	0	0	0	No active connection	5702
1226	2025-10-10 23:57:29.037	2025-10-10 23:57:33.427	ERROR	0	0	0	No active connection	4390
1227	2025-10-10 23:58:29.066	2025-10-10 23:58:34.128	ERROR	0	0	0	No active connection	5062
1228	2025-10-10 23:59:29.093	2025-10-10 23:59:32.228	ERROR	0	0	0	No active connection	3135
1229	2025-10-11 00:00:29.121	2025-10-11 00:00:34.728	ERROR	0	0	0	No active connection	5607
1230	2025-10-11 00:01:29.149	2025-10-11 00:01:33.328	ERROR	0	0	0	No active connection	4179
1231	2025-10-11 00:02:29.177	2025-10-11 00:02:32.629	ERROR	0	0	0	No active connection	3452
1235	2025-10-11 00:06:29.286	2025-10-11 00:06:32.728	ERROR	0	0	0	No active connection	3442
1236	2025-10-11 00:07:29.312	2025-10-11 00:07:31.827	ERROR	0	0	0	No active connection	2515
1237	2025-10-11 00:08:29.333	2025-10-11 00:08:31.227	ERROR	0	0	0	No active connection	1894
1404	2025-10-11 09:05:52.966	2025-10-11 09:05:55.145	SUCCESS	0	0	0	\N	2179
1406	2025-10-11 09:06:52.97	2025-10-11 09:06:55.146	SUCCESS	0	0	0	\N	2176
1408	2025-10-11 09:07:52.974	2025-10-11 09:07:55.845	SUCCESS	0	0	0	\N	2871
1410	2025-10-11 09:08:52.977	2025-10-11 09:09:04.845	SUCCESS	1	0	1	\N	11868
1412	2025-10-11 09:09:52.979	2025-10-11 09:10:08.445	SUCCESS	2	0	2	\N	15466
1414	2025-10-11 09:10:52.979	2025-10-11 09:10:56.245	SUCCESS	0	0	0	\N	3266
1426	2025-10-11 09:20:53.019	2025-10-11 09:20:56.767	SUCCESS	0	0	0	\N	3748
1435	2025-10-11 09:29:53.046	2025-10-11 09:29:55.345	SUCCESS	0	0	0	\N	2299
1436	2025-10-11 09:30:53.05	2025-10-11 09:30:55.445	SUCCESS	0	0	0	\N	2395
1437	2025-10-11 09:31:53.052	2025-10-11 09:31:55.645	SUCCESS	0	0	0	\N	2593
1438	2025-10-11 09:32:53.055	2025-10-11 09:32:55.669	SUCCESS	0	0	0	\N	2614
1439	2025-10-11 09:33:53.057	2025-10-11 09:33:53.836	SUCCESS	0	0	0	\N	779
1461	2025-10-11 09:54:43.486	2025-10-11 09:54:44.391	SUCCESS	0	0	0	\N	905
1474	2025-10-11 10:06:08.405	2025-10-11 10:06:09.299	SUCCESS	0	0	0	\N	894
1486	2025-10-11 10:16:15.761	2025-10-11 10:16:16.924	SUCCESS	0	0	0	\N	1163
1504	2025-10-11 10:25:19.722	2025-10-11 10:25:20.629	SUCCESS	0	0	0	\N	907
1558	2025-10-11 12:35:14.684	2025-10-11 12:35:15.388	SUCCESS	0	0	0	\N	704
1580	2025-10-11 12:47:14.689	2025-10-11 12:47:15.347	SUCCESS	0	0	0	\N	658
1678	2025-10-11 15:03:34.787	2025-10-11 15:03:35.722	SUCCESS	0	0	0	\N	935
1691	2025-10-11 15:15:34.793	2025-10-11 15:15:35.915	SUCCESS	0	0	0	\N	1122
1729	2025-10-11 16:18:21.339	2025-10-11 16:18:22.012	SUCCESS	0	0	0	\N	673
1751	2025-10-11 16:28:42.704	2025-10-11 16:28:43.88	SUCCESS	0	0	0	\N	1176
1769	2025-10-11 16:37:42.706	2025-10-11 16:37:43.392	SUCCESS	0	0	0	\N	686
1793	2025-10-11 16:49:42.715	2025-10-11 16:49:43.641	SUCCESS	0	0	0	\N	926
1811	2025-10-11 16:59:14.562	2025-10-11 16:59:18.997	SUCCESS	0	0	0	\N	4435
1825	2025-10-11 17:06:01.39	2025-10-11 17:06:07.118	SUCCESS	0	0	0	\N	5728
1827	2025-10-11 17:07:01.418	2025-10-11 17:07:12.218	SUCCESS	0	0	0	\N	10800
1830	2025-10-11 17:08:15.779	2025-10-11 17:08:16.706	SUCCESS	0	0	0	\N	927
1831	2025-10-11 17:09:02.922	2025-10-11 17:09:08.418	SUCCESS	0	0	0	\N	5496
1833	2025-10-11 17:10:03.018	2025-10-11 17:10:10.918	SUCCESS	0	0	0	\N	7900
1835	2025-10-11 17:11:02.932	2025-10-11 17:11:15.118	ERROR	0	0	0	Connection terminated due to connection timeout	12186
1837	2025-10-11 17:12:02.939	2025-10-11 17:12:07.618	SUCCESS	0	0	0	\N	4679
1839	2025-10-11 17:13:02.946	2025-10-11 17:13:12.038	SUCCESS	0	0	0	\N	9092
1855	2025-10-11 17:20:56.429	2025-10-11 17:20:57.109	SUCCESS	0	0	0	\N	680
1870	2025-10-11 17:29:16.588	2025-10-11 17:29:19.411	SUCCESS	1	0	1	\N	2823
1888	2025-10-11 17:39:16.595	2025-10-11 17:39:17.252	SUCCESS	0	0	0	\N	657
1890	2025-10-11 17:40:16.596	2025-10-11 17:40:17.277	SUCCESS	0	0	0	\N	681
1906	2025-10-11 17:52:16.602	2025-10-11 17:52:19.552	SUCCESS	1	0	1	\N	2950
1924	2025-10-11 18:02:01.934	2025-10-11 18:02:10.53	SUCCESS	0	0	0	\N	8596
1939	2025-10-11 18:09:16.61	2025-10-11 18:09:17.283	SUCCESS	0	0	0	\N	673
1941	2025-10-11 18:10:16.611	2025-10-11 18:10:17.268	SUCCESS	0	0	0	\N	657
1945	2025-10-11 18:12:16.612	2025-10-11 18:12:17.301	SUCCESS	0	0	0	\N	689
1961	2025-10-11 18:20:16.629	2025-10-11 18:20:17.553	SUCCESS	0	0	0	\N	924
1976	2025-10-11 18:27:02.398	2025-10-11 18:27:03.182	SUCCESS	0	0	0	\N	784
1977	2025-10-11 18:27:08.436	2025-10-11 18:27:16.233	SUCCESS	0	0	0	\N	7797
1992	2025-10-11 18:34:16.636	2025-10-11 18:34:17.522	SUCCESS	0	0	0	\N	886
1993	2025-10-11 18:35:08.561	2025-10-11 18:35:12.533	SUCCESS	0	0	0	\N	3972
1999	2025-10-11 18:38:13.747	2025-10-11 18:38:17.233	SUCCESS	0	0	0	\N	3486
2006	2025-10-11 18:41:16.644	2025-10-11 18:41:17.56	SUCCESS	0	0	0	\N	916
2013	2025-10-11 18:45:14.537	2025-10-11 18:45:17.546	SUCCESS	0	0	0	\N	3009
2015	2025-10-11 18:46:14.545	2025-10-11 18:46:27.234	SUCCESS	0	0	0	\N	12689
2016	2025-10-11 18:46:24.763	2025-10-11 18:46:32.799	SUCCESS	0	0	0	\N	8036
2018	2025-10-11 18:47:14.548	2025-10-11 18:47:23.733	SUCCESS	0	0	0	\N	9185
2020	2025-10-11 18:48:14.548	2025-10-11 18:48:24.033	SUCCESS	0	0	0	\N	9485
2021	2025-10-11 18:48:24.824	2025-10-11 18:48:28.9	SUCCESS	0	0	0	\N	4076
2024	2025-10-11 18:49:24.846	2025-10-11 18:49:26.909	SUCCESS	0	0	0	\N	2063
2025	2025-10-11 18:49:48.824	2025-10-11 18:49:49.478	SUCCESS	0	0	0	\N	654
2027	2025-10-11 18:50:24.854	2025-10-11 18:50:31.699	SUCCESS	0	0	0	\N	6845
2030	2025-10-11 18:52:24.856	2025-10-11 18:52:28.498	SUCCESS	0	0	0	\N	3642
2032	2025-10-11 18:53:24.858	2025-10-11 18:53:30.299	SUCCESS	0	0	0	\N	5441
2040	2025-10-11 18:57:36.409	2025-10-11 18:57:41.198	SUCCESS	0	0	0	\N	4789
2041	2025-10-11 18:58:30.596	2025-10-11 18:58:31.318	SUCCESS	0	0	0	\N	722
2058	2025-10-11 19:05:00.989	2025-10-11 19:05:24.585	SUCCESS	1	0	1	\N	23596
2059	2025-10-11 19:05:14.356	2025-10-11 19:05:25.259	SUCCESS	1	0	1	\N	10903
2062	2025-10-11 19:06:14.356	2025-10-11 19:06:25.289	SUCCESS	2	0	2	\N	10933
2082	2025-10-11 19:13:45.19	2025-10-11 19:13:46.41	SUCCESS	0	0	0	\N	1220
2093	2025-10-11 19:18:45.193	2025-10-11 19:18:46.412	SUCCESS	0	0	0	\N	1219
2104	2025-10-11 19:24:10.079	2025-10-11 19:24:11.521	SUCCESS	0	0	0	\N	1442
2112	2025-10-11 19:28:10.083	2025-10-11 19:28:11.284	SUCCESS	0	0	0	\N	1201
2122	2025-10-11 19:33:10.084	2025-10-11 19:33:11.367	SUCCESS	0	0	0	\N	1283
2128	2025-10-11 19:36:10.084	2025-10-11 19:36:11.082	SUCCESS	0	0	0	\N	998
2137	2025-10-11 19:40:45.453	2025-10-11 19:40:46.447	SUCCESS	0	0	0	\N	994
2146	2025-10-11 19:45:41.418	2025-10-11 19:45:42.66	SUCCESS	0	0	0	\N	1242
2150	2025-10-11 19:47:41.419	2025-10-11 19:47:42.423	SUCCESS	0	0	0	\N	1004
2159	2025-10-11 19:52:12.003	2025-10-11 19:52:13.222	SUCCESS	0	0	0	\N	1219
2166	2025-10-11 19:55:32.402	2025-10-11 19:55:38.144	SUCCESS	0	0	0	\N	5742
2168	2025-10-11 19:56:32.428	2025-10-11 19:56:38.044	SUCCESS	0	0	0	\N	5616
2171	2025-10-11 19:58:12.007	2025-10-11 19:58:13.002	SUCCESS	0	0	0	\N	995
2172	2025-10-11 19:58:32.481	2025-10-11 19:58:38.164	SUCCESS	0	0	0	\N	5683
2897	2025-10-12 09:24:44.222	2025-10-12 09:24:50.007	SUCCESS	0	0	0	\N	5785
1232	2025-10-11 00:03:29.204	2025-10-11 00:03:31.628	ERROR	0	0	0	No active connection	2424
1233	2025-10-11 00:04:29.232	2025-10-11 00:04:32.628	ERROR	0	0	0	No active connection	3396
1234	2025-10-11 00:05:29.258	2025-10-11 00:05:33.128	ERROR	0	0	0	No active connection	3870
1238	2025-10-11 00:10:29.385	2025-10-11 00:10:31.929	ERROR	0	0	0	No active connection	2544
1239	2025-10-11 00:11:29.411	2025-10-11 00:11:30.849	ERROR	0	0	0	No active connection	1438
1240	2025-10-11 00:12:29.437	2025-10-11 00:12:32.027	ERROR	0	0	0	No active connection	2590
1241	2025-10-11 00:13:29.461	2025-10-11 00:13:30.927	ERROR	0	0	0	No active connection	1466
1242	2025-10-11 00:14:29.487	2025-10-11 00:14:31.627	ERROR	0	0	0	No active connection	2140
1243	2025-10-11 00:15:29.499	2025-10-11 00:15:30.827	ERROR	0	0	0	No active connection	1328
1244	2025-10-11 00:16:29.521	2025-10-11 00:16:31.127	ERROR	0	0	0	No active connection	1606
1245	2025-10-11 00:17:29.546	2025-10-11 00:17:31.127	ERROR	0	0	0	No active connection	1581
1246	2025-10-11 00:18:29.569	2025-10-11 00:18:33.027	ERROR	0	0	0	No active connection	3458
1247	2025-10-11 00:19:29.627	2025-10-11 00:19:31.628	ERROR	0	0	0	No active connection	2001
1248	2025-10-11 00:20:29.651	2025-10-11 00:20:29.836	ERROR	0	0	0	No active connection	185
1249	2025-10-11 00:29:05.607	2025-10-11 00:29:10.206	ERROR	0	0	0	No active connection	4599
1250	2025-10-11 00:30:05.635	2025-10-11 00:30:10.005	ERROR	0	0	0	No active connection	4370
1251	2025-10-11 00:31:05.659	2025-10-11 00:31:09.306	ERROR	0	0	0	No active connection	3647
1252	2025-10-11 00:32:05.687	2025-10-11 00:32:08.404	ERROR	0	0	0	No active connection	2717
1253	2025-10-11 00:33:05.714	2025-10-11 00:33:09.004	ERROR	0	0	0	No active connection	3290
1254	2025-10-11 00:34:05.741	2025-10-11 00:34:09.305	ERROR	0	0	0	No active connection	3564
1255	2025-10-11 00:35:05.768	2025-10-11 00:35:08.206	ERROR	0	0	0	No active connection	2438
1256	2025-10-11 00:36:05.794	2025-10-11 00:36:08.704	ERROR	0	0	0	No active connection	2910
1257	2025-10-11 00:37:05.821	2025-10-11 00:37:09.804	ERROR	0	0	0	No active connection	3983
1258	2025-10-11 00:38:05.829	2025-10-11 00:38:08.003	ERROR	0	0	0	No active connection	2174
1259	2025-10-11 00:39:05.855	2025-10-11 00:39:08.203	ERROR	0	0	0	No active connection	2348
1260	2025-10-11 00:40:05.881	2025-10-11 00:40:08.902	ERROR	0	0	0	No active connection	3021
1261	2025-10-11 00:41:05.907	2025-10-11 00:41:08.903	ERROR	0	0	0	No active connection	2996
1262	2025-10-11 00:43:05.96	2025-10-11 00:43:09.406	ERROR	0	0	0	No active connection	3446
1263	2025-10-11 00:44:05.98	2025-10-11 00:44:10.203	ERROR	0	0	0	No active connection	4223
1264	2025-10-11 00:45:06.007	2025-10-11 00:45:08.904	ERROR	0	0	0	No active connection	2897
1265	2025-10-11 00:46:06.031	2025-10-11 00:46:08.803	ERROR	0	0	0	No active connection	2772
1266	2025-10-11 00:47:06.055	2025-10-11 00:47:09.105	ERROR	0	0	0	No active connection	3050
1267	2025-10-11 00:48:06.079	2025-10-11 00:48:08.903	ERROR	0	0	0	No active connection	2824
1268	2025-10-11 00:49:06.103	2025-10-11 00:49:09.803	ERROR	0	0	0	No active connection	3700
1269	2025-10-11 00:50:06.126	2025-10-11 00:50:08.903	ERROR	0	0	0	No active connection	2777
1270	2025-10-11 00:51:06.15	2025-10-11 00:51:08.903	ERROR	0	0	0	No active connection	2753
1271	2025-10-11 00:52:06.173	2025-10-11 00:52:08.703	ERROR	0	0	0	No active connection	2530
1272	2025-10-11 00:56:26.773	2025-10-11 00:56:29.533	ERROR	0	0	0	No active connection	2760
1273	2025-10-11 00:57:26.796	2025-10-11 00:57:29.933	ERROR	0	0	0	No active connection	3137
1274	2025-10-11 00:58:26.801	2025-10-11 00:58:28.433	ERROR	0	0	0	No active connection	1632
1275	2025-10-11 00:59:26.823	2025-10-11 00:59:29.533	ERROR	0	0	0	No active connection	2710
1276	2025-10-11 01:00:26.846	2025-10-11 01:00:29.533	ERROR	0	0	0	No active connection	2687
1277	2025-10-11 01:01:26.869	2025-10-11 01:01:29.134	ERROR	0	0	0	No active connection	2265
1278	2025-10-11 01:02:26.891	2025-10-11 01:02:28.733	ERROR	0	0	0	No active connection	1842
1279	2025-10-11 01:03:26.914	2025-10-11 01:03:28.833	ERROR	0	0	0	No active connection	1919
1280	2025-10-11 01:04:26.937	2025-10-11 01:04:29.333	ERROR	0	0	0	No active connection	2396
1281	2025-10-11 01:05:27.133	2025-10-11 01:05:30.233	ERROR	0	0	0	No active connection	3100
1282	2025-10-11 01:06:27.155	2025-10-11 01:06:30.733	ERROR	0	0	0	No active connection	3578
1283	2025-10-11 01:07:27.177	2025-10-11 01:07:29.533	ERROR	0	0	0	No active connection	2356
1284	2025-10-11 01:08:27.2	2025-10-11 01:08:29.233	ERROR	0	0	0	No active connection	2033
1285	2025-10-11 01:09:27.222	2025-10-11 01:09:28.754	ERROR	0	0	0	No active connection	1532
1286	2025-10-11 01:10:27.244	2025-10-11 01:10:30.433	ERROR	0	0	0	No active connection	3189
1287	2025-10-11 01:11:27.266	2025-10-11 01:11:29.233	ERROR	0	0	0	No active connection	1967
1288	2025-10-11 01:12:27.288	2025-10-11 01:12:29.833	ERROR	0	0	0	No active connection	2545
1289	2025-10-11 01:13:27.31	2025-10-11 01:13:29.434	ERROR	0	0	0	No active connection	2124
1290	2025-10-11 01:14:27.332	2025-10-11 01:14:29.433	ERROR	0	0	0	No active connection	2101
1291	2025-10-11 01:15:27.354	2025-10-11 01:15:29.933	ERROR	0	0	0	No active connection	2579
1292	2025-10-11 01:16:27.376	2025-10-11 01:16:29.734	ERROR	0	0	0	No active connection	2358
1293	2025-10-11 01:17:27.397	2025-10-11 01:17:29.333	ERROR	0	0	0	No active connection	1936
1294	2025-10-11 01:18:27.42	2025-10-11 01:18:29.256	ERROR	0	0	0	No active connection	1836
1295	2025-10-11 01:19:27.441	2025-10-11 01:19:32.533	ERROR	0	0	0	No active connection	5092
1296	2025-10-11 01:20:27.463	2025-10-11 01:20:29.533	ERROR	0	0	0	No active connection	2070
1297	2025-10-11 01:40:13.298	2025-10-11 01:40:18.059	ERROR	0	0	0	No active connection	4761
1298	2025-10-11 01:41:13.326	2025-10-11 01:41:17.259	ERROR	0	0	0	No active connection	3933
1299	2025-10-11 01:43:13.376	2025-10-11 01:43:16.859	ERROR	0	0	0	No active connection	3483
1300	2025-10-11 01:44:13.404	2025-10-11 01:44:18.259	ERROR	0	0	0	No active connection	4855
1301	2025-10-11 01:45:13.432	2025-10-11 01:45:16.658	ERROR	0	0	0	No active connection	3226
1302	2025-10-11 01:46:13.439	2025-10-11 01:46:16.658	ERROR	0	0	0	No active connection	3219
1303	2025-10-11 01:47:13.468	2025-10-11 01:47:16.959	ERROR	0	0	0	No active connection	3491
1304	2025-10-11 01:48:13.496	2025-10-11 01:48:17.559	ERROR	0	0	0	No active connection	4063
1305	2025-10-11 01:49:13.524	2025-10-11 01:49:16.958	ERROR	0	0	0	No active connection	3434
1306	2025-10-11 01:50:13.553	2025-10-11 01:50:17.258	ERROR	0	0	0	No active connection	3705
1307	2025-10-11 01:51:13.58	2025-10-11 01:51:17.859	ERROR	0	0	0	No active connection	4279
1308	2025-10-11 01:52:13.608	2025-10-11 01:52:17.958	ERROR	0	0	0	No active connection	4350
1309	2025-10-11 01:53:13.636	2025-10-11 01:53:17.858	ERROR	0	0	0	No active connection	4222
1310	2025-10-11 01:55:26.49	2025-10-11 01:55:30.846	ERROR	0	0	0	No active connection	4356
1311	2025-10-11 01:57:26.517	2025-10-11 01:57:28.546	ERROR	0	0	0	No active connection	2029
1405	2025-10-11 09:06:02.732	2025-10-11 09:06:03.669	SUCCESS	0	0	0	\N	937
1312	2025-10-11 01:58:26.545	2025-10-11 01:58:28.446	ERROR	0	0	0	No active connection	1901
1323	2025-10-11 02:09:26.827	2025-10-11 02:09:28.845	ERROR	0	0	0	No active connection	2018
1324	2025-10-11 02:10:26.852	2025-10-11 02:10:28.845	ERROR	0	0	0	No active connection	1993
1325	2025-10-11 02:11:26.877	2025-10-11 02:11:29.046	ERROR	0	0	0	No active connection	2169
1326	2025-10-11 02:12:26.901	2025-10-11 02:12:28.267	ERROR	0	0	0	No active connection	1366
1407	2025-10-11 09:07:02.761	2025-10-11 09:07:03.69	SUCCESS	0	0	0	\N	929
1463	2025-10-11 09:55:43.517	2025-10-11 09:55:44.508	SUCCESS	0	0	0	\N	991
1475	2025-10-11 10:07:26.58	2025-10-11 10:07:27.526	SUCCESS	0	0	0	\N	946
1488	2025-10-11 10:17:15.79	2025-10-11 10:17:16.798	SUCCESS	0	0	0	\N	1008
1506	2025-10-11 10:26:19.722	2025-10-11 10:26:20.896	SUCCESS	0	0	0	\N	1174
1560	2025-10-11 12:36:14.684	2025-10-11 12:36:15.451	SUCCESS	0	0	0	\N	767
1562	2025-10-11 12:37:14.684	2025-10-11 12:37:15.385	SUCCESS	0	0	0	\N	701
1582	2025-10-11 12:48:14.689	2025-10-11 12:48:15.833	SUCCESS	0	0	0	\N	1144
1679	2025-10-11 15:04:34.788	2025-10-11 15:04:35.893	SUCCESS	0	0	0	\N	1105
1693	2025-10-11 15:16:34.794	2025-10-11 15:16:35.673	SUCCESS	0	0	0	\N	879
1731	2025-10-11 16:19:21.34	2025-10-11 16:19:22.283	SUCCESS	0	0	0	\N	943
1752	2025-10-11 16:29:42.705	2025-10-11 16:29:43.379	SUCCESS	0	0	0	\N	674
1771	2025-10-11 16:38:42.706	2025-10-11 16:38:43.399	SUCCESS	0	0	0	\N	693
1795	2025-10-11 16:50:42.717	2025-10-11 16:50:43.634	SUCCESS	0	0	0	\N	917
1812	2025-10-11 17:00:15.774	2025-10-11 17:00:16.46	SUCCESS	0	0	0	\N	686
1832	2025-10-11 17:09:15.779	2025-10-11 17:09:16.939	SUCCESS	0	0	0	\N	1160
1857	2025-10-11 17:21:56.431	2025-10-11 17:21:57.32	SUCCESS	0	0	0	\N	889
1871	2025-10-11 17:30:16.592	2025-10-11 17:30:19.144	SUCCESS	1	0	1	\N	2552
1892	2025-10-11 17:41:16.597	2025-10-11 17:41:17.293	SUCCESS	0	0	0	\N	696
1907	2025-10-11 17:53:16.603	2025-10-11 17:53:19.306	SUCCESS	1	0	1	\N	2703
1925	2025-10-11 18:02:16.606	2025-10-11 18:02:17.292	SUCCESS	0	0	0	\N	686
1943	2025-10-11 18:11:16.612	2025-10-11 18:11:17.274	SUCCESS	0	0	0	\N	662
1963	2025-10-11 18:21:16.63	2025-10-11 18:21:17.56	SUCCESS	0	0	0	\N	930
1978	2025-10-11 18:27:16.634	2025-10-11 18:27:17.755	SUCCESS	0	0	0	\N	1121
1994	2025-10-11 18:35:16.637	2025-10-11 18:35:17.329	SUCCESS	0	0	0	\N	692
2008	2025-10-11 18:42:16.645	2025-10-11 18:42:17.329	SUCCESS	0	0	0	\N	684
2028	2025-10-11 18:50:48.823	2025-10-11 18:50:49.742	SUCCESS	0	0	0	\N	919
2043	2025-10-11 18:59:30.597	2025-10-11 18:59:31.472	SUCCESS	0	0	0	\N	875
2060	2025-10-11 19:05:30.604	2025-10-11 19:05:33.592	SUCCESS	1	0	1	\N	2988
2085	2025-10-11 19:14:45.193	2025-10-11 19:14:46.393	SUCCESS	0	0	0	\N	1200
2095	2025-10-11 19:19:45.193	2025-10-11 19:19:48.762	SUCCESS	1	0	1	\N	3569
2106	2025-10-11 19:25:10.08	2025-10-11 19:25:11.301	SUCCESS	0	0	0	\N	1221
2114	2025-10-11 19:29:10.083	2025-10-11 19:29:11.678	SUCCESS	0	0	0	\N	1595
2124	2025-10-11 19:34:10.084	2025-10-11 19:34:11.312	SUCCESS	0	0	0	\N	1228
2131	2025-10-11 19:37:10.085	2025-10-11 19:37:11.084	SUCCESS	0	0	0	\N	999
2140	2025-10-11 19:41:45.452	2025-10-11 19:41:46.91	SUCCESS	0	0	0	\N	1458
2147	2025-10-11 19:46:03.856	2025-10-11 19:46:12.254	SUCCESS	0	0	0	\N	8398
2151	2025-10-11 19:48:03.902	2025-10-11 19:48:12.054	SUCCESS	0	0	0	\N	8152
2152	2025-10-11 19:48:41.418	2025-10-11 19:48:42.418	SUCCESS	0	0	0	\N	1000
2154	2025-10-11 19:49:41.418	2025-10-11 19:49:42.41	SUCCESS	0	0	0	\N	992
2155	2025-10-11 19:50:03.935	2025-10-11 19:50:13.654	SUCCESS	0	0	0	\N	9719
2156	2025-10-11 19:50:32.267	2025-10-11 19:50:51.264	SUCCESS	0	0	0	\N	18997
2160	2025-10-11 19:52:32.322	2025-10-11 19:52:38.044	SUCCESS	0	0	0	\N	5722
2161	2025-10-11 19:53:12.003	2025-10-11 19:53:13.018	SUCCESS	0	0	0	\N	1015
2162	2025-10-11 19:53:32.348	2025-10-11 19:53:39.144	SUCCESS	0	0	0	\N	6796
2163	2025-10-11 19:54:12.004	2025-10-11 19:54:12.995	SUCCESS	0	0	0	\N	991
2164	2025-10-11 19:54:32.375	2025-10-11 19:54:40.844	SUCCESS	0	0	0	\N	8469
2167	2025-10-11 19:56:12.004	2025-10-11 19:56:13.003	SUCCESS	0	0	0	\N	999
2170	2025-10-11 19:57:32.454	2025-10-11 19:57:41.167	SUCCESS	0	0	0	\N	8713
2173	2025-10-11 19:59:12.008	2025-10-11 19:59:13.247	SUCCESS	0	0	0	\N	1239
2174	2025-10-11 19:59:32.506	2025-10-11 19:59:41.585	SUCCESS	0	0	0	\N	9079
2176	2025-10-11 20:00:32.532	2025-10-11 20:00:41.165	SUCCESS	0	0	0	\N	8633
2177	2025-10-11 20:01:12.008	2025-10-11 20:01:13.24	SUCCESS	0	0	0	\N	1232
2179	2025-10-11 20:02:12.009	2025-10-11 20:02:13.234	SUCCESS	0	0	0	\N	1225
2182	2025-10-11 20:03:32.586	2025-10-11 20:03:37.444	SUCCESS	0	0	0	\N	4858
2184	2025-10-11 20:04:32.611	2025-10-11 20:04:37.345	SUCCESS	0	0	0	\N	4734
2185	2025-10-11 20:05:12.01	2025-10-11 20:05:13.216	SUCCESS	0	0	0	\N	1206
2189	2025-10-11 20:07:12.012	2025-10-11 20:07:13.239	SUCCESS	0	0	0	\N	1227
2191	2025-10-11 20:08:12.013	2025-10-11 20:08:13.229	SUCCESS	0	0	0	\N	1216
2196	2025-10-11 20:16:11.78	2025-10-11 20:16:20.343	SUCCESS	0	0	0	\N	8563
2198	2025-10-11 20:18:11.819	2025-10-11 20:18:16.625	SUCCESS	0	0	0	\N	4806
2203	2025-10-11 20:23:11.927	2025-10-11 20:23:19.603	SUCCESS	0	0	0	\N	7676
2204	2025-10-11 20:24:11.952	2025-10-11 20:24:21.925	SUCCESS	0	0	0	\N	9973
2206	2025-10-11 20:26:12	2025-10-11 20:26:17.403	SUCCESS	0	0	0	\N	5403
2209	2025-10-11 20:29:12.037	2025-10-11 20:29:17.003	SUCCESS	0	0	0	\N	4966
2210	2025-10-11 20:30:12.051	2025-10-11 20:30:16.803	SUCCESS	0	0	0	\N	4752
2211	2025-10-11 20:31:05.046	2025-10-11 20:31:06.338	SUCCESS	0	0	0	\N	1292
2212	2025-10-11 20:31:12.075	2025-10-11 20:31:15.803	SUCCESS	0	0	0	\N	3728
2216	2025-10-11 20:33:05.048	2025-10-11 20:33:06.046	SUCCESS	0	0	0	\N	998
2222	2025-10-11 20:35:05.049	2025-10-11 20:35:06.272	SUCCESS	0	0	0	\N	1223
2224	2025-10-11 20:36:05.05	2025-10-11 20:36:06.284	SUCCESS	0	0	0	\N	1234
2225	2025-10-11 20:36:19.317	2025-10-11 20:36:25.903	SUCCESS	0	0	0	\N	6586
2226	2025-10-11 20:36:56.89	2025-10-11 20:37:02.985	SUCCESS	0	0	0	\N	6095
2227	2025-10-11 20:37:05.049	2025-10-11 20:37:06.245	SUCCESS	0	0	0	\N	1196
2228	2025-10-11 20:37:56.911	2025-10-11 20:38:06.785	SUCCESS	0	0	0	\N	9874
2229	2025-10-11 20:38:05.05	2025-10-11 20:38:06.946	SUCCESS	0	0	0	\N	1896
2230	2025-10-11 20:38:56.933	2025-10-11 20:39:00.309	SUCCESS	0	0	0	\N	3376
2231	2025-10-11 20:39:05.05	2025-10-11 20:39:06.255	SUCCESS	0	0	0	\N	1205
2232	2025-10-11 20:39:56.955	2025-10-11 20:40:02.184	SUCCESS	0	0	0	\N	5229
2233	2025-10-11 20:40:56.977	2025-10-11 20:41:01.584	SUCCESS	0	0	0	\N	4607
2234	2025-10-11 20:41:56.999	2025-10-11 20:42:02.484	SUCCESS	0	0	0	\N	5485
2235	2025-10-11 20:42:57.021	2025-10-11 20:43:01.784	SUCCESS	0	0	0	\N	4763
2236	2025-10-11 20:43:57.043	2025-10-11 20:44:01.384	SUCCESS	0	0	0	\N	4341
2237	2025-10-11 20:44:57.065	2025-10-11 20:44:59.985	SUCCESS	0	0	0	\N	2920
2238	2025-10-11 20:45:57.086	2025-10-11 20:46:00.685	SUCCESS	0	0	0	\N	3599
2239	2025-10-11 20:46:57.098	2025-10-11 20:47:01.385	SUCCESS	0	0	0	\N	4287
1313	2025-10-11 01:59:26.572	2025-10-11 01:59:27.645	ERROR	0	0	0	No active connection	1073
1314	2025-10-11 02:00:26.594	2025-10-11 02:00:28.047	ERROR	0	0	0	No active connection	1453
1315	2025-10-11 02:01:26.621	2025-10-11 02:01:28.046	ERROR	0	0	0	No active connection	1425
1316	2025-10-11 02:02:26.648	2025-10-11 02:02:28.646	ERROR	0	0	0	No active connection	1998
1317	2025-10-11 02:03:26.675	2025-10-11 02:03:29.445	ERROR	0	0	0	No active connection	2770
1318	2025-10-11 02:04:26.7	2025-10-11 02:04:27.645	ERROR	0	0	0	No active connection	945
1319	2025-10-11 02:05:26.726	2025-10-11 02:05:29.069	ERROR	0	0	0	No active connection	2343
1320	2025-10-11 02:06:26.752	2025-10-11 02:06:28.645	ERROR	0	0	0	No active connection	1893
1321	2025-10-11 02:07:26.777	2025-10-11 02:07:28.445	ERROR	0	0	0	No active connection	1668
1322	2025-10-11 02:08:26.802	2025-10-11 02:08:28.346	ERROR	0	0	0	No active connection	1544
1327	2025-10-11 02:51:16.347	2025-10-11 02:51:20.892	ERROR	0	0	0	No active connection	4545
1328	2025-10-11 02:53:17.317	2025-10-11 02:53:20.492	ERROR	0	0	0	No active connection	3175
1329	2025-10-11 02:54:17.343	2025-10-11 02:54:20.292	ERROR	0	0	0	No active connection	2949
1330	2025-10-11 02:55:17.364	2025-10-11 02:55:20.593	ERROR	0	0	0	No active connection	3229
1331	2025-10-11 02:56:17.389	2025-10-11 02:56:20.091	ERROR	0	0	0	No active connection	2702
1332	2025-10-11 02:57:17.414	2025-10-11 02:57:20.591	ERROR	0	0	0	No active connection	3177
1333	2025-10-11 02:58:17.437	2025-10-11 02:58:20.391	ERROR	0	0	0	No active connection	2954
1334	2025-10-11 02:59:17.461	2025-10-11 02:59:20.191	ERROR	0	0	0	No active connection	2730
1335	2025-10-11 03:00:17.485	2025-10-11 03:00:20.491	ERROR	0	0	0	No active connection	3006
1336	2025-10-11 03:01:17.509	2025-10-11 03:01:20.591	ERROR	0	0	0	No active connection	3082
1337	2025-10-11 03:02:17.533	2025-10-11 03:02:19.491	ERROR	0	0	0	No active connection	1958
1338	2025-10-11 03:03:17.557	2025-10-11 03:03:20.491	ERROR	0	0	0	No active connection	2934
1339	2025-10-11 03:04:17.581	2025-10-11 03:04:19.791	ERROR	0	0	0	No active connection	2210
1340	2025-10-11 03:05:17.606	2025-10-11 03:05:20.191	ERROR	0	0	0	No active connection	2585
1341	2025-10-11 03:06:17.629	2025-10-11 03:06:17.799	ERROR	0	0	0	No active connection	170
1409	2025-10-11 09:08:02.789	2025-10-11 09:08:03.688	SUCCESS	0	0	0	\N	899
1465	2025-10-11 09:56:43.546	2025-10-11 09:56:44.467	SUCCESS	0	0	0	\N	921
1476	2025-10-11 10:08:26.58	2025-10-11 10:08:27.541	SUCCESS	0	0	0	\N	961
1490	2025-10-11 10:18:15.82	2025-10-11 10:18:16.72	SUCCESS	0	0	0	\N	900
1508	2025-10-11 10:27:19.726	2025-10-11 10:27:20.67	SUCCESS	0	0	0	\N	944
1563	2025-10-11 12:38:14.684	2025-10-11 12:38:15.846	SUCCESS	0	0	0	\N	1162
1584	2025-10-11 12:49:14.689	2025-10-11 12:49:15.614	SUCCESS	0	0	0	\N	925
1680	2025-10-11 15:05:34.787	2025-10-11 15:05:35.778	SUCCESS	0	0	0	\N	991
1695	2025-10-11 15:17:34.795	2025-10-11 15:17:35.925	SUCCESS	0	0	0	\N	1130
1733	2025-10-11 16:20:21.341	2025-10-11 16:20:22.538	SUCCESS	0	0	0	\N	1197
1753	2025-10-11 16:30:42.705	2025-10-11 16:30:43.398	SUCCESS	0	0	0	\N	693
1773	2025-10-11 16:39:42.707	2025-10-11 16:39:45.365	SUCCESS	1	0	1	\N	2658
1797	2025-10-11 16:51:42.715	2025-10-11 16:51:43.707	SUCCESS	0	0	0	\N	992
1813	2025-10-11 17:00:14.564	2025-10-11 17:00:18.297	SUCCESS	0	0	0	\N	3733
1834	2025-10-11 17:10:15.78	2025-10-11 17:10:16.73	SUCCESS	0	0	0	\N	950
1858	2025-10-11 17:22:32.846	2025-10-11 17:22:45.289	ERROR	0	0	0	Connection terminated due to connection timeout	12443
1860	2025-10-11 17:23:32.87	2025-10-11 17:23:37.389	SUCCESS	0	0	0	\N	4519
1862	2025-10-11 17:24:32.892	2025-10-11 17:24:44.489	SUCCESS	0	0	0	\N	11597
1864	2025-10-11 17:25:32.915	2025-10-11 17:25:38.289	SUCCESS	0	0	0	\N	5374
1872	2025-10-11 17:31:16.592	2025-10-11 17:31:19.064	SUCCESS	1	0	1	\N	2472
1875	2025-10-11 17:32:35.105	2025-10-11 17:32:54.67	SUCCESS	1	0	1	\N	19565
1894	2025-10-11 17:42:16.598	2025-10-11 17:42:17.284	SUCCESS	0	0	0	\N	686
1909	2025-10-11 17:54:16.604	2025-10-11 17:54:19.088	SUCCESS	1	0	1	\N	2484
1913	2025-10-11 17:56:16.605	2025-10-11 17:56:17.315	SUCCESS	0	0	0	\N	710
1926	2025-10-11 18:03:01.946	2025-10-11 18:03:08.33	SUCCESS	0	0	0	\N	6384
1947	2025-10-11 18:13:16.612	2025-10-11 18:13:17.272	SUCCESS	0	0	0	\N	660
1950	2025-10-11 18:15:02.186	2025-10-11 18:15:08.329	SUCCESS	0	0	0	\N	6143
1952	2025-10-11 18:16:02.206	2025-10-11 18:16:06.729	SUCCESS	0	0	0	\N	4523
1954	2025-10-11 18:17:02.226	2025-10-11 18:17:08.229	SUCCESS	0	0	0	\N	6003
1965	2025-10-11 18:22:16.63	2025-10-11 18:22:17.331	SUCCESS	0	0	0	\N	701
1980	2025-10-11 18:28:16.634	2025-10-11 18:28:17.517	SUCCESS	0	0	0	\N	883
1979	2025-10-11 18:28:08.443	2025-10-11 18:28:18.733	SUCCESS	0	0	0	\N	10290
1981	2025-10-11 18:29:08.443	2025-10-11 18:29:21.054	ERROR	0	0	0	Connection terminated due to connection timeout	12611
1983	2025-10-11 18:30:08.473	2025-10-11 18:30:14.333	SUCCESS	0	0	0	\N	5860
1985	2025-10-11 18:31:08.5	2025-10-11 18:31:17.433	SUCCESS	0	0	0	\N	8933
1987	2025-10-11 18:32:08.503	2025-10-11 18:32:18.733	SUCCESS	0	0	0	\N	10230
1989	2025-10-11 18:33:08.507	2025-10-11 18:33:12.933	SUCCESS	0	0	0	\N	4426
1991	2025-10-11 18:34:08.535	2025-10-11 18:34:17.233	SUCCESS	0	0	0	\N	8698
1995	2025-10-11 18:36:13.744	2025-10-11 18:36:16.635	SUCCESS	0	0	0	\N	2891
1996	2025-10-11 18:36:16.638	2025-10-11 18:36:17.768	SUCCESS	0	0	0	\N	1130
1997	2025-10-11 18:37:13.747	2025-10-11 18:37:20.333	SUCCESS	0	0	0	\N	6586
2010	2025-10-11 18:43:16.645	2025-10-11 18:43:17.357	SUCCESS	0	0	0	\N	712
2023	2025-10-11 18:49:14.552	2025-10-11 18:49:19.933	SUCCESS	0	0	0	\N	5381
2026	2025-10-11 18:50:14.576	2025-10-11 18:50:20.933	SUCCESS	0	0	0	\N	6357
2029	2025-10-11 18:51:24.854	2025-10-11 18:51:27.098	SUCCESS	0	0	0	\N	2244
2031	2025-10-11 18:52:30.595	2025-10-11 18:52:31.337	SUCCESS	0	0	0	\N	742
2044	2025-10-11 19:00:00.872	2025-10-11 19:00:22.485	SUCCESS	0	0	0	\N	21613
2046	2025-10-11 19:01:00.892	2025-10-11 19:01:05.785	SUCCESS	0	0	0	\N	4893
2063	2025-10-11 19:06:30.603	2025-10-11 19:06:31.737	SUCCESS	0	0	0	\N	1134
2087	2025-10-11 19:15:45.193	2025-10-11 19:15:46.155	SUCCESS	0	0	0	\N	962
2096	2025-10-11 19:19:58.882	2025-10-11 19:20:03.527	SUCCESS	0	0	0	\N	4645
2097	2025-10-11 19:20:58.886	2025-10-11 19:21:09.248	SUCCESS	0	0	0	\N	10362
2099	2025-10-11 19:21:58.892	2025-10-11 19:22:04.027	SUCCESS	0	0	0	\N	5135
2108	2025-10-11 19:26:10.081	2025-10-11 19:26:13.012	SUCCESS	0	0	0	\N	2931
2111	2025-10-11 19:27:58.92	2025-10-11 19:28:05.727	SUCCESS	0	0	0	\N	6807
2113	2025-10-11 19:28:58.93	2025-10-11 19:29:05.727	SUCCESS	0	0	0	\N	6797
2116	2025-10-11 19:30:10.084	2025-10-11 19:30:11.287	SUCCESS	0	0	0	\N	1203
2119	2025-10-11 19:31:36.832	2025-10-11 19:31:44.705	SUCCESS	0	0	0	\N	7873
2121	2025-10-11 19:32:36.86	2025-10-11 19:32:45.905	SUCCESS	0	0	0	\N	9045
2123	2025-10-11 19:33:36.872	2025-10-11 19:33:41.805	SUCCESS	0	0	0	\N	4933
2125	2025-10-11 19:34:36.899	2025-10-11 19:34:41.306	SUCCESS	0	0	0	\N	4407
2240	2025-10-11 20:47:57.118	2025-10-11 20:48:00.285	SUCCESS	0	0	0	\N	3167
2241	2025-10-11 20:48:57.14	2025-10-11 20:49:00.484	SUCCESS	0	0	0	\N	3344
2242	2025-10-11 20:49:57.144	2025-10-11 20:50:01.084	SUCCESS	0	0	0	\N	3940
2243	2025-10-11 20:50:57.158	2025-10-11 20:51:03.084	SUCCESS	0	0	0	\N	5926
2253	2025-10-11 20:59:57.308	2025-10-11 20:59:58.907	SUCCESS	0	0	0	\N	1599
2257	2025-10-11 21:01:57.329	2025-10-11 21:01:57.779	SUCCESS	0	0	0	\N	450
2259	2025-10-11 21:02:57.329	2025-10-11 21:03:00.184	SUCCESS	0	0	0	\N	2855
2261	2025-10-11 21:03:57.684	2025-10-11 21:04:07.285	SUCCESS	0	0	0	\N	9601
2263	2025-10-11 21:04:57.705	2025-10-11 21:05:01.385	SUCCESS	0	0	0	\N	3680
2265	2025-10-11 21:05:57.727	2025-10-11 21:06:00.585	SUCCESS	0	0	0	\N	2858
2267	2025-10-11 21:06:57.747	2025-10-11 21:07:02.085	SUCCESS	0	0	0	\N	4338
2269	2025-10-11 21:07:57.767	2025-10-11 21:08:01.485	SUCCESS	0	0	0	\N	3718
2898	2025-10-12 09:25:44.239	2025-10-12 09:25:50.349	SUCCESS	0	0	0	\N	6110
2899	2025-10-12 09:26:44.257	2025-10-12 09:26:50.028	SUCCESS	0	0	0	\N	5771
2900	2025-10-12 09:27:44.274	2025-10-12 09:27:49.307	SUCCESS	0	0	0	\N	5033
2901	2025-10-12 09:28:44.29	2025-10-12 09:28:50.007	SUCCESS	0	0	0	\N	5717
2934	2025-10-12 10:09:21.888	2025-10-12 10:09:23.118	SUCCESS	0	0	0	\N	1230
2956	2025-10-12 10:20:21.892	2025-10-12 10:20:22.923	SUCCESS	0	0	0	\N	1031
2983	2025-10-12 10:32:58.707	2025-10-12 10:32:59.7	SUCCESS	0	0	0	\N	993
2986	2025-10-12 10:33:58.707	2025-10-12 10:33:59.7	SUCCESS	0	0	0	\N	993
3005	2025-10-12 10:43:56.099	2025-10-12 10:43:57.35	SUCCESS	0	0	0	\N	1251
3027	2025-10-12 10:54:56.104	2025-10-12 10:54:59.337	SUCCESS	1	0	1	\N	3233
3039	2025-10-12 11:07:34.148	2025-10-12 11:07:39.264	SUCCESS	2	0	2	\N	5116
3051	2025-10-12 11:14:35.762	2025-10-12 11:15:02.758	SUCCESS	1	0	1	\N	26996
3052	2025-10-12 11:15:29.749	2025-10-12 11:15:46.957	SUCCESS	1	0	1	\N	17208
3055	2025-10-12 11:15:35.779	2025-10-12 11:16:03.936	SUCCESS	1	0	1	\N	28157
3083	2025-10-12 11:22:43.47	2025-10-12 11:22:44.722	SUCCESS	0	0	0	\N	1252
3111	2025-10-12 11:32:30.07	2025-10-12 11:32:35.134	SUCCESS	0	0	0	\N	5064
3117	2025-10-12 11:34:30.109	2025-10-12 11:34:34.934	SUCCESS	0	0	0	\N	4825
3130	2025-10-12 11:40:51.313	2025-10-12 11:41:11.398	SUCCESS	1	0	1	\N	20085
3133	2025-10-12 11:42:00.854	2025-10-12 11:42:07.532	SUCCESS	1	0	1	\N	6678
3132	2025-10-12 11:41:51.341	2025-10-12 11:42:09.277	SUCCESS	1	0	1	\N	17936
2244	2025-10-11 20:51:57.181	2025-10-11 20:52:00.207	SUCCESS	0	0	0	\N	3026
2245	2025-10-11 20:52:57.202	2025-10-11 20:53:00.784	SUCCESS	0	0	0	\N	3582
2246	2025-10-11 20:53:57.223	2025-10-11 20:54:00.384	SUCCESS	0	0	0	\N	3161
2247	2025-10-11 20:54:57.245	2025-10-11 20:55:03.184	SUCCESS	0	0	0	\N	5939
2248	2025-10-11 20:55:57.266	2025-10-11 20:56:00.985	SUCCESS	0	0	0	\N	3719
2249	2025-10-11 20:56:57.288	2025-10-11 20:57:00.985	SUCCESS	0	0	0	\N	3697
2250	2025-10-11 20:57:57.306	2025-10-11 20:58:03.384	SUCCESS	0	0	0	\N	6078
2251	2025-10-11 20:58:57.307	2025-10-11 20:58:58.909	SUCCESS	0	0	0	\N	1602
2252	2025-10-11 20:59:14.386	2025-10-11 20:59:15.73	SUCCESS	0	0	0	\N	1344
2254	2025-10-11 21:00:14.387	2025-10-11 21:00:15.357	SUCCESS	0	0	0	\N	970
2255	2025-10-11 21:00:57.328	2025-10-11 21:01:00.384	SUCCESS	0	0	0	\N	3056
2256	2025-10-11 21:01:14.387	2025-10-11 21:01:15.607	SUCCESS	0	0	0	\N	1220
2258	2025-10-11 21:02:14.388	2025-10-11 21:02:15.64	SUCCESS	0	0	0	\N	1252
2260	2025-10-11 21:03:14.389	2025-10-11 21:03:15.624	SUCCESS	0	0	0	\N	1235
2262	2025-10-11 21:04:14.388	2025-10-11 21:04:15.59	SUCCESS	0	0	0	\N	1202
2264	2025-10-11 21:05:36.971	2025-10-11 21:05:38.188	SUCCESS	0	0	0	\N	1217
2266	2025-10-11 21:06:36.971	2025-10-11 21:06:38.167	SUCCESS	0	0	0	\N	1196
2268	2025-10-11 21:07:36.972	2025-10-11 21:07:37.974	SUCCESS	0	0	0	\N	1002
2270	2025-10-11 21:08:51.176	2025-10-11 21:08:52.399	SUCCESS	0	0	0	\N	1223
2271	2025-10-11 21:08:57.768	2025-10-11 21:08:58.228	SUCCESS	0	0	0	\N	460
2272	2025-10-11 21:09:51.176	2025-10-11 21:09:52.418	SUCCESS	0	0	0	\N	1242
2273	2025-10-11 21:09:57.786	2025-10-11 21:10:00.206	SUCCESS	0	0	0	\N	2420
2274	2025-10-11 21:10:51.176	2025-10-11 21:10:52.313	SUCCESS	0	0	0	\N	1137
2275	2025-10-11 21:10:57.807	2025-10-11 21:11:00.384	SUCCESS	0	0	0	\N	2577
2276	2025-10-11 21:11:51.176	2025-10-11 21:11:52.63	SUCCESS	0	0	0	\N	1454
2277	2025-10-11 21:11:58.101	2025-10-11 21:12:00.384	SUCCESS	0	0	0	\N	2283
2278	2025-10-11 21:12:51.176	2025-10-11 21:12:52.4	SUCCESS	0	0	0	\N	1224
2279	2025-10-11 21:12:58.122	2025-10-11 21:13:01.385	SUCCESS	0	0	0	\N	3263
2280	2025-10-11 21:13:47.88	2025-10-11 21:13:48.934	SUCCESS	0	0	0	\N	1054
2281	2025-10-11 21:13:51.176	2025-10-11 21:13:52.676	SUCCESS	0	0	0	\N	1500
2282	2025-10-11 21:13:58.142	2025-10-11 21:14:00.685	SUCCESS	0	0	0	\N	2543
2284	2025-10-11 21:14:51.177	2025-10-11 21:14:52.423	SUCCESS	0	0	0	\N	1246
2283	2025-10-11 21:14:47.882	2025-10-11 21:14:50.706	SUCCESS	0	0	0	\N	2824
2285	2025-10-11 21:14:58.163	2025-10-11 21:15:02.785	SUCCESS	0	0	0	\N	4622
2286	2025-10-11 21:15:51.178	2025-10-11 21:15:52.62	SUCCESS	0	0	0	\N	1442
2288	2025-10-11 21:15:55.878	2025-10-11 21:15:56.335	SUCCESS	0	0	0	\N	457
2289	2025-10-11 21:15:58.17	2025-10-11 21:16:02.185	SUCCESS	0	0	0	\N	4015
2287	2025-10-11 21:15:47.886	2025-10-11 21:16:02.425	SUCCESS	0	0	0	\N	14539
2290	2025-10-11 21:16:47.887	\N	RUNNING	0	0	0	\N	\N
2291	2025-10-11 21:16:51.179	2025-10-11 21:16:52.376	SUCCESS	0	0	0	\N	1197
2292	2025-10-11 21:16:55.871	2025-10-11 21:16:57.128	SUCCESS	0	0	0	\N	1257
2293	2025-10-11 21:16:58.191	\N	RUNNING	0	0	0	\N	\N
2298	2025-10-11 21:18:47.92	2025-10-11 21:19:00.606	SUCCESS	0	0	0	\N	12686
2294	2025-10-11 21:17:51.18	2025-10-11 21:17:52.387	SUCCESS	0	0	0	\N	1207
2295	2025-10-11 21:17:47.893	2025-10-11 21:17:57.828	SUCCESS	0	0	0	\N	9935
2296	2025-10-11 21:17:55.871	2025-10-11 21:17:58.567	SUCCESS	0	0	0	\N	2696
2297	2025-10-11 21:18:51.181	2025-10-11 21:18:52.429	SUCCESS	0	0	0	\N	1248
2299	2025-10-11 21:18:56.067	2025-10-11 21:19:04.367	SUCCESS	0	0	0	\N	8300
2301	2025-10-11 21:19:51.182	2025-10-11 21:19:52.391	SUCCESS	0	0	0	\N	1209
2300	2025-10-11 21:19:47.927	2025-10-11 21:19:55.058	SUCCESS	0	0	0	\N	7131
2302	2025-10-11 21:19:56.093	2025-10-11 21:20:00.167	SUCCESS	0	0	0	\N	4074
2303	2025-10-11 21:20:51.183	2025-10-11 21:20:52.396	SUCCESS	0	0	0	\N	1213
2304	2025-10-11 21:20:56.092	2025-10-11 21:21:02.767	SUCCESS	0	0	0	\N	6675
2305	2025-10-11 21:21:51.182	2025-10-11 21:21:52.453	SUCCESS	0	0	0	\N	1271
2306	2025-10-11 21:21:56.093	2025-10-11 21:22:03.957	SUCCESS	0	0	0	\N	7864
2307	2025-10-11 21:22:51.183	2025-10-11 21:22:52.393	SUCCESS	0	0	0	\N	1210
2308	2025-10-11 21:22:56.098	2025-10-11 21:23:05.667	SUCCESS	0	0	0	\N	9569
2309	2025-10-11 21:23:51.183	2025-10-11 21:23:52.412	SUCCESS	0	0	0	\N	1229
2310	2025-10-11 21:23:56.099	2025-10-11 21:24:11.267	SUCCESS	0	0	0	\N	15168
2311	2025-10-11 21:24:51.184	2025-10-11 21:24:52.421	SUCCESS	0	0	0	\N	1237
2312	2025-10-11 21:24:56.104	2025-10-11 21:25:01.167	SUCCESS	0	0	0	\N	5063
2313	2025-10-11 21:25:51.183	2025-10-11 21:25:52.408	SUCCESS	0	0	0	\N	1225
2314	2025-10-11 21:25:56.109	2025-10-11 21:26:02.367	SUCCESS	0	0	0	\N	6258
2315	2025-10-11 21:26:51.183	2025-10-11 21:26:52.172	SUCCESS	0	0	0	\N	989
2316	2025-10-11 21:26:56.134	2025-10-11 21:27:00.867	SUCCESS	0	0	0	\N	4733
2317	2025-10-11 21:27:51.184	2025-10-11 21:27:52.407	SUCCESS	0	0	0	\N	1223
2318	2025-10-11 21:27:56.135	2025-10-11 21:27:59.267	SUCCESS	0	0	0	\N	3132
2319	2025-10-11 21:28:56.266	2025-10-11 21:28:59.006	SUCCESS	0	0	0	\N	2740
2320	2025-10-11 21:29:29.363	2025-10-11 21:29:30.614	SUCCESS	0	0	0	\N	1251
2321	2025-10-11 21:29:56.267	2025-10-11 21:29:57.867	SUCCESS	0	0	0	\N	1600
2322	2025-10-11 21:30:29.363	2025-10-11 21:30:30.357	SUCCESS	0	0	0	\N	994
2323	2025-10-11 21:30:56.271	2025-10-11 21:30:59.467	SUCCESS	0	0	0	\N	3196
2324	2025-10-11 21:31:56.272	2025-10-11 21:31:56.774	SUCCESS	0	0	0	\N	502
2325	2025-10-11 21:32:18.839	2025-10-11 21:32:19.855	SUCCESS	0	0	0	\N	1016
2326	2025-10-11 21:32:56.272	2025-10-11 21:32:57.134	SUCCESS	0	0	0	\N	862
2327	2025-10-11 21:33:18.838	2025-10-11 21:33:19.821	SUCCESS	0	0	0	\N	983
2329	2025-10-11 21:33:56.273	2025-10-11 21:33:56.749	SUCCESS	0	0	0	\N	476
2328	2025-10-11 21:33:50.759	2025-10-11 21:34:10.734	ERROR	0	0	0	Connection terminated due to connection timeout	19975
2330	2025-10-11 21:34:18.838	2025-10-11 21:34:19.81	SUCCESS	0	0	0	\N	972
2332	2025-10-11 21:34:56.273	2025-10-11 21:34:57.096	SUCCESS	0	0	0	\N	823
2331	2025-10-11 21:34:50.786	2025-10-11 21:35:01.955	SUCCESS	0	0	0	\N	11169
2333	2025-10-11 21:35:18.839	2025-10-11 21:35:19.916	SUCCESS	0	0	0	\N	1077
2335	2025-10-11 21:35:56.273	2025-10-11 21:35:56.876	SUCCESS	0	0	0	\N	603
2334	2025-10-11 21:35:50.794	2025-10-11 21:36:01.532	SUCCESS	0	0	0	\N	10738
2336	2025-10-11 21:36:18.839	2025-10-11 21:36:19.849	SUCCESS	0	0	0	\N	1010
2337	2025-10-11 21:37:51.335	2025-10-11 21:38:01.832	SUCCESS	0	0	0	\N	10497
2338	2025-10-11 21:38:02.861	2025-10-11 21:38:04.109	SUCCESS	0	0	0	\N	1248
2339	2025-10-11 21:38:51.344	2025-10-11 21:39:02.153	SUCCESS	0	0	0	\N	10809
2340	2025-10-11 21:39:02.86	2025-10-11 21:39:04.081	SUCCESS	0	0	0	\N	1221
2341	2025-10-11 21:39:51.363	2025-10-11 21:40:01.532	SUCCESS	0	0	0	\N	10169
2342	2025-10-11 21:40:02.861	2025-10-11 21:40:03.847	SUCCESS	0	0	0	\N	986
2343	2025-10-11 21:40:51.386	2025-10-11 21:40:58.232	SUCCESS	0	0	0	\N	6846
2344	2025-10-11 21:41:28.001	2025-10-11 21:41:28.987	SUCCESS	0	0	0	\N	986
2345	2025-10-11 21:41:51.386	2025-10-11 21:41:59.732	SUCCESS	0	0	0	\N	8346
2346	2025-10-11 21:42:28.001	2025-10-11 21:42:29.221	SUCCESS	0	0	0	\N	1220
2347	2025-10-11 21:42:51.401	2025-10-11 21:42:57.432	SUCCESS	0	0	0	\N	6031
2348	2025-10-11 21:43:28.001	2025-10-11 21:43:29.21	SUCCESS	0	0	0	\N	1209
2351	2025-10-11 21:44:51.401	2025-10-11 21:44:56.532	SUCCESS	0	0	0	\N	5131
2355	2025-10-11 21:46:51.414	2025-10-11 21:46:56.932	SUCCESS	0	0	0	\N	5518
2357	2025-10-11 21:47:51.42	2025-10-11 21:47:53.297	SUCCESS	0	0	0	\N	1877
2359	2025-10-11 21:48:51.432	2025-10-11 21:48:54.55	SUCCESS	0	0	0	\N	3118
2361	2025-10-11 21:49:51.432	2025-10-11 21:49:56.532	SUCCESS	0	0	0	\N	5100
2367	2025-10-11 21:52:52.932	2025-10-11 21:53:01.231	SUCCESS	0	0	0	\N	8299
2369	2025-10-11 21:53:53.033	2025-10-11 21:54:11.532	SUCCESS	0	0	0	\N	18499
2378	2025-10-11 21:57:55.678	2025-10-11 21:58:03.178	SUCCESS	0	0	0	\N	7500
2383	2025-10-11 22:00:55.679	2025-10-11 22:01:02.179	SUCCESS	0	0	0	\N	6500
2397	2025-10-11 22:07:56.079	2025-10-11 22:08:04.378	SUCCESS	0	0	0	\N	8299
2403	2025-10-11 22:10:56.178	2025-10-11 22:11:00.878	SUCCESS	0	0	0	\N	4700
2410	2025-10-11 22:13:29.202	2025-10-11 22:13:39.648	SUCCESS	0	0	0	\N	10446
2902	2025-10-12 09:35:26.606	2025-10-12 09:35:43.23	SUCCESS	0	0	0	\N	16624
2903	2025-10-12 09:36:26.635	2025-10-12 09:36:33.13	SUCCESS	0	0	0	\N	6495
2906	2025-10-12 09:39:26.721	2025-10-12 09:39:34.53	SUCCESS	0	0	0	\N	7809
2907	2025-10-12 09:40:26.75	2025-10-12 09:40:34.53	SUCCESS	0	0	0	\N	7780
2909	2025-10-12 09:42:26.805	2025-10-12 09:42:34.13	SUCCESS	0	0	0	\N	7325
2910	2025-10-12 09:43:26.832	2025-10-12 09:43:34.63	SUCCESS	0	0	0	\N	7798
2912	2025-10-12 09:45:26.885	2025-10-12 09:45:34.651	SUCCESS	0	0	0	\N	7766
2914	2025-10-12 09:47:26.937	2025-10-12 09:47:33.854	SUCCESS	0	0	0	\N	6917
2916	2025-10-12 09:49:26.976	2025-10-12 09:49:33.33	SUCCESS	0	0	0	\N	6354
2917	2025-10-12 09:50:27.001	2025-10-12 09:50:34.951	SUCCESS	0	0	0	\N	7950
2936	2025-10-12 10:10:21.888	2025-10-12 10:10:23.15	SUCCESS	0	0	0	\N	1262
2958	2025-10-12 10:21:21.892	2025-10-12 10:21:23.161	SUCCESS	0	0	0	\N	1269
2988	2025-10-12 10:34:58.707	2025-10-12 10:34:59.707	SUCCESS	0	0	0	\N	1000
3007	2025-10-12 10:44:56.102	2025-10-12 10:44:58.33	SUCCESS	1	0	0	\N	2228
3009	2025-10-12 10:45:56.102	2025-10-12 10:45:58.092	SUCCESS	0	0	0	\N	1990
3011	2025-10-12 10:46:56.102	2025-10-12 10:47:00.209	SUCCESS	0	0	0	\N	4107
3028	2025-10-12 10:55:56.104	2025-10-12 10:55:59.575	SUCCESS	1	0	1	\N	3471
3040	2025-10-12 11:08:34.149	2025-10-12 11:08:35.4	SUCCESS	0	0	0	\N	1251
3054	2025-10-12 11:15:39.048	2025-10-12 11:15:44.77	SUCCESS	1	0	0	\N	5722
3087	2025-10-12 11:23:43.47	2025-10-12 11:23:44.628	SUCCESS	0	0	0	\N	1158
3112	2025-10-12 11:32:43.472	2025-10-12 11:32:44.502	SUCCESS	0	0	0	\N	1030
3135	2025-10-12 11:43:00.854	2025-10-12 11:43:09.645	SUCCESS	2	0	2	\N	8791
2349	2025-10-11 21:43:51.4	2025-10-11 21:43:52.453	SUCCESS	0	0	0	\N	1053
2350	2025-10-11 21:44:28.001	2025-10-11 21:44:29.009	SUCCESS	0	0	0	\N	1008
2352	2025-10-11 21:45:28.002	2025-10-11 21:45:29.001	SUCCESS	0	0	0	\N	999
2353	2025-10-11 21:45:51.406	2025-10-11 21:46:00.357	SUCCESS	0	0	0	\N	8951
2354	2025-10-11 21:46:28.003	2025-10-11 21:46:29.214	SUCCESS	0	0	0	\N	1211
2356	2025-10-11 21:47:35.847	2025-10-11 21:47:37.376	SUCCESS	0	0	0	\N	1529
2358	2025-10-11 21:48:35.854	2025-10-11 21:48:37.128	SUCCESS	0	0	0	\N	1274
2360	2025-10-11 21:49:35.847	2025-10-11 21:49:37.298	SUCCESS	0	0	0	\N	1451
2362	2025-10-11 21:50:35.847	2025-10-11 21:50:37.135	SUCCESS	0	0	0	\N	1288
2363	2025-10-11 21:50:51.933	2025-10-11 21:50:54.654	SUCCESS	0	0	0	\N	2721
2364	2025-10-11 21:51:35.848	2025-10-11 21:51:39.008	SUCCESS	1	0	1	\N	3160
2365	2025-10-11 21:51:52.632	2025-10-11 21:52:01.332	SUCCESS	0	0	0	\N	8700
2366	2025-10-11 21:52:35.848	2025-10-11 21:52:37.05	SUCCESS	0	0	0	\N	1202
2368	2025-10-11 21:53:35.847	2025-10-11 21:53:37.316	SUCCESS	0	0	0	\N	1469
2370	2025-10-11 21:54:35.847	2025-10-11 21:54:36.845	SUCCESS	0	0	0	\N	998
2371	2025-10-11 21:54:53.334	2025-10-11 21:55:01.732	SUCCESS	0	0	0	\N	8398
2372	2025-10-11 21:54:55.214	2025-10-11 21:55:05.578	SUCCESS	0	0	0	\N	10364
2373	2025-10-11 21:55:35.847	2025-10-11 21:55:36.881	SUCCESS	0	0	0	\N	1034
2374	2025-10-11 21:55:53.532	2025-10-11 21:56:05.332	SUCCESS	0	0	0	\N	11800
2375	2025-10-11 21:56:35.847	2025-10-11 21:56:36.834	SUCCESS	0	0	0	\N	987
2376	2025-10-11 21:56:53.532	2025-10-11 21:56:57.218	SUCCESS	0	0	0	\N	3686
2377	2025-10-11 21:56:55.677	2025-10-11 21:57:04.078	SUCCESS	0	0	0	\N	8401
2379	2025-10-11 21:58:21.159	2025-10-11 21:58:22.175	SUCCESS	0	0	0	\N	1016
2380	2025-10-11 21:58:55.679	2025-10-11 21:59:06.378	SUCCESS	0	0	0	\N	10699
2381	2025-10-11 21:59:55.679	2025-10-11 22:00:05.678	SUCCESS	0	0	0	\N	9999
2382	2025-10-11 22:00:11.341	2025-10-11 22:00:12.611	SUCCESS	0	0	0	\N	1270
2384	2025-10-11 22:01:11.34	2025-10-11 22:01:12.331	SUCCESS	0	0	0	\N	991
2387	2025-10-11 22:02:55.68	2025-10-11 22:03:08.682	SUCCESS	0	0	0	\N	13002
2389	2025-10-11 22:03:55.68	2025-10-11 22:03:57.679	SUCCESS	0	0	0	\N	1999
2391	2025-10-11 22:04:56.078	2025-10-11 22:05:01.078	SUCCESS	0	0	0	\N	5000
2393	2025-10-11 22:05:56.079	2025-10-11 22:06:00.68	SUCCESS	0	0	0	\N	4601
2399	2025-10-11 22:08:56.08	2025-10-11 22:09:05.478	SUCCESS	0	0	0	\N	9398
2401	2025-10-11 22:09:56.177	2025-10-11 22:10:05.778	SUCCESS	0	0	0	\N	9601
2405	2025-10-11 22:11:56.178	2025-10-11 22:11:57.478	SUCCESS	0	0	0	\N	1300
2407	2025-10-11 22:12:29.202	2025-10-11 22:12:33.204	SUCCESS	0	0	0	\N	4002
2408	2025-10-11 22:12:56.179	2025-10-11 22:13:01.978	SUCCESS	0	0	0	\N	5799
2412	2025-10-11 22:14:29.209	2025-10-11 22:14:35.961	SUCCESS	0	0	0	\N	6752
2414	2025-10-11 22:15:29.247	2025-10-11 22:15:38.448	SUCCESS	0	0	0	\N	9201
2416	2025-10-11 22:17:03.145	2025-10-11 22:17:13.47	SUCCESS	0	0	0	\N	10325
2418	2025-10-11 22:17:29.214	2025-10-11 22:17:39.647	SUCCESS	0	0	0	\N	10433
2435	2025-10-11 22:26:03.243	2025-10-11 22:26:08.869	SUCCESS	0	0	0	\N	5626
2904	2025-10-12 09:37:26.663	2025-10-12 09:37:34.43	SUCCESS	0	0	0	\N	7767
2905	2025-10-12 09:38:26.69	2025-10-12 09:38:33.657	SUCCESS	0	0	0	\N	6967
2908	2025-10-12 09:41:26.777	2025-10-12 09:41:35.23	SUCCESS	0	0	0	\N	8453
2911	2025-10-12 09:44:26.858	2025-10-12 09:44:34.63	SUCCESS	0	0	0	\N	7772
2913	2025-10-12 09:46:26.911	2025-10-12 09:46:32.33	SUCCESS	0	0	0	\N	5419
2915	2025-10-12 09:48:26.962	2025-10-12 09:48:35.53	SUCCESS	0	0	0	\N	8568
2918	2025-10-12 09:51:27.026	2025-10-12 09:51:28.013	SUCCESS	0	0	0	\N	987
2937	2025-10-12 10:11:21.888	2025-10-12 10:11:22.889	SUCCESS	0	0	0	\N	1001
2939	2025-10-12 10:12:21.888	2025-10-12 10:12:22.92	SUCCESS	0	0	0	\N	1032
2959	2025-10-12 10:22:21.892	2025-10-12 10:22:23.176	SUCCESS	0	0	0	\N	1284
2990	2025-10-12 10:35:58.708	2025-10-12 10:35:59.73	SUCCESS	0	0	0	\N	1022
3013	2025-10-12 10:47:56.103	2025-10-12 10:47:57.097	SUCCESS	0	0	0	\N	994
3029	2025-10-12 10:56:56.105	2025-10-12 10:56:59.596	SUCCESS	1	0	1	\N	3491
3041	2025-10-12 11:09:34.149	2025-10-12 11:09:35.601	SUCCESS	0	0	0	\N	1452
3058	2025-10-12 11:16:35.793	2025-10-12 11:16:56.536	SUCCESS	1	0	1	\N	20743
3085	2025-10-12 11:23:31.569	2025-10-12 11:23:35.546	SUCCESS	0	0	0	\N	3977
3084	2025-10-12 11:23:29.943	2025-10-12 11:23:38.634	SUCCESS	0	0	0	\N	8691
3090	2025-10-12 11:24:35.967	2025-10-12 11:24:39.057	SUCCESS	0	0	0	\N	3090
3091	2025-10-12 11:24:43.47	2025-10-12 11:24:44.712	SUCCESS	0	0	0	\N	1242
3092	2025-10-12 11:25:29.995	2025-10-12 11:25:35.234	SUCCESS	0	0	0	\N	5239
3093	2025-10-12 11:25:31.612	2025-10-12 11:25:35.545	SUCCESS	0	0	0	\N	3933
3094	2025-10-12 11:25:35.99	2025-10-12 11:25:40.357	SUCCESS	0	0	0	\N	4367
3100	2025-10-12 11:27:30.022	2025-10-12 11:27:37.134	SUCCESS	0	0	0	\N	7112
3115	2025-10-12 11:33:43.472	2025-10-12 11:33:44.699	SUCCESS	0	0	0	\N	1227
3137	2025-10-12 11:44:00.854	2025-10-12 11:44:01.845	SUCCESS	0	0	0	\N	991
2385	2025-10-11 22:01:55.679	2025-10-11 22:02:08.078	SUCCESS	0	0	0	\N	12399
2386	2025-10-11 22:02:11.341	2025-10-11 22:02:12.779	SUCCESS	0	0	0	\N	1438
2388	2025-10-11 22:03:11.341	2025-10-11 22:03:12.763	SUCCESS	0	0	0	\N	1422
2390	2025-10-11 22:04:11.341	2025-10-11 22:04:12.851	SUCCESS	0	0	0	\N	1510
2392	2025-10-11 22:05:11.341	2025-10-11 22:05:12.808	SUCCESS	0	0	0	\N	1467
2394	2025-10-11 22:06:11.342	2025-10-11 22:06:12.835	SUCCESS	0	0	0	\N	1493
2395	2025-10-11 22:06:56.08	2025-10-11 22:07:01.879	SUCCESS	0	0	0	\N	5799
2396	2025-10-11 22:07:11.342	2025-10-11 22:07:12.803	SUCCESS	0	0	0	\N	1461
2398	2025-10-11 22:08:11.342	2025-10-11 22:08:12.768	SUCCESS	0	0	0	\N	1426
2400	2025-10-11 22:09:11.342	2025-10-11 22:09:12.359	SUCCESS	0	0	0	\N	1017
2402	2025-10-11 22:10:11.343	2025-10-11 22:10:12.815	SUCCESS	0	0	0	\N	1472
2404	2025-10-11 22:11:11.345	2025-10-11 22:11:12.802	SUCCESS	0	0	0	\N	1457
2406	2025-10-11 22:12:11.345	2025-10-11 22:12:12.569	SUCCESS	0	0	0	\N	1224
2409	2025-10-11 22:13:11.345	2025-10-11 22:13:12.787	SUCCESS	0	0	0	\N	1442
2411	2025-10-11 22:14:11.346	2025-10-11 22:14:12.632	SUCCESS	0	0	0	\N	1286
2413	2025-10-11 22:15:11.345	2025-10-11 22:15:12.576	SUCCESS	0	0	0	\N	1231
2415	2025-10-11 22:16:11.345	2025-10-11 22:16:12.807	SUCCESS	0	0	0	\N	1462
2417	2025-10-11 22:17:11.346	2025-10-11 22:17:13.63	SUCCESS	0	0	0	\N	2284
2419	2025-10-11 22:18:03.151	2025-10-11 22:18:13.769	SUCCESS	0	0	0	\N	10618
2420	2025-10-11 22:18:29.221	2025-10-11 22:18:41.073	SUCCESS	0	0	0	\N	11852
2421	2025-10-11 22:19:03.153	2025-10-11 22:19:09.971	SUCCESS	0	0	0	\N	6818
2422	2025-10-11 22:19:10.505	2025-10-11 22:19:11.924	SUCCESS	0	0	0	\N	1419
2423	2025-10-11 22:19:29.221	2025-10-11 22:19:38.652	SUCCESS	0	0	0	\N	9431
2425	2025-10-11 22:20:10.505	2025-10-11 22:20:11.471	SUCCESS	0	0	0	\N	966
2424	2025-10-11 22:20:03.158	2025-10-11 22:20:15.569	SUCCESS	0	0	0	\N	12411
2426	2025-10-11 22:21:03.158	2025-10-11 22:21:06.869	SUCCESS	0	0	0	\N	3711
2427	2025-10-11 22:21:10.505	2025-10-11 22:21:11.765	SUCCESS	0	0	0	\N	1260
2428	2025-10-11 22:22:03.176	2025-10-11 22:22:14.969	SUCCESS	0	0	0	\N	11793
2430	2025-10-11 22:23:08.512	2025-10-11 22:23:10.025	SUCCESS	0	0	0	\N	1513
2429	2025-10-11 22:23:03.193	2025-10-11 22:23:09.871	SUCCESS	0	0	0	\N	6678
2432	2025-10-11 22:24:08.511	2025-10-11 22:24:10.134	SUCCESS	0	0	0	\N	1623
2431	2025-10-11 22:24:03.21	2025-10-11 22:24:12.869	SUCCESS	0	0	0	\N	9659
2433	2025-10-11 22:25:03.225	2025-10-11 22:25:08.47	SUCCESS	0	0	0	\N	5245
2434	2025-10-11 22:25:08.512	2025-10-11 22:25:09.964	SUCCESS	0	0	0	\N	1452
2436	2025-10-11 22:26:08.513	2025-10-11 22:26:09.53	SUCCESS	0	0	0	\N	1017
2437	2025-10-11 22:27:03.243	2025-10-11 22:27:05.969	SUCCESS	0	0	0	\N	2726
2438	2025-10-11 22:27:08.514	2025-10-11 22:27:09.755	SUCCESS	0	0	0	\N	1241
2439	2025-10-11 22:28:03.258	2025-10-11 22:28:08.971	SUCCESS	0	0	0	\N	5713
2440	2025-10-11 22:28:08.515	2025-10-11 22:28:09.729	SUCCESS	0	0	0	\N	1214
2442	2025-10-11 22:29:08.516	2025-10-11 22:29:10.321	SUCCESS	0	0	0	\N	1805
2441	2025-10-11 22:29:03.262	2025-10-11 22:29:10.17	SUCCESS	0	0	0	\N	6908
2444	2025-10-11 22:30:08.517	2025-10-11 22:30:09.544	SUCCESS	0	0	0	\N	1027
2443	2025-10-11 22:30:03.279	2025-10-11 22:30:13.069	SUCCESS	0	0	0	\N	9790
2445	2025-10-11 22:30:47.579	2025-10-11 22:30:57.078	SUCCESS	0	0	0	\N	9499
2446	2025-10-11 22:31:03.296	2025-10-11 22:31:05.972	SUCCESS	0	0	0	\N	2676
2447	2025-10-11 22:31:08.518	2025-10-11 22:31:09.554	SUCCESS	0	0	0	\N	1036
2448	2025-10-11 22:31:47.584	2025-10-11 22:31:53.387	SUCCESS	0	0	0	\N	5803
2449	2025-10-11 22:32:03.306	2025-10-11 22:32:06.97	SUCCESS	0	0	0	\N	3664
2450	2025-10-11 22:32:08.519	2025-10-11 22:32:09.755	SUCCESS	0	0	0	\N	1236
2451	2025-10-11 22:32:47.592	2025-10-11 22:32:55.377	SUCCESS	0	0	0	\N	7785
2452	2025-10-11 22:33:08.519	2025-10-11 22:33:09.726	SUCCESS	0	0	0	\N	1207
2453	2025-10-11 22:33:47.593	2025-10-11 22:33:55.399	SUCCESS	0	0	0	\N	7806
2454	2025-10-11 22:34:08.519	2025-10-11 22:34:09.511	SUCCESS	0	0	0	\N	992
2455	2025-10-11 22:34:47.594	2025-10-11 22:34:52.677	SUCCESS	0	0	0	\N	5083
2456	2025-10-11 22:35:47.605	2025-10-11 22:35:55.883	SUCCESS	0	0	0	\N	8278
2457	2025-10-11 22:36:28.007	2025-10-11 22:36:29.265	SUCCESS	0	0	0	\N	1258
2458	2025-10-11 22:36:47.606	2025-10-11 22:36:53.578	SUCCESS	0	0	0	\N	5972
2459	2025-10-11 22:37:28.007	2025-10-11 22:37:29.279	SUCCESS	0	0	0	\N	1272
2460	2025-10-11 22:37:47.777	2025-10-11 22:37:54.878	SUCCESS	0	0	0	\N	7101
2461	2025-10-11 22:38:28.008	2025-10-11 22:38:29.237	SUCCESS	0	0	0	\N	1229
2462	2025-10-11 22:38:47.78	2025-10-11 22:38:49.512	SUCCESS	0	0	0	\N	1732
2463	2025-10-11 22:39:28.009	2025-10-11 22:39:29.233	SUCCESS	0	0	0	\N	1224
2464	2025-10-11 22:39:47.78	2025-10-11 22:39:55.277	SUCCESS	0	0	0	\N	7497
2465	2025-10-11 22:40:28.009	2025-10-11 22:40:29.229	SUCCESS	0	0	0	\N	1220
2466	2025-10-11 22:40:47.797	2025-10-11 22:40:54.477	SUCCESS	0	0	0	\N	6680
2467	2025-10-11 22:41:28.008	2025-10-11 22:41:29.246	SUCCESS	0	0	0	\N	1238
2468	2025-10-11 22:41:47.814	2025-10-11 22:41:56.301	SUCCESS	0	0	0	\N	8487
2469	2025-10-11 22:42:28.008	2025-10-11 22:42:29.266	SUCCESS	0	0	0	\N	1258
2470	2025-10-11 22:42:47.831	2025-10-11 22:42:52.678	SUCCESS	0	0	0	\N	4847
2471	2025-10-11 22:43:13.14	2025-10-11 22:43:26.039	SUCCESS	0	0	0	\N	12899
2472	2025-10-11 22:43:28.008	2025-10-11 22:43:29.192	SUCCESS	0	0	0	\N	1184
2473	2025-10-11 22:43:47.848	2025-10-11 22:43:54.977	SUCCESS	0	0	0	\N	7129
2474	2025-10-11 22:44:13.168	2025-10-11 22:44:24.139	ERROR	0	0	0	Connection terminated due to connection timeout	10971
2475	2025-10-11 22:44:28.008	2025-10-11 22:44:29.263	SUCCESS	0	0	0	\N	1255
2476	2025-10-11 22:45:13.195	2025-10-11 22:45:22.739	SUCCESS	0	0	0	\N	9544
2477	2025-10-11 22:45:28.008	2025-10-11 22:45:29.285	SUCCESS	0	0	0	\N	1277
2478	2025-10-11 22:46:13.223	2025-10-11 22:46:23.039	SUCCESS	0	0	0	\N	9816
2479	2025-10-11 22:46:28.009	2025-10-11 22:46:29.262	SUCCESS	0	0	0	\N	1253
2480	2025-10-11 22:47:13.236	2025-10-11 22:47:22.116	SUCCESS	0	0	0	\N	8880
2481	2025-10-11 22:47:28.01	2025-10-11 22:47:29.458	SUCCESS	0	0	0	\N	1448
2482	2025-10-11 22:48:13.265	2025-10-11 22:48:23.94	SUCCESS	0	0	0	\N	10675
2483	2025-10-11 22:48:28.011	2025-10-11 22:48:30.626	SUCCESS	0	0	0	\N	2615
2484	2025-10-11 22:49:13.292	2025-10-11 22:49:24.039	SUCCESS	0	0	0	\N	10747
2485	2025-10-11 22:49:28.012	2025-10-11 22:49:29.248	SUCCESS	0	0	0	\N	1236
2486	2025-10-11 22:50:13.318	2025-10-11 22:50:25.94	SUCCESS	0	0	0	\N	12622
2487	2025-10-11 22:50:28.012	2025-10-11 22:50:29.484	SUCCESS	0	0	0	\N	1472
2488	2025-10-11 22:51:13.346	2025-10-11 22:51:23.039	SUCCESS	0	0	0	\N	9693
2489	2025-10-11 22:51:28.013	2025-10-11 22:51:29.234	SUCCESS	0	0	0	\N	1221
2490	2025-10-11 22:52:13.372	2025-10-11 22:52:24.039	SUCCESS	0	0	0	\N	10667
2491	2025-10-11 22:52:28.014	2025-10-11 22:52:29.021	SUCCESS	0	0	0	\N	1007
2492	2025-10-11 22:53:13.373	2025-10-11 22:53:16.644	SUCCESS	0	0	0	\N	3271
2493	2025-10-11 22:53:28.015	2025-10-11 22:53:31.247	SUCCESS	0	0	0	\N	3232
2919	2025-10-12 09:56:02.354	2025-10-12 09:56:11.675	SUCCESS	0	0	0	\N	9321
2920	2025-10-12 09:57:02.361	2025-10-12 09:57:11.991	SUCCESS	0	0	0	\N	9630
2928	2025-10-12 10:05:02.489	2025-10-12 10:05:08.769	SUCCESS	1	0	0	\N	6280
2930	2025-10-12 10:07:20.28	2025-10-12 10:07:25.149	SUCCESS	0	0	0	\N	4869
2938	2025-10-12 10:11:20.313	2025-10-12 10:11:29.749	SUCCESS	0	0	0	\N	9436
2941	2025-10-12 10:13:20.369	2025-10-12 10:13:35.27	SUCCESS	1	0	1	\N	14901
2944	2025-10-12 10:14:20.377	2025-10-12 10:14:29.055	SUCCESS	0	0	0	\N	8678
2946	2025-10-12 10:15:20.405	2025-10-12 10:15:24.748	SUCCESS	0	0	0	\N	4343
2948	2025-10-12 10:16:20.432	2025-10-12 10:16:28.39	SUCCESS	0	0	0	\N	7958
2950	2025-10-12 10:17:20.447	2025-10-12 10:17:28.949	SUCCESS	0	0	0	\N	8502
2957	2025-10-12 10:21:20.522	2025-10-12 10:21:29.649	SUCCESS	0	0	0	\N	9127
2961	2025-10-12 10:23:21.897	2025-10-12 10:23:23.15	SUCCESS	0	0	0	\N	1253
2977	2025-10-12 10:30:20.728	2025-10-12 10:30:25.449	SUCCESS	0	0	0	\N	4721
2978	2025-10-12 10:31:20.743	2025-10-12 10:31:26.449	SUCCESS	0	0	0	\N	5706
2981	2025-10-12 10:32:20.767	2025-10-12 10:32:27.669	SUCCESS	0	0	0	\N	6902
2985	2025-10-12 10:33:51.211	2025-10-12 10:33:57.132	SUCCESS	0	0	0	\N	5921
2989	2025-10-12 10:35:51.256	2025-10-12 10:35:57.253	SUCCESS	0	0	0	\N	5997
2992	2025-10-12 10:36:58.709	2025-10-12 10:36:59.999	SUCCESS	0	0	0	\N	1290
2993	2025-10-12 10:37:51.307	2025-10-12 10:37:57.432	SUCCESS	0	0	0	\N	6125
2996	2025-10-12 10:39:51.357	2025-10-12 10:39:58.458	SUCCESS	0	0	0	\N	7101
3015	2025-10-12 10:48:56.103	2025-10-12 10:48:57.09	SUCCESS	0	0	0	\N	987
3030	2025-10-12 10:57:56.105	2025-10-12 10:57:59.577	SUCCESS	1	0	1	\N	3472
3042	2025-10-12 11:10:34.149	2025-10-12 11:10:35.434	SUCCESS	0	0	0	\N	1285
3059	2025-10-12 11:16:39.048	2025-10-12 11:16:45.098	SUCCESS	1	0	0	\N	6050
3095	2025-10-12 11:25:43.471	2025-10-12 11:25:44.459	SUCCESS	0	0	0	\N	988
3118	2025-10-12 11:34:43.472	2025-10-12 11:34:46.565	SUCCESS	1	0	1	\N	3093
3139	2025-10-12 11:45:00.854	2025-10-12 11:45:02.888	SUCCESS	0	0	0	\N	2034
2494	2025-10-11 22:54:13.375	2025-10-11 22:54:22.539	SUCCESS	0	0	0	\N	9164
2495	2025-10-11 22:54:28.015	2025-10-11 22:54:29.262	SUCCESS	0	0	0	\N	1247
2498	2025-10-11 22:55:43.861	2025-10-11 22:55:57.397	SUCCESS	0	0	0	\N	13536
2499	2025-10-11 22:56:13.388	2025-10-11 22:56:23.439	SUCCESS	0	0	0	\N	10051
2921	2025-10-12 09:58:02.387	2025-10-12 09:58:09.471	SUCCESS	0	0	0	\N	7084
2924	2025-10-12 10:01:02.463	2025-10-12 10:01:12.071	SUCCESS	0	0	0	\N	9608
2942	2025-10-12 10:13:21.889	2025-10-12 10:13:25.114	SUCCESS	1	0	1	\N	3225
2943	2025-10-12 10:14:21.889	2025-10-12 10:14:22.92	SUCCESS	0	0	0	\N	1031
2963	2025-10-12 10:24:21.897	2025-10-12 10:24:22.873	SUCCESS	0	0	0	\N	976
2994	2025-10-12 10:37:58.71	2025-10-12 10:37:59.706	SUCCESS	0	0	0	\N	996
3017	2025-10-12 10:49:56.103	2025-10-12 10:49:57.147	SUCCESS	0	0	0	\N	1044
3031	2025-10-12 10:58:56.106	2025-10-12 10:58:57.338	SUCCESS	0	0	0	\N	1232
3032	2025-10-12 10:59:56.107	2025-10-12 10:59:57.328	SUCCESS	0	0	0	\N	1221
3043	2025-10-12 11:11:34.149	2025-10-12 11:11:35.16	SUCCESS	0	0	0	\N	1011
3063	2025-10-12 11:17:39.051	2025-10-12 11:17:40.114	SUCCESS	0	0	0	\N	1063
3099	2025-10-12 11:26:43.471	2025-10-12 11:26:44.456	SUCCESS	0	0	0	\N	985
3122	2025-10-12 11:36:29.686	2025-10-12 11:36:32.668	SUCCESS	1	0	1	\N	2982
2496	2025-10-11 22:55:13.382	2025-10-11 22:55:24.039	SUCCESS	0	0	0	\N	10657
2497	2025-10-11 22:55:28.014	2025-10-11 22:55:29.239	SUCCESS	0	0	0	\N	1225
2500	2025-10-11 22:56:28.015	2025-10-11 22:56:29.221	SUCCESS	0	0	0	\N	1206
2501	2025-10-11 22:56:43.863	2025-10-11 22:56:53.097	SUCCESS	0	0	0	\N	9234
2502	2025-10-11 22:57:13.409	2025-10-11 22:57:24.539	SUCCESS	0	0	0	\N	11130
2503	2025-10-11 22:57:28.015	2025-10-11 22:57:29.227	SUCCESS	0	0	0	\N	1212
2504	2025-10-11 22:57:43.891	2025-10-11 22:57:53.497	SUCCESS	0	0	0	\N	9606
2505	2025-10-11 22:58:13.432	2025-10-11 22:58:24.45	SUCCESS	0	0	0	\N	11018
2506	2025-10-11 22:58:28.015	2025-10-11 22:58:29.241	SUCCESS	0	0	0	\N	1226
2507	2025-10-11 22:58:43.891	2025-10-11 22:58:47.4	SUCCESS	0	0	0	\N	3509
2508	2025-10-11 22:59:28.015	2025-10-11 22:59:29.244	SUCCESS	0	0	0	\N	1229
2509	2025-10-11 22:59:43.895	2025-10-11 22:59:51.897	SUCCESS	0	0	0	\N	8002
2510	2025-10-11 23:00:28.016	2025-10-11 23:00:29.476	SUCCESS	0	0	0	\N	1460
2511	2025-10-11 23:00:43.903	2025-10-11 23:00:52.397	SUCCESS	0	0	0	\N	8494
2512	2025-10-11 23:01:28.017	2025-10-11 23:01:29.468	SUCCESS	0	0	0	\N	1451
2513	2025-10-11 23:01:43.902	2025-10-11 23:01:47.297	SUCCESS	0	0	0	\N	3395
2514	2025-10-11 23:02:28.018	2025-10-11 23:02:29.34	SUCCESS	0	0	0	\N	1322
2515	2025-10-11 23:03:44.021	2025-10-11 23:03:52.398	SUCCESS	0	0	0	\N	8377
2516	2025-10-11 23:03:54.226	2025-10-11 23:03:58.907	SUCCESS	0	0	0	\N	4681
2517	2025-10-11 23:04:44.046	2025-10-11 23:04:51.197	SUCCESS	0	0	0	\N	7151
2518	2025-10-11 23:04:54.224	2025-10-11 23:04:55.496	SUCCESS	0	0	0	\N	1272
2519	2025-10-11 23:05:44.072	2025-10-11 23:05:50.097	SUCCESS	0	0	0	\N	6025
2520	2025-10-11 23:05:54.224	2025-10-11 23:05:55.41	SUCCESS	0	0	0	\N	1186
2521	2025-10-11 23:06:44.096	2025-10-11 23:06:50.698	SUCCESS	0	0	0	\N	6602
2522	2025-10-11 23:06:54.227	2025-10-11 23:06:55.908	SUCCESS	0	0	0	\N	1681
2523	2025-10-11 23:07:44.121	2025-10-11 23:07:51.097	SUCCESS	0	0	0	\N	6976
2524	2025-10-11 23:08:44.146	2025-10-11 23:08:51.597	SUCCESS	0	0	0	\N	7451
2525	2025-10-11 23:09:11.276	2025-10-11 23:09:12.486	SUCCESS	0	0	0	\N	1210
2526	2025-10-11 23:09:44.151	2025-10-11 23:09:45.893	SUCCESS	0	0	0	\N	1742
2527	2025-10-11 23:10:11.276	2025-10-11 23:10:12.799	SUCCESS	0	0	0	\N	1523
2528	2025-10-11 23:10:44.155	2025-10-11 23:10:51.197	SUCCESS	0	0	0	\N	7042
2529	2025-10-11 23:11:11.277	2025-10-11 23:11:12.546	SUCCESS	0	0	0	\N	1269
2530	2025-10-11 23:11:44.155	2025-10-11 23:12:02.121	ERROR	0	0	0	Connection terminated due to connection timeout	17966
2531	2025-10-11 23:12:47.499	2025-10-11 23:12:55.797	SUCCESS	0	0	0	\N	8298
2532	2025-10-11 23:13:04.634	2025-10-11 23:13:08.382	SUCCESS	0	0	0	\N	3748
2533	2025-10-11 23:14:04.634	2025-10-11 23:14:06.113	SUCCESS	0	0	0	\N	1479
2534	2025-10-11 23:14:04.887	2025-10-11 23:14:15.469	SUCCESS	0	0	0	\N	10582
2535	2025-10-11 23:14:49.505	2025-10-11 23:14:57.697	SUCCESS	0	0	0	\N	8192
2536	2025-10-11 23:15:04.635	2025-10-11 23:15:06.087	SUCCESS	0	0	0	\N	1452
2537	2025-10-11 23:15:49.519	2025-10-11 23:15:56.197	SUCCESS	0	0	0	\N	6678
2538	2025-10-11 23:16:04.636	2025-10-11 23:16:06.053	SUCCESS	0	0	0	\N	1417
2539	2025-10-11 23:16:04.922	2025-10-11 23:16:14.569	SUCCESS	0	0	0	\N	9647
2540	2025-10-11 23:16:49.547	2025-10-11 23:16:54.798	SUCCESS	0	0	0	\N	5251
2541	2025-10-11 23:17:04.637	2025-10-11 23:17:05.686	SUCCESS	0	0	0	\N	1049
2542	2025-10-11 23:17:04.925	2025-10-11 23:17:09.669	SUCCESS	0	0	0	\N	4744
2543	2025-10-11 23:18:04.638	2025-10-11 23:18:05.685	SUCCESS	0	0	0	\N	1047
2544	2025-10-11 23:18:04.927	2025-10-11 23:18:12.768	SUCCESS	0	0	0	\N	7841
2545	2025-10-11 23:19:04.638	2025-10-11 23:19:05.635	SUCCESS	0	0	0	\N	997
2546	2025-10-11 23:19:04.954	2025-10-11 23:19:15.769	SUCCESS	0	0	0	\N	10815
2547	2025-10-11 23:20:04.638	2025-10-11 23:20:05.662	SUCCESS	0	0	0	\N	1024
2548	2025-10-11 23:20:04.968	2025-10-11 23:20:10.469	SUCCESS	0	0	0	\N	5501
2549	2025-10-11 23:21:04.639	2025-10-11 23:21:05.643	SUCCESS	0	0	0	\N	1004
2550	2025-10-11 23:21:04.995	2025-10-11 23:21:13.068	SUCCESS	0	0	0	\N	8073
2551	2025-10-11 23:22:04.638	2025-10-11 23:22:05.844	SUCCESS	0	0	0	\N	1206
2552	2025-10-11 23:22:05.021	2025-10-11 23:22:09.481	SUCCESS	0	0	0	\N	4460
2553	2025-10-11 23:22:28.257	2025-10-11 23:22:38.232	SUCCESS	0	0	0	\N	9975
2554	2025-10-11 23:23:04.638	2025-10-11 23:23:06.108	SUCCESS	0	0	0	\N	1470
2555	2025-10-11 23:23:28.283	2025-10-11 23:23:37.132	SUCCESS	0	0	0	\N	8849
2556	2025-10-11 23:24:04.639	2025-10-11 23:24:05.883	SUCCESS	0	0	0	\N	1244
2557	2025-10-11 23:24:28.305	2025-10-11 23:24:39.431	SUCCESS	0	0	0	\N	11126
2559	2025-10-11 23:25:31.231	2025-10-11 23:25:32.259	SUCCESS	0	0	0	\N	1028
2558	2025-10-11 23:25:28.325	2025-10-11 23:25:39.231	SUCCESS	0	0	0	\N	10906
2561	2025-10-11 23:26:31.232	2025-10-11 23:26:33.428	SUCCESS	0	0	0	\N	2196
2560	2025-10-11 23:26:28.327	2025-10-11 23:26:33.531	SUCCESS	0	0	0	\N	5204
2563	2025-10-11 23:27:31.232	2025-10-11 23:27:32.268	SUCCESS	0	0	0	\N	1036
2562	2025-10-11 23:27:28.352	2025-10-11 23:27:38.232	SUCCESS	0	0	0	\N	9880
2565	2025-10-11 23:28:31.235	2025-10-11 23:28:32.461	SUCCESS	0	0	0	\N	1226
2564	2025-10-11 23:28:28.377	2025-10-11 23:28:40.131	ERROR	0	0	0	Connection terminated due to connection timeout	11754
2566	2025-10-11 23:29:28.402	2025-10-11 23:29:37.531	SUCCESS	0	0	0	\N	9129
2567	2025-10-11 23:30:28.403	2025-10-11 23:30:31.702	SUCCESS	0	0	0	\N	3299
2568	2025-10-11 23:31:06.939	2025-10-11 23:31:07.948	SUCCESS	0	0	0	\N	1009
2569	2025-10-11 23:31:28.404	2025-10-11 23:31:44.931	SUCCESS	0	0	0	\N	16527
2570	2025-10-11 23:32:06.939	2025-10-11 23:32:08.152	SUCCESS	0	0	0	\N	1213
2571	2025-10-11 23:32:28.424	2025-10-11 23:32:38.631	SUCCESS	0	0	0	\N	10207
2572	2025-10-11 23:33:06.938	2025-10-11 23:33:08.153	SUCCESS	0	0	0	\N	1215
2573	2025-10-11 23:33:28.437	2025-10-11 23:33:34.031	SUCCESS	0	0	0	\N	5594
2574	2025-10-11 23:34:06.938	2025-10-11 23:34:07.955	SUCCESS	0	0	0	\N	1017
2575	2025-10-11 23:34:28.461	2025-10-11 23:34:37.432	SUCCESS	0	0	0	\N	8971
2576	2025-10-11 23:35:06.939	2025-10-11 23:35:08.409	SUCCESS	0	0	0	\N	1470
2577	2025-10-11 23:35:28.485	2025-10-11 23:35:35.431	SUCCESS	0	0	0	\N	6946
2578	2025-10-11 23:36:06.94	2025-10-11 23:36:08.171	SUCCESS	0	0	0	\N	1231
2579	2025-10-11 23:36:28.509	2025-10-11 23:36:37.231	SUCCESS	0	0	0	\N	8722
2580	2025-10-11 23:37:28.532	2025-10-11 23:37:33.932	SUCCESS	0	0	0	\N	5400
2581	2025-10-11 23:38:28.555	2025-10-11 23:38:34.132	SUCCESS	0	0	0	\N	5577
2582	2025-10-11 23:39:24.909	2025-10-11 23:39:26.21	SUCCESS	0	0	0	\N	1301
2583	2025-10-11 23:39:28.578	2025-10-11 23:39:35.231	SUCCESS	0	0	0	\N	6653
2584	2025-10-11 23:40:24.909	2025-10-11 23:40:25.903	SUCCESS	0	0	0	\N	994
2585	2025-10-11 23:40:28.598	2025-10-11 23:40:39.031	SUCCESS	0	0	0	\N	10433
2586	2025-10-11 23:41:28.621	2025-10-11 23:41:37.231	SUCCESS	0	0	0	\N	8610
2587	2025-10-11 23:42:28.644	2025-10-11 23:42:36.031	SUCCESS	0	0	0	\N	7387
2588	2025-10-11 23:42:41.879	2025-10-11 23:42:43.3	SUCCESS	0	0	0	\N	1421
2589	2025-10-11 23:43:28.666	2025-10-11 23:43:39.131	SUCCESS	0	0	0	\N	10465
2590	2025-10-11 23:43:41.879	2025-10-11 23:43:43.124	SUCCESS	0	0	0	\N	1245
2591	2025-10-11 23:44:28.688	2025-10-11 23:44:39.431	SUCCESS	0	0	0	\N	10743
2592	2025-10-11 23:44:41.88	2025-10-11 23:44:43.148	SUCCESS	0	0	0	\N	1268
2593	2025-10-11 23:45:28.709	2025-10-11 23:45:35.931	SUCCESS	0	0	0	\N	7222
2594	2025-10-11 23:45:41.881	2025-10-11 23:45:43.138	SUCCESS	0	0	0	\N	1257
2595	2025-10-11 23:46:28.73	2025-10-11 23:46:35.232	SUCCESS	0	0	0	\N	6502
2596	2025-10-11 23:46:41.882	2025-10-11 23:46:43.1	SUCCESS	0	0	0	\N	1218
2597	2025-10-11 23:47:28.75	2025-10-11 23:47:35.731	SUCCESS	0	0	0	\N	6981
2598	2025-10-11 23:47:41.884	2025-10-11 23:47:43.146	SUCCESS	0	0	0	\N	1262
2922	2025-10-12 09:59:02.413	2025-10-12 09:59:12.488	SUCCESS	0	0	0	\N	10075
2923	2025-10-12 10:00:02.438	2025-10-12 10:00:09.749	SUCCESS	0	0	0	\N	7311
2925	2025-10-12 10:02:02.488	2025-10-12 10:02:07.65	SUCCESS	0	0	0	\N	5162
2926	2025-10-12 10:03:02.488	2025-10-12 10:03:04.682	SUCCESS	0	0	0	\N	2194
2927	2025-10-12 10:04:02.488	2025-10-12 10:04:04.1	SUCCESS	0	0	0	\N	1612
2945	2025-10-12 10:15:21.889	2025-10-12 10:15:22.894	SUCCESS	0	0	0	\N	1005
2966	2025-10-12 10:25:21.897	2025-10-12 10:25:22.919	SUCCESS	0	0	0	\N	1022
2969	2025-10-12 10:27:21.898	2025-10-12 10:27:22.909	SUCCESS	0	0	0	\N	1011
2997	2025-10-12 10:39:56.101	2025-10-12 10:39:57.401	SUCCESS	0	0	0	\N	1300
3019	2025-10-12 10:50:56.103	2025-10-12 10:50:57.616	SUCCESS	0	0	0	\N	1513
3033	2025-10-12 11:00:56.107	2025-10-12 11:00:57.14	SUCCESS	0	0	0	\N	1033
3044	2025-10-12 11:12:34.149	2025-10-12 11:12:35.41	SUCCESS	0	0	0	\N	1261
3066	2025-10-12 11:18:39.051	2025-10-12 11:18:41.557	SUCCESS	0	0	0	\N	2506
3101	2025-10-12 11:27:43.472	2025-10-12 11:27:44.474	SUCCESS	0	0	0	\N	1002
3123	2025-10-12 11:36:51.24	2025-10-12 11:37:10.977	SUCCESS	1	0	1	\N	19737
3125	2025-10-12 11:37:51.261	2025-10-12 11:38:12.677	SUCCESS	1	0	1	\N	21416
3127	2025-10-12 11:38:51.266	2025-10-12 11:39:16.378	ERROR	1	0	1	Query read timeout	25112
3134	2025-10-12 11:42:51.343	2025-10-12 11:43:15.277	SUCCESS	2	0	1	\N	23934
3140	2025-10-12 11:45:51.396	2025-10-12 11:45:59.777	SUCCESS	0	0	0	\N	8381
2599	2025-10-11 23:48:28.77	2025-10-11 23:48:33.731	SUCCESS	0	0	0	\N	4961
2600	2025-10-11 23:48:41.886	2025-10-11 23:48:43.093	SUCCESS	0	0	0	\N	1207
2601	2025-10-11 23:49:28.773	2025-10-11 23:49:35.431	SUCCESS	0	0	0	\N	6658
2602	2025-10-11 23:49:41.886	2025-10-11 23:49:43.129	SUCCESS	0	0	0	\N	1243
2603	2025-10-11 23:50:41.886	2025-10-11 23:50:43.138	SUCCESS	0	0	0	\N	1252
2604	2025-10-11 23:51:41.887	2025-10-11 23:51:43.109	SUCCESS	0	0	0	\N	1222
2605	2025-10-11 23:52:41.887	2025-10-11 23:52:43.192	SUCCESS	0	0	0	\N	1305
2606	2025-10-11 23:53:41.886	2025-10-11 23:53:42.864	SUCCESS	0	0	0	\N	978
2607	2025-10-11 23:54:41.886	2025-10-11 23:54:43.119	SUCCESS	0	0	0	\N	1233
2608	2025-10-11 23:55:41.887	2025-10-11 23:55:43.165	SUCCESS	0	0	0	\N	1278
2609	2025-10-11 23:56:41.888	2025-10-11 23:56:42.923	SUCCESS	0	0	0	\N	1035
2610	2025-10-11 23:57:41.888	2025-10-11 23:57:43.127	SUCCESS	0	0	0	\N	1239
2611	2025-10-11 23:58:41.888	2025-10-11 23:58:42.897	SUCCESS	0	0	0	\N	1009
2612	2025-10-11 23:59:00.768	2025-10-11 23:59:09.644	SUCCESS	0	0	0	\N	8876
2613	2025-10-11 23:59:41.889	2025-10-11 23:59:43.172	SUCCESS	0	0	0	\N	1283
2614	2025-10-12 00:00:00.793	2025-10-12 00:00:07.644	SUCCESS	0	0	0	\N	6851
2615	2025-10-12 00:00:41.889	2025-10-12 00:00:43.178	SUCCESS	0	0	0	\N	1289
2616	2025-10-12 00:01:00.817	2025-10-12 00:01:08.744	SUCCESS	0	0	0	\N	7927
2617	2025-10-12 00:01:41.889	2025-10-12 00:01:43.15	SUCCESS	0	0	0	\N	1261
2618	2025-10-12 00:02:00.841	2025-10-12 00:02:08.865	SUCCESS	0	0	0	\N	8024
2619	2025-10-12 00:02:41.888	2025-10-12 00:02:43.138	SUCCESS	0	0	0	\N	1250
2620	2025-10-12 00:03:00.865	2025-10-12 00:03:08.344	SUCCESS	0	0	0	\N	7479
2621	2025-10-12 00:03:41.889	2025-10-12 00:03:42.895	SUCCESS	0	0	0	\N	1006
2622	2025-10-12 00:04:00.889	2025-10-12 00:04:09.166	SUCCESS	0	0	0	\N	8277
2623	2025-10-12 00:04:41.888	2025-10-12 00:04:43.155	SUCCESS	0	0	0	\N	1267
2624	2025-10-12 00:05:00.913	2025-10-12 00:05:09.544	SUCCESS	0	0	0	\N	8631
2625	2025-10-12 00:05:41.889	2025-10-12 00:05:43.155	SUCCESS	0	0	0	\N	1266
2626	2025-10-12 00:06:00.914	2025-10-12 00:06:03.843	SUCCESS	0	0	0	\N	2929
2627	2025-10-12 00:06:41.89	2025-10-12 00:06:43.096	SUCCESS	0	0	0	\N	1206
2628	2025-10-12 00:07:00.926	2025-10-12 00:07:09.464	SUCCESS	0	0	0	\N	8538
2629	2025-10-12 00:07:41.891	2025-10-12 00:07:42.872	SUCCESS	0	0	0	\N	981
2630	2025-10-12 00:08:00.95	2025-10-12 00:08:06.344	SUCCESS	0	0	0	\N	5394
2631	2025-10-12 00:08:41.892	2025-10-12 00:08:43.151	SUCCESS	0	0	0	\N	1259
2632	2025-10-12 00:08:43.913	2025-10-12 00:08:45.71	SUCCESS	0	0	0	\N	1797
2633	2025-10-12 00:09:00.973	2025-10-12 00:09:07.444	SUCCESS	0	0	0	\N	6471
2634	2025-10-12 00:09:41.893	2025-10-12 00:09:43.124	SUCCESS	0	0	0	\N	1231
2635	2025-10-12 00:09:43.912	2025-10-12 00:09:52.313	SUCCESS	0	0	0	\N	8401
2636	2025-10-12 00:10:00.997	2025-10-12 00:10:09.444	SUCCESS	0	0	0	\N	8447
2637	2025-10-12 00:10:41.894	2025-10-12 00:10:43.301	SUCCESS	0	0	0	\N	1407
2638	2025-10-12 00:10:43.915	2025-10-12 00:10:50.966	SUCCESS	0	0	0	\N	7051
2639	2025-10-12 00:11:01.021	2025-10-12 00:11:09.744	SUCCESS	0	0	0	\N	8723
2640	2025-10-12 00:11:41.895	2025-10-12 00:11:43.187	SUCCESS	0	0	0	\N	1292
2641	2025-10-12 00:11:52.422	2025-10-12 00:11:54.277	SUCCESS	0	0	0	\N	1855
2642	2025-10-12 00:12:41.895	2025-10-12 00:12:43.106	SUCCESS	0	0	0	\N	1211
2643	2025-10-12 00:12:52.429	2025-10-12 00:12:56.413	SUCCESS	0	0	0	\N	3984
2644	2025-10-12 00:13:41.896	2025-10-12 00:13:43.114	SUCCESS	0	0	0	\N	1218
2645	2025-10-12 00:13:52.428	2025-10-12 00:13:53.41	SUCCESS	0	0	0	\N	982
2646	2025-10-12 00:14:41.896	2025-10-12 00:14:43.138	SUCCESS	0	0	0	\N	1242
2647	2025-10-12 00:14:52.429	2025-10-12 00:14:57.734	SUCCESS	0	0	0	\N	5305
2648	2025-10-12 00:15:41.895	2025-10-12 00:15:42.858	SUCCESS	0	0	0	\N	963
2649	2025-10-12 00:15:52.513	2025-10-12 00:16:00.314	SUCCESS	0	0	0	\N	7801
2650	2025-10-12 00:16:41.895	2025-10-12 00:16:42.922	SUCCESS	0	0	0	\N	1027
2651	2025-10-12 00:16:52.543	2025-10-12 00:16:58.713	SUCCESS	0	0	0	\N	6170
2652	2025-10-12 00:17:41.895	2025-10-12 00:17:43.149	SUCCESS	0	0	0	\N	1254
2653	2025-10-12 00:17:52.572	2025-10-12 00:18:01.135	SUCCESS	0	0	0	\N	8563
2654	2025-10-12 00:18:41.895	2025-10-12 00:18:43.121	SUCCESS	0	0	0	\N	1226
2655	2025-10-12 00:18:52.6	2025-10-12 00:18:58.413	SUCCESS	0	0	0	\N	5813
2656	2025-10-12 00:19:41.896	2025-10-12 00:19:43.141	SUCCESS	0	0	0	\N	1245
2657	2025-10-12 00:19:52.628	2025-10-12 00:20:00.136	SUCCESS	0	0	0	\N	7508
2658	2025-10-12 00:20:41.897	2025-10-12 00:20:43.114	SUCCESS	0	0	0	\N	1217
2659	2025-10-12 00:20:52.655	2025-10-12 00:20:59.812	SUCCESS	0	0	0	\N	7157
2660	2025-10-12 00:21:41.898	2025-10-12 00:21:43.149	SUCCESS	0	0	0	\N	1251
2661	2025-10-12 00:21:52.677	2025-10-12 00:22:01.113	SUCCESS	0	0	0	\N	8436
2662	2025-10-12 00:22:41.899	2025-10-12 00:22:43.099	SUCCESS	0	0	0	\N	1200
2663	2025-10-12 00:22:52.702	2025-10-12 00:22:58.413	SUCCESS	0	0	0	\N	5711
2664	2025-10-12 00:23:41.9	2025-10-12 00:23:43.178	SUCCESS	0	0	0	\N	1278
2665	2025-10-12 00:23:52.727	2025-10-12 00:24:00.013	SUCCESS	0	0	0	\N	7286
2666	2025-10-12 00:24:41.901	2025-10-12 00:24:43.165	SUCCESS	0	0	0	\N	1264
2667	2025-10-12 00:24:52.753	2025-10-12 00:24:58.713	SUCCESS	0	0	0	\N	5960
2668	2025-10-12 00:25:41.901	2025-10-12 00:25:43.121	SUCCESS	0	0	0	\N	1220
2669	2025-10-12 00:25:52.779	2025-10-12 00:26:01.452	SUCCESS	0	0	0	\N	8673
2670	2025-10-12 00:26:52.804	2025-10-12 00:26:58.813	SUCCESS	0	0	0	\N	6009
2671	2025-10-12 00:27:52.83	2025-10-12 00:28:00.736	SUCCESS	0	0	0	\N	7906
2672	2025-10-12 00:28:52.847	2025-10-12 00:29:00.013	SUCCESS	0	0	0	\N	7166
2673	2025-10-12 00:29:52.872	2025-10-12 00:29:59.413	SUCCESS	0	0	0	\N	6541
2674	2025-10-12 00:30:52.897	2025-10-12 00:31:00.513	SUCCESS	0	0	0	\N	7616
2675	2025-10-12 00:31:52.921	2025-10-12 00:31:58.513	SUCCESS	0	0	0	\N	5592
2676	2025-10-12 00:32:52.946	2025-10-12 00:33:01.113	SUCCESS	0	0	0	\N	8167
2677	2025-10-12 00:33:52.969	2025-10-12 00:33:58.335	SUCCESS	0	0	0	\N	5366
2678	2025-10-12 00:34:52.993	2025-10-12 00:34:57.513	SUCCESS	0	0	0	\N	4520
2679	2025-10-12 01:08:20.414	2025-10-12 01:08:31.024	SUCCESS	0	0	0	\N	10610
2680	2025-10-12 01:10:20.987	2025-10-12 01:10:29.807	SUCCESS	0	0	0	\N	8820
2681	2025-10-12 01:11:21.286	2025-10-12 01:11:31.606	SUCCESS	0	0	0	\N	10320
2682	2025-10-12 01:12:21.313	2025-10-12 01:12:28.586	SUCCESS	0	0	0	\N	7273
2683	2025-10-12 01:13:21.34	2025-10-12 01:13:29.686	SUCCESS	0	0	0	\N	8346
2684	2025-10-12 01:14:21.367	2025-10-12 01:14:29.427	SUCCESS	0	0	0	\N	8060
2685	2025-10-12 01:15:21.393	2025-10-12 01:15:31.486	SUCCESS	0	0	0	\N	10093
2686	2025-10-12 01:16:21.418	2025-10-12 01:16:25.586	SUCCESS	0	0	0	\N	4168
2687	2025-10-12 01:17:21.445	2025-10-12 01:17:27.886	SUCCESS	0	0	0	\N	6441
2688	2025-10-12 01:18:21.471	2025-10-12 01:18:26.187	SUCCESS	0	0	0	\N	4716
2689	2025-10-12 01:19:21.496	2025-10-12 01:19:28.286	SUCCESS	0	0	0	\N	6790
2690	2025-10-12 01:20:21.521	2025-10-12 01:20:30.011	SUCCESS	0	0	0	\N	8490
2691	2025-10-12 01:21:21.539	2025-10-12 01:21:29.531	SUCCESS	0	0	0	\N	7992
2692	2025-10-12 01:22:21.563	2025-10-12 01:22:31.708	SUCCESS	0	0	0	\N	10145
2693	2025-10-12 01:23:21.588	2025-10-12 01:23:27.586	SUCCESS	0	0	0	\N	5998
2697	2025-10-12 01:27:21.667	2025-10-12 01:27:29.186	SUCCESS	0	0	0	\N	7519
2698	2025-10-12 01:28:21.691	2025-10-12 01:28:30.386	SUCCESS	0	0	0	\N	8695
2699	2025-10-12 01:29:21.715	2025-10-12 01:29:25.886	SUCCESS	0	0	0	\N	4171
2704	2025-10-12 01:34:21.815	2025-10-12 01:34:27.807	SUCCESS	0	0	0	\N	5992
2705	2025-10-12 01:35:21.838	2025-10-12 01:35:25.986	SUCCESS	0	0	0	\N	4148
2929	2025-10-12 10:06:20.278	2025-10-12 10:06:29.149	SUCCESS	1	0	1	\N	8871
2947	2025-10-12 10:16:21.889	2025-10-12 10:16:23.159	SUCCESS	0	0	0	\N	1270
2967	2025-10-12 10:26:21.898	2025-10-12 10:26:22.909	SUCCESS	0	0	0	\N	1011
2998	2025-10-12 10:40:51.382	2025-10-12 10:40:57.984	SUCCESS	0	0	0	\N	6602
3000	2025-10-12 10:41:51.407	2025-10-12 10:41:55.034	SUCCESS	0	0	0	\N	3627
3010	2025-10-12 10:46:51.517	2025-10-12 10:46:55.534	SUCCESS	0	0	0	\N	4017
3012	2025-10-12 10:47:51.54	2025-10-12 10:47:56.233	SUCCESS	0	0	0	\N	4693
3014	2025-10-12 10:48:51.562	2025-10-12 10:48:56.232	SUCCESS	0	0	0	\N	4670
3016	2025-10-12 10:49:51.578	2025-10-12 10:49:55.232	SUCCESS	0	0	0	\N	3654
3018	2025-10-12 10:50:51.601	2025-10-12 10:50:56.532	SUCCESS	0	0	0	\N	4931
3020	2025-10-12 10:51:51.615	2025-10-12 10:51:57.233	SUCCESS	0	0	0	\N	5618
3021	2025-10-12 10:51:56.103	2025-10-12 10:51:57.402	SUCCESS	0	0	0	\N	1299
3022	2025-10-12 10:52:51.638	2025-10-12 10:52:57.233	SUCCESS	0	0	0	\N	5595
3026	2025-10-12 10:54:51.663	\N	RUNNING	0	0	0	\N	\N
3034	2025-10-12 11:01:56.107	2025-10-12 11:01:57.089	SUCCESS	0	0	0	\N	982
3045	2025-10-12 11:12:29.687	2025-10-12 11:12:40.434	SUCCESS	0	0	0	\N	10747
3046	2025-10-12 11:13:29.694	2025-10-12 11:13:37.034	SUCCESS	0	0	0	\N	7340
3056	2025-10-12 11:16:29.762	2025-10-12 11:16:44.175	SUCCESS	1	0	0	\N	14413
3057	2025-10-12 11:16:31.435	2025-10-12 11:16:47.345	SUCCESS	1	0	1	\N	15910
3060	2025-10-12 11:17:29.79	2025-10-12 11:17:37.134	SUCCESS	0	0	0	\N	7344
3061	2025-10-12 11:17:31.443	2025-10-12 11:17:39.945	SUCCESS	0	0	0	\N	8502
3062	2025-10-12 11:17:35.818	2025-10-12 11:17:44.536	SUCCESS	0	0	0	\N	8718
3065	2025-10-12 11:18:31.465	2025-10-12 11:18:35.945	SUCCESS	0	0	0	\N	4480
3064	2025-10-12 11:18:29.818	2025-10-12 11:18:39.434	SUCCESS	0	0	0	\N	9616
3067	2025-10-12 11:18:35.842	2025-10-12 11:18:49.036	SUCCESS	0	0	0	\N	13194
3069	2025-10-12 11:19:31.487	2025-10-12 11:19:47.365	SUCCESS	1	0	1	\N	15878
3068	2025-10-12 11:19:29.844	2025-10-12 11:19:55.134	SUCCESS	1	0	1	\N	25290
3073	2025-10-12 11:20:31.506	2025-10-12 11:20:47.066	SUCCESS	1	0	1	\N	15560
3072	2025-10-12 11:20:29.864	2025-10-12 11:20:47.634	SUCCESS	1	0	0	\N	17770
3074	2025-10-12 11:20:35.876	2025-10-12 11:20:56.636	SUCCESS	1	0	1	\N	20760
3076	2025-10-12 11:21:29.89	2025-10-12 11:21:46.034	SUCCESS	1	0	0	\N	16144
3077	2025-10-12 11:21:31.528	2025-10-12 11:21:47.464	SUCCESS	1	0	1	\N	15936
3081	2025-10-12 11:22:31.548	2025-10-12 11:22:35.745	SUCCESS	0	0	0	\N	4197
3080	2025-10-12 11:22:29.917	2025-10-12 11:22:38.355	SUCCESS	0	0	0	\N	8438
3086	2025-10-12 11:23:35.943	2025-10-12 11:23:39.257	SUCCESS	0	0	0	\N	3314
3088	2025-10-12 11:24:29.97	2025-10-12 11:24:34.834	SUCCESS	0	0	0	\N	4864
3089	2025-10-12 11:24:31.59	2025-10-12 11:24:35.546	SUCCESS	0	0	0	\N	3956
3097	2025-10-12 11:26:31.634	2025-10-12 11:26:35.435	SUCCESS	0	0	0	\N	3801
3096	2025-10-12 11:26:30.021	2025-10-12 11:26:35.335	SUCCESS	0	0	0	\N	5314
3103	2025-10-12 11:28:43.472	2025-10-12 11:28:44.478	SUCCESS	0	0	0	\N	1006
3104	2025-10-12 11:29:30.049	2025-10-12 11:29:32.025	SUCCESS	0	0	0	\N	1976
3124	2025-10-12 11:37:29.686	2025-10-12 11:37:32.739	SUCCESS	1	0	1	\N	3053
2694	2025-10-12 01:24:21.612	2025-10-12 01:24:25.586	SUCCESS	0	0	0	\N	3974
2695	2025-10-12 01:25:21.636	2025-10-12 01:25:25.586	SUCCESS	0	0	0	\N	3950
2696	2025-10-12 01:26:21.661	2025-10-12 01:26:26.686	SUCCESS	0	0	0	\N	5025
2700	2025-10-12 01:30:21.739	2025-10-12 01:30:25.186	SUCCESS	0	0	0	\N	3447
2701	2025-10-12 01:31:21.744	2025-10-12 01:31:33.106	SUCCESS	0	0	0	\N	11362
2702	2025-10-12 01:32:21.767	2025-10-12 01:32:27.485	SUCCESS	0	0	0	\N	5718
2703	2025-10-12 01:33:21.791	2025-10-12 01:33:27.986	SUCCESS	0	0	0	\N	6195
2706	2025-10-12 03:09:41.72	2025-10-12 03:09:49.662	ERROR	0	0	0	Request failed with status code 400	7942
2707	2025-10-12 03:11:42.492	2025-10-12 03:11:49.762	ERROR	0	0	0	Request failed with status code 400	7270
2708	2025-10-12 03:12:42.522	2025-10-12 03:12:51.563	ERROR	0	0	0	Request failed with status code 400	9041
2709	2025-10-12 03:13:42.55	2025-10-12 03:13:48.966	ERROR	0	0	0	Request failed with status code 400	6416
2710	2025-10-12 03:14:42.574	2025-10-12 03:14:49.663	ERROR	0	0	0	Request failed with status code 400	7089
2711	2025-10-12 03:15:42.587	2025-10-12 03:15:50.263	ERROR	0	0	0	Request failed with status code 400	7676
2712	2025-10-12 03:16:42.614	2025-10-12 03:16:50.462	ERROR	0	0	0	Request failed with status code 400	7848
2713	2025-10-12 03:17:42.642	2025-10-12 03:17:48.962	ERROR	0	0	0	Request failed with status code 400	6320
2714	2025-10-12 03:18:42.67	2025-10-12 03:18:49.087	ERROR	0	0	0	Request failed with status code 400	6417
2715	2025-10-12 03:19:42.698	2025-10-12 03:19:52.062	ERROR	0	0	0	Request failed with status code 400	9364
2716	2025-10-12 03:20:42.725	2025-10-12 03:20:52.186	ERROR	0	0	0	Request failed with status code 400	9461
2717	2025-10-12 03:21:42.752	2025-10-12 03:21:50.162	ERROR	0	0	0	Request failed with status code 400	7410
2718	2025-10-12 03:22:42.756	2025-10-12 03:22:49.863	ERROR	0	0	0	Request failed with status code 400	7107
2719	2025-10-12 03:23:42.782	2025-10-12 03:23:48.463	ERROR	0	0	0	Request failed with status code 400	5681
2720	2025-10-12 03:24:42.799	2025-10-12 03:24:49.063	ERROR	0	0	0	Request failed with status code 400	6264
2721	2025-10-12 03:25:42.825	2025-10-12 03:25:50.362	ERROR	0	0	0	Request failed with status code 400	7537
2722	2025-10-12 03:26:42.842	2025-10-12 03:26:51.763	ERROR	0	0	0	Request failed with status code 400	8921
2723	2025-10-12 03:27:42.866	2025-10-12 03:27:48.163	ERROR	0	0	0	Request failed with status code 400	5297
2724	2025-10-12 03:28:42.89	2025-10-12 03:28:47.364	ERROR	0	0	0	Request failed with status code 400	4474
2725	2025-10-12 03:29:42.914	2025-10-12 03:29:49.063	ERROR	0	0	0	Request failed with status code 400	6149
2726	2025-10-12 03:30:42.938	2025-10-12 03:30:49.764	ERROR	0	0	0	Request failed with status code 400	6826
2727	2025-10-12 03:31:42.962	2025-10-12 03:31:46.065	ERROR	0	0	0	Request failed with status code 400	3103
2728	2025-10-12 03:32:42.985	2025-10-12 03:32:49.363	ERROR	0	0	0	Request failed with status code 400	6378
2729	2025-10-12 03:33:43.006	2025-10-12 03:33:43.701	ERROR	0	0	0	Request failed with status code 400	695
2730	2025-10-12 04:05:11.507	2025-10-12 04:05:27.264	SUCCESS	0	0	0	\N	15757
2731	2025-10-12 04:06:11.534	2025-10-12 04:06:15.238	SUCCESS	0	0	0	\N	3704
2732	2025-10-12 04:07:11.561	2025-10-12 04:07:20.359	SUCCESS	0	0	0	\N	8798
2733	2025-10-12 04:08:11.577	2025-10-12 04:08:18.559	SUCCESS	0	0	0	\N	6982
2734	2025-10-12 04:09:11.604	2025-10-12 04:09:17.138	SUCCESS	0	0	0	\N	5534
2735	2025-10-12 04:10:11.63	2025-10-12 04:10:17.538	SUCCESS	0	0	0	\N	5908
2736	2025-10-12 04:11:11.653	2025-10-12 04:11:17.338	SUCCESS	0	0	0	\N	5685
2737	2025-10-12 04:12:11.679	2025-10-12 04:12:20.238	SUCCESS	0	0	0	\N	8559
2738	2025-10-12 04:13:11.705	2025-10-12 04:13:15.338	SUCCESS	0	0	0	\N	3633
2739	2025-10-12 04:14:11.731	2025-10-12 04:14:18.338	SUCCESS	0	0	0	\N	6607
2740	2025-10-12 04:15:11.755	2025-10-12 04:15:17.738	SUCCESS	0	0	0	\N	5983
2741	2025-10-12 04:16:11.785	2025-10-12 04:16:16.638	SUCCESS	0	0	0	\N	4853
2742	2025-10-12 04:17:11.811	2025-10-12 04:17:17.938	SUCCESS	0	0	0	\N	6127
2743	2025-10-12 04:18:11.836	2025-10-12 04:18:16.638	SUCCESS	0	0	0	\N	4802
2744	2025-10-12 04:19:11.861	2025-10-12 04:19:15.94	SUCCESS	0	0	0	\N	4079
2745	2025-10-12 04:20:11.886	2025-10-12 04:20:16.538	SUCCESS	0	0	0	\N	4652
2746	2025-10-12 04:21:11.912	2025-10-12 04:21:17.341	SUCCESS	0	0	0	\N	5429
2747	2025-10-12 04:22:11.936	2025-10-12 04:22:16.238	SUCCESS	0	0	0	\N	4302
2748	2025-10-12 04:23:11.96	2025-10-12 04:23:21.438	SUCCESS	0	0	0	\N	9478
2749	2025-10-12 04:24:11.983	2025-10-12 04:24:23.738	SUCCESS	0	0	0	\N	11755
2750	2025-10-12 04:25:12.007	2025-10-12 04:25:16.866	SUCCESS	0	0	0	\N	4859
2751	2025-10-12 04:26:12.031	2025-10-12 04:26:17.641	SUCCESS	0	0	0	\N	5610
2752	2025-10-12 04:27:12.055	2025-10-12 04:27:16.938	SUCCESS	0	0	0	\N	4883
2753	2025-10-12 04:33:03.857	2025-10-12 04:33:13.858	SUCCESS	0	0	0	\N	10001
2754	2025-10-12 04:34:03.884	2025-10-12 04:34:11.157	SUCCESS	0	0	0	\N	7273
2755	2025-10-12 04:35:03.91	2025-10-12 04:35:09.658	SUCCESS	0	0	0	\N	5748
2756	2025-10-12 04:36:03.937	2025-10-12 04:36:10.278	SUCCESS	0	0	0	\N	6341
2757	2025-10-12 04:37:03.959	2025-10-12 04:37:11.557	SUCCESS	0	0	0	\N	7598
2758	2025-10-12 04:38:03.985	2025-10-12 04:38:10.867	SUCCESS	0	0	0	\N	6882
2759	2025-10-12 04:39:04.01	2025-10-12 04:39:10.957	SUCCESS	0	0	0	\N	6947
2760	2025-10-12 04:40:04.035	2025-10-12 04:40:08.758	SUCCESS	0	0	0	\N	4723
2761	2025-10-12 04:41:04.06	2025-10-12 04:41:09.757	SUCCESS	0	0	0	\N	5697
2762	2025-10-12 04:42:04.085	2025-10-12 04:42:11.757	SUCCESS	0	0	0	\N	7672
2763	2025-10-12 04:43:04.096	2025-10-12 04:43:14.998	SUCCESS	0	0	0	\N	10902
2764	2025-10-12 04:44:04.121	2025-10-12 04:44:11.899	SUCCESS	0	0	0	\N	7778
2765	2025-10-12 04:45:04.145	2025-10-12 04:45:08.658	SUCCESS	0	0	0	\N	4513
2766	2025-10-12 04:46:04.169	2025-10-12 04:46:12.278	SUCCESS	0	0	0	\N	8109
2767	2025-10-12 04:54:00.887	2025-10-12 04:54:12.472	SUCCESS	0	0	0	\N	11585
2768	2025-10-12 04:56:00.898	2025-10-12 04:56:06.851	SUCCESS	0	0	0	\N	5953
2769	2025-10-12 04:57:00.925	2025-10-12 04:57:06.351	SUCCESS	0	0	0	\N	5426
2770	2025-10-12 04:58:00.952	2025-10-12 04:58:05.452	SUCCESS	0	0	0	\N	4500
2771	2025-10-12 04:59:00.978	2025-10-12 04:59:06.152	SUCCESS	0	0	0	\N	5174
2772	2025-10-12 05:00:01.003	2025-10-12 05:00:07.051	SUCCESS	0	0	0	\N	6048
2773	2025-10-12 05:01:01.029	2025-10-12 05:01:06.752	SUCCESS	0	0	0	\N	5723
2774	2025-10-12 05:02:01.055	2025-10-12 05:02:06.251	SUCCESS	0	0	0	\N	5196
2775	2025-10-12 05:03:01.081	2025-10-12 05:03:06.272	SUCCESS	0	0	0	\N	5191
2776	2025-10-12 05:04:01.106	2025-10-12 05:04:06.651	SUCCESS	0	0	0	\N	5545
2777	2025-10-12 05:05:01.132	2025-10-12 05:05:06.451	SUCCESS	0	0	0	\N	5319
2778	2025-10-12 05:06:01.158	2025-10-12 05:06:09.372	SUCCESS	0	0	0	\N	8214
2779	2025-10-12 05:07:01.182	2025-10-12 05:07:08.45	SUCCESS	0	0	0	\N	7268
2780	2025-10-12 05:08:01.208	2025-10-12 05:08:03.564	SUCCESS	0	0	0	\N	2356
2781	2025-10-12 05:50:06.572	2025-10-12 05:50:18.268	SUCCESS	0	0	0	\N	11696
2782	2025-10-12 05:51:09.347	2025-10-12 05:51:19.047	SUCCESS	0	0	0	\N	9700
2783	2025-10-12 05:52:09.376	2025-10-12 05:52:17.147	SUCCESS	0	0	0	\N	7771
2785	2025-10-12 05:54:09.432	2025-10-12 05:54:17.347	SUCCESS	0	0	0	\N	7915
2787	2025-10-12 05:56:09.488	2025-10-12 05:56:15.348	SUCCESS	0	0	0	\N	5860
2790	2025-10-12 05:59:09.561	2025-10-12 05:59:17.171	SUCCESS	0	0	0	\N	7610
2794	2025-10-12 06:03:09.666	2025-10-12 06:03:14.347	SUCCESS	0	0	0	\N	4681
2795	2025-10-12 06:04:09.692	2025-10-12 06:04:13.35	SUCCESS	0	0	0	\N	3658
2931	2025-10-12 10:08:21.889	2025-10-12 10:08:22.945	SUCCESS	0	0	0	\N	1056
2949	2025-10-12 10:17:21.889	2025-10-12 10:17:22.885	SUCCESS	0	0	0	\N	996
2971	2025-10-12 10:28:21.898	2025-10-12 10:28:22.955	SUCCESS	0	0	0	\N	1057
2999	2025-10-12 10:40:56.1	2025-10-12 10:40:57.35	SUCCESS	0	0	0	\N	1250
3023	2025-10-12 10:52:56.103	2025-10-12 10:52:57.305	SUCCESS	0	0	0	\N	1202
3035	2025-10-12 11:03:34.146	2025-10-12 11:03:37.12	SUCCESS	1	0	1	\N	2974
3047	2025-10-12 11:13:34.15	2025-10-12 11:13:35.139	SUCCESS	0	0	0	\N	989
3071	2025-10-12 11:19:39.051	\N	RUNNING	0	0	0	\N	\N
3105	2025-10-12 11:29:43.472	2025-10-12 11:29:44.701	SUCCESS	0	0	0	\N	1229
3126	2025-10-12 11:38:29.689	2025-10-12 11:38:33.067	SUCCESS	1	0	1	\N	3378
2784	2025-10-12 05:53:09.404	2025-10-12 05:53:15.848	SUCCESS	0	0	0	\N	6444
2786	2025-10-12 05:55:09.46	2025-10-12 05:55:15.647	SUCCESS	0	0	0	\N	6187
2788	2025-10-12 05:57:09.516	2025-10-12 05:57:17.547	SUCCESS	0	0	0	\N	8031
2789	2025-10-12 05:58:09.538	2025-10-12 05:58:15.771	SUCCESS	0	0	0	\N	6233
2791	2025-10-12 06:00:09.589	2025-10-12 06:00:17.57	SUCCESS	0	0	0	\N	7981
2792	2025-10-12 06:01:09.616	2025-10-12 06:01:15.847	SUCCESS	0	0	0	\N	6231
2793	2025-10-12 06:02:09.642	2025-10-12 06:02:17.376	SUCCESS	0	0	0	\N	7734
2796	2025-10-12 06:16:08.534	2025-10-12 06:16:19.776	SUCCESS	0	0	0	\N	11242
2797	2025-10-12 06:18:09.081	2025-10-12 06:18:15.875	SUCCESS	0	0	0	\N	6794
2798	2025-10-12 06:19:09.107	2025-10-12 06:19:16.775	SUCCESS	0	0	0	\N	7668
2799	2025-10-12 06:20:09.132	2025-10-12 06:20:15.076	SUCCESS	0	0	0	\N	5944
2800	2025-10-12 06:21:09.157	2025-10-12 06:21:17.975	SUCCESS	0	0	0	\N	8818
2801	2025-10-12 06:22:09.182	2025-10-12 06:22:16.5	SUCCESS	0	0	0	\N	7318
2802	2025-10-12 06:23:09.207	2025-10-12 06:23:16.375	SUCCESS	0	0	0	\N	7168
2803	2025-10-12 06:24:09.232	2025-10-12 06:24:16.575	SUCCESS	0	0	0	\N	7343
2804	2025-10-12 06:25:09.257	2025-10-12 06:25:16.476	SUCCESS	0	0	0	\N	7219
2805	2025-10-12 06:26:09.281	2025-10-12 06:26:17.575	SUCCESS	0	0	0	\N	8294
2806	2025-10-12 06:27:09.305	2025-10-12 06:27:16.598	SUCCESS	0	0	0	\N	7293
2807	2025-10-12 06:28:09.329	2025-10-12 06:28:15.575	SUCCESS	0	0	0	\N	6246
2808	2025-10-12 06:29:09.353	2025-10-12 06:29:16.476	SUCCESS	0	0	0	\N	7123
2809	2025-10-12 06:30:09.357	2025-10-12 06:30:13.12	SUCCESS	0	0	0	\N	3763
2810	2025-10-12 07:36:21.151	2025-10-12 07:36:25.125	SUCCESS	0	0	0	\N	3974
2811	2025-10-12 07:37:21.153	2025-10-12 07:37:30.904	SUCCESS	0	0	0	\N	9751
2812	2025-10-12 07:39:21.156	2025-10-12 07:39:23.672	SUCCESS	0	0	0	\N	2516
2813	2025-10-12 07:40:21.182	2025-10-12 07:40:30.604	SUCCESS	0	0	0	\N	9422
2814	2025-10-12 07:41:21.207	2025-10-12 07:41:31.304	SUCCESS	0	0	0	\N	10097
2815	2025-10-12 07:42:21.214	2025-10-12 07:42:31.904	SUCCESS	0	0	0	\N	10690
2816	2025-10-12 07:43:21.233	2025-10-12 07:43:32.204	SUCCESS	0	0	0	\N	10971
2817	2025-10-12 07:44:21.252	2025-10-12 07:44:27.304	SUCCESS	0	0	0	\N	6052
2818	2025-10-12 07:45:21.265	2025-10-12 07:45:32.704	SUCCESS	0	0	0	\N	11439
2819	2025-10-12 07:46:21.404	2025-10-12 07:46:25.806	SUCCESS	0	0	0	\N	4402
2820	2025-10-12 07:47:21.421	2025-10-12 07:47:34.227	ERROR	0	0	0	Connection terminated due to connection timeout	12806
2821	2025-10-12 07:48:21.442	2025-10-12 07:48:24.605	SUCCESS	0	0	0	\N	3163
2822	2025-10-12 07:49:21.463	2025-10-12 07:49:25.104	SUCCESS	0	0	0	\N	3641
2823	2025-10-12 07:50:21.484	2025-10-12 07:50:25.004	SUCCESS	0	0	0	\N	3520
2824	2025-10-12 07:51:21.504	2025-10-12 07:51:24.827	SUCCESS	0	0	0	\N	3323
2825	2025-10-12 07:52:21.525	2025-10-12 07:52:26.205	SUCCESS	0	0	0	\N	4680
2826	2025-10-12 07:53:21.541	2025-10-12 07:53:26.128	SUCCESS	0	0	0	\N	4587
2827	2025-10-12 07:54:21.562	2025-10-12 07:54:41.504	SUCCESS	1	0	1	\N	19942
2828	2025-10-12 07:55:21.579	2025-10-12 07:55:24.906	SUCCESS	0	0	0	\N	3327
2829	2025-10-12 07:56:21.597	2025-10-12 07:56:25.304	SUCCESS	0	0	0	\N	3707
2830	2025-10-12 07:57:21.613	2025-10-12 07:57:49.804	SUCCESS	1	0	1	\N	28191
2831	2025-10-12 07:58:21.63	2025-10-12 07:58:24.228	SUCCESS	0	0	0	\N	2598
2832	2025-10-12 07:59:21.65	2025-10-12 07:59:24.131	SUCCESS	0	0	0	\N	2481
2833	2025-10-12 08:00:21.67	2025-10-12 08:00:25.604	SUCCESS	0	0	0	\N	3934
2834	2025-10-12 08:01:21.69	2025-10-12 08:01:24.904	SUCCESS	0	0	0	\N	3214
2835	2025-10-12 08:02:21.709	2025-10-12 08:02:24.804	SUCCESS	0	0	0	\N	3095
2836	2025-10-12 08:03:21.729	2025-10-12 08:03:26.304	SUCCESS	0	0	0	\N	4575
2837	2025-10-12 08:04:21.748	2025-10-12 08:04:24.704	SUCCESS	0	0	0	\N	2956
2838	2025-10-12 08:05:21.767	2025-10-12 08:05:24.805	SUCCESS	0	0	0	\N	3038
2839	2025-10-12 08:06:21.787	2025-10-12 08:06:24.905	SUCCESS	0	0	0	\N	3118
2840	2025-10-12 08:08:21.827	2025-10-12 08:08:25.205	SUCCESS	0	0	0	\N	3378
2841	2025-10-12 08:09:21.846	2025-10-12 08:09:25.305	SUCCESS	0	0	0	\N	3459
2842	2025-10-12 08:10:21.847	2025-10-12 08:10:25.504	SUCCESS	0	0	0	\N	3657
2843	2025-10-12 08:11:21.865	2025-10-12 08:11:25.606	SUCCESS	0	0	0	\N	3741
2844	2025-10-12 08:12:21.869	2025-10-12 08:12:24.404	SUCCESS	0	0	0	\N	2535
2845	2025-10-12 08:13:21.888	2025-10-12 08:13:24.304	SUCCESS	0	0	0	\N	2416
2846	2025-10-12 08:14:21.907	2025-10-12 08:14:26.305	SUCCESS	0	0	0	\N	4398
2847	2025-10-12 08:15:21.926	2025-10-12 08:15:25.716	SUCCESS	0	0	0	\N	3790
2848	2025-10-12 08:16:21.945	2025-10-12 08:16:26.204	SUCCESS	0	0	0	\N	4259
2849	2025-10-12 08:17:21.961	2025-10-12 08:17:24.604	SUCCESS	0	0	0	\N	2643
2850	2025-10-12 08:18:21.978	2025-10-12 08:18:24.904	SUCCESS	0	0	0	\N	2926
2851	2025-10-12 08:19:21.997	2025-10-12 08:19:24.43	SUCCESS	0	0	0	\N	2433
2852	2025-10-12 08:20:22.016	2025-10-12 08:20:25.204	SUCCESS	0	0	0	\N	3188
2853	2025-10-12 08:21:22.034	2025-10-12 08:21:24.226	SUCCESS	0	0	0	\N	2192
2854	2025-10-12 08:22:22.052	2025-10-12 08:22:25.505	SUCCESS	0	0	0	\N	3453
2855	2025-10-12 08:23:22.071	2025-10-12 08:23:24.404	SUCCESS	0	0	0	\N	2333
2856	2025-10-12 08:24:22.09	2025-10-12 08:24:24.706	SUCCESS	0	0	0	\N	2616
2857	2025-10-12 08:25:22.108	2025-10-12 08:25:25.405	SUCCESS	0	0	0	\N	3297
2858	2025-10-12 08:26:22.126	2025-10-12 08:26:24.504	SUCCESS	0	0	0	\N	2378
2859	2025-10-12 08:27:22.143	2025-10-12 08:27:24.524	SUCCESS	0	0	0	\N	2381
2860	2025-10-12 08:28:22.15	2025-10-12 08:28:24.704	SUCCESS	0	0	0	\N	2554
2861	2025-10-12 08:29:22.168	2025-10-12 08:29:25.604	SUCCESS	0	0	0	\N	3436
2862	2025-10-12 08:30:22.187	2025-10-12 08:30:24.404	SUCCESS	0	0	0	\N	2217
2863	2025-10-12 08:31:22.204	2025-10-12 08:31:24.93	SUCCESS	0	0	0	\N	2726
2864	2025-10-12 08:49:09.682	2025-10-12 08:49:19.657	SUCCESS	1	0	1	\N	9975
2865	2025-10-12 08:50:09.71	2025-10-12 08:50:18.177	SUCCESS	0	0	0	\N	8467
2866	2025-10-12 08:51:09.737	2025-10-12 08:51:16.856	SUCCESS	0	0	0	\N	7119
2867	2025-10-12 08:52:09.764	2025-10-12 08:52:18.056	SUCCESS	0	0	0	\N	8292
2868	2025-10-12 08:53:09.792	2025-10-12 08:53:15.657	SUCCESS	0	0	0	\N	5865
2869	2025-10-12 08:54:09.818	2025-10-12 08:54:17.056	SUCCESS	0	0	0	\N	7238
2870	2025-10-12 08:55:09.826	2025-10-12 08:55:16.956	SUCCESS	0	0	0	\N	7130
2871	2025-10-12 08:56:09.853	2025-10-12 08:56:16.456	SUCCESS	0	0	0	\N	6603
2872	2025-10-12 08:57:09.88	2025-10-12 08:57:17.48	SUCCESS	0	0	0	\N	7600
2873	2025-10-12 08:58:09.906	2025-10-12 08:58:18.856	SUCCESS	0	0	0	\N	8950
2874	2025-10-12 08:59:09.931	2025-10-12 08:59:16.356	SUCCESS	0	0	0	\N	6425
2875	2025-10-12 09:00:09.958	2025-10-12 09:00:17.556	SUCCESS	0	0	0	\N	7598
2876	2025-10-12 09:01:09.962	2025-10-12 09:01:16.884	SUCCESS	0	0	0	\N	6922
2877	2025-10-12 09:02:09.988	2025-10-12 09:02:18.056	SUCCESS	0	0	0	\N	8068
2878	2025-10-12 09:03:10.014	2025-10-12 09:03:17.656	SUCCESS	0	0	0	\N	7642
2879	2025-10-12 09:04:10.04	2025-10-12 09:04:13.177	SUCCESS	0	0	0	\N	3137
2880	2025-10-12 09:06:43.607	2025-10-12 09:06:52.407	SUCCESS	0	0	0	\N	8800
2881	2025-10-12 09:07:43.636	2025-10-12 09:07:50.307	SUCCESS	0	0	0	\N	6671
2882	2025-10-12 09:08:43.664	2025-10-12 09:08:50.532	SUCCESS	0	0	0	\N	6868
2883	2025-10-12 09:09:43.692	2025-10-12 09:09:50.107	SUCCESS	0	0	0	\N	6415
2884	2025-10-12 09:10:43.721	2025-10-12 09:10:49.607	SUCCESS	0	0	0	\N	5886
2886	2025-10-12 09:12:44.072	2025-10-12 09:13:19.807	SUCCESS	0	0	0	\N	35735
2891	2025-10-12 09:18:44.118	2025-10-12 09:18:49.007	SUCCESS	0	0	0	\N	4889
2932	2025-10-12 10:08:20.286	2025-10-12 10:08:25.869	SUCCESS	0	0	0	\N	5583
2951	2025-10-12 10:18:21.89	2025-10-12 10:18:22.886	SUCCESS	0	0	0	\N	996
2952	2025-10-12 10:18:20.468	2025-10-12 10:18:26.752	SUCCESS	0	0	0	\N	6284
2954	2025-10-12 10:19:20.47	2025-10-12 10:19:29.049	SUCCESS	0	0	0	\N	8579
2955	2025-10-12 10:20:20.496	2025-10-12 10:20:29.449	SUCCESS	0	0	0	\N	8953
2960	2025-10-12 10:22:20.546	2025-10-12 10:22:30.075	SUCCESS	0	0	0	\N	9529
2962	2025-10-12 10:23:20.571	2025-10-12 10:23:29.069	SUCCESS	0	0	0	\N	8498
2964	2025-10-12 10:24:20.595	2025-10-12 10:24:26.449	SUCCESS	0	0	0	\N	5854
2965	2025-10-12 10:25:20.619	2025-10-12 10:25:28.049	SUCCESS	0	0	0	\N	7430
2973	2025-10-12 10:29:21.899	2025-10-12 10:29:23.048	SUCCESS	0	0	0	\N	1149
2976	2025-10-12 10:30:21.899	2025-10-12 10:30:22.963	SUCCESS	0	0	0	\N	1064
3001	2025-10-12 10:41:56.1	2025-10-12 10:41:57.393	SUCCESS	0	0	0	\N	1293
3024	2025-10-12 10:53:51.661	2025-10-12 10:53:56.733	SUCCESS	0	0	0	\N	5072
3036	2025-10-12 11:04:34.146	2025-10-12 11:04:37.178	SUCCESS	1	0	1	\N	3032
3049	2025-10-12 11:14:31.39	2025-10-12 11:14:43.466	SUCCESS	1	0	0	\N	12076
3048	2025-10-12 11:14:29.721	2025-10-12 11:14:44.334	SUCCESS	1	0	1	\N	14613
3053	2025-10-12 11:15:31.413	2025-10-12 11:15:45.945	SUCCESS	1	0	0	\N	14532
3070	2025-10-12 11:19:35.865	2025-10-12 11:20:00.836	SUCCESS	1	0	0	\N	24971
3075	2025-10-12 11:20:43.471	2025-10-12 11:20:47.379	SUCCESS	1	0	1	\N	3908
3078	2025-10-12 11:21:35.899	2025-10-12 11:21:49.536	SUCCESS	1	0	0	\N	13637
3082	2025-10-12 11:22:35.92	2025-10-12 11:22:41.236	SUCCESS	0	0	0	\N	5316
3098	2025-10-12 11:26:36.007	2025-10-12 11:26:37.882	SUCCESS	0	0	0	\N	1875
3102	2025-10-12 11:28:30.046	2025-10-12 11:28:36.534	SUCCESS	0	0	0	\N	6488
3106	2025-10-12 11:30:30.05	2025-10-12 11:30:38.736	SUCCESS	0	0	0	\N	8686
3108	2025-10-12 11:31:30.05	2025-10-12 11:31:34.835	SUCCESS	0	0	0	\N	4785
3110	2025-10-12 11:31:51.14	2025-10-12 11:31:53.845	SUCCESS	0	0	0	\N	2705
3113	2025-10-12 11:32:51.141	2025-10-12 11:33:11.677	SUCCESS	0	0	0	\N	20536
3114	2025-10-12 11:33:30.089	2025-10-12 11:33:35.734	SUCCESS	0	0	0	\N	5645
3116	2025-10-12 11:33:51.17	2025-10-12 11:34:02.077	SUCCESS	0	0	0	\N	10907
3119	2025-10-12 11:34:51.2	2025-10-12 11:35:09.277	SUCCESS	1	0	1	\N	18077
3120	2025-10-12 11:35:30.128	2025-10-12 11:35:34.338	SUCCESS	1	0	1	\N	4210
3121	2025-10-12 11:35:51.229	2025-10-12 11:36:09.777	SUCCESS	1	0	1	\N	18548
3128	2025-10-12 11:39:29.689	2025-10-12 11:39:32.766	SUCCESS	1	0	1	\N	3077
3129	2025-10-12 11:39:51.289	2025-10-12 11:40:12.077	SUCCESS	1	0	1	\N	20788
3136	2025-10-12 11:43:51.368	2025-10-12 11:43:59.477	SUCCESS	0	0	0	\N	8109
3138	2025-10-12 11:44:51.395	2025-10-12 11:45:00.577	SUCCESS	0	0	0	\N	9182
2885	2025-10-12 09:11:43.72	2025-10-12 09:11:51.308	SUCCESS	0	0	0	\N	7588
2887	2025-10-12 09:13:44.073	2025-10-12 09:13:48.207	SUCCESS	0	0	0	\N	4134
2888	2025-10-12 09:15:44.082	2025-10-12 09:15:49.528	SUCCESS	0	0	0	\N	5446
2889	2025-10-12 09:16:44.087	2025-10-12 09:16:55.427	SUCCESS	0	0	0	\N	11340
2890	2025-10-12 09:17:44.104	2025-10-12 09:17:48.427	SUCCESS	0	0	0	\N	4323
2892	2025-10-12 09:19:44.136	2025-10-12 09:19:50.007	SUCCESS	0	0	0	\N	5871
2893	2025-10-12 09:20:44.153	2025-10-12 09:20:49.336	SUCCESS	0	0	0	\N	5183
2933	2025-10-12 10:09:20.287	2025-10-12 10:09:25.349	SUCCESS	0	0	0	\N	5062
2935	2025-10-12 10:10:20.292	2025-10-12 10:10:24.27	SUCCESS	0	0	0	\N	3978
2940	2025-10-12 10:12:20.341	2025-10-12 10:12:29.29	SUCCESS	0	0	0	\N	8949
2953	2025-10-12 10:19:21.89	2025-10-12 10:19:22.92	SUCCESS	0	0	0	\N	1030
2968	2025-10-12 10:26:20.643	2025-10-12 10:26:29.749	SUCCESS	0	0	0	\N	9106
2970	2025-10-12 10:27:20.667	2025-10-12 10:27:27.571	SUCCESS	0	0	0	\N	6904
2972	2025-10-12 10:28:20.679	2025-10-12 10:28:27.704	SUCCESS	0	0	0	\N	7025
2974	2025-10-12 10:29:20.704	2025-10-12 10:29:30.549	SUCCESS	0	0	0	\N	9845
2975	2025-10-12 10:29:49.686	2025-10-12 10:29:59.253	SUCCESS	0	0	0	\N	9567
2979	2025-10-12 10:31:51.159	2025-10-12 10:31:58.155	SUCCESS	0	0	0	\N	6996
2980	2025-10-12 10:31:58.706	2025-10-12 10:31:59.715	SUCCESS	0	0	0	\N	1009
2982	2025-10-12 10:32:51.184	2025-10-12 10:32:58.253	SUCCESS	0	0	0	\N	7069
2984	2025-10-12 10:33:20.791	2025-10-12 10:33:26.049	SUCCESS	0	0	0	\N	5258
2987	2025-10-12 10:34:51.229	2025-10-12 10:34:57.332	SUCCESS	0	0	0	\N	6103
2991	2025-10-12 10:36:51.281	2025-10-12 10:36:57.832	SUCCESS	0	0	0	\N	6551
2995	2025-10-12 10:38:51.332	2025-10-12 10:38:59.355	SUCCESS	0	0	0	\N	8023
3002	2025-10-12 10:42:51.432	2025-10-12 10:42:55.933	SUCCESS	0	0	0	\N	4501
3003	2025-10-12 10:42:56.1	2025-10-12 10:42:57.403	SUCCESS	0	0	0	\N	1303
3004	2025-10-12 10:43:51.457	2025-10-12 10:43:55.732	SUCCESS	0	0	0	\N	4275
3006	2025-10-12 10:44:51.482	2025-10-12 10:44:59.032	SUCCESS	1	0	0	\N	7550
3008	2025-10-12 10:45:51.494	2025-10-12 10:45:56.233	SUCCESS	0	0	0	\N	4739
3025	2025-10-12 10:53:56.103	2025-10-12 10:53:57.555	SUCCESS	0	0	0	\N	1452
3037	2025-10-12 11:05:34.147	2025-10-12 11:05:38.747	SUCCESS	2	0	2	\N	4600
3038	2025-10-12 11:06:34.148	2025-10-12 11:06:38.827	SUCCESS	2	0	2	\N	4679
3050	2025-10-12 11:14:34.153	\N	RUNNING	0	0	0	\N	\N
3079	2025-10-12 11:21:43.47	2025-10-12 11:21:46.106	SUCCESS	0	0	0	\N	2636
3107	2025-10-12 11:30:43.472	2025-10-12 11:30:44.782	SUCCESS	0	0	0	\N	1310
3109	2025-10-12 11:31:43.472	2025-10-12 11:31:45.65	SUCCESS	0	0	0	\N	2178
3131	2025-10-12 11:41:00.854	2025-10-12 11:41:03.696	SUCCESS	1	0	1	\N	2842
\.


--
-- Data for Name: products; Type: TABLE DATA; Schema: catalog; Owner: neondb_owner
--

COPY catalog.products (id, source, product_id, external_id, name, description, image_url, category, created_at, updated_at, raw_data) FROM stdin;
2	ALLEGRO	11957206330	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:03.948398	2025-10-06 17:22:30.916739	\N
4	ALLEGRO	10983158854	5905806203691	Wieszak ścienny WP60 na ubrania 60cm 5 uchwytów BIAŁY	\N	\N	\N	2025-10-06 17:15:57.801176	2025-10-06 17:22:24.927228	\N
5	ALLEGRO	17887745924	5905806208597	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Wotan	\N	\N	\N	2025-10-06 17:16:05.11784	2025-10-06 17:22:32.250706	\N
15	ALLEGRO	14384932878	5905806202212	Szafka na buty VB60x36D S1 siedzisko schowek 60cm WOTAN	\N	\N	\N	2025-10-06 17:15:59.543827	2025-10-06 17:22:26.662347	\N
22	ALLEGRO	16276323396	5905806233933	Komoda Bini 60x30D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:02.528744	2025-10-06 17:22:29.536323	\N
30	ALLEGRO	12487594818	5905806204988	Garderoba 80x30cm V50 Supra30 4 Panele D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:15:56.019495	2025-10-06 17:22:23.221558	\N
31	ALLEGRO	11873260685	5905806214246	Szafka na buty z szufladą Tres 80x82x36 SONOMA	\N	\N	\N	2025-10-06 17:16:01.360803	2025-10-06 17:22:28.425145	\N
32	ALLEGRO	15155236665	5905806209099	Szafka na buty z szufladą Tres 60x30D2N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:01.723085	2025-10-06 17:22:28.775281	\N
36	ALLEGRO	14384928066	5905806202038	Szafka na buty VB60x30D S1 siedzisko schowek 60cm ARTISAN	\N	\N	\N	2025-10-06 17:16:06.745646	2025-10-06 17:22:41.581542	\N
40	ALLEGRO	15919784146	5905806228984	Komoda Bones 50x36D1N1 SONOMA	\N	\N	\N	2025-10-06 17:15:58.019796	2025-10-06 17:22:30.099521	\N
42	ALLEGRO	15258808621	5905806210873	Wieszak ścienny W50 na ubrania 50cm WOTAN	\N	\N	\N	2025-10-06 17:16:03.65876	2025-10-06 17:22:30.611858	\N
44	ALLEGRO	15440331779	5905806218077	Zestaw VB80x30 Tres80x30 D1N1 szafka na buty siedzisko ARTISAN	\N	\N	\N	2025-10-06 17:16:04.599818	2025-10-06 17:22:31.552868	\N
46	ALLEGRO	15155237434	5905806209129	Szafka na buty z szufladą Tres 60x36D2N1 ARTISAN	\N	\N	\N	2025-10-06 17:16:04.818144	2025-10-06 17:22:31.760269	\N
48	ALLEGRO	11769358337	5905806222357	Panel ścienny tapicerowany pan1x50x35	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-06 17:22:32.515181	\N
49	ALLEGRO	13463849818	5905806203813	Wieszak ścienny WP50 ubrania 50cm 4 haki Lancelot	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-06 17:22:32.515181	\N
8	ALLEGRO	16724404597	5905806237191	Szafka na buty VB60x30D1N1 Dąb Estana	\N	5905806237191_1.jpg	\N	2025-10-06 17:15:55.367397	2025-10-11 21:35:02.022049	\N
17	ALLEGRO	17380187713	5905806202045	Szafka na buty VB60x30D1N1 Dąb Olejowany	\N	5905806202045_1.jpg	\N	2025-10-06 17:15:56.714736	2025-10-11 21:35:03.162429	\N
7	ALLEGRO	14384927614	5905806202014	Szafka na buty VB60x30D S1 siedzisko schowek 60cm WOTAN	\N	5905806202014_1.jpg	\N	2025-10-06 17:15:57.290996	2025-10-11 21:35:05.259937	\N
50	ALLEGRO	15176152026	5905806212952	Szafka komoda na buty 80x30 D2N1 Altus Dąb Artisan	\N	5905806212952_1.jpg	\N	2025-10-06 17:16:06.095193	2025-10-11 21:33:59.440091	\N
37	ALLEGRO	16276316851	5905806233896	Komoda Bini 60x30D1N1 BIAŁY	\N	5905806233896_1.jpg	\N	2025-10-06 17:16:02.750302	2025-10-11 21:32:52.324045	\N
12	ALLEGRO	16415950409	5905806231922	Szafka na buty VB50x36 D2N1 DĄB ARTISAN	\N	5905806231922_1.jpg	\N	2025-10-06 17:16:04.818144	2025-10-11 21:34:55.181825	\N
27	ALLEGRO	14387673937	5905806202366	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Czarny BIAŁY	\N	5905806202366_1.jpg	\N	2025-10-06 17:16:00.561855	2025-10-11 21:35:19.168184	\N
41	ALLEGRO	11906888620	5905806203578	Szafka na buty VB100x30D S1 siedzisko schowek 100cm DĄB SONOMA	\N	5905806203578_1.jpg	\N	2025-10-06 17:16:03.113694	2025-10-06 20:29:18.424548	\N
20	ALLEGRO	12266463730	5905806203899	Szafka na buty z szufladą Tres 30x30x82 Biały	\N	5905806203899_1.jpg	\N	2025-10-06 17:15:58.673348	2025-10-11 21:35:42.110242	\N
23	ALLEGRO	13854421583	5905204699973	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB WOTAN	\N	5905204699973_1.jpg	\N	2025-10-06 17:16:03.65876	2025-10-06 20:29:22.02912	\N
39	ALLEGRO	15221043126	5905806208337	Szafka na buty z szufladą Tres 60x36 Dąb Wotan	\N	5905806208337_1.jpg	\N	2025-10-06 17:15:54.48828	2025-10-11 21:36:00.391349	\N
1	ALLEGRO	15221503220	5905806214192	Szafka na buty z szufladą Tres 80x30 Dąb Wotan	\N	5905806214192_1.jpg	\N	2025-10-06 17:16:01.144793	2025-10-11 21:36:03.189396	\N
24	ALLEGRO	15155170458	5905806208788	Szafka na buty z szufladą Tres 80x30D1N1 CZARNY BIAŁY	\N	5905806208788_1.jpg	\N	2025-10-06 17:16:00.051972	2025-10-11 21:36:05.268305	\N
38	ALLEGRO	16602435582	5905806234596	Komoda Bini 80x30x82 D1N1 BIAŁY	\N	5905806234596_1.jpg	\N	2025-10-06 17:16:02.750302	2025-10-11 21:32:57.253946	\N
29	ALLEGRO	16602437468	5905806234688	Komoda Bini 80x36 D1N1 CZARNY	\N	5905806234688_1.jpg	\N	2025-10-06 17:16:00.779237	2025-10-11 21:32:59.302949	\N
26	ALLEGRO	14705411728	5905806203790	Wieszak ścienny WP50 na ubrania 50cm Dąb Sonoma	\N	5905806203790_1.jpg	\N	2025-10-06 17:16:00.268817	2025-10-11 21:36:37.027325	\N
56	ALLEGRO	11750203551	5905806208344	Szafka na buty z szufladą Tres 60x36 Biały	\N	5905806208344_1.jpg	\N	2025-10-06 17:16:10.568092	2025-10-11 21:35:56.259792	\N
33	ALLEGRO	12196322651	5905806203714	Wieszak ścienny WP60 na ubrania 60cm Lancelot	\N	5905806203714_1.jpg	\N	2025-10-06 17:16:01.723085	2025-10-11 08:58:14.9569	\N
3	ALLEGRO	15179529808	5905806213034	Szafka komoda na buty 50x30 D2N1 Altus Czarny	\N	5905806213034_1.jpg	\N	2025-10-06 17:15:58.457404	2025-10-11 21:33:54.191665	\N
55	ALLEGRO	11711299117	5905806203677	Wieszak ścienny WP60 na ubrania 60cm Sonoma	\N	5905806203677_1.jpg	\N	2025-10-06 17:16:01.360803	2025-10-11 08:58:16.756733	\N
35	ALLEGRO	16458885091	5905806221473	Zestaw Tres60x36D1N1 3PAN WP60 WOTAN	\N	5905806221473_1.jpg	\N	2025-10-06 17:16:02.012334	2025-10-11 08:58:45.656582	\N
14	ALLEGRO	15225572646	5905806213423	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 WOTAN	\N	5905806213423_1.jpg	\N	2025-10-06 17:15:55.584	2025-10-11 21:31:38.12786	\N
58	ALLEGRO	12487659714	5905204699591	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 Lancelot	\N	5905204699591_1.jpg	\N	2025-10-06 17:16:14.021211	2025-10-11 21:32:19.389136	\N
6	ALLEGRO	15251020703	5905806218220	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 CZARNY	\N	5905806218220_1.jpg	\N	2025-10-06 17:16:03.441281	2025-10-11 21:32:37.550485	\N
11	ALLEGRO	16602434928	5905806234558	Komoda Bini 50x36 D1N1 CZARNY	\N	5905806234558_1.jpg	\N	2025-10-06 17:16:00.779237	2025-10-11 21:32:49.730776	\N
10	ALLEGRO	14387669377	5905806202250	Szafka na buty VB80x30D S1 siedzisko schowek 80cm BIAŁY	\N	5905806202250_1.jpg	\N	2025-10-06 17:15:56.281456	2025-10-11 21:35:17.319181	\N
57	ALLEGRO	11750247503	5905806214208	Szafka na buty z szufladą Tres 80x36D1N1 Biały	\N	5905806214208_1.jpg	\N	2025-10-06 17:16:10.568092	2025-10-11 21:36:08.221877	\N
43	ALLEGRO	15919529373	5905806228229	Komoda Bones 60x36D4N1 SONOMA	\N	5905806228229_1.jpg	\N	2025-10-06 17:15:58.24065	2025-10-11 21:33:16.723542	\N
47	ALLEGRO	12258666208	5905806216974	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Biały	\N	5905806216974_1.jpg	\N	2025-10-06 17:15:57.584293	2025-10-06 20:28:46.795152	\N
25	ALLEGRO	10862951244	5905806209020	Szafka komoda na buty 50x30 D2N1 Altus Dąb Sonoma	\N	5905806209020_1.jpg	\N	2025-10-06 17:16:00.268817	2025-10-11 21:33:55.298786	\N
13	ALLEGRO	16602433072	5905806234473	Komoda Bini 50x30x82 D1N1 BIAŁY	\N	5905806234473_1.jpg	\N	2025-10-06 17:16:02.750302	2025-10-06 20:28:54.066652	\N
52	ALLEGRO	12476639410	5905204699454	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Dąb Sonoma	\N	5905204699454_1.jpg	\N	2025-10-06 17:16:06.528834	2025-10-11 21:34:15.291769	\N
16	ALLEGRO	17496557717	5905806238860	Szafka na buty VB100x30 D3N3 CZARNY	\N	5905806238860_1.jpg	\N	2025-10-06 17:15:59.76086	2025-10-11 21:34:32.28244	\N
28	ALLEGRO	10814138050	5905806200027	Szafka na buty VB50x30 D1N1 siedzisko schowek 50cm BIAŁY	\N	5905806200027_1.jpg	\N	2025-10-06 17:15:55.802962	2025-10-11 21:34:44.364478	\N
21	ALLEGRO	14384926745	5905806201994	Szafka na buty VB60x30D S1 siedzisko schowek 60cm BIAŁY	\N	5905806201994_1.jpg	\N	2025-10-06 17:16:02.302127	2025-10-11 21:34:58.052339	\N
34	ALLEGRO	16723583463	5905806237160	Szafka na buty z lustrem Supra 60x36 Szafa z szufladą D1N1 DĄB WOTAN	\N	5905806237160_1.jpg	\N	2025-10-06 17:16:02.012334	2025-10-11 21:35:34.104387	\N
61	ALLEGRO	14387670556	5905806202274	Szafka na buty VB80x30D S1 siedzisko schowek 80cm WOT	\N	\N	\N	2025-10-06 17:16:07.872784	2025-10-06 17:22:34.72799	\N
63	ALLEGRO	15919782083	5905806228946	Komoda Bones 50x36D1N1 ARTISAN	\N	\N	\N	2025-10-06 17:16:08.392572	2025-10-06 17:22:35.211303	\N
64	ALLEGRO	16602433840	5905806234503	Komoda Bini 50x30x82 D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:11.372612	2025-10-06 17:22:38.133873	\N
65	ALLEGRO	15112615224	5905806208528	Zestaw szafka na buty siedzisko VB60x30D1N1 Tres60 z szufladą Czarny Sonoma	\N	\N	\N	2025-10-06 17:16:11.988705	2025-10-06 17:22:38.737	\N
67	ALLEGRO	10862736322	5905806202007	Szafka na buty VB60x30D S1 siedzisko schowek 60cm Dąb Sonoma	\N	\N	\N	2025-10-06 17:16:12.494462	2025-10-06 17:22:39.219797	\N
73	ALLEGRO	16625973548	5905806222531	Siedzisko tapicerowane 50x29cm do szafki 50x30	\N	\N	\N	2025-10-06 17:16:15.120059	2025-10-06 17:22:41.788842	\N
74	ALLEGRO	14387674513	5905806202397	Szafka na buty VB80x36D S1 siedzisko schowek 80cm SO	\N	\N	\N	2025-10-06 17:16:15.373135	2025-10-06 17:22:42.030751	\N
76	ALLEGRO	15919776449	5905806228854	Komoda Bones 60x36D1N1 LANCELOT	\N	\N	\N	2025-10-06 17:16:13.585282	2025-10-06 17:22:42.667603	\N
80	ALLEGRO	14387675243	5905806202441	Szafka na buty VB80x36 D1N1 siedzisko, schowek 80cm Czarny	\N	\N	\N	2025-10-06 17:16:13.804885	2025-10-06 17:22:40.537619	\N
82	ALLEGRO	14387674903	5905806202427	Szafka na buty VB80x36D S1 siedzisko schowek 80cm ARTISAN	\N	\N	\N	2025-10-06 17:16:17.357182	2025-10-06 17:22:43.916719	\N
84	ALLEGRO	16602440992	5905806234763	Komoda Bini 100x36 D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:17.582405	2025-10-06 17:22:44.123278	\N
85	ALLEGRO	15121615649	5905806205138	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1D1Wotan	\N	\N	\N	2025-10-06 17:16:09.045078	2025-10-06 17:22:35.837192	\N
87	ALLEGRO	15440328552	5905806216875	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko LANCELOT	\N	\N	\N	2025-10-06 17:16:05.551656	2025-10-06 17:22:32.515181	\N
88	ALLEGRO	15315950401	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	\N	\N	\N	2025-10-06 17:16:06.963906	2025-10-06 17:22:33.859528	\N
86	ALLEGRO	15221331957	5905806214109	Szafka na buty z szufladą Tres 50x36 Czarny	\N	5905806214109_1.jpg	\N	2025-10-06 17:16:00.779237	2025-10-11 21:35:49.480784	\N
66	ALLEGRO	11769334649	5905806208429	Panel ścienny tapicerowany pan1x60x30	\N	5905806208429_1.jpg	\N	2025-10-06 17:16:12.241757	2025-10-11 21:33:38.379244	\N
71	ALLEGRO	15176150939	5905806209549	Szafka komoda na buty 80x30 D2N1 Altus CZARNY	\N	5905806209549_1.jpg	\N	2025-10-06 17:16:14.4606	2025-10-11 21:33:58.472875	\N
79	ALLEGRO	15685820231	5905806221923	Szafka na buty z szufladą Tres 60x30D1N3 CZARNY	\N	5905806221923_1.jpg	\N	2025-10-06 17:16:16.919578	2025-10-11 21:35:53.35264	\N
72	ALLEGRO	15176150526	5905806209525	Szafka komoda na buty 80x30 D2N1 Altus WOTAN	\N	5905806209525_1.jpg	\N	2025-10-06 17:16:14.681236	2025-10-11 21:34:00.385046	\N
92	ALLEGRO	16271360906	5905806233643	Szafka na buty Supra-Nex 30x30D1N1 SONOMA	\N	5905806233643_1.jpg	\N	2025-10-06 17:16:09.916884	2025-10-11 21:34:30.313079	\N
90	ALLEGRO	14604181578	5905806203660	Wieszak ścienny WP60 na ubrania 60cm Dąb Wotan	\N	5905806203660_1.jpg	\N	2025-10-06 17:15:57.290996	2025-10-11 08:58:12.757903	\N
168	SHOPER	910	5905806203592	Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan	\N	5905806203592_1.jpg	\N	2025-10-06 18:33:05.894736	2025-10-11 08:58:18.456923	{"id": "27016", "tax": "23%", "code": "5905806203592", "name": "Wieszak ścienny WP80 na ubrania 80cm Dąb Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "278.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "1", "stock_id": "1269", "tax_value": "23", "product_id": "910", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
68	ALLEGRO	15440328823	5905806217902	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko BIAŁY	\N	5905806217902_1.jpg	\N	2025-10-06 17:16:12.713229	2025-10-11 08:58:47.856486	\N
51	ALLEGRO	15225570547	5905806213379	Garderoba 100x30cm Supra50 VB50 4 Panele WP50 D1N1 BIAŁY	\N	5905806213379_1.jpg	\N	2025-10-06 17:16:06.312678	2025-10-11 21:31:35.936407	\N
89	ALLEGRO	17358916449	5905806237795	Garderoba 90x30cm D1N1 szafka na buty V60 Supra30 4 Panele Wieszak Kaszmir	\N	5905806237795_1.jpg	\N	2025-10-06 17:15:55.148372	2025-10-11 21:32:30.351896	\N
83	ALLEGRO	15109022782	5905806207569	Garderoba 80x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	\N	5905806207569_1.jpg	\N	2025-10-06 17:16:08.608804	2025-10-11 21:32:09.24357	\N
77	ALLEGRO	11769094598	5905806204087	Szafka na buty VB100x30D S1 siedzisko schowek 100cm BIAŁY	\N	5905806204087_1.jpg	\N	2025-10-06 17:16:16.253145	2025-10-11 21:34:33.426245	\N
91	ALLEGRO	15977138561	5905806229035	Komoda Bones 50x36D4N1 CZARNY	\N	5905806229035_1.jpg	\N	2025-10-06 17:16:09.483689	2025-10-11 21:33:07.86842	\N
60	ALLEGRO	11873248609	5905806208252	Szafka na buty z szufladą Tres 60x30 Dąb Sonoma	\N	5905806208252_1.jpg	\N	2025-10-06 17:16:11.149895	2025-10-11 21:35:52.412843	\N
93	ALLEGRO	15221043005	5905806208320	Szafka na buty z szufladą Tres 60x36 Dąb Artisan	\N	5905806208320_1.jpg	\N	2025-10-06 17:16:10.134542	2025-10-11 21:35:58.412663	\N
59	ALLEGRO	15176238729	5905806209662	Szafka komoda na buty 80x36 D2N1 Altus WOTAN	\N	5905806209662_1.jpg	\N	2025-10-06 17:16:07.872784	2025-10-11 21:34:02.345307	\N
95	ALLEGRO	12266374192	5905806208986	Szafka na buty Supra 30 słupek 30x36 D1N1 Biały	\N	5905806208986_1.jpg	\N	2025-10-06 17:16:10.568092	2025-10-11 21:34:10.148754	\N
62	ALLEGRO	15048053205	5905806205435	Szafka na buty VB100x30D S1 siedzisko schowek 100cm Czarny	\N	5905806205435_1.jpg	\N	2025-10-06 17:16:08.165996	2025-10-11 21:34:34.492136	\N
169	SHOPER	918	5905806205473	Szafka na buty VB100x36D S1 siedzisko schowek 100cm Artisan	\N	5905806205473_1.jpg	\N	2025-10-06 18:33:05.894736	2025-10-11 21:34:39.246152	{"id": "27017", "tax": "0%", "code": "5905806205473", "name": "Szafka na buty VB100x36D S1 siedzisko schowek 100cm Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "546.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "1", "stock_id": "1277", "tax_value": "0", "product_id": "918", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
75	ALLEGRO	15225857105	5905806206678	Szafka na buty VB100x36D S1 siedzisko schowek 100cm BIAŁY	\N	5905806206678_1.jpg	\N	2025-10-06 17:16:15.595209	2025-10-11 21:34:40.383545	\N
70	ALLEGRO	15112696299	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	\N	5905806208580_1.jpg	\N	2025-10-06 17:16:08.824264	2025-10-11 08:59:11.256913	\N
94	ALLEGRO	14384932329	5905806202199	Szafka na buty VB60x36D S1 siedzisko schowek 60cm BIAŁY	\N	5905806202199_1.jpg	\N	2025-10-06 17:16:10.351011	2025-10-11 21:35:09.179647	\N
81	ALLEGRO	16645309565	5905806216813	Szafka na buty VB80x30D1N2 LANCELOT	\N	5905806216813_1.jpg	\N	2025-10-06 17:16:17.140211	2025-10-11 21:35:24.233799	\N
69	ALLEGRO	14387674355	5905806202380	Szafka na buty VB80x36D S1 siedzisko schowek 80cm BIAŁY	\N	5905806202380_1.jpg	\N	2025-10-06 17:16:12.929991	2025-10-11 21:35:28.118399	\N
78	ALLEGRO	14387674657	5905806202403	Szafka na buty VB80x36D S1 siedzisko schowek 80cm DĄB WOTAN	\N	5905806202403_1.jpg	\N	2025-10-06 17:16:09.262461	2025-10-11 21:35:31.237776	\N
179	SHOPER	2806	5905806211016	Wieszak ścienny W60 na ubrania 60cm WOTAN	\N	\N	\N	2025-10-06 18:33:08.83739	2025-10-06 18:33:08.83739	{"id": "27010", "tax": "23%", "code": "5905806211016", "name": "Wieszak ścienny W60 na ubrania 60cm WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "193.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23148", "quantity": "1", "stock_id": "3204", "tax_value": "23", "product_id": "2806", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
176	SHOPER	165	5905806208955	Szafka nocna NOX 40x36  2 szuflady schowek biały	\N	5905806208955_1.jpg	\N	2025-10-06 18:33:08.207471	2025-10-11 21:36:19.159746	{"id": "27012", "tax": "23%", "code": "5905806208955", "name": "Szafka nocna NOX 40x36  2 szuflady schowek biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "352.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23149", "quantity": "1", "stock_id": "494", "tax_value": "23", "product_id": "165", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
173	SHOPER	2428	5905806233544	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 CZARNY WOTAN	\N	5905806233544_1.jpg	\N	2025-10-06 18:33:07.209279	2025-10-11 21:33:20.380783	{"id": "27014", "tax": "23%", "code": "5905806233544", "name": "Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 CZARNY WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "418.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23151", "quantity": "1", "stock_id": "2826", "tax_value": "23", "product_id": "2428", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
174	SHOPER	708	5905806202267	Szafka na buty VB80x30D S1 siedzisko schowek 80cm SO	\N	5905806202267_1.jpg	\N	2025-10-06 18:33:07.700476	2025-10-11 21:35:23.165698	{"id": "27013", "tax": "0%", "code": "5905806202267", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm SO", "type": "0", "unit": "szt.", "pkwiu": "", "price": "399.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23150", "quantity": "1", "stock_id": "1037", "tax_value": "0", "product_id": "708", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
181	SHOPER	3580	5905806238587	 Szafka na buty VB100x36D1N1 Dąb Estana	\N	5905806238587_1.jpg	\N	2025-10-06 18:33:10.090647	2025-10-11 21:31:34.996183	{"id": "27006", "tax": "23%", "code": "5905806238587", "name": " Szafka na buty VB100x36D1N1 Dąb Estana", "type": "0", "unit": "szt.", "pkwiu": "", "price": "546.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23146", "quantity": "1", "stock_id": "3978", "tax_value": "23", "product_id": "3580", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
172	SHOPER	1064	5905204699560	Garderoba 80x30cm V50 Supra30 4 Panele D1 BIA	\N	5905204699560_1.jpg	\N	2025-10-06 18:33:06.723802	2025-10-11 21:32:14.065065	{"id": "27015", "tax": "23%", "code": "5905204699560", "name": "Garderoba 80x30cm V50 Supra30 4 Panele D1 BIA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1283.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23152", "quantity": "1", "stock_id": "1434", "tax_value": "23", "product_id": "1064", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
180	SHOPER	1627	5905806217001	Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Czarny	\N	5905806217001_1.jpg	\N	2025-10-06 18:33:09.587604	2025-10-11 21:31:50.215741	{"id": "27007", "tax": "23%", "code": "5905806217001", "name": "Garderoba 120x36cm SUPRA 60-VB 60-4PAN-WP60 D1N1 Czarny", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1887.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23147", "quantity": "1", "stock_id": "2013", "tax_value": "23", "product_id": "1627", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
177	SHOPER	589	5905806217681	Szafka na buty z szufladą Tres2 60x92x30 DĄB WOTAN	\N	5905806217681_1.jpg	\N	2025-10-06 18:33:08.83739	2025-10-11 21:36:10.143642	{"id": "27008", "tax": "23%", "code": "5905806217681", "name": "Szafka na buty z szufladą Tres2 60x92x30 DĄB WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "452.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23148", "quantity": "1", "stock_id": "918", "tax_value": "23", "product_id": "589", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
178	SHOPER	2822	5905806235067	Szafka na buty Supra-Nex 50x36x244 D1N1 WOTAN	\N	5905806235067_1.jpg	\N	2025-10-06 18:33:08.83739	2025-10-11 21:34:31.294921	{"id": "27009", "tax": "23%", "code": "5905806235067", "name": "Szafka na buty Supra-Nex 50x36x244 D1N1 WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1309.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23148", "quantity": "1", "stock_id": "3220", "tax_value": "23", "product_id": "2822", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
175	SHOPER	2030	5905806228199	Komoda Bones 60x36D4N1 ARTISAN	\N	5905806228199_1.jpg	\N	2025-10-06 18:33:08.207471	2025-10-11 21:33:14.89645	{"id": "27011", "tax": "23%", "code": "5905806228199", "name": "Komoda Bones 60x36D4N1 ARTISAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "725.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23149", "quantity": "1", "stock_id": "2428", "tax_value": "23", "product_id": "2030", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
183	SHOPER	860	5905806203370	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele CZARNY-LANCELOT	\N	\N	\N	2025-10-06 18:52:35.818776	2025-10-06 18:52:35.818776	{"id": "27021", "tax": "0%", "code": "5905806203370", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele CZARNY-LANCELOT", "type": "0", "unit": "szt.", "pkwiu": "", "price": "811.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23155", "quantity": "1", "stock_id": "1204", "tax_value": "0", "product_id": "860", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
184	SHOPER	986	5905806208580	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan	\N	5905806208580_1.jpg	\N	2025-10-06 19:00:30.430201	2025-10-11 08:59:11.256913	{"id": "27022", "tax": "23%", "code": "5905806208580", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Dąb Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "828.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23156", "quantity": "1", "stock_id": "1356", "tax_value": "23", "product_id": "986", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
170	SHOPER	892	5905806208412	Panel ścienny tapicerowany 80x30	\N	5905806208412_1.jpg	\N	2025-10-06 18:33:05.894736	2025-10-11 21:33:39.335332	{"id": "27018", "tax": "23%", "code": "5905806208412", "name": "Panel ścienny tapicerowany 80x30", "type": "0", "unit": "szt.", "pkwiu": "", "price": "75.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "3", "stock_id": "1251", "tax_value": "23", "product_id": "892", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
19	ALLEGRO	12266508168	5905204699089	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 BIAŁY	\N	5905204699089_1.jpg	\N	2025-10-06 17:15:54.712851	2025-10-11 21:32:36.375805	\N
182	SHOPER	3702	5905806238525	Próbki płyt meblowych	\N	5905806238525_1.jpg	\N	2025-10-06 18:46:15.550476	2025-10-11 21:33:41.833268	{"id": "27020", "tax": "23%", "code": "5905806238525", "name": "Próbki płyt meblowych", "type": "0", "unit": "szt.", "pkwiu": "", "price": "30.00", "option": "", "weight": "2", "loyalty": null, "unit_fp": "0", "order_id": "23154", "quantity": "1", "stock_id": "4100", "tax_value": "23", "product_id": "3702", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
189	ALLEGRO	16901470101	5905806211528	Wieszak ścienny WP100 na ubrania 100cm WOTAN	\N	\N	\N	2025-10-06 19:33:24.984842	2025-10-06 19:33:24.984842	{"id": "b22cb0e0-a2e1-11f0-aba2-b3553c261cc2", "tax": null, "offer": {"id": "16901470101", "name": "Wieszak ścienny WP100 na ubrania 100cm WOTAN", "external": {"id": "5905806211528"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T18:26:05.247Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
45	ALLEGRO	15410022839	5905806218855	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Dąb Wotan	\N	5905806218855_1.jpg	\N	2025-10-06 17:15:54.931668	2025-10-11 21:34:27.348752	\N
171	SHOPER	1231	5905806213232	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Dąb Artisan	\N	5905806213232_1.jpg	\N	2025-10-06 18:33:05.894736	2025-10-11 21:34:20.369367	{"id": "27019", "tax": "23%", "code": "5905806213232", "name": "Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Dąb Artisan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1015.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23153", "quantity": "1", "stock_id": "1609", "tax_value": "23", "product_id": "1231", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
187	ALLEGRO	15463830012	5905806220605	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Czarny Dąb Artisan	\N	5905806220605_1.jpg	\N	2025-10-06 19:33:23.533952	2025-10-11 21:34:24.367802	{"id": "c8d78270-a2e6-11f0-a638-c7e352f2113f", "tax": null, "offer": {"id": "15463830012", "name": "Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Czarny Dąb Artisan", "external": {"id": "5905806220605"}, "productSet": null}, "price": {"amount": "1052.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T19:01:56.711Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1052.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
9	ALLEGRO	14384932618	5905806202205	Szafka na buty VB60x36D S1 siedzisko schowek 60cm DĄB SONOMA	\N	5905806202205_1.jpg	\N	2025-10-06 17:16:01.360803	2025-10-11 21:35:11.30406	\N
54	ALLEGRO	15685809460	5905806222005	Szafka na buty z szufladą Tres 60x36D1N3 CZARNY	\N	5905806222005_1.jpg	\N	2025-10-06 17:15:59.76086	2025-10-11 21:36:01.337396	\N
18	ALLEGRO	16319665889	5905806234268	Komoda szafka NEX 80x30x124 sypialnia salon przedpokój D1N1 BIAŁY	\N	5905806234268_1.jpg	\N	2025-10-06 17:15:59.112099	2025-10-11 21:33:27.642856	\N
188	ALLEGRO	14384920401	5905806201840	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm DĄB ARTISAN	\N	5905806201840_1.jpg	\N	2025-10-06 19:33:24.102967	2025-10-11 21:34:53.34382	{"id": "90776680-a2e5-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "14384920401", "name": "Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm DĄB ARTISAN", "external": {"id": "5905806201840"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T18:52:40.641Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
185	SHOPER	2590	5905806231984	Szafka na buty VB60x36D2N1 WOTAN	\N	5905806231984_1.jpg	\N	2025-10-06 19:27:17.659069	2025-10-11 21:35:15.312557	{"id": "27023", "tax": "23%", "code": "5905806231984", "name": "Szafka na buty VB60x36D2N1 WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "368.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23157", "quantity": "1", "stock_id": "2988", "tax_value": "23", "product_id": "2590", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
53	ALLEGRO	14563825336	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	\N	5905806203585_1.jpg	\N	2025-10-06 17:16:04.383082	2025-10-11 08:58:33.256666	\N
190	ALLEGRO	15919784886	5905806228991	Komoda Bones 50x36D1N1 WOTAN	\N	\N	\N	2025-10-06 19:33:25.920887	2025-10-06 19:33:25.920887	{"id": "35817720-a2db-11f0-8b51-87d1833631ec", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919784886", "name": "Komoda Bones 50x36D1N1 WOTAN", "external": {"id": "5905806228991"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:38:33.286Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
193	ALLEGRO	17395006524	5905806238310	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY	\N	5905806238310_1.jpg	\N	2025-10-06 19:33:27.296289	2025-10-11 21:34:16.292332	{"id": "617f48e0-a2d9-11f0-a638-c7e352f2113f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17395006524", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 OLEJOWANY", "external": {"id": "5905806238310"}, "productSet": null}, "price": {"amount": "788.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:26:46.285Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "788.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
199	SHOPER	3361	5905806203509	Zestaw 80x30D1N1 WP80 szafka na buty z wieszakiem LANCELOT	\N	\N	\N	2025-10-09 19:01:05.885702	2025-10-09 19:01:05.885702	{"id": "27052", "tax": "23%", "code": "5905806203509", "name": "Zestaw 80x30D1N1 WP80 szafka na buty z wieszakiem LANCELOT", "type": "0", "unit": "szt.", "pkwiu": "", "price": "677.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23178", "quantity": "1", "stock_id": "3759", "tax_value": "23", "product_id": "3361", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
192	ALLEGRO	12487594410	5905204699560	Garderoba 80x30cm V50 Supra30 4 Panele D1 BIAŁY	\N	5905204699560_1.jpg	\N	2025-10-06 19:33:26.829456	2025-10-11 21:32:14.065065	{"id": "b08f0010-a2d9-11f0-abd8-f5344f24907b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12487594410", "name": "Garderoba 80x30cm V50 Supra30 4 Panele D1 BIAŁY", "external": {"id": "5905204699560"}, "productSet": null}, "price": {"amount": "1283.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:29:26.939Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1283.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
198	SHOPER	2145	5905806229011	Komoda Bones 60x36D4N1 CZARNY	\N	5905806229011_1.jpg	\N	2025-10-09 19:01:04.235908	2025-10-11 21:33:15.882535	{"id": "27053", "tax": "23%", "code": "5905806229011", "name": "Komoda Bones 60x36D4N1 CZARNY", "type": "0", "unit": "szt.", "pkwiu": "", "price": "725.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23179", "quantity": "1", "stock_id": "2543", "tax_value": "23", "product_id": "2145", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
200	SHOPER	2104	5905806228946	Komoda Bones 50x36D1N1 ARTISAN	\N	\N	\N	2025-10-09 19:01:07.26201	2025-10-09 19:01:07.26201	{"id": "27050", "tax": "23%", "code": "5905806228946", "name": "Komoda Bones 50x36D1N1 ARTISAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "638.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23177", "quantity": "1", "stock_id": "2502", "tax_value": "23", "product_id": "2104", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
201	SHOPER	3206	5905806227253	Garderoba 60x30D1N1 3PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-09 19:01:07.26201	2025-10-09 19:01:07.26201	{"id": "27051", "tax": "0%", "code": "5905806227253", "name": "Garderoba 60x30D1N1 3PAN szafka na buty wieszak panele ARTISAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "747.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23177", "quantity": "1", "stock_id": "3604", "tax_value": "0", "product_id": "3206", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
202	SHOPER	1314	5905806214581	Szafka na buty z szufladą Tres 100x36D1N1 SONOMA	\N	\N	\N	2025-10-09 19:01:08.794663	2025-10-09 19:01:08.794663	{"id": "27048", "tax": "23%", "code": "5905806214581", "name": "Szafka na buty z szufladą Tres 100x36D1N1 SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "611.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23176", "quantity": "1", "stock_id": "1692", "tax_value": "23", "product_id": "1314", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
197	SHOPER	3713	5905806240306	Komoda Bones 80x36D1N1 Wotan	\N	5905806240306_1.jpg	\N	2025-10-09 19:00:46.54845	2025-10-11 21:33:17.627026	{"id": "27043", "tax": "23%", "code": "5905806240306", "name": "Komoda Bones 80x36D1N1 Wotan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "758.00", "option": "", "weight": "30", "loyalty": null, "unit_fp": "0", "order_id": "23173", "quantity": "1", "stock_id": "4111", "tax_value": "23", "product_id": "3713", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
191	ALLEGRO	16859417789	5905806210613	Półka ścienna 80x18x20cm CZARNY	\N	5905806210613_1.jpg	\N	2025-10-06 19:33:26.374775	2025-10-11 21:33:47.117756	{"id": "132bc050-a2da-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "16859417789", "name": "Półka ścienna 80x18x20cm CZARNY", "external": {"id": "5905806210613"}, "productSet": null}, "price": {"amount": "98.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-06T17:30:22.850Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "98.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
203	SHOPER	1480	5905806215991	Szafka na buty z wieszakiem VB50x36D1N1 WP50  SONOMA	\N	\N	\N	2025-10-09 19:01:08.794663	2025-10-09 19:01:08.794663	{"id": "27049", "tax": "23%", "code": "5905806215991", "name": "Szafka na buty z wieszakiem VB50x36D1N1 WP50  SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "531.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23176", "quantity": "1", "stock_id": "1866", "tax_value": "23", "product_id": "1480", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
204	SHOPER	1641	5905806218558	Tkanina Fjord Czarny	\N	\N	\N	2025-10-09 19:01:10.253988	2025-10-09 19:01:10.253988	{"id": "27044", "tax": "23%", "code": "5905806218558", "name": "Tkanina Fjord Czarny", "type": "0", "unit": "szt.", "pkwiu": "", "price": "30.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23174", "quantity": "1", "stock_id": "2039", "tax_value": "23", "product_id": "1641", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
207	SHOPER	974	5905806208467	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma	\N	\N	\N	2025-10-09 19:01:14.203914	2025-10-09 19:01:14.203914	{"id": "27033", "tax": "23%", "code": "5905806208467", "name": "Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Sonoma", "type": "0", "unit": "szt.", "pkwiu": "", "price": "780.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23167", "quantity": "1", "stock_id": "1344", "tax_value": "23", "product_id": "974", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
214	SHOPER	348	5905204699096	Garderoba 90x36cm V60 Supra30 4 Panele D1 SONOMA	\N	5905204699096_1.jpg	\N	2025-10-09 19:01:57.873794	2025-10-11 21:32:34.18524	{"id": "27037", "tax": "23%", "code": "5905204699096", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1 SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1391.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23169", "quantity": "1", "stock_id": "677", "tax_value": "23", "product_id": "348", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
212	SHOPER	1219	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	\N	5905806213560_1.jpg	\N	2025-10-09 19:01:55.104179	2025-10-11 21:34:14.301146	{"id": "27040", "tax": "23%", "code": "5905806213560", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "954.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23171", "quantity": "1", "stock_id": "1597", "tax_value": "23", "product_id": "1219", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
205	SHOPER	890	5905806208429	Panel ścienny tapicerowany pan1x60x30	\N	5905806208429_1.jpg	\N	2025-10-09 19:01:10.253988	2025-10-11 21:33:38.379244	{"id": "27045", "tax": "23%", "code": "5905806208429", "name": "Panel ścienny tapicerowany pan1x60x30", "type": "0", "unit": "szt.", "pkwiu": "", "price": "64.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23174", "quantity": "1", "stock_id": "1249", "tax_value": "23", "product_id": "890", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
215	SHOPER	3711	5905806240115	Szafka na buty VB60x36 D1N1 siedzisko, schowek KASZMIR	\N	5905806240115_1.jpg	\N	2025-10-09 19:01:59.153419	2025-10-11 21:35:07.316391	{"id": "27030", "tax": "23%", "code": "5905806240115", "name": "Szafka na buty VB60x36 D1N1 siedzisko, schowek KASZMIR", "type": "0", "unit": "szt.", "pkwiu": "", "price": "350.00", "option": "", "weight": "18", "loyalty": null, "unit_fp": "0", "order_id": "23164", "quantity": "1", "stock_id": "4109", "tax_value": "23", "product_id": "3711", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
209	SHOPER	963	5905806208399	Szafka na buty z szufladą Tres 60x36 Czarny Biały	\N	5905806208399_1.jpg	\N	2025-10-09 19:01:49.623499	2025-10-11 21:35:57.413038	{"id": "27046", "tax": "23%", "code": "5905806208399", "name": "Szafka na buty z szufladą Tres 60x36 Czarny Biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "478.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23175", "quantity": "1", "stock_id": "1328", "tax_value": "23", "product_id": "963", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
213	SHOPER	1787	5905806208344	Szafka na buty z szufladą Tres 60x36 Biały	\N	5905806208344_1.jpg	\N	2025-10-09 19:01:55.104179	2025-10-11 21:35:56.259792	{"id": "27041", "tax": "23%", "code": "5905806208344", "name": "Szafka na buty z szufladą Tres 60x36 Biały", "type": "0", "unit": "szt.", "pkwiu": "", "price": "478.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23171", "quantity": "1", "stock_id": "2185", "tax_value": "23", "product_id": "1787", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
208	SHOPER	1000	5905806211375	Wieszak ścienny W100 na ubrania 100cm SONOMA	\N	5905806211375_1.jpg	\N	2025-10-09 19:01:14.203914	2025-10-11 21:36:24.034616	{"id": "27034", "tax": "23%", "code": "5905806211375", "name": "Wieszak ścienny W100 na ubrania 100cm SONOMA", "type": "0", "unit": "szt.", "pkwiu": "", "price": "241.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23167", "quantity": "1", "stock_id": "1370", "tax_value": "23", "product_id": "1000", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
210	SHOPER	732	5905806202502	Szafka na buty VB80x36D S1 siedzisko schowek 80cm Czarny BIAŁY	\N	5905806202502_1.jpg	\N	2025-10-09 19:01:49.623499	2025-10-11 21:35:30.179187	{"id": "27047", "tax": "0%", "code": "5905806202502", "name": "Szafka na buty VB80x36D S1 siedzisko schowek 80cm Czarny BIAŁY", "type": "0", "unit": "szt.", "pkwiu": "", "price": "423.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23175", "quantity": "1", "stock_id": "1061", "tax_value": "0", "product_id": "732", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
206	SHOPER	909	5905806203585	Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan	\N	5905806203585_1.jpg	\N	2025-10-09 19:01:12.890428	2025-10-11 08:58:33.256666	{"id": "27042", "tax": "23%", "code": "5905806203585", "name": "Wieszak ścienny WP80 na ubrania 80cm Dąb Wotan", "type": "0", "unit": "szt.", "pkwiu": "", "price": "278.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23172", "quantity": "1", "stock_id": "1268", "tax_value": "23", "product_id": "909", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
217	ALLEGRO	13855292522	5905806200010	Szafka na buty VB50x30 D1N1 siedzisko, schowek DĄB LANCELOT	\N	5905806200010_1.jpg	\N	2025-10-09 19:30:10.915407	2025-10-11 21:34:48.212266	{"id": "27407420-a544-11f0-bb74-8b6fbb6f100b", "tax": null, "offer": {"id": "13855292522", "name": "Szafka na buty VB50x30 D1N1 siedzisko, schowek DĄB LANCELOT", "external": {"id": "5905806200010"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T19:15:34.727Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
218	ALLEGRO	16859415981	5905806210293	Półka ścienna 50x18x20cm WOTAN	\N	\N	\N	2025-10-09 19:31:22.488416	2025-10-09 19:31:22.488416	{"id": "13758aa0-a537-11f0-9cb2-b90a5baab897", "tax": null, "offer": {"id": "16859415981", "name": "Półka ścienna 50x18x20cm WOTAN", "external": {"id": "5905806210293"}, "productSet": null}, "price": {"amount": "76.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T17:41:40.314Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "76.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
222	ALLEGRO	16602435285	5905806234589	Komoda Bini 50x36 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:31:31.851944	2025-10-09 19:31:31.851944	{"id": "6d481a60-a51a-11f0-a588-b391296a673a", "tax": null, "offer": {"id": "16602435285", "name": "Komoda Bini 50x36 D1N1 WOTAN", "external": {"id": "5905806234589"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T14:16:23.628Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
224	ALLEGRO	14387672711	5905806202335	Szafka na buty VB80x30D S1 siedzisko schowek 80cm Cza Wotan	\N	\N	\N	2025-10-09 19:31:38.174424	2025-10-09 19:31:38.174424	{"id": "2688a332-a4ff-11f0-b9bf-2795de008363", "tax": null, "offer": {"id": "14387672711", "name": "Szafka na buty VB80x30D S1 siedzisko schowek 80cm Cza Wotan", "external": {"id": "5905806202335"}, "productSet": null}, "price": {"amount": "399.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T11:07:01.911Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "399.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
211	SHOPER	3496	5905806237825	Garderoba 60x36D1N1-4PAN szafka na buty wieszak panele Kaszmir	\N	5905806237825_1.jpg	\N	2025-10-09 19:01:55.104179	2025-10-11 21:32:07.157263	{"id": "27039", "tax": "0%", "code": "5905806237825", "name": "Garderoba 60x36D1N1-4PAN szafka na buty wieszak panele Kaszmir", "type": "0", "unit": "szt.", "pkwiu": "", "price": "835.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23171", "quantity": "1", "stock_id": "3894", "tax_value": "0", "product_id": "3496", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
221	ALLEGRO	12266508963	5905204699102	Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot	\N	5905204699102_1.jpg	\N	2025-10-09 19:31:30.312269	2025-10-11 21:32:32.225492	{"id": "e9a4c980-a521-11f0-b989-75c7faccd1ca", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12266508963", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1 Lancelot", "external": {"id": "5905204699102"}, "productSet": null}, "price": {"amount": "1332.40", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T15:14:38.004Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1332.40", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "39.07", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
219	ALLEGRO	15155167503	5905806208443	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN	\N	5905806208443_1.jpg	\N	2025-10-09 19:31:24.056133	2025-10-11 21:32:35.307649	{"id": "69bea6b0-a534-11f0-a008-2360f331b758", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15155167503", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 ARTISAN", "external": {"id": "5905806208443"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T17:24:14.711Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
216	SHOPER	719	5905806202373	Szafka na buty VB80x30D S1 siedzisko 80cm Czarny	\N	5905806202373_1.jpg	\N	2025-10-09 19:02:00.450016	2025-10-11 21:35:22.046149	{"id": "27029", "tax": "0%", "code": "5905806202373", "name": "Szafka na buty VB80x30D S1 siedzisko 80cm Czarny", "type": "0", "unit": "szt.", "pkwiu": "", "price": "399.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23163", "quantity": "1", "stock_id": "1048", "tax_value": "0", "product_id": "719", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
223	ALLEGRO	16698543601	5905806237023	Garderoba z lustrem 90x30cm V60 Supra30 4 Panele D1N1 Dąb Wotan	\N	5905806237023_1.jpg	\N	2025-10-09 19:31:36.551395	2025-10-11 21:32:41.200799	{"id": "891abea0-a50b-11f0-9b0c-e511fc7361fa", "tax": null, "offer": {"id": "16698543601", "name": "Garderoba z lustrem 90x30cm V60 Supra30 4 Panele D1N1 Dąb Wotan", "external": {"id": "5905806237023"}, "productSet": null}, "price": {"amount": "1430.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T12:31:32.872Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1430.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "62.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
220	ALLEGRO	16271341145	5905806233391	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 WOTAN	\N	5905806233391_1.jpg	\N	2025-10-09 19:31:28.746481	2025-10-11 21:33:19.436624	{"id": "6a923310-a523-11f0-a204-f12f4b71e7fe", "tax": null, "offer": {"id": "16271341145", "name": "Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 WOTAN", "external": {"id": "5905806233391"}, "productSet": null}, "price": {"amount": "385.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T15:22:17.049Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "385.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
226	ALLEGRO	16602434150	5905806234510	Komoda Bini 50x30x82 D1N1 SONOMA	\N	\N	\N	2025-10-09 19:31:41.337269	2025-10-09 19:31:41.337269	{"id": "8c283cd0-a4f7-11f0-a444-6d64b3cc877f", "tax": null, "offer": {"id": "16602434150", "name": "Komoda Bini 50x30x82 D1N1 SONOMA", "external": {"id": "5905806234510"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T10:07:46.307Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
227	ALLEGRO	15919776759	5905806228861	Komoda Bones 60x36D1N1 SONOMA	\N	\N	\N	2025-10-09 19:31:42.890879	2025-10-09 19:31:42.890879	{"id": "24386810-a4f3-11f0-a588-b391296a673a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919776759", "name": "Komoda Bones 60x36D1N1 SONOMA", "external": {"id": "5905806228861"}, "productSet": null}, "price": {"amount": "671.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T09:35:26.392Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "671.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
225	ALLEGRO	16901480273	5905806234022	Wieszak ścienny WP60 na ubrania 60cm CZARNY WOTAN	\N	5905806234022_1.jpg	\N	2025-10-09 19:31:38.174424	2025-10-11 21:36:42.109244	{"id": "2688a331-a4ff-11f0-b9bf-2795de008363", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "16901480273", "name": "Wieszak ścienny WP60 na ubrania 60cm CZARNY WOTAN", "external": {"id": "5905806234022"}, "productSet": null}, "price": {"amount": "229.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T11:07:01.911Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "229.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
232	ALLEGRO	15321913673	5905806216943	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan	\N	5905806216943_1.jpg	\N	2025-10-09 19:32:01.342774	2025-10-11 21:31:48.437349	{"id": "63dbd690-a486-11f0-b989-75c7faccd1ca", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15321913673", "name": "Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Wotan", "external": {"id": "5905806216943"}, "productSet": null}, "price": {"amount": "1750.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T20:37:25.568Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1750.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "76.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
233	ALLEGRO	17358967427	5905806237825	Garderoba 60x36D1N1-4PAN WP szafka na buty wieszak panele Kaszmir	\N	5905806237825_1.jpg	\N	2025-10-09 19:32:02.920419	2025-10-11 21:32:07.157263	{"id": "04305191-a480-11f0-bfb1-c5232bd647f2", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "17358967427", "name": "Garderoba 60x36D1N1-4PAN WP szafka na buty wieszak panele Kaszmir", "external": {"id": "5905806237825"}, "productSet": null}, "price": {"amount": "835.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T19:51:26.263Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "835.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
231	ALLEGRO	14388158414	5905806202694	Garderoba 50x36P2WPB szafka na buty wieszak Sonoma	\N	5905806202694_1.jpg	\N	2025-10-09 19:31:59.668882	2025-10-11 21:31:58.409484	{"id": "e64932f0-a493-11f0-a471-6bb0586de370", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14388158414", "name": "Garderoba 50x36P2WPB szafka na buty wieszak Sonoma", "external": {"id": "5905806202694"}, "productSet": null}, "price": {"amount": "643.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T22:16:43.843Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "643.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
229	ALLEGRO	15876902214	5905806215175	Szafka nocna 40x36 Nox dwie szuflady schowek CZARNY	\N	5905806215175_1.jpg	\N	2025-10-09 19:31:54.962898	2025-10-11 21:36:18.058896	{"id": "55056c90-a4da-11f0-9b0c-e511fc7361fa", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15876902214", "name": "Szafka nocna 40x36 Nox dwie szuflady schowek CZARNY", "external": {"id": "5905806215175"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T06:38:48.216Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
234	ALLEGRO	16271340785	5905806233292	Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA	\N	5905806233292_1.jpg	\N	2025-10-09 19:32:17.226597	2025-10-11 21:33:18.521491	{"id": "5da1b6e0-a455-11f0-b989-75c7faccd1ca", "tax": null, "offer": {"id": "16271340785", "name": "Komoda szafka NEX 30x30 sypialnia salon przedpokój D1N1 SONOMA", "external": {"id": "5905806233292"}, "productSet": null}, "price": {"amount": "368.80", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T14:45:05.974Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "368.80", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "16.20", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
228	ALLEGRO	12224099030	5905204699249	Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma	\N	5905204699249_1.jpg	\N	2025-10-09 19:31:51.879859	2025-10-11 21:34:22.38285	{"id": "5cdbdb20-a4df-11f0-961e-6d069f850ff8", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12224099030", "name": "Szafka na buty Supra 60x30 Szafa z szufladą D1N1 Dąb Sonoma", "external": {"id": "5905204699249"}, "productSet": null}, "price": {"amount": "884.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-09T07:13:40.284Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "884.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "38.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
239	ALLEGRO	15919730348	5905806228830	Komoda Bones 60x30D1N1 SONOMA	\N	\N	\N	2025-10-09 19:34:05.149018	2025-10-09 19:34:05.149018	{"id": "bce19ae0-a431-11f0-af7e-5f793825db67", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919730348", "name": "Komoda Bones 60x30D1N1 SONOMA", "external": {"id": "5905806228830"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:30:50.598Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
235	ALLEGRO	10862932479	5905806209532	Szafka komoda na buty 80x30 D2N1 Altus BIAŁY	\N	5905806209532_1.jpg	\N	2025-10-09 19:33:55.704691	2025-10-11 21:33:57.401181	{"id": "cac93f00-a454-11f0-a471-6bb0586de370", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "10862932479", "name": "Szafka komoda na buty 80x30 D2N1 Altus BIAŁY", "external": {"id": "5905806209532"}, "productSet": null}, "price": {"amount": "532.60", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T14:41:38.668Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "532.60", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "23.40", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
241	ALLEGRO	15408455867	5905806218688	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 WOTAN BIAŁY	\N	5905806218688_1.jpg	\N	2025-10-09 19:34:06.759391	2025-10-11 21:34:21.330408	{"id": "36702f80-a431-11f0-8f13-933da22fca3d", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15408455867", "name": "Szafka na buty Supra 50x36 Szafa z szufladą D1N1 WOTAN BIAŁY", "external": {"id": "5905806218688"}, "productSet": null}, "price": {"amount": "1015.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:29:53.726Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1015.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
404	SHOPER	685	5905806202014	Szafka na buty VB60x30D1N1 WOTAN	\N	5905806202014_1.jpg	\N	2025-10-10 18:56:33.039248	2025-10-11 21:35:05.259937	{"id": "27060", "tax": "0%", "code": "5905806202014", "name": "Szafka na buty VB60x30D1N1 WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "326.00", "option": "", "weight": "0", "loyalty": null, "unit_fp": "0", "order_id": "23184", "quantity": "1", "stock_id": "1014", "tax_value": "0", "product_id": "685", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
240	ALLEGRO	16521833793	5905806227130	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1N1 WOTAN BIAŁY	\N	5905806227130_1.jpg	\N	2025-10-09 19:34:06.759391	2025-10-11 21:32:21.419426	{"id": "36702f81-a431-11f0-8f13-933da22fca3d", "tax": null, "offer": {"id": "16521833793", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 D1N1 WOTAN BIAŁY", "external": {"id": "5905806227130"}, "productSet": null}, "price": {"amount": "1319.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:29:53.726Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1319.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
238	ALLEGRO	14655550516	5905806205015	Garderoba 80x30cm SU30 VB-4PAN-WP50 D1N1 Wotan	\N	5905806205015_1.jpg	\N	2025-10-09 19:34:03.538387	2025-10-11 21:32:11.283855	{"id": "c0a51610-a432-11f0-a6cc-b3145592fdde", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "14655550516", "name": "Garderoba 80x30cm SU30 VB-4PAN-WP50 D1N1 Wotan", "external": {"id": "5905806205015"}, "productSet": null}, "price": {"amount": "1283.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T10:40:58.713Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1283.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
236	ALLEGRO	15178440255	5905806210118	Szafka komoda na buty 80x36 D2N2 Altus ARTISAN	\N	5905806210118_1.jpg	\N	2025-10-09 19:33:58.780544	2025-10-11 21:34:03.359944	{"id": "3b62aea0-a44f-11f0-88a6-1f93f938b7b3", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15178440255", "name": "Szafka komoda na buty 80x36 D2N2 Altus ARTISAN", "external": {"id": "5905806210118"}, "productSet": null}, "price": {"amount": "636.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T14:01:34.608Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "636.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
237	ALLEGRO	14384922015	5905806201871	Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY	\N	5905806201871_1.jpg	\N	2025-10-09 19:34:01.943813	2025-10-11 21:34:52.350909	{"id": "8ed915f0-a43c-11f0-96d3-f7121b08a32c", "tax": null, "offer": {"id": "14384922015", "name": "Szafka na buty VB50x36 D1N1 siedzisko schowek 50cm BIAŁY", "external": {"id": "5905806201871"}, "productSet": null}, "price": {"amount": "326.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-08T11:47:36.900Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "326.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
403	SHOPER	3651	5905806239270	Szafa Silva 80x65x207 D3N1 WOTAN	\N	5905806239270_1.jpg	\N	2025-10-10 18:56:33.039248	2025-10-11 21:33:52.056287	{"id": "27059", "tax": "23%", "code": "5905806239270", "name": "Szafa Silva 80x65x207 D3N1 WOTAN", "type": "0", "unit": "szt.", "pkwiu": "", "price": "1500.00", "option": "", "weight": "18", "loyalty": null, "unit_fp": "0", "order_id": "23184", "quantity": "1", "stock_id": "4049", "tax_value": "23", "product_id": "3651", "file_options": [], "text_options": [], "delivery_time": "5", "discount_perc": "0.0000", "warehouse_code": null, "delivery_time_hours": "120"}
245	ALLEGRO	14910130346	5905806204049	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-09 19:34:27.397521	2025-10-09 19:34:27.397521	{"id": "bd041570-a3cd-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "14910130346", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele ARTISAN", "external": {"id": "5905806204049"}, "productSet": null}, "price": {"amount": "811.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T22:37:03.666Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "811.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
247	ALLEGRO	14384985982	5905806202236	Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN	\N	\N	\N	2025-10-09 19:34:30.326811	2025-10-09 19:34:30.326811	{"id": "bb0feac0-a3c6-11f0-9d66-3d00eb1ccfed", "tax": null, "offer": {"id": "14384985982", "name": "Szafka na buty VB60x36D S1 siedzisko schowek 60cm ARTISAN", "external": {"id": "5905806202236"}, "productSet": null}, "price": {"amount": "350.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:44:05.528Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "350.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
248	ALLEGRO	16859419202	5905806210439	Półka ścienna 60x18x20cm WOTAN	\N	\N	\N	2025-10-09 19:34:31.926296	2025-10-09 19:34:31.926296	{"id": "876a7b40-a3c6-11f0-9a42-bb8e9ffafe52", "tax": null, "offer": {"id": "16859419202", "name": "Półka ścienna 60x18x20cm WOTAN", "external": {"id": "5905806210439"}, "productSet": null}, "price": {"amount": "87.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:42:42.773Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "87.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
251	ALLEGRO	16625971969	5905806222524	Siedzisko tapicerowane 80x29cm do szafki 80x30	\N	\N	\N	2025-10-09 19:34:41.444673	2025-10-09 19:34:41.444673	{"id": "7c6a6280-a3aa-11f0-a15e-754093089519", "tax": null, "offer": {"id": "16625971969", "name": "Siedzisko tapicerowane 80x29cm do szafki 80x30", "external": {"id": "5905806222524"}, "productSet": null}, "price": {"amount": "75.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T18:33:02.465Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "75.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
254	ALLEGRO	16602434536	5905806234527	Komoda Bini 50x30x82 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:34:47.681114	2025-10-09 19:34:47.681114	{"id": "14d905a1-a39f-11f0-b56d-0ba559d87e46", "tax": null, "offer": {"id": "16602434536", "name": "Komoda Bini 50x30x82 D1N1 WOTAN", "external": {"id": "5905806234527"}, "productSet": null}, "price": {"amount": "352.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T17:01:47.983Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "352.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
255	ALLEGRO	12196226645	5905806203615	Wieszak ścienny WP80 na ubrania 80cm Lancelot	\N	\N	\N	2025-10-09 19:34:49.240924	2025-10-09 19:34:49.240924	{"id": "5b983f70-a39e-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "12196226645", "name": "Wieszak ścienny WP80 na ubrania 80cm Lancelot", "external": {"id": "5905806203615"}, "productSet": null}, "price": {"amount": "278.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:55:30.772Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "278.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
252	ALLEGRO	17636751422	5905806205121	Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 SONOMA	\N	5905806205121_1.jpg	\N	2025-10-09 19:34:44.442189	2025-10-11 21:32:20.432878	{"id": "d303ecb0-a3a0-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "17636751422", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 D1 SONOMA", "external": {"id": "5905806205121"}, "productSet": null}, "price": {"amount": "1263.50", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T17:13:53.667Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1263.50", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "55.50", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
249	ALLEGRO	14383316918	5905806201758	Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały	\N	5905806201758_1.jpg	\N	2025-10-09 19:34:35.391646	2025-10-11 21:32:22.392494	{"id": "6fd785e0-a3bc-11f0-bfbd-d3aacc6a2e00", "tax": null, "offer": {"id": "14383316918", "name": "Garderoba 80x36cm SU30 VB-4PAN-WP50 N1 Czarny D1 Biały", "external": {"id": "5905806201758"}, "productSet": null}, "price": {"amount": "1263.50", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T21:11:14.096Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1263.50", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "55.50", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
246	ALLEGRO	14910130495	5905806204056	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele BIAŁY	\N	5905806204056_1.jpg	\N	2025-10-09 19:34:28.864582	2025-10-11 21:32:02.084837	{"id": "3cc896c0-a3cc-11f0-a6cc-b3145592fdde", "tax": null, "offer": {"id": "14910130495", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele BIAŁY", "external": {"id": "5905806204056"}, "productSet": null}, "price": {"amount": "811.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T22:27:10.760Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "811.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
253	ALLEGRO	12476571569	5905806213560	Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały	\N	5905806213560_1.jpg	\N	2025-10-09 19:34:46.040975	2025-10-11 21:34:14.301146	{"id": "47073e70-a39f-11f0-9468-2bd22967b382", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12476571569", "name": "Szafka na buty Supra 50x30 Szafa z szufladą D1N1 Biały", "external": {"id": "5905806213560"}, "productSet": null}, "price": {"amount": "788.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T17:04:37.686Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "788.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
256	ALLEGRO	15919728876	5905806228793	Komoda Bones 60x36D1N1 ARTISAN	\N	\N	\N	2025-10-09 19:34:50.800284	2025-10-09 19:34:50.800284	{"id": "f1c1d391-a39d-11f0-8d43-e5c6c6646cd8", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15919728876", "name": "Komoda Bones 60x36D1N1 ARTISAN", "external": {"id": "5905806228793"}, "productSet": null}, "price": {"amount": "671.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:53:45.966Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "671.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
262	ALLEGRO	14024671782	5905806201307	Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Lancelot	\N	\N	\N	2025-10-09 19:35:16.329333	2025-10-09 19:35:16.329333	{"id": "6287b490-a34f-11f0-b861-bd1e9af656a8", "tax": null, "offer": {"id": "14024671782", "name": "Szafka na buty Supra 30 słupek 30x30 D1N1 Czarny Lancelot", "external": {"id": "5905806201307"}, "productSet": null}, "price": {"amount": "532.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T07:30:28.729Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "532.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
263	ALLEGRO	15372387250	5905806217926	Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN	\N	\N	\N	2025-10-09 19:35:17.859367	2025-10-09 19:35:17.859367	{"id": "b4d359b0-a34b-11f0-87ab-43c4d16d6a38", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15372387250", "name": "Zestaw VB50x30 Tres50x30 D1N1 szafka na buty siedzisko WOTAN", "external": {"id": "5905806217926"}, "productSet": null}, "price": {"amount": "737.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T07:04:50.959Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "737.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
266	ALLEGRO	17358940752	5905806237801	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir	\N	\N	\N	2025-10-09 19:35:30.758556	2025-10-09 19:35:30.758556	{"id": "304affb0-9d63-11f0-a677-a5b8c1586284", "tax": null, "offer": {"id": "17358940752", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 Kaszmir", "external": {"id": "5905806237801"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-09-29T18:37:53.401Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
258	ALLEGRO	15221332021	5905806214130	Szafka na buty z szufladą Tres 50x36 Dąb Wotan	\N	5905806214130_1.jpg	\N	2025-10-09 19:34:56.692218	2025-10-11 21:35:51.40609	{"id": "aa3a44e0-a397-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221332021", "name": "Szafka na buty z szufladą Tres 50x36 Dąb Wotan", "external": {"id": "5905806214130"}, "productSet": null}, "price": {"amount": "447.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:08:03.409Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "447.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
259	ALLEGRO	16276325492	5905806233957	Komoda Bini 60x36D1N1 BIAŁY	\N	5905806233957_1.jpg	\N	2025-10-09 19:34:58.255169	2025-10-11 21:32:55.123724	{"id": "816e3d00-a397-11f0-9288-ef897151e2e1", "tax": null, "offer": {"id": "16276325492", "name": "Komoda Bini 60x36D1N1 BIAŁY", "external": {"id": "5905806233957"}, "productSet": null}, "price": {"amount": "462.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T16:07:07.415Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "462.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
265	ALLEGRO	16271344068	5905806233490	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN	\N	5905806233490_1.jpg	\N	2025-10-09 19:35:23.030281	2025-10-11 21:33:22.332347	{"id": "a6f1c6b0-a341-11f0-9a42-bb8e9ffafe52", "tax": null, "offer": {"id": "16271344068", "name": "Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 WOTAN", "external": {"id": "5905806233490"}, "productSet": null}, "price": {"amount": "418.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T05:52:04.196Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "418.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
261	ALLEGRO	12263585961	5905204699218	Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Dąb Sonoma	\N	5905204699218_1.jpg	\N	2025-10-09 19:35:13.347269	2025-10-11 21:34:25.393801	{"id": "88af56c1-a357-11f0-bc71-87ddccc94446", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12263585961", "name": "Szafka na buty Supra 60x36 Szafa z szufladą D1N1 Dąb Sonoma", "external": {"id": "5905204699218"}, "productSet": null}, "price": {"amount": "1052.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T08:28:26.205Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1052.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
264	ALLEGRO	13854397976	5905204699997	Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN	\N	5905204699997_1.jpg	\N	2025-10-09 19:35:19.36659	2025-10-11 21:34:46.366781	{"id": "a6a3fb32-a349-11f0-9d2c-bd0fd501dc68", "tax": null, "offer": {"id": "13854397976", "name": "Szafka na buty VB50x30 D1N1 siedzisko schowek DĄB ARTISAN", "external": {"id": "5905204699997"}, "productSet": null}, "price": {"amount": "314.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T06:49:07.597Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "314.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
260	ALLEGRO	16415944014	5905806231885	Szafka na buty VB100x30D2N1 ARTISAN	\N	5905806231885_1.jpg	\N	2025-10-09 19:34:59.752861	2025-10-11 21:34:38.177202	{"id": "8a81ae80-a393-11f0-bc71-87ddccc94446", "tax": null, "offer": {"id": "16415944014", "name": "Szafka na buty VB100x30D2N1 ARTISAN", "external": {"id": "5905806231885"}, "productSet": null}, "price": {"amount": "556.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-07T15:43:37.315Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "556.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
269	ALLEGRO	11742813479	5905806204025	Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele SONOMA	\N	\N	\N	2025-10-09 19:52:38.260123	2025-10-09 19:52:38.260123	{"id": "2ebd6e83-a05b-11f0-819e-1344c439828f", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "11742813479", "name": "Garderoba 60x30D1N1-4PAN szafka na buty wieszak panele SONOMA", "external": {"id": "5905806204025"}, "productSet": null}, "price": {"amount": "776.80", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "776.80", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "34.20", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
270	ALLEGRO	15446678390	5905806219623	Szafka na buty 60x30D2N1Supra SONOMA	\N	\N	\N	2025-10-09 19:52:38.260123	2025-10-09 19:52:38.260123	{"id": "2ebd6e81-a05b-11f0-819e-1344c439828f", "tax": null, "offer": {"id": "15446678390", "name": "Szafka na buty 60x30D2N1Supra SONOMA", "external": {"id": "5905806219623"}, "productSet": null}, "price": {"amount": "1105.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1105.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
274	ALLEGRO	15229738794	5905806214574	Szafka na buty z szufladą Tres 100x36D1N1 WOTAN	\N	\N	\N	2025-10-09 19:52:48.527521	2025-10-09 19:52:48.527521	{"id": "029505f0-a03f-11f0-bc5e-258a5e1e619a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15229738794", "name": "Szafka na buty z szufladą Tres 100x36D1N1 WOTAN", "external": {"id": "5905806214574"}, "productSet": null}, "price": {"amount": "611.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T10:04:06.189Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "611.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
267	ALLEGRO	15112696167	5905806208566	Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Biały	\N	5905806208566_1.jpg	\N	2025-10-09 19:52:33.022688	2025-10-11 08:59:00.75771	{"id": "2f4df840-a067-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112696167", "name": "Zestaw szafka na buty siedzisko VB60x36 Tres60 z szufladą Biały", "external": {"id": "5905806208566"}, "productSet": null}, "price": {"amount": "793.10", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T14:45:19.720Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "793.10", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "34.90", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
268	ALLEGRO	12258788829	5905806216936	Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Sonoma	\N	5905806216936_1.jpg	\N	2025-10-09 19:52:38.260123	2025-10-11 21:31:47.438886	{"id": "2ebd6e82-a05b-11f0-819e-1344c439828f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12258788829", "name": "Garderoba 120x30cm SU60-VB60-4PAN-WP60 D1 N1 Dąb Sonoma", "external": {"id": "5905806216936"}, "productSet": null}, "price": {"amount": "1827.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1827.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
276	ALLEGRO	16644957145	5905806204179	Garderoba 90x30cm D1N1 V60 Supra30 4 Panele WOTAN	\N	5905806204179_1.jpg	\N	2025-10-09 19:52:53.294006	2025-10-11 21:32:29.362394	{"id": "c967f380-a031-11f0-8e98-fdfd51e10ba4", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "16644957145", "name": "Garderoba 90x30cm D1N1 V60 Supra30 4 Panele WOTAN", "external": {"id": "5905806204179"}, "productSet": null}, "price": {"amount": "1343.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T08:22:15.599Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1343.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
271	ALLEGRO	15221504597	5905806214253	Szafka na buty z szufladą Tres 80x36 Dąb Wotan	\N	5905806214253_1.jpg	\N	2025-10-09 19:52:38.260123	2025-10-11 21:36:07.165134	{"id": "2ebd6e80-a05b-11f0-819e-1344c439828f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15221504597", "name": "Szafka na buty z szufladą Tres 80x36 Dąb Wotan", "external": {"id": "5905806214253"}, "productSet": null}, "price": {"amount": "600.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T13:17:15.222Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "600.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
273	ALLEGRO	16383693560	5905806234046	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój BIAŁY	\N	5905806234046_1.jpg	\N	2025-10-09 19:52:45.217892	2025-10-11 21:33:24.351556	{"id": "19cc45c1-a054-11f0-b871-03a75625f948", "tax": null, "offer": {"id": "16383693560", "name": "Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój BIAŁY", "external": {"id": "5905806234046"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T12:28:28.373Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
275	ALLEGRO	15410023447	5905806218879	Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan	\N	5905806218879_1.jpg	\N	2025-10-09 19:52:50.096528	2025-10-11 21:34:29.351374	{"id": "b369bb00-a03f-11f0-8737-b36df7580750", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15410023447", "name": "Szafka na buty Supra 80x36 Szafa z szufladą D1N1 Dąb Artisan", "external": {"id": "5905806218879"}, "productSet": null}, "price": {"amount": "1123.60", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-03T10:00:22.614Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "CAMPAIGN"}], "originalPrice": {"amount": "1123.60", "currency": "PLN"}, "reconciliation": {"type": "BILLING", "value": {"amount": "49.40", "currency": "PLN"}, "quantity": 1}, "selectedAdditionalServices": []}
277	ALLEGRO	15440332407	5905806218176	Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko ARTISAN	\N	\N	\N	2025-10-09 19:52:59.565071	2025-10-09 19:52:59.565071	{"id": "8396a950-9fc8-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15440332407", "name": "Zestaw VB80x36 Tres80x36 D1N1 szafka na buty siedzisko ARTISAN", "external": {"id": "5905806218176"}, "productSet": null}, "price": {"amount": "1023.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T19:47:53.396Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1023.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
280	ALLEGRO	16276327427	5905806233995	Komoda Bini 60x36D1N1 SONOMA	\N	\N	\N	2025-10-09 19:53:06.305605	2025-10-09 19:53:06.305605	{"id": "424b1740-9fc0-11f0-8509-57e61af36c1f", "tax": null, "offer": {"id": "16276327427", "name": "Komoda Bini 60x36D1N1 SONOMA", "external": {"id": "5905806233995"}, "productSet": null}, "price": {"amount": "462.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T18:48:09.646Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "462.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
282	ALLEGRO	16602441323	5905806234770	Komoda Bini 100x36 D1N1 WOTAN	\N	\N	\N	2025-10-09 19:53:15.422578	2025-10-09 19:53:15.422578	{"id": "e18d9d21-9fa5-11f0-ad8a-5d9c081a41b2", "tax": null, "offer": {"id": "16602441323", "name": "Komoda Bini 100x36 D1N1 WOTAN", "external": {"id": "5905806234770"}, "productSet": null}, "price": {"amount": "682.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T15:39:26.910Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "682.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
283	ALLEGRO	15440329487	5905806217995	Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko SONOMA	\N	\N	\N	2025-10-09 19:53:20.219267	2025-10-09 19:53:20.219267	{"id": "ed23c610-9f9a-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15440329487", "name": "Zestaw VB50x36 Tres50x36 D1N1 szafka na buty siedzisko SONOMA", "external": {"id": "5905806217995"}, "productSet": null}, "price": {"amount": "773.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T14:23:26.503Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "773.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
278	ALLEGRO	15315961595	5905806214673	Szafka na buty z szufladą Tres 100x30D1N1 BIAŁY	\N	5905806214673_1.jpg	\N	2025-10-09 19:53:01.402189	2025-10-11 21:35:36.232307	{"id": "707e9ea0-9fc7-11f0-9d66-3d00eb1ccfed", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15315961595", "name": "Szafka na buty z szufladą Tres 100x30D1N1 BIAŁY", "external": {"id": "5905806214673"}, "productSet": null}, "price": {"amount": "587.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T19:40:08.911Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "587.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
284	ALLEGRO	15251019919	5905806204162	Garderoba 90x36cm V60 Supra30 4 Panele D1N1 WOTAN	\N	5905806204162_1.jpg	\N	2025-10-09 19:53:21.859258	2025-10-11 21:32:39.272195	{"id": "c0e5a1e1-9f9a-11f0-8509-57e61af36c1f", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15251019919", "name": "Garderoba 90x36cm V60 Supra30 4 Panele D1N1 WOTAN", "external": {"id": "5905806204162"}, "productSet": null}, "price": {"amount": "1391.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T14:20:28.097Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1391.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
285	ALLEGRO	16383698094	5905806234084	Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój CZARNY	\N	5905806234084_1.jpg	\N	2025-10-09 19:53:26.561265	2025-10-11 21:33:25.470701	{"id": "2200c8d0-9f67-11f0-a6ba-19e7472c74e3", "tax": null, "offer": {"id": "16383698094", "name": "Komoda szafka NEX 60x30x124 D1N1 sypialnia salon przedpokój CZARNY", "external": {"id": "5905806234084"}, "productSet": null}, "price": {"amount": "638.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T08:11:20.907Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "638.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
286	ALLEGRO	15134391509	5905806209372	Szafka 60x30D1N2 komoda wysoka Supra T2 BIAŁY CZARNY	\N	5905806209372_1.jpg	\N	2025-10-09 19:53:28.085804	2025-10-11 21:33:53.151184	{"id": "affef3c0-9f65-11f0-8234-ff8a51029ee2", "tax": null, "offer": {"id": "15134391509", "name": "Szafka 60x30D1N2 komoda wysoka Supra T2 BIAŁY CZARNY", "external": {"id": "5905806209372"}, "productSet": null}, "price": {"amount": "1016.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T08:01:02.229Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1016.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
281	ALLEGRO	12476571893	5905204699492	Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Biały	\N	5905204699492_1.jpg	\N	2025-10-09 19:53:10.853809	2025-10-11 21:34:17.380538	{"id": "c8c357e0-9fa9-11f0-9a42-bb8e9ffafe52", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12476571893", "name": "Szafka na buty Supra 50x36 Szafa z szufladą D1N1 Biały", "external": {"id": "5905204699492"}, "productSet": null}, "price": {"amount": "1015.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T16:07:49.871Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1015.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
279	ALLEGRO	10945431249	5905806208191	Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały	\N	5905806208191_1.jpg	\N	2025-10-09 19:53:02.963613	2025-10-11 21:34:50.262802	{"id": "a241d610-9fc6-11f0-8c53-b9e6d89e658e", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "10945431249", "name": "Szafka na buty VB50x30D2N1 siedzisko schowek 50cm Biały", "external": {"id": "5905806208191"}, "productSet": null}, "price": {"amount": "332.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-02T19:35:20.332Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "332.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
291	ALLEGRO	15258837181	5905806211023	Wieszak ścienny W60 na ubrania 60cm LANCELOT	\N	\N	\N	2025-10-09 19:53:54.029929	2025-10-09 19:53:54.029929	{"id": "099509a1-9eef-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "15258837181", "name": "Wieszak ścienny W60 na ubrania 60cm LANCELOT", "external": {"id": "5905806211023"}, "productSet": null}, "price": {"amount": "193.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:51:37.691Z", "quantity": 1, "vouchers": [], "discounts": [{"type": "BUNDLE"}], "originalPrice": {"amount": "193.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
298	ALLEGRO	16760747405	5905806236156	Garderoba 80x36D1N2 4PAN szafka na buty wieszak panele ARTISAN	\N	\N	\N	2025-10-09 19:54:30.841405	2025-10-09 19:54:30.841405	{"id": "d41854a0-9e97-11f0-8996-07b46275101a", "tax": null, "offer": {"id": "16760747405", "name": "Garderoba 80x36D1N2 4PAN szafka na buty wieszak panele ARTISAN", "external": {"id": "5905806236156"}, "productSet": null}, "price": {"amount": "1045.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T07:30:40.068Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1045.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
294	ALLEGRO	17478159653	5905806238679	Zestaw Tres60x36D1N1 3PAN WP60 KASZMIR	\N	5905806238679_1.jpg	\N	2025-10-09 19:54:01.930469	2025-10-11 08:58:41.956736	{"id": "741a7c30-9ed9-11f0-b465-492415e4339b", "tax": null, "offer": {"id": "17478159653", "name": "Zestaw Tres60x36D1N1 3PAN WP60 KASZMIR", "external": {"id": "5905806238679"}, "productSet": null}, "price": {"amount": "857.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T15:18:19.500Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "857.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
297	ALLEGRO	15112614579	5905806208504	Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Wotan	\N	5905806208504_1.jpg	\N	2025-10-09 19:54:26.194085	2025-10-11 08:58:57.15746	{"id": "778e3940-9ea4-11f0-8996-07b46275101a", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "15112614579", "name": "Zestaw szafka na buty siedzisko VB60x30 D1N1 Tres60 z szufladą Dąb Wotan", "external": {"id": "5905806208504"}, "productSet": null}, "price": {"amount": "780.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T08:58:07.596Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "780.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
292	ALLEGRO	11769341228	5905806208412	Panel ścienny tapicerowany pan1x80x30	\N	5905806208412_1.jpg	\N	2025-10-09 19:53:55.625141	2025-10-11 21:33:39.335332	{"id": "d9e03540-9eee-11f0-b465-492415e4339b", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "11769341228", "name": "Panel ścienny tapicerowany pan1x80x30", "external": {"id": "5905806208412"}, "productSet": null}, "price": {"amount": "75.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T17:48:50.373Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "75.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
295	ALLEGRO	11873257937	5905806208351	Szafka na buty z szufladą Tres 60x36 Dąb Sonoma	\N	5905806208351_1.jpg	\N	2025-10-09 19:54:06.564881	2025-10-11 21:35:59.374759	{"id": "10a4f6e0-9ed3-11f0-a0f2-ad990a13a62d", "tax": {"rate": "23.00", "subject": "GOODS", "exemption": null}, "offer": {"id": "11873257937", "name": "Szafka na buty z szufladą Tres 60x36 Dąb Sonoma", "external": {"id": "5905806208351"}, "productSet": null}, "price": {"amount": "434.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T14:31:13.809Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "434.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
288	ALLEGRO	12487657175	5905204699614	Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY	\N	5905204699614_1.jpg	\N	2025-10-09 19:53:40.214695	2025-10-11 21:32:24.199575	{"id": "533d46b0-9efb-11f0-9e10-59ae2eaec9de", "tax": {"rate": "23.00", "subject": null, "exemption": null}, "offer": {"id": "12487657175", "name": "Garderoba 80x36cm V50 Supra30 4 Panele D1 BIAŁY", "external": {"id": "5905204699614"}, "productSet": null}, "price": {"amount": "1319.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T19:19:10.157Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "1319.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
296	ALLEGRO	16271343737	5905806233476	Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 LANCELOT	\N	5905806233476_1.jpg	\N	2025-10-09 19:54:14.234736	2025-10-11 21:33:21.343271	{"id": "ab724b80-9ebc-11f0-96ea-bf4f56b08af2", "tax": null, "offer": {"id": "16271343737", "name": "Komoda szafka NEX 30x36 sypialnia salon przedpokój D1N1 LANCELOT", "external": {"id": "5905806233476"}, "productSet": null}, "price": {"amount": "418.00", "currency": "PLN"}, "deposit": null, "boughtAt": "2025-10-01T11:49:39.791Z", "quantity": 1, "vouchers": [], "discounts": null, "originalPrice": {"amount": "418.00", "currency": "PLN"}, "reconciliation": null, "selectedAdditionalServices": []}
290	ALLEGRO	12405971238	5905204699140	Szafka na buty Supra 80x30 Szafa z szufladą D1N1 Biały	\N	