import logging

_logger = logging.getLogger(__name__)


# noinspection SqlWithoutWhere
def migrate(cr, version):
    _logger.info(f'end migration start (from {version})')

    # update partners
    _logger.info('remove ref for partners')

    cr.execute(
        """
        SELECT id from res_partner p
        WHERE p.name = 'None None' AND ref IS NOT NULL
            OR EXISTS (
                SELECT 1
                FROM res_partner parent
                WHERE parent.id = p.parent_id AND parent.name = %s
            )
        """,
        ('None None',),
    )

    if partner_ids := [row[0] for row in cr.fetchall()]:
        _logger.info('update partners')

        cr.execute('UPDATE res_partner SET ref = NULL WHERE id = ANY(%s)', (partner_ids,))

    _logger.info('end migration finished')
