import logging

_logger = logging.getLogger(__name__)


def migrate(cr, version):
    """
    Rename the field to store the x_allegro_id data
    """

    _logger.info(f'pre migration start (from {version})')

    cr.execute(
        """SELECT true FROM information_schema.columns
     WHERE table_name='res_partner' AND column_name='allegro_id'"""
    )

    if cr.dictfetchone():
        cr.execute('ALTER TABLE res_partner RENAME COLUMN allegro_id TO x_allegro_id')

    _logger.info('pre migration finished')
