-- disable allegro
DO
$$
    DECLARE
        do_neutralize BOOLEAN;
        updated_count INTEGER;

    BEGIN
        do_neutralize := FALSE;

        SELECT TRUE INTO do_neutralize
            FROM information_schema.tables
            WHERE table_schema = 'public' AND table_name = 'trilab_market_account'
            LIMIT 1;

        IF do_neutralize THEN
            do_neutralize := FALSE;

            SELECT TRUE INTO do_neutralize
                FROM information_schema.columns
                WHERE table_name = 'trilab_market_account' AND column_name = 'allegro_access_token'
                LIMIT 1;
        END IF;

        IF do_neutralize THEN
            UPDATE trilab_market_account
                SET allegro_access_token          = NULL,
                    allegro_access_token_validity = NULL,
                    allegro_refresh_token         = NULL,
                    allegro_environment           = 'sandbox',
                    state                         = 'draft',
                    active                        = false
                WHERE market = 'allegro';

            GET DIAGNOSTICS updated_count = ROW_COUNT;

            RAISE NOTICE 'neutralized % allegro account(s)', updated_count;

        ELSE

            RAISE WARNING 'skip allegro accounts missing tables/fields/records';
        END IF;
    END
$$;

-- changing application keys for the test environment to avoid the refresh token issue

UPDATE ir_config_parameter
SET value = '632c7e562fd848bfb4c6cc41c079989b'
WHERE key = 'allegro_client_id_prod';

UPDATE ir_config_parameter
SET value = 'P9xTtjxanaXLAJGm3joj6yudao9YzRkSfAkeuQG8kk0vHwywKwsAaM9TpedalcL0'
WHERE key = 'allegro_client_secret_prod';
